package sdk

/*
	Source: https://github.com/skelsec/pysecur3/blob/master/pysecur3/MCP.py

	PING              = 0
	ERROR             = 1
	GET_MAC           = 2
	SET_VALUE         = 3
	GET_VALUE         = 4
	DEBUG             = 5
	JMCP              = 6
	GET_GW_VERSION    = 7

	LOGIN             = 16
	LOGOUT            = 17

	GET_USER_IDS      = 32
	GET_USER_NAME     = 33
	ADD_USER          = 34
	CHANGE_PASSWD     = 35
	REMOVE_USER       = 36
	SET_USER_RIGHTS   = 37
	GET_NAME          = 38
	SET_NAME          = 39
	GET_USER_RIGHTS   = 40
	ADD_PORT          = 41
	ADD_GROUP         = 42
	REMOVE_GROUP      = 43
	SET_GROUP_NAME    = 44
	GET_GROUP_NAME    = 45
	SET_GROUPED_PORTS = 46
	GET_GROUPED_PORTS = 47
	GET_PORTS         = 48
	GET_TYPE          = 49
	GET_STATE         = 50
	SET_STATE         = 51
	GET_PORT_NAME     = 52
	SET_PORT_NAME     = 53
	SET_TYPE          = 54

	GET_GROUP_IDS     = 64
	INHERIT_PORT      = 65
	REMOVE_PORT       = 66

	SET_SSL           = 80
	SCAN_WIFI         = 81
	WIFI_FOUND        = 82
	GET_WIFI_STATE    = 83
	HM_GET_TRANSITION = 112


	CHANGE_USER_NAME  = 67
	CHANGE_USER_NAME_OF_USER  = 68
	CHANGE_PASSWORD_OF_USER   = 69
*/

const (
	RESPONSE_MASK = 0x80

	COMMANDID_PING              = 0x00
	COMMANDID_ERROR             = 0x01
	COMMANDID_GET_MAC           = 0x02
	COMMANDID_JMCP              = 0x06
	COMMANDID_LOGIN             = 0x10
	COMMANDID_LOGOUT            = 0x11
	COMMANDID_GET_NAME          = 0x26
	COMMANDID_SET_STATE         = 0x33
	COMMANDID_HM_GET_TRANSITION = 0x70

	COMMANDID_GET_USER_IDS    = 32
	COMMANDID_GET_USER_NAME   = 33
	COMMANDID_ADD_USER        = 0x22
	COMMANDID_CHANGE_PASSWD   = 0x45 // Original value: 0x23 == 35
	COMMANDID_REMOVE_USER     = 0x24
	COMMANDID_SET_USER_RIGHTS = 0x25
	COMMANDID_GET_USER_RIGHTS = 0x28

	COMMANDID_PING_RESPONSE     = COMMANDID_PING | RESPONSE_MASK
	COMMANDID_GET_MAC_RESPONSE  = COMMANDID_GET_MAC | RESPONSE_MASK
	COMMANDID_JMCP_RESPONSE     = COMMANDID_JMCP | RESPONSE_MASK
	COMMANDID_LOGIN_RESPONSE    = COMMANDID_LOGIN | RESPONSE_MASK
	COMMANDID_LOGOUT_RESPONSE   = COMMANDID_LOGOUT | RESPONSE_MASK
	COMMANDID_GET_NAME_RESPONSE = COMMANDID_GET_NAME | RESPONSE_MASK
	//COMMANDID_SET_STATE_RESPONSE         = COMMANDID_SET_STATE | RESPONSE_MASK
	COMMANDID_HM_GET_TRANSITION_RESPONSE = COMMANDID_HM_GET_TRANSITION | RESPONSE_MASK
	COMMANDID_GET_USER_IDS_RESPONSE      = COMMANDID_GET_USER_IDS | RESPONSE_MASK
	COMMANDID_GET_USER_NAME_RESPONSE     = COMMANDID_GET_USER_NAME | RESPONSE_MASK
	COMMANDID_ADD_USER_RESPONSE          = COMMANDID_ADD_USER | RESPONSE_MASK
	COMMANDID_CHANGE_PASSWD_RESPONSE     = COMMANDID_CHANGE_PASSWD | RESPONSE_MASK
	COMMANDID_REMOVE_USER_RESPONSE       = COMMANDID_REMOVE_USER | RESPONSE_MASK
	COMMANDID_SET_USER_RIGHTS_RESPONSE   = COMMANDID_SET_USER_RIGHTS | RESPONSE_MASK
	COMMANDID_GET_USER_RIGHTS_RESPONSE   = COMMANDID_GET_USER_RIGHTS | RESPONSE_MASK

	PORT_TYPE_NONE       = 0
	PORT_TYPE_IMPULS     = 1
	PORT_TYPE_AUTO_CLOSE = 2
	PORT_TYPE_ON_OFF     = 3
	PORT_TYPE_UP         = 4
	PORT_TYPE_DOWN       = 5
	PORT_TYPE_HALF       = 6
	PORT_TYPE_WALK       = 7
	PORT_TYPE_LIGHT      = 8
	PORT_TYPE_ON         = 9
	PORT_TYPE_OFF        = 10
	PORT_TYPE_LOCK       = 11
	PORT_TYPE_UNLOCK     = 12
	PORT_TYPE_OPEN_DOOR  = 13
	PORT_TYPE_LIFT       = 14
	PORT_TYPE_SINK       = 15
)
