import { includes } from 'lodash'
import ruleError from './ruleError'

// Tags that have no associated components but are allowed even so
const componentLessTags = ['mj-all', 'mj-class']

export default function validateTag(element, { components }) {
  const { tagName } = element

  if (includes(componentLessTags, tagName)) return null

  const Component = components[tagName]

  if (!Component) {
    return ruleError(
      `Element ${tagName} doesn't exist or is not registered`,
      element,
    )
  }

  return null
}
