from mongoengine import Document, IntField, StringField
from django.conf import settings

from crits.core.crits_mongoengine import CritsDocument, CritsSchemaDocument


class Exploit(CritsDocument, CritsSchemaDocument, Document):
    """
    Exploit class.
    """

    meta = {
        "crits_type": "Exploit",
        "collection": settings.COL_EXPLOIT_DETAILS,
        "latest_schema_version": 1,
        "schema_doc": {
            'name': 'The CVE of the exploit',
            'active': 'Enabled in the UI (on/off)',
            'sample_count': ('Number of samples with this backdoor. Added by'
                             ' MapReduce')
        }
    }

    name = StringField()
    #TODO: this could be a boolean field if we migrate
    active = StringField(default="on")
    sample_count = IntField(default=0)

    def increment_count(self):
        """
        Increment count of exploits in CRITs.
        """

        self.sample_count += 1

    def decrement_count(self):
        """
        Decrement count of exploits in CRITs.
        """

        self.sample_count -= 1
