<p align="center"><img src="../../static/logo-small.png" alt="MarkText" width="100" height="100"></p>

<h1 align="center">MarkText</h1>

<div align="center">
  <a href="https://twitter.com/intent/tweet?via=marktextme&url=https://github.com/marktext/marktext/&text=What%20do%20you%20want%20to%20say%20to%20app?&hashtags=happyMarkText">
    <img src="https://img.shields.io/twitter/url/https/github.com/marktext/marktext.svg?style=for-the-badge" alt="twitter">
  </a>
</div>
<div align="center">
  <strong>:high_brightness: 下一代 Markdown 编辑器 :crescent_moon:</strong><br>
  一个简单优雅的开源 Markdown 编辑器，专注于速度和可用性。<br>
  <sub>可用于 Linux、macOS 和 Windows。</sub>
</div>

<br>

<div align="center">
  <!-- Version -->
  <a href="https://marktext.github.io/website">
    <img src="https://badge.fury.io/gh/jocs%2Fmarktext.svg" alt="website">
  </a>
  <!-- License -->
  <a href="LICENSE">
    <img src="https://img.shields.io/github/license/marktext/marktext.svg" alt="LICENSE">
  </a>
  <!-- Build Status -->
  <a href="https://travis-ci.org/marktext/marktext/">
    <img src="https://travis-ci.org/marktext/marktext.svg?branch=master" alt="build">
  </a>
  <a href="https://ci.appveyor.com/project/marktext/marktext/branch/master">
    <img src="https://ci.appveyor.com/api/projects/status/l4gxgydj0i95hmxg/branch/master?svg=true" alt="build">
  </a>
  <!-- Downloads total -->
  <a href="https://github.com/marktext/marktext/releases">
    <img src="https://img.shields.io/github/downloads/marktext/marktext/total.svg" alt="total download">
  </a>
  <!-- Downloads latest release -->
  <a href="https://github.com/marktext/marktext/releases/latest">
    <img src="https://img.shields.io/github/downloads/marktext/marktext/v0.16.3/total.svg" alt="latest download">
  </a>
  <!-- sponsors -->
  <a href="https://opencollective.com/marktext">
    <img src="https://opencollective.com/marktext/tiers/silver-sponsors/badge.svg?label=SilverSponsors&color=brightgreen" alt="sponsors">
  </a>
</div>

<div align="center">
  <h3>
    <a href="https://marktext.app">
      网站
    </a>
    <span> | </span>
    <a href="https://github.com/marktext/marktext#features">
      特性
    </a>
    <span> | </span>
    <a href="https://github.com/marktext/marktext#download-and-installation">
      下载
    </a>
    <span> | </span>
    <a href="https://github.com/marktext/marktext#development">
      开发
    </a>
    <span> | </span>
    <a href="https://github.com/marktext/marktext#contribution">
      贡献
    </a>
  </h3>
</div>

<div align="center">
  <sub>翻译：</sub>
  <a href="zh_cn.md#readme">
    <span>:cn:</span>
  </a>
  <a href="zh_tw.md#readme">
    <span>:taiwan:</span>
  </a>
  <a href="pl.md#readme">
    <span>:poland:</span>
  </a>
  <a href="ja.md#readme">
    <span>:jp:</span>
  </a>
  <a href="french.md#readme">
    <span>:fr:</span>
  </a>
  <a href="tr.md#readme">
    <span>:tr:</span>
  </a>
  <a href="spanish.md#readme">
    <span>:es:</span>
  </a>
  <a href="pt.md#readme">
    <span>:portugal:</span>
  </a>
  <a href="ko.md#readme">
    <span>:kr:</span>
  </a>
</div>

<div align="center">
  <sub>这款 Markdown 编辑器由
    <a href="https://github.com/Jocs">Jocs</a> 和
    <a href="https://github.com/marktext/marktext/graphs/contributors">
      贡献者们
    </a>
  以 ❤︎ 打造</sub>
</div>

<br />

<h2 align="center">支持 MarkText</h2>

MarkText 是一个使用 MIT license 的开源项目，您将一直能够从 GitHub release 页面免费下载最新版本。MarkText 仍然在开发中，它的发展离不开所有赞助者，希望您能加入他们的行列：

- [在 Patreon 上成为支持者或赞助者](https://www.patreon.com/ranluo) 或 [一次性捐赠](https://github.com/Jocs/sponsor.me)
- [在 Open Collective 上成为支持者或赞助者](https://opencollective.com/marktext)

##### Patreon 和 OpenCollective 有什么不同？

在 Patreon 赞助：资金将直接赞助给创建并继续维护 MarkText 的 Luo Ran (@jocs)。
在 Open Collective 赞助：所有费用都是透明的，这些赞助资金将用于 MarkText 的开发、维护、在线和离线活动以及一些必要的资源。
所有赞助者（无论是在 Patreon 还是 Open Collective）的姓名或公司徽标将出现在 MarkText 的官方网站和 README.md 文件中。

**特别赞助者**

<a href="https://www.dogedoge.com/">
 <img src="https://www.dogedoge.com/assets/new_logo.min.png" width="100" height="100">
</a>

**白金赞助者**

<a href="https://opencollective.com/marktext#platinum-sponsors">
 <img src="https://opencollective.com/marktext/tiers/platinum-sponsors.svg?avatarHeight=36&width=600">
</a>

**黄金赞助者**

<a href="https://opencollective.com/marktext#platinum-sponsors">
  <img src="https://opencollective.com/marktext/tiers/gold-sponsors.svg?avatarHeight=36&width=600">
</a>

**银牌赞助者**

<a href="https://opencollective.com/marktext#platinum-sponsors">
  <img src="https://opencollective.com/marktext/tiers/silver-sponsors.svg?avatarHeight=36&width=600">
</a>

**青铜赞助者**

<a href="https://opencollective.com/marktext#platinum-sponsors">
  <img src="https://opencollective.com/marktext/tiers/bronze-sponsors.svg?avatarHeight=36&width=600">
</a>

**支持者**

<a href="https://opencollective.com/marktext#backers">
  <img src="https://opencollective.com/marktext/tiers/backer.svg?avatarHeight=36&width=600">
</a>

## 截图

![](../../docs/marktext.png?raw=true)

### 特性

- 实时预览（所见即所得）和简洁明了的界面，使您获得无干扰的写作体验。
- 支持 [CommonMark 规范](https://spec.commonmark.org/0.29/)和 [GitHub Flavored Markdown 规范](https://github.github.com/gfm/)。
- Markdown扩展，例如数学表达式（KaTeX）、front matter 和 emoji。
- 支持段落和内联样式快捷方式，以提高您的写作效率。
- 输出 **HTML** 和 **PDF** 文件。
- 各种主题：**Cadmium Light**、**Material Dark** 等等。
- 各种编辑模式：**源代码模式**、**打字机模式**、**专注模式**。
- 直接从剪贴板中粘贴图片。

<h4 align="center">:crescent_moon: 主题 :high_brightness:</h4>

| Cadmium Light                                     | Dark                                            |
|:-------------------------------------------------:|:-----------------------------------------------:|
| ![](../../docs/themeImages/cadmium-light.png?raw=true)  | ![](../../docs/themeImages/dark.png?raw=true)         |
| Graphite Light                                    | Material Dark                                   |
| ![](../../docs/themeImages/graphite-light.png?raw=true) | ![](../../docs/themeImages/materal-dark.png?raw=true) |
| Ulysses Light                                     | One Dark                                        |
| ![](../../docs/themeImages/ulysses-light.png?raw=true)  | ![](../../docs/themeImages/one-dark.png?raw=true)     |

<h4 align="center">:smile_cat: 编辑模式 :dog:</h4>

| 源代码          | 打字机               | 专注               |
|:--------------------:|:------------------------:|:-------------------:|
| ![](../../docs/source.gif) | ![](../../docs/typewriter.gif) | ![](../../docs/focus.gif) |

## 为什么要编写一个编辑器？

1. 我爱写作。我曾经使用过很多 Markdown 编辑器，但还没有一个编辑器可以完全满足我的需求。我不喜欢当我写一些难以忍受的错误时会被打扰。**MarkText** 使用 virtual DOM 来渲染页面，具有高效和开源的附加优势。这样，任何喜欢 Markdown 和写作的人都可以使用 MarkText。
2. 如上所述，**MarkText** 是完全自由开源的，并且将永远是开源的。我们希望所有 Markdown 爱好者都可以贡献自己的代码，并帮助将 **MarkText** 开发为流行的 Markdown 编辑器。
3. Markdown 编辑器很多，各有优点，有一些拥有独特的特性。我们很难满足每个 Markdown 用户的需求，但是我们希望 **MarkText** 能够尽可能满足每个 Markdown 用户的需求。尽管最新的 **MarkText** 仍不完美，但我们将尽力使它尽可能地完善。

## 下载和安装

![platform](https://img.shields.io/static/v1.svg?label=Platform&message=Linux-64%20|%20macOS-64%20|%20Win-32%20|%20Win-64&style=for-the-badge)

| ![](https://raw.githubusercontent.com/wiki/ryanoasis/nerd-fonts/screenshots/v1.0.x/mac-pass-sm.png)                                                                                                  | ![](https://raw.githubusercontent.com/wiki/ryanoasis/nerd-fonts/screenshots/v1.0.x/windows-pass-sm.png)                                                                                                          | ![](https://raw.githubusercontent.com/wiki/ryanoasis/nerd-fonts/screenshots/v1.0.x/linux-pass-sm.png)                                                                                                                        |
|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
| [![latest version](https://img.shields.io/github/downloads/marktext/marktext/latest/marktext.dmg.svg)](https://github.com/marktext/marktext/releases/download/v0.16.3/marktext.dmg) | [![latest version](https://img.shields.io/github/downloads/marktext/marktext/latest/marktext-setup.exe.svg)](https://github.com/marktext/marktext/releases/download/v0.16.3/marktext-setup.exe) | [![latest version](https://img.shields.io/github/downloads/marktext/marktext/latest/marktext-x86_64.AppImage.svg)](https://github.com/marktext/marktext/releases/download/v0.16.3/marktext-x86_64.AppImage) |

想要看看最新版本有什么新特性？请参阅[更新日志](.github/CHANGELOG.md)。

#### macOS

您可以从 [release 页面](https://github.com/marktext/marktext/releases/latest)下载最新的 `marktext-%version%.dmg` 或者使用 [**homebrew cask**](https://github.com/caskroom/homebrew-cask) 安装 MarkText。要使用 Homebrew-Cask，您只需要安装 [Homebrew](https://brew.sh/)。

```bash
brew install --cask mark-text
```

#### Windows

要想安装 MarkText，只需下载并运行安装向导（`marktext-setup-％version％.exe`），然后选择为本用户安装还是为本计算机所有用户安装。

或者，也可以使用 Chocolatey 或 Winget 等软件包管理器来安装 MarkText。

  - 使用 Chocolatey 前需要安装好 [Chocolatey](https://chocolatey.org/install)。
  
  ```bash
  choco install marktext
  ```
  
  - 使用 Winget 前需要安装好 [Winget](https://docs.microsoft.com/en-us/windows/package-manager/winget/#install-winget)。
  
  ```bash
  winget install marktext
  ```

#### Linux

请按照 [Linux 安装指南](../../docs/LINUX.md)。

#### 其它

您可以从 [release 页面](https://github.com/marktext/marktext/releases/latest)下载适用于 Linux、macOS 和 Windows 的所有二进制文件。如果您的系统无法正常使用某个版本，请创建一个 [issue](https://github.com/marktext/marktext/issues)。

## 开发

如果您想自己构建 **MarkText**，请查看我们的[构建指南](../../docs/dev/BUILD.md)。

- [用户文档](../../docs/README.md)
- [开发者文档](../../docs/dev/README.md)

如果您对 **MarkText** 有任何疑问，欢迎写一个 issue。当这样做时，请使用打开 issue 时的默认格式。当然，如果您直接提交 PR，我们将不胜感激。

## 集成

- [Alfred 工作流](http://www.packal.org/workflow/mark-text)：macOS 应用程序 Alfred 的工作流：使用“mt”在文件或者文件夹下打开 MarkText。

## 贡献

MarkText 正在全面开发中，请确保在提出 PR 之前先阅读[贡献指南](../../CONTRIBUTING.md)。想要给 MarkText 添加一些功能？请先看看 [roadmap](../../ROADMAP.md) 和开放的 issue。

## 贡献者

感谢所有为 MarkText 做出贡献的人[[贡献者](https://github.com/marktext/marktext/graphs/contributors)]

特别感谢设计了 MarkText 图标的 @[Yasujizr](https://github.com/Yasujizr)。

<a href="https://github.com/marktext/marktext/graphs/contributors"><img src="https://opencollective.com/marktext/contributors.svg?width=890" /></a>

## 许可证

[**MIT**](../../LICENSE)

[![FOSSA Status](https://app.fossa.io/api/projects/git%2Bgithub.com%2Fmarktext%2Fmarktext.svg?type=large)](https://app.fossa.io/projects/git%2Bgithub.com%2Fmarktext%2Fmarktext?ref=badge_large)
