/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.LinkedList;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;
import org.checkerframework.javacutil.InternalUtils;

public class EqualToNode
extends Node {
    protected BinaryTree tree;
    protected Node lhs;
    protected Node rhs;

    public EqualToNode(BinaryTree tree, Node lhs, Node rhs) {
        super(InternalUtils.typeOf((Tree)tree));
        assert (tree.getKind().equals((Object)Tree.Kind.EQUAL_TO));
        this.tree = tree;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public Node getLeftOperand() {
        return this.lhs;
    }

    public Node getRightOperand() {
        return this.rhs;
    }

    @Override
    public BinaryTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitEqualTo(this, p);
    }

    public String toString() {
        return "(" + this.getLeftOperand() + " == " + this.getRightOperand() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EqualToNode)) {
            return false;
        }
        EqualToNode other = (EqualToNode)obj;
        return this.getLeftOperand().equals(other.getLeftOperand()) && this.getRightOperand().equals(other.getRightOperand());
    }

    public int hashCode() {
        return HashCodeUtils.hash(this.getLeftOperand(), this.getRightOperand());
    }

    @Override
    public Collection<Node> getOperands() {
        LinkedList<Node> list = new LinkedList<Node>();
        list.add(this.getLeftOperand());
        list.add(this.getRightOperand());
        return list;
    }
}

