/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.compiling.DependencyFileProcessor;
import com.android.builder.internal.compiler.SourceSearcher;
import com.android.builder.internal.incremental.DependencyData;
import com.android.ide.common.internal.CommandLineRunner;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.sdklib.io.FileOp;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AidlProcessor
implements SourceSearcher.SourceFileProcessor {
    @NonNull
    private final String mAidlExecutable;
    @NonNull
    private final String mFrameworkLocation;
    @NonNull
    private final List<File> mImportFolders;
    @NonNull
    private final File mSourceOutputDir;
    @Nullable
    private final File mParcelableOutputDir;
    @NonNull
    private final DependencyFileProcessor mDependencyFileProcessor;
    @NonNull
    private final CommandLineRunner mRunner;

    public AidlProcessor(@NonNull String aidlExecutable, @NonNull String frameworkLocation, @NonNull List<File> importFolders, @NonNull File sourceOutputDir, @Nullable File parcelableOutputDir, @NonNull DependencyFileProcessor dependencyFileProcessor, @NonNull CommandLineRunner runner) {
        this.mAidlExecutable = aidlExecutable;
        this.mFrameworkLocation = frameworkLocation;
        this.mImportFolders = importFolders;
        this.mSourceOutputDir = sourceOutputDir;
        this.mParcelableOutputDir = parcelableOutputDir;
        this.mDependencyFileProcessor = dependencyFileProcessor;
        this.mRunner = runner;
    }

    @Override
    public void processFile(@NonNull File sourceFolder, @NonNull File sourceFile) throws IOException, InterruptedException, LoggedErrorException {
        ArrayList command = Lists.newArrayList();
        command.add(this.mAidlExecutable);
        command.add("-p" + this.mFrameworkLocation);
        command.add("-o" + this.mSourceOutputDir.getAbsolutePath());
        for (File f : this.mImportFolders) {
            command.add("-I" + f.getAbsolutePath());
        }
        File depFile = File.createTempFile("aidl", ".d");
        command.add("-d" + depFile.getAbsolutePath());
        command.add(sourceFile.getAbsolutePath());
        this.mRunner.runCmdLine((List)command, null);
        DependencyData data = this.mDependencyFileProcessor.processFile(depFile);
        if (this.mParcelableOutputDir != null && data != null && data.getOutputFiles().isEmpty()) {
            String relative = FileOp.makeRelative((File)sourceFolder, (File)sourceFile);
            File destFile = new File(this.mParcelableOutputDir, relative);
            destFile.getParentFile().mkdirs();
            Files.copy((File)sourceFile, (File)destFile);
            data.addSecondaryOutputFile(destFile.getPath());
        }
        depFile.delete();
    }
}

