/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IteratingVerb;
import com.google.common.truth.StringUtil;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public abstract class AbstractVerb<T extends AbstractVerb<T>> {
    private final FailureStrategy failureStrategy;

    public AbstractVerb(FailureStrategy failureStrategy) {
        this.failureStrategy = failureStrategy;
    }

    protected FailureStrategy getFailureStrategy() {
        return this.getFailureMessage() != null ? new MessagePrependingFailureStrategy(this.failureStrategy, this.getFailureMessage()) : this.failureStrategy;
    }

    public void fail() {
        this.getFailureStrategy().fail("");
    }

    public void fail(@Nullable String format, Object ... args) {
        this.getFailureStrategy().fail(StringUtil.format(format, args));
    }

    @CheckReturnValue
    public abstract T withFailureMessage(String var1);

    protected abstract String getFailureMessage();

    public <S extends Subject<S, T>, T, SF extends SubjectFactory<S, T>> DelegatedVerb<S, T> about(SF factory) {
        return new DelegatedVerb(this.getFailureStrategy(), factory);
    }

    @GwtIncompatible(value="com.google.common.truth.IteratingVerb")
    public <T> IteratingVerb<T> in(Iterable<T> data) {
        return new IteratingVerb<T>(data, this.getFailureStrategy());
    }

    protected static class MessagePrependingFailureStrategy
    extends FailureStrategy {
        private final FailureStrategy delegate;
        private final String failureMessagePrepend;

        protected MessagePrependingFailureStrategy(FailureStrategy delegate, String failureMessage) {
            this.delegate = delegate;
            this.failureMessagePrepend = failureMessage;
        }

        @Override
        public void fail(String message) {
            String string = String.valueOf(String.valueOf(this.failureMessagePrepend));
            String string2 = String.valueOf(String.valueOf(message));
            this.delegate.fail(new StringBuilder(2 + string.length() + string2.length()).append(string).append(": ").append(string2).toString());
        }

        @Override
        public void fail(String message, Throwable cause) {
            String string = String.valueOf(String.valueOf(this.failureMessagePrepend));
            String string2 = String.valueOf(String.valueOf(message));
            this.delegate.fail(new StringBuilder(2 + string.length() + string2.length()).append(string).append(": ").append(string2).toString(), cause);
        }

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual) {
            String string = String.valueOf(String.valueOf(this.failureMessagePrepend));
            String string2 = String.valueOf(String.valueOf(StringUtil.messageFor(message, expected, actual)));
            this.delegate.fail(new StringBuilder(2 + string.length() + string2.length()).append(string).append(": ").append(string2).toString());
        }
    }

    public static class DelegatedVerb<S extends Subject<S, T>, T> {
        private final SubjectFactory<S, T> factory;
        private final FailureStrategy failureStrategy;

        public DelegatedVerb(FailureStrategy fs, SubjectFactory<S, T> factory) {
            this.factory = factory;
            this.failureStrategy = fs;
        }

        @CheckReturnValue
        public S that(T target) {
            return this.factory.getSubject(this.failureStrategy, target);
        }
    }
}

