/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Platform;
import com.google.common.truth.StringUtil;
import com.google.common.truth.SubjectUtils;
import com.google.common.truth.TestVerb;
import java.util.List;
import javax.annotation.Nullable;

public class Subject<S extends Subject<S, T>, T> {
    protected final FailureStrategy failureStrategy;
    private final T subject;
    private String customName = null;

    public Subject(FailureStrategy failureStrategy, @Nullable T subject) {
        this.failureStrategy = (FailureStrategy)Preconditions.checkNotNull((Object)failureStrategy);
        this.subject = subject;
    }

    protected String internalCustomName() {
        return this.customName;
    }

    public S named(String name) {
        this.customName = (String)Preconditions.checkNotNull((Object)name, (Object)"Name passed to named() cannot be null.");
        return (S)this;
    }

    public void isNull() {
        if (this.getSubject() != null) {
            this.fail("is null");
        }
    }

    public void isNotNull() {
        if (this.getSubject() == null) {
            this.failWithoutSubject("is a non-null reference");
        }
    }

    public void isEqualTo(@Nullable Object other) {
        if (!Objects.equal(this.getSubject(), (Object)other)) {
            this.fail("is equal to", other);
        }
    }

    public void isNotEqualTo(@Nullable Object other) {
        if (Objects.equal(this.getSubject(), (Object)other)) {
            this.fail("is not equal to", other);
        }
    }

    public void isSameAs(@Nullable Object other) {
        if (this.getSubject() != other) {
            this.fail("is the same instance as", other);
        }
    }

    public void isNotSameAs(@Nullable Object other) {
        if (this.getSubject() == other) {
            this.fail("is not the same instance as", other);
        }
    }

    public void isInstanceOf(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (!Platform.isInstanceOfType(this.getSubject(), clazz)) {
            if (this.getSubject() != null) {
                this.failWithBadResults("is an instance of", clazz.getName(), "is an instance of", this.getSubject().getClass().getName());
            } else {
                this.fail("is an instance of", (Object)clazz.getName());
            }
        }
    }

    public void isNotInstanceOf(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (this.getSubject() == null) {
            return;
        }
        if (Platform.isInstanceOfType(this.getSubject(), clazz)) {
            this.failWithRawMessage("%s expected not to be an instance of %s, but was.", this.getDisplaySubject(), clazz.getName());
        }
    }

    public void isIn(Iterable<?> iterable) {
        if (!Iterables.contains(iterable, this.getSubject())) {
            this.fail("is equal to any element in", (Object)iterable);
        }
    }

    public void isAnyOf(@Nullable Object first, @Nullable Object second, Object ... rest) {
        List<Object> list = SubjectUtils.accumulate(first, second, rest);
        if (!list.contains(this.getSubject())) {
            this.fail("is equal to any of", (Object)list);
        }
    }

    public void isNotIn(Iterable<?> iterable) {
        int index = Iterables.indexOf(iterable, (Predicate)Predicates.equalTo(this.getSubject()));
        if (index != -1) {
            this.failWithRawMessage("Not true that %s is not in %s. It was found at index %s", this.getDisplaySubject(), iterable, index);
        }
    }

    public void isNoneOf(@Nullable Object first, @Nullable Object second, Object ... rest) {
        this.isNotIn(SubjectUtils.accumulate(first, second, rest));
    }

    protected T getSubject() {
        return this.subject;
    }

    protected String getDisplaySubject() {
        if (this.customName != null) {
            String string = String.valueOf(String.valueOf(this.customName));
            String string2 = String.valueOf(String.valueOf(this.getSubject()));
            return new StringBuilder(5 + string.length() + string2.length()).append(string).append(" (<").append(string2).append(">)").toString();
        }
        String string = String.valueOf(String.valueOf(this.getSubject()));
        return new StringBuilder(2 + string.length()).append("<").append(string).append(">").toString();
    }

    protected TestVerb check() {
        return new TestVerb(this.failureStrategy);
    }

    protected void fail(String verb) {
        String string = String.valueOf(String.valueOf(this.getDisplaySubject()));
        String string2 = String.valueOf(String.valueOf(verb));
        this.failureStrategy.fail(new StringBuilder(15 + string.length() + string2.length()).append("Not true that ").append(string).append(" ").append(string2).toString());
    }

    protected void fail(String verb, Object part) {
        boolean needsDisambiguation;
        StringBuilder message = new StringBuilder("Not true that ").append(this.getDisplaySubject()).append(" ");
        boolean bl = needsDisambiguation = part != null && this.getSubject() != null && this.getSubject().toString().equals(part.toString()) && !this.getSubject().getClass().equals(part.getClass());
        if (needsDisambiguation) {
            message.append("(").append(this.getSubject().getClass().getName()).append(") ");
        }
        message.append(verb).append(" <").append(part).append(">");
        if (needsDisambiguation) {
            message.append(" (").append(part.getClass().getName()).append(")");
        }
        this.failureStrategy.fail(message.toString());
    }

    protected void fail(String verb, Object ... messageParts) {
        if (messageParts.length == 0) {
            this.fail(verb);
        } else if (messageParts.length == 1) {
            this.fail(verb, messageParts[0]);
        } else {
            StringBuilder message = new StringBuilder("Not true that ");
            message.append(this.getDisplaySubject()).append(" ").append(verb);
            for (Object part : messageParts) {
                message.append(" <").append(part).append(">");
            }
            this.failureStrategy.fail(message.toString());
        }
    }

    protected void failWithBadResults(String verb, Object expected, String failVerb, Object actual) {
        String message = StringUtil.format("Not true that %s %s <%s>. It %s <%s>", this.getDisplaySubject(), verb, expected, failVerb, actual == null ? "null reference" : actual);
        this.failureStrategy.fail(message);
    }

    protected void failWithCustomSubject(String verb, Object expected, Object actual) {
        String message = StringUtil.format("Not true that <%s> %s <%s>", actual == null ? "null reference" : actual, verb, expected);
        this.failureStrategy.fail(message);
    }

    protected void failWithoutSubject(String verb) {
        String string;
        if (this.customName == null) {
            string = "the subject";
        } else {
            String string2 = String.valueOf(String.valueOf(this.customName));
            string = new StringBuilder(2 + string2.length()).append("\"").append(string2).append("\"").toString();
        }
        String subject = string;
        this.failureStrategy.fail(StringUtil.format("Not true that %s %s", subject, verb));
    }

    protected void failWithRawMessage(String message, Object ... parameters) {
        this.failureStrategy.fail(StringUtil.format(message, parameters));
    }

    @Deprecated
    public boolean equals(@Nullable Object o) {
        throw new UnsupportedOperationException("If you meant to test object equality, use .isEqualTo(other) instead.");
    }

    @Deprecated
    public int hashCode() {
        throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
    }
}

