// Copyright 2014 Google Inc. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.devtools.build.lib.analysis;

import com.google.common.collect.UnmodifiableIterator;
import com.google.devtools.build.lib.analysis.config.BuildConfiguration;
import com.google.devtools.build.lib.packages.Target;

/**
 * A configured target that is used instead of a real configured target if there
 * are cyclic dependencies or if any of the prerequisites has errors. This
 * avoids accessing state that shouldn't be accessed.
 */
final class ErrorConfiguredTarget extends AbstractConfiguredTarget {
  ErrorConfiguredTarget(Target target, BuildConfiguration configuration) {
    super(target, configuration);
  }

  @Override
  public Object get(String providerKey) {
    throw new UnsupportedOperationException();
  }

  @Override
  public UnmodifiableIterator<TransitiveInfoProvider> iterator() {
    throw new IllegalStateException();
  }
}

