/*
 * msstyle data maps
 *
 * Copyright (C) 2004 Kevin Koltzau
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <stdarg.h>

#include "windef.h"
#include "winbase.h"
#include "winuser.h"
#include "tmschema.h"

#define TMT_ENUM 200

typedef struct _MSSTYLES_PROPERTY_MAP {
    WORD dwPrimitiveType;
    WORD dwPropertyID;
    WCHAR szPropertyName[24];
} MSSTYLES_PROPERTY_MAP, *PMSSTYLES_PROPERTY_MAP;

typedef struct _MSSTYLES_ENUM_MAP {
    WORD dwEnum;
    WORD dwValue;
    WCHAR szValueName[18];
} MSSTYLES_ENUM_MAP, *PMSSTYLES_ENUM_MAP;

typedef struct _MSSTYLES_CLASS_MAP {
    WORD dwPartID;
    WORD dwStateID;
    WCHAR szName[31];
} MSSTYLES_CLASS_MAP, *PMSSTYLES_CLASS_MAP;

typedef struct _MSSTYLES_CLASS_NAME {
    const MSSTYLES_CLASS_MAP *lpMap;
    WCHAR pszClass[12];
} MSSTYLES_CLASS_NAME, *PMSSTYLES_CLASS_NAME;

/***********************************************************************
 * Map property names to IDs & primitive types
 * PrimitiveType,PropertyID,PropertyName
 */
static const MSSTYLES_PROPERTY_MAP mapProperty[] = {
    {TMT_STRING, TMT_STRING, L"STRING"},
    {TMT_INT, TMT_INT, L"INT"},
    {TMT_BOOL, TMT_BOOL, L"BOOL"},
    {TMT_COLOR, TMT_COLOR, L"COLOR"},
    {TMT_MARGINS, TMT_MARGINS, L"MARGINS"},
    {TMT_FILENAME, TMT_FILENAME, L"FILENAME"},
    {TMT_SIZE, TMT_SIZE, L"SIZE"},
    {TMT_POSITION, TMT_POSITION, L"POSITION"},
    {TMT_RECT, TMT_RECT, L"RECT"},
    {TMT_FONT, TMT_FONT, L"FONT"},
    {TMT_INTLIST, TMT_INTLIST, L"INTLIST"},
    {TMT_STRING, TMT_COLORSCHEMES, L"COLORSCHEMES"},
    {TMT_STRING, TMT_SIZES, L"SIZES"},
    {TMT_INT, TMT_CHARSET, L"CHARSET"},
    {TMT_STRING, TMT_DISPLAYNAME, L"DISPLAYNAME"},
    {TMT_STRING, TMT_TOOLTIP, L"TOOLTIP"},
    {TMT_STRING, TMT_COMPANY, L"COMPANY"},
    {TMT_STRING, TMT_AUTHOR, L"AUTHOR"},
    {TMT_STRING, TMT_COPYRIGHT, L"COPYRIGHT"},
    {TMT_STRING, TMT_URL, L"URL"},
    {TMT_STRING, TMT_VERSION, L"VERSION"},
    {TMT_STRING, TMT_DESCRIPTION, L"DESCRIPTION"},
    {TMT_FONT, TMT_CAPTIONFONT, L"CAPTIONFONT"},
    {TMT_FONT, TMT_SMALLCAPTIONFONT, L"SMALLCAPTIONFONT"},
    {TMT_FONT, TMT_MENUFONT, L"MENUFONT"},
    {TMT_FONT, TMT_STATUSFONT, L"STATUSFONT"},
    {TMT_FONT, TMT_MSGBOXFONT, L"MSGBOXFONT"},
    {TMT_FONT, TMT_ICONTITLEFONT, L"ICONTITLEFONT"},
    {TMT_FONT, TMT_HEADING1FONT, L"HEADING1FONT"},
    {TMT_FONT, TMT_HEADING2FONT, L"HEADING2FONT"},
    {TMT_FONT, TMT_BODYFONT, L"BODYFONT"},
    {TMT_BOOL, TMT_FLATMENUS, L"FLATMENUS"},
    {TMT_SIZE, TMT_SIZINGBORDERWIDTH, L"SIZINGBORDERWIDTH"},
    {TMT_SIZE, TMT_SCROLLBARWIDTH, L"SCROLLBARWIDTH"},
    {TMT_SIZE, TMT_SCROLLBARHEIGHT, L"SCROLLBARHEIGHT"},
    {TMT_SIZE, TMT_CAPTIONBARWIDTH, L"CAPTIONBARWIDTH"},
    {TMT_SIZE, TMT_CAPTIONBARHEIGHT, L"CAPTIONBARHEIGHT"},
    {TMT_SIZE, TMT_SMCAPTIONBARWIDTH, L"SMCAPTIONBARWIDTH"},
    {TMT_SIZE, TMT_SMCAPTIONBARHEIGHT, L"SMCAPTIONBARHEIGHT"},
    {TMT_SIZE, TMT_MENUBARWIDTH, L"MENUBARWIDTH"},
    {TMT_SIZE, TMT_MENUBARHEIGHT, L"MENUBARHEIGHT"},
    {TMT_INT, TMT_MINCOLORDEPTH, L"MINCOLORDEPTH"},
    {TMT_STRING, TMT_CSSNAME, L"CSSNAME"},
    {TMT_STRING, TMT_XMLNAME, L"XMLNAME"},
    {TMT_COLOR, TMT_SCROLLBAR, L"SCROLLBAR"},
    {TMT_COLOR, TMT_BACKGROUND, L"BACKGROUND"},
    {TMT_COLOR, TMT_ACTIVECAPTION, L"ACTIVECAPTION"},
    {TMT_COLOR, TMT_INACTIVECAPTION, L"INACTIVECAPTION"},
    {TMT_COLOR, TMT_MENU, L"MENU"},
    {TMT_COLOR, TMT_WINDOW, L"WINDOW"},
    {TMT_COLOR, TMT_WINDOWFRAME, L"WINDOWFRAME"},
    {TMT_COLOR, TMT_MENUTEXT, L"MENUTEXT"},
    {TMT_COLOR, TMT_WINDOWTEXT, L"WINDOWTEXT"},
    {TMT_COLOR, TMT_CAPTIONTEXT, L"CAPTIONTEXT"},
    {TMT_COLOR, TMT_ACTIVEBORDER, L"ACTIVEBORDER"},
    {TMT_COLOR, TMT_INACTIVEBORDER, L"INACTIVEBORDER"},
    {TMT_COLOR, TMT_APPWORKSPACE, L"APPWORKSPACE"},
    {TMT_COLOR, TMT_HIGHLIGHT, L"HIGHLIGHT"},
    {TMT_COLOR, TMT_HIGHLIGHTTEXT, L"HIGHLIGHTTEXT"},
    {TMT_COLOR, TMT_BTNFACE, L"BTNFACE"},
    {TMT_COLOR, TMT_BTNSHADOW, L"BTNSHADOW"},
    {TMT_COLOR, TMT_GRAYTEXT, L"GRAYTEXT"},
    {TMT_COLOR, TMT_BTNTEXT, L"BTNTEXT"},
    {TMT_COLOR, TMT_INACTIVECAPTIONTEXT, L"INACTIVECAPTIONTEXT"},
    {TMT_COLOR, TMT_BTNHIGHLIGHT, L"BTNHIGHLIGHT"},
    {TMT_COLOR, TMT_DKSHADOW3D, L"DKSHADOW3D"},
    {TMT_COLOR, TMT_LIGHT3D, L"LIGHT3D"},
    {TMT_COLOR, TMT_INFOTEXT, L"INFOTEXT"},
    {TMT_COLOR, TMT_INFOBK, L"INFOBK"},
    {TMT_COLOR, TMT_BUTTONALTERNATEFACE, L"BUTTONALTERNATEFACE"},
    {TMT_COLOR, TMT_HOTTRACKING, L"HOTTRACKING"},
    {TMT_COLOR, TMT_GRADIENTACTIVECAPTION, L"GRADIENTACTIVECAPTION"},
    {TMT_COLOR, TMT_GRADIENTINACTIVECAPTION, L"GRADIENTINACTIVECAPTION"},
    {TMT_COLOR, TMT_MENUHILIGHT, L"MENUHILIGHT"},
    {TMT_COLOR, TMT_MENUBAR, L"MENUBAR"},
    {TMT_INT, TMT_FROMHUE1, L"FROMHUE1"},
    {TMT_INT, TMT_FROMHUE2, L"FROMHUE2"},
    {TMT_INT, TMT_FROMHUE3, L"FROMHUE3"},
    {TMT_INT, TMT_FROMHUE4, L"FROMHUE4"},
    {TMT_INT, TMT_FROMHUE5, L"FROMHUE5"},
    {TMT_INT, TMT_TOHUE1, L"TOHUE1"},
    {TMT_INT, TMT_TOHUE2, L"TOHUE2"},
    {TMT_INT, TMT_TOHUE3, L"TOHUE3"},
    {TMT_INT, TMT_TOHUE4, L"TOHUE4"},
    {TMT_INT, TMT_TOHUE5, L"TOHUE5"},
    {TMT_COLOR, TMT_FROMCOLOR1, L"FROMCOLOR1"},
    {TMT_COLOR, TMT_FROMCOLOR2, L"FROMCOLOR2"},
    {TMT_COLOR, TMT_FROMCOLOR3, L"FROMCOLOR3"},
    {TMT_COLOR, TMT_FROMCOLOR4, L"FROMCOLOR4"},
    {TMT_COLOR, TMT_FROMCOLOR5, L"FROMCOLOR5"},
    {TMT_COLOR, TMT_TOCOLOR1, L"TOCOLOR1"},
    {TMT_COLOR, TMT_TOCOLOR2, L"TOCOLOR2"},
    {TMT_COLOR, TMT_TOCOLOR3, L"TOCOLOR3"},
    {TMT_COLOR, TMT_TOCOLOR4, L"TOCOLOR4"},
    {TMT_COLOR, TMT_TOCOLOR5, L"TOCOLOR5"},
    {TMT_BOOL, TMT_TRANSPARENT, L"TRANSPARENT"},
    {TMT_BOOL, TMT_AUTOSIZE, L"AUTOSIZE"},
    {TMT_BOOL, TMT_BORDERONLY, L"BORDERONLY"},
    {TMT_BOOL, TMT_COMPOSITED, L"COMPOSITED"},
    {TMT_BOOL, TMT_BGFILL, L"BGFILL"},
    {TMT_BOOL, TMT_GLYPHTRANSPARENT, L"GLYPHTRANSPARENT"},
    {TMT_BOOL, TMT_GLYPHONLY, L"GLYPHONLY"},
    {TMT_BOOL, TMT_ALWAYSSHOWSIZINGBAR, L"ALWAYSSHOWSIZINGBAR"},
    {TMT_BOOL, TMT_MIRRORIMAGE, L"MIRRORIMAGE"},
    {TMT_BOOL, TMT_UNIFORMSIZING, L"UNIFORMSIZING"},
    {TMT_BOOL, TMT_INTEGRALSIZING, L"INTEGRALSIZING"},
    {TMT_BOOL, TMT_SOURCEGROW, L"SOURCEGROW"},
    {TMT_BOOL, TMT_SOURCESHRINK, L"SOURCESHRINK"},
    {TMT_INT, TMT_IMAGECOUNT, L"IMAGECOUNT"},
    {TMT_INT, TMT_ALPHALEVEL, L"ALPHALEVEL"},
    {TMT_INT, TMT_BORDERSIZE, L"BORDERSIZE"},
    {TMT_INT, TMT_ROUNDCORNERWIDTH, L"ROUNDCORNERWIDTH"},
    {TMT_INT, TMT_ROUNDCORNERHEIGHT, L"ROUNDCORNERHEIGHT"},
    {TMT_INT, TMT_GRADIENTRATIO1, L"GRADIENTRATIO1"},
    {TMT_INT, TMT_GRADIENTRATIO2, L"GRADIENTRATIO2"},
    {TMT_INT, TMT_GRADIENTRATIO3, L"GRADIENTRATIO3"},
    {TMT_INT, TMT_GRADIENTRATIO4, L"GRADIENTRATIO4"},
    {TMT_INT, TMT_GRADIENTRATIO5, L"GRADIENTRATIO5"},
    {TMT_INT, TMT_PROGRESSCHUNKSIZE, L"PROGRESSCHUNKSIZE"},
    {TMT_INT, TMT_PROGRESSSPACESIZE, L"PROGRESSSPACESIZE"},
    {TMT_INT, TMT_SATURATION, L"SATURATION"},
    {TMT_INT, TMT_TEXTBORDERSIZE, L"TEXTBORDERSIZE"},
    {TMT_INT, TMT_ALPHATHRESHOLD, L"ALPHATHRESHOLD"},
    {TMT_SIZE, TMT_WIDTH, L"WIDTH"},
    {TMT_SIZE, TMT_HEIGHT, L"HEIGHT"},
    {TMT_INT, TMT_GLYPHINDEX, L"GLYPHINDEX"},
    {TMT_INT, TMT_TRUESIZESTRETCHMARK, L"TRUESIZESTRETCHMARK"},
    {TMT_INT, TMT_MINDPI1, L"MINDPI1"},
    {TMT_INT, TMT_MINDPI2, L"MINDPI2"},
    {TMT_INT, TMT_MINDPI3, L"MINDPI3"},
    {TMT_INT, TMT_MINDPI4, L"MINDPI4"},
    {TMT_INT, TMT_MINDPI5, L"MINDPI5"},
    {TMT_FONT, TMT_GLYPHFONT, L"GLYPHFONT"},
    {TMT_FILENAME, TMT_IMAGEFILE, L"IMAGEFILE"},
    {TMT_FILENAME, TMT_IMAGEFILE1, L"IMAGEFILE1"},
    {TMT_FILENAME, TMT_IMAGEFILE2, L"IMAGEFILE2"},
    {TMT_FILENAME, TMT_IMAGEFILE3, L"IMAGEFILE3"},
    {TMT_FILENAME, TMT_IMAGEFILE4, L"IMAGEFILE4"},
    {TMT_FILENAME, TMT_IMAGEFILE5, L"IMAGEFILE5"},
    {TMT_FILENAME, TMT_STOCKIMAGEFILE, L"STOCKIMAGEFILE"},
    {TMT_FILENAME, TMT_GLYPHIMAGEFILE, L"GLYPHIMAGEFILE"},
    {TMT_STRING, TMT_TEXT, L"TEXT"},
    {TMT_POSITION, TMT_OFFSET, L"OFFSET"},
    {TMT_POSITION, TMT_TEXTSHADOWOFFSET, L"TEXTSHADOWOFFSET"},
    {TMT_POSITION, TMT_MINSIZE, L"MINSIZE"},
    {TMT_POSITION, TMT_MINSIZE1, L"MINSIZE1"},
    {TMT_POSITION, TMT_MINSIZE2, L"MINSIZE2"},
    {TMT_POSITION, TMT_MINSIZE3, L"MINSIZE3"},
    {TMT_POSITION, TMT_MINSIZE4, L"MINSIZE4"},
    {TMT_POSITION, TMT_MINSIZE5, L"MINSIZE5"},
    {TMT_POSITION, TMT_NORMALSIZE, L"NORMALSIZE"},
    {TMT_MARGINS, TMT_SIZINGMARGINS, L"SIZINGMARGINS"},
    {TMT_MARGINS, TMT_CONTENTMARGINS, L"CONTENTMARGINS"},
    {TMT_MARGINS, TMT_CAPTIONMARGINS, L"CAPTIONMARGINS"},
    {TMT_COLOR, TMT_BORDERCOLOR, L"BORDERCOLOR"},
    {TMT_COLOR, TMT_FILLCOLOR, L"FILLCOLOR"},
    {TMT_COLOR, TMT_TEXTCOLOR, L"TEXTCOLOR"},
    {TMT_COLOR, TMT_EDGELIGHTCOLOR, L"EDGELIGHTCOLOR"},
    {TMT_COLOR, TMT_EDGEHIGHLIGHTCOLOR, L"EDGEHIGHLIGHTCOLOR"},
    {TMT_COLOR, TMT_EDGESHADOWCOLOR, L"EDGESHADOWCOLOR"},
    {TMT_COLOR, TMT_EDGEDKSHADOWCOLOR, L"EDGEDKSHADOWCOLOR"},
    {TMT_COLOR, TMT_EDGEFILLCOLOR, L"EDGEFILLCOLOR"},
    {TMT_COLOR, TMT_TRANSPARENTCOLOR, L"TRANSPARENTCOLOR"},
    {TMT_COLOR, TMT_GRADIENTCOLOR1, L"GRADIENTCOLOR1"},
    {TMT_COLOR, TMT_GRADIENTCOLOR2, L"GRADIENTCOLOR2"},
    {TMT_COLOR, TMT_GRADIENTCOLOR3, L"GRADIENTCOLOR3"},
    {TMT_COLOR, TMT_GRADIENTCOLOR4, L"GRADIENTCOLOR4"},
    {TMT_COLOR, TMT_GRADIENTCOLOR5, L"GRADIENTCOLOR5"},
    {TMT_COLOR, TMT_SHADOWCOLOR, L"SHADOWCOLOR"},
    {TMT_COLOR, TMT_GLOWCOLOR, L"GLOWCOLOR"},
    {TMT_COLOR, TMT_TEXTBORDERCOLOR, L"TEXTBORDERCOLOR"},
    {TMT_COLOR, TMT_TEXTSHADOWCOLOR, L"TEXTSHADOWCOLOR"},
    {TMT_COLOR, TMT_GLYPHTEXTCOLOR, L"GLYPHTEXTCOLOR"},
    {TMT_COLOR, TMT_GLYPHTRANSPARENTCOLOR, L"GLYPHTRANSPARENTCOLOR"},
    {TMT_COLOR, TMT_FILLCOLORHINT, L"FILLCOLORHINT"},
    {TMT_COLOR, TMT_BORDERCOLORHINT, L"BORDERCOLORHINT"},
    {TMT_COLOR, TMT_ACCENTCOLORHINT, L"ACCENTCOLORHINT"},
    {TMT_ENUM, TMT_BGTYPE, L"BGTYPE"},
    {TMT_ENUM, TMT_BORDERTYPE, L"BORDERTYPE"},
    {TMT_ENUM, TMT_FILLTYPE, L"FILLTYPE"},
    {TMT_ENUM, TMT_SIZINGTYPE, L"SIZINGTYPE"},
    {TMT_ENUM, TMT_HALIGN, L"HALIGN"},
    {TMT_ENUM, TMT_CONTENTALIGNMENT, L"CONTENTALIGNMENT"},
    {TMT_ENUM, TMT_VALIGN, L"VALIGN"},
    {TMT_ENUM, TMT_OFFSETTYPE, L"OFFSETTYPE"},
    {TMT_ENUM, TMT_ICONEFFECT, L"ICONEFFECT"},
    {TMT_ENUM, TMT_TEXTSHADOWTYPE, L"TEXTSHADOWTYPE"},
    {TMT_ENUM, TMT_IMAGELAYOUT, L"IMAGELAYOUT"},
    {TMT_ENUM, TMT_GLYPHTYPE, L"GLYPHTYPE"},
    {TMT_ENUM, TMT_IMAGESELECTTYPE, L"IMAGESELECTTYPE"},
    {TMT_ENUM, TMT_GLYPHFONTSIZINGTYPE, L"GLYPHFONTSIZINGTYPE"},
    {TMT_ENUM, TMT_TRUESIZESCALINGTYPE, L"TRUESIZESCALINGTYPE"},
    {TMT_BOOL, TMT_USERPICTURE, L"USERPICTURE"},
    {TMT_RECT, TMT_DEFAULTPANESIZE, L"DEFAULTPANESIZE"},
    {TMT_COLOR, TMT_BLENDCOLOR, L"BLENDCOLOR"},
    {0, 0, L""}
};

/***********************************************************************
 * Map strings to enumeration values
 * Enum,Value,ValueName
 */
static const MSSTYLES_ENUM_MAP mapEnum[] = {
    {TMT_BGTYPE, BT_IMAGEFILE, L"IMAGEFILE"},
    {TMT_BGTYPE, BT_BORDERFILL, L"BORDERFILL"},
    {TMT_BGTYPE, BT_NONE, L"NONE"},
    {TMT_IMAGELAYOUT, IL_VERTICAL, L"VERTICAL"},
    {TMT_IMAGELAYOUT, IL_HORIZONTAL, L"HORIZONTAL"},
    {TMT_BORDERTYPE, BT_RECT, L"RECT"},
    {TMT_BORDERTYPE, BT_ROUNDRECT, L"ROUNDRECT"},
    {TMT_BORDERTYPE, BT_ELLIPSE, L"ELLIPSE"},
    {TMT_FILLTYPE, FT_SOLID, L"SOLID"},
    {TMT_FILLTYPE, FT_VERTGRADIENT, L"VERTGRADIENT"},
    {TMT_FILLTYPE, FT_HORZGRADIENT, L"HORZGRADIENT"},
    {TMT_FILLTYPE, FT_RADIALGRADIENT, L"RADIALGRADIENT"},
    {TMT_FILLTYPE, FT_TILEIMAGE, L"TILEIMAGE"},
    {TMT_SIZINGTYPE, ST_TRUESIZE, L"TRUESIZE"},
    {TMT_SIZINGTYPE, ST_STRETCH, L"STRETCH"},
    {TMT_SIZINGTYPE, ST_TILE, L"TILE"},
    {TMT_HALIGN, HA_LEFT, L"LEFT"},
    {TMT_HALIGN, HA_CENTER, L"CENTER"},
    {TMT_HALIGN, HA_RIGHT, L"RIGHT"},
    {TMT_CONTENTALIGNMENT, CA_LEFT, L"LEFT"},
    {TMT_CONTENTALIGNMENT, CA_CENTER, L"CENTER"},
    {TMT_CONTENTALIGNMENT, CA_RIGHT, L"RIGHT"},
    {TMT_VALIGN, VA_TOP, L"TOP"},
    {TMT_VALIGN, VA_CENTER, L"CENTER"},
    {TMT_VALIGN, VA_BOTTOM, L"BOTTOM"},
    {TMT_OFFSETTYPE, OT_TOPLEFT, L"TOPLEFT"},
    {TMT_OFFSETTYPE, OT_TOPRIGHT, L"TOPRIGHT"},
    {TMT_OFFSETTYPE, OT_TOPMIDDLE, L"TOPMIDDLE"},
    {TMT_OFFSETTYPE, OT_BOTTOMLEFT, L"BOTTOMLEFT"},
    {TMT_OFFSETTYPE, OT_BOTTOMRIGHT, L"BOTTOMRIGHT"},
    {TMT_OFFSETTYPE, OT_BOTTOMMIDDLE, L"BOTTOMMIDDLE"},
    {TMT_OFFSETTYPE, OT_MIDDLELEFT, L"MIDDLELEFT"},
    {TMT_OFFSETTYPE, OT_MIDDLERIGHT, L"MIDDLERIGHT"},
    {TMT_OFFSETTYPE, OT_LEFTOFCAPTION, L"LEFTOFCAPTION"},
    {TMT_OFFSETTYPE, OT_RIGHTOFCAPTION, L"RIGHTOFCAPTION"},
    {TMT_OFFSETTYPE, OT_LEFTOFLASTBUTTON, L"LEFTOFLASTBUTTON"},
    {TMT_OFFSETTYPE, OT_RIGHTOFLASTBUTTON, L"RIGHTOFLASTBUTTON"},
    {TMT_OFFSETTYPE, OT_ABOVELASTBUTTON, L"ABOVELASTBUTTON"},
    {TMT_OFFSETTYPE, OT_BELOWLASTBUTTON, L"BELOWLASTBUTTON"},
    {TMT_ICONEFFECT, ICE_NONE, L"NONE"},
    {TMT_ICONEFFECT, ICE_GLOW, L"GLOW"},
    {TMT_ICONEFFECT, ICE_SHADOW, L"SHADOW"},
    {TMT_ICONEFFECT, ICE_PULSE, L"PULSE"},
    {TMT_ICONEFFECT, ICE_ALPHA, L"ALPHA"},
    {TMT_TEXTSHADOWTYPE, TST_NONE, L"NONE"},
    {TMT_TEXTSHADOWTYPE, TST_SINGLE, L"SINGLE"},
    {TMT_TEXTSHADOWTYPE, TST_CONTINUOUS, L"CONTINUOUS"},
    {TMT_GLYPHTYPE, GT_NONE, L"NONE"},
    {TMT_GLYPHTYPE, GT_IMAGEGLYPH, L"IMAGEGLYPH"},
    {TMT_GLYPHTYPE, GT_FONTGLYPH, L"FONTGLYPH"},
    {TMT_IMAGESELECTTYPE, IST_NONE, L"NONE"},
    {TMT_IMAGESELECTTYPE, IST_SIZE, L"SIZE"},
    {TMT_IMAGESELECTTYPE, IST_DPI, L"DPI"},
    {TMT_TRUESIZESCALINGTYPE, TSST_NONE, L"NONE"},
    {TMT_TRUESIZESCALINGTYPE, TSST_SIZE, L"SIZE"},
    {TMT_TRUESIZESCALINGTYPE, TSST_DPI, L"DPI"},
    {TMT_GLYPHFONTSIZINGTYPE, GFST_NONE, L"NONE"},
    {TMT_GLYPHFONTSIZINGTYPE, GFST_SIZE, L"SIZE"},
    {TMT_GLYPHFONTSIZINGTYPE, GFST_DPI, L"DPI"},
    {0, 0, L""}
};


/***********************************************************************
 * Classes defined below
 * Defined as PartID,StateID,TextName
 * If StateID == 0 then its a part being defined
 */

/* These are globals to all classes, but its treated as a separate class */
static const MSSTYLES_CLASS_MAP classGlobals[] = {
    {GP_BORDER, 0, L"BORDER"},
    {GP_BORDER, BSS_FLAT, L"FLAT"},
    {GP_BORDER, BSS_RAISED, L"RAISED"},
    {GP_BORDER, BSS_SUNKEN, L"SUNKEN"},
    {GP_LINEHORZ, 0, L"LINEHORZ"},
    {GP_LINEHORZ, LHS_FLAT, L"FLAT"},
    {GP_LINEHORZ, LHS_RAISED, L"RAISED"},
    {GP_LINEHORZ, LHS_SUNKEN, L"SUNKEN"},
    {GP_LINEVERT, 0, L"LINEVERT"},
    {GP_LINEVERT, LVS_FLAT, L"FLAT"},
    {GP_LINEVERT, LVS_RAISED, L"RAISED"},
    {GP_LINEVERT, LVS_SUNKEN, L"SUNKEN"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classButton[] = {
    {BP_PUSHBUTTON, 0, L"PUSHBUTTON"},
    {BP_PUSHBUTTON, PBS_NORMAL, L"NORMAL"},
    {BP_PUSHBUTTON, PBS_HOT, L"HOT"},
    {BP_PUSHBUTTON, PBS_PRESSED, L"PRESSED"},
    {BP_PUSHBUTTON, PBS_DISABLED, L"DISABLED"},
    {BP_PUSHBUTTON, PBS_DEFAULTED, L"DEFAULTED"},
    {BP_RADIOBUTTON, 0, L"RADIOBUTTON"},
    {BP_RADIOBUTTON, RBS_UNCHECKEDNORMAL, L"UNCHECKEDNORMAL"},
    {BP_RADIOBUTTON, RBS_UNCHECKEDHOT, L"UNCHECKEDHOT"},
    {BP_RADIOBUTTON, RBS_UNCHECKEDPRESSED, L"UNCHECKEDPRESSED"},
    {BP_RADIOBUTTON, RBS_UNCHECKEDDISABLED, L"UNCHECKEDDISABLED"},
    {BP_RADIOBUTTON, RBS_CHECKEDNORMAL, L"CHECKEDNORMAL"},
    {BP_RADIOBUTTON, RBS_CHECKEDHOT, L"CHECKEDHOT"},
    {BP_RADIOBUTTON, RBS_CHECKEDPRESSED, L"CHECKEDPRESSED"},
    {BP_RADIOBUTTON, RBS_CHECKEDDISABLED, L"CHECKEDDISABLED"},
    {BP_CHECKBOX, 0, L"CHECKBOX"},
    {BP_CHECKBOX, CBS_UNCHECKEDNORMAL, L"UNCHECKEDNORMAL"},
    {BP_CHECKBOX, CBS_UNCHECKEDHOT, L"UNCHECKEDHOT"},
    {BP_CHECKBOX, CBS_UNCHECKEDPRESSED, L"UNCHECKEDPRESSED"},
    {BP_CHECKBOX, CBS_UNCHECKEDDISABLED, L"UNCHECKEDDISABLED"},
    {BP_CHECKBOX, CBS_CHECKEDNORMAL, L"CHECKEDNORMAL"},
    {BP_CHECKBOX, CBS_CHECKEDHOT, L"CHECKEDHOT"},
    {BP_CHECKBOX, CBS_CHECKEDPRESSED, L"CHECKEDPRESSED"},
    {BP_CHECKBOX, CBS_CHECKEDDISABLED, L"CHECKEDDISABLED"},
    {BP_CHECKBOX, CBS_MIXEDNORMAL, L"MIXEDNORMAL"},
    {BP_CHECKBOX, CBS_MIXEDHOT, L"MIXEDHOT"},
    {BP_CHECKBOX, CBS_MIXEDPRESSED, L"MIXEDPRESSED"},
    {BP_CHECKBOX, CBS_MIXEDDISABLED, L"MIXEDDISABLED"},
    {BP_GROUPBOX, 0, L"GROUPBOX"},
    {BP_GROUPBOX, GBS_NORMAL, L"NORMAL"},
    {BP_GROUPBOX, GBS_DISABLED, L"DISABLED"},
    {BP_USERBUTTON, 0, L"USERBUTTON"},
    {BP_COMMANDLINK, 0, L"COMMANDLINK"},
    {BP_COMMANDLINK, CMDLS_NORMAL, L"NORMAL"},
    {BP_COMMANDLINK, CMDLS_HOT, L"HOT"},
    {BP_COMMANDLINK, CMDLS_PRESSED, L"PRESSED"},
    {BP_COMMANDLINK, CMDLS_DISABLED, L"DISABLED"},
    {BP_COMMANDLINK, CMDLS_DEFAULTED, L"DEFAULTED"},
    {BP_COMMANDLINK, CMDLS_DEFAULTED_ANIMATING, L"DEFAULTED_ANIMATING"},
    {BP_COMMANDLINKGLYPH, 0, L"COMMANDLINKGLYPH"},
    {BP_COMMANDLINKGLYPH, CMDLGS_NORMAL, L"NORMAL"},
    {BP_COMMANDLINKGLYPH, CMDLGS_HOT, L"HOT"},
    {BP_COMMANDLINKGLYPH, CMDLGS_PRESSED, L"PRESSED"},
    {BP_COMMANDLINKGLYPH, CMDLGS_DISABLED, L"DISABLED"},
    {BP_COMMANDLINKGLYPH, CMDLGS_DEFAULTED, L"DEFAULTED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classClock[] = {
    {CLP_TIME, 0, L"TIME"},
    {CLP_TIME, CLS_NORMAL, L"NORMAL"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classCombobox[] = {
    {CP_DROPDOWNBUTTON, 0, L"DROPDOWNBUTTON"},
    {CP_DROPDOWNBUTTON, CBXS_NORMAL, L"NORMAL"},
    {CP_DROPDOWNBUTTON, CBXS_HOT, L"HOT"},
    {CP_DROPDOWNBUTTON, CBXS_PRESSED, L"PRESSED"},
    {CP_DROPDOWNBUTTON, CBXS_DISABLED, L"DISABLED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classEdit[] = {
    {EP_EDITTEXT, 0, L"EDITTEXT"},
    {EP_EDITTEXT, ETS_NORMAL, L"NORMAL"},
    {EP_EDITTEXT, ETS_HOT, L"HOT"},
    {EP_EDITTEXT, ETS_SELECTED, L"SELECTED"},
    {EP_EDITTEXT, ETS_DISABLED, L"DISABLED"},
    {EP_EDITTEXT, ETS_FOCUSED, L"FOCUSED"},
    {EP_EDITTEXT, ETS_READONLY, L"READONLY"},
    {EP_EDITTEXT, ETS_ASSIST, L"ASSIST"},
    {EP_CARET, 0, L"CARET"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classExplorerbar[] = {
    {EBP_HEADERBACKGROUND, 0, L"HEADERBACKGROUND"},
    {EBP_HEADERCLOSE, 0, L"HEADERCLOSE"},
    {EBP_HEADERCLOSE, EBHC_NORMAL, L"NORMAL"},
    {EBP_HEADERCLOSE, EBHC_HOT, L"HOT"},
    {EBP_HEADERCLOSE, EBHC_PRESSED, L"PRESSED"},
    {EBP_HEADERPIN, 0, L"HEADERPIN"},
    {EBP_HEADERPIN, EBHP_NORMAL, L"NORMAL"},
    {EBP_HEADERPIN, EBHP_HOT, L"HOT"},
    {EBP_HEADERPIN, EBHP_PRESSED, L"PRESSED"},
    {EBP_HEADERPIN, EBHP_SELECTEDNORMAL, L"SELECTEDNORMAL"},
    {EBP_HEADERPIN, EBHP_SELECTEDHOT, L"SELECTEDHOT"},
    {EBP_HEADERPIN, EBHP_SELECTEDPRESSED, L"SELECTEDPRESSED"},
    {EBP_IEBARMENU, 0, L"IEBARMENU"},
    {EBP_IEBARMENU, EBM_NORMAL, L"NORMAL"},
    {EBP_IEBARMENU, EBM_HOT, L"HOT"},
    {EBP_IEBARMENU, EBM_PRESSED, L"PRESSED"},
    {EBP_NORMALGROUPBACKGROUND, 0, L"NORMALGROUPBACKGROUND"},
    {EBP_NORMALGROUPCOLLAPSE, 0, L"NORMALGROUPCOLLAPSE"},
    {EBP_NORMALGROUPCOLLAPSE, EBNGC_NORMAL, L"NORMAL"},
    {EBP_NORMALGROUPCOLLAPSE, EBNGC_HOT, L"HOT"},
    {EBP_NORMALGROUPCOLLAPSE, EBNGC_PRESSED, L"PRESSED"},
    {EBP_NORMALGROUPEXPAND, 0, L"NORMALGROUPEXPAND"},
    {EBP_NORMALGROUPEXPAND, EBNGE_NORMAL, L"NORMAL"},
    {EBP_NORMALGROUPEXPAND, EBNGE_HOT, L"HOT"},
    {EBP_NORMALGROUPEXPAND, EBNGE_PRESSED, L"PRESSED"},
    {EBP_NORMALGROUPHEAD, 0, L"NORMALGROUPHEAD"},
    {EBP_SPECIALGROUPBACKGROUND, 0, L"SPECIALGROUPBACKGROUND"},
    {EBP_SPECIALGROUPCOLLAPSE, 0, L"SPECIALGROUPCOLLAPSE"},
    {EBP_SPECIALGROUPCOLLAPSE, EBSGC_NORMAL, L"NORMAL"},
    {EBP_SPECIALGROUPCOLLAPSE, EBSGC_HOT, L"HOT"},
    {EBP_SPECIALGROUPCOLLAPSE, EBSGC_PRESSED, L"PRESSED"},
    {EBP_SPECIALGROUPEXPAND, 0, L"SPECIALGROUPEXPAND"},
    {EBP_SPECIALGROUPEXPAND, EBSGE_NORMAL, L"NORMAL"},
    {EBP_SPECIALGROUPEXPAND, EBSGE_HOT, L"HOT"},
    {EBP_SPECIALGROUPEXPAND, EBSGE_PRESSED, L"PRESSED"},
    {EBP_SPECIALGROUPHEAD, 0, L"SPECIALGROUPHEAD"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classHeader[] = {
    {HP_HEADERITEM, 0, L"HEADERITEM"},
    {HP_HEADERITEM, HIS_NORMAL, L"NORMAL"},
    {HP_HEADERITEM, HIS_HOT, L"HOT"},
    {HP_HEADERITEM, HIS_PRESSED, L"PRESSED"},
    {HP_HEADERITEMLEFT, 0, L"HEADERITEMLEFT"},
    {HP_HEADERITEMLEFT, HILS_NORMAL, L"NORMAL"},
    {HP_HEADERITEMLEFT, HILS_HOT, L"HOT"},
    {HP_HEADERITEMLEFT, HILS_PRESSED, L"PRESSED"},
    {HP_HEADERITEMRIGHT, 0, L"HEADERITEMRIGHT"},
    {HP_HEADERITEMRIGHT, HIRS_NORMAL, L"NORMAL"},
    {HP_HEADERITEMRIGHT, HIRS_HOT, L"HOT"},
    {HP_HEADERITEMRIGHT, HIRS_PRESSED, L"PRESSED"},
    {HP_HEADERSORTARROW, 0, L"HEADERSORTARROW"},
    {HP_HEADERSORTARROW, HSAS_SORTEDUP, L"SORTEDUP"},
    {HP_HEADERSORTARROW, HSAS_SORTEDDOWN, L"SORTEDDOWN"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classListview[] = {
    {LVP_LISTITEM, 0, L"LISTITEM"},
    {LVP_LISTITEM, LIS_NORMAL, L"NORMAL"},
    {LVP_LISTITEM, LIS_HOT, L"HOT"},
    {LVP_LISTITEM, LIS_SELECTED, L"SELECTED"},
    {LVP_LISTITEM, LIS_DISABLED, L"DISABLED"},
    {LVP_LISTITEM, LIS_SELECTEDNOTFOCUS, L"SELECTEDNOTFOCUS"},
    {LVP_LISTGROUP, 0, L"LISTGROUP"},
    {LVP_LISTDETAIL, 0, L"LISTDETAIL"},
    {LVP_LISTSORTEDDETAIL, 0, L"LISTSORTEDDETAIL"},
    {LVP_EMPTYTEXT, 0, L"EMPTYTEXT"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classMenu[] = {
    {MP_MENUITEM, 0, L"MENUITEM"},
    {MP_MENUITEM, MS_NORMAL, L"NORMAL"},
    {MP_MENUITEM, MS_SELECTED, L"SELECTED"},
    {MP_MENUITEM, MS_DEMOTED, L"DEMOTED"},
    {MP_MENUDROPDOWN, 0, L"MENUDROPDOWN"},
    {MP_MENUDROPDOWN, MS_NORMAL, L"NORMAL"},
    {MP_MENUDROPDOWN, MS_SELECTED, L"SELECTED"},
    {MP_MENUDROPDOWN, MS_DEMOTED, L"DEMOTED"},
    {MP_MENUBARITEM, 0, L"MENUBARITEM"},
    {MP_MENUBARITEM, MS_NORMAL, L"NORMAL"},
    {MP_MENUBARITEM, MS_SELECTED, L"SELECTED"},
    {MP_MENUBARITEM, MS_DEMOTED, L"DEMOTED"},
    {MP_MENUBARDROPDOWN, 0, L"MENUBARDROPDOWN"},
    {MP_MENUBARDROPDOWN, MS_NORMAL, L"NORMAL"},
    {MP_MENUBARDROPDOWN, MS_SELECTED, L"SELECTED"},
    {MP_MENUBARDROPDOWN, MS_DEMOTED, L"DEMOTED"},
    {MP_CHEVRON, 0, L"CHEVRON"},
    {MP_CHEVRON, MS_NORMAL, L"NORMAL"},
    {MP_CHEVRON, MS_SELECTED, L"SELECTED"},
    {MP_CHEVRON, MS_DEMOTED, L"DEMOTED"},
    {MP_SEPARATOR, 0, L"SEPARATOR"},
    {MP_SEPARATOR, MS_NORMAL, L"NORMAL"},
    {MP_SEPARATOR, MS_SELECTED, L"SELECTED"},
    {MP_SEPARATOR, MS_DEMOTED, L"DEMOTED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classMenuband[] = {
    {MDP_NEWAPPBUTTON, 0, L"NEWAPPBUTTON"},
    {MDP_NEWAPPBUTTON, MDS_NORMAL, L"NORMAL"},
    {MDP_NEWAPPBUTTON, MDS_HOT, L"HOT"},
    {MDP_NEWAPPBUTTON, MDS_PRESSED, L"PRESSED"},
    {MDP_NEWAPPBUTTON, MDS_DISABLED, L"DISABLED"},
    {MDP_NEWAPPBUTTON, MDS_CHECKED, L"CHECKED"},
    {MDP_NEWAPPBUTTON, MDS_HOTCHECKED, L"HOTCHECKED"},
    {MDP_SEPERATOR, 0, L"SEPERATOR"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classPage[] = {
    {PGRP_UP, 0, L"UP"},
    {PGRP_UP, UPS_NORMAL, L"NORMAL"},
    {PGRP_UP, UPS_HOT, L"HOT"},
    {PGRP_UP, UPS_PRESSED, L"PRESSED"},
    {PGRP_UP, UPS_DISABLED, L"DISABLED"},
    {PGRP_DOWN, 0, L"DOWN"},
    {PGRP_DOWN, DNS_NORMAL, L"NORMAL"},
    {PGRP_DOWN, DNS_HOT, L"HOT"},
    {PGRP_DOWN, DNS_PRESSED, L"PRESSED"},
    {PGRP_DOWN, DNS_DISABLED, L"DISABLED"},
    {PGRP_UPHORZ, 0, L"UPHORZ"},
    {PGRP_UPHORZ, UPHZS_NORMAL, L"NORMAL"},
    {PGRP_UPHORZ, UPHZS_HOT, L"HOT"},
    {PGRP_UPHORZ, UPHZS_PRESSED, L"PRESSED"},
    {PGRP_UPHORZ, UPHZS_DISABLED, L"DISABLED"},
    {PGRP_DOWNHORZ, 0, L"DOWNHORZ"},
    {PGRP_DOWNHORZ, DNHZS_NORMAL, L"NORMAL"},
    {PGRP_DOWNHORZ, DNHZS_HOT, L"HOT"},
    {PGRP_DOWNHORZ, DNHZS_PRESSED, L"PRESSED"},
    {PGRP_DOWNHORZ, DNHZS_DISABLED, L"DISABLED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classProgress[] = {
    {PP_BAR, 0, L"BAR"},
    {PP_BARVERT, 0, L"BARVERT"},
    {PP_CHUNK, 0, L"CHUNK"},
    {PP_CHUNKVERT, 0, L"CHUNKVERT"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classRebar[] = {
    {RP_GRIPPER, 0, L"GRIPPER"},
    {RP_GRIPPERVERT, 0, L"GRIPPERVERT"},
    {RP_BAND, 0, L"BAND"},
    {RP_CHEVRON, 0, L"CHEVRON"},
    {RP_CHEVRON, CHEVS_NORMAL, L"NORMAL"},
    {RP_CHEVRON, CHEVS_HOT, L"HOT"},
    {RP_CHEVRON, CHEVS_PRESSED, L"PRESSED"},
    {RP_CHEVRONVERT, 0, L"CHEVRONVERT"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classScrollbar[] = {
    {SBP_ARROWBTN, 0, L"ARROWBTN"},
    {SBP_ARROWBTN, ABS_UPNORMAL, L"UPNORMAL"},
    {SBP_ARROWBTN, ABS_UPHOT, L"UPHOT"},
    {SBP_ARROWBTN, ABS_UPPRESSED, L"UPPRESSED"},
    {SBP_ARROWBTN, ABS_UPDISABLED, L"UPDISABLED"},
    {SBP_ARROWBTN, ABS_DOWNNORMAL, L"DOWNNORMAL"},
    {SBP_ARROWBTN, ABS_DOWNHOT, L"DOWNHOT"},
    {SBP_ARROWBTN, ABS_DOWNPRESSED, L"DOWNPRESSED"},
    {SBP_ARROWBTN, ABS_DOWNDISABLED, L"DOWNDISABLED"},
    {SBP_ARROWBTN, ABS_LEFTNORMAL, L"LEFTNORMAL"},
    {SBP_ARROWBTN, ABS_LEFTHOT, L"LEFTHOT"},
    {SBP_ARROWBTN, ABS_LEFTPRESSED, L"LEFTPRESSED"},
    {SBP_ARROWBTN, ABS_LEFTDISABLED, L"LEFTDISABLED"},
    {SBP_ARROWBTN, ABS_RIGHTNORMAL, L"RIGHTNORMAL"},
    {SBP_ARROWBTN, ABS_RIGHTHOT, L"RIGHTHOT"},
    {SBP_ARROWBTN, ABS_RIGHTPRESSED, L"RIGHTPRESSED"},
    {SBP_ARROWBTN, ABS_RIGHTDISABLED, L"RIGHTDISABLED"},
    {SBP_THUMBBTNHORZ, 0, L"THUMBBTNHORZ"},
    {SBP_THUMBBTNHORZ, SCRBS_NORMAL, L"NORMAL"},
    {SBP_THUMBBTNHORZ, SCRBS_HOT, L"HOT"},
    {SBP_THUMBBTNHORZ, SCRBS_PRESSED, L"PRESSED"},
    {SBP_THUMBBTNHORZ, SCRBS_DISABLED, L"DISABLED"},
    {SBP_THUMBBTNVERT, 0, L"THUMBBTNVERT"},
    {SBP_THUMBBTNVERT, SCRBS_NORMAL, L"NORMAL"},
    {SBP_THUMBBTNVERT, SCRBS_HOT, L"HOT"},
    {SBP_THUMBBTNVERT, SCRBS_PRESSED, L"PRESSED"},
    {SBP_THUMBBTNVERT, SCRBS_DISABLED, L"DISABLED"},
    {SBP_LOWERTRACKHORZ, 0, L"LOWERTRACKHORZ"},
    {SBP_LOWERTRACKHORZ, SCRBS_NORMAL, L"NORMAL"},
    {SBP_LOWERTRACKHORZ, SCRBS_HOT, L"HOT"},
    {SBP_LOWERTRACKHORZ, SCRBS_PRESSED, L"PRESSED"},
    {SBP_LOWERTRACKHORZ, SCRBS_DISABLED, L"DISABLED"},
    {SBP_UPPERTRACKHORZ, 0, L"UPPERTRACKHORZ"},
    {SBP_UPPERTRACKHORZ, SCRBS_NORMAL, L"NORMAL"},
    {SBP_UPPERTRACKHORZ, SCRBS_HOT, L"HOT"},
    {SBP_UPPERTRACKHORZ, SCRBS_PRESSED, L"PRESSED"},
    {SBP_UPPERTRACKHORZ, SCRBS_DISABLED, L"DISABLED"},
    {SBP_LOWERTRACKVERT, 0, L"LOWERTRACKVERT"},
    {SBP_LOWERTRACKVERT, SCRBS_NORMAL, L"NORMAL"},
    {SBP_LOWERTRACKVERT, SCRBS_HOT, L"HOT"},
    {SBP_LOWERTRACKVERT, SCRBS_PRESSED, L"PRESSED"},
    {SBP_LOWERTRACKVERT, SCRBS_DISABLED, L"DISABLED"},
    {SBP_UPPERTRACKVERT, 0, L"UPPERTRACKVERT"},
    {SBP_UPPERTRACKVERT, SCRBS_NORMAL, L"NORMAL"},
    {SBP_UPPERTRACKVERT, SCRBS_HOT, L"HOT"},
    {SBP_UPPERTRACKVERT, SCRBS_PRESSED, L"PRESSED"},
    {SBP_UPPERTRACKVERT, SCRBS_DISABLED, L"DISABLED"},
    {SBP_GRIPPERHORZ, 0, L"GRIPPERHORZ"},
    {SBP_GRIPPERVERT, 0, L"GRIPPERVERT"},
    {SBP_SIZEBOX, 0, L"SIZEBOX"},
    {SBP_SIZEBOX, SZB_RIGHTALIGN, L"RIGHTALIGN"},
    {SBP_SIZEBOX, SZB_LEFTALIGN, L"LEFTALIGN"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classSpin[] = {
    {SPNP_UP, 0, L"UP"},
    {SPNP_UP, UPS_NORMAL, L"NORMAL"},
    {SPNP_UP, UPS_HOT, L"HOT"},
    {SPNP_UP, UPS_PRESSED, L"PRESSED"},
    {SPNP_UP, UPS_DISABLED, L"DISABLED"},
    {SPNP_DOWN, 0, L"DOWN"},
    {SPNP_DOWN, DNS_NORMAL, L"NORMAL"},
    {SPNP_DOWN, DNS_HOT, L"HOT"},
    {SPNP_DOWN, DNS_PRESSED, L"PRESSED"},
    {SPNP_DOWN, DNS_DISABLED, L"DISABLED"},
    {SPNP_UPHORZ, 0, L"UPHORZ"},
    {SPNP_UPHORZ, UPHZS_NORMAL, L"NORMAL"},
    {SPNP_UPHORZ, UPHZS_HOT, L"HOT"},
    {SPNP_UPHORZ, UPHZS_PRESSED, L"PRESSED"},
    {SPNP_UPHORZ, UPHZS_DISABLED, L"DISABLED"},
    {SPNP_DOWNHORZ, 0, L"DOWNHORZ"},
    {SPNP_DOWNHORZ, DNHZS_NORMAL, L"NORMAL"},
    {SPNP_DOWNHORZ, DNHZS_HOT, L"HOT"},
    {SPNP_DOWNHORZ, DNHZS_PRESSED, L"PRESSED"},
    {SPNP_DOWNHORZ, DNHZS_DISABLED, L"DISABLED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classStartpanel[] = {
    {SPP_USERPANE, 0, L"USERPANE"},
    {SPP_MOREPROGRAMS, 0, L"MOREPROGRAMS"},
    {SPP_MOREPROGRAMSARROW, 0, L"MOREPROGRAMSARROW"},
    {SPP_MOREPROGRAMSARROW, SPS_NORMAL, L"NORMAL"},
    {SPP_MOREPROGRAMSARROW, SPS_HOT, L"HOT"},
    {SPP_MOREPROGRAMSARROW, SPS_PRESSED, L"PRESSED"},
    {SPP_PROGLIST, 0, L"PROGLIST"},
    {SPP_PROGLISTSEPARATOR, 0, L"PROGLISTSEPARATOR"},
    {SPP_PLACESLIST, 0, L"PLACESLIST"},
    {SPP_PLACESLISTSEPARATOR, 0, L"PLACESLISTSEPARATOR"},
    {SPP_LOGOFF, 0, L"LOGOFF"},
    {SPP_LOGOFFBUTTONS, 0, L"LOGOFFBUTTONS"},
    {SPP_LOGOFFBUTTONS, SPLS_NORMAL, L"NORMAL"},
    {SPP_LOGOFFBUTTONS, SPLS_HOT, L"HOT"},
    {SPP_LOGOFFBUTTONS, SPLS_PRESSED, L"PRESSED"},
    {SPP_USERPICTURE, 0, L"USERPICTURE"},
    {SPP_PREVIEW, 0, L"PREVIEW"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classStatus[] = {
    {SP_PANE, 0, L"PANE"},
    {SP_GRIPPERPANE, 0, L"GRIPPERPANE"},
    {SP_GRIPPER, 0, L"GRIPPER"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classTab[] = {
    {TABP_TABITEM, 0, L"TABITEM"},
    {TABP_TABITEM, TIS_NORMAL, L"NORMAL"},
    {TABP_TABITEM, TIS_HOT, L"HOT"},
    {TABP_TABITEM, TIS_SELECTED, L"SELECTED"},
    {TABP_TABITEM, TIS_DISABLED, L"DISABLED"},
    {TABP_TABITEM, TIS_FOCUSED, L"FOCUSED"},
    {TABP_TABITEMLEFTEDGE, 0, L"TABITEMLEFTEDGE"},
    {TABP_TABITEMLEFTEDGE, TILES_NORMAL, L"NORMAL"},
    {TABP_TABITEMLEFTEDGE, TILES_HOT, L"HOT"},
    {TABP_TABITEMLEFTEDGE, TILES_SELECTED, L"SELECTED"},
    {TABP_TABITEMLEFTEDGE, TILES_DISABLED, L"DISABLED"},
    {TABP_TABITEMLEFTEDGE, TILES_FOCUSED, L"FOCUSED"},
    {TABP_TABITEMRIGHTEDGE, 0, L"TABITEMRIGHTEDGE"},
    {TABP_TABITEMRIGHTEDGE, TIRES_NORMAL, L"NORMAL"},
    {TABP_TABITEMRIGHTEDGE, TIRES_HOT, L"HOT"},
    {TABP_TABITEMRIGHTEDGE, TIRES_SELECTED, L"SELECTED"},
    {TABP_TABITEMRIGHTEDGE, TIRES_DISABLED, L"DISABLED"},
    {TABP_TABITEMRIGHTEDGE, TIRES_FOCUSED, L"FOCUSED"},
    {TABP_TABITEMBOTHEDGE, 0, L"TABITEMBOTHEDGE"},
    {TABP_TABITEMBOTHEDGE, TIBES_NORMAL, L"NORMAL"},
    {TABP_TABITEMBOTHEDGE, TIBES_HOT, L"HOT"},
    {TABP_TABITEMBOTHEDGE, TIBES_SELECTED, L"SELECTED"},
    {TABP_TABITEMBOTHEDGE, TIBES_DISABLED, L"DISABLED"},
    {TABP_TABITEMBOTHEDGE, TIBES_FOCUSED, L"FOCUSED"},
    {TABP_TOPTABITEM, 0, L"TOPTABITEM"},
    {TABP_TOPTABITEM, TTIS_NORMAL, L"NORMAL"},
    {TABP_TOPTABITEM, TTIS_HOT, L"HOT"},
    {TABP_TOPTABITEM, TTIS_SELECTED, L"SELECTED"},
    {TABP_TOPTABITEM, TTIS_DISABLED, L"DISABLED"},
    {TABP_TOPTABITEM, TTIS_FOCUSED, L"FOCUSED"},
    {TABP_TOPTABITEMLEFTEDGE, 0, L"TOPTABITEMLEFTEDGE"},
    {TABP_TOPTABITEMLEFTEDGE, TTILES_NORMAL, L"NORMAL"},
    {TABP_TOPTABITEMLEFTEDGE, TTILES_HOT, L"HOT"},
    {TABP_TOPTABITEMLEFTEDGE, TTILES_SELECTED, L"SELECTED"},
    {TABP_TOPTABITEMLEFTEDGE, TTILES_DISABLED, L"DISABLED"},
    {TABP_TOPTABITEMLEFTEDGE, TTILES_FOCUSED, L"FOCUSED"},
    {TABP_TOPTABITEMRIGHTEDGE, 0, L"TOPTABITEMRIGHTEDGE"},
    {TABP_TOPTABITEMRIGHTEDGE, TTIRES_NORMAL, L"NORMAL"},
    {TABP_TOPTABITEMRIGHTEDGE, TTIRES_HOT, L"HOT"},
    {TABP_TOPTABITEMRIGHTEDGE, TTIRES_SELECTED, L"SELECTED"},
    {TABP_TOPTABITEMRIGHTEDGE, TTIRES_DISABLED, L"DISABLED"},
    {TABP_TOPTABITEMRIGHTEDGE, TTIRES_FOCUSED, L"FOCUSED"},
    {TABP_TOPTABITEMBOTHEDGE, 0, L"TOPTABITEMBOTHEDGE"},
    {TABP_TOPTABITEMBOTHEDGE, TTIBES_NORMAL, L"NORMAL"},
    {TABP_TOPTABITEMBOTHEDGE, TTIBES_HOT, L"HOT"},
    {TABP_TOPTABITEMBOTHEDGE, TTIBES_SELECTED, L"SELECTED"},
    {TABP_TOPTABITEMBOTHEDGE, TTIBES_DISABLED, L"DISABLED"},
    {TABP_TOPTABITEMBOTHEDGE, TTIBES_FOCUSED, L"FOCUSED"},
    {TABP_PANE, 0, L"PANE"},
    {TABP_BODY, 0, L"BODY"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classTaskband[] = {
    {TDP_GROUPCOUNT, 0, L"GROUPCOUNT"},
    {TDP_FLASHBUTTON, 0, L"FLASHBUTTON"},
    {TDP_FLASHBUTTONGROUPMENU, 0, L"FLASHBUTTONGROUPMENU"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classTaskbar[] = {
    {TBP_BACKGROUNDBOTTOM, 0, L"BACKGROUNDBOTTOM"},
    {TBP_BACKGROUNDRIGHT, 0, L"BACKGROUNDRIGHT"},
    {TBP_BACKGROUNDTOP, 0, L"BACKGROUNDTOP"},
    {TBP_BACKGROUNDLEFT, 0, L"BACKGROUNDLEFT"},
    {TBP_SIZINGBARBOTTOM, 0, L"SIZINGBARBOTTOM"},
    {TBP_SIZINGBARRIGHT, 0, L"SIZINGBARRIGHT"},
    {TBP_SIZINGBARTOP, 0, L"SIZINGBARTOP"},
    {TBP_SIZINGBARLEFT, 0, L"SIZINGBARLEFT"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classToolbar[] = {
    {TP_BUTTON, 0, L"BUTTON"},
    {TP_BUTTON, TS_NORMAL, L"NORMAL"},
    {TP_BUTTON, TS_HOT, L"HOT"},
    {TP_BUTTON, TS_PRESSED, L"PRESSED"},
    {TP_BUTTON, TS_DISABLED, L"DISABLED"},
    {TP_BUTTON, TS_CHECKED, L"CHECKED"},
    {TP_BUTTON, TS_HOTCHECKED, L"HOTCHECKED"},
    {TP_DROPDOWNBUTTON, 0, L"DROPDOWNBUTTON"},
    {TP_DROPDOWNBUTTON, TS_NORMAL, L"NORMAL"},
    {TP_DROPDOWNBUTTON, TS_HOT, L"HOT"},
    {TP_DROPDOWNBUTTON, TS_PRESSED, L"PRESSED"},
    {TP_DROPDOWNBUTTON, TS_DISABLED, L"DISABLED"},
    {TP_DROPDOWNBUTTON, TS_CHECKED, L"CHECKED"},
    {TP_DROPDOWNBUTTON, TS_HOTCHECKED, L"HOTCHECKED"},
    {TP_SPLITBUTTON, 0, L"SPLITBUTTON"},
    {TP_SPLITBUTTON, TS_NORMAL, L"NORMAL"},
    {TP_SPLITBUTTON, TS_HOT, L"HOT"},
    {TP_SPLITBUTTON, TS_PRESSED, L"PRESSED"},
    {TP_SPLITBUTTON, TS_DISABLED, L"DISABLED"},
    {TP_SPLITBUTTON, TS_CHECKED, L"CHECKED"},
    {TP_SPLITBUTTON, TS_HOTCHECKED, L"HOTCHECKED"},
    {TP_SPLITBUTTONDROPDOWN, 0, L"SPLITBUTTONDROPDOWN"},
    {TP_SPLITBUTTONDROPDOWN, TS_NORMAL, L"NORMAL"},
    {TP_SPLITBUTTONDROPDOWN, TS_HOT, L"HOT"},
    {TP_SPLITBUTTONDROPDOWN, TS_PRESSED, L"PRESSED"},
    {TP_SPLITBUTTONDROPDOWN, TS_DISABLED, L"DISABLED"},
    {TP_SPLITBUTTONDROPDOWN, TS_CHECKED, L"CHECKED"},
    {TP_SPLITBUTTONDROPDOWN, TS_HOTCHECKED, L"HOTCHECKED"},
    {TP_SEPARATOR, 0, L"SEPARATOR"},
    {TP_SEPARATOR, TS_NORMAL, L"NORMAL"},
    {TP_SEPARATOR, TS_HOT, L"HOT"},
    {TP_SEPARATOR, TS_PRESSED, L"PRESSED"},
    {TP_SEPARATOR, TS_DISABLED, L"DISABLED"},
    {TP_SEPARATOR, TS_CHECKED, L"CHECKED"},
    {TP_SEPARATOR, TS_HOTCHECKED, L"HOTCHECKED"},
    {TP_SEPARATORVERT, 0, L"SEPARATORVERT"},
    {TP_SEPARATORVERT, TS_NORMAL, L"NORMAL"},
    {TP_SEPARATORVERT, TS_HOT, L"HOT"},
    {TP_SEPARATORVERT, TS_PRESSED, L"PRESSED"},
    {TP_SEPARATORVERT, TS_DISABLED, L"DISABLED"},
    {TP_SEPARATORVERT, TS_CHECKED, L"CHECKED"},
    {TP_SEPARATORVERT, TS_HOTCHECKED, L"HOTCHECKED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classTooltip[] = {
    {TTP_STANDARD, 0, L"STANDARD"},
    {TTP_STANDARD, TTSS_NORMAL, L"NORMAL"},
    {TTP_STANDARD, TTSS_LINK, L"LINK"},
    {TTP_STANDARDTITLE, 0, L"STANDARDTITLE"},
    {TTP_STANDARDTITLE, TTSS_NORMAL, L"NORMAL"},
    {TTP_STANDARDTITLE, TTSS_LINK, L"LINK"},
    {TTP_BALLOON, 0, L"BALLOON"},
    {TTP_BALLOON, TTBS_NORMAL, L"NORMAL"},
    {TTP_BALLOON, TTBS_LINK, L"LINK"},
    {TTP_BALLOONTITLE, 0, L"BALLOONTITLE"},
    {TTP_BALLOONTITLE, TTBS_NORMAL, L"NORMAL"},
    {TTP_BALLOONTITLE, TTBS_LINK, L"LINK"},
    {TTP_CLOSE, 0, L"CLOSE"},
    {TTP_CLOSE, TTCS_NORMAL, L"NORMAL"},
    {TTP_CLOSE, TTCS_HOT, L"HOT"},
    {TTP_CLOSE, TTCS_PRESSED, L"PRESSED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classTrackbar[] = {
    {TKP_TRACK, 0, L"TRACK"},
    {TKP_TRACK, TRS_NORMAL, L"NORMAL"},
    {TKP_TRACKVERT, 0, L"TRACKVERT"},
    {TKP_TRACKVERT, TRVS_NORMAL, L"NORMAL"},
    {TKP_THUMB, 0, L"THUMB"},
    {TKP_THUMB, TUS_NORMAL, L"NORMAL"},
    {TKP_THUMB, TUS_HOT, L"HOT"},
    {TKP_THUMB, TUS_PRESSED, L"PRESSED"},
    {TKP_THUMB, TUS_FOCUSED, L"FOCUSED"},
    {TKP_THUMB, TUS_DISABLED, L"DISABLED"},
    {TKP_THUMBBOTTOM, 0, L"THUMBBOTTOM"},
    {TKP_THUMBBOTTOM, TUBS_NORMAL, L"NORMAL"},
    {TKP_THUMBBOTTOM, TUBS_HOT, L"HOT"},
    {TKP_THUMBBOTTOM, TUBS_PRESSED, L"PRESSED"},
    {TKP_THUMBBOTTOM, TUBS_FOCUSED, L"FOCUSED"},
    {TKP_THUMBBOTTOM, TUBS_DISABLED, L"DISABLED"},
    {TKP_THUMBTOP, 0, L"THUMBTOP"},
    {TKP_THUMBTOP, TUTS_NORMAL, L"NORMAL"},
    {TKP_THUMBTOP, TUTS_HOT, L"HOT"},
    {TKP_THUMBTOP, TUTS_PRESSED, L"PRESSED"},
    {TKP_THUMBTOP, TUTS_FOCUSED, L"FOCUSED"},
    {TKP_THUMBTOP, TUTS_DISABLED, L"DISABLED"},
    {TKP_THUMBVERT, 0, L"THUMBVERT"},
    {TKP_THUMBVERT, TUVS_NORMAL, L"NORMAL"},
    {TKP_THUMBVERT, TUVS_HOT, L"HOT"},
    {TKP_THUMBVERT, TUVS_PRESSED, L"PRESSED"},
    {TKP_THUMBVERT, TUVS_FOCUSED, L"FOCUSED"},
    {TKP_THUMBVERT, TUVS_DISABLED, L"DISABLED"},
    {TKP_THUMBLEFT, 0, L"THUMBLEFT"},
    {TKP_THUMBLEFT, TUVLS_NORMAL, L"NORMAL"},
    {TKP_THUMBLEFT, TUVLS_HOT, L"HOT"},
    {TKP_THUMBLEFT, TUVLS_PRESSED, L"PRESSED"},
    {TKP_THUMBLEFT, TUVLS_FOCUSED, L"FOCUSED"},
    {TKP_THUMBLEFT, TUVLS_DISABLED, L"DISABLED"},
    {TKP_THUMBRIGHT, 0, L"THUMBRIGHT"},
    {TKP_THUMBRIGHT, TUVRS_NORMAL, L"NORMAL"},
    {TKP_THUMBRIGHT, TUVRS_HOT, L"HOT"},
    {TKP_THUMBRIGHT, TUVRS_PRESSED, L"PRESSED"},
    {TKP_THUMBRIGHT, TUVRS_FOCUSED, L"FOCUSED"},
    {TKP_THUMBRIGHT, TUVRS_DISABLED, L"DISABLED"},
    {TKP_TICS, 0, L"TICS"},
    {TKP_TICS, TSS_NORMAL, L"NORMAL"},
    {TKP_TICSVERT, 0, L"TICSVERT"},
    {TKP_TICSVERT, TSVS_NORMAL, L"NORMAL"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classTraynotify[] = {
    {TNP_BACKGROUND, 0, L"BACKGROUND"},
    {TNP_ANIMBACKGROUND, 0, L"ANIMBACKGROUND"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classTreeview[] = {
    {TVP_TREEITEM, 0, L"TREEITEM"},
    {TVP_TREEITEM, TREIS_NORMAL, L"NORMAL"},
    {TVP_TREEITEM, TREIS_HOT, L"HOT"},
    {TVP_TREEITEM, TREIS_SELECTED, L"SELECTED"},
    {TVP_TREEITEM, TREIS_DISABLED, L"DISABLED"},
    {TVP_TREEITEM, TREIS_SELECTEDNOTFOCUS, L"SELECTEDNOTFOCUS"},
    {TVP_GLYPH, 0, L"GLYPH"},
    {TVP_GLYPH, GLPS_CLOSED, L"CLOSED"},
    {TVP_GLYPH, GLPS_OPENED, L"OPENED"},
    {TVP_BRANCH, 0, L"BRANCH"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classWindow[] = {
    {WP_CAPTION, 0, L"CAPTION"},
    {WP_CAPTION, CS_ACTIVE, L"ACTIVE"},
    {WP_CAPTION, CS_INACTIVE, L"INACTIVE"},
    {WP_CAPTION, CS_DISABLED, L"DISABLED"},
    {WP_SMALLCAPTION, 0, L"SMALLCAPTION"},
    {WP_SMALLCAPTION, CS_ACTIVE, L"ACTIVE"},
    {WP_SMALLCAPTION, CS_INACTIVE, L"INACTIVE"},
    {WP_SMALLCAPTION, CS_DISABLED, L"DISABLED"},
    {WP_MINCAPTION, 0, L"MINCAPTION"},
    {WP_MINCAPTION, MNCS_ACTIVE, L"ACTIVE"},
    {WP_MINCAPTION, MNCS_INACTIVE, L"INACTIVE"},
    {WP_MINCAPTION, MNCS_DISABLED, L"DISABLED"},
    {WP_SMALLMINCAPTION, 0, L"SMALLMINCAPTION"},
    {WP_SMALLMINCAPTION, MNCS_ACTIVE, L"ACTIVE"},
    {WP_SMALLMINCAPTION, MNCS_INACTIVE, L"INACTIVE"},
    {WP_SMALLMINCAPTION, MNCS_DISABLED, L"DISABLED"},
    {WP_MAXCAPTION, 0, L"MAXCAPTION"},
    {WP_MAXCAPTION, MXCS_ACTIVE, L"ACTIVE"},
    {WP_MAXCAPTION, MXCS_INACTIVE, L"INACTIVE"},
    {WP_MAXCAPTION, MXCS_DISABLED, L"DISABLED"},
    {WP_SMALLMAXCAPTION, 0, L"SMALLMAXCAPTION"},
    {WP_SMALLMAXCAPTION, MXCS_ACTIVE, L"ACTIVE"},
    {WP_SMALLMAXCAPTION, MXCS_INACTIVE, L"INACTIVE"},
    {WP_SMALLMAXCAPTION, MXCS_DISABLED, L"DISABLED"},
    {WP_FRAMELEFT, 0, L"FRAMELEFT"},
    {WP_FRAMELEFT, FS_ACTIVE, L"ACTIVE"},
    {WP_FRAMELEFT, FS_INACTIVE, L"INACTIVE"},
    {WP_FRAMERIGHT, 0, L"FRAMERIGHT"},
    {WP_FRAMERIGHT, FS_ACTIVE, L"ACTIVE"},
    {WP_FRAMERIGHT, FS_INACTIVE, L"INACTIVE"},
    {WP_FRAMEBOTTOM, 0, L"FRAMEBOTTOM"},
    {WP_FRAMEBOTTOM, FS_ACTIVE, L"ACTIVE"},
    {WP_FRAMEBOTTOM, FS_INACTIVE, L"INACTIVE"},
    {WP_SMALLFRAMELEFT, 0, L"SMALLFRAMELEFT"},
    {WP_SMALLFRAMELEFT, FS_ACTIVE, L"ACTIVE"},
    {WP_SMALLFRAMELEFT, FS_INACTIVE, L"INACTIVE"},
    {WP_SMALLFRAMERIGHT, 0, L"SMALLFRAMERIGHT"},
    {WP_SMALLFRAMERIGHT, FS_ACTIVE, L"ACTIVE"},
    {WP_SMALLFRAMERIGHT, FS_INACTIVE, L"INACTIVE"},
    {WP_SMALLFRAMEBOTTOM, 0, L"SMALLFRAMEBOTTOM"},
    {WP_SMALLFRAMEBOTTOM, FS_ACTIVE, L"ACTIVE"},
    {WP_SMALLFRAMEBOTTOM, FS_INACTIVE, L"INACTIVE"},
    {WP_SYSBUTTON, 0, L"SYSBUTTON"},
    {WP_SYSBUTTON, SBS_NORMAL, L"NORMAL"},
    {WP_SYSBUTTON, SBS_HOT, L"HOT"},
    {WP_SYSBUTTON, SBS_PUSHED, L"PUSHED"},
    {WP_SYSBUTTON, SBS_DISABLED, L"DISABLED"},
    {WP_MDISYSBUTTON, 0, L"MDISYSBUTTON"},
    {WP_MDISYSBUTTON, SBS_NORMAL, L"NORMAL"},
    {WP_MDISYSBUTTON, SBS_HOT, L"HOT"},
    {WP_MDISYSBUTTON, SBS_PUSHED, L"PUSHED"},
    {WP_MDISYSBUTTON, SBS_DISABLED, L"DISABLED"},
    {WP_MINBUTTON, 0, L"MINBUTTON"},
    {WP_MINBUTTON, MINBS_NORMAL, L"NORMAL"},
    {WP_MINBUTTON, MINBS_HOT, L"HOT"},
    {WP_MINBUTTON, MINBS_PUSHED, L"PUSHED"},
    {WP_MINBUTTON, MINBS_DISABLED, L"DISABLED"},
    {WP_MDIMINBUTTON, 0, L"MDIMINBUTTON"},
    {WP_MDIMINBUTTON, MINBS_NORMAL, L"NORMAL"},
    {WP_MDIMINBUTTON, MINBS_HOT, L"HOT"},
    {WP_MDIMINBUTTON, MINBS_PUSHED, L"PUSHED"},
    {WP_MDIMINBUTTON, MINBS_DISABLED, L"DISABLED"},
    {WP_MAXBUTTON, 0, L"MAXBUTTON"},
    {WP_MAXBUTTON, MAXBS_NORMAL, L"NORMAL"},
    {WP_MAXBUTTON, MAXBS_HOT, L"HOT"},
    {WP_MAXBUTTON, MAXBS_PUSHED, L"PUSHED"},
    {WP_MAXBUTTON, MAXBS_DISABLED, L"DISABLED"},
    {WP_CLOSEBUTTON, 0, L"CLOSEBUTTON"},
    {WP_CLOSEBUTTON, CBS_NORMAL, L"NORMAL"},
    {WP_CLOSEBUTTON, CBS_HOT, L"HOT"},
    {WP_CLOSEBUTTON, CBS_PUSHED, L"PUSHED"},
    {WP_CLOSEBUTTON, CBS_DISABLED, L"DISABLED"},
    {WP_SMALLCLOSEBUTTON, 0, L"SMALLCLOSEBUTTON"},
    {WP_SMALLCLOSEBUTTON, CBS_NORMAL, L"NORMAL"},
    {WP_SMALLCLOSEBUTTON, CBS_HOT, L"HOT"},
    {WP_SMALLCLOSEBUTTON, CBS_PUSHED, L"PUSHED"},
    {WP_SMALLCLOSEBUTTON, CBS_DISABLED, L"DISABLED"},
    {WP_MDICLOSEBUTTON, 0, L"MDICLOSEBUTTON"},
    {WP_MDICLOSEBUTTON, CBS_NORMAL, L"NORMAL"},
    {WP_MDICLOSEBUTTON, CBS_HOT, L"HOT"},
    {WP_MDICLOSEBUTTON, CBS_PUSHED, L"PUSHED"},
    {WP_MDICLOSEBUTTON, CBS_DISABLED, L"DISABLED"},
    {WP_RESTOREBUTTON, 0, L"RESTOREBUTTON"},
    {WP_RESTOREBUTTON, RBS_NORMAL, L"NORMAL"},
    {WP_RESTOREBUTTON, RBS_HOT, L"HOT"},
    {WP_RESTOREBUTTON, RBS_PUSHED, L"PUSHED"},
    {WP_RESTOREBUTTON, RBS_DISABLED, L"DISABLED"},
    {WP_MDIRESTOREBUTTON, 0, L"MDIRESTOREBUTTON"},
    {WP_MDIRESTOREBUTTON, RBS_NORMAL, L"NORMAL"},
    {WP_MDIRESTOREBUTTON, RBS_HOT, L"HOT"},
    {WP_MDIRESTOREBUTTON, RBS_PUSHED, L"PUSHED"},
    {WP_MDIRESTOREBUTTON, RBS_DISABLED, L"DISABLED"},
    {WP_HELPBUTTON, 0, L"HELPBUTTON"},
    {WP_HELPBUTTON, HBS_NORMAL, L"NORMAL"},
    {WP_HELPBUTTON, HBS_HOT, L"HOT"},
    {WP_HELPBUTTON, HBS_PUSHED, L"PUSHED"},
    {WP_HELPBUTTON, HBS_DISABLED, L"DISABLED"},
    {WP_MDIHELPBUTTON, 0, L"MDIHELPBUTTON"},
    {WP_MDIHELPBUTTON, HBS_NORMAL, L"NORMAL"},
    {WP_MDIHELPBUTTON, HBS_HOT, L"HOT"},
    {WP_MDIHELPBUTTON, HBS_PUSHED, L"PUSHED"},
    {WP_MDIHELPBUTTON, HBS_DISABLED, L"DISABLED"},
    {WP_HORZSCROLL, 0, L"HORZSCROLL"},
    {WP_HORZSCROLL, HSS_NORMAL, L"NORMAL"},
    {WP_HORZSCROLL, HSS_HOT, L"HOT"},
    {WP_HORZSCROLL, HSS_PUSHED, L"PUSHED"},
    {WP_HORZSCROLL, HSS_DISABLED, L"DISABLED"},
    {WP_HORZTHUMB, 0, L"HORZTHUMB"},
    {WP_HORZTHUMB, HTS_NORMAL, L"NORMAL"},
    {WP_HORZTHUMB, HTS_HOT, L"HOT"},
    {WP_HORZTHUMB, HTS_PUSHED, L"PUSHED"},
    {WP_HORZTHUMB, HTS_DISABLED, L"DISABLED"},
    {WP_VERTSCROLL, 0, L"VERTSCROLL"},
    {WP_VERTSCROLL, VSS_NORMAL, L"NORMAL"},
    {WP_VERTSCROLL, VSS_HOT, L"HOT"},
    {WP_VERTSCROLL, VSS_PUSHED, L"PUSHED"},
    {WP_VERTSCROLL, VSS_DISABLED, L"DISABLED"},
    {WP_VERTTHUMB, 0, L"VERTTHUMB"},
    {WP_VERTTHUMB, VTS_NORMAL, L"NORMAL"},
    {WP_VERTTHUMB, VTS_HOT, L"HOT"},
    {WP_VERTTHUMB, VTS_PUSHED, L"PUSHED"},
    {WP_VERTTHUMB, VTS_DISABLED, L"DISABLED"},
    {WP_DIALOG, 0, L"DIALOG"},
    {WP_CAPTIONSIZINGTEMPLATE, 0, L"CAPTIONSIZINGTEMPLATE"},
    {WP_SMALLCAPTIONSIZINGTEMPLATE, 0, L"SMALLCAPTIONSIZINGTEMPLATE"},
    {WP_FRAMELEFTSIZINGTEMPLATE, 0, L"FRAMELEFTSIZINGTEMPLATE"},
    {WP_SMALLFRAMELEFTSIZINGTEMPLATE, 0, L"SMALLFRAMELEFTSIZINGTEMPLATE"},
    {WP_FRAMERIGHTSIZINGTEMPLATE, 0, L"FRAMERIGHTSIZINGTEMPLATE"},
    {WP_SMALLFRAMERIGHTSIZINGTEMPLATE, 0, L"SMALLFRAMERIGHTSIZINGTEMPLATE"},
    {WP_FRAMEBOTTOMSIZINGTEMPLATE, 0, L"FRAMEBOTTOMSIZINGTEMPLATE"},
    {WP_SMALLFRAMEBOTTOMSIZINGTEMPLATE, 0, L"SMALLFRAMEBOTTOMSIZINGTEMPLATE"},
    {0, 0, L""}
};

/* Map class names to part/state maps */
static const MSSTYLES_CLASS_NAME mapClass[] = {
    {classGlobals, L"GLOBALS"},
    {classButton, L"BUTTON"},
    {classClock, L"CLOCK"},
    {classCombobox, L"COMBOBOX"},
    {classEdit, L"EDIT"},
    {classExplorerbar, L"EXPLORERBAR"},
    {classHeader, L"HEADER"},
    {classListview, L"LISTVIEW"},
    {classMenu, L"MENU"},
    {classMenuband, L"MENUBAND"},
    {classPage, L"PAGE"},
    {classProgress, L"PROGRESS"},
    {classRebar, L"REBAR"},
    {classScrollbar, L"SCROLLBAR"},
    {classSpin, L"SPIN"},
    {classStartpanel, L"STARTPANEL"},
    {classStatus, L"STATUS"},
    {classTab, L"TAB"},
    {classTaskband, L"TASKBAND"},
    {classTaskbar, L"TASKBAR"},
    {classToolbar, L"TOOLBAR"},
    {classTooltip, L"TOOLTIP"},
    {classTrackbar, L"TRACKBAR"},
    {classTraynotify, L"TRAYNOTIFY"},
    {classTreeview, L"TREEVIEW"},
    {classWindow, L"WINDOW"}
};

BOOL MSSTYLES_LookupPartState(LPCWSTR pszClass, LPCWSTR pszPart, LPCWSTR pszState, int *iPartId, int *iStateId)
{
    unsigned int i;
    const MSSTYLES_CLASS_MAP *map;

    *iPartId = 0;
    *iStateId = 0;
    for(i=0; i<ARRAY_SIZE(mapClass); i++) {
        if(!lstrcmpiW(mapClass[i].pszClass, pszClass)) {
            map = mapClass[i].lpMap;
            if(pszPart) {
                do {
                    if(map->dwStateID == 0 && !lstrcmpiW(map->szName, pszPart)) {
                        *iPartId = map->dwPartID;
                        break;
                    }
                } while(*((++map)->szName));
            }
            if(pszState) {
                if(pszPart && *iPartId == 0) {
                    break;
                }
                do {
                    if(pszPart) {
                        if(map->dwPartID == *iPartId && !lstrcmpiW(map->szName, pszState)) {
                            *iStateId = map->dwStateID;
                            break;
                        }
                    }
                    else {
                        if(!lstrcmpiW(map->szName, pszState)) {
                            *iStateId = map->dwStateID;
                            break;
                        }
                    }
                } while(*((++map)->szName));
            }
            break;
        }
    }
    if(pszPart && *iPartId == 0) {
        return FALSE;
    }
    if(pszState && *iStateId == 0) {
        return FALSE;
    }
    return TRUE;
}

/**********************************************************************
 *      MSSTYLES_LookupProperty
 *
 * Find a property ID from name
 *
 * PARAMS
 *     pszPropertyName     Name of property to lookup
 *     dwPrimitive         Location to store primitive type of property
 *     dwId                Location to store ID of property
 *
 * RETURNS
 *     FALSE if value is not found, TRUE otherwise
 */
BOOL MSSTYLES_LookupProperty(LPCWSTR pszPropertyName, int *dwPrimitive, int *dwId)
{
    DWORD item = 0;
    do {
        if(!lstrcmpiW(mapProperty[item].szPropertyName, pszPropertyName)) {
            if(dwPrimitive) *dwPrimitive = mapProperty[item].dwPrimitiveType;
            if(dwId) *dwId = mapProperty[item].dwPropertyID;
            return TRUE;
        }
    } while(*mapProperty[++item].szPropertyName);
    return FALSE;
}

/**********************************************************************
 *      MSSTYLES_LookupEnum
 *
 * Lookup the value for an enumeration
 *
 * PARAMS
 *     pszValueName        Value name to lookup
 *     dwEnum              Enumeration property ID to search
 *     dwValue             Location to store value
 *
 * RETURNS
 *     FALSE if value is not found, TRUE otherwise
 */
BOOL MSSTYLES_LookupEnum(LPCWSTR pszValueName, int dwEnum, int *dwValue)
{
    DWORD item = 0;
    /* Locate the enum block */
    while(*mapEnum[item].szValueName && mapEnum[item].dwEnum != dwEnum) item++;
    /* Now find the value in that block */
    while(*mapEnum[item].szValueName && mapEnum[item].dwEnum == dwEnum) {
        if(!lstrcmpiW(mapEnum[item].szValueName, pszValueName)) {
            if(dwValue) *dwValue = mapEnum[item].dwValue;
            return TRUE;
        }
        item++;
    }
    return FALSE;
}
