// Copyright 2012 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// ========================================================================

#ifndef OMAHA_GOOPDATE_APP_COMMAND_TEST_BASE_H__
#define OMAHA_GOOPDATE_APP_COMMAND_TEST_BASE_H__

#include <atlstr.h>

#include "omaha/goopdate/app_unittest_base.h"
#include "omaha/testing/unit_test.h"

namespace omaha {

class AppCommandTestBase : public AppTestBaseWithRegistryOverride {
 protected:
  AppCommandTestBase();

 public:
  static void CreateAppClientKey(const CString& guid, bool is_machine);
  static void DeleteAppClientKey(const CString& guid, bool is_machine);
  static void CreateLegacyCommand(const CString& guid,
                                  bool is_machine,
                                  const CString& cmd_id,
                                  const CString& cmd_line);
  static void CreateAutoRunOnOSUpgradeCommand(const CString& guid,
                                              bool is_machine,
                                              const CString& cmd_id,
                                              const CString& cmd_line);
  static void CreateCommand(const CString& guid,
                            bool is_machine,
                            const CString& cmd_id,
                            const CString& cmd_line);
  static void SetCommandValue(const CString& guid,
                              bool is_machine,
                              const CString& cmd_id,
                              const TCHAR* name,
                              const DWORD* value);
  static void CreateEmptyCommandKey(const CString& guid, bool is_machine);
};

}  // namespace omaha

#endif  // OMAHA_GOOPDATE_APP_COMMAND_TEST_BASE_H__
