use crate as pg_sys;
#[cfg(any(
    feature = "pg12",
    feature = "pg13",
    feature = "pg14",
    feature = "pg15",
    feature = "pg16"
))]
use crate::NullableDatum;
use crate::{Datum, Oid, PgNode};
#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") { 7 - (index % 8) } else { index % 8 };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") { 7 - (index % 8) } else { index % 8 };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index =
                    if cfg!(target_endian = "big") { bit_width as usize - 1 - i } else { i };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") { bit_width as usize - 1 - i } else { i };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
#[repr(C)]
pub struct __BindgenUnionField<T>(::std::marker::PhantomData<T>);
impl<T> __BindgenUnionField<T> {
    #[inline]
    pub const fn new() -> Self {
        __BindgenUnionField(::std::marker::PhantomData)
    }
    #[inline]
    pub unsafe fn as_ref(&self) -> &T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut(&mut self) -> &mut T {
        ::std::mem::transmute(self)
    }
}
impl<T> ::std::default::Default for __BindgenUnionField<T> {
    #[inline]
    fn default() -> Self {
        Self::new()
    }
}
impl<T> ::std::clone::Clone for __BindgenUnionField<T> {
    #[inline]
    fn clone(&self) -> Self {
        Self::new()
    }
}
impl<T> ::std::marker::Copy for __BindgenUnionField<T> {}
impl<T> ::std::fmt::Debug for __BindgenUnionField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__BindgenUnionField")
    }
}
impl<T> ::std::hash::Hash for __BindgenUnionField<T> {
    fn hash<H: ::std::hash::Hasher>(&self, _state: &mut H) {}
}
impl<T> ::std::cmp::PartialEq for __BindgenUnionField<T> {
    fn eq(&self, _other: &__BindgenUnionField<T>) -> bool {
        true
    }
}
impl<T> ::std::cmp::Eq for __BindgenUnionField<T> {}
pub const PG_DIAG_SEVERITY: u8 = 83u8;
pub const PG_DIAG_SEVERITY_NONLOCALIZED: u8 = 86u8;
pub const PG_DIAG_SQLSTATE: u8 = 67u8;
pub const PG_DIAG_MESSAGE_PRIMARY: u8 = 77u8;
pub const PG_DIAG_MESSAGE_DETAIL: u8 = 68u8;
pub const PG_DIAG_MESSAGE_HINT: u8 = 72u8;
pub const PG_DIAG_STATEMENT_POSITION: u8 = 80u8;
pub const PG_DIAG_INTERNAL_POSITION: u8 = 112u8;
pub const PG_DIAG_INTERNAL_QUERY: u8 = 113u8;
pub const PG_DIAG_CONTEXT: u8 = 87u8;
pub const PG_DIAG_SCHEMA_NAME: u8 = 115u8;
pub const PG_DIAG_TABLE_NAME: u8 = 116u8;
pub const PG_DIAG_COLUMN_NAME: u8 = 99u8;
pub const PG_DIAG_DATATYPE_NAME: u8 = 100u8;
pub const PG_DIAG_CONSTRAINT_NAME: u8 = 110u8;
pub const PG_DIAG_SOURCE_FILE: u8 = 70u8;
pub const PG_DIAG_SOURCE_LINE: u8 = 76u8;
pub const PG_DIAG_SOURCE_FUNCTION: u8 = 82u8;
pub const ALIGNOF_DOUBLE: u32 = 8;
pub const ALIGNOF_INT: u32 = 4;
pub const ALIGNOF_LONG: u32 = 8;
pub const ALIGNOF_PG_INT128_TYPE: u32 = 16;
pub const ALIGNOF_SHORT: u32 = 2;
pub const BLCKSZ: u32 = 8192;
pub const CONFIGURE_ARGS : & [u8 ; 109] = b" '--prefix=/home/zombodb/.pgrx/13.11/pgrx-install' '--with-pgport=28813' '--enable-debug' '--enable-cassert'\0" ;
pub const DEF_PGPORT: u32 = 28813;
pub const DEF_PGPORT_STR: &[u8; 6] = b"28813\0";
pub const ENABLE_THREAD_SAFETY: u32 = 1;
pub const HAVE_APPEND_HISTORY: u32 = 1;
pub const HAVE_ATOMICS: u32 = 1;
pub const HAVE_BACKTRACE_SYMBOLS: u32 = 1;
pub const HAVE_CLOCK_GETTIME: u32 = 1;
pub const HAVE_COMPUTED_GOTO: u32 = 1;
pub const HAVE_DECL_FDATASYNC: u32 = 1;
pub const HAVE_DECL_F_FULLFSYNC: u32 = 0;
pub const HAVE_DECL_POSIX_FADVISE: u32 = 1;
pub const HAVE_DECL_RTLD_GLOBAL: u32 = 1;
pub const HAVE_DECL_RTLD_NOW: u32 = 1;
pub const HAVE_DECL_STRLCAT: u32 = 0;
pub const HAVE_DECL_STRLCPY: u32 = 0;
pub const HAVE_DECL_STRNLEN: u32 = 1;
pub const HAVE_DECL_STRTOLL: u32 = 1;
pub const HAVE_DECL_STRTOULL: u32 = 1;
pub const HAVE_DLOPEN: u32 = 1;
pub const HAVE_EXECINFO_H: u32 = 1;
pub const HAVE_EXPLICIT_BZERO: u32 = 1;
pub const HAVE_FDATASYNC: u32 = 1;
pub const HAVE_FSEEKO: u32 = 1;
pub const HAVE_FUNCNAME__FUNC: u32 = 1;
pub const HAVE_GCC__ATOMIC_INT32_CAS: u32 = 1;
pub const HAVE_GCC__ATOMIC_INT64_CAS: u32 = 1;
pub const HAVE_GCC__SYNC_CHAR_TAS: u32 = 1;
pub const HAVE_GCC__SYNC_INT32_CAS: u32 = 1;
pub const HAVE_GCC__SYNC_INT32_TAS: u32 = 1;
pub const HAVE_GCC__SYNC_INT64_CAS: u32 = 1;
pub const HAVE_GETADDRINFO: u32 = 1;
pub const HAVE_GETHOSTBYNAME_R: u32 = 1;
pub const HAVE_GETIFADDRS: u32 = 1;
pub const HAVE_GETOPT: u32 = 1;
pub const HAVE_GETOPT_H: u32 = 1;
pub const HAVE_GETOPT_LONG: u32 = 1;
pub const HAVE_GETPWUID_R: u32 = 1;
pub const HAVE_GETRLIMIT: u32 = 1;
pub const HAVE_GETRUSAGE: u32 = 1;
pub const HAVE_HISTORY_TRUNCATE_FILE: u32 = 1;
pub const HAVE_IFADDRS_H: u32 = 1;
pub const HAVE_INET_ATON: u32 = 1;
pub const HAVE_INTTYPES_H: u32 = 1;
pub const HAVE_INT_OPTERR: u32 = 1;
pub const HAVE_INT_TIMEZONE: u32 = 1;
pub const HAVE_IPV6: u32 = 1;
pub const HAVE_LANGINFO_H: u32 = 1;
pub const HAVE_LIBM: u32 = 1;
pub const HAVE_LIBREADLINE: u32 = 1;
pub const HAVE_LIBZ: u32 = 1;
pub const HAVE_LINK: u32 = 1;
pub const HAVE_LOCALE_T: u32 = 1;
pub const HAVE_LONG_INT_64: u32 = 1;
pub const HAVE_MEMORY_H: u32 = 1;
pub const HAVE_MKDTEMP: u32 = 1;
pub const HAVE_NETINET_TCP_H: u32 = 1;
pub const HAVE_NET_IF_H: u32 = 1;
pub const HAVE_POLL: u32 = 1;
pub const HAVE_POLL_H: u32 = 1;
pub const HAVE_POSIX_FADVISE: u32 = 1;
pub const HAVE_POSIX_FALLOCATE: u32 = 1;
pub const HAVE_PPOLL: u32 = 1;
pub const HAVE_PREAD: u32 = 1;
pub const HAVE_PTHREAD: u32 = 1;
pub const HAVE_PTHREAD_PRIO_INHERIT: u32 = 1;
pub const HAVE_PWRITE: u32 = 1;
pub const HAVE_RANDOM: u32 = 1;
pub const HAVE_READLINE_HISTORY_H: u32 = 1;
pub const HAVE_READLINE_READLINE_H: u32 = 1;
pub const HAVE_READLINK: u32 = 1;
pub const HAVE_RL_COMPLETION_APPEND_CHARACTER: u32 = 1;
pub const HAVE_RL_COMPLETION_MATCHES: u32 = 1;
pub const HAVE_RL_COMPLETION_SUPPRESS_QUOTE: u32 = 1;
pub const HAVE_RL_FILENAME_COMPLETION_FUNCTION: u32 = 1;
pub const HAVE_RL_FILENAME_QUOTE_CHARACTERS: u32 = 1;
pub const HAVE_RL_FILENAME_QUOTING_FUNCTION: u32 = 1;
pub const HAVE_RL_RESET_SCREEN_SIZE: u32 = 1;
pub const HAVE_SETENV: u32 = 1;
pub const HAVE_SETSID: u32 = 1;
pub const HAVE_SHM_OPEN: u32 = 1;
pub const HAVE_SPINLOCKS: u32 = 1;
pub const HAVE_SRANDOM: u32 = 1;
pub const HAVE_STDBOOL_H: u32 = 1;
pub const HAVE_STDINT_H: u32 = 1;
pub const HAVE_STDLIB_H: u32 = 1;
pub const HAVE_STRCHRNUL: u32 = 1;
pub const HAVE_STRERROR_R: u32 = 1;
pub const HAVE_STRINGS_H: u32 = 1;
pub const HAVE_STRING_H: u32 = 1;
pub const HAVE_STRNLEN: u32 = 1;
pub const HAVE_STRSIGNAL: u32 = 1;
pub const HAVE_STRTOF: u32 = 1;
pub const HAVE_STRTOLL: u32 = 1;
pub const HAVE_STRTOULL: u32 = 1;
pub const HAVE_STRUCT_ADDRINFO: u32 = 1;
pub const HAVE_STRUCT_OPTION: u32 = 1;
pub const HAVE_STRUCT_SOCKADDR_STORAGE: u32 = 1;
pub const HAVE_STRUCT_SOCKADDR_STORAGE_SS_FAMILY: u32 = 1;
pub const HAVE_STRUCT_SOCKADDR_UN: u32 = 1;
pub const HAVE_STRUCT_TM_TM_ZONE: u32 = 1;
pub const HAVE_SYMLINK: u32 = 1;
pub const HAVE_SYNC_FILE_RANGE: u32 = 1;
pub const HAVE_SYSLOG: u32 = 1;
pub const HAVE_SYS_EPOLL_H: u32 = 1;
pub const HAVE_SYS_IPC_H: u32 = 1;
pub const HAVE_SYS_PERSONALITY_H: u32 = 1;
pub const HAVE_SYS_PRCTL_H: u32 = 1;
pub const HAVE_SYS_RESOURCE_H: u32 = 1;
pub const HAVE_SYS_SELECT_H: u32 = 1;
pub const HAVE_SYS_SEM_H: u32 = 1;
pub const HAVE_SYS_SHM_H: u32 = 1;
pub const HAVE_SYS_STAT_H: u32 = 1;
pub const HAVE_SYS_TYPES_H: u32 = 1;
pub const HAVE_SYS_UN_H: u32 = 1;
pub const HAVE_TERMIOS_H: u32 = 1;
pub const HAVE_TYPEOF: u32 = 1;
pub const HAVE_UNISTD_H: u32 = 1;
pub const HAVE_UNSETENV: u32 = 1;
pub const HAVE_USELOCALE: u32 = 1;
pub const HAVE_WCTYPE_H: u32 = 1;
pub const HAVE_X86_64_POPCNTQ: u32 = 1;
pub const HAVE__BOOL: u32 = 1;
pub const HAVE__BUILTIN_BSWAP16: u32 = 1;
pub const HAVE__BUILTIN_BSWAP32: u32 = 1;
pub const HAVE__BUILTIN_BSWAP64: u32 = 1;
pub const HAVE__BUILTIN_CLZ: u32 = 1;
pub const HAVE__BUILTIN_CONSTANT_P: u32 = 1;
pub const HAVE__BUILTIN_CTZ: u32 = 1;
pub const HAVE__BUILTIN_FRAME_ADDRESS: u32 = 1;
pub const HAVE__BUILTIN_OP_OVERFLOW: u32 = 1;
pub const HAVE__BUILTIN_POPCOUNT: u32 = 1;
pub const HAVE__BUILTIN_TYPES_COMPATIBLE_P: u32 = 1;
pub const HAVE__BUILTIN_UNREACHABLE: u32 = 1;
pub const HAVE__GET_CPUID: u32 = 1;
pub const HAVE__STATIC_ASSERT: u32 = 1;
pub const INT64_MODIFIER: &[u8; 2] = b"l\0";
pub const MAXIMUM_ALIGNOF: u32 = 8;
pub const MEMSET_LOOP_LIMIT: u32 = 1024;
pub const PACKAGE_BUGREPORT: &[u8; 32] = b"pgsql-bugs@lists.postgresql.org\0";
pub const PACKAGE_NAME: &[u8; 11] = b"PostgreSQL\0";
pub const PACKAGE_STRING: &[u8; 17] = b"PostgreSQL 13.11\0";
pub const PACKAGE_TARNAME: &[u8; 11] = b"postgresql\0";
pub const PACKAGE_URL: &[u8; 28] = b"https://www.postgresql.org/\0";
pub const PACKAGE_VERSION: &[u8; 6] = b"13.11\0";
pub const PG_KRB_SRVNAM: &[u8; 9] = b"postgres\0";
pub const PG_MAJORVERSION: &[u8; 3] = b"13\0";
pub const PG_MAJORVERSION_NUM: u32 = 13;
pub const PG_MINORVERSION_NUM: u32 = 11;
pub const PG_USE_STDBOOL: u32 = 1;
pub const PG_VERSION: &[u8; 6] = b"13.11\0";
pub const PG_VERSION_NUM: u32 = 130011;
pub const PG_VERSION_STR : & [u8 ; 105] = b"PostgreSQL 13.11 on x86_64-pc-linux-gnu, compiled by gcc (Ubuntu 11.3.0-1ubuntu1~22.04.1) 11.3.0, 64-bit\0" ;
pub const RELSEG_SIZE: u32 = 131072;
pub const SIZEOF_BOOL: u32 = 1;
pub const SIZEOF_LONG: u32 = 8;
pub const SIZEOF_OFF_T: u32 = 8;
pub const SIZEOF_SIZE_T: u32 = 8;
pub const SIZEOF_VOID_P: u32 = 8;
pub const STDC_HEADERS: u32 = 1;
pub const USE_ASSERT_CHECKING: u32 = 1;
pub const USE_DEV_URANDOM: u32 = 1;
pub const USE_SSE42_CRC32C_WITH_RUNTIME_CHECK: u32 = 1;
pub const USE_SYSV_SHARED_MEMORY: u32 = 1;
pub const USE_UNNAMED_POSIX_SEMAPHORES: u32 = 1;
pub const XLOG_BLCKSZ: u32 = 8192;
pub const DEFAULT_XLOG_SEG_SIZE: u32 = 16777216;
pub const NAMEDATALEN: u32 = 64;
pub const FUNC_MAX_ARGS: u32 = 100;
pub const INDEX_MAX_KEYS: u32 = 32;
pub const PARTITION_MAX_KEYS: u32 = 32;
pub const USE_FLOAT8_BYVAL: u32 = 1;
pub const NUM_SPINLOCK_SEMAPHORES: u32 = 128;
pub const NUM_ATOMICS_SEMAPHORES: u32 = 64;
pub const MAXPGPATH: u32 = 1024;
pub const PG_SOMAXCONN: u32 = 10000;
pub const BITS_PER_BYTE: u32 = 8;
pub const ALIGNOF_BUFFER: u32 = 32;
pub const HAVE_WORKING_LINK: u32 = 1;
pub const DEFAULT_BACKEND_FLUSH_AFTER: u32 = 0;
pub const DEFAULT_BGWRITER_FLUSH_AFTER: u32 = 64;
pub const DEFAULT_CHECKPOINT_FLUSH_AFTER: u32 = 32;
pub const WRITEBACK_MAX_PENDING_FLUSHES: u32 = 256;
pub const DEFAULT_PGSOCKET_DIR: &[u8; 5] = b"/tmp\0";
pub const DEFAULT_EVENT_SOURCE: &[u8; 11] = b"PostgreSQL\0";
pub const PG_CACHE_LINE_SIZE: u32 = 128;
pub const TRACE_SORT: u32 = 1;
pub const _STDIO_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __GLIBC_USE_ISOC2X: u32 = 0;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const __TIMESIZE: u32 = 64;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_SCANF: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_60559_BFP__: u32 = 201404;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_IEC_60559_COMPLEX__: u32 = 201404;
pub const __STDC_ISO_10646__: u32 = 201706;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 35;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __glibc_c99_flexarr_available: u32 = 1;
pub const __LDOUBLE_REDIRECTS_TO_FLOAT128_ABI: u32 = 0;
pub const __HAVE_GENERIC_SELECTION: u32 = 1;
pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
pub const __GNUC_VA_LIST: u32 = 1;
pub const _BITS_TYPES_H: u32 = 1;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
pub const __STATFS_MATCHES_STATFS64: u32 = 1;
pub const __KERNEL_OLD_TIMEVAL_MATCHES_TIMEVAL64: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const _BITS_TIME64_H: u32 = 1;
pub const _____fpos_t_defined: u32 = 1;
pub const ____mbstate_t_defined: u32 = 1;
pub const _____fpos64_t_defined: u32 = 1;
pub const ____FILE_defined: u32 = 1;
pub const __FILE_defined: u32 = 1;
pub const __struct_FILE_defined: u32 = 1;
pub const _IO_EOF_SEEN: u32 = 16;
pub const _IO_ERR_SEEN: u32 = 32;
pub const _IO_USER_LOCK: u32 = 32768;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 1;
pub const _IONBF: u32 = 2;
pub const BUFSIZ: u32 = 8192;
pub const EOF: i32 = -1;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const P_tmpdir: &[u8; 5] = b"/tmp\0";
pub const _BITS_STDIO_LIM_H: u32 = 1;
pub const L_tmpnam: u32 = 20;
pub const TMP_MAX: u32 = 238328;
pub const FILENAME_MAX: u32 = 4096;
pub const L_ctermid: u32 = 9;
pub const FOPEN_MAX: u32 = 16;
pub const __HAVE_FLOAT128: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT128: u32 = 0;
pub const __HAVE_FLOAT64X: u32 = 1;
pub const __HAVE_FLOAT64X_LONG_DOUBLE: u32 = 1;
pub const __HAVE_FLOAT16: u32 = 0;
pub const __HAVE_FLOAT32: u32 = 1;
pub const __HAVE_FLOAT64: u32 = 1;
pub const __HAVE_FLOAT32X: u32 = 1;
pub const __HAVE_FLOAT128X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT16: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT32: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT64: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT32X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT64X: u32 = 0;
pub const __HAVE_DISTINCT_FLOAT128X: u32 = 0;
pub const __HAVE_FLOATN_NOT_TYPEDEF: u32 = 0;
pub const _STDLIB_H: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WSTOPPED: u32 = 2;
pub const WEXITED: u32 = 4;
pub const WCONTINUED: u32 = 8;
pub const WNOWAIT: u32 = 16777216;
pub const __WNOTHREAD: u32 = 536870912;
pub const __WALL: u32 = 1073741824;
pub const __WCLONE: u32 = 2147483648;
pub const __W_CONTINUED: u32 = 65535;
pub const __WCOREFLAG: u32 = 128;
pub const __ldiv_t_defined: u32 = 1;
pub const __lldiv_t_defined: u32 = 1;
pub const RAND_MAX: u32 = 2147483647;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const _SYS_TYPES_H: u32 = 1;
pub const __clock_t_defined: u32 = 1;
pub const __clockid_t_defined: u32 = 1;
pub const __time_t_defined: u32 = 1;
pub const __timer_t_defined: u32 = 1;
pub const _BITS_STDINT_INTN_H: u32 = 1;
pub const __BIT_TYPES_DEFINED__: u32 = 1;
pub const _ENDIAN_H: u32 = 1;
pub const _BITS_ENDIAN_H: u32 = 1;
pub const __LITTLE_ENDIAN: u32 = 1234;
pub const __BIG_ENDIAN: u32 = 4321;
pub const __PDP_ENDIAN: u32 = 3412;
pub const _BITS_ENDIANNESS_H: u32 = 1;
pub const __BYTE_ORDER: u32 = 1234;
pub const __FLOAT_WORD_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const _BITS_BYTESWAP_H: u32 = 1;
pub const _BITS_UINTN_IDENTITY_H: u32 = 1;
pub const _SYS_SELECT_H: u32 = 1;
pub const __sigset_t_defined: u32 = 1;
pub const __timeval_defined: u32 = 1;
pub const _STRUCT_TIMESPEC: u32 = 1;
pub const FD_SETSIZE: u32 = 1024;
pub const _BITS_PTHREADTYPES_COMMON_H: u32 = 1;
pub const _THREAD_SHARED_TYPES_H: u32 = 1;
pub const _BITS_PTHREADTYPES_ARCH_H: u32 = 1;
pub const __SIZEOF_PTHREAD_MUTEX_T: u32 = 40;
pub const __SIZEOF_PTHREAD_ATTR_T: u32 = 56;
pub const __SIZEOF_PTHREAD_RWLOCK_T: u32 = 56;
pub const __SIZEOF_PTHREAD_BARRIER_T: u32 = 32;
pub const __SIZEOF_PTHREAD_MUTEXATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_COND_T: u32 = 48;
pub const __SIZEOF_PTHREAD_CONDATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_RWLOCKATTR_T: u32 = 8;
pub const __SIZEOF_PTHREAD_BARRIERATTR_T: u32 = 4;
pub const _THREAD_MUTEX_INTERNAL_H: u32 = 1;
pub const __PTHREAD_MUTEX_HAVE_PREV: u32 = 1;
pub const __have_pthread_attr_t: u32 = 1;
pub const _ALLOCA_H: u32 = 1;
pub const _STRING_H: u32 = 1;
pub const _BITS_TYPES_LOCALE_T_H: u32 = 1;
pub const _BITS_TYPES___LOCALE_T_H: u32 = 1;
pub const _STRINGS_H: u32 = 1;
pub const _STDINT_H: u32 = 1;
pub const _BITS_WCHAR_H: u32 = 1;
pub const _BITS_STDINT_UINTN_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const _ERRNO_H: u32 = 1;
pub const _BITS_ERRNO_H: u32 = 1;
pub const EPERM: u32 = 1;
pub const ENOENT: u32 = 2;
pub const ESRCH: u32 = 3;
pub const EINTR: u32 = 4;
pub const EIO: u32 = 5;
pub const ENXIO: u32 = 6;
pub const E2BIG: u32 = 7;
pub const ENOEXEC: u32 = 8;
pub const EBADF: u32 = 9;
pub const ECHILD: u32 = 10;
pub const EAGAIN: u32 = 11;
pub const ENOMEM: u32 = 12;
pub const EACCES: u32 = 13;
pub const EFAULT: u32 = 14;
pub const ENOTBLK: u32 = 15;
pub const EBUSY: u32 = 16;
pub const EEXIST: u32 = 17;
pub const EXDEV: u32 = 18;
pub const ENODEV: u32 = 19;
pub const ENOTDIR: u32 = 20;
pub const EISDIR: u32 = 21;
pub const EINVAL: u32 = 22;
pub const ENFILE: u32 = 23;
pub const EMFILE: u32 = 24;
pub const ENOTTY: u32 = 25;
pub const ETXTBSY: u32 = 26;
pub const EFBIG: u32 = 27;
pub const ENOSPC: u32 = 28;
pub const ESPIPE: u32 = 29;
pub const EROFS: u32 = 30;
pub const EMLINK: u32 = 31;
pub const EPIPE: u32 = 32;
pub const EDOM: u32 = 33;
pub const ERANGE: u32 = 34;
pub const EDEADLK: u32 = 35;
pub const ENAMETOOLONG: u32 = 36;
pub const ENOLCK: u32 = 37;
pub const ENOSYS: u32 = 38;
pub const ENOTEMPTY: u32 = 39;
pub const ELOOP: u32 = 40;
pub const EWOULDBLOCK: u32 = 11;
pub const ENOMSG: u32 = 42;
pub const EIDRM: u32 = 43;
pub const ECHRNG: u32 = 44;
pub const EL2NSYNC: u32 = 45;
pub const EL3HLT: u32 = 46;
pub const EL3RST: u32 = 47;
pub const ELNRNG: u32 = 48;
pub const EUNATCH: u32 = 49;
pub const ENOCSI: u32 = 50;
pub const EL2HLT: u32 = 51;
pub const EBADE: u32 = 52;
pub const EBADR: u32 = 53;
pub const EXFULL: u32 = 54;
pub const ENOANO: u32 = 55;
pub const EBADRQC: u32 = 56;
pub const EBADSLT: u32 = 57;
pub const EDEADLOCK: u32 = 35;
pub const EBFONT: u32 = 59;
pub const ENOSTR: u32 = 60;
pub const ENODATA: u32 = 61;
pub const ETIME: u32 = 62;
pub const ENOSR: u32 = 63;
pub const ENONET: u32 = 64;
pub const ENOPKG: u32 = 65;
pub const EREMOTE: u32 = 66;
pub const ENOLINK: u32 = 67;
pub const EADV: u32 = 68;
pub const ESRMNT: u32 = 69;
pub const ECOMM: u32 = 70;
pub const EPROTO: u32 = 71;
pub const EMULTIHOP: u32 = 72;
pub const EDOTDOT: u32 = 73;
pub const EBADMSG: u32 = 74;
pub const EOVERFLOW: u32 = 75;
pub const ENOTUNIQ: u32 = 76;
pub const EBADFD: u32 = 77;
pub const EREMCHG: u32 = 78;
pub const ELIBACC: u32 = 79;
pub const ELIBBAD: u32 = 80;
pub const ELIBSCN: u32 = 81;
pub const ELIBMAX: u32 = 82;
pub const ELIBEXEC: u32 = 83;
pub const EILSEQ: u32 = 84;
pub const ERESTART: u32 = 85;
pub const ESTRPIPE: u32 = 86;
pub const EUSERS: u32 = 87;
pub const ENOTSOCK: u32 = 88;
pub const EDESTADDRREQ: u32 = 89;
pub const EMSGSIZE: u32 = 90;
pub const EPROTOTYPE: u32 = 91;
pub const ENOPROTOOPT: u32 = 92;
pub const EPROTONOSUPPORT: u32 = 93;
pub const ESOCKTNOSUPPORT: u32 = 94;
pub const EOPNOTSUPP: u32 = 95;
pub const EPFNOSUPPORT: u32 = 96;
pub const EAFNOSUPPORT: u32 = 97;
pub const EADDRINUSE: u32 = 98;
pub const EADDRNOTAVAIL: u32 = 99;
pub const ENETDOWN: u32 = 100;
pub const ENETUNREACH: u32 = 101;
pub const ENETRESET: u32 = 102;
pub const ECONNABORTED: u32 = 103;
pub const ECONNRESET: u32 = 104;
pub const ENOBUFS: u32 = 105;
pub const EISCONN: u32 = 106;
pub const ENOTCONN: u32 = 107;
pub const ESHUTDOWN: u32 = 108;
pub const ETOOMANYREFS: u32 = 109;
pub const ETIMEDOUT: u32 = 110;
pub const ECONNREFUSED: u32 = 111;
pub const EHOSTDOWN: u32 = 112;
pub const EHOSTUNREACH: u32 = 113;
pub const EALREADY: u32 = 114;
pub const EINPROGRESS: u32 = 115;
pub const ESTALE: u32 = 116;
pub const EUCLEAN: u32 = 117;
pub const ENOTNAM: u32 = 118;
pub const ENAVAIL: u32 = 119;
pub const EISNAM: u32 = 120;
pub const EREMOTEIO: u32 = 121;
pub const EDQUOT: u32 = 122;
pub const ENOMEDIUM: u32 = 123;
pub const EMEDIUMTYPE: u32 = 124;
pub const ECANCELED: u32 = 125;
pub const ENOKEY: u32 = 126;
pub const EKEYEXPIRED: u32 = 127;
pub const EKEYREVOKED: u32 = 128;
pub const EKEYREJECTED: u32 = 129;
pub const EOWNERDEAD: u32 = 130;
pub const ENOTRECOVERABLE: u32 = 131;
pub const ERFKILL: u32 = 132;
pub const EHWPOISON: u32 = 133;
pub const ENOTSUP: u32 = 95;
pub const _LOCALE_H: u32 = 1;
pub const _BITS_LOCALE_H: u32 = 1;
pub const __LC_CTYPE: u32 = 0;
pub const __LC_NUMERIC: u32 = 1;
pub const __LC_TIME: u32 = 2;
pub const __LC_COLLATE: u32 = 3;
pub const __LC_MONETARY: u32 = 4;
pub const __LC_MESSAGES: u32 = 5;
pub const __LC_ALL: u32 = 6;
pub const __LC_PAPER: u32 = 7;
pub const __LC_NAME: u32 = 8;
pub const __LC_ADDRESS: u32 = 9;
pub const __LC_TELEPHONE: u32 = 10;
pub const __LC_MEASUREMENT: u32 = 11;
pub const __LC_IDENTIFICATION: u32 = 12;
pub const LC_CTYPE: u32 = 0;
pub const LC_NUMERIC: u32 = 1;
pub const LC_TIME: u32 = 2;
pub const LC_COLLATE: u32 = 3;
pub const LC_MONETARY: u32 = 4;
pub const LC_MESSAGES: u32 = 5;
pub const LC_ALL: u32 = 6;
pub const LC_PAPER: u32 = 7;
pub const LC_NAME: u32 = 8;
pub const LC_ADDRESS: u32 = 9;
pub const LC_TELEPHONE: u32 = 10;
pub const LC_MEASUREMENT: u32 = 11;
pub const LC_IDENTIFICATION: u32 = 12;
pub const LC_CTYPE_MASK: u32 = 1;
pub const LC_NUMERIC_MASK: u32 = 2;
pub const LC_TIME_MASK: u32 = 4;
pub const LC_COLLATE_MASK: u32 = 8;
pub const LC_MONETARY_MASK: u32 = 16;
pub const LC_MESSAGES_MASK: u32 = 32;
pub const LC_PAPER_MASK: u32 = 128;
pub const LC_NAME_MASK: u32 = 256;
pub const LC_ADDRESS_MASK: u32 = 512;
pub const LC_TELEPHONE_MASK: u32 = 1024;
pub const LC_MEASUREMENT_MASK: u32 = 2048;
pub const LC_IDENTIFICATION_MASK: u32 = 4096;
pub const LC_ALL_MASK: u32 = 8127;
pub const HAVE_PG_ATTRIBUTE_NORETURN: u32 = 1;
pub const HAVE_PRAGMA_GCC_SYSTEM_HEADER: u32 = 1;
pub const __bool_true_false_are_defined: u32 = 1;
pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const INT64_FORMAT: &[u8; 4] = b"%ld\0";
pub const UINT64_FORMAT: &[u8; 4] = b"%lu\0";
pub const HAVE_INT128: u32 = 1;
pub const PG_INT8_MIN: i32 = -128;
pub const PG_INT8_MAX: u32 = 127;
pub const PG_UINT8_MAX: u32 = 255;
pub const PG_INT16_MIN: i32 = -32768;
pub const PG_INT16_MAX: u32 = 32767;
pub const PG_UINT16_MAX: u32 = 65535;
pub const PG_INT32_MIN: i32 = -2147483648;
pub const PG_INT32_MAX: u32 = 2147483647;
pub const PG_UINT32_MAX: u32 = 4294967295;
pub const FLOAT8PASSBYVAL: u32 = 1;
pub const MAXDIM: u32 = 6;
pub const HAVE_UNIX_SOCKETS: u32 = 1;
pub const HIGHBIT: u32 = 128;
pub const ESCAPE_STRING_SYNTAX: u8 = 69u8;
pub const STATUS_OK: u32 = 0;
pub const STATUS_ERROR: i32 = -1;
pub const STATUS_EOF: i32 = -2;
pub const STATUS_WAITING: u32 = 2;
pub const PG_BINARY: u32 = 0;
pub const PG_BINARY_A: &[u8; 2] = b"a\0";
pub const PG_BINARY_R: &[u8; 2] = b"r\0";
pub const PG_BINARY_W: &[u8; 2] = b"w\0";
pub const _CTYPE_H: u32 = 1;
pub const _NETDB_H: u32 = 1;
pub const _NETINET_IN_H: u32 = 1;
pub const _SYS_SOCKET_H: u32 = 1;
pub const __iovec_defined: u32 = 1;
pub const PF_UNSPEC: u32 = 0;
pub const PF_LOCAL: u32 = 1;
pub const PF_UNIX: u32 = 1;
pub const PF_FILE: u32 = 1;
pub const PF_INET: u32 = 2;
pub const PF_AX25: u32 = 3;
pub const PF_IPX: u32 = 4;
pub const PF_APPLETALK: u32 = 5;
pub const PF_NETROM: u32 = 6;
pub const PF_BRIDGE: u32 = 7;
pub const PF_ATMPVC: u32 = 8;
pub const PF_X25: u32 = 9;
pub const PF_INET6: u32 = 10;
pub const PF_ROSE: u32 = 11;
pub const PF_DECnet: u32 = 12;
pub const PF_NETBEUI: u32 = 13;
pub const PF_SECURITY: u32 = 14;
pub const PF_KEY: u32 = 15;
pub const PF_NETLINK: u32 = 16;
pub const PF_ROUTE: u32 = 16;
pub const PF_PACKET: u32 = 17;
pub const PF_ASH: u32 = 18;
pub const PF_ECONET: u32 = 19;
pub const PF_ATMSVC: u32 = 20;
pub const PF_RDS: u32 = 21;
pub const PF_SNA: u32 = 22;
pub const PF_IRDA: u32 = 23;
pub const PF_PPPOX: u32 = 24;
pub const PF_WANPIPE: u32 = 25;
pub const PF_LLC: u32 = 26;
pub const PF_IB: u32 = 27;
pub const PF_MPLS: u32 = 28;
pub const PF_CAN: u32 = 29;
pub const PF_TIPC: u32 = 30;
pub const PF_BLUETOOTH: u32 = 31;
pub const PF_IUCV: u32 = 32;
pub const PF_RXRPC: u32 = 33;
pub const PF_ISDN: u32 = 34;
pub const PF_PHONET: u32 = 35;
pub const PF_IEEE802154: u32 = 36;
pub const PF_CAIF: u32 = 37;
pub const PF_ALG: u32 = 38;
pub const PF_NFC: u32 = 39;
pub const PF_VSOCK: u32 = 40;
pub const PF_KCM: u32 = 41;
pub const PF_QIPCRTR: u32 = 42;
pub const PF_SMC: u32 = 43;
pub const PF_XDP: u32 = 44;
pub const PF_MCTP: u32 = 45;
pub const PF_MAX: u32 = 46;
pub const AF_UNSPEC: u32 = 0;
pub const AF_LOCAL: u32 = 1;
pub const AF_UNIX: u32 = 1;
pub const AF_FILE: u32 = 1;
pub const AF_INET: u32 = 2;
pub const AF_AX25: u32 = 3;
pub const AF_IPX: u32 = 4;
pub const AF_APPLETALK: u32 = 5;
pub const AF_NETROM: u32 = 6;
pub const AF_BRIDGE: u32 = 7;
pub const AF_ATMPVC: u32 = 8;
pub const AF_X25: u32 = 9;
pub const AF_INET6: u32 = 10;
pub const AF_ROSE: u32 = 11;
pub const AF_DECnet: u32 = 12;
pub const AF_NETBEUI: u32 = 13;
pub const AF_SECURITY: u32 = 14;
pub const AF_KEY: u32 = 15;
pub const AF_NETLINK: u32 = 16;
pub const AF_ROUTE: u32 = 16;
pub const AF_PACKET: u32 = 17;
pub const AF_ASH: u32 = 18;
pub const AF_ECONET: u32 = 19;
pub const AF_ATMSVC: u32 = 20;
pub const AF_RDS: u32 = 21;
pub const AF_SNA: u32 = 22;
pub const AF_IRDA: u32 = 23;
pub const AF_PPPOX: u32 = 24;
pub const AF_WANPIPE: u32 = 25;
pub const AF_LLC: u32 = 26;
pub const AF_IB: u32 = 27;
pub const AF_MPLS: u32 = 28;
pub const AF_CAN: u32 = 29;
pub const AF_TIPC: u32 = 30;
pub const AF_BLUETOOTH: u32 = 31;
pub const AF_IUCV: u32 = 32;
pub const AF_RXRPC: u32 = 33;
pub const AF_ISDN: u32 = 34;
pub const AF_PHONET: u32 = 35;
pub const AF_IEEE802154: u32 = 36;
pub const AF_CAIF: u32 = 37;
pub const AF_ALG: u32 = 38;
pub const AF_NFC: u32 = 39;
pub const AF_VSOCK: u32 = 40;
pub const AF_KCM: u32 = 41;
pub const AF_QIPCRTR: u32 = 42;
pub const AF_SMC: u32 = 43;
pub const AF_XDP: u32 = 44;
pub const AF_MCTP: u32 = 45;
pub const AF_MAX: u32 = 46;
pub const SOL_RAW: u32 = 255;
pub const SOL_DECNET: u32 = 261;
pub const SOL_X25: u32 = 262;
pub const SOL_PACKET: u32 = 263;
pub const SOL_ATM: u32 = 264;
pub const SOL_AAL: u32 = 265;
pub const SOL_IRDA: u32 = 266;
pub const SOL_NETBEUI: u32 = 267;
pub const SOL_LLC: u32 = 268;
pub const SOL_DCCP: u32 = 269;
pub const SOL_NETLINK: u32 = 270;
pub const SOL_TIPC: u32 = 271;
pub const SOL_RXRPC: u32 = 272;
pub const SOL_PPPOL2TP: u32 = 273;
pub const SOL_BLUETOOTH: u32 = 274;
pub const SOL_PNPIPE: u32 = 275;
pub const SOL_RDS: u32 = 276;
pub const SOL_IUCV: u32 = 277;
pub const SOL_CAIF: u32 = 278;
pub const SOL_ALG: u32 = 279;
pub const SOL_NFC: u32 = 280;
pub const SOL_KCM: u32 = 281;
pub const SOL_TLS: u32 = 282;
pub const SOL_XDP: u32 = 283;
pub const SOMAXCONN: u32 = 4096;
pub const _BITS_SOCKADDR_H: u32 = 1;
pub const _SS_SIZE: u32 = 128;
pub const __BITS_PER_LONG: u32 = 64;
pub const FIOSETOWN: u32 = 35073;
pub const SIOCSPGRP: u32 = 35074;
pub const FIOGETOWN: u32 = 35075;
pub const SIOCGPGRP: u32 = 35076;
pub const SIOCATMARK: u32 = 35077;
pub const SIOCGSTAMP_OLD: u32 = 35078;
pub const SIOCGSTAMPNS_OLD: u32 = 35079;
pub const SOL_SOCKET: u32 = 1;
pub const SO_DEBUG: u32 = 1;
pub const SO_REUSEADDR: u32 = 2;
pub const SO_TYPE: u32 = 3;
pub const SO_ERROR: u32 = 4;
pub const SO_DONTROUTE: u32 = 5;
pub const SO_BROADCAST: u32 = 6;
pub const SO_SNDBUF: u32 = 7;
pub const SO_RCVBUF: u32 = 8;
pub const SO_SNDBUFFORCE: u32 = 32;
pub const SO_RCVBUFFORCE: u32 = 33;
pub const SO_KEEPALIVE: u32 = 9;
pub const SO_OOBINLINE: u32 = 10;
pub const SO_NO_CHECK: u32 = 11;
pub const SO_PRIORITY: u32 = 12;
pub const SO_LINGER: u32 = 13;
pub const SO_BSDCOMPAT: u32 = 14;
pub const SO_REUSEPORT: u32 = 15;
pub const SO_PASSCRED: u32 = 16;
pub const SO_PEERCRED: u32 = 17;
pub const SO_RCVLOWAT: u32 = 18;
pub const SO_SNDLOWAT: u32 = 19;
pub const SO_RCVTIMEO_OLD: u32 = 20;
pub const SO_SNDTIMEO_OLD: u32 = 21;
pub const SO_SECURITY_AUTHENTICATION: u32 = 22;
pub const SO_SECURITY_ENCRYPTION_TRANSPORT: u32 = 23;
pub const SO_SECURITY_ENCRYPTION_NETWORK: u32 = 24;
pub const SO_BINDTODEVICE: u32 = 25;
pub const SO_ATTACH_FILTER: u32 = 26;
pub const SO_DETACH_FILTER: u32 = 27;
pub const SO_GET_FILTER: u32 = 26;
pub const SO_PEERNAME: u32 = 28;
pub const SO_ACCEPTCONN: u32 = 30;
pub const SO_PEERSEC: u32 = 31;
pub const SO_PASSSEC: u32 = 34;
pub const SO_MARK: u32 = 36;
pub const SO_PROTOCOL: u32 = 38;
pub const SO_DOMAIN: u32 = 39;
pub const SO_RXQ_OVFL: u32 = 40;
pub const SO_WIFI_STATUS: u32 = 41;
pub const SCM_WIFI_STATUS: u32 = 41;
pub const SO_PEEK_OFF: u32 = 42;
pub const SO_NOFCS: u32 = 43;
pub const SO_LOCK_FILTER: u32 = 44;
pub const SO_SELECT_ERR_QUEUE: u32 = 45;
pub const SO_BUSY_POLL: u32 = 46;
pub const SO_MAX_PACING_RATE: u32 = 47;
pub const SO_BPF_EXTENSIONS: u32 = 48;
pub const SO_INCOMING_CPU: u32 = 49;
pub const SO_ATTACH_BPF: u32 = 50;
pub const SO_DETACH_BPF: u32 = 27;
pub const SO_ATTACH_REUSEPORT_CBPF: u32 = 51;
pub const SO_ATTACH_REUSEPORT_EBPF: u32 = 52;
pub const SO_CNX_ADVICE: u32 = 53;
pub const SCM_TIMESTAMPING_OPT_STATS: u32 = 54;
pub const SO_MEMINFO: u32 = 55;
pub const SO_INCOMING_NAPI_ID: u32 = 56;
pub const SO_COOKIE: u32 = 57;
pub const SCM_TIMESTAMPING_PKTINFO: u32 = 58;
pub const SO_PEERGROUPS: u32 = 59;
pub const SO_ZEROCOPY: u32 = 60;
pub const SO_TXTIME: u32 = 61;
pub const SCM_TXTIME: u32 = 61;
pub const SO_BINDTOIFINDEX: u32 = 62;
pub const SO_TIMESTAMP_OLD: u32 = 29;
pub const SO_TIMESTAMPNS_OLD: u32 = 35;
pub const SO_TIMESTAMPING_OLD: u32 = 37;
pub const SO_TIMESTAMP_NEW: u32 = 63;
pub const SO_TIMESTAMPNS_NEW: u32 = 64;
pub const SO_TIMESTAMPING_NEW: u32 = 65;
pub const SO_RCVTIMEO_NEW: u32 = 66;
pub const SO_SNDTIMEO_NEW: u32 = 67;
pub const SO_DETACH_REUSEPORT_BPF: u32 = 68;
pub const SO_PREFER_BUSY_POLL: u32 = 69;
pub const SO_BUSY_POLL_BUDGET: u32 = 70;
pub const SO_NETNS_COOKIE: u32 = 71;
pub const SO_BUF_LOCK: u32 = 72;
pub const SO_TIMESTAMP: u32 = 29;
pub const SO_TIMESTAMPNS: u32 = 35;
pub const SO_TIMESTAMPING: u32 = 37;
pub const SO_RCVTIMEO: u32 = 20;
pub const SO_SNDTIMEO: u32 = 21;
pub const SCM_TIMESTAMP: u32 = 29;
pub const SCM_TIMESTAMPNS: u32 = 35;
pub const SCM_TIMESTAMPING: u32 = 37;
pub const __osockaddr_defined: u32 = 1;
pub const __USE_KERNEL_IPV6_DEFS: u32 = 0;
pub const IP_OPTIONS: u32 = 4;
pub const IP_HDRINCL: u32 = 3;
pub const IP_TOS: u32 = 1;
pub const IP_TTL: u32 = 2;
pub const IP_RECVOPTS: u32 = 6;
pub const IP_RETOPTS: u32 = 7;
pub const IP_MULTICAST_IF: u32 = 32;
pub const IP_MULTICAST_TTL: u32 = 33;
pub const IP_MULTICAST_LOOP: u32 = 34;
pub const IP_ADD_MEMBERSHIP: u32 = 35;
pub const IP_DROP_MEMBERSHIP: u32 = 36;
pub const IP_UNBLOCK_SOURCE: u32 = 37;
pub const IP_BLOCK_SOURCE: u32 = 38;
pub const IP_ADD_SOURCE_MEMBERSHIP: u32 = 39;
pub const IP_DROP_SOURCE_MEMBERSHIP: u32 = 40;
pub const IP_MSFILTER: u32 = 41;
pub const MCAST_JOIN_GROUP: u32 = 42;
pub const MCAST_BLOCK_SOURCE: u32 = 43;
pub const MCAST_UNBLOCK_SOURCE: u32 = 44;
pub const MCAST_LEAVE_GROUP: u32 = 45;
pub const MCAST_JOIN_SOURCE_GROUP: u32 = 46;
pub const MCAST_LEAVE_SOURCE_GROUP: u32 = 47;
pub const MCAST_MSFILTER: u32 = 48;
pub const IP_MULTICAST_ALL: u32 = 49;
pub const IP_UNICAST_IF: u32 = 50;
pub const MCAST_EXCLUDE: u32 = 0;
pub const MCAST_INCLUDE: u32 = 1;
pub const IP_ROUTER_ALERT: u32 = 5;
pub const IP_PKTINFO: u32 = 8;
pub const IP_PKTOPTIONS: u32 = 9;
pub const IP_PMTUDISC: u32 = 10;
pub const IP_MTU_DISCOVER: u32 = 10;
pub const IP_RECVERR: u32 = 11;
pub const IP_RECVTTL: u32 = 12;
pub const IP_RECVTOS: u32 = 13;
pub const IP_MTU: u32 = 14;
pub const IP_FREEBIND: u32 = 15;
pub const IP_IPSEC_POLICY: u32 = 16;
pub const IP_XFRM_POLICY: u32 = 17;
pub const IP_PASSSEC: u32 = 18;
pub const IP_TRANSPARENT: u32 = 19;
pub const IP_ORIGDSTADDR: u32 = 20;
pub const IP_RECVORIGDSTADDR: u32 = 20;
pub const IP_MINTTL: u32 = 21;
pub const IP_NODEFRAG: u32 = 22;
pub const IP_CHECKSUM: u32 = 23;
pub const IP_BIND_ADDRESS_NO_PORT: u32 = 24;
pub const IP_RECVFRAGSIZE: u32 = 25;
pub const IP_RECVERR_RFC4884: u32 = 26;
pub const IP_PMTUDISC_DONT: u32 = 0;
pub const IP_PMTUDISC_WANT: u32 = 1;
pub const IP_PMTUDISC_DO: u32 = 2;
pub const IP_PMTUDISC_PROBE: u32 = 3;
pub const IP_PMTUDISC_INTERFACE: u32 = 4;
pub const IP_PMTUDISC_OMIT: u32 = 5;
pub const SOL_IP: u32 = 0;
pub const IP_DEFAULT_MULTICAST_TTL: u32 = 1;
pub const IP_DEFAULT_MULTICAST_LOOP: u32 = 1;
pub const IP_MAX_MEMBERSHIPS: u32 = 20;
pub const IPV6_ADDRFORM: u32 = 1;
pub const IPV6_2292PKTINFO: u32 = 2;
pub const IPV6_2292HOPOPTS: u32 = 3;
pub const IPV6_2292DSTOPTS: u32 = 4;
pub const IPV6_2292RTHDR: u32 = 5;
pub const IPV6_2292PKTOPTIONS: u32 = 6;
pub const IPV6_CHECKSUM: u32 = 7;
pub const IPV6_2292HOPLIMIT: u32 = 8;
pub const IPV6_NEXTHOP: u32 = 9;
pub const IPV6_AUTHHDR: u32 = 10;
pub const IPV6_UNICAST_HOPS: u32 = 16;
pub const IPV6_MULTICAST_IF: u32 = 17;
pub const IPV6_MULTICAST_HOPS: u32 = 18;
pub const IPV6_MULTICAST_LOOP: u32 = 19;
pub const IPV6_JOIN_GROUP: u32 = 20;
pub const IPV6_LEAVE_GROUP: u32 = 21;
pub const IPV6_ROUTER_ALERT: u32 = 22;
pub const IPV6_MTU_DISCOVER: u32 = 23;
pub const IPV6_MTU: u32 = 24;
pub const IPV6_RECVERR: u32 = 25;
pub const IPV6_V6ONLY: u32 = 26;
pub const IPV6_JOIN_ANYCAST: u32 = 27;
pub const IPV6_LEAVE_ANYCAST: u32 = 28;
pub const IPV6_MULTICAST_ALL: u32 = 29;
pub const IPV6_ROUTER_ALERT_ISOLATE: u32 = 30;
pub const IPV6_RECVERR_RFC4884: u32 = 31;
pub const IPV6_IPSEC_POLICY: u32 = 34;
pub const IPV6_XFRM_POLICY: u32 = 35;
pub const IPV6_HDRINCL: u32 = 36;
pub const IPV6_RECVPKTINFO: u32 = 49;
pub const IPV6_PKTINFO: u32 = 50;
pub const IPV6_RECVHOPLIMIT: u32 = 51;
pub const IPV6_HOPLIMIT: u32 = 52;
pub const IPV6_RECVHOPOPTS: u32 = 53;
pub const IPV6_HOPOPTS: u32 = 54;
pub const IPV6_RTHDRDSTOPTS: u32 = 55;
pub const IPV6_RECVRTHDR: u32 = 56;
pub const IPV6_RTHDR: u32 = 57;
pub const IPV6_RECVDSTOPTS: u32 = 58;
pub const IPV6_DSTOPTS: u32 = 59;
pub const IPV6_RECVPATHMTU: u32 = 60;
pub const IPV6_PATHMTU: u32 = 61;
pub const IPV6_DONTFRAG: u32 = 62;
pub const IPV6_RECVTCLASS: u32 = 66;
pub const IPV6_TCLASS: u32 = 67;
pub const IPV6_AUTOFLOWLABEL: u32 = 70;
pub const IPV6_ADDR_PREFERENCES: u32 = 72;
pub const IPV6_MINHOPCOUNT: u32 = 73;
pub const IPV6_ORIGDSTADDR: u32 = 74;
pub const IPV6_RECVORIGDSTADDR: u32 = 74;
pub const IPV6_TRANSPARENT: u32 = 75;
pub const IPV6_UNICAST_IF: u32 = 76;
pub const IPV6_RECVFRAGSIZE: u32 = 77;
pub const IPV6_FREEBIND: u32 = 78;
pub const IPV6_ADD_MEMBERSHIP: u32 = 20;
pub const IPV6_DROP_MEMBERSHIP: u32 = 21;
pub const IPV6_RXHOPOPTS: u32 = 54;
pub const IPV6_RXDSTOPTS: u32 = 59;
pub const IPV6_PMTUDISC_DONT: u32 = 0;
pub const IPV6_PMTUDISC_WANT: u32 = 1;
pub const IPV6_PMTUDISC_DO: u32 = 2;
pub const IPV6_PMTUDISC_PROBE: u32 = 3;
pub const IPV6_PMTUDISC_INTERFACE: u32 = 4;
pub const IPV6_PMTUDISC_OMIT: u32 = 5;
pub const SOL_IPV6: u32 = 41;
pub const SOL_ICMPV6: u32 = 58;
pub const IPV6_RTHDR_LOOSE: u32 = 0;
pub const IPV6_RTHDR_STRICT: u32 = 1;
pub const IPV6_RTHDR_TYPE_0: u32 = 0;
pub const IN_CLASSA_NET: u32 = 4278190080;
pub const IN_CLASSA_NSHIFT: u32 = 24;
pub const IN_CLASSA_HOST: u32 = 16777215;
pub const IN_CLASSA_MAX: u32 = 128;
pub const IN_CLASSB_NET: u32 = 4294901760;
pub const IN_CLASSB_NSHIFT: u32 = 16;
pub const IN_CLASSB_HOST: u32 = 65535;
pub const IN_CLASSB_MAX: u32 = 65536;
pub const IN_CLASSC_NET: u32 = 4294967040;
pub const IN_CLASSC_NSHIFT: u32 = 8;
pub const IN_CLASSC_HOST: u32 = 255;
pub const IN_LOOPBACKNET: u32 = 127;
pub const INET_ADDRSTRLEN: u32 = 16;
pub const INET6_ADDRSTRLEN: u32 = 46;
pub const _RPC_NETDB_H: u32 = 1;
pub const _PATH_HEQUIV: &[u8; 17] = b"/etc/hosts.equiv\0";
pub const _PATH_HOSTS: &[u8; 11] = b"/etc/hosts\0";
pub const _PATH_NETWORKS: &[u8; 14] = b"/etc/networks\0";
pub const _PATH_NSSWITCH_CONF: &[u8; 19] = b"/etc/nsswitch.conf\0";
pub const _PATH_PROTOCOLS: &[u8; 15] = b"/etc/protocols\0";
pub const _PATH_SERVICES: &[u8; 14] = b"/etc/services\0";
pub const HOST_NOT_FOUND: u32 = 1;
pub const TRY_AGAIN: u32 = 2;
pub const NO_RECOVERY: u32 = 3;
pub const NO_DATA: u32 = 4;
pub const NETDB_INTERNAL: i32 = -1;
pub const NETDB_SUCCESS: u32 = 0;
pub const NO_ADDRESS: u32 = 4;
pub const AI_PASSIVE: u32 = 1;
pub const AI_CANONNAME: u32 = 2;
pub const AI_NUMERICHOST: u32 = 4;
pub const AI_V4MAPPED: u32 = 8;
pub const AI_ALL: u32 = 16;
pub const AI_ADDRCONFIG: u32 = 32;
pub const AI_NUMERICSERV: u32 = 1024;
pub const EAI_BADFLAGS: i32 = -1;
pub const EAI_NONAME: i32 = -2;
pub const EAI_AGAIN: i32 = -3;
pub const EAI_FAIL: i32 = -4;
pub const EAI_FAMILY: i32 = -6;
pub const EAI_SOCKTYPE: i32 = -7;
pub const EAI_SERVICE: i32 = -8;
pub const EAI_MEMORY: i32 = -10;
pub const EAI_SYSTEM: i32 = -11;
pub const EAI_OVERFLOW: i32 = -12;
pub const NI_MAXHOST: u32 = 1025;
pub const NI_MAXSERV: u32 = 32;
pub const NI_NUMERICHOST: u32 = 1;
pub const NI_NUMERICSERV: u32 = 2;
pub const NI_NOFQDN: u32 = 4;
pub const NI_NAMEREQD: u32 = 8;
pub const NI_DGRAM: u32 = 16;
pub const _PWD_H: u32 = 1;
pub const NSS_BUFLEN_PASSWD: u32 = 1024;
pub const PGINVALID_SOCKET: i32 = -1;
pub const PG_BACKEND_VERSIONSTR: &[u8; 29] = b"postgres (PostgreSQL) 13.11\n\0";
pub const EXE: &[u8; 1] = b"\0";
pub const DEVNULL: &[u8; 10] = b"/dev/null\0";
pub const USE_REPL_SNPRINTF: u32 = 1;
pub const PG_STRERROR_R_BUFLEN: u32 = 256;
pub const PG_IOLBF: u32 = 1;
pub const _MATH_H: u32 = 1;
pub const _BITS_LIBM_SIMD_DECL_STUBS_H: u32 = 1;
pub const __FP_LOGB0_IS_MIN: u32 = 1;
pub const __FP_LOGBNAN_IS_MIN: u32 = 1;
pub const FP_ILOGB0: i32 = -2147483648;
pub const FP_ILOGBNAN: i32 = -2147483648;
pub const __MATH_DECLARING_DOUBLE: u32 = 1;
pub const __MATH_DECLARING_FLOATN: u32 = 0;
pub const __MATH_DECLARE_LDOUBLE: u32 = 1;
pub const MATH_ERRNO: u32 = 1;
pub const MATH_ERREXCEPT: u32 = 2;
pub const math_errhandling: u32 = 3;
pub const M_E: f64 = 2.718281828459045;
pub const M_LOG2E: f64 = 1.4426950408889634;
pub const M_LOG10E: f64 = 0.4342944819032518;
pub const M_LN2: f64 = 0.6931471805599453;
pub const M_LN10: f64 = 2.302585092994046;
pub const M_PI: f64 = 3.141592653589793;
pub const M_PI_2: f64 = 1.5707963267948966;
pub const M_PI_4: f64 = 0.7853981633974483;
pub const M_1_PI: f64 = 0.3183098861837907;
pub const M_2_PI: f64 = 0.6366197723675814;
pub const M_2_SQRTPI: f64 = 1.1283791670955126;
pub const M_SQRT2: f64 = 1.4142135623730951;
pub const M_SQRT1_2: f64 = 0.7071067811865476;
pub const _SETJMP_H: u32 = 1;
pub const _BITS_SETJMP_H: u32 = 1;
pub const __jmp_buf_tag_defined: u32 = 1;
pub const DEBUG5: u32 = 10;
pub const DEBUG4: u32 = 11;
pub const DEBUG3: u32 = 12;
pub const DEBUG2: u32 = 13;
pub const DEBUG1: u32 = 14;
pub const LOG: u32 = 15;
pub const LOG_SERVER_ONLY: u32 = 16;
pub const COMMERROR: u32 = 16;
pub const INFO: u32 = 17;
pub const NOTICE: u32 = 18;
pub const WARNING: u32 = 19;
pub const ERROR: u32 = 20;
pub const FATAL: u32 = 21;
pub const PANIC: u32 = 22;
pub const LOG_DESTINATION_STDERR: u32 = 1;
pub const LOG_DESTINATION_SYSLOG: u32 = 2;
pub const LOG_DESTINATION_EVENTLOG: u32 = 4;
pub const LOG_DESTINATION_CSVLOG: u32 = 8;
pub const MCXT_ALLOC_HUGE: u32 = 1;
pub const MCXT_ALLOC_NO_OOM: u32 = 2;
pub const MCXT_ALLOC_ZERO: u32 = 4;
pub const VARATT_SHORT_MAX: u32 = 127;
pub const FIELDNO_NULLABLE_DATUM_DATUM: u32 = 0;
pub const FIELDNO_NULLABLE_DATUM_ISNULL: u32 = 1;
pub const SIZEOF_DATUM: u32 = 8;
pub const InvalidAttrNumber: u32 = 0;
pub const MaxAttrNumber: u32 = 32767;
pub const AttributeRelationId: Oid = Oid(1249);
pub const AttributeRelation_Rowtype_Id: u32 = 75;
pub const Anum_pg_attribute_attrelid: u32 = 1;
pub const Anum_pg_attribute_attname: u32 = 2;
pub const Anum_pg_attribute_atttypid: u32 = 3;
pub const Anum_pg_attribute_attstattarget: u32 = 4;
pub const Anum_pg_attribute_attlen: u32 = 5;
pub const Anum_pg_attribute_attnum: u32 = 6;
pub const Anum_pg_attribute_attndims: u32 = 7;
pub const Anum_pg_attribute_attcacheoff: u32 = 8;
pub const Anum_pg_attribute_atttypmod: u32 = 9;
pub const Anum_pg_attribute_attbyval: u32 = 10;
pub const Anum_pg_attribute_attstorage: u32 = 11;
pub const Anum_pg_attribute_attalign: u32 = 12;
pub const Anum_pg_attribute_attnotnull: u32 = 13;
pub const Anum_pg_attribute_atthasdef: u32 = 14;
pub const Anum_pg_attribute_atthasmissing: u32 = 15;
pub const Anum_pg_attribute_attidentity: u32 = 16;
pub const Anum_pg_attribute_attgenerated: u32 = 17;
pub const Anum_pg_attribute_attisdropped: u32 = 18;
pub const Anum_pg_attribute_attislocal: u32 = 19;
pub const Anum_pg_attribute_attinhcount: u32 = 20;
pub const Anum_pg_attribute_attcollation: u32 = 21;
pub const Anum_pg_attribute_attacl: u32 = 22;
pub const Anum_pg_attribute_attoptions: u32 = 23;
pub const Anum_pg_attribute_attfdwoptions: u32 = 24;
pub const Anum_pg_attribute_attmissingval: u32 = 25;
pub const Natts_pg_attribute: u32 = 25;
pub const ATTRIBUTE_IDENTITY_ALWAYS: u8 = 97u8;
pub const ATTRIBUTE_IDENTITY_BY_DEFAULT: u8 = 100u8;
pub const ATTRIBUTE_GENERATED_STORED: u8 = 115u8;
pub const AGGSPLITOP_COMBINE: u32 = 1;
pub const AGGSPLITOP_SKIPFINAL: u32 = 2;
pub const AGGSPLITOP_SERIALIZE: u32 = 4;
pub const AGGSPLITOP_DESERIALIZE: u32 = 8;
pub const LP_UNUSED: u32 = 0;
pub const LP_NORMAL: u32 = 1;
pub const LP_REDIRECT: u32 = 2;
pub const LP_DEAD: u32 = 3;
pub const SpecTokenOffsetNumber: u32 = 65534;
pub const MovedPartitionsOffsetNumber: u32 = 65533;
pub const FIELDNO_HEAPTUPLEDATA_DATA: u32 = 3;
pub const _FCNTL_H: u32 = 1;
pub const __O_LARGEFILE: u32 = 0;
pub const F_GETLK64: u32 = 5;
pub const F_SETLK64: u32 = 6;
pub const F_SETLKW64: u32 = 7;
pub const O_ACCMODE: u32 = 3;
pub const O_RDONLY: u32 = 0;
pub const O_WRONLY: u32 = 1;
pub const O_RDWR: u32 = 2;
pub const O_CREAT: u32 = 64;
pub const O_EXCL: u32 = 128;
pub const O_NOCTTY: u32 = 256;
pub const O_TRUNC: u32 = 512;
pub const O_APPEND: u32 = 1024;
pub const O_NONBLOCK: u32 = 2048;
pub const O_NDELAY: u32 = 2048;
pub const O_SYNC: u32 = 1052672;
pub const O_FSYNC: u32 = 1052672;
pub const O_ASYNC: u32 = 8192;
pub const __O_DIRECTORY: u32 = 65536;
pub const __O_NOFOLLOW: u32 = 131072;
pub const __O_CLOEXEC: u32 = 524288;
pub const __O_DIRECT: u32 = 16384;
pub const __O_NOATIME: u32 = 262144;
pub const __O_PATH: u32 = 2097152;
pub const __O_DSYNC: u32 = 4096;
pub const __O_TMPFILE: u32 = 4259840;
pub const F_GETLK: u32 = 5;
pub const F_SETLK: u32 = 6;
pub const F_SETLKW: u32 = 7;
pub const O_DIRECTORY: u32 = 65536;
pub const O_NOFOLLOW: u32 = 131072;
pub const O_CLOEXEC: u32 = 524288;
pub const O_DSYNC: u32 = 4096;
pub const O_RSYNC: u32 = 1052672;
pub const F_DUPFD: u32 = 0;
pub const F_GETFD: u32 = 1;
pub const F_SETFD: u32 = 2;
pub const F_GETFL: u32 = 3;
pub const F_SETFL: u32 = 4;
pub const __F_SETOWN: u32 = 8;
pub const __F_GETOWN: u32 = 9;
pub const F_SETOWN: u32 = 8;
pub const F_GETOWN: u32 = 9;
pub const __F_SETSIG: u32 = 10;
pub const __F_GETSIG: u32 = 11;
pub const __F_SETOWN_EX: u32 = 15;
pub const __F_GETOWN_EX: u32 = 16;
pub const F_DUPFD_CLOEXEC: u32 = 1030;
pub const FD_CLOEXEC: u32 = 1;
pub const F_RDLCK: u32 = 0;
pub const F_WRLCK: u32 = 1;
pub const F_UNLCK: u32 = 2;
pub const F_EXLCK: u32 = 4;
pub const F_SHLCK: u32 = 8;
pub const LOCK_SH: u32 = 1;
pub const LOCK_EX: u32 = 2;
pub const LOCK_NB: u32 = 4;
pub const LOCK_UN: u32 = 8;
pub const FAPPEND: u32 = 1024;
pub const FFSYNC: u32 = 1052672;
pub const FASYNC: u32 = 8192;
pub const FNONBLOCK: u32 = 2048;
pub const FNDELAY: u32 = 2048;
pub const __POSIX_FADV_DONTNEED: u32 = 4;
pub const __POSIX_FADV_NOREUSE: u32 = 5;
pub const POSIX_FADV_NORMAL: u32 = 0;
pub const POSIX_FADV_RANDOM: u32 = 1;
pub const POSIX_FADV_SEQUENTIAL: u32 = 2;
pub const POSIX_FADV_WILLNEED: u32 = 3;
pub const POSIX_FADV_DONTNEED: u32 = 4;
pub const POSIX_FADV_NOREUSE: u32 = 5;
pub const AT_FDCWD: i32 = -100;
pub const AT_SYMLINK_NOFOLLOW: u32 = 256;
pub const AT_REMOVEDIR: u32 = 512;
pub const AT_SYMLINK_FOLLOW: u32 = 1024;
pub const AT_EACCESS: u32 = 512;
pub const _BITS_STAT_H: u32 = 1;
pub const _BITS_STRUCT_STAT_H: u32 = 1;
pub const __S_IFMT: u32 = 61440;
pub const __S_IFDIR: u32 = 16384;
pub const __S_IFCHR: u32 = 8192;
pub const __S_IFBLK: u32 = 24576;
pub const __S_IFREG: u32 = 32768;
pub const __S_IFIFO: u32 = 4096;
pub const __S_IFLNK: u32 = 40960;
pub const __S_IFSOCK: u32 = 49152;
pub const __S_ISUID: u32 = 2048;
pub const __S_ISGID: u32 = 1024;
pub const __S_ISVTX: u32 = 512;
pub const __S_IREAD: u32 = 256;
pub const __S_IWRITE: u32 = 128;
pub const __S_IEXEC: u32 = 64;
pub const UTIME_NOW: u32 = 1073741823;
pub const UTIME_OMIT: u32 = 1073741822;
pub const S_IFMT: u32 = 61440;
pub const S_IFDIR: u32 = 16384;
pub const S_IFCHR: u32 = 8192;
pub const S_IFBLK: u32 = 24576;
pub const S_IFREG: u32 = 32768;
pub const S_IFIFO: u32 = 4096;
pub const S_IFLNK: u32 = 40960;
pub const S_IFSOCK: u32 = 49152;
pub const S_ISUID: u32 = 2048;
pub const S_ISGID: u32 = 1024;
pub const S_ISVTX: u32 = 512;
pub const S_IRUSR: u32 = 256;
pub const S_IWUSR: u32 = 128;
pub const S_IXUSR: u32 = 64;
pub const S_IRWXU: u32 = 448;
pub const S_IRGRP: u32 = 32;
pub const S_IWGRP: u32 = 16;
pub const S_IXGRP: u32 = 8;
pub const S_IRWXG: u32 = 56;
pub const S_IROTH: u32 = 4;
pub const S_IWOTH: u32 = 2;
pub const S_IXOTH: u32 = 1;
pub const S_IRWXO: u32 = 7;
pub const R_OK: u32 = 4;
pub const W_OK: u32 = 2;
pub const X_OK: u32 = 1;
pub const F_OK: u32 = 0;
pub const F_ULOCK: u32 = 0;
pub const F_LOCK: u32 = 1;
pub const F_TLOCK: u32 = 2;
pub const F_TEST: u32 = 3;
pub const InvalidXLogRecPtr: u32 = 0;
pub const PG_O_DIRECT: u32 = 0;
pub const OPEN_SYNC_FLAG: u32 = 1052672;
pub const OPEN_DATASYNC_FLAG: u32 = 4096;
pub const FirstGenbkiObjectId: u32 = 10000;
pub const FirstBootstrapObjectId: u32 = 12000;
pub const FirstNormalObjectId: u32 = 16384;
pub const TypeRelationId: Oid = Oid(1247);
pub const TypeRelation_Rowtype_Id: u32 = 71;
pub const Anum_pg_type_oid: u32 = 1;
pub const Anum_pg_type_typname: u32 = 2;
pub const Anum_pg_type_typnamespace: u32 = 3;
pub const Anum_pg_type_typowner: u32 = 4;
pub const Anum_pg_type_typlen: u32 = 5;
pub const Anum_pg_type_typbyval: u32 = 6;
pub const Anum_pg_type_typtype: u32 = 7;
pub const Anum_pg_type_typcategory: u32 = 8;
pub const Anum_pg_type_typispreferred: u32 = 9;
pub const Anum_pg_type_typisdefined: u32 = 10;
pub const Anum_pg_type_typdelim: u32 = 11;
pub const Anum_pg_type_typrelid: u32 = 12;
pub const Anum_pg_type_typelem: u32 = 13;
pub const Anum_pg_type_typarray: u32 = 14;
pub const Anum_pg_type_typinput: u32 = 15;
pub const Anum_pg_type_typoutput: u32 = 16;
pub const Anum_pg_type_typreceive: u32 = 17;
pub const Anum_pg_type_typsend: u32 = 18;
pub const Anum_pg_type_typmodin: u32 = 19;
pub const Anum_pg_type_typmodout: u32 = 20;
pub const Anum_pg_type_typanalyze: u32 = 21;
pub const Anum_pg_type_typalign: u32 = 22;
pub const Anum_pg_type_typstorage: u32 = 23;
pub const Anum_pg_type_typnotnull: u32 = 24;
pub const Anum_pg_type_typbasetype: u32 = 25;
pub const Anum_pg_type_typtypmod: u32 = 26;
pub const Anum_pg_type_typndims: u32 = 27;
pub const Anum_pg_type_typcollation: u32 = 28;
pub const Anum_pg_type_typdefaultbin: u32 = 29;
pub const Anum_pg_type_typdefault: u32 = 30;
pub const Anum_pg_type_typacl: u32 = 31;
pub const Natts_pg_type: u32 = 31;
pub const TYPTYPE_BASE: u8 = 98u8;
pub const TYPTYPE_COMPOSITE: u8 = 99u8;
pub const TYPTYPE_DOMAIN: u8 = 100u8;
pub const TYPTYPE_ENUM: u8 = 101u8;
pub const TYPTYPE_PSEUDO: u8 = 112u8;
pub const TYPTYPE_RANGE: u8 = 114u8;
pub const TYPCATEGORY_INVALID: u8 = 0u8;
pub const TYPCATEGORY_ARRAY: u8 = 65u8;
pub const TYPCATEGORY_BOOLEAN: u8 = 66u8;
pub const TYPCATEGORY_COMPOSITE: u8 = 67u8;
pub const TYPCATEGORY_DATETIME: u8 = 68u8;
pub const TYPCATEGORY_ENUM: u8 = 69u8;
pub const TYPCATEGORY_GEOMETRIC: u8 = 71u8;
pub const TYPCATEGORY_NETWORK: u8 = 73u8;
pub const TYPCATEGORY_NUMERIC: u8 = 78u8;
pub const TYPCATEGORY_PSEUDOTYPE: u8 = 80u8;
pub const TYPCATEGORY_RANGE: u8 = 82u8;
pub const TYPCATEGORY_STRING: u8 = 83u8;
pub const TYPCATEGORY_TIMESPAN: u8 = 84u8;
pub const TYPCATEGORY_USER: u8 = 85u8;
pub const TYPCATEGORY_BITSTRING: u8 = 86u8;
pub const TYPCATEGORY_UNKNOWN: u8 = 88u8;
pub const TYPALIGN_CHAR: u8 = 99u8;
pub const TYPALIGN_SHORT: u8 = 115u8;
pub const TYPALIGN_INT: u8 = 105u8;
pub const TYPALIGN_DOUBLE: u8 = 100u8;
pub const TYPSTORAGE_PLAIN: u8 = 112u8;
pub const TYPSTORAGE_EXTERNAL: u8 = 101u8;
pub const TYPSTORAGE_EXTENDED: u8 = 120u8;
pub const TYPSTORAGE_MAIN: u8 = 109u8;
pub const BOOLOID: Oid = Oid(16);
pub const BYTEAOID: Oid = Oid(17);
pub const CHAROID: Oid = Oid(18);
pub const NAMEOID: Oid = Oid(19);
pub const INT8OID: Oid = Oid(20);
pub const INT2OID: Oid = Oid(21);
pub const INT2VECTOROID: Oid = Oid(22);
pub const INT4OID: Oid = Oid(23);
pub const REGPROCOID: Oid = Oid(24);
pub const TEXTOID: Oid = Oid(25);
pub const OIDOID: Oid = Oid(26);
pub const TIDOID: Oid = Oid(27);
pub const XIDOID: Oid = Oid(28);
pub const CIDOID: Oid = Oid(29);
pub const OIDVECTOROID: Oid = Oid(30);
pub const JSONOID: Oid = Oid(114);
pub const XMLOID: Oid = Oid(142);
pub const PGNODETREEOID: Oid = Oid(194);
pub const PGNDISTINCTOID: Oid = Oid(3361);
pub const PGDEPENDENCIESOID: Oid = Oid(3402);
pub const PGMCVLISTOID: Oid = Oid(5017);
pub const PGDDLCOMMANDOID: Oid = Oid(32);
pub const XID8OID: Oid = Oid(5069);
pub const POINTOID: Oid = Oid(600);
pub const LSEGOID: Oid = Oid(601);
pub const PATHOID: Oid = Oid(602);
pub const BOXOID: Oid = Oid(603);
pub const POLYGONOID: Oid = Oid(604);
pub const LINEOID: Oid = Oid(628);
pub const FLOAT4OID: Oid = Oid(700);
pub const FLOAT8OID: Oid = Oid(701);
pub const UNKNOWNOID: Oid = Oid(705);
pub const CIRCLEOID: Oid = Oid(718);
pub const CASHOID: Oid = Oid(790);
pub const MACADDROID: Oid = Oid(829);
pub const INETOID: Oid = Oid(869);
pub const CIDROID: Oid = Oid(650);
pub const MACADDR8OID: Oid = Oid(774);
pub const ACLITEMOID: Oid = Oid(1033);
pub const BPCHAROID: Oid = Oid(1042);
pub const VARCHAROID: Oid = Oid(1043);
pub const DATEOID: Oid = Oid(1082);
pub const TIMEOID: Oid = Oid(1083);
pub const TIMESTAMPOID: Oid = Oid(1114);
pub const TIMESTAMPTZOID: Oid = Oid(1184);
pub const INTERVALOID: Oid = Oid(1186);
pub const TIMETZOID: Oid = Oid(1266);
pub const BITOID: Oid = Oid(1560);
pub const VARBITOID: Oid = Oid(1562);
pub const NUMERICOID: Oid = Oid(1700);
pub const REFCURSOROID: Oid = Oid(1790);
pub const REGPROCEDUREOID: Oid = Oid(2202);
pub const REGOPEROID: Oid = Oid(2203);
pub const REGOPERATOROID: Oid = Oid(2204);
pub const REGCLASSOID: Oid = Oid(2205);
pub const REGCOLLATIONOID: Oid = Oid(4191);
pub const REGTYPEOID: Oid = Oid(2206);
pub const REGROLEOID: Oid = Oid(4096);
pub const REGNAMESPACEOID: Oid = Oid(4089);
pub const UUIDOID: Oid = Oid(2950);
pub const LSNOID: Oid = Oid(3220);
pub const TSVECTOROID: Oid = Oid(3614);
pub const GTSVECTOROID: Oid = Oid(3642);
pub const TSQUERYOID: Oid = Oid(3615);
pub const REGCONFIGOID: Oid = Oid(3734);
pub const REGDICTIONARYOID: Oid = Oid(3769);
pub const JSONBOID: Oid = Oid(3802);
pub const JSONPATHOID: Oid = Oid(4072);
pub const TXID_SNAPSHOTOID: Oid = Oid(2970);
pub const PG_SNAPSHOTOID: Oid = Oid(5038);
pub const INT4RANGEOID: Oid = Oid(3904);
pub const NUMRANGEOID: Oid = Oid(3906);
pub const TSRANGEOID: Oid = Oid(3908);
pub const TSTZRANGEOID: Oid = Oid(3910);
pub const DATERANGEOID: Oid = Oid(3912);
pub const INT8RANGEOID: Oid = Oid(3926);
pub const RECORDOID: Oid = Oid(2249);
pub const RECORDARRAYOID: Oid = Oid(2287);
pub const CSTRINGOID: Oid = Oid(2275);
pub const ANYOID: Oid = Oid(2276);
pub const ANYARRAYOID: Oid = Oid(2277);
pub const VOIDOID: Oid = Oid(2278);
pub const TRIGGEROID: Oid = Oid(2279);
pub const EVTTRIGGEROID: Oid = Oid(3838);
pub const LANGUAGE_HANDLEROID: Oid = Oid(2280);
pub const INTERNALOID: Oid = Oid(2281);
pub const ANYELEMENTOID: Oid = Oid(2283);
pub const ANYNONARRAYOID: Oid = Oid(2776);
pub const ANYENUMOID: Oid = Oid(3500);
pub const FDW_HANDLEROID: Oid = Oid(3115);
pub const INDEX_AM_HANDLEROID: Oid = Oid(325);
pub const TSM_HANDLEROID: Oid = Oid(3310);
pub const TABLE_AM_HANDLEROID: Oid = Oid(269);
pub const ANYRANGEOID: Oid = Oid(3831);
pub const ANYCOMPATIBLEOID: Oid = Oid(5077);
pub const ANYCOMPATIBLEARRAYOID: Oid = Oid(5078);
pub const ANYCOMPATIBLENONARRAYOID: Oid = Oid(5079);
pub const ANYCOMPATIBLERANGEOID: Oid = Oid(5080);
pub const BOOLARRAYOID: Oid = Oid(1000);
pub const BYTEAARRAYOID: Oid = Oid(1001);
pub const CHARARRAYOID: Oid = Oid(1002);
pub const NAMEARRAYOID: Oid = Oid(1003);
pub const INT8ARRAYOID: Oid = Oid(1016);
pub const INT2ARRAYOID: Oid = Oid(1005);
pub const INT2VECTORARRAYOID: Oid = Oid(1006);
pub const INT4ARRAYOID: Oid = Oid(1007);
pub const REGPROCARRAYOID: Oid = Oid(1008);
pub const TEXTARRAYOID: Oid = Oid(1009);
pub const OIDARRAYOID: Oid = Oid(1028);
pub const TIDARRAYOID: Oid = Oid(1010);
pub const XIDARRAYOID: Oid = Oid(1011);
pub const CIDARRAYOID: Oid = Oid(1012);
pub const OIDVECTORARRAYOID: Oid = Oid(1013);
pub const JSONARRAYOID: Oid = Oid(199);
pub const XMLARRAYOID: Oid = Oid(143);
pub const XID8ARRAYOID: Oid = Oid(271);
pub const POINTARRAYOID: Oid = Oid(1017);
pub const LSEGARRAYOID: Oid = Oid(1018);
pub const PATHARRAYOID: Oid = Oid(1019);
pub const BOXARRAYOID: Oid = Oid(1020);
pub const POLYGONARRAYOID: Oid = Oid(1027);
pub const LINEARRAYOID: Oid = Oid(629);
pub const FLOAT4ARRAYOID: Oid = Oid(1021);
pub const FLOAT8ARRAYOID: Oid = Oid(1022);
pub const CIRCLEARRAYOID: Oid = Oid(719);
pub const MONEYARRAYOID: Oid = Oid(791);
pub const MACADDRARRAYOID: Oid = Oid(1040);
pub const INETARRAYOID: Oid = Oid(1041);
pub const CIDRARRAYOID: Oid = Oid(651);
pub const MACADDR8ARRAYOID: Oid = Oid(775);
pub const ACLITEMARRAYOID: Oid = Oid(1034);
pub const BPCHARARRAYOID: Oid = Oid(1014);
pub const VARCHARARRAYOID: Oid = Oid(1015);
pub const DATEARRAYOID: Oid = Oid(1182);
pub const TIMEARRAYOID: Oid = Oid(1183);
pub const TIMESTAMPARRAYOID: Oid = Oid(1115);
pub const TIMESTAMPTZARRAYOID: Oid = Oid(1185);
pub const INTERVALARRAYOID: Oid = Oid(1187);
pub const TIMETZARRAYOID: Oid = Oid(1270);
pub const BITARRAYOID: Oid = Oid(1561);
pub const VARBITARRAYOID: Oid = Oid(1563);
pub const NUMERICARRAYOID: Oid = Oid(1231);
pub const REFCURSORARRAYOID: Oid = Oid(2201);
pub const REGPROCEDUREARRAYOID: Oid = Oid(2207);
pub const REGOPERARRAYOID: Oid = Oid(2208);
pub const REGOPERATORARRAYOID: Oid = Oid(2209);
pub const REGCLASSARRAYOID: Oid = Oid(2210);
pub const REGCOLLATIONARRAYOID: Oid = Oid(4192);
pub const REGTYPEARRAYOID: Oid = Oid(2211);
pub const REGROLEARRAYOID: Oid = Oid(4097);
pub const REGNAMESPACEARRAYOID: Oid = Oid(4090);
pub const UUIDARRAYOID: Oid = Oid(2951);
pub const PG_LSNARRAYOID: Oid = Oid(3221);
pub const TSVECTORARRAYOID: Oid = Oid(3643);
pub const GTSVECTORARRAYOID: Oid = Oid(3644);
pub const TSQUERYARRAYOID: Oid = Oid(3645);
pub const REGCONFIGARRAYOID: Oid = Oid(3735);
pub const REGDICTIONARYARRAYOID: Oid = Oid(3770);
pub const JSONBARRAYOID: Oid = Oid(3807);
pub const JSONPATHARRAYOID: Oid = Oid(4073);
pub const TXID_SNAPSHOTARRAYOID: Oid = Oid(2949);
pub const PG_SNAPSHOTARRAYOID: Oid = Oid(5039);
pub const INT4RANGEARRAYOID: Oid = Oid(3905);
pub const NUMRANGEARRAYOID: Oid = Oid(3907);
pub const TSRANGEARRAYOID: Oid = Oid(3909);
pub const TSTZRANGEARRAYOID: Oid = Oid(3911);
pub const DATERANGEARRAYOID: Oid = Oid(3913);
pub const INT8RANGEARRAYOID: Oid = Oid(3927);
pub const CSTRINGARRAYOID: Oid = Oid(1263);
pub const PD_HAS_FREE_LINES: u32 = 1;
pub const PD_PAGE_FULL: u32 = 2;
pub const PD_ALL_VISIBLE: u32 = 4;
pub const PD_VALID_FLAG_BITS: u32 = 7;
pub const PG_PAGE_LAYOUT_VERSION: u32 = 4;
pub const PG_DATA_CHECKSUM_VERSION: u32 = 1;
pub const PAI_OVERWRITE: u32 = 1;
pub const PAI_IS_HEAP: u32 = 2;
pub const PIV_LOG_WARNING: u32 = 1;
pub const PIV_REPORT_STAT: u32 = 2;
pub const MaxTupleAttributeNumber: u32 = 1664;
pub const MaxHeapAttributeNumber: u32 = 1600;
pub const FIELDNO_HEAPTUPLEHEADERDATA_INFOMASK2: u32 = 2;
pub const FIELDNO_HEAPTUPLEHEADERDATA_INFOMASK: u32 = 3;
pub const FIELDNO_HEAPTUPLEHEADERDATA_HOFF: u32 = 4;
pub const FIELDNO_HEAPTUPLEHEADERDATA_BITS: u32 = 5;
pub const HEAP_HASNULL: u32 = 1;
pub const HEAP_HASVARWIDTH: u32 = 2;
pub const HEAP_HASEXTERNAL: u32 = 4;
pub const HEAP_HASOID_OLD: u32 = 8;
pub const HEAP_XMAX_KEYSHR_LOCK: u32 = 16;
pub const HEAP_COMBOCID: u32 = 32;
pub const HEAP_XMAX_EXCL_LOCK: u32 = 64;
pub const HEAP_XMAX_LOCK_ONLY: u32 = 128;
pub const HEAP_XMAX_SHR_LOCK: u32 = 80;
pub const HEAP_LOCK_MASK: u32 = 80;
pub const HEAP_XMIN_COMMITTED: u32 = 256;
pub const HEAP_XMIN_INVALID: u32 = 512;
pub const HEAP_XMIN_FROZEN: u32 = 768;
pub const HEAP_XMAX_COMMITTED: u32 = 1024;
pub const HEAP_XMAX_INVALID: u32 = 2048;
pub const HEAP_XMAX_IS_MULTI: u32 = 4096;
pub const HEAP_UPDATED: u32 = 8192;
pub const HEAP_MOVED_OFF: u32 = 16384;
pub const HEAP_MOVED_IN: u32 = 32768;
pub const HEAP_MOVED: u32 = 49152;
pub const HEAP_XACT_MASK: u32 = 65520;
pub const HEAP_XMAX_BITS: u32 = 7376;
pub const HEAP_NATTS_MASK: u32 = 2047;
pub const HEAP_KEYS_UPDATED: u32 = 8192;
pub const HEAP_HOT_UPDATED: u32 = 16384;
pub const HEAP_ONLY_TUPLE: u32 = 32768;
pub const HEAP2_XACT_MASK: u32 = 57344;
pub const HEAP_TUPLE_HAS_MATCH: u32 = 32768;
pub const MaxAttrSize: u32 = 10485760;
pub const SelfItemPointerAttributeNumber: i32 = -1;
pub const MinTransactionIdAttributeNumber: i32 = -2;
pub const MinCommandIdAttributeNumber: i32 = -3;
pub const MaxTransactionIdAttributeNumber: i32 = -4;
pub const MaxCommandIdAttributeNumber: i32 = -5;
pub const TableOidAttributeNumber: i32 = -6;
pub const FirstLowInvalidHeapAttributeNumber: i32 = -7;
pub const InvalidBuffer: u32 = 0;
pub const TTS_FLAG_EMPTY: u32 = 2;
pub const TTS_FLAG_SHOULDFREE: u32 = 4;
pub const TTS_FLAG_SLOW: u32 = 8;
pub const TTS_FLAG_FIXED: u32 = 16;
pub const FIELDNO_TUPLETABLESLOT_FLAGS: u32 = 1;
pub const FIELDNO_TUPLETABLESLOT_NVALID: u32 = 2;
pub const FIELDNO_TUPLETABLESLOT_TUPLEDESCRIPTOR: u32 = 4;
pub const FIELDNO_TUPLETABLESLOT_VALUES: u32 = 5;
pub const FIELDNO_TUPLETABLESLOT_ISNULL: u32 = 6;
pub const FIELDNO_HEAPTUPLETABLESLOT_TUPLE: u32 = 1;
pub const FIELDNO_HEAPTUPLETABLESLOT_OFF: u32 = 2;
pub const FIELDNO_MINIMALTUPLETABLESLOT_TUPLE: u32 = 1;
pub const FIELDNO_MINIMALTUPLETABLESLOT_OFF: u32 = 4;
pub const BITS_PER_BITMAPWORD: u32 = 64;
pub const _TIME_H: u32 = 1;
pub const _BITS_TIME_H: u32 = 1;
pub const CLOCK_REALTIME: u32 = 0;
pub const CLOCK_MONOTONIC: u32 = 1;
pub const CLOCK_PROCESS_CPUTIME_ID: u32 = 2;
pub const CLOCK_THREAD_CPUTIME_ID: u32 = 3;
pub const CLOCK_MONOTONIC_RAW: u32 = 4;
pub const CLOCK_REALTIME_COARSE: u32 = 5;
pub const CLOCK_MONOTONIC_COARSE: u32 = 6;
pub const CLOCK_BOOTTIME: u32 = 7;
pub const CLOCK_REALTIME_ALARM: u32 = 8;
pub const CLOCK_BOOTTIME_ALARM: u32 = 9;
pub const CLOCK_TAI: u32 = 11;
pub const TIMER_ABSTIME: u32 = 1;
pub const __struct_tm_defined: u32 = 1;
pub const __itimerspec_defined: u32 = 1;
pub const TIME_UTC: u32 = 1;
pub const PG_INSTR_CLOCK: u32 = 1;
pub const FIELDNO_FUNCTIONCALLINFODATA_ISNULL: u32 = 4;
pub const FIELDNO_FUNCTIONCALLINFODATA_ARGS: u32 = 6;
pub const PG_MAGIC_FUNCTION_NAME_STRING: &[u8; 14] = b"Pg_magic_func\0";
pub const AGG_CONTEXT_AGGREGATE: u32 = 1;
pub const AGG_CONTEXT_WINDOW: u32 = 2;
pub const PARAM_FLAG_CONST: u32 = 1;
pub const BTLessStrategyNumber: u32 = 1;
pub const BTLessEqualStrategyNumber: u32 = 2;
pub const BTEqualStrategyNumber: u32 = 3;
pub const BTGreaterEqualStrategyNumber: u32 = 4;
pub const BTGreaterStrategyNumber: u32 = 5;
pub const BTMaxStrategyNumber: u32 = 5;
pub const HTEqualStrategyNumber: u32 = 1;
pub const HTMaxStrategyNumber: u32 = 1;
pub const RTLeftStrategyNumber: u32 = 1;
pub const RTOverLeftStrategyNumber: u32 = 2;
pub const RTOverlapStrategyNumber: u32 = 3;
pub const RTOverRightStrategyNumber: u32 = 4;
pub const RTRightStrategyNumber: u32 = 5;
pub const RTSameStrategyNumber: u32 = 6;
pub const RTContainsStrategyNumber: u32 = 7;
pub const RTContainedByStrategyNumber: u32 = 8;
pub const RTOverBelowStrategyNumber: u32 = 9;
pub const RTBelowStrategyNumber: u32 = 10;
pub const RTAboveStrategyNumber: u32 = 11;
pub const RTOverAboveStrategyNumber: u32 = 12;
pub const RTOldContainsStrategyNumber: u32 = 13;
pub const RTOldContainedByStrategyNumber: u32 = 14;
pub const RTKNNSearchStrategyNumber: u32 = 15;
pub const RTContainsElemStrategyNumber: u32 = 16;
pub const RTAdjacentStrategyNumber: u32 = 17;
pub const RTEqualStrategyNumber: u32 = 18;
pub const RTNotEqualStrategyNumber: u32 = 19;
pub const RTLessStrategyNumber: u32 = 20;
pub const RTLessEqualStrategyNumber: u32 = 21;
pub const RTGreaterStrategyNumber: u32 = 22;
pub const RTGreaterEqualStrategyNumber: u32 = 23;
pub const RTSubStrategyNumber: u32 = 24;
pub const RTSubEqualStrategyNumber: u32 = 25;
pub const RTSuperStrategyNumber: u32 = 26;
pub const RTSuperEqualStrategyNumber: u32 = 27;
pub const RTPrefixStrategyNumber: u32 = 28;
pub const RTMaxStrategyNumber: u32 = 28;
pub const INNER_VAR: u32 = 65000;
pub const OUTER_VAR: u32 = 65001;
pub const INDEX_VAR: u32 = 65002;
pub const PRS2_OLD_VARNO: u32 = 1;
pub const PRS2_NEW_VARNO: u32 = 2;
pub const _LIBC_LIMITS_H_: u32 = 1;
pub const MB_LEN_MAX: u32 = 16;
pub const _BITS_POSIX1_LIM_H: u32 = 1;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const NR_OPEN: u32 = 1024;
pub const NGROUPS_MAX: u32 = 65536;
pub const ARG_MAX: u32 = 131072;
pub const LINK_MAX: u32 = 127;
pub const MAX_CANON: u32 = 255;
pub const MAX_INPUT: u32 = 255;
pub const NAME_MAX: u32 = 255;
pub const PATH_MAX: u32 = 4096;
pub const PIPE_BUF: u32 = 4096;
pub const XATTR_NAME_MAX: u32 = 255;
pub const XATTR_SIZE_MAX: u32 = 65536;
pub const XATTR_LIST_MAX: u32 = 65536;
pub const RTSIG_MAX: u32 = 32;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const PTHREAD_KEYS_MAX: u32 = 1024;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const AIO_PRIO_DELTA_MAX: u32 = 20;
pub const PTHREAD_STACK_MIN: u32 = 16384;
pub const DELAYTIMER_MAX: u32 = 2147483647;
pub const TTY_NAME_MAX: u32 = 32;
pub const LOGIN_NAME_MAX: u32 = 256;
pub const HOST_NAME_MAX: u32 = 64;
pub const MQ_PRIO_MAX: u32 = 32768;
pub const SEM_VALUE_MAX: u32 = 2147483647;
pub const _BITS_POSIX2_LIM_H: u32 = 1;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const BC_BASE_MAX: u32 = 99;
pub const BC_DIM_MAX: u32 = 2048;
pub const BC_SCALE_MAX: u32 = 99;
pub const BC_STRING_MAX: u32 = 1000;
pub const COLL_WEIGHTS_MAX: u32 = 255;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 2048;
pub const CHARCLASS_NAME_MAX: u32 = 2048;
pub const RE_DUP_MAX: u32 = 32767;
pub const DSM_IMPL_POSIX: u32 = 1;
pub const DSM_IMPL_SYSV: u32 = 2;
pub const DSM_IMPL_WINDOWS: u32 = 3;
pub const DSM_IMPL_MMAP: u32 = 4;
pub const DEFAULT_DYNAMIC_SHARED_MEMORY_TYPE: u32 = 1;
pub const PG_DYNSHMEM_DIR: &[u8; 12] = b"pg_dynshmem\0";
pub const PG_DYNSHMEM_MMAP_FILE_PREFIX: &[u8; 6] = b"mmap.\0";
pub const DSM_CREATE_NULL_IF_MAXSEGMENTS: u32 = 1;
pub const DSM_HANDLE_INVALID: u32 = 0;
pub const SIZEOF_DSA_POINTER: u32 = 8;
pub const DSA_POINTER_FORMAT: &[u8; 7] = b"%016lx\0";
pub const DSA_ALLOC_HUGE: u32 = 1;
pub const DSA_ALLOC_NO_OOM: u32 = 2;
pub const DSA_ALLOC_ZERO: u32 = 4;
pub const DEFAULT_SPINS_PER_DELAY: u32 = 100;
pub const HASH_PARTITION: u32 = 1;
pub const HASH_SEGMENT: u32 = 2;
pub const HASH_DIRSIZE: u32 = 4;
pub const HASH_FFACTOR: u32 = 8;
pub const HASH_ELEM: u32 = 16;
pub const HASH_BLOBS: u32 = 32;
pub const HASH_FUNCTION: u32 = 64;
pub const HASH_COMPARE: u32 = 128;
pub const HASH_KEYCOPY: u32 = 256;
pub const HASH_ALLOC: u32 = 512;
pub const HASH_CONTEXT: u32 = 1024;
pub const HASH_SHARED_MEM: u32 = 2048;
pub const HASH_ATTACH: u32 = 4096;
pub const HASH_FIXED_SIZE: u32 = 8192;
pub const NO_MAX_DSIZE: i32 = -1;
pub const _DIRENT_H: u32 = 1;
pub const _DIRENT_MATCHES_DIRENT64: u32 = 1;
pub const MAXNAMLEN: u32 = 255;
pub const PG_TEMP_FILES_DIR: &[u8; 10] = b"pgsql_tmp\0";
pub const PG_TEMP_FILE_PREFIX: &[u8; 10] = b"pgsql_tmp\0";
pub const SHARED_TUPLESTORE_SINGLE_PASS: u32 = 1;
pub const MAX_TIMESTAMP_PRECISION: u32 = 6;
pub const MAX_INTERVAL_PRECISION: u32 = 6;
pub const TS_PREC_INV: f64 = 1000000.0;
pub const DAYS_PER_YEAR: f64 = 365.25;
pub const MONTHS_PER_YEAR: u32 = 12;
pub const DAYS_PER_MONTH: u32 = 30;
pub const HOURS_PER_DAY: u32 = 24;
pub const SECS_PER_YEAR: u32 = 31557600;
pub const SECS_PER_DAY: u32 = 86400;
pub const SECS_PER_HOUR: u32 = 3600;
pub const SECS_PER_MINUTE: u32 = 60;
pub const MINS_PER_HOUR: u32 = 60;
pub const MAX_TZDISP_HOUR: u32 = 15;
pub const TZDISP_LIMIT: u32 = 57600;
pub const JULIAN_MINYEAR: i32 = -4713;
pub const JULIAN_MINMONTH: u32 = 11;
pub const JULIAN_MINDAY: u32 = 24;
pub const JULIAN_MAXYEAR: u32 = 5874898;
pub const JULIAN_MAXMONTH: u32 = 6;
pub const JULIAN_MAXDAY: u32 = 3;
pub const UNIX_EPOCH_JDATE: u32 = 2440588;
pub const POSTGRES_EPOCH_JDATE: u32 = 2451545;
pub const DATETIME_MIN_JULIAN: u32 = 0;
pub const DATE_END_JULIAN: u32 = 2147483494;
pub const TIMESTAMP_END_JULIAN: u32 = 109203528;
pub const RELCACHE_INIT_FILENAME: &[u8; 17] = b"pg_internal.init\0";
pub const INDEX_SIZE_MASK: u32 = 8191;
pub const INDEX_AM_RESERVED_BIT: u32 = 8192;
pub const INDEX_VAR_MASK: u32 = 16384;
pub const INDEX_NULL_MASK: u32 = 32768;
pub const NUM_TUPLESORTMETHODS: u32 = 4;
pub const EEO_FLAG_IS_QUAL: u32 = 1;
pub const FIELDNO_EXPRSTATE_RESNULL: u32 = 2;
pub const FIELDNO_EXPRSTATE_RESVALUE: u32 = 3;
pub const FIELDNO_EXPRSTATE_RESULTSLOT: u32 = 4;
pub const FIELDNO_EXPRSTATE_PARENT: u32 = 11;
pub const FIELDNO_EXPRCONTEXT_SCANTUPLE: u32 = 1;
pub const FIELDNO_EXPRCONTEXT_INNERTUPLE: u32 = 2;
pub const FIELDNO_EXPRCONTEXT_OUTERTUPLE: u32 = 3;
pub const FIELDNO_EXPRCONTEXT_AGGVALUES: u32 = 8;
pub const FIELDNO_EXPRCONTEXT_AGGNULLS: u32 = 9;
pub const FIELDNO_EXPRCONTEXT_CASEDATUM: u32 = 10;
pub const FIELDNO_EXPRCONTEXT_CASENULL: u32 = 11;
pub const FIELDNO_EXPRCONTEXT_DOMAINDATUM: u32 = 12;
pub const FIELDNO_EXPRCONTEXT_DOMAINNULL: u32 = 13;
pub const FIELDNO_AGGSTATE_CURAGGCONTEXT: u32 = 14;
pub const FIELDNO_AGGSTATE_CURPERTRANS: u32 = 16;
pub const FIELDNO_AGGSTATE_CURRENT_SET: u32 = 20;
pub const FIELDNO_AGGSTATE_ALL_PERGROUPS: u32 = 53;
pub const COMPLETION_TAG_BUFSIZE: u32 = 64;
pub const ACL_INSERT: u32 = 1;
pub const ACL_SELECT: u32 = 2;
pub const ACL_UPDATE: u32 = 4;
pub const ACL_DELETE: u32 = 8;
pub const ACL_TRUNCATE: u32 = 16;
pub const ACL_REFERENCES: u32 = 32;
pub const ACL_TRIGGER: u32 = 64;
pub const ACL_EXECUTE: u32 = 128;
pub const ACL_USAGE: u32 = 256;
pub const ACL_CREATE: u32 = 512;
pub const ACL_CREATE_TEMP: u32 = 1024;
pub const ACL_CONNECT: u32 = 2048;
pub const N_ACL_RIGHTS: u32 = 12;
pub const ACL_NO_RIGHTS: u32 = 0;
pub const ACL_SELECT_FOR_UPDATE: u32 = 4;
pub const FRAMEOPTION_NONDEFAULT: u32 = 1;
pub const FRAMEOPTION_RANGE: u32 = 2;
pub const FRAMEOPTION_ROWS: u32 = 4;
pub const FRAMEOPTION_GROUPS: u32 = 8;
pub const FRAMEOPTION_BETWEEN: u32 = 16;
pub const FRAMEOPTION_START_UNBOUNDED_PRECEDING: u32 = 32;
pub const FRAMEOPTION_END_UNBOUNDED_PRECEDING: u32 = 64;
pub const FRAMEOPTION_START_UNBOUNDED_FOLLOWING: u32 = 128;
pub const FRAMEOPTION_END_UNBOUNDED_FOLLOWING: u32 = 256;
pub const FRAMEOPTION_START_CURRENT_ROW: u32 = 512;
pub const FRAMEOPTION_END_CURRENT_ROW: u32 = 1024;
pub const FRAMEOPTION_START_OFFSET_PRECEDING: u32 = 2048;
pub const FRAMEOPTION_END_OFFSET_PRECEDING: u32 = 4096;
pub const FRAMEOPTION_START_OFFSET_FOLLOWING: u32 = 8192;
pub const FRAMEOPTION_END_OFFSET_FOLLOWING: u32 = 16384;
pub const FRAMEOPTION_EXCLUDE_CURRENT_ROW: u32 = 32768;
pub const FRAMEOPTION_EXCLUDE_GROUP: u32 = 65536;
pub const FRAMEOPTION_EXCLUDE_TIES: u32 = 131072;
pub const FRAMEOPTION_START_OFFSET: u32 = 10240;
pub const FRAMEOPTION_END_OFFSET: u32 = 20480;
pub const FRAMEOPTION_EXCLUSION: u32 = 229376;
pub const FRAMEOPTION_DEFAULTS: u32 = 1058;
pub const PARTITION_STRATEGY_HASH: u8 = 104u8;
pub const PARTITION_STRATEGY_LIST: u8 = 108u8;
pub const PARTITION_STRATEGY_RANGE: u8 = 114u8;
pub const FKCONSTR_ACTION_NOACTION: u8 = 97u8;
pub const FKCONSTR_ACTION_RESTRICT: u8 = 114u8;
pub const FKCONSTR_ACTION_CASCADE: u8 = 99u8;
pub const FKCONSTR_ACTION_SETNULL: u8 = 110u8;
pub const FKCONSTR_ACTION_SETDEFAULT: u8 = 100u8;
pub const FKCONSTR_MATCH_FULL: u8 = 102u8;
pub const FKCONSTR_MATCH_PARTIAL: u8 = 112u8;
pub const FKCONSTR_MATCH_SIMPLE: u8 = 115u8;
pub const OPCLASS_ITEM_OPERATOR: u32 = 1;
pub const OPCLASS_ITEM_FUNCTION: u32 = 2;
pub const OPCLASS_ITEM_STORAGETYPE: u32 = 3;
pub const CURSOR_OPT_BINARY: u32 = 1;
pub const CURSOR_OPT_SCROLL: u32 = 2;
pub const CURSOR_OPT_NO_SCROLL: u32 = 4;
pub const CURSOR_OPT_INSENSITIVE: u32 = 8;
pub const CURSOR_OPT_HOLD: u32 = 16;
pub const CURSOR_OPT_FAST_PLAN: u32 = 32;
pub const CURSOR_OPT_GENERIC_PLAN: u32 = 64;
pub const CURSOR_OPT_CUSTOM_PLAN: u32 = 128;
pub const CURSOR_OPT_PARALLEL_OK: u32 = 256;
pub const REINDEXOPT_VERBOSE: u32 = 1;
pub const REINDEXOPT_REPORT_PROGRESS: u32 = 2;
pub const MaxAllocHugeSize: u32 = 0;
pub const ALLOCSET_DEFAULT_MINSIZE: u32 = 0;
pub const ALLOCSET_DEFAULT_INITSIZE: u32 = 8192;
pub const ALLOCSET_DEFAULT_MAXSIZE: u32 = 8388608;
pub const ALLOCSET_SMALL_MINSIZE: u32 = 0;
pub const ALLOCSET_SMALL_INITSIZE: u32 = 1024;
pub const ALLOCSET_SMALL_MAXSIZE: u32 = 8192;
pub const ALLOCSET_SEPARATE_THRESHOLD: u32 = 8192;
pub const SLAB_DEFAULT_BLOCK_SIZE: u32 = 8192;
pub const SLAB_LARGE_BLOCK_SIZE: u32 = 8388608;
pub const EXEC_FLAG_EXPLAIN_ONLY: u32 = 1;
pub const EXEC_FLAG_REWIND: u32 = 2;
pub const EXEC_FLAG_BACKWARD: u32 = 4;
pub const EXEC_FLAG_MARK: u32 = 8;
pub const EXEC_FLAG_SKIP_TRIGGERS: u32 = 16;
pub const EXEC_FLAG_WITH_NO_DATA: u32 = 32;
pub const _BITS_SIGNUM_GENERIC_H: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGILL: u32 = 4;
pub const SIGABRT: u32 = 6;
pub const SIGFPE: u32 = 8;
pub const SIGSEGV: u32 = 11;
pub const SIGTERM: u32 = 15;
pub const SIGHUP: u32 = 1;
pub const SIGQUIT: u32 = 3;
pub const SIGTRAP: u32 = 5;
pub const SIGKILL: u32 = 9;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGIOT: u32 = 6;
pub const _BITS_SIGNUM_ARCH_H: u32 = 1;
pub const SIGSTKFLT: u32 = 16;
pub const SIGPWR: u32 = 30;
pub const SIGBUS: u32 = 7;
pub const SIGSYS: u32 = 31;
pub const SIGURG: u32 = 23;
pub const SIGSTOP: u32 = 19;
pub const SIGTSTP: u32 = 20;
pub const SIGCONT: u32 = 18;
pub const SIGCHLD: u32 = 17;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGPOLL: u32 = 29;
pub const SIGXFSZ: u32 = 25;
pub const SIGXCPU: u32 = 24;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGUSR1: u32 = 10;
pub const SIGUSR2: u32 = 12;
pub const SIGWINCH: u32 = 28;
pub const SIGIO: u32 = 29;
pub const SIGCLD: u32 = 17;
pub const __SIGRTMIN: u32 = 32;
pub const __SIGRTMAX: u32 = 64;
pub const _NSIG: u32 = 65;
pub const __sig_atomic_t_defined: u32 = 1;
pub const __siginfo_t_defined: u32 = 1;
pub const __SI_MAX_SIZE: u32 = 128;
pub const _BITS_SIGINFO_ARCH_H: u32 = 1;
pub const __SI_ERRNO_THEN_CODE: u32 = 1;
pub const __SI_HAVE_SIGSYS: u32 = 1;
pub const _BITS_SIGINFO_CONSTS_H: u32 = 1;
pub const __SI_ASYNCIO_AFTER_SIGIO: u32 = 1;
pub const __sigevent_t_defined: u32 = 1;
pub const __SIGEV_MAX_SIZE: u32 = 64;
pub const _BITS_SIGEVENT_CONSTS_H: u32 = 1;
pub const NSIG: u32 = 65;
pub const _BITS_SIGACTION_H: u32 = 1;
pub const SA_NOCLDSTOP: u32 = 1;
pub const SA_NOCLDWAIT: u32 = 2;
pub const SA_SIGINFO: u32 = 4;
pub const SA_ONSTACK: u32 = 134217728;
pub const SA_RESTART: u32 = 268435456;
pub const SA_NODEFER: u32 = 1073741824;
pub const SA_RESETHAND: u32 = 2147483648;
pub const SA_INTERRUPT: u32 = 536870912;
pub const SA_NOMASK: u32 = 1073741824;
pub const SA_ONESHOT: u32 = 2147483648;
pub const SA_STACK: u32 = 134217728;
pub const SIG_BLOCK: u32 = 0;
pub const SIG_UNBLOCK: u32 = 1;
pub const SIG_SETMASK: u32 = 2;
pub const _BITS_SIGCONTEXT_H: u32 = 1;
pub const FP_XSTATE_MAGIC1: u32 = 1179670611;
pub const FP_XSTATE_MAGIC2: u32 = 1179670597;
pub const __stack_t_defined: u32 = 1;
pub const _SYS_UCONTEXT_H: u32 = 1;
pub const __NGREG: u32 = 23;
pub const NGREG: u32 = 23;
pub const _BITS_SIGSTACK_H: u32 = 1;
pub const MINSIGSTKSZ: u32 = 2048;
pub const SIGSTKSZ: u32 = 8192;
pub const _BITS_SS_FLAGS_H: u32 = 1;
pub const __sigstack_defined: u32 = 1;
pub const _BITS_SIGTHREAD_H: u32 = 1;
pub const TZ_STRLEN_MAX: u32 = 255;
pub const InvalidPid: i32 = -1;
pub const USE_POSTGRES_DATES: u32 = 0;
pub const USE_ISO_DATES: u32 = 1;
pub const USE_SQL_DATES: u32 = 2;
pub const USE_GERMAN_DATES: u32 = 3;
pub const USE_XSD_DATES: u32 = 4;
pub const DATEORDER_YMD: u32 = 0;
pub const DATEORDER_DMY: u32 = 1;
pub const DATEORDER_MDY: u32 = 2;
pub const INTSTYLE_POSTGRES: u32 = 0;
pub const INTSTYLE_POSTGRES_VERBOSE: u32 = 1;
pub const INTSTYLE_SQL_STANDARD: u32 = 2;
pub const INTSTYLE_ISO_8601: u32 = 3;
pub const MAXTZLEN: u32 = 10;
pub const SECURITY_LOCAL_USERID_CHANGE: u32 = 1;
pub const SECURITY_RESTRICTED_OPERATION: u32 = 2;
pub const SECURITY_NOFORCE_RLS: u32 = 4;
pub const _SYS_UN_H: u32 = 1;
pub const SM_DATABASE: u32 = 64;
pub const SM_USER: u32 = 32;
pub const SM_DATABASE_USER: u32 = 97;
pub const SM_OPTIONS: u32 = 64;
pub const SM_UNUSED: u32 = 64;
pub const SM_TTY: u32 = 64;
pub const MAX_STARTUP_PACKET_LENGTH: u32 = 10000;
pub const AUTH_REQ_OK: u32 = 0;
pub const AUTH_REQ_KRB4: u32 = 1;
pub const AUTH_REQ_KRB5: u32 = 2;
pub const AUTH_REQ_PASSWORD: u32 = 3;
pub const AUTH_REQ_CRYPT: u32 = 4;
pub const AUTH_REQ_MD5: u32 = 5;
pub const AUTH_REQ_SCM_CREDS: u32 = 6;
pub const AUTH_REQ_GSS: u32 = 7;
pub const AUTH_REQ_GSS_CONT: u32 = 8;
pub const AUTH_REQ_SSPI: u32 = 9;
pub const AUTH_REQ_SASL: u32 = 10;
pub const AUTH_REQ_SASL_CONT: u32 = 11;
pub const AUTH_REQ_SASL_FIN: u32 = 12;
pub const MIN_XFN_CHARS: u32 = 16;
pub const MAX_XFN_CHARS: u32 = 40;
pub const VALID_XFN_CHARS: &[u8; 40] = b"0123456789ABCDEF.history.backup.partial\0";
pub const CATALOG_VERSION_NO: u32 = 202007201;
pub const OIDCHARS: u32 = 10;
pub const FORKNAMECHARS: u32 = 4;
pub const InvalidBackendId: i32 = -1;
pub const XLR_INFO_MASK: u32 = 15;
pub const XLR_RMGR_INFO_MASK: u32 = 240;
pub const XLR_SPECIAL_REL_UPDATE: u32 = 1;
pub const XLR_CHECK_CONSISTENCY: u32 = 2;
pub const BKPIMAGE_HAS_HOLE: u32 = 1;
pub const BKPIMAGE_IS_COMPRESSED: u32 = 2;
pub const BKPIMAGE_APPLY: u32 = 4;
pub const BKPBLOCK_FORK_MASK: u32 = 15;
pub const BKPBLOCK_FLAG_MASK: u32 = 240;
pub const BKPBLOCK_HAS_IMAGE: u32 = 16;
pub const BKPBLOCK_HAS_DATA: u32 = 32;
pub const BKPBLOCK_WILL_INIT: u32 = 64;
pub const BKPBLOCK_SAME_REL: u32 = 128;
pub const XLR_MAX_BLOCK_ID: u32 = 32;
pub const XLR_BLOCK_ID_DATA_SHORT: u32 = 255;
pub const XLR_BLOCK_ID_DATA_LONG: u32 = 254;
pub const XLR_BLOCK_ID_ORIGIN: u32 = 253;
pub const TRANSACTION_STATUS_IN_PROGRESS: u32 = 0;
pub const TRANSACTION_STATUS_COMMITTED: u32 = 1;
pub const TRANSACTION_STATUS_ABORTED: u32 = 2;
pub const TRANSACTION_STATUS_SUB_COMMITTED: u32 = 3;
pub const CLOG_ZEROPAGE: u32 = 0;
pub const CLOG_TRUNCATE: u32 = 16;
pub const WL_LATCH_SET: u32 = 1;
pub const WL_SOCKET_READABLE: u32 = 2;
pub const WL_SOCKET_WRITEABLE: u32 = 4;
pub const WL_TIMEOUT: u32 = 8;
pub const WL_POSTMASTER_DEATH: u32 = 16;
pub const WL_EXIT_ON_PM_DEATH: u32 = 32;
pub const WL_SOCKET_CONNECTED: u32 = 4;
pub const WL_SOCKET_MASK: u32 = 6;
pub const NoLock: u32 = 0;
pub const AccessShareLock: u32 = 1;
pub const RowShareLock: u32 = 2;
pub const RowExclusiveLock: u32 = 3;
pub const ShareUpdateExclusiveLock: u32 = 4;
pub const ShareLock: u32 = 5;
pub const ShareRowExclusiveLock: u32 = 6;
pub const ExclusiveLock: u32 = 7;
pub const AccessExclusiveLock: u32 = 8;
pub const MaxLockMode: u32 = 8;
pub const LWLOCK_PADDED_SIZE: u32 = 128;
pub const NUM_INDIVIDUAL_LWLOCKS: u32 = 48;
pub const NUM_BUFFER_PARTITIONS: u32 = 128;
pub const LOG2_NUM_LOCK_PARTITIONS: u32 = 4;
pub const NUM_LOCK_PARTITIONS: u32 = 16;
pub const LOG2_NUM_PREDICATELOCK_PARTITIONS: u32 = 4;
pub const NUM_PREDICATELOCK_PARTITIONS: u32 = 16;
pub const BUFFER_MAPPING_LWLOCK_OFFSET: u32 = 48;
pub const LOCK_MANAGER_LWLOCK_OFFSET: u32 = 176;
pub const PREDICATELOCK_MANAGER_LWLOCK_OFFSET: u32 = 192;
pub const NUM_FIXED_LWLOCKS: u32 = 208;
pub const SHMEM_INDEX_KEYSIZE: u32 = 48;
pub const SHMEM_INDEX_SIZE: u32 = 64;
pub const InvalidLocalTransactionId: u32 = 0;
pub const MAX_LOCKMODES: u32 = 10;
pub const DEFAULT_LOCKMETHOD: u32 = 1;
pub const USER_LOCKMETHOD: u32 = 2;
pub const PGPROC_MAX_CACHED_SUBXIDS: u32 = 64;
pub const PROC_IS_AUTOVACUUM: u32 = 1;
pub const PROC_IN_VACUUM: u32 = 2;
pub const PROC_IN_ANALYZE: u32 = 4;
pub const PROC_VACUUM_FOR_WRAPAROUND: u32 = 8;
pub const PROC_IN_LOGICAL_DECODING: u32 = 16;
pub const PROC_RESERVED: u32 = 32;
pub const PROC_VACUUM_STATE_MASK: u32 = 14;
pub const PROC_XMIN_FLAGS: u32 = 2;
pub const FP_LOCK_SLOTS_PER_BACKEND: u32 = 16;
pub const INVALID_PGPROCNO: u32 = 2147483647;
pub const DELAY_CHKPT_START: u32 = 1;
pub const DELAY_CHKPT_COMPLETE: u32 = 2;
pub const NUM_AUXILIARY_PROCS: u32 = 4;
pub const PGSTAT_STAT_PERMANENT_DIRECTORY: &[u8; 8] = b"pg_stat\0";
pub const PGSTAT_STAT_PERMANENT_FILENAME: &[u8; 20] = b"pg_stat/global.stat\0";
pub const PGSTAT_STAT_PERMANENT_TMPFILE: &[u8; 19] = b"pg_stat/global.tmp\0";
pub const PG_STAT_TMP_DIR: &[u8; 12] = b"pg_stat_tmp\0";
pub const PGSTAT_MAX_MSG_SIZE: u32 = 1000;
pub const PGSTAT_FILE_FORMAT_ID: u32 = 27638941;
pub const PG_WAIT_LWLOCK: u32 = 16777216;
pub const PG_WAIT_LOCK: u32 = 50331648;
pub const PG_WAIT_BUFFER_PIN: u32 = 67108864;
pub const PG_WAIT_ACTIVITY: u32 = 83886080;
pub const PG_WAIT_CLIENT: u32 = 100663296;
pub const PG_WAIT_EXTENSION: u32 = 117440512;
pub const PG_WAIT_IPC: u32 = 134217728;
pub const PG_WAIT_TIMEOUT: u32 = 150994944;
pub const PG_WAIT_IO: u32 = 167772160;
pub const PGSTAT_NUM_PROGRESS_PARAM: u32 = 20;
pub const SK_ISNULL: u32 = 1;
pub const SK_UNARY: u32 = 2;
pub const SK_ROW_HEADER: u32 = 4;
pub const SK_ROW_MEMBER: u32 = 8;
pub const SK_ROW_END: u32 = 16;
pub const SK_SEARCHARRAY: u32 = 32;
pub const SK_SEARCHNULL: u32 = 64;
pub const SK_SEARCHNOTNULL: u32 = 128;
pub const SK_ORDER_BY: u32 = 256;
pub const XLR_NORMAL_MAX_BLOCK_ID: u32 = 4;
pub const XLR_NORMAL_RDATAS: u32 = 20;
pub const REGBUF_FORCE_IMAGE: u32 = 1;
pub const REGBUF_NO_IMAGE: u32 = 2;
pub const REGBUF_WILL_INIT: u32 = 6;
pub const REGBUF_STANDARD: u32 = 8;
pub const REGBUF_KEEP_DATA: u32 = 16;
pub const SYNC_METHOD_FSYNC: u32 = 0;
pub const SYNC_METHOD_FDATASYNC: u32 = 1;
pub const SYNC_METHOD_OPEN: u32 = 2;
pub const SYNC_METHOD_FSYNC_WRITETHROUGH: u32 = 3;
pub const SYNC_METHOD_OPEN_DSYNC: u32 = 4;
pub const CHECKPOINT_IS_SHUTDOWN: u32 = 1;
pub const CHECKPOINT_END_OF_RECOVERY: u32 = 2;
pub const CHECKPOINT_IMMEDIATE: u32 = 4;
pub const CHECKPOINT_FORCE: u32 = 8;
pub const CHECKPOINT_FLUSH_ALL: u32 = 16;
pub const CHECKPOINT_WAIT: u32 = 32;
pub const CHECKPOINT_REQUESTED: u32 = 64;
pub const CHECKPOINT_CAUSE_XLOG: u32 = 128;
pub const CHECKPOINT_CAUSE_TIME: u32 = 256;
pub const XLOG_INCLUDE_ORIGIN: u32 = 1;
pub const XLOG_MARK_UNIMPORTANT: u32 = 2;
pub const RECOVERY_SIGNAL_FILE: &[u8; 16] = b"recovery.signal\0";
pub const STANDBY_SIGNAL_FILE: &[u8; 15] = b"standby.signal\0";
pub const BACKUP_LABEL_FILE: &[u8; 13] = b"backup_label\0";
pub const BACKUP_LABEL_OLD: &[u8; 17] = b"backup_label.old\0";
pub const TABLESPACE_MAP: &[u8; 15] = b"tablespace_map\0";
pub const TABLESPACE_MAP_OLD: &[u8; 19] = b"tablespace_map.old\0";
pub const PROMOTE_SIGNAL_FILE: &[u8; 8] = b"promote\0";
pub const FALLBACK_PROMOTE_SIGNAL_FILE: &[u8; 17] = b"fallback_promote\0";
pub const XLOG_PAGE_MAGIC: u32 = 53510;
pub const XLP_FIRST_IS_CONTRECORD: u32 = 1;
pub const XLP_LONG_HEADER: u32 = 2;
pub const XLP_BKP_REMOVABLE: u32 = 4;
pub const XLP_FIRST_IS_OVERWRITE_CONTRECORD: u32 = 8;
pub const XLP_ALL_FLAGS: u32 = 15;
pub const WalSegMinSize: u32 = 1048576;
pub const WalSegMaxSize: u32 = 1073741824;
pub const DEFAULT_MIN_WAL_SEGS: u32 = 5;
pub const DEFAULT_MAX_WAL_SEGS: u32 = 64;
pub const XLOGDIR: &[u8; 7] = b"pg_wal\0";
pub const XLOG_CONTROL_FILE: &[u8; 18] = b"global/pg_control\0";
pub const MAXFNAMELEN: u32 = 64;
pub const XLOG_FNAME_LEN: u32 = 24;
pub const RelationRelationId: Oid = Oid(1259);
pub const RelationRelation_Rowtype_Id: u32 = 83;
pub const Anum_pg_class_oid: u32 = 1;
pub const Anum_pg_class_relname: u32 = 2;
pub const Anum_pg_class_relnamespace: u32 = 3;
pub const Anum_pg_class_reltype: u32 = 4;
pub const Anum_pg_class_reloftype: u32 = 5;
pub const Anum_pg_class_relowner: u32 = 6;
pub const Anum_pg_class_relam: u32 = 7;
pub const Anum_pg_class_relfilenode: u32 = 8;
pub const Anum_pg_class_reltablespace: u32 = 9;
pub const Anum_pg_class_relpages: u32 = 10;
pub const Anum_pg_class_reltuples: u32 = 11;
pub const Anum_pg_class_relallvisible: u32 = 12;
pub const Anum_pg_class_reltoastrelid: u32 = 13;
pub const Anum_pg_class_relhasindex: u32 = 14;
pub const Anum_pg_class_relisshared: u32 = 15;
pub const Anum_pg_class_relpersistence: u32 = 16;
pub const Anum_pg_class_relkind: u32 = 17;
pub const Anum_pg_class_relnatts: u32 = 18;
pub const Anum_pg_class_relchecks: u32 = 19;
pub const Anum_pg_class_relhasrules: u32 = 20;
pub const Anum_pg_class_relhastriggers: u32 = 21;
pub const Anum_pg_class_relhassubclass: u32 = 22;
pub const Anum_pg_class_relrowsecurity: u32 = 23;
pub const Anum_pg_class_relforcerowsecurity: u32 = 24;
pub const Anum_pg_class_relispopulated: u32 = 25;
pub const Anum_pg_class_relreplident: u32 = 26;
pub const Anum_pg_class_relispartition: u32 = 27;
pub const Anum_pg_class_relrewrite: u32 = 28;
pub const Anum_pg_class_relfrozenxid: u32 = 29;
pub const Anum_pg_class_relminmxid: u32 = 30;
pub const Anum_pg_class_relacl: u32 = 31;
pub const Anum_pg_class_reloptions: u32 = 32;
pub const Anum_pg_class_relpartbound: u32 = 33;
pub const Natts_pg_class: u32 = 33;
pub const RELKIND_RELATION: u8 = 114u8;
pub const RELKIND_INDEX: u8 = 105u8;
pub const RELKIND_SEQUENCE: u8 = 83u8;
pub const RELKIND_TOASTVALUE: u8 = 116u8;
pub const RELKIND_VIEW: u8 = 118u8;
pub const RELKIND_MATVIEW: u8 = 109u8;
pub const RELKIND_COMPOSITE_TYPE: u8 = 99u8;
pub const RELKIND_FOREIGN_TABLE: u8 = 102u8;
pub const RELKIND_PARTITIONED_TABLE: u8 = 112u8;
pub const RELKIND_PARTITIONED_INDEX: u8 = 73u8;
pub const RELPERSISTENCE_PERMANENT: u8 = 112u8;
pub const RELPERSISTENCE_UNLOGGED: u8 = 117u8;
pub const RELPERSISTENCE_TEMP: u8 = 116u8;
pub const REPLICA_IDENTITY_DEFAULT: u8 = 100u8;
pub const REPLICA_IDENTITY_NOTHING: u8 = 110u8;
pub const REPLICA_IDENTITY_FULL: u8 = 102u8;
pub const REPLICA_IDENTITY_INDEX: u8 = 105u8;
pub const IndexRelationId: Oid = Oid(2610);
pub const Anum_pg_index_indexrelid: u32 = 1;
pub const Anum_pg_index_indrelid: u32 = 2;
pub const Anum_pg_index_indnatts: u32 = 3;
pub const Anum_pg_index_indnkeyatts: u32 = 4;
pub const Anum_pg_index_indisunique: u32 = 5;
pub const Anum_pg_index_indisprimary: u32 = 6;
pub const Anum_pg_index_indisexclusion: u32 = 7;
pub const Anum_pg_index_indimmediate: u32 = 8;
pub const Anum_pg_index_indisclustered: u32 = 9;
pub const Anum_pg_index_indisvalid: u32 = 10;
pub const Anum_pg_index_indcheckxmin: u32 = 11;
pub const Anum_pg_index_indisready: u32 = 12;
pub const Anum_pg_index_indislive: u32 = 13;
pub const Anum_pg_index_indisreplident: u32 = 14;
pub const Anum_pg_index_indkey: u32 = 15;
pub const Anum_pg_index_indcollation: u32 = 16;
pub const Anum_pg_index_indclass: u32 = 17;
pub const Anum_pg_index_indoption: u32 = 18;
pub const Anum_pg_index_indexprs: u32 = 19;
pub const Anum_pg_index_indpred: u32 = 20;
pub const Natts_pg_index: u32 = 20;
pub const INDOPTION_DESC: u32 = 1;
pub const INDOPTION_NULLS_FIRST: u32 = 2;
pub const PublicationRelationId: Oid = Oid(6104);
pub const Anum_pg_publication_oid: u32 = 1;
pub const Anum_pg_publication_pubname: u32 = 2;
pub const Anum_pg_publication_pubowner: u32 = 3;
pub const Anum_pg_publication_puballtables: u32 = 4;
pub const Anum_pg_publication_pubinsert: u32 = 5;
pub const Anum_pg_publication_pubupdate: u32 = 6;
pub const Anum_pg_publication_pubdelete: u32 = 7;
pub const Anum_pg_publication_pubtruncate: u32 = 8;
pub const Anum_pg_publication_pubviaroot: u32 = 9;
pub const Natts_pg_publication: u32 = 9;
pub const HEAP_MIN_FILLFACTOR: u32 = 10;
pub const HEAP_DEFAULT_FILLFACTOR: u32 = 100;
pub const MAX_GENERIC_XLOG_PAGES: u32 = 4;
pub const GENERIC_XLOG_FULL_IMAGE: u32 = 1;
pub const GIN_COMPARE_PROC: u32 = 1;
pub const GIN_EXTRACTVALUE_PROC: u32 = 2;
pub const GIN_EXTRACTQUERY_PROC: u32 = 3;
pub const GIN_CONSISTENT_PROC: u32 = 4;
pub const GIN_COMPARE_PARTIAL_PROC: u32 = 5;
pub const GIN_TRICONSISTENT_PROC: u32 = 6;
pub const GIN_OPTIONS_PROC: u32 = 7;
pub const GINNProcs: u32 = 7;
pub const GIN_SEARCH_MODE_DEFAULT: u32 = 0;
pub const GIN_SEARCH_MODE_INCLUDE_EMPTY: u32 = 1;
pub const GIN_SEARCH_MODE_ALL: u32 = 2;
pub const GIN_SEARCH_MODE_EVERYTHING: u32 = 3;
pub const GIN_FALSE: u32 = 0;
pub const GIN_TRUE: u32 = 1;
pub const GIN_MAYBE: u32 = 2;
pub const GIST_CONSISTENT_PROC: u32 = 1;
pub const GIST_UNION_PROC: u32 = 2;
pub const GIST_COMPRESS_PROC: u32 = 3;
pub const GIST_DECOMPRESS_PROC: u32 = 4;
pub const GIST_PENALTY_PROC: u32 = 5;
pub const GIST_PICKSPLIT_PROC: u32 = 6;
pub const GIST_EQUAL_PROC: u32 = 7;
pub const GIST_DISTANCE_PROC: u32 = 8;
pub const GIST_FETCH_PROC: u32 = 9;
pub const GIST_OPTIONS_PROC: u32 = 10;
pub const GISTNProcs: u32 = 10;
pub const F_LEAF: u32 = 1;
pub const F_DELETED: u32 = 2;
pub const F_TUPLES_DELETED: u32 = 4;
pub const F_FOLLOW_RIGHT: u32 = 8;
pub const F_HAS_GARBAGE: u32 = 16;
pub const GIST_PAGE_ID: u32 = 65409;
pub const EOH_HEADER_MAGIC: i32 = -1;
pub const EA_MAGIC: u32 = 689375833;
pub const PG_AUTOCONF_FILENAME: &[u8; 21] = b"postgresql.auto.conf\0";
pub const GUC_QUALIFIER_SEPARATOR: u8 = 46u8;
pub const GUC_LIST_INPUT: u32 = 1;
pub const GUC_LIST_QUOTE: u32 = 2;
pub const GUC_NO_SHOW_ALL: u32 = 4;
pub const GUC_NO_RESET_ALL: u32 = 8;
pub const GUC_REPORT: u32 = 16;
pub const GUC_NOT_IN_SAMPLE: u32 = 32;
pub const GUC_DISALLOW_IN_FILE: u32 = 64;
pub const GUC_CUSTOM_PLACEHOLDER: u32 = 128;
pub const GUC_SUPERUSER_ONLY: u32 = 256;
pub const GUC_IS_NAME: u32 = 512;
pub const GUC_NOT_WHILE_SEC_REST: u32 = 1024;
pub const GUC_DISALLOW_IN_AUTO_FILE: u32 = 2048;
pub const GUC_UNIT_KB: u32 = 4096;
pub const GUC_UNIT_BLOCKS: u32 = 8192;
pub const GUC_UNIT_XBLOCKS: u32 = 12288;
pub const GUC_UNIT_MB: u32 = 16384;
pub const GUC_UNIT_BYTE: u32 = 32768;
pub const GUC_UNIT_MEMORY: u32 = 61440;
pub const GUC_UNIT_MS: u32 = 65536;
pub const GUC_UNIT_S: u32 = 131072;
pub const GUC_UNIT_MIN: u32 = 196608;
pub const GUC_UNIT_TIME: u32 = 983040;
pub const GUC_EXPLAIN: u32 = 1048576;
pub const GUC_UNIT: u32 = 1044480;
pub const DEFAULT_TABLE_ACCESS_METHOD: &[u8; 5] = b"heap\0";
pub const TABLE_INSERT_SKIP_FSM: u32 = 2;
pub const TABLE_INSERT_FROZEN: u32 = 4;
pub const TABLE_INSERT_NO_LOGICAL: u32 = 8;
pub const TUPLE_LOCK_FLAG_LOCK_UPDATE_IN_PROGRESS: u32 = 1;
pub const TUPLE_LOCK_FLAG_FIND_LAST_VERSION: u32 = 2;
pub const HEAP_INSERT_SKIP_FSM: u32 = 2;
pub const HEAP_INSERT_FROZEN: u32 = 4;
pub const HEAP_INSERT_NO_LOGICAL: u32 = 8;
pub const HEAP_INSERT_SPECULATIVE: u32 = 16;
pub const SHAREDINVALCATALOG_ID: i32 = -1;
pub const SHAREDINVALRELCACHE_ID: i32 = -2;
pub const SHAREDINVALSMGR_ID: i32 = -3;
pub const SHAREDINVALRELMAP_ID: i32 = -4;
pub const SHAREDINVALSNAPSHOT_ID: i32 = -5;
pub const INTERVAL_FULL_RANGE: u32 = 32767;
pub const INTERVAL_RANGE_MASK: u32 = 32767;
pub const INTERVAL_FULL_PRECISION: u32 = 65535;
pub const INTERVAL_PRECISION_MASK: u32 = 65535;
pub const DAGO: &[u8; 4] = b"ago\0";
pub const DCURRENT: &[u8; 8] = b"current\0";
pub const EPOCH: &[u8; 6] = b"epoch\0";
pub const INVALID: &[u8; 8] = b"invalid\0";
pub const EARLY: &[u8; 10] = b"-infinity\0";
pub const LATE: &[u8; 9] = b"infinity\0";
pub const NOW: &[u8; 4] = b"now\0";
pub const TODAY: &[u8; 6] = b"today\0";
pub const TOMORROW: &[u8; 9] = b"tomorrow\0";
pub const YESTERDAY: &[u8; 10] = b"yesterday\0";
pub const ZULU: &[u8; 5] = b"zulu\0";
pub const DMICROSEC: &[u8; 8] = b"usecond\0";
pub const DMILLISEC: &[u8; 8] = b"msecond\0";
pub const DSECOND: &[u8; 7] = b"second\0";
pub const DMINUTE: &[u8; 7] = b"minute\0";
pub const DHOUR: &[u8; 5] = b"hour\0";
pub const DDAY: &[u8; 4] = b"day\0";
pub const DWEEK: &[u8; 5] = b"week\0";
pub const DMONTH: &[u8; 6] = b"month\0";
pub const DQUARTER: &[u8; 8] = b"quarter\0";
pub const DYEAR: &[u8; 5] = b"year\0";
pub const DDECADE: &[u8; 7] = b"decade\0";
pub const DCENTURY: &[u8; 8] = b"century\0";
pub const DMILLENNIUM: &[u8; 11] = b"millennium\0";
pub const DA_D: &[u8; 3] = b"ad\0";
pub const DB_C: &[u8; 3] = b"bc\0";
pub const DTIMEZONE: &[u8; 9] = b"timezone\0";
pub const AM: u32 = 0;
pub const PM: u32 = 1;
pub const HR24: u32 = 2;
pub const AD: u32 = 0;
pub const BC: u32 = 1;
pub const RESERV: u32 = 0;
pub const MONTH: u32 = 1;
pub const YEAR: u32 = 2;
pub const DAY: u32 = 3;
pub const JULIAN: u32 = 4;
pub const TZ: u32 = 5;
pub const DTZ: u32 = 6;
pub const DYNTZ: u32 = 7;
pub const IGNORE_DTF: u32 = 8;
pub const AMPM: u32 = 9;
pub const HOUR: u32 = 10;
pub const MINUTE: u32 = 11;
pub const SECOND: u32 = 12;
pub const MILLISECOND: u32 = 13;
pub const MICROSECOND: u32 = 14;
pub const DOY: u32 = 15;
pub const DOW: u32 = 16;
pub const UNITS: u32 = 17;
pub const ADBC: u32 = 18;
pub const AGO: u32 = 19;
pub const ABS_BEFORE: u32 = 20;
pub const ABS_AFTER: u32 = 21;
pub const ISODATE: u32 = 22;
pub const ISOTIME: u32 = 23;
pub const WEEK: u32 = 24;
pub const DECADE: u32 = 25;
pub const CENTURY: u32 = 26;
pub const MILLENNIUM: u32 = 27;
pub const DTZMOD: u32 = 28;
pub const UNKNOWN_FIELD: u32 = 31;
pub const DTK_NUMBER: u32 = 0;
pub const DTK_STRING: u32 = 1;
pub const DTK_DATE: u32 = 2;
pub const DTK_TIME: u32 = 3;
pub const DTK_TZ: u32 = 4;
pub const DTK_AGO: u32 = 5;
pub const DTK_SPECIAL: u32 = 6;
pub const DTK_EARLY: u32 = 9;
pub const DTK_LATE: u32 = 10;
pub const DTK_EPOCH: u32 = 11;
pub const DTK_NOW: u32 = 12;
pub const DTK_YESTERDAY: u32 = 13;
pub const DTK_TODAY: u32 = 14;
pub const DTK_TOMORROW: u32 = 15;
pub const DTK_ZULU: u32 = 16;
pub const DTK_DELTA: u32 = 17;
pub const DTK_SECOND: u32 = 18;
pub const DTK_MINUTE: u32 = 19;
pub const DTK_HOUR: u32 = 20;
pub const DTK_DAY: u32 = 21;
pub const DTK_WEEK: u32 = 22;
pub const DTK_MONTH: u32 = 23;
pub const DTK_QUARTER: u32 = 24;
pub const DTK_YEAR: u32 = 25;
pub const DTK_DECADE: u32 = 26;
pub const DTK_CENTURY: u32 = 27;
pub const DTK_MILLENNIUM: u32 = 28;
pub const DTK_MILLISEC: u32 = 29;
pub const DTK_MICROSEC: u32 = 30;
pub const DTK_JULIAN: u32 = 31;
pub const DTK_DOW: u32 = 32;
pub const DTK_DOY: u32 = 33;
pub const DTK_TZ_HOUR: u32 = 34;
pub const DTK_TZ_MINUTE: u32 = 35;
pub const DTK_ISOYEAR: u32 = 36;
pub const DTK_ISODOW: u32 = 37;
pub const MAXDATELEN: u32 = 128;
pub const MAXDATEFIELDS: u32 = 25;
pub const TOKMAXLEN: u32 = 10;
pub const DTERR_BAD_FORMAT: i32 = -1;
pub const DTERR_FIELD_OVERFLOW: i32 = -2;
pub const DTERR_MD_FIELD_OVERFLOW: i32 = -3;
pub const DTERR_INTERVAL_OVERFLOW: i32 = -4;
pub const DTERR_TZDISP_OVERFLOW: i32 = -5;
pub const GIDSIZE: u32 = 200;
pub const XACT_READ_UNCOMMITTED: u32 = 0;
pub const XACT_READ_COMMITTED: u32 = 1;
pub const XACT_REPEATABLE_READ: u32 = 2;
pub const XACT_SERIALIZABLE: u32 = 3;
pub const XACT_FLAGS_ACCESSEDTEMPNAMESPACE: u32 = 1;
pub const XACT_FLAGS_ACQUIREDACCESSEXCLUSIVELOCK: u32 = 2;
pub const XACT_FLAGS_NEEDIMMEDIATECOMMIT: u32 = 4;
pub const XACT_FLAGS_PIPELINING: u32 = 8;
pub const XLOG_XACT_COMMIT: u32 = 0;
pub const XLOG_XACT_PREPARE: u32 = 16;
pub const XLOG_XACT_ABORT: u32 = 32;
pub const XLOG_XACT_COMMIT_PREPARED: u32 = 48;
pub const XLOG_XACT_ABORT_PREPARED: u32 = 64;
pub const XLOG_XACT_ASSIGNMENT: u32 = 80;
pub const XLOG_XACT_OPMASK: u32 = 112;
pub const XLOG_XACT_HAS_INFO: u32 = 128;
pub const XACT_XINFO_HAS_DBINFO: u32 = 1;
pub const XACT_XINFO_HAS_SUBXACTS: u32 = 2;
pub const XACT_XINFO_HAS_RELFILENODES: u32 = 4;
pub const XACT_XINFO_HAS_INVALS: u32 = 8;
pub const XACT_XINFO_HAS_TWOPHASE: u32 = 16;
pub const XACT_XINFO_HAS_ORIGIN: u32 = 32;
pub const XACT_XINFO_HAS_AE_LOCKS: u32 = 64;
pub const XACT_XINFO_HAS_GID: u32 = 128;
pub const XACT_COMPLETION_APPLY_FEEDBACK: u32 = 536870912;
pub const XACT_COMPLETION_UPDATE_RELCACHE_FILE: u32 = 1073741824;
pub const XACT_COMPLETION_FORCE_SYNC_COMMIT: u32 = 2147483648;
pub const PERFORM_DELETION_INTERNAL: u32 = 1;
pub const PERFORM_DELETION_CONCURRENTLY: u32 = 2;
pub const PERFORM_DELETION_QUIETLY: u32 = 4;
pub const PERFORM_DELETION_SKIP_ORIGINAL: u32 = 8;
pub const PERFORM_DELETION_SKIP_EXTENSIONS: u32 = 16;
pub const PERFORM_DELETION_CONCURRENT_LOCK: u32 = 32;
pub const DEFAULT_INDEX_TYPE: &[u8; 6] = b"btree\0";
pub const INDEX_CREATE_IS_PRIMARY: u32 = 1;
pub const INDEX_CREATE_ADD_CONSTRAINT: u32 = 2;
pub const INDEX_CREATE_SKIP_BUILD: u32 = 4;
pub const INDEX_CREATE_CONCURRENT: u32 = 8;
pub const INDEX_CREATE_IF_NOT_EXISTS: u32 = 16;
pub const INDEX_CREATE_PARTITIONED: u32 = 32;
pub const INDEX_CREATE_INVALID: u32 = 64;
pub const INDEX_CONSTR_CREATE_MARK_AS_PRIMARY: u32 = 1;
pub const INDEX_CONSTR_CREATE_DEFERRABLE: u32 = 2;
pub const INDEX_CONSTR_CREATE_INIT_DEFERRED: u32 = 4;
pub const INDEX_CONSTR_CREATE_UPDATE_INDEX: u32 = 8;
pub const INDEX_CONSTR_CREATE_REMOVE_OLD_DEPS: u32 = 16;
pub const REINDEX_REL_PROCESS_TOAST: u32 = 1;
pub const REINDEX_REL_SUPPRESS_INDEX_USE: u32 = 2;
pub const REINDEX_REL_CHECK_CONSTRAINTS: u32 = 4;
pub const REINDEX_REL_FORCE_INDEXES_UNLOGGED: u32 = 8;
pub const REINDEX_REL_FORCE_INDEXES_PERMANENT: u32 = 16;
pub const AggregateFnoidIndexId: u32 = 2650;
pub const AmNameIndexId: u32 = 2651;
pub const AmOidIndexId: u32 = 2652;
pub const AccessMethodStrategyIndexId: u32 = 2653;
pub const AccessMethodOperatorIndexId: u32 = 2654;
pub const AccessMethodOperatorOidIndexId: u32 = 2756;
pub const AccessMethodProcedureIndexId: u32 = 2655;
pub const AccessMethodProcedureOidIndexId: u32 = 2757;
pub const AttrDefaultIndexId: u32 = 2656;
pub const AttrDefaultOidIndexId: u32 = 2657;
pub const AttributeRelidNameIndexId: u32 = 2658;
pub const AttributeRelidNumIndexId: u32 = 2659;
pub const AuthIdRolnameIndexId: u32 = 2676;
pub const AuthIdOidIndexId: u32 = 2677;
pub const AuthMemRoleMemIndexId: u32 = 2694;
pub const AuthMemMemRoleIndexId: u32 = 2695;
pub const CastOidIndexId: u32 = 2660;
pub const CastSourceTargetIndexId: u32 = 2661;
pub const ClassOidIndexId: u32 = 2662;
pub const ClassNameNspIndexId: u32 = 2663;
pub const ClassTblspcRelfilenodeIndexId: u32 = 3455;
pub const CollationNameEncNspIndexId: u32 = 3164;
pub const CollationOidIndexId: u32 = 3085;
pub const ConstraintNameNspIndexId: u32 = 2664;
pub const ConstraintRelidTypidNameIndexId: u32 = 2665;
pub const ConstraintTypidIndexId: u32 = 2666;
pub const ConstraintOidIndexId: u32 = 2667;
pub const ConstraintParentIndexId: u32 = 2579;
pub const ConversionDefaultIndexId: u32 = 2668;
pub const ConversionNameNspIndexId: u32 = 2669;
pub const ConversionOidIndexId: u32 = 2670;
pub const DatabaseNameIndexId: u32 = 2671;
pub const DatabaseOidIndexId: u32 = 2672;
pub const DependDependerIndexId: u32 = 2673;
pub const DependReferenceIndexId: u32 = 2674;
pub const DescriptionObjIndexId: u32 = 2675;
pub const SharedDescriptionObjIndexId: u32 = 2397;
pub const EnumOidIndexId: u32 = 3502;
pub const EnumTypIdLabelIndexId: u32 = 3503;
pub const EnumTypIdSortOrderIndexId: u32 = 3534;
pub const IndexIndrelidIndexId: u32 = 2678;
pub const IndexRelidIndexId: u32 = 2679;
pub const InheritsRelidSeqnoIndexId: u32 = 2680;
pub const InheritsParentIndexId: u32 = 2187;
pub const InitPrivsObjIndexId: u32 = 3395;
pub const LanguageNameIndexId: u32 = 2681;
pub const LanguageOidIndexId: u32 = 2682;
pub const LargeObjectLOidPNIndexId: u32 = 2683;
pub const LargeObjectMetadataOidIndexId: u32 = 2996;
pub const NamespaceNameIndexId: u32 = 2684;
pub const NamespaceOidIndexId: u32 = 2685;
pub const OpclassAmNameNspIndexId: u32 = 2686;
pub const OpclassOidIndexId: u32 = 2687;
pub const OperatorOidIndexId: u32 = 2688;
pub const OperatorNameNspIndexId: u32 = 2689;
pub const OpfamilyAmNameNspIndexId: u32 = 2754;
pub const OpfamilyOidIndexId: u32 = 2755;
pub const ProcedureOidIndexId: u32 = 2690;
pub const ProcedureNameArgsNspIndexId: u32 = 2691;
pub const RewriteOidIndexId: u32 = 2692;
pub const RewriteRelRulenameIndexId: u32 = 2693;
pub const SequenceRelidIndexId: u32 = 5002;
pub const SharedDependDependerIndexId: u32 = 1232;
pub const SharedDependReferenceIndexId: u32 = 1233;
pub const StatisticRelidAttnumInhIndexId: u32 = 2696;
pub const StatisticExtOidIndexId: u32 = 3380;
pub const StatisticExtNameIndexId: u32 = 3997;
pub const StatisticExtRelidIndexId: u32 = 3379;
pub const StatisticExtDataStxoidIndexId: u32 = 3433;
pub const TablespaceOidIndexId: u32 = 2697;
pub const TablespaceNameIndexId: u32 = 2698;
pub const TransformOidIndexId: u32 = 3574;
pub const TransformTypeLangIndexId: u32 = 3575;
pub const TriggerConstraintIndexId: u32 = 2699;
pub const TriggerRelidNameIndexId: u32 = 2701;
pub const TriggerOidIndexId: u32 = 2702;
pub const EventTriggerNameIndexId: u32 = 3467;
pub const EventTriggerOidIndexId: u32 = 3468;
pub const TSConfigNameNspIndexId: u32 = 3608;
pub const TSConfigOidIndexId: u32 = 3712;
pub const TSConfigMapIndexId: u32 = 3609;
pub const TSDictionaryNameNspIndexId: u32 = 3604;
pub const TSDictionaryOidIndexId: u32 = 3605;
pub const TSParserNameNspIndexId: u32 = 3606;
pub const TSParserOidIndexId: u32 = 3607;
pub const TSTemplateNameNspIndexId: u32 = 3766;
pub const TSTemplateOidIndexId: u32 = 3767;
pub const TypeOidIndexId: u32 = 2703;
pub const TypeNameNspIndexId: u32 = 2704;
pub const ForeignDataWrapperOidIndexId: u32 = 112;
pub const ForeignDataWrapperNameIndexId: u32 = 548;
pub const ForeignServerOidIndexId: u32 = 113;
pub const ForeignServerNameIndexId: u32 = 549;
pub const UserMappingOidIndexId: u32 = 174;
pub const UserMappingUserServerIndexId: u32 = 175;
pub const ForeignTableRelidIndexId: u32 = 3119;
pub const DefaultAclRoleNspObjIndexId: u32 = 827;
pub const DefaultAclOidIndexId: u32 = 828;
pub const DbRoleSettingDatidRolidIndexId: u32 = 2965;
pub const SecLabelObjectIndexId: u32 = 3597;
pub const SharedSecLabelObjectIndexId: u32 = 3593;
pub const ExtensionOidIndexId: u32 = 3080;
pub const ExtensionNameIndexId: u32 = 3081;
pub const RangeTypidIndexId: u32 = 3542;
pub const PolicyOidIndexId: u32 = 3257;
pub const PolicyPolrelidPolnameIndexId: u32 = 3258;
pub const ReplicationOriginIdentIndex: u32 = 6001;
pub const ReplicationOriginNameIndex: u32 = 6002;
pub const PartitionedRelidIndexId: u32 = 3351;
pub const PublicationObjectIndexId: u32 = 6110;
pub const PublicationNameIndexId: u32 = 6111;
pub const PublicationRelObjectIndexId: u32 = 6112;
pub const PublicationRelPrrelidPrpubidIndexId: u32 = 6113;
pub const SubscriptionObjectIndexId: u32 = 6114;
pub const SubscriptionNameIndexId: u32 = 6115;
pub const SubscriptionRelSrrelidSrsubidIndexId: u32 = 6117;
pub const AccessMethodOperatorRelationId: Oid = Oid(2602);
pub const Anum_pg_amop_oid: u32 = 1;
pub const Anum_pg_amop_amopfamily: u32 = 2;
pub const Anum_pg_amop_amoplefttype: u32 = 3;
pub const Anum_pg_amop_amoprighttype: u32 = 4;
pub const Anum_pg_amop_amopstrategy: u32 = 5;
pub const Anum_pg_amop_amoppurpose: u32 = 6;
pub const Anum_pg_amop_amopopr: u32 = 7;
pub const Anum_pg_amop_amopmethod: u32 = 8;
pub const Anum_pg_amop_amopsortfamily: u32 = 9;
pub const Natts_pg_amop: u32 = 9;
pub const AMOP_SEARCH: u8 = 115u8;
pub const AMOP_ORDER: u8 = 111u8;
pub const AuthIdRelationId: Oid = Oid(1260);
pub const AuthIdRelation_Rowtype_Id: u32 = 2842;
pub const Anum_pg_authid_oid: u32 = 1;
pub const Anum_pg_authid_rolname: u32 = 2;
pub const Anum_pg_authid_rolsuper: u32 = 3;
pub const Anum_pg_authid_rolinherit: u32 = 4;
pub const Anum_pg_authid_rolcreaterole: u32 = 5;
pub const Anum_pg_authid_rolcreatedb: u32 = 6;
pub const Anum_pg_authid_rolcanlogin: u32 = 7;
pub const Anum_pg_authid_rolreplication: u32 = 8;
pub const Anum_pg_authid_rolbypassrls: u32 = 9;
pub const Anum_pg_authid_rolconnlimit: u32 = 10;
pub const Anum_pg_authid_rolpassword: u32 = 11;
pub const Anum_pg_authid_rolvaliduntil: u32 = 12;
pub const Natts_pg_authid: u32 = 12;
pub const BOOTSTRAP_SUPERUSERID: u32 = 10;
pub const DEFAULT_ROLE_MONITOR: u32 = 3373;
pub const DEFAULT_ROLE_READ_ALL_SETTINGS: u32 = 3374;
pub const DEFAULT_ROLE_READ_ALL_STATS: u32 = 3375;
pub const DEFAULT_ROLE_STAT_SCAN_TABLES: u32 = 3377;
pub const DEFAULT_ROLE_READ_SERVER_FILES: u32 = 4569;
pub const DEFAULT_ROLE_WRITE_SERVER_FILES: u32 = 4570;
pub const DEFAULT_ROLE_EXECUTE_SERVER_PROGRAM: u32 = 4571;
pub const DEFAULT_ROLE_SIGNAL_BACKENDID: u32 = 4200;
pub const DatabaseRelationId: Oid = Oid(1262);
pub const DatabaseRelation_Rowtype_Id: u32 = 1248;
pub const Anum_pg_database_oid: u32 = 1;
pub const Anum_pg_database_datname: u32 = 2;
pub const Anum_pg_database_datdba: u32 = 3;
pub const Anum_pg_database_encoding: u32 = 4;
pub const Anum_pg_database_datcollate: u32 = 5;
pub const Anum_pg_database_datctype: u32 = 6;
pub const Anum_pg_database_datistemplate: u32 = 7;
pub const Anum_pg_database_datallowconn: u32 = 8;
pub const Anum_pg_database_datconnlimit: u32 = 9;
pub const Anum_pg_database_datlastsysoid: u32 = 10;
pub const Anum_pg_database_datfrozenxid: u32 = 11;
pub const Anum_pg_database_datminmxid: u32 = 12;
pub const Anum_pg_database_dattablespace: u32 = 13;
pub const Anum_pg_database_datacl: u32 = 14;
pub const Natts_pg_database: u32 = 14;
pub const TemplateDbOid: Oid = Oid(1);
pub const EnumRelationId: Oid = Oid(3501);
pub const Anum_pg_enum_oid: u32 = 1;
pub const Anum_pg_enum_enumtypid: u32 = 2;
pub const Anum_pg_enum_enumsortorder: u32 = 3;
pub const Anum_pg_enum_enumlabel: u32 = 4;
pub const Natts_pg_enum: u32 = 4;
pub const ExtensionRelationId: Oid = Oid(3079);
pub const Anum_pg_extension_oid: u32 = 1;
pub const Anum_pg_extension_extname: u32 = 2;
pub const Anum_pg_extension_extowner: u32 = 3;
pub const Anum_pg_extension_extnamespace: u32 = 4;
pub const Anum_pg_extension_extrelocatable: u32 = 5;
pub const Anum_pg_extension_extversion: u32 = 6;
pub const Anum_pg_extension_extconfig: u32 = 7;
pub const Anum_pg_extension_extcondition: u32 = 8;
pub const Natts_pg_extension: u32 = 8;
pub const ForeignServerRelationId: Oid = Oid(1417);
pub const Anum_pg_foreign_server_oid: u32 = 1;
pub const Anum_pg_foreign_server_srvname: u32 = 2;
pub const Anum_pg_foreign_server_srvowner: u32 = 3;
pub const Anum_pg_foreign_server_srvfdw: u32 = 4;
pub const Anum_pg_foreign_server_srvtype: u32 = 5;
pub const Anum_pg_foreign_server_srvversion: u32 = 6;
pub const Anum_pg_foreign_server_srvacl: u32 = 7;
pub const Anum_pg_foreign_server_srvoptions: u32 = 8;
pub const Natts_pg_foreign_server: u32 = 8;
pub const ForeignTableRelationId: Oid = Oid(3118);
pub const Anum_pg_foreign_table_ftrelid: u32 = 1;
pub const Anum_pg_foreign_table_ftserver: u32 = 2;
pub const Anum_pg_foreign_table_ftoptions: u32 = 3;
pub const Natts_pg_foreign_table: u32 = 3;
pub const OperatorRelationId: Oid = Oid(2617);
pub const Anum_pg_operator_oid: u32 = 1;
pub const Anum_pg_operator_oprname: u32 = 2;
pub const Anum_pg_operator_oprnamespace: u32 = 3;
pub const Anum_pg_operator_oprowner: u32 = 4;
pub const Anum_pg_operator_oprkind: u32 = 5;
pub const Anum_pg_operator_oprcanmerge: u32 = 6;
pub const Anum_pg_operator_oprcanhash: u32 = 7;
pub const Anum_pg_operator_oprleft: u32 = 8;
pub const Anum_pg_operator_oprright: u32 = 9;
pub const Anum_pg_operator_oprresult: u32 = 10;
pub const Anum_pg_operator_oprcom: u32 = 11;
pub const Anum_pg_operator_oprnegate: u32 = 12;
pub const Anum_pg_operator_oprcode: u32 = 13;
pub const Anum_pg_operator_oprrest: u32 = 14;
pub const Anum_pg_operator_oprjoin: u32 = 15;
pub const Natts_pg_operator: u32 = 15;
pub const BooleanNotEqualOperator: u32 = 85;
pub const BooleanEqualOperator: u32 = 91;
pub const Int4EqualOperator: u32 = 96;
pub const Int4LessOperator: u32 = 97;
pub const TextEqualOperator: u32 = 98;
pub const NameEqualTextOperator: u32 = 254;
pub const NameLessTextOperator: u32 = 255;
pub const NameGreaterEqualTextOperator: u32 = 257;
pub const TIDEqualOperator: u32 = 387;
pub const TIDLessOperator: u32 = 2799;
pub const Int8LessOperator: u32 = 412;
pub const OID_NAME_REGEXEQ_OP: u32 = 639;
pub const OID_TEXT_REGEXEQ_OP: u32 = 641;
pub const TextLessOperator: u32 = 664;
pub const TextGreaterEqualOperator: u32 = 667;
pub const Float8LessOperator: u32 = 672;
pub const BpcharEqualOperator: u32 = 1054;
pub const OID_BPCHAR_REGEXEQ_OP: u32 = 1055;
pub const BpcharLessOperator: u32 = 1058;
pub const BpcharGreaterEqualOperator: u32 = 1061;
pub const ARRAY_EQ_OP: u32 = 1070;
pub const ARRAY_LT_OP: u32 = 1072;
pub const ARRAY_GT_OP: u32 = 1073;
pub const OID_NAME_LIKE_OP: u32 = 1207;
pub const OID_TEXT_LIKE_OP: u32 = 1209;
pub const OID_BPCHAR_LIKE_OP: u32 = 1211;
pub const OID_NAME_ICREGEXEQ_OP: u32 = 1226;
pub const OID_TEXT_ICREGEXEQ_OP: u32 = 1228;
pub const OID_BPCHAR_ICREGEXEQ_OP: u32 = 1234;
pub const OID_INET_SUB_OP: u32 = 931;
pub const OID_INET_SUBEQ_OP: u32 = 932;
pub const OID_INET_SUP_OP: u32 = 933;
pub const OID_INET_SUPEQ_OP: u32 = 934;
pub const OID_INET_OVERLAP_OP: u32 = 3552;
pub const OID_NAME_ICLIKE_OP: u32 = 1625;
pub const OID_TEXT_ICLIKE_OP: u32 = 1627;
pub const OID_BPCHAR_ICLIKE_OP: u32 = 1629;
pub const ByteaEqualOperator: u32 = 1955;
pub const ByteaLessOperator: u32 = 1957;
pub const ByteaGreaterEqualOperator: u32 = 1960;
pub const OID_BYTEA_LIKE_OP: u32 = 2016;
pub const TextPatternLessOperator: u32 = 2314;
pub const TextPatternGreaterEqualOperator: u32 = 2317;
pub const BpcharPatternLessOperator: u32 = 2326;
pub const BpcharPatternGreaterEqualOperator: u32 = 2329;
pub const OID_ARRAY_OVERLAP_OP: u32 = 2750;
pub const OID_ARRAY_CONTAINS_OP: u32 = 2751;
pub const OID_ARRAY_CONTAINED_OP: u32 = 2752;
pub const RECORD_EQ_OP: u32 = 2988;
pub const RECORD_LT_OP: u32 = 2990;
pub const RECORD_GT_OP: u32 = 2991;
pub const OID_RANGE_LESS_OP: u32 = 3884;
pub const OID_RANGE_LESS_EQUAL_OP: u32 = 3885;
pub const OID_RANGE_GREATER_EQUAL_OP: u32 = 3886;
pub const OID_RANGE_GREATER_OP: u32 = 3887;
pub const OID_RANGE_OVERLAP_OP: u32 = 3888;
pub const OID_RANGE_CONTAINS_ELEM_OP: u32 = 3889;
pub const OID_RANGE_CONTAINS_OP: u32 = 3890;
pub const OID_RANGE_ELEM_CONTAINED_OP: u32 = 3891;
pub const OID_RANGE_CONTAINED_OP: u32 = 3892;
pub const OID_RANGE_LEFT_OP: u32 = 3893;
pub const OID_RANGE_RIGHT_OP: u32 = 3894;
pub const OID_RANGE_OVERLAPS_LEFT_OP: u32 = 3895;
pub const OID_RANGE_OVERLAPS_RIGHT_OP: u32 = 3896;
pub const OperatorClassRelationId: Oid = Oid(2616);
pub const Anum_pg_opclass_oid: u32 = 1;
pub const Anum_pg_opclass_opcmethod: u32 = 2;
pub const Anum_pg_opclass_opcname: u32 = 3;
pub const Anum_pg_opclass_opcnamespace: u32 = 4;
pub const Anum_pg_opclass_opcowner: u32 = 5;
pub const Anum_pg_opclass_opcfamily: u32 = 6;
pub const Anum_pg_opclass_opcintype: u32 = 7;
pub const Anum_pg_opclass_opcdefault: u32 = 8;
pub const Anum_pg_opclass_opckeytype: u32 = 9;
pub const Natts_pg_opclass: u32 = 9;
pub const DATE_BTREE_OPS_OID: Oid = Oid(3122);
pub const FLOAT8_BTREE_OPS_OID: Oid = Oid(3123);
pub const INT2_BTREE_OPS_OID: Oid = Oid(1979);
pub const INT4_BTREE_OPS_OID: Oid = Oid(1978);
pub const INT8_BTREE_OPS_OID: Oid = Oid(3124);
pub const NUMERIC_BTREE_OPS_OID: Oid = Oid(3125);
pub const OID_BTREE_OPS_OID: Oid = Oid(1981);
pub const TEXT_BTREE_OPS_OID: Oid = Oid(3126);
pub const TIMESTAMPTZ_BTREE_OPS_OID: Oid = Oid(3127);
pub const TIMESTAMP_BTREE_OPS_OID: Oid = Oid(3128);
pub const TEXT_BTREE_PATTERN_OPS_OID: Oid = Oid(4217);
pub const VARCHAR_BTREE_PATTERN_OPS_OID: Oid = Oid(4218);
pub const BPCHAR_BTREE_PATTERN_OPS_OID: Oid = Oid(4219);
pub const OperatorFamilyRelationId: Oid = Oid(2753);
pub const Anum_pg_opfamily_oid: u32 = 1;
pub const Anum_pg_opfamily_opfmethod: u32 = 2;
pub const Anum_pg_opfamily_opfname: u32 = 3;
pub const Anum_pg_opfamily_opfnamespace: u32 = 4;
pub const Anum_pg_opfamily_opfowner: u32 = 5;
pub const Natts_pg_opfamily: u32 = 5;
pub const BOOL_BTREE_FAM_OID: Oid = Oid(424);
pub const BPCHAR_BTREE_FAM_OID: Oid = Oid(426);
pub const BYTEA_BTREE_FAM_OID: Oid = Oid(428);
pub const NETWORK_BTREE_FAM_OID: Oid = Oid(1974);
pub const INTEGER_BTREE_FAM_OID: Oid = Oid(1976);
pub const OID_BTREE_FAM_OID: Oid = Oid(1989);
pub const TEXT_BTREE_FAM_OID: Oid = Oid(1994);
pub const TEXT_PATTERN_BTREE_FAM_OID: Oid = Oid(2095);
pub const BPCHAR_PATTERN_BTREE_FAM_OID: Oid = Oid(2097);
pub const BOOL_HASH_FAM_OID: Oid = Oid(2222);
pub const TEXT_SPGIST_FAM_OID: Oid = Oid(4017);
pub const ProcedureRelationId: Oid = Oid(1255);
pub const ProcedureRelation_Rowtype_Id: u32 = 81;
pub const Anum_pg_proc_oid: u32 = 1;
pub const Anum_pg_proc_proname: u32 = 2;
pub const Anum_pg_proc_pronamespace: u32 = 3;
pub const Anum_pg_proc_proowner: u32 = 4;
pub const Anum_pg_proc_prolang: u32 = 5;
pub const Anum_pg_proc_procost: u32 = 6;
pub const Anum_pg_proc_prorows: u32 = 7;
pub const Anum_pg_proc_provariadic: u32 = 8;
pub const Anum_pg_proc_prosupport: u32 = 9;
pub const Anum_pg_proc_prokind: u32 = 10;
pub const Anum_pg_proc_prosecdef: u32 = 11;
pub const Anum_pg_proc_proleakproof: u32 = 12;
pub const Anum_pg_proc_proisstrict: u32 = 13;
pub const Anum_pg_proc_proretset: u32 = 14;
pub const Anum_pg_proc_provolatile: u32 = 15;
pub const Anum_pg_proc_proparallel: u32 = 16;
pub const Anum_pg_proc_pronargs: u32 = 17;
pub const Anum_pg_proc_pronargdefaults: u32 = 18;
pub const Anum_pg_proc_prorettype: u32 = 19;
pub const Anum_pg_proc_proargtypes: u32 = 20;
pub const Anum_pg_proc_proallargtypes: u32 = 21;
pub const Anum_pg_proc_proargmodes: u32 = 22;
pub const Anum_pg_proc_proargnames: u32 = 23;
pub const Anum_pg_proc_proargdefaults: u32 = 24;
pub const Anum_pg_proc_protrftypes: u32 = 25;
pub const Anum_pg_proc_prosrc: u32 = 26;
pub const Anum_pg_proc_probin: u32 = 27;
pub const Anum_pg_proc_proconfig: u32 = 28;
pub const Anum_pg_proc_proacl: u32 = 29;
pub const Natts_pg_proc: u32 = 29;
pub const PROKIND_FUNCTION: u8 = 102u8;
pub const PROKIND_AGGREGATE: u8 = 97u8;
pub const PROKIND_WINDOW: u8 = 119u8;
pub const PROKIND_PROCEDURE: u8 = 112u8;
pub const PROVOLATILE_IMMUTABLE: u8 = 105u8;
pub const PROVOLATILE_STABLE: u8 = 115u8;
pub const PROVOLATILE_VOLATILE: u8 = 118u8;
pub const PROPARALLEL_SAFE: u8 = 115u8;
pub const PROPARALLEL_RESTRICTED: u8 = 114u8;
pub const PROPARALLEL_UNSAFE: u8 = 117u8;
pub const PROARGMODE_IN: u8 = 105u8;
pub const PROARGMODE_OUT: u8 = 111u8;
pub const PROARGMODE_INOUT: u8 = 98u8;
pub const PROARGMODE_VARIADIC: u8 = 118u8;
pub const PROARGMODE_TABLE: u8 = 116u8;
pub const HEAP_TABLE_AM_HANDLER_OID: Oid = Oid(3);
pub const NamespaceRelationId: Oid = Oid(2615);
pub const Anum_pg_namespace_oid: u32 = 1;
pub const Anum_pg_namespace_nspname: u32 = 2;
pub const Anum_pg_namespace_nspowner: u32 = 3;
pub const Anum_pg_namespace_nspacl: u32 = 4;
pub const Natts_pg_namespace: u32 = 4;
pub const PG_CATALOG_NAMESPACE: u32 = 11;
pub const PG_TOAST_NAMESPACE: u32 = 99;
pub const PG_PUBLIC_NAMESPACE: u32 = 2200;
pub const ACL_ID_PUBLIC: u32 = 0;
pub const ACL_MODECHG_ADD: u32 = 1;
pub const ACL_MODECHG_DEL: u32 = 2;
pub const ACL_MODECHG_EQL: u32 = 3;
pub const ACL_INSERT_CHR: u8 = 97u8;
pub const ACL_SELECT_CHR: u8 = 114u8;
pub const ACL_UPDATE_CHR: u8 = 119u8;
pub const ACL_DELETE_CHR: u8 = 100u8;
pub const ACL_TRUNCATE_CHR: u8 = 68u8;
pub const ACL_REFERENCES_CHR: u8 = 120u8;
pub const ACL_TRIGGER_CHR: u8 = 116u8;
pub const ACL_EXECUTE_CHR: u8 = 88u8;
pub const ACL_USAGE_CHR: u8 = 85u8;
pub const ACL_CREATE_CHR: u8 = 67u8;
pub const ACL_CREATE_TEMP_CHR: u8 = 84u8;
pub const ACL_CONNECT_CHR: u8 = 99u8;
pub const ACL_ALL_RIGHTS_STR: &[u8; 13] = b"arwdDxtXUCTc\0";
pub const ACL_ALL_RIGHTS_COLUMN: u32 = 39;
pub const ACL_ALL_RIGHTS_RELATION: u32 = 127;
pub const ACL_ALL_RIGHTS_SEQUENCE: u32 = 262;
pub const ACL_ALL_RIGHTS_DATABASE: u32 = 3584;
pub const ACL_ALL_RIGHTS_FDW: u32 = 256;
pub const ACL_ALL_RIGHTS_FOREIGN_SERVER: u32 = 256;
pub const ACL_ALL_RIGHTS_FUNCTION: u32 = 128;
pub const ACL_ALL_RIGHTS_LANGUAGE: u32 = 256;
pub const ACL_ALL_RIGHTS_LARGEOBJECT: u32 = 6;
pub const ACL_ALL_RIGHTS_SCHEMA: u32 = 768;
pub const ACL_ALL_RIGHTS_TABLESPACE: u32 = 512;
pub const ACL_ALL_RIGHTS_TYPE: u32 = 256;
pub const TableSpaceRelationId: Oid = Oid(1213);
pub const Anum_pg_tablespace_oid: u32 = 1;
pub const Anum_pg_tablespace_spcname: u32 = 2;
pub const Anum_pg_tablespace_spcowner: u32 = 3;
pub const Anum_pg_tablespace_spcacl: u32 = 4;
pub const Anum_pg_tablespace_spcoptions: u32 = 5;
pub const Natts_pg_tablespace: u32 = 5;
pub const DEFAULTTABLESPACE_OID: Oid = Oid(1663);
pub const GLOBALTABLESPACE_OID: Oid = Oid(1664);
pub const TriggerRelationId: Oid = Oid(2620);
pub const Anum_pg_trigger_oid: u32 = 1;
pub const Anum_pg_trigger_tgrelid: u32 = 2;
pub const Anum_pg_trigger_tgparentid: u32 = 3;
pub const Anum_pg_trigger_tgname: u32 = 4;
pub const Anum_pg_trigger_tgfoid: u32 = 5;
pub const Anum_pg_trigger_tgtype: u32 = 6;
pub const Anum_pg_trigger_tgenabled: u32 = 7;
pub const Anum_pg_trigger_tgisinternal: u32 = 8;
pub const Anum_pg_trigger_tgconstrrelid: u32 = 9;
pub const Anum_pg_trigger_tgconstrindid: u32 = 10;
pub const Anum_pg_trigger_tgconstraint: u32 = 11;
pub const Anum_pg_trigger_tgdeferrable: u32 = 12;
pub const Anum_pg_trigger_tginitdeferred: u32 = 13;
pub const Anum_pg_trigger_tgnargs: u32 = 14;
pub const Anum_pg_trigger_tgattr: u32 = 15;
pub const Anum_pg_trigger_tgargs: u32 = 16;
pub const Anum_pg_trigger_tgqual: u32 = 17;
pub const Anum_pg_trigger_tgoldtable: u32 = 18;
pub const Anum_pg_trigger_tgnewtable: u32 = 19;
pub const Natts_pg_trigger: u32 = 19;
pub const TRIGGER_TYPE_ROW: u32 = 1;
pub const TRIGGER_TYPE_BEFORE: u32 = 2;
pub const TRIGGER_TYPE_INSERT: u32 = 4;
pub const TRIGGER_TYPE_DELETE: u32 = 8;
pub const TRIGGER_TYPE_UPDATE: u32 = 16;
pub const TRIGGER_TYPE_TRUNCATE: u32 = 32;
pub const TRIGGER_TYPE_INSTEAD: u32 = 64;
pub const TRIGGER_TYPE_LEVEL_MASK: u32 = 1;
pub const TRIGGER_TYPE_STATEMENT: u32 = 0;
pub const TRIGGER_TYPE_TIMING_MASK: u32 = 66;
pub const TRIGGER_TYPE_AFTER: u32 = 0;
pub const TRIGGER_TYPE_EVENT_MASK: u32 = 60;
pub const EventTriggerRelationId: Oid = Oid(3466);
pub const Anum_pg_event_trigger_oid: u32 = 1;
pub const Anum_pg_event_trigger_evtname: u32 = 2;
pub const Anum_pg_event_trigger_evtevent: u32 = 3;
pub const Anum_pg_event_trigger_evtowner: u32 = 4;
pub const Anum_pg_event_trigger_evtfoid: u32 = 5;
pub const Anum_pg_event_trigger_evtenabled: u32 = 6;
pub const Anum_pg_event_trigger_evttags: u32 = 7;
pub const Natts_pg_event_trigger: u32 = 7;
pub const AT_REWRITE_ALTER_PERSISTENCE: u32 = 1;
pub const AT_REWRITE_DEFAULT_VAL: u32 = 2;
pub const AT_REWRITE_COLUMN_REWRITE: u32 = 4;
pub const XLOG_TBLSPC_CREATE: u32 = 0;
pub const XLOG_TBLSPC_DROP: u32 = 16;
pub const TRIGGER_EVENT_INSERT: u32 = 0;
pub const TRIGGER_EVENT_DELETE: u32 = 1;
pub const TRIGGER_EVENT_UPDATE: u32 = 2;
pub const TRIGGER_EVENT_TRUNCATE: u32 = 3;
pub const TRIGGER_EVENT_OPMASK: u32 = 3;
pub const TRIGGER_EVENT_ROW: u32 = 4;
pub const TRIGGER_EVENT_BEFORE: u32 = 8;
pub const TRIGGER_EVENT_AFTER: u32 = 0;
pub const TRIGGER_EVENT_INSTEAD: u32 = 16;
pub const TRIGGER_EVENT_TIMINGMASK: u32 = 24;
pub const AFTER_TRIGGER_DEFERRABLE: u32 = 32;
pub const AFTER_TRIGGER_INITDEFERRED: u32 = 64;
pub const SESSION_REPLICATION_ROLE_ORIGIN: u32 = 0;
pub const SESSION_REPLICATION_ROLE_REPLICA: u32 = 1;
pub const SESSION_REPLICATION_ROLE_LOCAL: u32 = 2;
pub const TRIGGER_FIRES_ON_ORIGIN: u8 = 79u8;
pub const TRIGGER_FIRES_ALWAYS: u8 = 65u8;
pub const TRIGGER_FIRES_ON_REPLICA: u8 = 82u8;
pub const TRIGGER_DISABLED: u8 = 68u8;
pub const RI_TRIGGER_PK: u32 = 1;
pub const RI_TRIGGER_FK: u32 = 2;
pub const RI_TRIGGER_NONE: u32 = 0;
pub const StatisticRelationId: Oid = Oid(2619);
pub const Anum_pg_statistic_starelid: u32 = 1;
pub const Anum_pg_statistic_staattnum: u32 = 2;
pub const Anum_pg_statistic_stainherit: u32 = 3;
pub const Anum_pg_statistic_stanullfrac: u32 = 4;
pub const Anum_pg_statistic_stawidth: u32 = 5;
pub const Anum_pg_statistic_stadistinct: u32 = 6;
pub const Anum_pg_statistic_stakind1: u32 = 7;
pub const Anum_pg_statistic_stakind2: u32 = 8;
pub const Anum_pg_statistic_stakind3: u32 = 9;
pub const Anum_pg_statistic_stakind4: u32 = 10;
pub const Anum_pg_statistic_stakind5: u32 = 11;
pub const Anum_pg_statistic_staop1: u32 = 12;
pub const Anum_pg_statistic_staop2: u32 = 13;
pub const Anum_pg_statistic_staop3: u32 = 14;
pub const Anum_pg_statistic_staop4: u32 = 15;
pub const Anum_pg_statistic_staop5: u32 = 16;
pub const Anum_pg_statistic_stacoll1: u32 = 17;
pub const Anum_pg_statistic_stacoll2: u32 = 18;
pub const Anum_pg_statistic_stacoll3: u32 = 19;
pub const Anum_pg_statistic_stacoll4: u32 = 20;
pub const Anum_pg_statistic_stacoll5: u32 = 21;
pub const Anum_pg_statistic_stanumbers1: u32 = 22;
pub const Anum_pg_statistic_stanumbers2: u32 = 23;
pub const Anum_pg_statistic_stanumbers3: u32 = 24;
pub const Anum_pg_statistic_stanumbers4: u32 = 25;
pub const Anum_pg_statistic_stanumbers5: u32 = 26;
pub const Anum_pg_statistic_stavalues1: u32 = 27;
pub const Anum_pg_statistic_stavalues2: u32 = 28;
pub const Anum_pg_statistic_stavalues3: u32 = 29;
pub const Anum_pg_statistic_stavalues4: u32 = 30;
pub const Anum_pg_statistic_stavalues5: u32 = 31;
pub const Natts_pg_statistic: u32 = 31;
pub const STATISTIC_KIND_MCV: u32 = 1;
pub const STATISTIC_KIND_HISTOGRAM: u32 = 2;
pub const STATISTIC_KIND_CORRELATION: u32 = 3;
pub const STATISTIC_KIND_MCELEM: u32 = 4;
pub const STATISTIC_KIND_DECHIST: u32 = 5;
pub const STATISTIC_KIND_RANGE_LENGTH_HISTOGRAM: u32 = 6;
pub const STATISTIC_KIND_BOUNDS_HISTOGRAM: u32 = 7;
pub const STATISTIC_NUM_SLOTS: u32 = 5;
pub const VACUUM_OPTION_NO_PARALLEL: u32 = 0;
pub const VACUUM_OPTION_PARALLEL_BULKDEL: u32 = 1;
pub const VACUUM_OPTION_PARALLEL_COND_CLEANUP: u32 = 2;
pub const VACUUM_OPTION_PARALLEL_CLEANUP: u32 = 4;
pub const VACUUM_OPTION_MAX_VALID_VALUE: u32 = 7;
pub const CACHEDPLANSOURCE_MAGIC: u32 = 195726186;
pub const CACHEDPLAN_MAGIC: u32 = 953717834;
pub const CACHEDEXPR_MAGIC: u32 = 838275847;
pub const SPI_ERROR_CONNECT: i32 = -1;
pub const SPI_ERROR_COPY: i32 = -2;
pub const SPI_ERROR_OPUNKNOWN: i32 = -3;
pub const SPI_ERROR_UNCONNECTED: i32 = -4;
pub const SPI_ERROR_CURSOR: i32 = -5;
pub const SPI_ERROR_ARGUMENT: i32 = -6;
pub const SPI_ERROR_PARAM: i32 = -7;
pub const SPI_ERROR_TRANSACTION: i32 = -8;
pub const SPI_ERROR_NOATTRIBUTE: i32 = -9;
pub const SPI_ERROR_NOOUTFUNC: i32 = -10;
pub const SPI_ERROR_TYPUNKNOWN: i32 = -11;
pub const SPI_ERROR_REL_DUPLICATE: i32 = -12;
pub const SPI_ERROR_REL_NOT_FOUND: i32 = -13;
pub const SPI_OK_CONNECT: u32 = 1;
pub const SPI_OK_FINISH: u32 = 2;
pub const SPI_OK_FETCH: u32 = 3;
pub const SPI_OK_UTILITY: u32 = 4;
pub const SPI_OK_SELECT: u32 = 5;
pub const SPI_OK_SELINTO: u32 = 6;
pub const SPI_OK_INSERT: u32 = 7;
pub const SPI_OK_DELETE: u32 = 8;
pub const SPI_OK_UPDATE: u32 = 9;
pub const SPI_OK_CURSOR: u32 = 10;
pub const SPI_OK_INSERT_RETURNING: u32 = 11;
pub const SPI_OK_DELETE_RETURNING: u32 = 12;
pub const SPI_OK_UPDATE_RETURNING: u32 = 13;
pub const SPI_OK_REWRITTEN: u32 = 14;
pub const SPI_OK_REL_REGISTER: u32 = 15;
pub const SPI_OK_REL_UNREGISTER: u32 = 16;
pub const SPI_OK_TD_REGISTER: u32 = 17;
pub const SPI_OPT_NONATOMIC: u32 = 1;
pub const BGWORKER_SHMEM_ACCESS: u32 = 1;
pub const BGWORKER_BACKEND_DATABASE_CONNECTION: u32 = 2;
pub const BGWORKER_CLASS_PARALLEL: u32 = 16;
pub const BGW_DEFAULT_RESTART_INTERVAL: u32 = 60;
pub const BGW_NEVER_RESTART: i32 = -1;
pub const BGW_MAXLEN: u32 = 96;
pub const BGW_EXTRALEN: u32 = 128;
pub const BGWORKER_BYPASS_ALLOWCONN: u32 = 1;
pub const HAVE_PLANNERINFO_TYPEDEF: u32 = 1;
pub const HAVE_INDEXOPTINFO_TYPEDEF: u32 = 1;
pub const HAVE_SPECIALJOININFO_TYPEDEF: u32 = 1;
pub const GROUPING_CAN_USE_SORT: u32 = 1;
pub const GROUPING_CAN_USE_HASH: u32 = 2;
pub const GROUPING_CAN_PARTIAL_AGG: u32 = 4;
pub const FSV_MISSING_OK: u32 = 1;
pub const FDW_MISSING_OK: u32 = 1;
pub const MAX_MULTIBYTE_CHAR_LEN: u32 = 4;
pub const SS2: u32 = 142;
pub const SS3: u32 = 143;
pub const LC_ISO8859_1: u32 = 129;
pub const LC_ISO8859_2: u32 = 130;
pub const LC_ISO8859_3: u32 = 131;
pub const LC_ISO8859_4: u32 = 132;
pub const LC_TIS620: u32 = 133;
pub const LC_ISO8859_7: u32 = 134;
pub const LC_ISO8859_6: u32 = 135;
pub const LC_ISO8859_8: u32 = 136;
pub const LC_JISX0201K: u32 = 137;
pub const LC_JISX0201R: u32 = 138;
pub const LC_KOI8_R: u32 = 139;
pub const LC_ISO8859_5: u32 = 140;
pub const LC_ISO8859_9: u32 = 141;
pub const LC_ISO8859_15: u32 = 142;
pub const LC_JISX0208_1978: u32 = 144;
pub const LC_GB2312_80: u32 = 145;
pub const LC_JISX0208: u32 = 146;
pub const LC_KS5601: u32 = 147;
pub const LC_JISX0212: u32 = 148;
pub const LC_CNS11643_1: u32 = 149;
pub const LC_CNS11643_2: u32 = 150;
pub const LC_JISX0213_1: u32 = 151;
pub const LC_BIG5_1: u32 = 152;
pub const LC_BIG5_2: u32 = 153;
pub const LCPRV1_A: u32 = 154;
pub const LCPRV1_B: u32 = 155;
pub const LCPRV2_A: u32 = 156;
pub const LCPRV2_B: u32 = 157;
pub const LC_SISHENG: u32 = 160;
pub const LC_IPA: u32 = 161;
pub const LC_VISCII_LOWER: u32 = 162;
pub const LC_VISCII_UPPER: u32 = 163;
pub const LC_ARABIC_DIGIT: u32 = 164;
pub const LC_ARABIC_1_COLUMN: u32 = 165;
pub const LC_ASCII_RIGHT_TO_LEFT: u32 = 166;
pub const LC_LAO: u32 = 167;
pub const LC_ARABIC_2_COLUMN: u32 = 168;
pub const LC_INDIAN_1_COLUMN: u32 = 240;
pub const LC_TIBETAN_1_COLUMN: u32 = 241;
pub const LC_UNICODE_SUBSET_2: u32 = 242;
pub const LC_UNICODE_SUBSET_3: u32 = 243;
pub const LC_UNICODE_SUBSET: u32 = 244;
pub const LC_ETHIOPIC: u32 = 245;
pub const LC_CNS11643_3: u32 = 246;
pub const LC_CNS11643_4: u32 = 247;
pub const LC_CNS11643_5: u32 = 248;
pub const LC_CNS11643_6: u32 = 249;
pub const LC_CNS11643_7: u32 = 250;
pub const LC_INDIAN_2_COLUMN: u32 = 251;
pub const LC_TIBETAN: u32 = 252;
pub const MAX_CONVERSION_GROWTH: u32 = 4;
pub const MAX_UNICODE_EQUIVALENT_STRING: u32 = 16;
pub const EXTNODENAME_MAX_LEN: u32 = 64;
pub const CUSTOMPATH_SUPPORT_BACKWARD_SCAN: u32 = 1;
pub const CUSTOMPATH_SUPPORT_MARK_RESTORE: u32 = 2;
pub const QTW_IGNORE_RT_SUBQUERIES: u32 = 1;
pub const QTW_IGNORE_CTE_SUBQUERIES: u32 = 2;
pub const QTW_IGNORE_RC_SUBQUERIES: u32 = 3;
pub const QTW_IGNORE_JOINALIASES: u32 = 4;
pub const QTW_IGNORE_RANGE_TABLE: u32 = 8;
pub const QTW_EXAMINE_RTES_BEFORE: u32 = 16;
pub const QTW_EXAMINE_RTES_AFTER: u32 = 32;
pub const QTW_DONT_COPY_QUERY: u32 = 64;
pub const QTW_EXAMINE_SORTGROUP: u32 = 128;
pub const DEFAULT_SEQ_PAGE_COST: f64 = 1.0;
pub const DEFAULT_RANDOM_PAGE_COST: f64 = 4.0;
pub const DEFAULT_CPU_TUPLE_COST: f64 = 0.01;
pub const DEFAULT_CPU_INDEX_TUPLE_COST: f64 = 0.005;
pub const DEFAULT_CPU_OPERATOR_COST: f64 = 0.0025;
pub const DEFAULT_PARALLEL_TUPLE_COST: f64 = 0.1;
pub const DEFAULT_PARALLEL_SETUP_COST: f64 = 1000.0;
pub const DEFAULT_EFFECTIVE_CACHE_SIZE: u32 = 524288;
pub const PVC_INCLUDE_AGGREGATES: u32 = 1;
pub const PVC_RECURSE_AGGREGATES: u32 = 2;
pub const PVC_INCLUDE_WINDOWFUNCS: u32 = 4;
pub const PVC_RECURSE_WINDOWFUNCS: u32 = 8;
pub const PVC_INCLUDE_PLACEHOLDERS: u32 = 16;
pub const PVC_RECURSE_PLACEHOLDERS: u32 = 32;
pub const DEFAULT_CURSOR_TUPLE_FRACTION: f64 = 0.1;
pub const ER_MAGIC: u32 = 1384727874;
pub const ER_FLAG_FVALUE_VALID: u32 = 1;
pub const ER_FLAG_FVALUE_ALLOCED: u32 = 2;
pub const ER_FLAG_DVALUES_VALID: u32 = 4;
pub const ER_FLAG_DVALUES_ALLOCED: u32 = 8;
pub const ER_FLAG_HAVE_EXTERNAL: u32 = 16;
pub const ER_FLAG_TUPDESC_ALLOCED: u32 = 32;
pub const ER_FLAG_IS_DOMAIN: u32 = 64;
pub const ER_FLAG_IS_DUMMY: u32 = 128;
pub const ER_FLAGS_NON_DATA: u32 = 224;
pub const TYPECACHE_EQ_OPR: u32 = 1;
pub const TYPECACHE_LT_OPR: u32 = 2;
pub const TYPECACHE_GT_OPR: u32 = 4;
pub const TYPECACHE_CMP_PROC: u32 = 8;
pub const TYPECACHE_HASH_PROC: u32 = 16;
pub const TYPECACHE_EQ_OPR_FINFO: u32 = 32;
pub const TYPECACHE_CMP_PROC_FINFO: u32 = 64;
pub const TYPECACHE_HASH_PROC_FINFO: u32 = 128;
pub const TYPECACHE_TUPDESC: u32 = 256;
pub const TYPECACHE_BTREE_OPFAMILY: u32 = 512;
pub const TYPECACHE_HASH_OPFAMILY: u32 = 1024;
pub const TYPECACHE_RANGE_INFO: u32 = 2048;
pub const TYPECACHE_DOMAIN_BASE_INFO: u32 = 4096;
pub const TYPECACHE_DOMAIN_CONSTR_INFO: u32 = 8192;
pub const TYPECACHE_HASH_EXTENDED_PROC: u32 = 16384;
pub const TYPECACHE_HASH_EXTENDED_PROC_FINFO: u32 = 32768;
pub const PLPGSQL_XCHECK_NONE: u32 = 0;
pub const PLPGSQL_XCHECK_SHADOWVAR: u32 = 2;
pub const PLPGSQL_XCHECK_TOOMANYROWS: u32 = 4;
pub const PLPGSQL_XCHECK_STRICTMULTIASSIGNMENT: u32 = 8;
pub const POSTMASTER_FD_WATCH: u32 = 0;
pub const POSTMASTER_FD_OWN: u32 = 1;
pub const MAX_BACKENDS: u32 = 262143;
pub const RBTXN_HAS_CATALOG_CHANGES: u32 = 1;
pub const RBTXN_IS_SUBXACT: u32 = 2;
pub const RBTXN_IS_SERIALIZED: u32 = 4;
pub const OLD_SNAPSHOT_PADDING_ENTRIES: u32 = 10;
pub const MAX_IO_CONCURRENCY: u32 = 1000;
pub const BUFFER_LOCK_UNLOCK: u32 = 0;
pub const BUFFER_LOCK_SHARE: u32 = 1;
pub const BUFFER_LOCK_EXCLUSIVE: u32 = 2;
pub const XLOG_STANDBY_LOCK: u32 = 0;
pub const XLOG_RUNNING_XACTS: u32 = 16;
pub const XLOG_INVALIDATIONS: u32 = 32;
pub const PROCARRAY_VACUUM_FLAG: u32 = 2;
pub const PROCARRAY_ANALYZE_FLAG: u32 = 4;
pub const PROCARRAY_LOGICAL_DECODING_FLAG: u32 = 16;
pub const PROCARRAY_SLOTS_XMIN: u32 = 32;
pub const PROCARRAY_PROC_FLAGS_MASK: u32 = 22;
pub const PROCARRAY_FLAGS_DEFAULT: u32 = 16;
pub const PROCARRAY_FLAGS_VACUUM: u32 = 18;
pub const PROCARRAY_FLAGS_ANALYZE: u32 = 20;
pub const PROCARRAY_FLAGS_VACUUM_ANALYZE: u32 = 22;
pub const STACK_DEPTH_SLOP: u32 = 524288;
pub const COMMAND_OK_IN_READ_ONLY_TXN: u32 = 1;
pub const COMMAND_OK_IN_PARALLEL_MODE: u32 = 2;
pub const COMMAND_OK_IN_RECOVERY: u32 = 4;
pub const COMMAND_IS_STRICTLY_READ_ONLY: u32 = 7;
pub const COMMAND_IS_NOT_READ_ONLY: u32 = 0;
pub const MAXSTRLEN: u32 = 2047;
pub const MAXSTRPOS: u32 = 1048575;
pub const MAXENTRYPOS: u32 = 16384;
pub const MAXNUMPOS: u32 = 256;
pub const QI_VAL: u32 = 1;
pub const QI_OPR: u32 = 2;
pub const QI_VALSTOP: u32 = 3;
pub const OP_NOT: u32 = 1;
pub const OP_AND: u32 = 2;
pub const OP_OR: u32 = 3;
pub const OP_PHRASE: u32 = 4;
pub const OP_COUNT: u32 = 4;
pub const TSL_ADDPOS: u32 = 1;
pub const TSL_PREFIX: u32 = 2;
pub const TSL_FILTER: u32 = 4;
pub const P_TSV_OPR_IS_DELIM: u32 = 1;
pub const P_TSV_IS_TSQUERY: u32 = 2;
pub const P_TSV_IS_WEB: u32 = 4;
pub const P_TSQ_PLAIN: u32 = 1;
pub const P_TSQ_WEB: u32 = 2;
pub const TS_EXEC_EMPTY: u32 = 0;
pub const TS_EXEC_SKIP_NOT: u32 = 1;
pub const TS_EXEC_PHRASE_NO_POS: u32 = 2;
pub const TSearchStrategyNumber: u32 = 1;
pub const TSearchWithClassStrategyNumber: u32 = 2;
pub const QTN_NEEDFREE: u32 = 1;
pub const QTN_NOCHANGE: u32 = 2;
pub const QTN_WORDFREE: u32 = 4;
pub const MAXINT8LEN: u32 = 20;
pub const FORMAT_TYPE_TYPEMOD_GIVEN: u32 = 1;
pub const FORMAT_TYPE_ALLOW_INVALID: u32 = 2;
pub const FORMAT_TYPE_FORCE_QUALIFY: u32 = 4;
pub const MAX_TIME_PRECISION: u32 = 6;
pub const RADIANS_PER_DEGREE: f64 = 0.017453292519943295;
pub const NUMERIC_MAX_PRECISION: u32 = 1000;
pub const NUMERIC_MAX_DISPLAY_SCALE: u32 = 1000;
pub const NUMERIC_MIN_DISPLAY_SCALE: u32 = 0;
pub const NUMERIC_MAX_RESULT_SCALE: u32 = 2000;
pub const NUMERIC_MIN_SIG_DIGITS: u32 = 16;
pub const JsonbContainsStrategyNumber: u32 = 7;
pub const JsonbExistsStrategyNumber: u32 = 9;
pub const JsonbExistsAnyStrategyNumber: u32 = 10;
pub const JsonbExistsAllStrategyNumber: u32 = 11;
pub const JsonbJsonpathExistsStrategyNumber: u32 = 15;
pub const JsonbJsonpathPredicateStrategyNumber: u32 = 16;
pub const JGINFLAG_KEY: u32 = 1;
pub const JGINFLAG_NULL: u32 = 2;
pub const JGINFLAG_BOOL: u32 = 3;
pub const JGINFLAG_NUM: u32 = 4;
pub const JGINFLAG_STR: u32 = 5;
pub const JGINFLAG_HASHED: u32 = 16;
pub const JGIN_MAXLENGTH: u32 = 125;
pub const JENTRY_OFFLENMASK: u32 = 268435455;
pub const JENTRY_TYPEMASK: u32 = 1879048192;
pub const JENTRY_HAS_OFF: u32 = 2147483648;
pub const JENTRY_ISSTRING: u32 = 0;
pub const JENTRY_ISNUMERIC: u32 = 268435456;
pub const JENTRY_ISBOOL_FALSE: u32 = 536870912;
pub const JENTRY_ISBOOL_TRUE: u32 = 805306368;
pub const JENTRY_ISNULL: u32 = 1073741824;
pub const JENTRY_ISCONTAINER: u32 = 1342177280;
pub const JB_OFFSET_STRIDE: u32 = 32;
pub const JB_CMASK: u32 = 268435455;
pub const JB_FSCALAR: u32 = 268435456;
pub const JB_FOBJECT: u32 = 536870912;
pub const JB_FARRAY: u32 = 1073741824;
pub const ATTSTATSSLOT_VALUES: u32 = 1;
pub const ATTSTATSSLOT_NUMBERS: u32 = 2;
pub const DEFAULT_EQ_SEL: f64 = 0.005;
pub const DEFAULT_INEQ_SEL: f64 = 0.3333333333333333;
pub const DEFAULT_RANGE_INEQ_SEL: f64 = 0.005;
pub const DEFAULT_MATCH_SEL: f64 = 0.005;
pub const DEFAULT_MATCHING_SEL: f64 = 0.01;
pub const DEFAULT_NUM_DISTINCT: u32 = 200;
pub const DEFAULT_UNK_SEL: f64 = 0.005;
pub const DEFAULT_NOT_UNK_SEL: f64 = 0.995;
pub const CATCACHE_MAXKEYS: u32 = 4;
pub const CT_MAGIC: u32 = 1462113538;
pub const CL_MAGIC: u32 = 1383485699;
pub const RANGE_EMPTY: u32 = 1;
pub const RANGE_LB_INC: u32 = 2;
pub const RANGE_UB_INC: u32 = 4;
pub const RANGE_LB_INF: u32 = 8;
pub const RANGE_UB_INF: u32 = 16;
pub const RANGE_LB_NULL: u32 = 32;
pub const RANGE_UB_NULL: u32 = 64;
pub const RANGE_CONTAIN_EMPTY: u32 = 128;
pub const RANGESTRAT_BEFORE: u32 = 1;
pub const RANGESTRAT_OVERLEFT: u32 = 2;
pub const RANGESTRAT_OVERLAPS: u32 = 3;
pub const RANGESTRAT_OVERRIGHT: u32 = 4;
pub const RANGESTRAT_AFTER: u32 = 5;
pub const RANGESTRAT_ADJACENT: u32 = 6;
pub const RANGESTRAT_CONTAINS: u32 = 7;
pub const RANGESTRAT_CONTAINED_BY: u32 = 8;
pub const RANGESTRAT_CONTAINS_ELEM: u32 = 16;
pub const RANGESTRAT_EQ: u32 = 18;
pub type pg_int64 = ::std::os::raw::c_long;
pub type va_list = __builtin_va_list;
pub type __gnuc_va_list = __builtin_va_list;
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __int_least8_t = __int8_t;
pub type __uint_least8_t = __uint8_t;
pub type __int_least16_t = __int16_t;
pub type __uint_least16_t = __uint16_t;
pub type __int_least32_t = __int32_t;
pub type __uint_least32_t = __uint32_t;
pub type __int_least64_t = __int64_t;
pub type __uint_least64_t = __uint64_t;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __intmax_t = ::std::os::raw::c_long;
pub type __uintmax_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __suseconds64_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __fsword_t = ::std::os::raw::c_long;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
pub type __loff_t = __off64_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
pub type __sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __mbstate_t {
    pub __count: ::std::os::raw::c_int,
    pub __value: __mbstate_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t__bindgen_ty_1 {
    pub __wch: ::std::os::raw::c_uint,
    pub __wchb: [::std::os::raw::c_char; 4usize],
}
impl Default for __mbstate_t__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for __mbstate_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos_t {
    pub __pos: __off_t,
    pub __state: __mbstate_t,
}
impl Default for _G_fpos_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __fpos_t = _G_fpos_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos64_t {
    pub __pos: __off64_t,
    pub __state: __mbstate_t,
}
impl Default for _G_fpos64_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __fpos64_t = _G_fpos64_t;
pub type __FILE = _IO_FILE;
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _flags2: ::std::os::raw::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::std::os::raw::c_void,
    pub __pad5: usize,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 20usize],
}
impl Default for _IO_FILE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type off_t = __off_t;
pub type fpos_t = __fpos_t;
pub type _Float32 = f32;
pub type _Float64 = f64;
pub type _Float32x = f64;
pub type _Float64x = u128;
#[pgrx_macros::pg_guard]
extern "C" {
    #[link_name = "\u{1}__isoc99_fscanf"]
    pub fn fscanf1(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    #[link_name = "\u{1}__isoc99_scanf"]
    pub fn scanf1(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    #[link_name = "\u{1}__isoc99_sscanf"]
    pub fn sscanf1(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    #[link_name = "\u{1}__isoc99_vfscanf"]
    pub fn vfscanf1(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    #[link_name = "\u{1}__isoc99_vscanf"]
    pub fn vscanf1(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    #[link_name = "\u{1}__isoc99_vsscanf"]
    pub fn vsscanf1(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
pub type wchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
pub type u_char = __u_char;
pub type u_short = __u_short;
pub type u_int = __u_int;
pub type u_long = __u_long;
pub type quad_t = __quad_t;
pub type u_quad_t = __u_quad_t;
pub type fsid_t = __fsid_t;
pub type loff_t = __loff_t;
pub type ino_t = __ino_t;
pub type dev_t = __dev_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
pub type nlink_t = __nlink_t;
pub type uid_t = __uid_t;
pub type pid_t = __pid_t;
pub type id_t = __id_t;
pub type daddr_t = __daddr_t;
pub type caddr_t = __caddr_t;
pub type key_t = __key_t;
pub type clock_t = __clock_t;
pub type clockid_t = __clockid_t;
pub type time_t = __time_t;
pub type timer_t = __timer_t;
pub type ulong = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_int8_t = __uint8_t;
pub type u_int16_t = __uint16_t;
pub type u_int32_t = __uint32_t;
pub type u_int64_t = __uint64_t;
pub type register_t = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
pub type sigset_t = __sigset_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
pub type suseconds_t = __suseconds_t;
pub type __fd_mask = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct fd_set {
    pub __fds_bits: [__fd_mask; 16usize],
}
pub type fd_mask = __fd_mask;
pub type blksize_t = __blksize_t;
pub type blkcnt_t = __blkcnt_t;
pub type fsblkcnt_t = __fsblkcnt_t;
pub type fsfilcnt_t = __fsfilcnt_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __atomic_wide_counter {
    pub __value64: ::std::os::raw::c_ulonglong,
    pub __value32: __atomic_wide_counter__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __atomic_wide_counter__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
impl Default for __atomic_wide_counter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
impl Default for __pthread_internal_list {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_slist {
    pub __next: *mut __pthread_internal_slist,
}
impl Default for __pthread_internal_slist {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __pthread_slist_t = __pthread_internal_slist;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
impl Default for __pthread_mutex_s {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __pthread_rwlock_arch_t {
    pub __readers: ::std::os::raw::c_uint,
    pub __writers: ::std::os::raw::c_uint,
    pub __wrphase_futex: ::std::os::raw::c_uint,
    pub __writers_futex: ::std::os::raw::c_uint,
    pub __pad3: ::std::os::raw::c_uint,
    pub __pad4: ::std::os::raw::c_uint,
    pub __cur_writer: ::std::os::raw::c_int,
    pub __shared: ::std::os::raw::c_int,
    pub __rwelision: ::std::os::raw::c_schar,
    pub __pad1: [::std::os::raw::c_uchar; 7usize],
    pub __pad2: ::std::os::raw::c_ulong,
    pub __flags: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_cond_s {
    pub __wseq: __atomic_wide_counter,
    pub __g1_start: __atomic_wide_counter,
    pub __g_refs: [::std::os::raw::c_uint; 2usize],
    pub __g_size: [::std::os::raw::c_uint; 2usize],
    pub __g1_orig_size: ::std::os::raw::c_uint,
    pub __wrefs: ::std::os::raw::c_uint,
    pub __g_signals: [::std::os::raw::c_uint; 2usize],
}
impl Default for __pthread_cond_s {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __tss_t = ::std::os::raw::c_uint;
pub type __thrd_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __once_flag {
    pub __data: ::std::os::raw::c_int,
}
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutexattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
impl Default for pthread_mutexattr_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_condattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
impl Default for pthread_condattr_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type pthread_key_t = ::std::os::raw::c_uint;
pub type pthread_once_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_attr_t {
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
impl Default for pthread_attr_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
}
impl Default for pthread_mutex_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: __pthread_cond_s,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
}
impl Default for pthread_cond_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t {
    pub __data: __pthread_rwlock_arch_t,
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
impl Default for pthread_rwlock_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlockattr_t {
    pub __size: [::std::os::raw::c_char; 8usize],
    pub __align: ::std::os::raw::c_long,
}
impl Default for pthread_rwlockattr_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type pthread_spinlock_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrier_t {
    pub __size: [::std::os::raw::c_char; 32usize],
    pub __align: ::std::os::raw::c_long,
}
impl Default for pthread_barrier_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrierattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
impl Default for pthread_barrierattr_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct random_data {
    pub fptr: *mut i32,
    pub rptr: *mut i32,
    pub state: *mut i32,
    pub rand_type: ::std::os::raw::c_int,
    pub rand_deg: ::std::os::raw::c_int,
    pub rand_sep: ::std::os::raw::c_int,
    pub end_ptr: *mut i32,
}
impl Default for random_data {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct drand48_data {
    pub __x: [::std::os::raw::c_ushort; 3usize],
    pub __old_x: [::std::os::raw::c_ushort; 3usize],
    pub __c: ::std::os::raw::c_ushort,
    pub __init: ::std::os::raw::c_ushort,
    pub __a: ::std::os::raw::c_ulonglong,
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn alloca(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn atexit(__func: ::std::option::Option<unsafe extern "C" fn()>) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn at_quick_exit(
        __func: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
pub type __compar_fn_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __memcmpeq(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: usize,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __locale_struct {
    pub __locales: [*mut __locale_data; 13usize],
    pub __ctype_b: *const ::std::os::raw::c_ushort,
    pub __ctype_tolower: *const ::std::os::raw::c_int,
    pub __ctype_toupper: *const ::std::os::raw::c_int,
    pub __names: [*const ::std::os::raw::c_char; 13usize],
}
impl Default for __locale_struct {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __locale_t = *mut __locale_struct;
pub type locale_t = __locale_t;
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Default, Copy, Clone)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::std::os::raw::c_longlong,
    pub __bindgen_padding_0: u64,
    pub __clang_max_align_nonce2: u128,
}
pub type int_least8_t = __int_least8_t;
pub type int_least16_t = __int_least16_t;
pub type int_least32_t = __int_least32_t;
pub type int_least64_t = __int_least64_t;
pub type uint_least8_t = __uint_least8_t;
pub type uint_least16_t = __uint_least16_t;
pub type uint_least32_t = __uint_least32_t;
pub type uint_least64_t = __uint_least64_t;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type int_fast16_t = ::std::os::raw::c_long;
pub type int_fast32_t = ::std::os::raw::c_long;
pub type int_fast64_t = ::std::os::raw::c_long;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type uint_fast16_t = ::std::os::raw::c_ulong;
pub type uint_fast32_t = ::std::os::raw::c_ulong;
pub type uint_fast64_t = ::std::os::raw::c_ulong;
pub type intmax_t = __intmax_t;
pub type uintmax_t = __uintmax_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lconv {
    pub decimal_point: *mut ::std::os::raw::c_char,
    pub thousands_sep: *mut ::std::os::raw::c_char,
    pub grouping: *mut ::std::os::raw::c_char,
    pub int_curr_symbol: *mut ::std::os::raw::c_char,
    pub currency_symbol: *mut ::std::os::raw::c_char,
    pub mon_decimal_point: *mut ::std::os::raw::c_char,
    pub mon_thousands_sep: *mut ::std::os::raw::c_char,
    pub mon_grouping: *mut ::std::os::raw::c_char,
    pub positive_sign: *mut ::std::os::raw::c_char,
    pub negative_sign: *mut ::std::os::raw::c_char,
    pub int_frac_digits: ::std::os::raw::c_char,
    pub frac_digits: ::std::os::raw::c_char,
    pub p_cs_precedes: ::std::os::raw::c_char,
    pub p_sep_by_space: ::std::os::raw::c_char,
    pub n_cs_precedes: ::std::os::raw::c_char,
    pub n_sep_by_space: ::std::os::raw::c_char,
    pub p_sign_posn: ::std::os::raw::c_char,
    pub n_sign_posn: ::std::os::raw::c_char,
    pub int_p_cs_precedes: ::std::os::raw::c_char,
    pub int_p_sep_by_space: ::std::os::raw::c_char,
    pub int_n_cs_precedes: ::std::os::raw::c_char,
    pub int_n_sep_by_space: ::std::os::raw::c_char,
    pub int_p_sign_posn: ::std::os::raw::c_char,
    pub int_n_sign_posn: ::std::os::raw::c_char,
}
impl Default for lconv {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Pointer = *mut ::std::os::raw::c_char;
pub type int8 = ::std::os::raw::c_schar;
pub type int16 = ::std::os::raw::c_short;
pub type int32 = ::std::os::raw::c_int;
pub type uint8 = ::std::os::raw::c_uchar;
pub type uint16 = ::std::os::raw::c_ushort;
pub type uint32 = ::std::os::raw::c_uint;
pub type bits8 = uint8;
pub type bits16 = uint16;
pub type bits32 = uint32;
pub type int64 = ::std::os::raw::c_long;
pub type uint64 = ::std::os::raw::c_ulong;
pub type int128 = i128;
pub type uint128 = u128;
pub type Size = usize;
pub type Index = ::std::os::raw::c_uint;
pub type Offset = ::std::os::raw::c_int;
pub type float4 = f32;
pub type float8 = f64;
pub type regproc = Oid;
pub type RegProcedure = regproc;
pub type TransactionId = uint32;
pub type LocalTransactionId = uint32;
pub type SubTransactionId = uint32;
pub type MultiXactId = TransactionId;
pub type MultiXactOffset = uint32;
pub type CommandId = uint32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IntArray {
    pub indx: [::std::os::raw::c_int; 6usize],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varlena {
    pub vl_len_: [::std::os::raw::c_char; 4usize],
    pub vl_dat: __IncompleteArrayField<::std::os::raw::c_char>,
}
pub type bytea = varlena;
pub type text = varlena;
pub type BpChar = varlena;
pub type VarChar = varlena;
#[repr(C)]
#[derive(Debug)]
pub struct int2vector {
    pub vl_len_: int32,
    pub ndim: ::std::os::raw::c_int,
    pub dataoffset: int32,
    pub elemtype: Oid,
    pub dim1: ::std::os::raw::c_int,
    pub lbound1: ::std::os::raw::c_int,
    pub values: __IncompleteArrayField<int16>,
}
impl Default for int2vector {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct oidvector {
    pub vl_len_: int32,
    pub ndim: ::std::os::raw::c_int,
    pub dataoffset: int32,
    pub elemtype: Oid,
    pub dim1: ::std::os::raw::c_int,
    pub lbound1: ::std::os::raw::c_int,
    pub values: __IncompleteArrayField<Oid>,
}
impl Default for oidvector {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nameData {
    pub data: [::std::os::raw::c_char; 64usize],
}
impl Default for nameData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type NameData = nameData;
pub type Name = *mut NameData;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExceptionalCondition(
        conditionName: *const ::std::os::raw::c_char,
        errorType: *const ::std::os::raw::c_char,
        fileName: *const ::std::os::raw::c_char,
        lineNumber: ::std::os::raw::c_int,
    ) -> !;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union PGAlignedBlock {
    pub data: [::std::os::raw::c_char; 8192usize],
    pub force_align_d: f64,
    pub force_align_i64: int64,
}
impl Default for PGAlignedBlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union PGAlignedXLogBlock {
    pub data: [::std::os::raw::c_char; 8192usize],
    pub force_align_d: f64,
    pub force_align_i64: int64,
}
impl Default for PGAlignedXLogBlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const _ISupper: _bindgen_ty_1 = 256;
pub const _ISlower: _bindgen_ty_1 = 512;
pub const _ISalpha: _bindgen_ty_1 = 1024;
pub const _ISdigit: _bindgen_ty_1 = 2048;
pub const _ISxdigit: _bindgen_ty_1 = 4096;
pub const _ISspace: _bindgen_ty_1 = 8192;
pub const _ISprint: _bindgen_ty_1 = 16384;
pub const _ISgraph: _bindgen_ty_1 = 32768;
pub const _ISblank: _bindgen_ty_1 = 1;
pub const _IScntrl: _bindgen_ty_1 = 2;
pub const _ISpunct: _bindgen_ty_1 = 4;
pub const _ISalnum: _bindgen_ty_1 = 8;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iovec {
    pub iov_base: *mut ::std::os::raw::c_void,
    pub iov_len: usize,
}
impl Default for iovec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type socklen_t = __socklen_t;
pub const __socket_type_SOCK_STREAM: __socket_type = 1;
pub const __socket_type_SOCK_DGRAM: __socket_type = 2;
pub const __socket_type_SOCK_RAW: __socket_type = 3;
pub const __socket_type_SOCK_RDM: __socket_type = 4;
pub const __socket_type_SOCK_SEQPACKET: __socket_type = 5;
pub const __socket_type_SOCK_DCCP: __socket_type = 6;
pub const __socket_type_SOCK_PACKET: __socket_type = 10;
pub const __socket_type_SOCK_CLOEXEC: __socket_type = 524288;
pub const __socket_type_SOCK_NONBLOCK: __socket_type = 2048;
pub type __socket_type = ::std::os::raw::c_uint;
pub type sa_family_t = ::std::os::raw::c_ushort;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct sockaddr {
    pub sa_family: sa_family_t,
    pub sa_data: [::std::os::raw::c_char; 14usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_storage {
    pub ss_family: sa_family_t,
    pub __ss_padding: [::std::os::raw::c_char; 118usize],
    pub __ss_align: ::std::os::raw::c_ulong,
}
impl Default for sockaddr_storage {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const MSG_OOB: _bindgen_ty_2 = 1;
pub const MSG_PEEK: _bindgen_ty_2 = 2;
pub const MSG_DONTROUTE: _bindgen_ty_2 = 4;
pub const MSG_CTRUNC: _bindgen_ty_2 = 8;
pub const MSG_PROXY: _bindgen_ty_2 = 16;
pub const MSG_TRUNC: _bindgen_ty_2 = 32;
pub const MSG_DONTWAIT: _bindgen_ty_2 = 64;
pub const MSG_EOR: _bindgen_ty_2 = 128;
pub const MSG_WAITALL: _bindgen_ty_2 = 256;
pub const MSG_FIN: _bindgen_ty_2 = 512;
pub const MSG_SYN: _bindgen_ty_2 = 1024;
pub const MSG_CONFIRM: _bindgen_ty_2 = 2048;
pub const MSG_RST: _bindgen_ty_2 = 4096;
pub const MSG_ERRQUEUE: _bindgen_ty_2 = 8192;
pub const MSG_NOSIGNAL: _bindgen_ty_2 = 16384;
pub const MSG_MORE: _bindgen_ty_2 = 32768;
pub const MSG_WAITFORONE: _bindgen_ty_2 = 65536;
pub const MSG_BATCH: _bindgen_ty_2 = 262144;
pub const MSG_ZEROCOPY: _bindgen_ty_2 = 67108864;
pub const MSG_FASTOPEN: _bindgen_ty_2 = 536870912;
pub const MSG_CMSG_CLOEXEC: _bindgen_ty_2 = 1073741824;
pub type _bindgen_ty_2 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct msghdr {
    pub msg_name: *mut ::std::os::raw::c_void,
    pub msg_namelen: socklen_t,
    pub msg_iov: *mut iovec,
    pub msg_iovlen: usize,
    pub msg_control: *mut ::std::os::raw::c_void,
    pub msg_controllen: usize,
    pub msg_flags: ::std::os::raw::c_int,
}
impl Default for msghdr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct cmsghdr {
    pub cmsg_len: usize,
    pub cmsg_level: ::std::os::raw::c_int,
    pub cmsg_type: ::std::os::raw::c_int,
    pub __cmsg_data: __IncompleteArrayField<::std::os::raw::c_uchar>,
}
pub const SCM_RIGHTS: _bindgen_ty_3 = 1;
pub type _bindgen_ty_3 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __kernel_fd_set {
    pub fds_bits: [::std::os::raw::c_ulong; 16usize],
}
pub type __kernel_sighandler_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
pub type __kernel_key_t = ::std::os::raw::c_int;
pub type __kernel_mqd_t = ::std::os::raw::c_int;
pub type __kernel_old_uid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_gid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_dev_t = ::std::os::raw::c_ulong;
pub type __kernel_long_t = ::std::os::raw::c_long;
pub type __kernel_ulong_t = ::std::os::raw::c_ulong;
pub type __kernel_ino_t = __kernel_ulong_t;
pub type __kernel_mode_t = ::std::os::raw::c_uint;
pub type __kernel_pid_t = ::std::os::raw::c_int;
pub type __kernel_ipc_pid_t = ::std::os::raw::c_int;
pub type __kernel_uid_t = ::std::os::raw::c_uint;
pub type __kernel_gid_t = ::std::os::raw::c_uint;
pub type __kernel_suseconds_t = __kernel_long_t;
pub type __kernel_daddr_t = ::std::os::raw::c_int;
pub type __kernel_uid32_t = ::std::os::raw::c_uint;
pub type __kernel_gid32_t = ::std::os::raw::c_uint;
pub type __kernel_size_t = __kernel_ulong_t;
pub type __kernel_ssize_t = __kernel_long_t;
pub type __kernel_ptrdiff_t = __kernel_long_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __kernel_fsid_t {
    pub val: [::std::os::raw::c_int; 2usize],
}
pub type __kernel_off_t = __kernel_long_t;
pub type __kernel_loff_t = ::std::os::raw::c_longlong;
pub type __kernel_old_time_t = __kernel_long_t;
pub type __kernel_time_t = __kernel_long_t;
pub type __kernel_time64_t = ::std::os::raw::c_longlong;
pub type __kernel_clock_t = __kernel_long_t;
pub type __kernel_timer_t = ::std::os::raw::c_int;
pub type __kernel_clockid_t = ::std::os::raw::c_int;
pub type __kernel_caddr_t = *mut ::std::os::raw::c_char;
pub type __kernel_uid16_t = ::std::os::raw::c_ushort;
pub type __kernel_gid16_t = ::std::os::raw::c_ushort;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct linger {
    pub l_onoff: ::std::os::raw::c_int,
    pub l_linger: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct osockaddr {
    pub sa_family: ::std::os::raw::c_ushort,
    pub sa_data: [::std::os::raw::c_uchar; 14usize],
}
pub const SHUT_RD: _bindgen_ty_4 = 0;
pub const SHUT_WR: _bindgen_ty_4 = 1;
pub const SHUT_RDWR: _bindgen_ty_4 = 2;
pub type _bindgen_ty_4 = ::std::os::raw::c_uint;
pub type in_addr_t = u32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct in_addr {
    pub s_addr: in_addr_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ip_opts {
    pub ip_dst: in_addr,
    pub ip_opts: [::std::os::raw::c_char; 40usize],
}
impl Default for ip_opts {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ip_mreqn {
    pub imr_multiaddr: in_addr,
    pub imr_address: in_addr,
    pub imr_ifindex: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct in_pktinfo {
    pub ipi_ifindex: ::std::os::raw::c_int,
    pub ipi_spec_dst: in_addr,
    pub ipi_addr: in_addr,
}
pub const IPPROTO_IP: _bindgen_ty_5 = 0;
pub const IPPROTO_ICMP: _bindgen_ty_5 = 1;
pub const IPPROTO_IGMP: _bindgen_ty_5 = 2;
pub const IPPROTO_IPIP: _bindgen_ty_5 = 4;
pub const IPPROTO_TCP: _bindgen_ty_5 = 6;
pub const IPPROTO_EGP: _bindgen_ty_5 = 8;
pub const IPPROTO_PUP: _bindgen_ty_5 = 12;
pub const IPPROTO_UDP: _bindgen_ty_5 = 17;
pub const IPPROTO_IDP: _bindgen_ty_5 = 22;
pub const IPPROTO_TP: _bindgen_ty_5 = 29;
pub const IPPROTO_DCCP: _bindgen_ty_5 = 33;
pub const IPPROTO_IPV6: _bindgen_ty_5 = 41;
pub const IPPROTO_RSVP: _bindgen_ty_5 = 46;
pub const IPPROTO_GRE: _bindgen_ty_5 = 47;
pub const IPPROTO_ESP: _bindgen_ty_5 = 50;
pub const IPPROTO_AH: _bindgen_ty_5 = 51;
pub const IPPROTO_MTP: _bindgen_ty_5 = 92;
pub const IPPROTO_BEETPH: _bindgen_ty_5 = 94;
pub const IPPROTO_ENCAP: _bindgen_ty_5 = 98;
pub const IPPROTO_PIM: _bindgen_ty_5 = 103;
pub const IPPROTO_COMP: _bindgen_ty_5 = 108;
pub const IPPROTO_SCTP: _bindgen_ty_5 = 132;
pub const IPPROTO_UDPLITE: _bindgen_ty_5 = 136;
pub const IPPROTO_MPLS: _bindgen_ty_5 = 137;
pub const IPPROTO_ETHERNET: _bindgen_ty_5 = 143;
pub const IPPROTO_RAW: _bindgen_ty_5 = 255;
pub const IPPROTO_MPTCP: _bindgen_ty_5 = 262;
pub const IPPROTO_MAX: _bindgen_ty_5 = 263;
pub type _bindgen_ty_5 = ::std::os::raw::c_uint;
pub const IPPROTO_HOPOPTS: _bindgen_ty_6 = 0;
pub const IPPROTO_ROUTING: _bindgen_ty_6 = 43;
pub const IPPROTO_FRAGMENT: _bindgen_ty_6 = 44;
pub const IPPROTO_ICMPV6: _bindgen_ty_6 = 58;
pub const IPPROTO_NONE: _bindgen_ty_6 = 59;
pub const IPPROTO_DSTOPTS: _bindgen_ty_6 = 60;
pub const IPPROTO_MH: _bindgen_ty_6 = 135;
pub type _bindgen_ty_6 = ::std::os::raw::c_uint;
pub type in_port_t = u16;
pub const IPPORT_ECHO: _bindgen_ty_7 = 7;
pub const IPPORT_DISCARD: _bindgen_ty_7 = 9;
pub const IPPORT_SYSTAT: _bindgen_ty_7 = 11;
pub const IPPORT_DAYTIME: _bindgen_ty_7 = 13;
pub const IPPORT_NETSTAT: _bindgen_ty_7 = 15;
pub const IPPORT_FTP: _bindgen_ty_7 = 21;
pub const IPPORT_TELNET: _bindgen_ty_7 = 23;
pub const IPPORT_SMTP: _bindgen_ty_7 = 25;
pub const IPPORT_TIMESERVER: _bindgen_ty_7 = 37;
pub const IPPORT_NAMESERVER: _bindgen_ty_7 = 42;
pub const IPPORT_WHOIS: _bindgen_ty_7 = 43;
pub const IPPORT_MTP: _bindgen_ty_7 = 57;
pub const IPPORT_TFTP: _bindgen_ty_7 = 69;
pub const IPPORT_RJE: _bindgen_ty_7 = 77;
pub const IPPORT_FINGER: _bindgen_ty_7 = 79;
pub const IPPORT_TTYLINK: _bindgen_ty_7 = 87;
pub const IPPORT_SUPDUP: _bindgen_ty_7 = 95;
pub const IPPORT_EXECSERVER: _bindgen_ty_7 = 512;
pub const IPPORT_LOGINSERVER: _bindgen_ty_7 = 513;
pub const IPPORT_CMDSERVER: _bindgen_ty_7 = 514;
pub const IPPORT_EFSSERVER: _bindgen_ty_7 = 520;
pub const IPPORT_BIFFUDP: _bindgen_ty_7 = 512;
pub const IPPORT_WHOSERVER: _bindgen_ty_7 = 513;
pub const IPPORT_ROUTESERVER: _bindgen_ty_7 = 520;
pub const IPPORT_RESERVED: _bindgen_ty_7 = 1024;
pub const IPPORT_USERRESERVED: _bindgen_ty_7 = 5000;
pub type _bindgen_ty_7 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in6_addr {
    pub __in6_u: in6_addr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union in6_addr__bindgen_ty_1 {
    pub __u6_addr8: [u8; 16usize],
    pub __u6_addr16: [u16; 8usize],
    pub __u6_addr32: [u32; 4usize],
}
impl Default for in6_addr__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for in6_addr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct sockaddr_in {
    pub sin_family: sa_family_t,
    pub sin_port: in_port_t,
    pub sin_addr: in_addr,
    pub sin_zero: [::std::os::raw::c_uchar; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sockaddr_in6 {
    pub sin6_family: sa_family_t,
    pub sin6_port: in_port_t,
    pub sin6_flowinfo: u32,
    pub sin6_addr: in6_addr,
    pub sin6_scope_id: u32,
}
impl Default for sockaddr_in6 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ip_mreq {
    pub imr_multiaddr: in_addr,
    pub imr_interface: in_addr,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ip_mreq_source {
    pub imr_multiaddr: in_addr,
    pub imr_interface: in_addr,
    pub imr_sourceaddr: in_addr,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ipv6_mreq {
    pub ipv6mr_multiaddr: in6_addr,
    pub ipv6mr_interface: ::std::os::raw::c_uint,
}
impl Default for ipv6_mreq {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct group_req {
    pub gr_interface: u32,
    pub gr_group: sockaddr_storage,
}
impl Default for group_req {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct group_source_req {
    pub gsr_interface: u32,
    pub gsr_group: sockaddr_storage,
    pub gsr_source: sockaddr_storage,
}
impl Default for group_source_req {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ip_msfilter {
    pub imsf_multiaddr: in_addr,
    pub imsf_interface: in_addr,
    pub imsf_fmode: u32,
    pub imsf_numsrc: u32,
    pub imsf_slist: [in_addr; 1usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct group_filter {
    pub gf_interface: u32,
    pub gf_group: sockaddr_storage,
    pub gf_fmode: u32,
    pub gf_numsrc: u32,
    pub gf_slist: [sockaddr_storage; 1usize],
}
impl Default for group_filter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bindresvport6(
        __sockfd: ::std::os::raw::c_int,
        __sock_in: *mut sockaddr_in6,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rpcent {
    pub r_name: *mut ::std::os::raw::c_char,
    pub r_aliases: *mut *mut ::std::os::raw::c_char,
    pub r_number: ::std::os::raw::c_int,
}
impl Default for rpcent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct netent {
    pub n_name: *mut ::std::os::raw::c_char,
    pub n_aliases: *mut *mut ::std::os::raw::c_char,
    pub n_addrtype: ::std::os::raw::c_int,
    pub n_net: u32,
}
impl Default for netent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hostent {
    pub h_name: *mut ::std::os::raw::c_char,
    pub h_aliases: *mut *mut ::std::os::raw::c_char,
    pub h_addrtype: ::std::os::raw::c_int,
    pub h_length: ::std::os::raw::c_int,
    pub h_addr_list: *mut *mut ::std::os::raw::c_char,
}
impl Default for hostent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct servent {
    pub s_name: *mut ::std::os::raw::c_char,
    pub s_aliases: *mut *mut ::std::os::raw::c_char,
    pub s_port: ::std::os::raw::c_int,
    pub s_proto: *mut ::std::os::raw::c_char,
}
impl Default for servent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct protoent {
    pub p_name: *mut ::std::os::raw::c_char,
    pub p_aliases: *mut *mut ::std::os::raw::c_char,
    pub p_proto: ::std::os::raw::c_int,
}
impl Default for protoent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct addrinfo {
    pub ai_flags: ::std::os::raw::c_int,
    pub ai_family: ::std::os::raw::c_int,
    pub ai_socktype: ::std::os::raw::c_int,
    pub ai_protocol: ::std::os::raw::c_int,
    pub ai_addrlen: socklen_t,
    pub ai_addr: *mut sockaddr,
    pub ai_canonname: *mut ::std::os::raw::c_char,
    pub ai_next: *mut addrinfo,
}
impl Default for addrinfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct passwd {
    pub pw_name: *mut ::std::os::raw::c_char,
    pub pw_passwd: *mut ::std::os::raw::c_char,
    pub pw_uid: __uid_t,
    pub pw_gid: __gid_t,
    pub pw_gecos: *mut ::std::os::raw::c_char,
    pub pw_dir: *mut ::std::os::raw::c_char,
    pub pw_shell: *mut ::std::os::raw::c_char,
}
impl Default for passwd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type pgsocket = ::std::os::raw::c_int;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_set_noblock(sock: pgsocket) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_set_block(sock: pgsocket) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn has_drive_prefix(filename: *const ::std::os::raw::c_char) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn first_dir_separator(
        filename: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn last_dir_separator(
        filename: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn first_path_var_separator(
        pathlist: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn join_path_components(
        ret_path: *mut ::std::os::raw::c_char,
        head: *const ::std::os::raw::c_char,
        tail: *const ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn canonicalize_path(path: *mut ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn make_native_path(path: *mut ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn cleanup_path(path: *mut ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn path_contains_parent_reference(path: *const ::std::os::raw::c_char) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn path_is_relative_and_below_cwd(path: *const ::std::os::raw::c_char) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn path_is_prefix_of_path(
        path1: *const ::std::os::raw::c_char,
        path2: *const ::std::os::raw::c_char,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn make_absolute_path(path: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_progname(argv0: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_share_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_etc_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_include_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_pkginclude_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_includeserver_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_lib_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_pkglib_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_locale_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_doc_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_html_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_man_path(
        my_exec_path: *const ::std::os::raw::c_char,
        ret_path: *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_home_path(ret_path: *mut ::std::os::raw::c_char) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_parent_directory(path: *mut ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgfnames(path: *const ::std::os::raw::c_char) -> *mut *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgfnames_cleanup(filenames: *mut *mut ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn set_pglocale_pgservice(
        argv0: *const ::std::os::raw::c_char,
        app: *const ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn find_my_exec(
        argv0: *const ::std::os::raw::c_char,
        retpath: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn find_other_exec(
        argv0: *const ::std::os::raw::c_char,
        target: *const ::std::os::raw::c_char,
        versionstr: *const ::std::os::raw::c_char,
        retpath: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pipe_read_line(
        cmd: *mut ::std::os::raw::c_char,
        line: *mut ::std::os::raw::c_char,
        maxsize: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_usleep(microsec: ::std::os::raw::c_long);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_strcasecmp(
        s1: *const ::std::os::raw::c_char,
        s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_strncasecmp(
        s1: *const ::std::os::raw::c_char,
        s2: *const ::std::os::raw::c_char,
        n: usize,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_toupper(ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_tolower(ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_ascii_toupper(ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_ascii_tolower(ch: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_snprintf(
        str_: *mut ::std::os::raw::c_char,
        count: usize,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_sprintf(
        str_: *mut ::std::os::raw::c_char,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_fprintf(
        stream: *mut FILE,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_printf(fmt: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_strfromd(
        str_: *mut ::std::os::raw::c_char,
        count: usize,
        precision: ::std::os::raw::c_int,
        value: f64,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_strerror(errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_strerror_r(
        errnum: ::std::os::raw::c_int,
        buf: *mut ::std::os::raw::c_char,
        buflen: usize,
    ) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_strsignal(signum: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn simple_prompt(
        prompt: *const ::std::os::raw::c_char,
        destination: *mut ::std::os::raw::c_char,
        destlen: usize,
        echo: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pclose_check(stream: *mut FILE) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn rmtree(path: *const ::std::os::raw::c_char, rmtopdir: bool) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_erand48(xseed: *mut ::std::os::raw::c_ushort) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_lrand48() -> ::std::os::raw::c_long;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_jrand48(xseed: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_srand48(seed: ::std::os::raw::c_long);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn fls(mask: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn getpeereid(
        sock: ::std::os::raw::c_int,
        uid: *mut uid_t,
        gid: *mut gid_t,
    ) -> ::std::os::raw::c_int;
}
pub type float_t = f32;
pub type double_t = f64;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __acos(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __asin(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __atan(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __atan2(__y: f64, __x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __cos(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __sin(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __tan(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __cosh(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __sinh(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __tanh(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __acosh(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __asinh(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __atanh(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __exp(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __frexp(__x: f64, __exponent: *mut ::std::os::raw::c_int) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __ldexp(__x: f64, __exponent: ::std::os::raw::c_int) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __log(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __log10(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __modf(__x: f64, __iptr: *mut f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __expm1(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __log1p(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __logb(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __exp2(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __log2(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __pow(__x: f64, __y: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __sqrt(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __hypot(__x: f64, __y: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __cbrt(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __ceil(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __fabs(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __floor(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __fmod(__x: f64, __y: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __drem(__x: f64, __y: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __significand(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __copysign(__x: f64, __y: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __nan(__tagb: *const ::std::os::raw::c_char) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __j0(arg1: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __j1(arg1: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __jn(arg1: ::std::os::raw::c_int, arg2: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __y0(arg1: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __y1(arg1: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __yn(arg1: ::std::os::raw::c_int, arg2: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __erf(arg1: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __erfc(arg1: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __lgamma(arg1: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __tgamma(arg1: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __gamma(arg1: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __lgamma_r(arg1: f64, __signgamp: *mut ::std::os::raw::c_int) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __rint(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __nextafter(__x: f64, __y: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __nexttoward(__x: f64, __y: u128) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __remainder(__x: f64, __y: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __scalbn(__x: f64, __n: ::std::os::raw::c_int) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __ilogb(__x: f64) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __scalbln(__x: f64, __n: ::std::os::raw::c_long) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __nearbyint(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __round(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __trunc(__x: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __remquo(__x: f64, __y: f64, __quo: *mut ::std::os::raw::c_int) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __lrint(__x: f64) -> ::std::os::raw::c_long;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __llrint(__x: f64) -> ::std::os::raw::c_longlong;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __lround(__x: f64) -> ::std::os::raw::c_long;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __llround(__x: f64) -> ::std::os::raw::c_longlong;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __fdim(__x: f64, __y: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __fmax(__x: f64, __y: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __fmin(__x: f64, __y: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __fma(__x: f64, __y: f64, __z: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __scalb(__x: f64, __n: f64) -> f64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __acosf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __asinf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __atanf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __atan2f(__y: f32, __x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __cosf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __sinf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __tanf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __coshf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __sinhf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __tanhf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __acoshf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __asinhf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __atanhf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __expf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __frexpf(__x: f32, __exponent: *mut ::std::os::raw::c_int) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __ldexpf(__x: f32, __exponent: ::std::os::raw::c_int) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __logf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __log10f(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __modff(__x: f32, __iptr: *mut f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __expm1f(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __log1pf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __logbf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __exp2f(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __log2f(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __powf(__x: f32, __y: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __sqrtf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __hypotf(__x: f32, __y: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __cbrtf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __ceilf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __fabsf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __floorf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __fmodf(__x: f32, __y: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __dremf(__x: f32, __y: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __significandf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __copysignf(__x: f32, __y: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __nanf(__tagb: *const ::std::os::raw::c_char) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __j0f(arg1: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __j1f(arg1: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __jnf(arg1: ::std::os::raw::c_int, arg2: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __y0f(arg1: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __y1f(arg1: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __ynf(arg1: ::std::os::raw::c_int, arg2: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __erff(arg1: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __erfcf(arg1: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __lgammaf(arg1: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __tgammaf(arg1: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __gammaf(arg1: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __lgammaf_r(arg1: f32, __signgamp: *mut ::std::os::raw::c_int) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __rintf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __nextafterf(__x: f32, __y: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __nexttowardf(__x: f32, __y: u128) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __remainderf(__x: f32, __y: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __scalbnf(__x: f32, __n: ::std::os::raw::c_int) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __ilogbf(__x: f32) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __scalblnf(__x: f32, __n: ::std::os::raw::c_long) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __nearbyintf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __roundf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __truncf(__x: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __remquof(__x: f32, __y: f32, __quo: *mut ::std::os::raw::c_int) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __lrintf(__x: f32) -> ::std::os::raw::c_long;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __llrintf(__x: f32) -> ::std::os::raw::c_longlong;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __lroundf(__x: f32) -> ::std::os::raw::c_long;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __llroundf(__x: f32) -> ::std::os::raw::c_longlong;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __fdimf(__x: f32, __y: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __fmaxf(__x: f32, __y: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __fminf(__x: f32, __y: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __fmaf(__x: f32, __y: f32, __z: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __scalbf(__x: f32, __n: f32) -> f32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __acosl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __asinl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __atanl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __atan2l(__y: u128, __x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __cosl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __sinl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __tanl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __coshl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __sinhl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __tanhl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __acoshl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __asinhl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __atanhl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __expl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __frexpl(__x: u128, __exponent: *mut ::std::os::raw::c_int) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __ldexpl(__x: u128, __exponent: ::std::os::raw::c_int) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __logl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __log10l(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __modfl(__x: u128, __iptr: *mut u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __expm1l(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __log1pl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __logbl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __exp2l(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __log2l(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __powl(__x: u128, __y: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __sqrtl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __hypotl(__x: u128, __y: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __cbrtl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __ceill(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __fabsl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __floorl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __fmodl(__x: u128, __y: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __dreml(__x: u128, __y: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __significandl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __copysignl(__x: u128, __y: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __nanl(__tagb: *const ::std::os::raw::c_char) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __j0l(arg1: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __j1l(arg1: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __jnl(arg1: ::std::os::raw::c_int, arg2: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __y0l(arg1: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __y1l(arg1: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __ynl(arg1: ::std::os::raw::c_int, arg2: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __erfl(arg1: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __erfcl(arg1: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __lgammal(arg1: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __tgammal(arg1: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __gammal(arg1: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __lgammal_r(arg1: u128, __signgamp: *mut ::std::os::raw::c_int) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __rintl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __nextafterl(__x: u128, __y: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __nexttowardl(__x: u128, __y: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __remainderl(__x: u128, __y: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __scalbnl(__x: u128, __n: ::std::os::raw::c_int) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __ilogbl(__x: u128) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __scalblnl(__x: u128, __n: ::std::os::raw::c_long) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __nearbyintl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __roundl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __truncl(__x: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __remquol(__x: u128, __y: u128, __quo: *mut ::std::os::raw::c_int) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __lrintl(__x: u128) -> ::std::os::raw::c_long;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __llrintl(__x: u128) -> ::std::os::raw::c_longlong;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __lroundl(__x: u128) -> ::std::os::raw::c_long;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __llroundl(__x: u128) -> ::std::os::raw::c_longlong;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __fdiml(__x: u128, __y: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __fmaxl(__x: u128, __y: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __fminl(__x: u128, __y: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __fmal(__x: u128, __y: u128, __z: u128) -> u128;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn __scalbl(__x: u128, __n: u128) -> u128;
}
pub const FP_NAN: _bindgen_ty_8 = 0;
pub const FP_INFINITE: _bindgen_ty_8 = 1;
pub const FP_ZERO: _bindgen_ty_8 = 2;
pub const FP_SUBNORMAL: _bindgen_ty_8 = 3;
pub const FP_NORMAL: _bindgen_ty_8 = 4;
pub type _bindgen_ty_8 = ::std::os::raw::c_uint;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn strlcat(
        dst: *mut ::std::os::raw::c_char,
        src: *const ::std::os::raw::c_char,
        siz: usize,
    ) -> usize;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn strlcpy(
        dst: *mut ::std::os::raw::c_char,
        src: *const ::std::os::raw::c_char,
        siz: usize,
    ) -> usize;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_qsort(
        base: *mut ::std::os::raw::c_void,
        nel: usize,
        elsize: usize,
        cmp: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_qsort_strcmp(
        a: *const ::std::os::raw::c_void,
        b: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
pub type qsort_arg_comparator = ::std::option::Option<
    unsafe extern "C" fn(
        a: *const ::std::os::raw::c_void,
        b: *const ::std::os::raw::c_void,
        arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn qsort_arg(
        base: *mut ::std::os::raw::c_void,
        nel: usize,
        elsize: usize,
        cmp: qsort_arg_comparator,
        arg: *mut ::std::os::raw::c_void,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_get_encoding_from_locale(
        ctype: *const ::std::os::raw::c_char,
        write_message: bool,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_inet_net_ntop(
        af: ::std::os::raw::c_int,
        src: *const ::std::os::raw::c_void,
        bits: ::std::os::raw::c_int,
        dst: *mut ::std::os::raw::c_char,
        size: usize,
    ) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_strong_random(buf: *mut ::std::os::raw::c_void, len: usize) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_check_dir(dir: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_mkdir_p(
        path: *mut ::std::os::raw::c_char,
        omode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type pqsigfunc = ::std::option::Option<unsafe extern "C" fn(signo: ::std::os::raw::c_int)>;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pqsignal(signo: ::std::os::raw::c_int, func: pqsigfunc) -> pqsigfunc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn escape_single_quotes_ascii(
        src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn wait_result_to_str(exit_status: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn wait_result_is_signal(
        exit_status: ::std::os::raw::c_int,
        signum: ::std::os::raw::c_int,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn wait_result_is_any_signal(
        exit_status: ::std::os::raw::c_int,
        include_command_not_found: bool,
    ) -> bool;
}
pub type __jmp_buf = [::std::os::raw::c_long; 8usize];
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __jmp_buf_tag {
    pub __jmpbuf: __jmp_buf,
    pub __mask_was_saved: ::std::os::raw::c_int,
    pub __saved_mask: __sigset_t,
}
pub type jmp_buf = [__jmp_buf_tag; 1usize];
pub type sigjmp_buf = [__jmp_buf_tag; 1usize];
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn errcode_for_file_access() -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn errcode_for_socket_access() -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn errmsg_internal(fmt: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn errmsg_plural(
        fmt_singular: *const ::std::os::raw::c_char,
        fmt_plural: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_ulong,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn errdetail_internal(fmt: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn errdetail_log(fmt: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn errdetail_log_plural(
        fmt_singular: *const ::std::os::raw::c_char,
        fmt_plural: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_ulong,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn errdetail_plural(
        fmt_singular: *const ::std::os::raw::c_char,
        fmt_plural: *const ::std::os::raw::c_char,
        n: ::std::os::raw::c_ulong,
        ...
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn set_errcontext_domain(domain: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn errhidestmt(hide_stmt: bool) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn errhidecontext(hide_ctx: bool) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn errbacktrace() -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn errfunction(funcname: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn errposition(cursorpos: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn internalerrposition(cursorpos: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn internalerrquery(query: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn err_generic_string(
        field: ::std::os::raw::c_int,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn geterrcode() -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn geterrposition() -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn getinternalerrposition() -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pre_format_elog_string(
        errnumber: ::std::os::raw::c_int,
        domain: *const ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn format_elog_string(
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ErrorContextCallback {
    pub previous: *mut ErrorContextCallback,
    pub callback: ::std::option::Option<unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void)>,
    pub arg: *mut ::std::os::raw::c_void,
}
impl Default for ErrorContextCallback {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut error_context_stack: *mut ErrorContextCallback;
}
extern "C" {
    pub static mut PG_exception_stack: *mut sigjmp_buf;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ErrorData {
    pub elevel: ::std::os::raw::c_int,
    pub output_to_server: bool,
    pub output_to_client: bool,
    pub show_funcname: bool,
    pub hide_stmt: bool,
    pub hide_ctx: bool,
    pub filename: *const ::std::os::raw::c_char,
    pub lineno: ::std::os::raw::c_int,
    pub funcname: *const ::std::os::raw::c_char,
    pub domain: *const ::std::os::raw::c_char,
    pub context_domain: *const ::std::os::raw::c_char,
    pub sqlerrcode: ::std::os::raw::c_int,
    pub message: *mut ::std::os::raw::c_char,
    pub detail: *mut ::std::os::raw::c_char,
    pub detail_log: *mut ::std::os::raw::c_char,
    pub hint: *mut ::std::os::raw::c_char,
    pub context: *mut ::std::os::raw::c_char,
    pub backtrace: *mut ::std::os::raw::c_char,
    pub message_id: *const ::std::os::raw::c_char,
    pub schema_name: *mut ::std::os::raw::c_char,
    pub table_name: *mut ::std::os::raw::c_char,
    pub column_name: *mut ::std::os::raw::c_char,
    pub datatype_name: *mut ::std::os::raw::c_char,
    pub constraint_name: *mut ::std::os::raw::c_char,
    pub cursorpos: ::std::os::raw::c_int,
    pub internalpos: ::std::os::raw::c_int,
    pub internalquery: *mut ::std::os::raw::c_char,
    pub saved_errno: ::std::os::raw::c_int,
    pub assoc_context: *mut MemoryContextData,
}
impl Default for ErrorData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EmitErrorReport();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CopyErrorData() -> *mut ErrorData;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FreeErrorData(edata: *mut ErrorData);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FlushErrorState();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ReThrowError(edata: *mut ErrorData) -> !;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ThrowErrorData(edata: *mut ErrorData);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetErrorContextStack() -> *mut ::std::os::raw::c_char;
}
pub type emit_log_hook_type = ::std::option::Option<unsafe extern "C" fn(edata: *mut ErrorData)>;
extern "C" {
    pub static mut emit_log_hook: emit_log_hook_type;
}
pub const PGErrorVerbosity_PGERROR_TERSE: PGErrorVerbosity = 0;
pub const PGErrorVerbosity_PGERROR_DEFAULT: PGErrorVerbosity = 1;
pub const PGErrorVerbosity_PGERROR_VERBOSE: PGErrorVerbosity = 2;
pub type PGErrorVerbosity = ::std::os::raw::c_uint;
extern "C" {
    pub static mut Log_error_verbosity: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut Log_line_prefix: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut Log_destination: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut Log_destination_string: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut syslog_sequence_numbers: bool;
}
extern "C" {
    pub static mut syslog_split_messages: bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DebugFileOpen();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn unpack_sql_state(sql_state: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn in_error_recursion_trouble() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn set_syslog_parameters(
        ident: *const ::std::os::raw::c_char,
        facility: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn write_stderr(fmt: *const ::std::os::raw::c_char, ...);
}
pub type MemoryContext = *mut MemoryContextData;
pub type MemoryContextCallbackFunction =
    ::std::option::Option<unsafe extern "C" fn(arg: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoryContextCallback {
    pub func: MemoryContextCallbackFunction,
    pub arg: *mut ::std::os::raw::c_void,
    pub next: *mut MemoryContextCallback,
}
impl Default for MemoryContextCallback {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut CurrentMemoryContext: MemoryContext;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextAlloc(context: MemoryContext, size: Size) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextAllocZero(
        context: MemoryContext,
        size: Size,
    ) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextAllocZeroAligned(
        context: MemoryContext,
        size: Size,
    ) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextAllocExtended(
        context: MemoryContext,
        size: Size,
        flags: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn palloc(size: Size) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn palloc0(size: Size) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn palloc_extended(size: Size, flags: ::std::os::raw::c_int)
        -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn repalloc(
        pointer: *mut ::std::os::raw::c_void,
        size: Size,
    ) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pfree(pointer: *mut ::std::os::raw::c_void);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextAllocHuge(
        context: MemoryContext,
        size: Size,
    ) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn repalloc_huge(
        pointer: *mut ::std::os::raw::c_void,
        size: Size,
    ) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextRegisterResetCallback(
        context: MemoryContext,
        cb: *mut MemoryContextCallback,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextStrdup(
        context: MemoryContext,
        string: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pstrdup(in_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pnstrdup(in_: *const ::std::os::raw::c_char, len: Size) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pchomp(in_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn psprintf(fmt: *const ::std::os::raw::c_char, ...) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct varatt_external {
    pub va_rawsize: int32,
    pub va_extsize: int32,
    pub va_valueid: Oid,
    pub va_toastrelid: Oid,
}
impl Default for varatt_external {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct varatt_indirect {
    pub pointer: *mut varlena,
}
impl Default for varatt_indirect {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct varatt_expanded {
    pub eohptr: *mut ExpandedObjectHeader,
}
impl Default for varatt_expanded {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const vartag_external_VARTAG_INDIRECT: vartag_external = 1;
pub const vartag_external_VARTAG_EXPANDED_RO: vartag_external = 2;
pub const vartag_external_VARTAG_EXPANDED_RW: vartag_external = 3;
pub const vartag_external_VARTAG_ONDISK: vartag_external = 18;
pub type vartag_external = ::std::os::raw::c_uint;
#[repr(C)]
pub struct varattrib_4b {
    pub va_4byte: __BindgenUnionField<varattrib_4b__bindgen_ty_1>,
    pub va_compressed: __BindgenUnionField<varattrib_4b__bindgen_ty_2>,
    pub bindgen_union_field: [u32; 2usize],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_4b__bindgen_ty_1 {
    pub va_header: uint32,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_4b__bindgen_ty_2 {
    pub va_header: uint32,
    pub va_rawsize: uint32,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
impl Default for varattrib_4b {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_1b {
    pub va_header: uint8,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct varattrib_1b_e {
    pub va_header: uint8,
    pub va_tag: uint8,
    pub va_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
pub type AttrNumber = int16;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_attribute {
    pub attrelid: Oid,
    pub attname: NameData,
    pub atttypid: Oid,
    pub attstattarget: int32,
    pub attlen: int16,
    pub attnum: int16,
    pub attndims: int32,
    pub attcacheoff: int32,
    pub atttypmod: int32,
    pub attbyval: bool,
    pub attstorage: ::std::os::raw::c_char,
    pub attalign: ::std::os::raw::c_char,
    pub attnotnull: bool,
    pub atthasdef: bool,
    pub atthasmissing: bool,
    pub attidentity: ::std::os::raw::c_char,
    pub attgenerated: ::std::os::raw::c_char,
    pub attisdropped: bool,
    pub attislocal: bool,
    pub attinhcount: int32,
    pub attcollation: Oid,
}
impl Default for FormData_pg_attribute {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_attribute = *mut FormData_pg_attribute;
pub const NodeTag_T_Invalid: NodeTag = 0;
pub const NodeTag_T_IndexInfo: NodeTag = 1;
pub const NodeTag_T_ExprContext: NodeTag = 2;
pub const NodeTag_T_ProjectionInfo: NodeTag = 3;
pub const NodeTag_T_JunkFilter: NodeTag = 4;
pub const NodeTag_T_OnConflictSetState: NodeTag = 5;
pub const NodeTag_T_ResultRelInfo: NodeTag = 6;
pub const NodeTag_T_EState: NodeTag = 7;
pub const NodeTag_T_TupleTableSlot: NodeTag = 8;
pub const NodeTag_T_Plan: NodeTag = 9;
pub const NodeTag_T_Result: NodeTag = 10;
pub const NodeTag_T_ProjectSet: NodeTag = 11;
pub const NodeTag_T_ModifyTable: NodeTag = 12;
pub const NodeTag_T_Append: NodeTag = 13;
pub const NodeTag_T_MergeAppend: NodeTag = 14;
pub const NodeTag_T_RecursiveUnion: NodeTag = 15;
pub const NodeTag_T_BitmapAnd: NodeTag = 16;
pub const NodeTag_T_BitmapOr: NodeTag = 17;
pub const NodeTag_T_Scan: NodeTag = 18;
pub const NodeTag_T_SeqScan: NodeTag = 19;
pub const NodeTag_T_SampleScan: NodeTag = 20;
pub const NodeTag_T_IndexScan: NodeTag = 21;
pub const NodeTag_T_IndexOnlyScan: NodeTag = 22;
pub const NodeTag_T_BitmapIndexScan: NodeTag = 23;
pub const NodeTag_T_BitmapHeapScan: NodeTag = 24;
pub const NodeTag_T_TidScan: NodeTag = 25;
pub const NodeTag_T_SubqueryScan: NodeTag = 26;
pub const NodeTag_T_FunctionScan: NodeTag = 27;
pub const NodeTag_T_ValuesScan: NodeTag = 28;
pub const NodeTag_T_TableFuncScan: NodeTag = 29;
pub const NodeTag_T_CteScan: NodeTag = 30;
pub const NodeTag_T_NamedTuplestoreScan: NodeTag = 31;
pub const NodeTag_T_WorkTableScan: NodeTag = 32;
pub const NodeTag_T_ForeignScan: NodeTag = 33;
pub const NodeTag_T_CustomScan: NodeTag = 34;
pub const NodeTag_T_Join: NodeTag = 35;
pub const NodeTag_T_NestLoop: NodeTag = 36;
pub const NodeTag_T_MergeJoin: NodeTag = 37;
pub const NodeTag_T_HashJoin: NodeTag = 38;
pub const NodeTag_T_Material: NodeTag = 39;
pub const NodeTag_T_Sort: NodeTag = 40;
pub const NodeTag_T_IncrementalSort: NodeTag = 41;
pub const NodeTag_T_Group: NodeTag = 42;
pub const NodeTag_T_Agg: NodeTag = 43;
pub const NodeTag_T_WindowAgg: NodeTag = 44;
pub const NodeTag_T_Unique: NodeTag = 45;
pub const NodeTag_T_Gather: NodeTag = 46;
pub const NodeTag_T_GatherMerge: NodeTag = 47;
pub const NodeTag_T_Hash: NodeTag = 48;
pub const NodeTag_T_SetOp: NodeTag = 49;
pub const NodeTag_T_LockRows: NodeTag = 50;
pub const NodeTag_T_Limit: NodeTag = 51;
pub const NodeTag_T_NestLoopParam: NodeTag = 52;
pub const NodeTag_T_PlanRowMark: NodeTag = 53;
pub const NodeTag_T_PartitionPruneInfo: NodeTag = 54;
pub const NodeTag_T_PartitionedRelPruneInfo: NodeTag = 55;
pub const NodeTag_T_PartitionPruneStepOp: NodeTag = 56;
pub const NodeTag_T_PartitionPruneStepCombine: NodeTag = 57;
pub const NodeTag_T_PlanInvalItem: NodeTag = 58;
pub const NodeTag_T_PlanState: NodeTag = 59;
pub const NodeTag_T_ResultState: NodeTag = 60;
pub const NodeTag_T_ProjectSetState: NodeTag = 61;
pub const NodeTag_T_ModifyTableState: NodeTag = 62;
pub const NodeTag_T_AppendState: NodeTag = 63;
pub const NodeTag_T_MergeAppendState: NodeTag = 64;
pub const NodeTag_T_RecursiveUnionState: NodeTag = 65;
pub const NodeTag_T_BitmapAndState: NodeTag = 66;
pub const NodeTag_T_BitmapOrState: NodeTag = 67;
pub const NodeTag_T_ScanState: NodeTag = 68;
pub const NodeTag_T_SeqScanState: NodeTag = 69;
pub const NodeTag_T_SampleScanState: NodeTag = 70;
pub const NodeTag_T_IndexScanState: NodeTag = 71;
pub const NodeTag_T_IndexOnlyScanState: NodeTag = 72;
pub const NodeTag_T_BitmapIndexScanState: NodeTag = 73;
pub const NodeTag_T_BitmapHeapScanState: NodeTag = 74;
pub const NodeTag_T_TidScanState: NodeTag = 75;
pub const NodeTag_T_SubqueryScanState: NodeTag = 76;
pub const NodeTag_T_FunctionScanState: NodeTag = 77;
pub const NodeTag_T_TableFuncScanState: NodeTag = 78;
pub const NodeTag_T_ValuesScanState: NodeTag = 79;
pub const NodeTag_T_CteScanState: NodeTag = 80;
pub const NodeTag_T_NamedTuplestoreScanState: NodeTag = 81;
pub const NodeTag_T_WorkTableScanState: NodeTag = 82;
pub const NodeTag_T_ForeignScanState: NodeTag = 83;
pub const NodeTag_T_CustomScanState: NodeTag = 84;
pub const NodeTag_T_JoinState: NodeTag = 85;
pub const NodeTag_T_NestLoopState: NodeTag = 86;
pub const NodeTag_T_MergeJoinState: NodeTag = 87;
pub const NodeTag_T_HashJoinState: NodeTag = 88;
pub const NodeTag_T_MaterialState: NodeTag = 89;
pub const NodeTag_T_SortState: NodeTag = 90;
pub const NodeTag_T_IncrementalSortState: NodeTag = 91;
pub const NodeTag_T_GroupState: NodeTag = 92;
pub const NodeTag_T_AggState: NodeTag = 93;
pub const NodeTag_T_WindowAggState: NodeTag = 94;
pub const NodeTag_T_UniqueState: NodeTag = 95;
pub const NodeTag_T_GatherState: NodeTag = 96;
pub const NodeTag_T_GatherMergeState: NodeTag = 97;
pub const NodeTag_T_HashState: NodeTag = 98;
pub const NodeTag_T_SetOpState: NodeTag = 99;
pub const NodeTag_T_LockRowsState: NodeTag = 100;
pub const NodeTag_T_LimitState: NodeTag = 101;
pub const NodeTag_T_Alias: NodeTag = 102;
pub const NodeTag_T_RangeVar: NodeTag = 103;
pub const NodeTag_T_TableFunc: NodeTag = 104;
pub const NodeTag_T_Expr: NodeTag = 105;
pub const NodeTag_T_Var: NodeTag = 106;
pub const NodeTag_T_Const: NodeTag = 107;
pub const NodeTag_T_Param: NodeTag = 108;
pub const NodeTag_T_Aggref: NodeTag = 109;
pub const NodeTag_T_GroupingFunc: NodeTag = 110;
pub const NodeTag_T_WindowFunc: NodeTag = 111;
pub const NodeTag_T_SubscriptingRef: NodeTag = 112;
pub const NodeTag_T_FuncExpr: NodeTag = 113;
pub const NodeTag_T_NamedArgExpr: NodeTag = 114;
pub const NodeTag_T_OpExpr: NodeTag = 115;
pub const NodeTag_T_DistinctExpr: NodeTag = 116;
pub const NodeTag_T_NullIfExpr: NodeTag = 117;
pub const NodeTag_T_ScalarArrayOpExpr: NodeTag = 118;
pub const NodeTag_T_BoolExpr: NodeTag = 119;
pub const NodeTag_T_SubLink: NodeTag = 120;
pub const NodeTag_T_SubPlan: NodeTag = 121;
pub const NodeTag_T_AlternativeSubPlan: NodeTag = 122;
pub const NodeTag_T_FieldSelect: NodeTag = 123;
pub const NodeTag_T_FieldStore: NodeTag = 124;
pub const NodeTag_T_RelabelType: NodeTag = 125;
pub const NodeTag_T_CoerceViaIO: NodeTag = 126;
pub const NodeTag_T_ArrayCoerceExpr: NodeTag = 127;
pub const NodeTag_T_ConvertRowtypeExpr: NodeTag = 128;
pub const NodeTag_T_CollateExpr: NodeTag = 129;
pub const NodeTag_T_CaseExpr: NodeTag = 130;
pub const NodeTag_T_CaseWhen: NodeTag = 131;
pub const NodeTag_T_CaseTestExpr: NodeTag = 132;
pub const NodeTag_T_ArrayExpr: NodeTag = 133;
pub const NodeTag_T_RowExpr: NodeTag = 134;
pub const NodeTag_T_RowCompareExpr: NodeTag = 135;
pub const NodeTag_T_CoalesceExpr: NodeTag = 136;
pub const NodeTag_T_MinMaxExpr: NodeTag = 137;
pub const NodeTag_T_SQLValueFunction: NodeTag = 138;
pub const NodeTag_T_XmlExpr: NodeTag = 139;
pub const NodeTag_T_NullTest: NodeTag = 140;
pub const NodeTag_T_BooleanTest: NodeTag = 141;
pub const NodeTag_T_CoerceToDomain: NodeTag = 142;
pub const NodeTag_T_CoerceToDomainValue: NodeTag = 143;
pub const NodeTag_T_SetToDefault: NodeTag = 144;
pub const NodeTag_T_CurrentOfExpr: NodeTag = 145;
pub const NodeTag_T_NextValueExpr: NodeTag = 146;
pub const NodeTag_T_InferenceElem: NodeTag = 147;
pub const NodeTag_T_TargetEntry: NodeTag = 148;
pub const NodeTag_T_RangeTblRef: NodeTag = 149;
pub const NodeTag_T_JoinExpr: NodeTag = 150;
pub const NodeTag_T_FromExpr: NodeTag = 151;
pub const NodeTag_T_OnConflictExpr: NodeTag = 152;
pub const NodeTag_T_IntoClause: NodeTag = 153;
pub const NodeTag_T_ExprState: NodeTag = 154;
pub const NodeTag_T_AggrefExprState: NodeTag = 155;
pub const NodeTag_T_WindowFuncExprState: NodeTag = 156;
pub const NodeTag_T_SetExprState: NodeTag = 157;
pub const NodeTag_T_SubPlanState: NodeTag = 158;
pub const NodeTag_T_AlternativeSubPlanState: NodeTag = 159;
pub const NodeTag_T_DomainConstraintState: NodeTag = 160;
pub const NodeTag_T_PlannerInfo: NodeTag = 161;
pub const NodeTag_T_PlannerGlobal: NodeTag = 162;
pub const NodeTag_T_RelOptInfo: NodeTag = 163;
pub const NodeTag_T_IndexOptInfo: NodeTag = 164;
pub const NodeTag_T_ForeignKeyOptInfo: NodeTag = 165;
pub const NodeTag_T_ParamPathInfo: NodeTag = 166;
pub const NodeTag_T_Path: NodeTag = 167;
pub const NodeTag_T_IndexPath: NodeTag = 168;
pub const NodeTag_T_BitmapHeapPath: NodeTag = 169;
pub const NodeTag_T_BitmapAndPath: NodeTag = 170;
pub const NodeTag_T_BitmapOrPath: NodeTag = 171;
pub const NodeTag_T_TidPath: NodeTag = 172;
pub const NodeTag_T_SubqueryScanPath: NodeTag = 173;
pub const NodeTag_T_ForeignPath: NodeTag = 174;
pub const NodeTag_T_CustomPath: NodeTag = 175;
pub const NodeTag_T_NestPath: NodeTag = 176;
pub const NodeTag_T_MergePath: NodeTag = 177;
pub const NodeTag_T_HashPath: NodeTag = 178;
pub const NodeTag_T_AppendPath: NodeTag = 179;
pub const NodeTag_T_MergeAppendPath: NodeTag = 180;
pub const NodeTag_T_GroupResultPath: NodeTag = 181;
pub const NodeTag_T_MaterialPath: NodeTag = 182;
pub const NodeTag_T_UniquePath: NodeTag = 183;
pub const NodeTag_T_GatherPath: NodeTag = 184;
pub const NodeTag_T_GatherMergePath: NodeTag = 185;
pub const NodeTag_T_ProjectionPath: NodeTag = 186;
pub const NodeTag_T_ProjectSetPath: NodeTag = 187;
pub const NodeTag_T_SortPath: NodeTag = 188;
pub const NodeTag_T_IncrementalSortPath: NodeTag = 189;
pub const NodeTag_T_GroupPath: NodeTag = 190;
pub const NodeTag_T_UpperUniquePath: NodeTag = 191;
pub const NodeTag_T_AggPath: NodeTag = 192;
pub const NodeTag_T_GroupingSetsPath: NodeTag = 193;
pub const NodeTag_T_MinMaxAggPath: NodeTag = 194;
pub const NodeTag_T_WindowAggPath: NodeTag = 195;
pub const NodeTag_T_SetOpPath: NodeTag = 196;
pub const NodeTag_T_RecursiveUnionPath: NodeTag = 197;
pub const NodeTag_T_LockRowsPath: NodeTag = 198;
pub const NodeTag_T_ModifyTablePath: NodeTag = 199;
pub const NodeTag_T_LimitPath: NodeTag = 200;
pub const NodeTag_T_EquivalenceClass: NodeTag = 201;
pub const NodeTag_T_EquivalenceMember: NodeTag = 202;
pub const NodeTag_T_PathKey: NodeTag = 203;
pub const NodeTag_T_PathTarget: NodeTag = 204;
pub const NodeTag_T_RestrictInfo: NodeTag = 205;
pub const NodeTag_T_IndexClause: NodeTag = 206;
pub const NodeTag_T_PlaceHolderVar: NodeTag = 207;
pub const NodeTag_T_SpecialJoinInfo: NodeTag = 208;
pub const NodeTag_T_AppendRelInfo: NodeTag = 209;
pub const NodeTag_T_PlaceHolderInfo: NodeTag = 210;
pub const NodeTag_T_MinMaxAggInfo: NodeTag = 211;
pub const NodeTag_T_PlannerParamItem: NodeTag = 212;
pub const NodeTag_T_RollupData: NodeTag = 213;
pub const NodeTag_T_GroupingSetData: NodeTag = 214;
pub const NodeTag_T_StatisticExtInfo: NodeTag = 215;
pub const NodeTag_T_MemoryContext: NodeTag = 216;
pub const NodeTag_T_AllocSetContext: NodeTag = 217;
pub const NodeTag_T_SlabContext: NodeTag = 218;
pub const NodeTag_T_GenerationContext: NodeTag = 219;
pub const NodeTag_T_Value: NodeTag = 220;
pub const NodeTag_T_Integer: NodeTag = 221;
pub const NodeTag_T_Float: NodeTag = 222;
pub const NodeTag_T_String: NodeTag = 223;
pub const NodeTag_T_BitString: NodeTag = 224;
pub const NodeTag_T_Null: NodeTag = 225;
pub const NodeTag_T_List: NodeTag = 226;
pub const NodeTag_T_IntList: NodeTag = 227;
pub const NodeTag_T_OidList: NodeTag = 228;
pub const NodeTag_T_ExtensibleNode: NodeTag = 229;
pub const NodeTag_T_RawStmt: NodeTag = 230;
pub const NodeTag_T_Query: NodeTag = 231;
pub const NodeTag_T_PlannedStmt: NodeTag = 232;
pub const NodeTag_T_InsertStmt: NodeTag = 233;
pub const NodeTag_T_DeleteStmt: NodeTag = 234;
pub const NodeTag_T_UpdateStmt: NodeTag = 235;
pub const NodeTag_T_SelectStmt: NodeTag = 236;
pub const NodeTag_T_AlterTableStmt: NodeTag = 237;
pub const NodeTag_T_AlterTableCmd: NodeTag = 238;
pub const NodeTag_T_AlterDomainStmt: NodeTag = 239;
pub const NodeTag_T_SetOperationStmt: NodeTag = 240;
pub const NodeTag_T_GrantStmt: NodeTag = 241;
pub const NodeTag_T_GrantRoleStmt: NodeTag = 242;
pub const NodeTag_T_AlterDefaultPrivilegesStmt: NodeTag = 243;
pub const NodeTag_T_ClosePortalStmt: NodeTag = 244;
pub const NodeTag_T_ClusterStmt: NodeTag = 245;
pub const NodeTag_T_CopyStmt: NodeTag = 246;
pub const NodeTag_T_CreateStmt: NodeTag = 247;
pub const NodeTag_T_DefineStmt: NodeTag = 248;
pub const NodeTag_T_DropStmt: NodeTag = 249;
pub const NodeTag_T_TruncateStmt: NodeTag = 250;
pub const NodeTag_T_CommentStmt: NodeTag = 251;
pub const NodeTag_T_FetchStmt: NodeTag = 252;
pub const NodeTag_T_IndexStmt: NodeTag = 253;
pub const NodeTag_T_CreateFunctionStmt: NodeTag = 254;
pub const NodeTag_T_AlterFunctionStmt: NodeTag = 255;
pub const NodeTag_T_DoStmt: NodeTag = 256;
pub const NodeTag_T_RenameStmt: NodeTag = 257;
pub const NodeTag_T_RuleStmt: NodeTag = 258;
pub const NodeTag_T_NotifyStmt: NodeTag = 259;
pub const NodeTag_T_ListenStmt: NodeTag = 260;
pub const NodeTag_T_UnlistenStmt: NodeTag = 261;
pub const NodeTag_T_TransactionStmt: NodeTag = 262;
pub const NodeTag_T_ViewStmt: NodeTag = 263;
pub const NodeTag_T_LoadStmt: NodeTag = 264;
pub const NodeTag_T_CreateDomainStmt: NodeTag = 265;
pub const NodeTag_T_CreatedbStmt: NodeTag = 266;
pub const NodeTag_T_DropdbStmt: NodeTag = 267;
pub const NodeTag_T_VacuumStmt: NodeTag = 268;
pub const NodeTag_T_ExplainStmt: NodeTag = 269;
pub const NodeTag_T_CreateTableAsStmt: NodeTag = 270;
pub const NodeTag_T_CreateSeqStmt: NodeTag = 271;
pub const NodeTag_T_AlterSeqStmt: NodeTag = 272;
pub const NodeTag_T_VariableSetStmt: NodeTag = 273;
pub const NodeTag_T_VariableShowStmt: NodeTag = 274;
pub const NodeTag_T_DiscardStmt: NodeTag = 275;
pub const NodeTag_T_CreateTrigStmt: NodeTag = 276;
pub const NodeTag_T_CreatePLangStmt: NodeTag = 277;
pub const NodeTag_T_CreateRoleStmt: NodeTag = 278;
pub const NodeTag_T_AlterRoleStmt: NodeTag = 279;
pub const NodeTag_T_DropRoleStmt: NodeTag = 280;
pub const NodeTag_T_LockStmt: NodeTag = 281;
pub const NodeTag_T_ConstraintsSetStmt: NodeTag = 282;
pub const NodeTag_T_ReindexStmt: NodeTag = 283;
pub const NodeTag_T_CheckPointStmt: NodeTag = 284;
pub const NodeTag_T_CreateSchemaStmt: NodeTag = 285;
pub const NodeTag_T_AlterDatabaseStmt: NodeTag = 286;
pub const NodeTag_T_AlterDatabaseSetStmt: NodeTag = 287;
pub const NodeTag_T_AlterRoleSetStmt: NodeTag = 288;
pub const NodeTag_T_CreateConversionStmt: NodeTag = 289;
pub const NodeTag_T_CreateCastStmt: NodeTag = 290;
pub const NodeTag_T_CreateOpClassStmt: NodeTag = 291;
pub const NodeTag_T_CreateOpFamilyStmt: NodeTag = 292;
pub const NodeTag_T_AlterOpFamilyStmt: NodeTag = 293;
pub const NodeTag_T_PrepareStmt: NodeTag = 294;
pub const NodeTag_T_ExecuteStmt: NodeTag = 295;
pub const NodeTag_T_DeallocateStmt: NodeTag = 296;
pub const NodeTag_T_DeclareCursorStmt: NodeTag = 297;
pub const NodeTag_T_CreateTableSpaceStmt: NodeTag = 298;
pub const NodeTag_T_DropTableSpaceStmt: NodeTag = 299;
pub const NodeTag_T_AlterObjectDependsStmt: NodeTag = 300;
pub const NodeTag_T_AlterObjectSchemaStmt: NodeTag = 301;
pub const NodeTag_T_AlterOwnerStmt: NodeTag = 302;
pub const NodeTag_T_AlterOperatorStmt: NodeTag = 303;
pub const NodeTag_T_AlterTypeStmt: NodeTag = 304;
pub const NodeTag_T_DropOwnedStmt: NodeTag = 305;
pub const NodeTag_T_ReassignOwnedStmt: NodeTag = 306;
pub const NodeTag_T_CompositeTypeStmt: NodeTag = 307;
pub const NodeTag_T_CreateEnumStmt: NodeTag = 308;
pub const NodeTag_T_CreateRangeStmt: NodeTag = 309;
pub const NodeTag_T_AlterEnumStmt: NodeTag = 310;
pub const NodeTag_T_AlterTSDictionaryStmt: NodeTag = 311;
pub const NodeTag_T_AlterTSConfigurationStmt: NodeTag = 312;
pub const NodeTag_T_CreateFdwStmt: NodeTag = 313;
pub const NodeTag_T_AlterFdwStmt: NodeTag = 314;
pub const NodeTag_T_CreateForeignServerStmt: NodeTag = 315;
pub const NodeTag_T_AlterForeignServerStmt: NodeTag = 316;
pub const NodeTag_T_CreateUserMappingStmt: NodeTag = 317;
pub const NodeTag_T_AlterUserMappingStmt: NodeTag = 318;
pub const NodeTag_T_DropUserMappingStmt: NodeTag = 319;
pub const NodeTag_T_AlterTableSpaceOptionsStmt: NodeTag = 320;
pub const NodeTag_T_AlterTableMoveAllStmt: NodeTag = 321;
pub const NodeTag_T_SecLabelStmt: NodeTag = 322;
pub const NodeTag_T_CreateForeignTableStmt: NodeTag = 323;
pub const NodeTag_T_ImportForeignSchemaStmt: NodeTag = 324;
pub const NodeTag_T_CreateExtensionStmt: NodeTag = 325;
pub const NodeTag_T_AlterExtensionStmt: NodeTag = 326;
pub const NodeTag_T_AlterExtensionContentsStmt: NodeTag = 327;
pub const NodeTag_T_CreateEventTrigStmt: NodeTag = 328;
pub const NodeTag_T_AlterEventTrigStmt: NodeTag = 329;
pub const NodeTag_T_RefreshMatViewStmt: NodeTag = 330;
pub const NodeTag_T_ReplicaIdentityStmt: NodeTag = 331;
pub const NodeTag_T_AlterSystemStmt: NodeTag = 332;
pub const NodeTag_T_CreatePolicyStmt: NodeTag = 333;
pub const NodeTag_T_AlterPolicyStmt: NodeTag = 334;
pub const NodeTag_T_CreateTransformStmt: NodeTag = 335;
pub const NodeTag_T_CreateAmStmt: NodeTag = 336;
pub const NodeTag_T_CreatePublicationStmt: NodeTag = 337;
pub const NodeTag_T_AlterPublicationStmt: NodeTag = 338;
pub const NodeTag_T_CreateSubscriptionStmt: NodeTag = 339;
pub const NodeTag_T_AlterSubscriptionStmt: NodeTag = 340;
pub const NodeTag_T_DropSubscriptionStmt: NodeTag = 341;
pub const NodeTag_T_CreateStatsStmt: NodeTag = 342;
pub const NodeTag_T_AlterCollationStmt: NodeTag = 343;
pub const NodeTag_T_CallStmt: NodeTag = 344;
pub const NodeTag_T_AlterStatsStmt: NodeTag = 345;
pub const NodeTag_T_A_Expr: NodeTag = 346;
pub const NodeTag_T_ColumnRef: NodeTag = 347;
pub const NodeTag_T_ParamRef: NodeTag = 348;
pub const NodeTag_T_A_Const: NodeTag = 349;
pub const NodeTag_T_FuncCall: NodeTag = 350;
pub const NodeTag_T_A_Star: NodeTag = 351;
pub const NodeTag_T_A_Indices: NodeTag = 352;
pub const NodeTag_T_A_Indirection: NodeTag = 353;
pub const NodeTag_T_A_ArrayExpr: NodeTag = 354;
pub const NodeTag_T_ResTarget: NodeTag = 355;
pub const NodeTag_T_MultiAssignRef: NodeTag = 356;
pub const NodeTag_T_TypeCast: NodeTag = 357;
pub const NodeTag_T_CollateClause: NodeTag = 358;
pub const NodeTag_T_SortBy: NodeTag = 359;
pub const NodeTag_T_WindowDef: NodeTag = 360;
pub const NodeTag_T_RangeSubselect: NodeTag = 361;
pub const NodeTag_T_RangeFunction: NodeTag = 362;
pub const NodeTag_T_RangeTableSample: NodeTag = 363;
pub const NodeTag_T_RangeTableFunc: NodeTag = 364;
pub const NodeTag_T_RangeTableFuncCol: NodeTag = 365;
pub const NodeTag_T_TypeName: NodeTag = 366;
pub const NodeTag_T_ColumnDef: NodeTag = 367;
pub const NodeTag_T_IndexElem: NodeTag = 368;
pub const NodeTag_T_Constraint: NodeTag = 369;
pub const NodeTag_T_DefElem: NodeTag = 370;
pub const NodeTag_T_RangeTblEntry: NodeTag = 371;
pub const NodeTag_T_RangeTblFunction: NodeTag = 372;
pub const NodeTag_T_TableSampleClause: NodeTag = 373;
pub const NodeTag_T_WithCheckOption: NodeTag = 374;
pub const NodeTag_T_SortGroupClause: NodeTag = 375;
pub const NodeTag_T_GroupingSet: NodeTag = 376;
pub const NodeTag_T_WindowClause: NodeTag = 377;
pub const NodeTag_T_ObjectWithArgs: NodeTag = 378;
pub const NodeTag_T_AccessPriv: NodeTag = 379;
pub const NodeTag_T_CreateOpClassItem: NodeTag = 380;
pub const NodeTag_T_TableLikeClause: NodeTag = 381;
pub const NodeTag_T_FunctionParameter: NodeTag = 382;
pub const NodeTag_T_LockingClause: NodeTag = 383;
pub const NodeTag_T_RowMarkClause: NodeTag = 384;
pub const NodeTag_T_XmlSerialize: NodeTag = 385;
pub const NodeTag_T_WithClause: NodeTag = 386;
pub const NodeTag_T_InferClause: NodeTag = 387;
pub const NodeTag_T_OnConflictClause: NodeTag = 388;
pub const NodeTag_T_CommonTableExpr: NodeTag = 389;
pub const NodeTag_T_RoleSpec: NodeTag = 390;
pub const NodeTag_T_TriggerTransition: NodeTag = 391;
pub const NodeTag_T_PartitionElem: NodeTag = 392;
pub const NodeTag_T_PartitionSpec: NodeTag = 393;
pub const NodeTag_T_PartitionBoundSpec: NodeTag = 394;
pub const NodeTag_T_PartitionRangeDatum: NodeTag = 395;
pub const NodeTag_T_PartitionCmd: NodeTag = 396;
pub const NodeTag_T_VacuumRelation: NodeTag = 397;
pub const NodeTag_T_IdentifySystemCmd: NodeTag = 398;
pub const NodeTag_T_BaseBackupCmd: NodeTag = 399;
pub const NodeTag_T_CreateReplicationSlotCmd: NodeTag = 400;
pub const NodeTag_T_DropReplicationSlotCmd: NodeTag = 401;
pub const NodeTag_T_StartReplicationCmd: NodeTag = 402;
pub const NodeTag_T_TimeLineHistoryCmd: NodeTag = 403;
pub const NodeTag_T_SQLCmd: NodeTag = 404;
pub const NodeTag_T_TriggerData: NodeTag = 405;
pub const NodeTag_T_EventTriggerData: NodeTag = 406;
pub const NodeTag_T_ReturnSetInfo: NodeTag = 407;
pub const NodeTag_T_WindowObjectData: NodeTag = 408;
pub const NodeTag_T_TIDBitmap: NodeTag = 409;
pub const NodeTag_T_InlineCodeBlock: NodeTag = 410;
pub const NodeTag_T_FdwRoutine: NodeTag = 411;
pub const NodeTag_T_IndexAmRoutine: NodeTag = 412;
pub const NodeTag_T_TableAmRoutine: NodeTag = 413;
pub const NodeTag_T_TsmRoutine: NodeTag = 414;
pub const NodeTag_T_ForeignKeyCacheInfo: NodeTag = 415;
pub const NodeTag_T_CallContext: NodeTag = 416;
pub const NodeTag_T_SupportRequestSimplify: NodeTag = 417;
pub const NodeTag_T_SupportRequestSelectivity: NodeTag = 418;
pub const NodeTag_T_SupportRequestCost: NodeTag = 419;
pub const NodeTag_T_SupportRequestRows: NodeTag = 420;
pub const NodeTag_T_SupportRequestIndexCondition: NodeTag = 421;
pub type NodeTag = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Node {
    pub type_: NodeTag,
}
impl Default for Node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn outNode(str_: *mut StringInfoData, obj: *const ::std::os::raw::c_void);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn outToken(str_: *mut StringInfoData, s: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn outBitmapset(str_: *mut StringInfoData, bms: *const Bitmapset);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn outDatum(
        str_: *mut StringInfoData,
        value: usize,
        typlen: ::std::os::raw::c_int,
        typbyval: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn nodeToString(obj: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bmsToString(bms: *const Bitmapset) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn stringToNode(str_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn readBitmapset() -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn readDatum(typbyval: bool) -> usize;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn readBoolCols(numCols: ::std::os::raw::c_int) -> *mut bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn readIntCols(numCols: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn readOidCols(numCols: ::std::os::raw::c_int) -> *mut Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn readAttrNumberCols(numCols: ::std::os::raw::c_int) -> *mut int16;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn copyObjectImpl(obj: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn equal(a: *const ::std::os::raw::c_void, b: *const ::std::os::raw::c_void) -> bool;
}
pub type Selectivity = f64;
pub type Cost = f64;
pub const CmdType_CMD_UNKNOWN: CmdType = 0;
pub const CmdType_CMD_SELECT: CmdType = 1;
pub const CmdType_CMD_UPDATE: CmdType = 2;
pub const CmdType_CMD_INSERT: CmdType = 3;
pub const CmdType_CMD_DELETE: CmdType = 4;
pub const CmdType_CMD_UTILITY: CmdType = 5;
pub const CmdType_CMD_NOTHING: CmdType = 6;
pub type CmdType = ::std::os::raw::c_uint;
pub const JoinType_JOIN_INNER: JoinType = 0;
pub const JoinType_JOIN_LEFT: JoinType = 1;
pub const JoinType_JOIN_FULL: JoinType = 2;
pub const JoinType_JOIN_RIGHT: JoinType = 3;
pub const JoinType_JOIN_SEMI: JoinType = 4;
pub const JoinType_JOIN_ANTI: JoinType = 5;
pub const JoinType_JOIN_UNIQUE_OUTER: JoinType = 6;
pub const JoinType_JOIN_UNIQUE_INNER: JoinType = 7;
pub type JoinType = ::std::os::raw::c_uint;
pub const AggStrategy_AGG_PLAIN: AggStrategy = 0;
pub const AggStrategy_AGG_SORTED: AggStrategy = 1;
pub const AggStrategy_AGG_HASHED: AggStrategy = 2;
pub const AggStrategy_AGG_MIXED: AggStrategy = 3;
pub type AggStrategy = ::std::os::raw::c_uint;
pub const AggSplit_AGGSPLIT_SIMPLE: AggSplit = 0;
pub const AggSplit_AGGSPLIT_INITIAL_SERIAL: AggSplit = 6;
pub const AggSplit_AGGSPLIT_FINAL_DESERIAL: AggSplit = 9;
pub type AggSplit = ::std::os::raw::c_uint;
pub const SetOpCmd_SETOPCMD_INTERSECT: SetOpCmd = 0;
pub const SetOpCmd_SETOPCMD_INTERSECT_ALL: SetOpCmd = 1;
pub const SetOpCmd_SETOPCMD_EXCEPT: SetOpCmd = 2;
pub const SetOpCmd_SETOPCMD_EXCEPT_ALL: SetOpCmd = 3;
pub type SetOpCmd = ::std::os::raw::c_uint;
pub const SetOpStrategy_SETOP_SORTED: SetOpStrategy = 0;
pub const SetOpStrategy_SETOP_HASHED: SetOpStrategy = 1;
pub type SetOpStrategy = ::std::os::raw::c_uint;
pub const OnConflictAction_ONCONFLICT_NONE: OnConflictAction = 0;
pub const OnConflictAction_ONCONFLICT_NOTHING: OnConflictAction = 1;
pub const OnConflictAction_ONCONFLICT_UPDATE: OnConflictAction = 2;
pub type OnConflictAction = ::std::os::raw::c_uint;
pub const LimitOption_LIMIT_OPTION_COUNT: LimitOption = 0;
pub const LimitOption_LIMIT_OPTION_WITH_TIES: LimitOption = 1;
pub const LimitOption_LIMIT_OPTION_DEFAULT: LimitOption = 2;
pub type LimitOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub union ListCell {
    pub ptr_value: *mut ::std::os::raw::c_void,
    pub int_value: ::std::os::raw::c_int,
    pub oid_value: Oid,
}
impl Default for ListCell {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct List {
    pub type_: NodeTag,
    pub length: ::std::os::raw::c_int,
    pub max_length: ::std::os::raw::c_int,
    pub elements: *mut ListCell,
    pub initial_elements: __IncompleteArrayField<ListCell>,
}
impl Default for List {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForEachState {
    pub l: *const List,
    pub i: ::std::os::raw::c_int,
}
impl Default for ForEachState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForBothState {
    pub l1: *const List,
    pub l2: *const List,
    pub i: ::std::os::raw::c_int,
}
impl Default for ForBothState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForBothCellState {
    pub l1: *const List,
    pub l2: *const List,
    pub i1: ::std::os::raw::c_int,
    pub i2: ::std::os::raw::c_int,
}
impl Default for ForBothCellState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForThreeState {
    pub l1: *const List,
    pub l2: *const List,
    pub l3: *const List,
    pub i: ::std::os::raw::c_int,
}
impl Default for ForThreeState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForFourState {
    pub l1: *const List,
    pub l2: *const List,
    pub l3: *const List,
    pub l4: *const List,
    pub i: ::std::os::raw::c_int,
}
impl Default for ForFourState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForFiveState {
    pub l1: *const List,
    pub l2: *const List,
    pub l3: *const List,
    pub l4: *const List,
    pub l5: *const List,
    pub i: ::std::os::raw::c_int,
}
impl Default for ForFiveState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_make1_impl(t: NodeTag, datum1: ListCell) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_make2_impl(t: NodeTag, datum1: ListCell, datum2: ListCell) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_make3_impl(
        t: NodeTag,
        datum1: ListCell,
        datum2: ListCell,
        datum3: ListCell,
    ) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_make4_impl(
        t: NodeTag,
        datum1: ListCell,
        datum2: ListCell,
        datum3: ListCell,
        datum4: ListCell,
    ) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn lappend(list: *mut List, datum: *mut ::std::os::raw::c_void) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn lappend_int(list: *mut List, datum: ::std::os::raw::c_int) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn lappend_oid(list: *mut List, datum: Oid) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_insert_nth(
        list: *mut List,
        pos: ::std::os::raw::c_int,
        datum: *mut ::std::os::raw::c_void,
    ) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_insert_nth_int(
        list: *mut List,
        pos: ::std::os::raw::c_int,
        datum: ::std::os::raw::c_int,
    ) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_insert_nth_oid(
        list: *mut List,
        pos: ::std::os::raw::c_int,
        datum: Oid,
    ) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn lcons(datum: *mut ::std::os::raw::c_void, list: *mut List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn lcons_int(datum: ::std::os::raw::c_int, list: *mut List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn lcons_oid(datum: Oid, list: *mut List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_concat(list1: *mut List, list2: *const List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_concat_copy(list1: *const List, list2: *const List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_truncate(list: *mut List, new_size: ::std::os::raw::c_int) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_member(list: *const List, datum: *const ::std::os::raw::c_void) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_member_ptr(list: *const List, datum: *const ::std::os::raw::c_void) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_member_int(list: *const List, datum: ::std::os::raw::c_int) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_member_oid(list: *const List, datum: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_delete(list: *mut List, datum: *mut ::std::os::raw::c_void) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_delete_ptr(list: *mut List, datum: *mut ::std::os::raw::c_void) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_delete_int(list: *mut List, datum: ::std::os::raw::c_int) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_delete_oid(list: *mut List, datum: Oid) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_delete_first(list: *mut List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_delete_last(list: *mut List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_delete_first_n(list: *mut List, n: ::std::os::raw::c_int) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_delete_nth_cell(list: *mut List, n: ::std::os::raw::c_int) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_delete_cell(list: *mut List, cell: *mut ListCell) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_union(list1: *const List, list2: *const List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_union_ptr(list1: *const List, list2: *const List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_union_int(list1: *const List, list2: *const List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_union_oid(list1: *const List, list2: *const List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_intersection(list1: *const List, list2: *const List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_intersection_int(list1: *const List, list2: *const List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_difference(list1: *const List, list2: *const List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_difference_ptr(list1: *const List, list2: *const List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_difference_int(list1: *const List, list2: *const List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_difference_oid(list1: *const List, list2: *const List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_append_unique(list: *mut List, datum: *mut ::std::os::raw::c_void) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_append_unique_ptr(list: *mut List, datum: *mut ::std::os::raw::c_void)
        -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_append_unique_int(list: *mut List, datum: ::std::os::raw::c_int) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_append_unique_oid(list: *mut List, datum: Oid) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_concat_unique(list1: *mut List, list2: *const List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_concat_unique_ptr(list1: *mut List, list2: *const List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_concat_unique_int(list1: *mut List, list2: *const List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_concat_unique_oid(list1: *mut List, list2: *const List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_deduplicate_oid(list: *mut List);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_free(list: *mut List);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_free_deep(list: *mut List);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_copy(list: *const List) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_copy_tail(list: *const List, nskip: ::std::os::raw::c_int) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_copy_deep(oldlist: *const List) -> *mut List;
}
pub type list_sort_comparator = ::std::option::Option<
    unsafe extern "C" fn(a: *const ListCell, b: *const ListCell) -> ::std::os::raw::c_int,
>;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_sort(list: *mut List, cmp: list_sort_comparator);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn list_oid_cmp(p1: *const ListCell, p2: *const ListCell) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AttrDefault {
    pub adnum: AttrNumber,
    pub adbin: *mut ::std::os::raw::c_char,
}
impl Default for AttrDefault {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ConstrCheck {
    pub ccname: *mut ::std::os::raw::c_char,
    pub ccbin: *mut ::std::os::raw::c_char,
    pub ccvalid: bool,
    pub ccnoinherit: bool,
}
impl Default for ConstrCheck {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleConstr {
    pub defval: *mut AttrDefault,
    pub check: *mut ConstrCheck,
    pub missing: *mut AttrMissing,
    pub num_defval: uint16,
    pub num_check: uint16,
    pub has_not_null: bool,
    pub has_generated_stored: bool,
}
impl Default for TupleConstr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct TupleDescData {
    pub natts: ::std::os::raw::c_int,
    pub tdtypeid: Oid,
    pub tdtypmod: int32,
    pub tdrefcount: ::std::os::raw::c_int,
    pub constr: *mut TupleConstr,
    pub attrs: __IncompleteArrayField<FormData_pg_attribute>,
}
impl Default for TupleDescData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleDesc = *mut TupleDescData;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CreateTemplateTupleDesc(natts: ::std::os::raw::c_int) -> TupleDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CreateTupleDesc(
        natts: ::std::os::raw::c_int,
        attrs: *mut Form_pg_attribute,
    ) -> TupleDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CreateTupleDescCopy(tupdesc: TupleDesc) -> TupleDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CreateTupleDescCopyConstr(tupdesc: TupleDesc) -> TupleDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TupleDescCopy(dst: TupleDesc, src: TupleDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TupleDescCopyEntry(
        dst: TupleDesc,
        dstAttno: AttrNumber,
        src: TupleDesc,
        srcAttno: AttrNumber,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FreeTupleDesc(tupdesc: TupleDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn IncrTupleDescRefCount(tupdesc: TupleDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DecrTupleDescRefCount(tupdesc: TupleDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn equalTupleDescs(tupdesc1: TupleDesc, tupdesc2: TupleDesc) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn hashTupleDesc(tupdesc: TupleDesc) -> uint32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TupleDescInitEntry(
        desc: TupleDesc,
        attributeNumber: AttrNumber,
        attributeName: *const ::std::os::raw::c_char,
        oidtypeid: Oid,
        typmod: int32,
        attdim: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TupleDescInitBuiltinEntry(
        desc: TupleDesc,
        attributeNumber: AttrNumber,
        attributeName: *const ::std::os::raw::c_char,
        oidtypeid: Oid,
        typmod: int32,
        attdim: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TupleDescInitEntryCollation(
        desc: TupleDesc,
        attributeNumber: AttrNumber,
        collationid: Oid,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BuildDescForRelation(schema: *mut List) -> TupleDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BuildDescFromLists(
        names: *mut List,
        types: *mut List,
        typmods: *mut List,
        collations: *mut List,
    ) -> TupleDesc;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AttrMap {
    pub attnums: *mut AttrNumber,
    pub maplen: ::std::os::raw::c_int,
}
impl Default for AttrMap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn make_attrmap(maplen: ::std::os::raw::c_int) -> *mut AttrMap;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn free_attrmap(map: *mut AttrMap);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn build_attrmap_by_name(indesc: TupleDesc, outdesc: TupleDesc) -> *mut AttrMap;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn build_attrmap_by_name_if_req(indesc: TupleDesc, outdesc: TupleDesc) -> *mut AttrMap;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn build_attrmap_by_position(
        indesc: TupleDesc,
        outdesc: TupleDesc,
        msg: *const ::std::os::raw::c_char,
    ) -> *mut AttrMap;
}
pub type BlockNumber = uint32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BlockIdData {
    pub bi_hi: uint16,
    pub bi_lo: uint16,
}
pub type BlockId = *mut BlockIdData;
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct ItemIdData {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl ItemIdData {
    #[inline]
    pub fn lp_off(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 15u8) as u32) }
    }
    #[inline]
    pub fn set_lp_off(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub fn lp_flags(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_lp_flags(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn lp_len(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 15u8) as u32) }
    }
    #[inline]
    pub fn set_lp_len(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        lp_off: ::std::os::raw::c_uint,
        lp_flags: ::std::os::raw::c_uint,
        lp_len: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 15u8, {
            let lp_off: u32 = unsafe { ::std::mem::transmute(lp_off) };
            lp_off as u64
        });
        __bindgen_bitfield_unit.set(15usize, 2u8, {
            let lp_flags: u32 = unsafe { ::std::mem::transmute(lp_flags) };
            lp_flags as u64
        });
        __bindgen_bitfield_unit.set(17usize, 15u8, {
            let lp_len: u32 = unsafe { ::std::mem::transmute(lp_len) };
            lp_len as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type ItemId = *mut ItemIdData;
pub type ItemOffset = uint16;
pub type ItemLength = uint16;
pub type OffsetNumber = uint16;
#[repr(C, packed(2))]
#[derive(Debug, Default, Copy, Clone)]
pub struct ItemPointerData {
    pub ip_blkid: BlockIdData,
    pub ip_posid: OffsetNumber,
}
pub type ItemPointer = *mut ItemPointerData;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ItemPointerEquals(pointer1: ItemPointer, pointer2: ItemPointer) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ItemPointerCompare(arg1: ItemPointer, arg2: ItemPointer) -> int32;
}
pub type HeapTupleHeader = *mut HeapTupleHeaderData;
pub type MinimalTuple = *mut MinimalTupleData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HeapTupleData {
    pub t_len: uint32,
    pub t_self: ItemPointerData,
    pub t_tableOid: Oid,
    pub t_data: HeapTupleHeader,
}
impl Default for HeapTupleData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type HeapTuple = *mut HeapTupleData;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn HeapTupleHeaderGetCmin(tup: HeapTupleHeader) -> CommandId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn HeapTupleHeaderGetCmax(tup: HeapTupleHeader) -> CommandId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn HeapTupleHeaderAdjustCmax(
        tup: HeapTupleHeader,
        cmax: *mut CommandId,
        iscombo: *mut bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn HeapTupleGetUpdateXid(tuple: HeapTupleHeader) -> TransactionId;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct flock {
    pub l_type: ::std::os::raw::c_short,
    pub l_whence: ::std::os::raw::c_short,
    pub l_start: __off_t,
    pub l_len: __off_t,
    pub l_pid: __pid_t,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct stat {
    pub st_dev: __dev_t,
    pub st_ino: __ino_t,
    pub st_nlink: __nlink_t,
    pub st_mode: __mode_t,
    pub st_uid: __uid_t,
    pub st_gid: __gid_t,
    pub __pad0: ::std::os::raw::c_int,
    pub st_rdev: __dev_t,
    pub st_size: __off_t,
    pub st_blksize: __blksize_t,
    pub st_blocks: __blkcnt_t,
    pub st_atim: timespec,
    pub st_mtim: timespec,
    pub st_ctim: timespec,
    pub __glibc_reserved: [__syscall_slong_t; 3usize],
}
pub type XLogRecPtr = uint64;
pub type XLogSegNo = uint64;
pub type TimeLineID = uint32;
pub type RepOriginId = uint16;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct FullTransactionId {
    pub value: uint64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VariableCacheData {
    pub nextOid: Oid,
    pub oidCount: uint32,
    pub nextFullXid: FullTransactionId,
    pub oldestXid: TransactionId,
    pub xidVacLimit: TransactionId,
    pub xidWarnLimit: TransactionId,
    pub xidStopLimit: TransactionId,
    pub xidWrapLimit: TransactionId,
    pub oldestXidDB: Oid,
    pub oldestCommitTsXid: TransactionId,
    pub newestCommitTsXid: TransactionId,
    pub latestCompletedXid: TransactionId,
    pub oldestClogXid: TransactionId,
}
impl Default for VariableCacheData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type VariableCache = *mut VariableCacheData;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TransactionStartedDuringRecovery() -> bool;
}
extern "C" {
    pub static mut ShmemVariableCache: VariableCache;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TransactionIdDidCommit(transactionId: TransactionId) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TransactionIdDidAbort(transactionId: TransactionId) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TransactionIdIsKnownCompleted(transactionId: TransactionId) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TransactionIdCommitTree(
        xid: TransactionId,
        nxids: ::std::os::raw::c_int,
        xids: *mut TransactionId,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TransactionIdAsyncCommitTree(
        xid: TransactionId,
        nxids: ::std::os::raw::c_int,
        xids: *mut TransactionId,
        lsn: XLogRecPtr,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TransactionIdAbortTree(
        xid: TransactionId,
        nxids: ::std::os::raw::c_int,
        xids: *mut TransactionId,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TransactionIdPrecedes(id1: TransactionId, id2: TransactionId) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TransactionIdPrecedesOrEquals(id1: TransactionId, id2: TransactionId) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TransactionIdFollows(id1: TransactionId, id2: TransactionId) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TransactionIdFollowsOrEquals(id1: TransactionId, id2: TransactionId) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TransactionIdLatest(
        mainxid: TransactionId,
        nxids: ::std::os::raw::c_int,
        xids: *const TransactionId,
    ) -> TransactionId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TransactionIdGetCommitLSN(xid: TransactionId) -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetNewTransactionId(isSubXact: bool) -> FullTransactionId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AdvanceNextFullTransactionIdPastXid(xid: TransactionId);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ReadNextFullTransactionId() -> FullTransactionId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SetTransactionIdLimit(oldest_datfrozenxid: TransactionId, oldest_datoid: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AdvanceOldestClogXid(oldest_datfrozenxid: TransactionId);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ForceTransactionIdLimitUpdate() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetNewObjectId() -> Oid;
}
pub type Item = Pointer;
pub type Page = Pointer;
pub type LocationIndex = uint16;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PageXLogRecPtr {
    pub xlogid: uint32,
    pub xrecoff: uint32,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct PageHeaderData {
    pub pd_lsn: PageXLogRecPtr,
    pub pd_checksum: uint16,
    pub pd_flags: uint16,
    pub pd_lower: LocationIndex,
    pub pd_upper: LocationIndex,
    pub pd_special: LocationIndex,
    pub pd_pagesize_version: uint16,
    pub pd_prune_xid: TransactionId,
    pub pd_linp: __IncompleteArrayField<ItemIdData>,
}
pub type PageHeader = *mut PageHeaderData;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageInit(page: Page, pageSize: Size, specialSize: Size);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageIsVerified(page: Page, blkno: BlockNumber) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageIsVerifiedExtended(
        page: Page,
        blkno: BlockNumber,
        flags: ::std::os::raw::c_int,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageAddItemExtended(
        page: Page,
        item: Item,
        size: Size,
        offsetNumber: OffsetNumber,
        flags: ::std::os::raw::c_int,
    ) -> OffsetNumber;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageGetTempPage(page: Page) -> Page;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageGetTempPageCopy(page: Page) -> Page;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageGetTempPageCopySpecial(page: Page) -> Page;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageRestoreTempPage(tempPage: Page, oldPage: Page);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageRepairFragmentation(page: Page);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageGetFreeSpace(page: Page) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageGetFreeSpaceForMultipleTuples(page: Page, ntups: ::std::os::raw::c_int) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageGetExactFreeSpace(page: Page) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageGetHeapFreeSpace(page: Page) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageIndexTupleDelete(page: Page, offset: OffsetNumber);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageIndexMultiDelete(
        page: Page,
        itemnos: *mut OffsetNumber,
        nitems: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageIndexTupleDeleteNoCompact(page: Page, offset: OffsetNumber);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageIndexTupleOverwrite(
        page: Page,
        offnum: OffsetNumber,
        newtup: Item,
        newsize: Size,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageSetChecksumCopy(page: Page, blkno: BlockNumber) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PageSetChecksumInplace(page: Page, blkno: BlockNumber);
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct HeapTupleFields {
    pub t_xmin: TransactionId,
    pub t_xmax: TransactionId,
    pub t_field3: HeapTupleFields__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union HeapTupleFields__bindgen_ty_1 {
    pub t_cid: CommandId,
    pub t_xvac: TransactionId,
}
impl Default for HeapTupleFields__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for HeapTupleFields {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DatumTupleFields {
    pub datum_len_: int32,
    pub datum_typmod: int32,
    pub datum_typeid: Oid,
}
impl Default for DatumTupleFields {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct HeapTupleHeaderData {
    pub t_choice: HeapTupleHeaderData__bindgen_ty_1,
    pub t_ctid: ItemPointerData,
    pub t_infomask2: uint16,
    pub t_infomask: uint16,
    pub t_hoff: uint8,
    pub t_bits: __IncompleteArrayField<bits8>,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union HeapTupleHeaderData__bindgen_ty_1 {
    pub t_heap: HeapTupleFields,
    pub t_datum: DatumTupleFields,
}
impl Default for HeapTupleHeaderData__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for HeapTupleHeaderData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct MinimalTupleData {
    pub t_len: uint32,
    pub mt_padding: [::std::os::raw::c_char; 6usize],
    pub t_infomask2: uint16,
    pub t_infomask: uint16,
    pub t_hoff: uint8,
    pub t_bits: __IncompleteArrayField<bits8>,
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_compute_data_size(
        tupleDesc: TupleDesc,
        values: *mut Datum,
        isnull: *mut bool,
    ) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_fill_tuple(
        tupleDesc: TupleDesc,
        values: *mut Datum,
        isnull: *mut bool,
        data: *mut ::std::os::raw::c_char,
        data_size: Size,
        infomask: *mut uint16,
        bit: *mut bits8,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_attisnull(
        tup: HeapTuple,
        attnum: ::std::os::raw::c_int,
        tupleDesc: TupleDesc,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn nocachegetattr(tup: HeapTuple, attnum: ::std::os::raw::c_int, att: TupleDesc) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_getsysattr(
        tup: HeapTuple,
        attnum: ::std::os::raw::c_int,
        tupleDesc: TupleDesc,
        isnull: *mut bool,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn getmissingattr(
        tupleDesc: TupleDesc,
        attnum: ::std::os::raw::c_int,
        isnull: *mut bool,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_copytuple(tuple: HeapTuple) -> HeapTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_copytuple_with_tuple(src: HeapTuple, dest: HeapTuple);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_copy_tuple_as_datum(tuple: HeapTuple, tupleDesc: TupleDesc) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_form_tuple(
        tupleDescriptor: TupleDesc,
        values: *mut Datum,
        isnull: *mut bool,
    ) -> HeapTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_modify_tuple(
        tuple: HeapTuple,
        tupleDesc: TupleDesc,
        replValues: *mut Datum,
        replIsnull: *mut bool,
        doReplace: *mut bool,
    ) -> HeapTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_modify_tuple_by_cols(
        tuple: HeapTuple,
        tupleDesc: TupleDesc,
        nCols: ::std::os::raw::c_int,
        replCols: *mut ::std::os::raw::c_int,
        replValues: *mut Datum,
        replIsnull: *mut bool,
    ) -> HeapTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_deform_tuple(
        tuple: HeapTuple,
        tupleDesc: TupleDesc,
        values: *mut Datum,
        isnull: *mut bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_freetuple(htup: HeapTuple);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_form_minimal_tuple(
        tupleDescriptor: TupleDesc,
        values: *mut Datum,
        isnull: *mut bool,
    ) -> MinimalTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_free_minimal_tuple(mtup: MinimalTuple);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_copy_minimal_tuple(mtup: MinimalTuple) -> MinimalTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_tuple_from_minimal_tuple(mtup: MinimalTuple) -> HeapTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn minimal_tuple_from_heap_tuple(htup: HeapTuple) -> MinimalTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_expand_tuple(sourceTuple: HeapTuple, tupleDesc: TupleDesc) -> HeapTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn minimal_expand_tuple(sourceTuple: HeapTuple, tupleDesc: TupleDesc) -> MinimalTuple;
}
pub type Buffer = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BufferAccessStrategyData {
    _unused: [u8; 0],
}
pub type BufferAccessStrategy = *mut BufferAccessStrategyData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleTableSlot {
    pub type_: NodeTag,
    pub tts_flags: uint16,
    pub tts_nvalid: AttrNumber,
    pub tts_ops: *const TupleTableSlotOps,
    pub tts_tupleDescriptor: TupleDesc,
    pub tts_values: *mut Datum,
    pub tts_isnull: *mut bool,
    pub tts_mcxt: MemoryContext,
    pub tts_tid: ItemPointerData,
    pub tts_tableOid: Oid,
}
impl Default for TupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TupleTableSlotOps {
    pub base_slot_size: usize,
    pub init: ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot)>,
    pub release: ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot)>,
    pub clear: ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot)>,
    pub getsomeattrs: ::std::option::Option<
        unsafe extern "C" fn(slot: *mut TupleTableSlot, natts: ::std::os::raw::c_int),
    >,
    pub getsysattr: ::std::option::Option<
        unsafe extern "C" fn(
            slot: *mut TupleTableSlot,
            attnum: ::std::os::raw::c_int,
            isnull: *mut bool,
        ) -> Datum,
    >,
    pub materialize: ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot)>,
    pub copyslot: ::std::option::Option<
        unsafe extern "C" fn(dstslot: *mut TupleTableSlot, srcslot: *mut TupleTableSlot),
    >,
    pub get_heap_tuple:
        ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot) -> HeapTuple>,
    pub get_minimal_tuple:
        ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot) -> MinimalTuple>,
    pub copy_heap_tuple:
        ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot) -> HeapTuple>,
    pub copy_minimal_tuple:
        ::std::option::Option<unsafe extern "C" fn(slot: *mut TupleTableSlot) -> MinimalTuple>,
}
extern "C" {
    pub static TTSOpsVirtual: TupleTableSlotOps;
}
extern "C" {
    pub static TTSOpsHeapTuple: TupleTableSlotOps;
}
extern "C" {
    pub static TTSOpsMinimalTuple: TupleTableSlotOps;
}
extern "C" {
    pub static TTSOpsBufferHeapTuple: TupleTableSlotOps;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VirtualTupleTableSlot {
    pub base: TupleTableSlot,
    pub data: *mut ::std::os::raw::c_char,
}
impl Default for VirtualTupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HeapTupleTableSlot {
    pub base: TupleTableSlot,
    pub tuple: HeapTuple,
    pub off: uint32,
    pub tupdata: HeapTupleData,
}
impl Default for HeapTupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BufferHeapTupleTableSlot {
    pub base: HeapTupleTableSlot,
    pub buffer: Buffer,
}
impl Default for BufferHeapTupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MinimalTupleTableSlot {
    pub base: TupleTableSlot,
    pub tuple: HeapTuple,
    pub mintuple: MinimalTuple,
    pub minhdr: HeapTupleData,
    pub off: uint32,
}
impl Default for MinimalTupleTableSlot {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MakeTupleTableSlot(
        tupleDesc: TupleDesc,
        tts_ops: *const TupleTableSlotOps,
    ) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecAllocTableSlot(
        tupleTable: *mut *mut List,
        desc: TupleDesc,
        tts_ops: *const TupleTableSlotOps,
    ) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecResetTupleTable(tupleTable: *mut List, shouldFree: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MakeSingleTupleTableSlot(
        tupdesc: TupleDesc,
        tts_ops: *const TupleTableSlotOps,
    ) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecDropSingleTupleTableSlot(slot: *mut TupleTableSlot);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecSetSlotDescriptor(slot: *mut TupleTableSlot, tupdesc: TupleDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecStoreHeapTuple(
        tuple: HeapTuple,
        slot: *mut TupleTableSlot,
        shouldFree: bool,
    ) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecForceStoreHeapTuple(tuple: HeapTuple, slot: *mut TupleTableSlot, shouldFree: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecStoreBufferHeapTuple(
        tuple: HeapTuple,
        slot: *mut TupleTableSlot,
        buffer: Buffer,
    ) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecStorePinnedBufferHeapTuple(
        tuple: HeapTuple,
        slot: *mut TupleTableSlot,
        buffer: Buffer,
    ) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecStoreMinimalTuple(
        mtup: MinimalTuple,
        slot: *mut TupleTableSlot,
        shouldFree: bool,
    ) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecForceStoreMinimalTuple(
        mtup: MinimalTuple,
        slot: *mut TupleTableSlot,
        shouldFree: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecStoreVirtualTuple(slot: *mut TupleTableSlot) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecStoreAllNullTuple(slot: *mut TupleTableSlot) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecStoreHeapTupleDatum(data: Datum, slot: *mut TupleTableSlot);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecFetchSlotHeapTuple(
        slot: *mut TupleTableSlot,
        materialize: bool,
        shouldFree: *mut bool,
    ) -> HeapTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecFetchSlotMinimalTuple(
        slot: *mut TupleTableSlot,
        shouldFree: *mut bool,
    ) -> MinimalTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecFetchSlotHeapTupleDatum(slot: *mut TupleTableSlot) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn slot_getmissingattrs(
        slot: *mut TupleTableSlot,
        startAttNum: ::std::os::raw::c_int,
        lastAttNum: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn slot_getsomeattrs_int(slot: *mut TupleTableSlot, attnum: ::std::os::raw::c_int);
}
pub type bitmapword = uint64;
pub type signedbitmapword = int64;
#[repr(C)]
#[derive(Debug, Default)]
pub struct Bitmapset {
    pub nwords: ::std::os::raw::c_int,
    pub words: __IncompleteArrayField<bitmapword>,
}
pub const BMS_Comparison_BMS_EQUAL: BMS_Comparison = 0;
pub const BMS_Comparison_BMS_SUBSET1: BMS_Comparison = 1;
pub const BMS_Comparison_BMS_SUBSET2: BMS_Comparison = 2;
pub const BMS_Comparison_BMS_DIFFERENT: BMS_Comparison = 3;
pub type BMS_Comparison = ::std::os::raw::c_uint;
pub const BMS_Membership_BMS_EMPTY_SET: BMS_Membership = 0;
pub const BMS_Membership_BMS_SINGLETON: BMS_Membership = 1;
pub const BMS_Membership_BMS_MULTIPLE: BMS_Membership = 2;
pub type BMS_Membership = ::std::os::raw::c_uint;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_copy(a: *const Bitmapset) -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_equal(a: *const Bitmapset, b: *const Bitmapset) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_compare(a: *const Bitmapset, b: *const Bitmapset) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_make_singleton(x: ::std::os::raw::c_int) -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_free(a: *mut Bitmapset);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_union(a: *const Bitmapset, b: *const Bitmapset) -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_intersect(a: *const Bitmapset, b: *const Bitmapset) -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_difference(a: *const Bitmapset, b: *const Bitmapset) -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_is_subset(a: *const Bitmapset, b: *const Bitmapset) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_subset_compare(a: *const Bitmapset, b: *const Bitmapset) -> BMS_Comparison;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_is_member(x: ::std::os::raw::c_int, a: *const Bitmapset) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_member_index(a: *mut Bitmapset, x: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_overlap(a: *const Bitmapset, b: *const Bitmapset) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_overlap_list(a: *const Bitmapset, b: *const List) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_nonempty_difference(a: *const Bitmapset, b: *const Bitmapset) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_singleton_member(a: *const Bitmapset) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_get_singleton_member(
        a: *const Bitmapset,
        member: *mut ::std::os::raw::c_int,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_num_members(a: *const Bitmapset) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_membership(a: *const Bitmapset) -> BMS_Membership;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_is_empty(a: *const Bitmapset) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_add_member(a: *mut Bitmapset, x: ::std::os::raw::c_int) -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_del_member(a: *mut Bitmapset, x: ::std::os::raw::c_int) -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_add_members(a: *mut Bitmapset, b: *const Bitmapset) -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_add_range(
        a: *mut Bitmapset,
        lower: ::std::os::raw::c_int,
        upper: ::std::os::raw::c_int,
    ) -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_int_members(a: *mut Bitmapset, b: *const Bitmapset) -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_del_members(a: *mut Bitmapset, b: *const Bitmapset) -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_join(a: *mut Bitmapset, b: *mut Bitmapset) -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_first_member(a: *mut Bitmapset) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_next_member(
        a: *const Bitmapset,
        prevbit: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_prev_member(
        a: *const Bitmapset,
        prevbit: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bms_hash_value(a: *const Bitmapset) -> uint32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bitmap_hash(key: *const ::std::os::raw::c_void, keysize: Size) -> uint32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn bitmap_match(
        key1: *const ::std::os::raw::c_void,
        key2: *const ::std::os::raw::c_void,
        keysize: Size,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleConversionMap {
    pub indesc: TupleDesc,
    pub outdesc: TupleDesc,
    pub attrMap: *mut AttrMap,
    pub invalues: *mut Datum,
    pub inisnull: *mut bool,
    pub outvalues: *mut Datum,
    pub outisnull: *mut bool,
}
impl Default for TupleConversionMap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn convert_tuples_by_position(
        indesc: TupleDesc,
        outdesc: TupleDesc,
        msg: *const ::std::os::raw::c_char,
    ) -> *mut TupleConversionMap;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn convert_tuples_by_name(indesc: TupleDesc, outdesc: TupleDesc)
        -> *mut TupleConversionMap;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn execute_attr_map_tuple(tuple: HeapTuple, map: *mut TupleConversionMap) -> HeapTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn execute_attr_map_slot(
        attrMap: *mut AttrMap,
        in_slot: *mut TupleTableSlot,
        out_slot: *mut TupleTableSlot,
    ) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn execute_attr_map_cols(attrMap: *mut AttrMap, inbitmap: *mut Bitmapset)
        -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn free_conversion_map(map: *mut TupleConversionMap);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *const ::std::os::raw::c_char,
}
impl Default for tm {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct itimerspec {
    pub it_interval: timespec,
    pub it_value: timespec,
}
pub type instr_time = timespec;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BufferUsage {
    pub shared_blks_hit: ::std::os::raw::c_long,
    pub shared_blks_read: ::std::os::raw::c_long,
    pub shared_blks_dirtied: ::std::os::raw::c_long,
    pub shared_blks_written: ::std::os::raw::c_long,
    pub local_blks_hit: ::std::os::raw::c_long,
    pub local_blks_read: ::std::os::raw::c_long,
    pub local_blks_dirtied: ::std::os::raw::c_long,
    pub local_blks_written: ::std::os::raw::c_long,
    pub temp_blks_read: ::std::os::raw::c_long,
    pub temp_blks_written: ::std::os::raw::c_long,
    pub blk_read_time: instr_time,
    pub blk_write_time: instr_time,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct WalUsage {
    pub wal_records: ::std::os::raw::c_long,
    pub wal_fpi: ::std::os::raw::c_long,
    pub wal_bytes: uint64,
}
pub const InstrumentOption_INSTRUMENT_TIMER: InstrumentOption = 1;
pub const InstrumentOption_INSTRUMENT_BUFFERS: InstrumentOption = 2;
pub const InstrumentOption_INSTRUMENT_ROWS: InstrumentOption = 4;
pub const InstrumentOption_INSTRUMENT_WAL: InstrumentOption = 8;
pub const InstrumentOption_INSTRUMENT_ALL: InstrumentOption = 2147483647;
pub type InstrumentOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Instrumentation {
    pub need_timer: bool,
    pub need_bufusage: bool,
    pub need_walusage: bool,
    pub running: bool,
    pub starttime: instr_time,
    pub counter: instr_time,
    pub firsttuple: f64,
    pub tuplecount: f64,
    pub bufusage_start: BufferUsage,
    pub walusage_start: WalUsage,
    pub startup: f64,
    pub total: f64,
    pub ntuples: f64,
    pub ntuples2: f64,
    pub nloops: f64,
    pub nfiltered1: f64,
    pub nfiltered2: f64,
    pub bufusage: BufferUsage,
    pub walusage: WalUsage,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct WorkerInstrumentation {
    pub num_workers: ::std::os::raw::c_int,
    pub instrument: __IncompleteArrayField<Instrumentation>,
}
extern "C" {
    pub static mut pgBufferUsage: BufferUsage;
}
extern "C" {
    pub static mut pgWalUsage: WalUsage;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InstrAlloc(
        n: ::std::os::raw::c_int,
        instrument_options: ::std::os::raw::c_int,
    ) -> *mut Instrumentation;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InstrInit(instr: *mut Instrumentation, instrument_options: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InstrStartNode(instr: *mut Instrumentation);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InstrStopNode(instr: *mut Instrumentation, nTuples: f64);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InstrEndLoop(instr: *mut Instrumentation);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InstrAggNode(dst: *mut Instrumentation, add: *mut Instrumentation);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InstrStartParallelQuery();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InstrEndParallelQuery(bufusage: *mut BufferUsage, walusage: *mut WalUsage);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InstrAccumParallelQuery(bufusage: *mut BufferUsage, walusage: *mut WalUsage);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BufferUsageAccumDiff(
        dst: *mut BufferUsage,
        add: *const BufferUsage,
        sub: *const BufferUsage,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn WalUsageAccumDiff(dst: *mut WalUsage, add: *const WalUsage, sub: *const WalUsage);
}
pub type fmNodePtr = *mut Node;
pub type fmAggrefPtr = *mut Aggref;
pub type fmExprContextCallbackFunction = ::std::option::Option<unsafe extern "C" fn(arg: Datum)>;
pub type fmStringInfo = *mut StringInfoData;
pub type FunctionCallInfo = *mut FunctionCallInfoBaseData;
pub type PGFunction =
    ::std::option::Option<unsafe extern "C" fn(fcinfo: FunctionCallInfo) -> Datum>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FmgrInfo {
    pub fn_addr: PGFunction,
    pub fn_oid: Oid,
    pub fn_nargs: ::std::os::raw::c_short,
    pub fn_strict: bool,
    pub fn_retset: bool,
    pub fn_stats: ::std::os::raw::c_uchar,
    pub fn_extra: *mut ::std::os::raw::c_void,
    pub fn_mcxt: MemoryContext,
    pub fn_expr: fmNodePtr,
}
impl Default for FmgrInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct FunctionCallInfoBaseData {
    pub flinfo: *mut FmgrInfo,
    pub context: fmNodePtr,
    pub resultinfo: fmNodePtr,
    pub fncollation: Oid,
    pub isnull: bool,
    pub nargs: ::std::os::raw::c_short,
    pub args: __IncompleteArrayField<NullableDatum>,
}
impl Default for FunctionCallInfoBaseData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn fmgr_info(functionId: Oid, finfo: *mut FmgrInfo);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn fmgr_info_cxt(functionId: Oid, finfo: *mut FmgrInfo, mcxt: MemoryContext);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn fmgr_info_copy(dstinfo: *mut FmgrInfo, srcinfo: *mut FmgrInfo, destcxt: MemoryContext);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn fmgr_symbol(
        functionId: Oid,
        mod_: *mut *mut ::std::os::raw::c_char,
        fn_: *mut *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_detoast_datum(datum: *mut varlena) -> *mut varlena;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_detoast_datum_copy(datum: *mut varlena) -> *mut varlena;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_detoast_datum_slice(datum: *mut varlena, first: int32, count: int32) -> *mut varlena;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_detoast_datum_packed(datum: *mut varlena) -> *mut varlena;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Pg_finfo_record {
    pub api_version: ::std::os::raw::c_int,
}
pub type PGFInfoFunction = ::std::option::Option<unsafe extern "C" fn() -> *const Pg_finfo_record>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Pg_magic_struct {
    pub len: ::std::os::raw::c_int,
    pub version: ::std::os::raw::c_int,
    pub funcmaxargs: ::std::os::raw::c_int,
    pub indexmaxkeys: ::std::os::raw::c_int,
    pub namedatalen: ::std::os::raw::c_int,
    pub float8byval: ::std::os::raw::c_int,
}
pub type PGModuleMagicFunction =
    ::std::option::Option<unsafe extern "C" fn() -> *const Pg_magic_struct>;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DirectFunctionCall1Coll(func: PGFunction, collation: Oid, arg1: Datum) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DirectFunctionCall2Coll(
        func: PGFunction,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DirectFunctionCall3Coll(
        func: PGFunction,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DirectFunctionCall4Coll(
        func: PGFunction,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DirectFunctionCall5Coll(
        func: PGFunction,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DirectFunctionCall6Coll(
        func: PGFunction,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DirectFunctionCall7Coll(
        func: PGFunction,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
        arg7: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DirectFunctionCall8Coll(
        func: PGFunction,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
        arg7: Datum,
        arg8: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DirectFunctionCall9Coll(
        func: PGFunction,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
        arg7: Datum,
        arg8: Datum,
        arg9: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CallerFInfoFunctionCall1(
        func: PGFunction,
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CallerFInfoFunctionCall2(
        func: PGFunction,
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FunctionCall0Coll(flinfo: *mut FmgrInfo, collation: Oid) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FunctionCall1Coll(flinfo: *mut FmgrInfo, collation: Oid, arg1: Datum) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FunctionCall2Coll(
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FunctionCall3Coll(
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FunctionCall4Coll(
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FunctionCall5Coll(
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FunctionCall6Coll(
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FunctionCall7Coll(
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
        arg7: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FunctionCall8Coll(
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
        arg7: Datum,
        arg8: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FunctionCall9Coll(
        flinfo: *mut FmgrInfo,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
        arg7: Datum,
        arg8: Datum,
        arg9: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OidFunctionCall0Coll(functionId: Oid, collation: Oid) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OidFunctionCall1Coll(functionId: Oid, collation: Oid, arg1: Datum) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OidFunctionCall2Coll(functionId: Oid, collation: Oid, arg1: Datum, arg2: Datum)
        -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OidFunctionCall3Coll(
        functionId: Oid,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OidFunctionCall4Coll(
        functionId: Oid,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OidFunctionCall5Coll(
        functionId: Oid,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OidFunctionCall6Coll(
        functionId: Oid,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OidFunctionCall7Coll(
        functionId: Oid,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
        arg7: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OidFunctionCall8Coll(
        functionId: Oid,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
        arg7: Datum,
        arg8: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OidFunctionCall9Coll(
        functionId: Oid,
        collation: Oid,
        arg1: Datum,
        arg2: Datum,
        arg3: Datum,
        arg4: Datum,
        arg5: Datum,
        arg6: Datum,
        arg7: Datum,
        arg8: Datum,
        arg9: Datum,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InputFunctionCall(
        flinfo: *mut FmgrInfo,
        str_: *mut ::std::os::raw::c_char,
        typioparam: Oid,
        typmod: int32,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OidInputFunctionCall(
        functionId: Oid,
        str_: *mut ::std::os::raw::c_char,
        typioparam: Oid,
        typmod: int32,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OutputFunctionCall(flinfo: *mut FmgrInfo, val: Datum) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OidOutputFunctionCall(functionId: Oid, val: Datum) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ReceiveFunctionCall(
        flinfo: *mut FmgrInfo,
        buf: fmStringInfo,
        typioparam: Oid,
        typmod: int32,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OidReceiveFunctionCall(
        functionId: Oid,
        buf: fmStringInfo,
        typioparam: Oid,
        typmod: int32,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SendFunctionCall(flinfo: *mut FmgrInfo, val: Datum) -> *mut bytea;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OidSendFunctionCall(functionId: Oid, val: Datum) -> *mut bytea;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn fetch_finfo_record(
        filehandle: *mut ::std::os::raw::c_void,
        funcname: *const ::std::os::raw::c_char,
    ) -> *const Pg_finfo_record;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn clear_external_function_hash(filehandle: *mut ::std::os::raw::c_void);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn fmgr_internal_function(proname: *const ::std::os::raw::c_char) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_fn_expr_rettype(flinfo: *mut FmgrInfo) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_fn_expr_argtype(flinfo: *mut FmgrInfo, argnum: ::std::os::raw::c_int) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_call_expr_argtype(expr: fmNodePtr, argnum: ::std::os::raw::c_int) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_fn_expr_arg_stable(flinfo: *mut FmgrInfo, argnum: ::std::os::raw::c_int) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_call_expr_arg_stable(expr: fmNodePtr, argnum: ::std::os::raw::c_int) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_fn_expr_variadic(flinfo: *mut FmgrInfo) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_fn_opclass_options(flinfo: *mut FmgrInfo) -> *mut bytea;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn has_fn_opclass_options(flinfo: *mut FmgrInfo) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn set_fn_opclass_options(flinfo: *mut FmgrInfo, options: *mut bytea);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CheckFunctionValidatorAccess(validatorOid: Oid, functionOid: Oid) -> bool;
}
extern "C" {
    pub static mut Dynamic_library_path: *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn load_external_function(
        filename: *const ::std::os::raw::c_char,
        funcname: *const ::std::os::raw::c_char,
        signalNotFound: bool,
        filehandle: *mut *mut ::std::os::raw::c_void,
    ) -> PGFunction;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn lookup_external_function(
        filehandle: *mut ::std::os::raw::c_void,
        funcname: *const ::std::os::raw::c_char,
    ) -> PGFunction;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn load_file(filename: *const ::std::os::raw::c_char, restricted: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn find_rendezvous_variable(
        varName: *const ::std::os::raw::c_char,
    ) -> *mut *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EstimateLibraryStateSpace() -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SerializeLibraryState(maxsize: Size, start_address: *mut ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RestoreLibraryState(start_address: *mut ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AggCheckCallContext(
        fcinfo: FunctionCallInfo,
        aggcontext: *mut MemoryContext,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AggGetAggref(fcinfo: FunctionCallInfo) -> fmAggrefPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AggGetTempMemoryContext(fcinfo: FunctionCallInfo) -> MemoryContext;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AggStateIsShared(fcinfo: FunctionCallInfo) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AggRegisterCallback(
        fcinfo: FunctionCallInfo,
        func: fmExprContextCallbackFunction,
        arg: Datum,
    );
}
pub const FmgrHookEventType_FHET_START: FmgrHookEventType = 0;
pub const FmgrHookEventType_FHET_END: FmgrHookEventType = 1;
pub const FmgrHookEventType_FHET_ABORT: FmgrHookEventType = 2;
pub type FmgrHookEventType = ::std::os::raw::c_uint;
pub type needs_fmgr_hook_type = ::std::option::Option<unsafe extern "C" fn(fn_oid: Oid) -> bool>;
pub type fmgr_hook_type = ::std::option::Option<
    unsafe extern "C" fn(event: FmgrHookEventType, flinfo: *mut FmgrInfo, arg: *mut Datum),
>;
extern "C" {
    pub static mut needs_fmgr_hook: needs_fmgr_hook_type;
}
extern "C" {
    pub static mut fmgr_hook: fmgr_hook_type;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StringInfoData {
    pub data: *mut ::std::os::raw::c_char,
    pub len: ::std::os::raw::c_int,
    pub maxlen: ::std::os::raw::c_int,
    pub cursor: ::std::os::raw::c_int,
}
impl Default for StringInfoData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type StringInfo = *mut StringInfoData;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn makeStringInfo() -> StringInfo;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn initStringInfo(str_: StringInfo);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn resetStringInfo(str_: StringInfo);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn appendStringInfo(str_: StringInfo, fmt: *const ::std::os::raw::c_char, ...);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn appendStringInfoString(str_: StringInfo, s: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn appendStringInfoChar(str_: StringInfo, ch: ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn appendStringInfoSpaces(str_: StringInfo, count: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn appendBinaryStringInfo(
        str_: StringInfo,
        data: *const ::std::os::raw::c_char,
        datalen: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn appendBinaryStringInfoNT(
        str_: StringInfo,
        data: *const ::std::os::raw::c_char,
        datalen: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn enlargeStringInfo(str_: StringInfo, needed: ::std::os::raw::c_int);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pairingheap_node {
    pub first_child: *mut pairingheap_node,
    pub next_sibling: *mut pairingheap_node,
    pub prev_or_parent: *mut pairingheap_node,
}
impl Default for pairingheap_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type pairingheap_comparator = ::std::option::Option<
    unsafe extern "C" fn(
        a: *const pairingheap_node,
        b: *const pairingheap_node,
        arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pairingheap {
    pub ph_compare: pairingheap_comparator,
    pub ph_arg: *mut ::std::os::raw::c_void,
    pub ph_root: *mut pairingheap_node,
}
impl Default for pairingheap {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pairingheap_allocate(
        compare: pairingheap_comparator,
        arg: *mut ::std::os::raw::c_void,
    ) -> *mut pairingheap;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pairingheap_free(heap: *mut pairingheap);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pairingheap_add(heap: *mut pairingheap, node: *mut pairingheap_node);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pairingheap_first(heap: *mut pairingheap) -> *mut pairingheap_node;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pairingheap_remove_first(heap: *mut pairingheap) -> *mut pairingheap_node;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pairingheap_remove(heap: *mut pairingheap, node: *mut pairingheap_node);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamExternData {
    pub value: Datum,
    pub isnull: bool,
    pub pflags: uint16,
    pub ptype: Oid,
}
impl Default for ParamExternData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ParamListInfo = *mut ParamListInfoData;
pub type ParamFetchHook = ::std::option::Option<
    unsafe extern "C" fn(
        params: ParamListInfo,
        paramid: ::std::os::raw::c_int,
        speculative: bool,
        workspace: *mut ParamExternData,
    ) -> *mut ParamExternData,
>;
pub type ParamCompileHook = ::std::option::Option<
    unsafe extern "C" fn(
        params: ParamListInfo,
        param: *mut Param,
        state: *mut ExprState,
        resv: *mut Datum,
        resnull: *mut bool,
    ),
>;
pub type ParserSetupHook = ::std::option::Option<
    unsafe extern "C" fn(pstate: *mut ParseState, arg: *mut ::std::os::raw::c_void),
>;
#[repr(C)]
#[derive(Debug)]
pub struct ParamListInfoData {
    pub paramFetch: ParamFetchHook,
    pub paramFetchArg: *mut ::std::os::raw::c_void,
    pub paramCompile: ParamCompileHook,
    pub paramCompileArg: *mut ::std::os::raw::c_void,
    pub parserSetup: ParserSetupHook,
    pub parserSetupArg: *mut ::std::os::raw::c_void,
    pub paramValuesStr: *mut ::std::os::raw::c_char,
    pub numParams: ::std::os::raw::c_int,
    pub params: __IncompleteArrayField<ParamExternData>,
}
impl Default for ParamListInfoData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamExecData {
    pub execPlan: *mut ::std::os::raw::c_void,
    pub value: Datum,
    pub isnull: bool,
}
impl Default for ParamExecData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamsErrorCbData {
    pub portalName: *const ::std::os::raw::c_char,
    pub params: ParamListInfo,
}
impl Default for ParamsErrorCbData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn makeParamList(numParams: ::std::os::raw::c_int) -> ParamListInfo;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn copyParamList(from: ParamListInfo) -> ParamListInfo;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EstimateParamListSpace(paramLI: ParamListInfo) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SerializeParamList(
        paramLI: ParamListInfo,
        start_address: *mut *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RestoreParamList(start_address: *mut *mut ::std::os::raw::c_char) -> ParamListInfo;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BuildParamLogString(
        params: ParamListInfo,
        paramTextValues: *mut *mut ::std::os::raw::c_char,
        valueLen: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ParamsErrorCallback(arg: *mut ::std::os::raw::c_void);
}
pub const ScanDirection_BackwardScanDirection: ScanDirection = -1;
pub const ScanDirection_NoMovementScanDirection: ScanDirection = 0;
pub const ScanDirection_ForwardScanDirection: ScanDirection = 1;
pub type ScanDirection = ::std::os::raw::c_int;
pub type StrategyNumber = uint16;
pub const LockClauseStrength_LCS_NONE: LockClauseStrength = 0;
pub const LockClauseStrength_LCS_FORKEYSHARE: LockClauseStrength = 1;
pub const LockClauseStrength_LCS_FORSHARE: LockClauseStrength = 2;
pub const LockClauseStrength_LCS_FORNOKEYUPDATE: LockClauseStrength = 3;
pub const LockClauseStrength_LCS_FORUPDATE: LockClauseStrength = 4;
pub type LockClauseStrength = ::std::os::raw::c_uint;
pub const LockWaitPolicy_LockWaitBlock: LockWaitPolicy = 0;
pub const LockWaitPolicy_LockWaitSkip: LockWaitPolicy = 1;
pub const LockWaitPolicy_LockWaitError: LockWaitPolicy = 2;
pub type LockWaitPolicy = ::std::os::raw::c_uint;
pub const LockTupleMode_LockTupleKeyShare: LockTupleMode = 0;
pub const LockTupleMode_LockTupleShare: LockTupleMode = 1;
pub const LockTupleMode_LockTupleNoKeyExclusive: LockTupleMode = 2;
pub const LockTupleMode_LockTupleExclusive: LockTupleMode = 3;
pub type LockTupleMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Alias {
    pub type_: NodeTag,
    pub aliasname: *mut ::std::os::raw::c_char,
    pub colnames: *mut List,
}
impl Default for Alias {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const OnCommitAction_ONCOMMIT_NOOP: OnCommitAction = 0;
pub const OnCommitAction_ONCOMMIT_PRESERVE_ROWS: OnCommitAction = 1;
pub const OnCommitAction_ONCOMMIT_DELETE_ROWS: OnCommitAction = 2;
pub const OnCommitAction_ONCOMMIT_DROP: OnCommitAction = 3;
pub type OnCommitAction = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeVar {
    pub type_: NodeTag,
    pub catalogname: *mut ::std::os::raw::c_char,
    pub schemaname: *mut ::std::os::raw::c_char,
    pub relname: *mut ::std::os::raw::c_char,
    pub inh: bool,
    pub relpersistence: ::std::os::raw::c_char,
    pub alias: *mut Alias,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeVar {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableFunc {
    pub type_: NodeTag,
    pub ns_uris: *mut List,
    pub ns_names: *mut List,
    pub docexpr: *mut Node,
    pub rowexpr: *mut Node,
    pub colnames: *mut List,
    pub coltypes: *mut List,
    pub coltypmods: *mut List,
    pub colcollations: *mut List,
    pub colexprs: *mut List,
    pub coldefexprs: *mut List,
    pub notnulls: *mut Bitmapset,
    pub ordinalitycol: ::std::os::raw::c_int,
    pub location: ::std::os::raw::c_int,
}
impl Default for TableFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IntoClause {
    pub type_: NodeTag,
    pub rel: *mut RangeVar,
    pub colNames: *mut List,
    pub accessMethod: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub onCommit: OnCommitAction,
    pub tableSpaceName: *mut ::std::os::raw::c_char,
    pub viewQuery: *mut Node,
    pub skipData: bool,
}
impl Default for IntoClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Expr {
    pub type_: NodeTag,
}
impl Default for Expr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Var {
    pub xpr: Expr,
    pub varno: Index,
    pub varattno: AttrNumber,
    pub vartype: Oid,
    pub vartypmod: int32,
    pub varcollid: Oid,
    pub varlevelsup: Index,
    pub varnosyn: Index,
    pub varattnosyn: AttrNumber,
    pub location: ::std::os::raw::c_int,
}
impl Default for Var {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Const {
    pub xpr: Expr,
    pub consttype: Oid,
    pub consttypmod: int32,
    pub constcollid: Oid,
    pub constlen: ::std::os::raw::c_int,
    pub constvalue: Datum,
    pub constisnull: bool,
    pub constbyval: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for Const {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ParamKind_PARAM_EXTERN: ParamKind = 0;
pub const ParamKind_PARAM_EXEC: ParamKind = 1;
pub const ParamKind_PARAM_SUBLINK: ParamKind = 2;
pub const ParamKind_PARAM_MULTIEXPR: ParamKind = 3;
pub type ParamKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Param {
    pub xpr: Expr,
    pub paramkind: ParamKind,
    pub paramid: ::std::os::raw::c_int,
    pub paramtype: Oid,
    pub paramtypmod: int32,
    pub paramcollid: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for Param {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Aggref {
    pub xpr: Expr,
    pub aggfnoid: Oid,
    pub aggtype: Oid,
    pub aggcollid: Oid,
    pub inputcollid: Oid,
    pub aggtranstype: Oid,
    pub aggargtypes: *mut List,
    pub aggdirectargs: *mut List,
    pub args: *mut List,
    pub aggorder: *mut List,
    pub aggdistinct: *mut List,
    pub aggfilter: *mut Expr,
    pub aggstar: bool,
    pub aggvariadic: bool,
    pub aggkind: ::std::os::raw::c_char,
    pub agglevelsup: Index,
    pub aggsplit: AggSplit,
    pub location: ::std::os::raw::c_int,
}
impl Default for Aggref {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupingFunc {
    pub xpr: Expr,
    pub args: *mut List,
    pub refs: *mut List,
    pub cols: *mut List,
    pub agglevelsup: Index,
    pub location: ::std::os::raw::c_int,
}
impl Default for GroupingFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowFunc {
    pub xpr: Expr,
    pub winfnoid: Oid,
    pub wintype: Oid,
    pub wincollid: Oid,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub aggfilter: *mut Expr,
    pub winref: Index,
    pub winstar: bool,
    pub winagg: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for WindowFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubscriptingRef {
    pub xpr: Expr,
    pub refcontainertype: Oid,
    pub refelemtype: Oid,
    pub reftypmod: int32,
    pub refcollid: Oid,
    pub refupperindexpr: *mut List,
    pub reflowerindexpr: *mut List,
    pub refexpr: *mut Expr,
    pub refassgnexpr: *mut Expr,
}
impl Default for SubscriptingRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const CoercionContext_COERCION_IMPLICIT: CoercionContext = 0;
pub const CoercionContext_COERCION_ASSIGNMENT: CoercionContext = 1;
pub const CoercionContext_COERCION_EXPLICIT: CoercionContext = 2;
pub type CoercionContext = ::std::os::raw::c_uint;
pub const CoercionForm_COERCE_EXPLICIT_CALL: CoercionForm = 0;
pub const CoercionForm_COERCE_EXPLICIT_CAST: CoercionForm = 1;
pub const CoercionForm_COERCE_IMPLICIT_CAST: CoercionForm = 2;
pub type CoercionForm = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FuncExpr {
    pub xpr: Expr,
    pub funcid: Oid,
    pub funcresulttype: Oid,
    pub funcretset: bool,
    pub funcvariadic: bool,
    pub funcformat: CoercionForm,
    pub funccollid: Oid,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for FuncExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedArgExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub name: *mut ::std::os::raw::c_char,
    pub argnumber: ::std::os::raw::c_int,
    pub location: ::std::os::raw::c_int,
}
impl Default for NamedArgExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OpExpr {
    pub xpr: Expr,
    pub opno: Oid,
    pub opfuncid: Oid,
    pub opresulttype: Oid,
    pub opretset: bool,
    pub opcollid: Oid,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for OpExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type DistinctExpr = OpExpr;
pub type NullIfExpr = OpExpr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScalarArrayOpExpr {
    pub xpr: Expr,
    pub opno: Oid,
    pub opfuncid: Oid,
    pub useOr: bool,
    pub inputcollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for ScalarArrayOpExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BoolExprType_AND_EXPR: BoolExprType = 0;
pub const BoolExprType_OR_EXPR: BoolExprType = 1;
pub const BoolExprType_NOT_EXPR: BoolExprType = 2;
pub type BoolExprType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BoolExpr {
    pub xpr: Expr,
    pub boolop: BoolExprType,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for BoolExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SubLinkType_EXISTS_SUBLINK: SubLinkType = 0;
pub const SubLinkType_ALL_SUBLINK: SubLinkType = 1;
pub const SubLinkType_ANY_SUBLINK: SubLinkType = 2;
pub const SubLinkType_ROWCOMPARE_SUBLINK: SubLinkType = 3;
pub const SubLinkType_EXPR_SUBLINK: SubLinkType = 4;
pub const SubLinkType_MULTIEXPR_SUBLINK: SubLinkType = 5;
pub const SubLinkType_ARRAY_SUBLINK: SubLinkType = 6;
pub const SubLinkType_CTE_SUBLINK: SubLinkType = 7;
pub type SubLinkType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubLink {
    pub xpr: Expr,
    pub subLinkType: SubLinkType,
    pub subLinkId: ::std::os::raw::c_int,
    pub testexpr: *mut Node,
    pub operName: *mut List,
    pub subselect: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for SubLink {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubPlan {
    pub xpr: Expr,
    pub subLinkType: SubLinkType,
    pub testexpr: *mut Node,
    pub paramIds: *mut List,
    pub plan_id: ::std::os::raw::c_int,
    pub plan_name: *mut ::std::os::raw::c_char,
    pub firstColType: Oid,
    pub firstColTypmod: int32,
    pub firstColCollation: Oid,
    pub useHashTable: bool,
    pub unknownEqFalse: bool,
    pub parallel_safe: bool,
    pub setParam: *mut List,
    pub parParam: *mut List,
    pub args: *mut List,
    pub startup_cost: Cost,
    pub per_call_cost: Cost,
    pub subLinkId: ::std::os::raw::c_int,
}
impl Default for SubPlan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlternativeSubPlan {
    pub xpr: Expr,
    pub subplans: *mut List,
}
impl Default for AlternativeSubPlan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FieldSelect {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub fieldnum: AttrNumber,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
}
impl Default for FieldSelect {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FieldStore {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub newvals: *mut List,
    pub fieldnums: *mut List,
    pub resulttype: Oid,
}
impl Default for FieldStore {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RelabelType {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
    pub relabelformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for RelabelType {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoerceViaIO {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub resultcollid: Oid,
    pub coerceformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoerceViaIO {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayCoerceExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub elemexpr: *mut Expr,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
    pub coerceformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for ArrayCoerceExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ConvertRowtypeExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub convertformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for ConvertRowtypeExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollateExpr {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub collOid: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for CollateExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CaseExpr {
    pub xpr: Expr,
    pub casetype: Oid,
    pub casecollid: Oid,
    pub arg: *mut Expr,
    pub args: *mut List,
    pub defresult: *mut Expr,
    pub location: ::std::os::raw::c_int,
}
impl Default for CaseExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CaseWhen {
    pub xpr: Expr,
    pub expr: *mut Expr,
    pub result: *mut Expr,
    pub location: ::std::os::raw::c_int,
}
impl Default for CaseWhen {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CaseTestExpr {
    pub xpr: Expr,
    pub typeId: Oid,
    pub typeMod: int32,
    pub collation: Oid,
}
impl Default for CaseTestExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayExpr {
    pub xpr: Expr,
    pub array_typeid: Oid,
    pub array_collid: Oid,
    pub element_typeid: Oid,
    pub elements: *mut List,
    pub multidims: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for ArrayExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowExpr {
    pub xpr: Expr,
    pub args: *mut List,
    pub row_typeid: Oid,
    pub row_format: CoercionForm,
    pub colnames: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for RowExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RowCompareType_ROWCOMPARE_LT: RowCompareType = 1;
pub const RowCompareType_ROWCOMPARE_LE: RowCompareType = 2;
pub const RowCompareType_ROWCOMPARE_EQ: RowCompareType = 3;
pub const RowCompareType_ROWCOMPARE_GE: RowCompareType = 4;
pub const RowCompareType_ROWCOMPARE_GT: RowCompareType = 5;
pub const RowCompareType_ROWCOMPARE_NE: RowCompareType = 6;
pub type RowCompareType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowCompareExpr {
    pub xpr: Expr,
    pub rctype: RowCompareType,
    pub opnos: *mut List,
    pub opfamilies: *mut List,
    pub inputcollids: *mut List,
    pub largs: *mut List,
    pub rargs: *mut List,
}
impl Default for RowCompareExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoalesceExpr {
    pub xpr: Expr,
    pub coalescetype: Oid,
    pub coalescecollid: Oid,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoalesceExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const MinMaxOp_IS_GREATEST: MinMaxOp = 0;
pub const MinMaxOp_IS_LEAST: MinMaxOp = 1;
pub type MinMaxOp = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MinMaxExpr {
    pub xpr: Expr,
    pub minmaxtype: Oid,
    pub minmaxcollid: Oid,
    pub inputcollid: Oid,
    pub op: MinMaxOp,
    pub args: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for MinMaxExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SQLValueFunctionOp_SVFOP_CURRENT_DATE: SQLValueFunctionOp = 0;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIME: SQLValueFunctionOp = 1;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIME_N: SQLValueFunctionOp = 2;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIMESTAMP: SQLValueFunctionOp = 3;
pub const SQLValueFunctionOp_SVFOP_CURRENT_TIMESTAMP_N: SQLValueFunctionOp = 4;
pub const SQLValueFunctionOp_SVFOP_LOCALTIME: SQLValueFunctionOp = 5;
pub const SQLValueFunctionOp_SVFOP_LOCALTIME_N: SQLValueFunctionOp = 6;
pub const SQLValueFunctionOp_SVFOP_LOCALTIMESTAMP: SQLValueFunctionOp = 7;
pub const SQLValueFunctionOp_SVFOP_LOCALTIMESTAMP_N: SQLValueFunctionOp = 8;
pub const SQLValueFunctionOp_SVFOP_CURRENT_ROLE: SQLValueFunctionOp = 9;
pub const SQLValueFunctionOp_SVFOP_CURRENT_USER: SQLValueFunctionOp = 10;
pub const SQLValueFunctionOp_SVFOP_USER: SQLValueFunctionOp = 11;
pub const SQLValueFunctionOp_SVFOP_SESSION_USER: SQLValueFunctionOp = 12;
pub const SQLValueFunctionOp_SVFOP_CURRENT_CATALOG: SQLValueFunctionOp = 13;
pub const SQLValueFunctionOp_SVFOP_CURRENT_SCHEMA: SQLValueFunctionOp = 14;
pub type SQLValueFunctionOp = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SQLValueFunction {
    pub xpr: Expr,
    pub op: SQLValueFunctionOp,
    pub type_: Oid,
    pub typmod: int32,
    pub location: ::std::os::raw::c_int,
}
impl Default for SQLValueFunction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const XmlExprOp_IS_XMLCONCAT: XmlExprOp = 0;
pub const XmlExprOp_IS_XMLELEMENT: XmlExprOp = 1;
pub const XmlExprOp_IS_XMLFOREST: XmlExprOp = 2;
pub const XmlExprOp_IS_XMLPARSE: XmlExprOp = 3;
pub const XmlExprOp_IS_XMLPI: XmlExprOp = 4;
pub const XmlExprOp_IS_XMLROOT: XmlExprOp = 5;
pub const XmlExprOp_IS_XMLSERIALIZE: XmlExprOp = 6;
pub const XmlExprOp_IS_DOCUMENT: XmlExprOp = 7;
pub type XmlExprOp = ::std::os::raw::c_uint;
pub const XmlOptionType_XMLOPTION_DOCUMENT: XmlOptionType = 0;
pub const XmlOptionType_XMLOPTION_CONTENT: XmlOptionType = 1;
pub type XmlOptionType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XmlExpr {
    pub xpr: Expr,
    pub op: XmlExprOp,
    pub name: *mut ::std::os::raw::c_char,
    pub named_args: *mut List,
    pub arg_names: *mut List,
    pub args: *mut List,
    pub xmloption: XmlOptionType,
    pub type_: Oid,
    pub typmod: int32,
    pub location: ::std::os::raw::c_int,
}
impl Default for XmlExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const NullTestType_IS_NULL: NullTestType = 0;
pub const NullTestType_IS_NOT_NULL: NullTestType = 1;
pub type NullTestType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NullTest {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub nulltesttype: NullTestType,
    pub argisrow: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for NullTest {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const BoolTestType_IS_TRUE: BoolTestType = 0;
pub const BoolTestType_IS_NOT_TRUE: BoolTestType = 1;
pub const BoolTestType_IS_FALSE: BoolTestType = 2;
pub const BoolTestType_IS_NOT_FALSE: BoolTestType = 3;
pub const BoolTestType_IS_UNKNOWN: BoolTestType = 4;
pub const BoolTestType_IS_NOT_UNKNOWN: BoolTestType = 5;
pub type BoolTestType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BooleanTest {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub booltesttype: BoolTestType,
    pub location: ::std::os::raw::c_int,
}
impl Default for BooleanTest {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoerceToDomain {
    pub xpr: Expr,
    pub arg: *mut Expr,
    pub resulttype: Oid,
    pub resulttypmod: int32,
    pub resultcollid: Oid,
    pub coercionformat: CoercionForm,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoerceToDomain {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CoerceToDomainValue {
    pub xpr: Expr,
    pub typeId: Oid,
    pub typeMod: int32,
    pub collation: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for CoerceToDomainValue {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetToDefault {
    pub xpr: Expr,
    pub typeId: Oid,
    pub typeMod: int32,
    pub collation: Oid,
    pub location: ::std::os::raw::c_int,
}
impl Default for SetToDefault {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CurrentOfExpr {
    pub xpr: Expr,
    pub cvarno: Index,
    pub cursor_name: *mut ::std::os::raw::c_char,
    pub cursor_param: ::std::os::raw::c_int,
}
impl Default for CurrentOfExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NextValueExpr {
    pub xpr: Expr,
    pub seqid: Oid,
    pub typeId: Oid,
}
impl Default for NextValueExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InferenceElem {
    pub xpr: Expr,
    pub expr: *mut Node,
    pub infercollid: Oid,
    pub inferopclass: Oid,
}
impl Default for InferenceElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TargetEntry {
    pub xpr: Expr,
    pub expr: *mut Expr,
    pub resno: AttrNumber,
    pub resname: *mut ::std::os::raw::c_char,
    pub ressortgroupref: Index,
    pub resorigtbl: Oid,
    pub resorigcol: AttrNumber,
    pub resjunk: bool,
}
impl Default for TargetEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTblRef {
    pub type_: NodeTag,
    pub rtindex: ::std::os::raw::c_int,
}
impl Default for RangeTblRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JoinExpr {
    pub type_: NodeTag,
    pub jointype: JoinType,
    pub isNatural: bool,
    pub larg: *mut Node,
    pub rarg: *mut Node,
    pub usingClause: *mut List,
    pub quals: *mut Node,
    pub alias: *mut Alias,
    pub rtindex: ::std::os::raw::c_int,
}
impl Default for JoinExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FromExpr {
    pub type_: NodeTag,
    pub fromlist: *mut List,
    pub quals: *mut Node,
}
impl Default for FromExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnConflictExpr {
    pub type_: NodeTag,
    pub action: OnConflictAction,
    pub arbiterElems: *mut List,
    pub arbiterWhere: *mut Node,
    pub constraint: Oid,
    pub onConflictSet: *mut List,
    pub onConflictWhere: *mut Node,
    pub exclRelIndex: ::std::os::raw::c_int,
    pub exclRelTlist: *mut List,
}
impl Default for OnConflictExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlannedStmt {
    pub type_: NodeTag,
    pub commandType: CmdType,
    pub queryId: uint64,
    pub hasReturning: bool,
    pub hasModifyingCTE: bool,
    pub canSetTag: bool,
    pub transientPlan: bool,
    pub dependsOnRole: bool,
    pub parallelModeNeeded: bool,
    pub jitFlags: ::std::os::raw::c_int,
    pub planTree: *mut Plan,
    pub rtable: *mut List,
    pub resultRelations: *mut List,
    pub rootResultRelations: *mut List,
    pub appendRelations: *mut List,
    pub subplans: *mut List,
    pub rewindPlanIDs: *mut Bitmapset,
    pub rowMarks: *mut List,
    pub relationOids: *mut List,
    pub invalItems: *mut List,
    pub paramExecTypes: *mut List,
    pub utilityStmt: *mut Node,
    pub stmt_location: ::std::os::raw::c_int,
    pub stmt_len: ::std::os::raw::c_int,
}
impl Default for PlannedStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Plan {
    pub type_: NodeTag,
    pub startup_cost: Cost,
    pub total_cost: Cost,
    pub plan_rows: f64,
    pub plan_width: ::std::os::raw::c_int,
    pub parallel_aware: bool,
    pub parallel_safe: bool,
    pub plan_node_id: ::std::os::raw::c_int,
    pub targetlist: *mut List,
    pub qual: *mut List,
    pub lefttree: *mut Plan,
    pub righttree: *mut Plan,
    pub initPlan: *mut List,
    pub extParam: *mut Bitmapset,
    pub allParam: *mut Bitmapset,
}
impl Default for Plan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Result {
    pub plan: Plan,
    pub resconstantqual: *mut Node,
}
impl Default for Result {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectSet {
    pub plan: Plan,
}
impl Default for ProjectSet {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ModifyTable {
    pub plan: Plan,
    pub operation: CmdType,
    pub canSetTag: bool,
    pub nominalRelation: Index,
    pub rootRelation: Index,
    pub partColsUpdated: bool,
    pub resultRelations: *mut List,
    pub resultRelIndex: ::std::os::raw::c_int,
    pub rootResultRelIndex: ::std::os::raw::c_int,
    pub plans: *mut List,
    pub withCheckOptionLists: *mut List,
    pub returningLists: *mut List,
    pub fdwPrivLists: *mut List,
    pub fdwDirectModifyPlans: *mut Bitmapset,
    pub rowMarks: *mut List,
    pub epqParam: ::std::os::raw::c_int,
    pub onConflictAction: OnConflictAction,
    pub arbiterIndexes: *mut List,
    pub onConflictSet: *mut List,
    pub onConflictWhere: *mut Node,
    pub exclRelRTI: Index,
    pub exclRelTlist: *mut List,
}
impl Default for ModifyTable {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Append {
    pub plan: Plan,
    pub apprelids: *mut Bitmapset,
    pub appendplans: *mut List,
    pub first_partial_plan: ::std::os::raw::c_int,
    pub part_prune_info: *mut PartitionPruneInfo,
}
impl Default for Append {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeAppend {
    pub plan: Plan,
    pub apprelids: *mut Bitmapset,
    pub mergeplans: *mut List,
    pub numCols: ::std::os::raw::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub collations: *mut Oid,
    pub nullsFirst: *mut bool,
    pub part_prune_info: *mut PartitionPruneInfo,
}
impl Default for MergeAppend {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RecursiveUnion {
    pub plan: Plan,
    pub wtParam: ::std::os::raw::c_int,
    pub numCols: ::std::os::raw::c_int,
    pub dupColIdx: *mut AttrNumber,
    pub dupOperators: *mut Oid,
    pub dupCollations: *mut Oid,
    pub numGroups: ::std::os::raw::c_long,
}
impl Default for RecursiveUnion {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapAnd {
    pub plan: Plan,
    pub bitmapplans: *mut List,
}
impl Default for BitmapAnd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapOr {
    pub plan: Plan,
    pub isshared: bool,
    pub bitmapplans: *mut List,
}
impl Default for BitmapOr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Scan {
    pub plan: Plan,
    pub scanrelid: Index,
}
impl Default for Scan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type SeqScan = Scan;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SampleScan {
    pub scan: Scan,
    pub tablesample: *mut TableSampleClause,
}
impl Default for SampleScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexScan {
    pub scan: Scan,
    pub indexid: Oid,
    pub indexqual: *mut List,
    pub indexqualorig: *mut List,
    pub indexorderby: *mut List,
    pub indexorderbyorig: *mut List,
    pub indexorderbyops: *mut List,
    pub indexorderdir: ScanDirection,
}
impl Default for IndexScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexOnlyScan {
    pub scan: Scan,
    pub indexid: Oid,
    pub indexqual: *mut List,
    pub indexorderby: *mut List,
    pub indextlist: *mut List,
    pub indexorderdir: ScanDirection,
    pub recheckqual: *mut List,
}
impl Default for IndexOnlyScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapIndexScan {
    pub scan: Scan,
    pub indexid: Oid,
    pub isshared: bool,
    pub indexqual: *mut List,
    pub indexqualorig: *mut List,
}
impl Default for BitmapIndexScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapHeapScan {
    pub scan: Scan,
    pub bitmapqualorig: *mut List,
}
impl Default for BitmapHeapScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TidScan {
    pub scan: Scan,
    pub tidquals: *mut List,
}
impl Default for TidScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubqueryScan {
    pub scan: Scan,
    pub subplan: *mut Plan,
}
impl Default for SubqueryScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionScan {
    pub scan: Scan,
    pub functions: *mut List,
    pub funcordinality: bool,
}
impl Default for FunctionScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ValuesScan {
    pub scan: Scan,
    pub values_lists: *mut List,
}
impl Default for ValuesScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableFuncScan {
    pub scan: Scan,
    pub tablefunc: *mut TableFunc,
}
impl Default for TableFuncScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CteScan {
    pub scan: Scan,
    pub ctePlanId: ::std::os::raw::c_int,
    pub cteParam: ::std::os::raw::c_int,
}
impl Default for CteScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedTuplestoreScan {
    pub scan: Scan,
    pub enrname: *mut ::std::os::raw::c_char,
}
impl Default for NamedTuplestoreScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WorkTableScan {
    pub scan: Scan,
    pub wtParam: ::std::os::raw::c_int,
}
impl Default for WorkTableScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignScan {
    pub scan: Scan,
    pub operation: CmdType,
    pub fs_server: Oid,
    pub fdw_exprs: *mut List,
    pub fdw_private: *mut List,
    pub fdw_scan_tlist: *mut List,
    pub fdw_recheck_quals: *mut List,
    pub fs_relids: *mut Bitmapset,
    pub fsSystemCol: bool,
}
impl Default for ForeignScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CustomScan {
    pub scan: Scan,
    pub flags: uint32,
    pub custom_plans: *mut List,
    pub custom_exprs: *mut List,
    pub custom_private: *mut List,
    pub custom_scan_tlist: *mut List,
    pub custom_relids: *mut Bitmapset,
    pub methods: *const CustomScanMethods,
}
impl Default for CustomScan {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Join {
    pub plan: Plan,
    pub jointype: JoinType,
    pub inner_unique: bool,
    pub joinqual: *mut List,
}
impl Default for Join {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestLoop {
    pub join: Join,
    pub nestParams: *mut List,
}
impl Default for NestLoop {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestLoopParam {
    pub type_: NodeTag,
    pub paramno: ::std::os::raw::c_int,
    pub paramval: *mut Var,
}
impl Default for NestLoopParam {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeJoin {
    pub join: Join,
    pub skip_mark_restore: bool,
    pub mergeclauses: *mut List,
    pub mergeFamilies: *mut Oid,
    pub mergeCollations: *mut Oid,
    pub mergeStrategies: *mut ::std::os::raw::c_int,
    pub mergeNullsFirst: *mut bool,
}
impl Default for MergeJoin {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoin {
    pub join: Join,
    pub hashclauses: *mut List,
    pub hashoperators: *mut List,
    pub hashcollations: *mut List,
    pub hashkeys: *mut List,
}
impl Default for HashJoin {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Material {
    pub plan: Plan,
}
impl Default for Material {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Sort {
    pub plan: Plan,
    pub numCols: ::std::os::raw::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub collations: *mut Oid,
    pub nullsFirst: *mut bool,
}
impl Default for Sort {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IncrementalSort {
    pub sort: Sort,
    pub nPresortedCols: ::std::os::raw::c_int,
}
impl Default for IncrementalSort {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Group {
    pub plan: Plan,
    pub numCols: ::std::os::raw::c_int,
    pub grpColIdx: *mut AttrNumber,
    pub grpOperators: *mut Oid,
    pub grpCollations: *mut Oid,
}
impl Default for Group {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Agg {
    pub plan: Plan,
    pub aggstrategy: AggStrategy,
    pub aggsplit: AggSplit,
    pub numCols: ::std::os::raw::c_int,
    pub grpColIdx: *mut AttrNumber,
    pub grpOperators: *mut Oid,
    pub grpCollations: *mut Oid,
    pub numGroups: ::std::os::raw::c_long,
    pub transitionSpace: uint64,
    pub aggParams: *mut Bitmapset,
    pub groupingSets: *mut List,
    pub chain: *mut List,
}
impl Default for Agg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowAgg {
    pub plan: Plan,
    pub winref: Index,
    pub partNumCols: ::std::os::raw::c_int,
    pub partColIdx: *mut AttrNumber,
    pub partOperators: *mut Oid,
    pub partCollations: *mut Oid,
    pub ordNumCols: ::std::os::raw::c_int,
    pub ordColIdx: *mut AttrNumber,
    pub ordOperators: *mut Oid,
    pub ordCollations: *mut Oid,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut Node,
    pub endOffset: *mut Node,
    pub startInRangeFunc: Oid,
    pub endInRangeFunc: Oid,
    pub inRangeColl: Oid,
    pub inRangeAsc: bool,
    pub inRangeNullsFirst: bool,
}
impl Default for WindowAgg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Unique {
    pub plan: Plan,
    pub numCols: ::std::os::raw::c_int,
    pub uniqColIdx: *mut AttrNumber,
    pub uniqOperators: *mut Oid,
    pub uniqCollations: *mut Oid,
}
impl Default for Unique {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Gather {
    pub plan: Plan,
    pub num_workers: ::std::os::raw::c_int,
    pub rescan_param: ::std::os::raw::c_int,
    pub single_copy: bool,
    pub invisible: bool,
    pub initParam: *mut Bitmapset,
}
impl Default for Gather {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherMerge {
    pub plan: Plan,
    pub num_workers: ::std::os::raw::c_int,
    pub rescan_param: ::std::os::raw::c_int,
    pub numCols: ::std::os::raw::c_int,
    pub sortColIdx: *mut AttrNumber,
    pub sortOperators: *mut Oid,
    pub collations: *mut Oid,
    pub nullsFirst: *mut bool,
    pub initParam: *mut Bitmapset,
}
impl Default for GatherMerge {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Hash {
    pub plan: Plan,
    pub hashkeys: *mut List,
    pub skewTable: Oid,
    pub skewColumn: AttrNumber,
    pub skewInherit: bool,
    pub rows_total: f64,
}
impl Default for Hash {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOp {
    pub plan: Plan,
    pub cmd: SetOpCmd,
    pub strategy: SetOpStrategy,
    pub numCols: ::std::os::raw::c_int,
    pub dupColIdx: *mut AttrNumber,
    pub dupOperators: *mut Oid,
    pub dupCollations: *mut Oid,
    pub flagColIdx: AttrNumber,
    pub firstFlag: ::std::os::raw::c_int,
    pub numGroups: ::std::os::raw::c_long,
}
impl Default for SetOp {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockRows {
    pub plan: Plan,
    pub rowMarks: *mut List,
    pub epqParam: ::std::os::raw::c_int,
}
impl Default for LockRows {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Limit {
    pub plan: Plan,
    pub limitOffset: *mut Node,
    pub limitCount: *mut Node,
    pub limitOption: LimitOption,
    pub uniqNumCols: ::std::os::raw::c_int,
    pub uniqColIdx: *mut AttrNumber,
    pub uniqOperators: *mut Oid,
    pub uniqCollations: *mut Oid,
}
impl Default for Limit {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RowMarkType_ROW_MARK_EXCLUSIVE: RowMarkType = 0;
pub const RowMarkType_ROW_MARK_NOKEYEXCLUSIVE: RowMarkType = 1;
pub const RowMarkType_ROW_MARK_SHARE: RowMarkType = 2;
pub const RowMarkType_ROW_MARK_KEYSHARE: RowMarkType = 3;
pub const RowMarkType_ROW_MARK_REFERENCE: RowMarkType = 4;
pub const RowMarkType_ROW_MARK_COPY: RowMarkType = 5;
pub type RowMarkType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlanRowMark {
    pub type_: NodeTag,
    pub rti: Index,
    pub prti: Index,
    pub rowmarkId: Index,
    pub markType: RowMarkType,
    pub allMarkTypes: ::std::os::raw::c_int,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
    pub isParent: bool,
}
impl Default for PlanRowMark {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneInfo {
    pub type_: NodeTag,
    pub prune_infos: *mut List,
    pub other_subplans: *mut Bitmapset,
}
impl Default for PartitionPruneInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionedRelPruneInfo {
    pub type_: NodeTag,
    pub rtindex: Index,
    pub present_parts: *mut Bitmapset,
    pub nparts: ::std::os::raw::c_int,
    pub subplan_map: *mut ::std::os::raw::c_int,
    pub subpart_map: *mut ::std::os::raw::c_int,
    pub relid_map: *mut Oid,
    pub initial_pruning_steps: *mut List,
    pub exec_pruning_steps: *mut List,
    pub execparamids: *mut Bitmapset,
}
impl Default for PartitionedRelPruneInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneStep {
    pub type_: NodeTag,
    pub step_id: ::std::os::raw::c_int,
}
impl Default for PartitionPruneStep {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneStepOp {
    pub step: PartitionPruneStep,
    pub opstrategy: StrategyNumber,
    pub exprs: *mut List,
    pub cmpfns: *mut List,
    pub nullkeys: *mut Bitmapset,
}
impl Default for PartitionPruneStepOp {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const PartitionPruneCombineOp_PARTPRUNE_COMBINE_UNION: PartitionPruneCombineOp = 0;
pub const PartitionPruneCombineOp_PARTPRUNE_COMBINE_INTERSECT: PartitionPruneCombineOp = 1;
pub type PartitionPruneCombineOp = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneStepCombine {
    pub step: PartitionPruneStep,
    pub combineOp: PartitionPruneCombineOp,
    pub source_stepids: *mut List,
}
impl Default for PartitionPruneStepCombine {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlanInvalItem {
    pub type_: NodeTag,
    pub cacheId: ::std::os::raw::c_int,
    pub hashValue: uint32,
}
impl Default for PlanInvalItem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_atomic_flag {
    pub value: ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_atomic_uint32 {
    pub value: uint32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pg_atomic_uint64 {
    pub value: uint64,
}
extern "C" {
    pub static mut dynamic_shared_memory_type: ::std::os::raw::c_int;
}
pub type dsm_handle = uint32;
pub const dsm_op_DSM_OP_CREATE: dsm_op = 0;
pub const dsm_op_DSM_OP_ATTACH: dsm_op = 1;
pub const dsm_op_DSM_OP_DETACH: dsm_op = 2;
pub const dsm_op_DSM_OP_DESTROY: dsm_op = 3;
pub type dsm_op = ::std::os::raw::c_uint;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsm_impl_op(
        op: dsm_op,
        handle: dsm_handle,
        request_size: Size,
        impl_private: *mut *mut ::std::os::raw::c_void,
        mapped_address: *mut *mut ::std::os::raw::c_void,
        mapped_size: *mut Size,
        elevel: ::std::os::raw::c_int,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsm_impl_pin_segment(
        handle: dsm_handle,
        impl_private: *mut ::std::os::raw::c_void,
        impl_private_pm_handle: *mut *mut ::std::os::raw::c_void,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsm_impl_unpin_segment(
        handle: dsm_handle,
        impl_private: *mut *mut ::std::os::raw::c_void,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dsm_segment {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PGShmemHeader {
    _unused: [u8; 0],
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsm_cleanup_using_control_segment(old_control_handle: dsm_handle);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsm_postmaster_startup(arg1: *mut PGShmemHeader);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsm_backend_shutdown();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsm_detach_all();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsm_create(size: Size, flags: ::std::os::raw::c_int) -> *mut dsm_segment;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsm_attach(h: dsm_handle) -> *mut dsm_segment;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsm_detach(seg: *mut dsm_segment);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsm_pin_mapping(seg: *mut dsm_segment);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsm_unpin_mapping(seg: *mut dsm_segment);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsm_pin_segment(seg: *mut dsm_segment);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsm_unpin_segment(h: dsm_handle);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsm_find_mapping(h: dsm_handle) -> *mut dsm_segment;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsm_segment_address(seg: *mut dsm_segment) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsm_segment_map_length(seg: *mut dsm_segment) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsm_segment_handle(seg: *mut dsm_segment) -> dsm_handle;
}
pub type on_dsm_detach_callback =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut dsm_segment, arg: Datum)>;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn on_dsm_detach(seg: *mut dsm_segment, function: on_dsm_detach_callback, arg: Datum);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn cancel_on_dsm_detach(
        seg: *mut dsm_segment,
        function: on_dsm_detach_callback,
        arg: Datum,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn reset_on_dsm_detach();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dsa_area {
    _unused: [u8; 0],
}
pub type dsa_pointer = uint64;
pub type dsa_pointer_atomic = pg_atomic_uint64;
pub type dsa_handle = dsm_handle;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_create(tranche_id: ::std::os::raw::c_int) -> *mut dsa_area;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_create_in_place(
        place: *mut ::std::os::raw::c_void,
        size: usize,
        tranche_id: ::std::os::raw::c_int,
        segment: *mut dsm_segment,
    ) -> *mut dsa_area;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_attach(handle: dsa_handle) -> *mut dsa_area;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_attach_in_place(
        place: *mut ::std::os::raw::c_void,
        segment: *mut dsm_segment,
    ) -> *mut dsa_area;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_release_in_place(place: *mut ::std::os::raw::c_void);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_on_dsm_detach_release_in_place(arg1: *mut dsm_segment, arg2: Datum);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_on_shmem_exit_release_in_place(arg1: ::std::os::raw::c_int, arg2: Datum);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_pin_mapping(area: *mut dsa_area);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_detach(area: *mut dsa_area);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_pin(area: *mut dsa_area);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_unpin(area: *mut dsa_area);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_set_size_limit(area: *mut dsa_area, limit: usize);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_minimum_size() -> usize;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_get_handle(area: *mut dsa_area) -> dsa_handle;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_allocate_extended(
        area: *mut dsa_area,
        size: usize,
        flags: ::std::os::raw::c_int,
    ) -> dsa_pointer;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_free(area: *mut dsa_area, dp: dsa_pointer);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_get_address(area: *mut dsa_area, dp: dsa_pointer) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_trim(area: *mut dsa_area);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dsa_dump(area: *mut dsa_area);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TIDBitmap {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TBMIterator {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TBMSharedIterator {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct TBMIterateResult {
    pub blockno: BlockNumber,
    pub ntuples: ::std::os::raw::c_int,
    pub recheck: bool,
    pub offsets: __IncompleteArrayField<OffsetNumber>,
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tbm_create(maxbytes: ::std::os::raw::c_long, dsa: *mut dsa_area) -> *mut TIDBitmap;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tbm_free(tbm: *mut TIDBitmap);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tbm_free_shared_area(dsa: *mut dsa_area, dp: dsa_pointer);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tbm_add_tuples(
        tbm: *mut TIDBitmap,
        tids: ItemPointer,
        ntids: ::std::os::raw::c_int,
        recheck: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tbm_add_page(tbm: *mut TIDBitmap, pageno: BlockNumber);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tbm_union(a: *mut TIDBitmap, b: *const TIDBitmap);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tbm_intersect(a: *mut TIDBitmap, b: *const TIDBitmap);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tbm_is_empty(tbm: *const TIDBitmap) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tbm_begin_iterate(tbm: *mut TIDBitmap) -> *mut TBMIterator;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tbm_prepare_shared_iterate(tbm: *mut TIDBitmap) -> dsa_pointer;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tbm_iterate(iterator: *mut TBMIterator) -> *mut TBMIterateResult;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tbm_shared_iterate(iterator: *mut TBMSharedIterator) -> *mut TBMIterateResult;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tbm_end_iterate(iterator: *mut TBMIterator);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tbm_end_shared_iterate(iterator: *mut TBMSharedIterator);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tbm_attach_shared_iterate(dsa: *mut dsa_area, dp: dsa_pointer)
        -> *mut TBMSharedIterator;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tbm_calculate_entries(maxbytes: f64) -> ::std::os::raw::c_long;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionBoundInfoData {
    _unused: [u8; 0],
}
pub type PartitionBoundInfo = *mut PartitionBoundInfoData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionKeyData {
    _unused: [u8; 0],
}
pub type PartitionKey = *mut PartitionKeyData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionDescData {
    _unused: [u8; 0],
}
pub type PartitionDesc = *mut PartitionDescData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionDirectoryData {
    _unused: [u8; 0],
}
pub type PartitionDirectory = *mut PartitionDirectoryData;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proclist_node {
    pub next: ::std::os::raw::c_int,
    pub prev: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proclist_head {
    pub head: ::std::os::raw::c_int,
    pub tail: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proclist_mutable_iter {
    pub cur: ::std::os::raw::c_int,
    pub next: ::std::os::raw::c_int,
}
pub type slock_t = ::std::os::raw::c_uchar;
extern "C" {
    pub static mut dummy_spinlock: slock_t;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn s_lock(
        lock: *mut slock_t,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
        func: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn set_spins_per_delay(shared_spins_per_delay: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn update_spins_per_delay(
        shared_spins_per_delay: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SpinDelayStatus {
    pub spins: ::std::os::raw::c_int,
    pub delays: ::std::os::raw::c_int,
    pub cur_delay: ::std::os::raw::c_int,
    pub file: *const ::std::os::raw::c_char,
    pub line: ::std::os::raw::c_int,
    pub func: *const ::std::os::raw::c_char,
}
impl Default for SpinDelayStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn perform_spin_delay(status: *mut SpinDelayStatus);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn finish_spin_delay(status: *mut SpinDelayStatus);
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ConditionVariable {
    pub mutex: slock_t,
    pub wakeup: proclist_head,
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ConditionVariableInit(cv: *mut ConditionVariable);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ConditionVariableSleep(cv: *mut ConditionVariable, wait_event_info: uint32);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ConditionVariableTimedSleep(
        cv: *mut ConditionVariable,
        timeout: ::std::os::raw::c_long,
        wait_event_info: uint32,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ConditionVariableCancelSleep();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ConditionVariablePrepareToSleep(cv: *mut ConditionVariable);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ConditionVariableSignal(cv: *mut ConditionVariable);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ConditionVariableBroadcast(cv: *mut ConditionVariable);
}
pub type HashValueFunc = ::std::option::Option<
    unsafe extern "C" fn(key: *const ::std::os::raw::c_void, keysize: Size) -> uint32,
>;
pub type HashCompareFunc = ::std::option::Option<
    unsafe extern "C" fn(
        key1: *const ::std::os::raw::c_void,
        key2: *const ::std::os::raw::c_void,
        keysize: Size,
    ) -> ::std::os::raw::c_int,
>;
pub type HashCopyFunc = ::std::option::Option<
    unsafe extern "C" fn(
        dest: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        keysize: Size,
    ) -> *mut ::std::os::raw::c_void,
>;
pub type HashAllocFunc =
    ::std::option::Option<unsafe extern "C" fn(request: Size) -> *mut ::std::os::raw::c_void>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASHELEMENT {
    pub link: *mut HASHELEMENT,
    pub hashvalue: uint32,
}
impl Default for HASHELEMENT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASHHDR {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTAB {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASHCTL {
    pub num_partitions: ::std::os::raw::c_long,
    pub ssize: ::std::os::raw::c_long,
    pub dsize: ::std::os::raw::c_long,
    pub max_dsize: ::std::os::raw::c_long,
    pub ffactor: ::std::os::raw::c_long,
    pub keysize: Size,
    pub entrysize: Size,
    pub hash: HashValueFunc,
    pub match_: HashCompareFunc,
    pub keycopy: HashCopyFunc,
    pub alloc: HashAllocFunc,
    pub hcxt: MemoryContext,
    pub hctl: *mut HASHHDR,
}
impl Default for HASHCTL {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const HASHACTION_HASH_FIND: HASHACTION = 0;
pub const HASHACTION_HASH_ENTER: HASHACTION = 1;
pub const HASHACTION_HASH_REMOVE: HASHACTION = 2;
pub const HASHACTION_HASH_ENTER_NULL: HASHACTION = 3;
pub type HASHACTION = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HASH_SEQ_STATUS {
    pub hashp: *mut HTAB,
    pub curBucket: uint32,
    pub curEntry: *mut HASHELEMENT,
}
impl Default for HASH_SEQ_STATUS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn hash_create(
        tabname: *const ::std::os::raw::c_char,
        nelem: ::std::os::raw::c_long,
        info: *mut HASHCTL,
        flags: ::std::os::raw::c_int,
    ) -> *mut HTAB;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn hash_destroy(hashp: *mut HTAB);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn hash_stats(where_: *const ::std::os::raw::c_char, hashp: *mut HTAB);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn hash_search(
        hashp: *mut HTAB,
        keyPtr: *const ::std::os::raw::c_void,
        action: HASHACTION,
        foundPtr: *mut bool,
    ) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_hash_value(hashp: *mut HTAB, keyPtr: *const ::std::os::raw::c_void) -> uint32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn hash_search_with_hash_value(
        hashp: *mut HTAB,
        keyPtr: *const ::std::os::raw::c_void,
        hashvalue: uint32,
        action: HASHACTION,
        foundPtr: *mut bool,
    ) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn hash_update_hash_key(
        hashp: *mut HTAB,
        existingEntry: *mut ::std::os::raw::c_void,
        newKeyPtr: *const ::std::os::raw::c_void,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn hash_get_num_entries(hashp: *mut HTAB) -> ::std::os::raw::c_long;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn hash_seq_init(status: *mut HASH_SEQ_STATUS, hashp: *mut HTAB);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn hash_seq_search(status: *mut HASH_SEQ_STATUS) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn hash_seq_term(status: *mut HASH_SEQ_STATUS);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn hash_freeze(hashp: *mut HTAB);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn hash_estimate_size(num_entries: ::std::os::raw::c_long, entrysize: Size) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn hash_select_dirsize(num_entries: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn hash_get_shared_size(info: *mut HASHCTL, flags: ::std::os::raw::c_int) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AtEOXact_HashTables(isCommit: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AtEOSubXact_HashTables(isCommit: bool, nestDepth: ::std::os::raw::c_int);
}
pub const EphemeralNameRelationType_ENR_NAMED_TUPLESTORE: EphemeralNameRelationType = 0;
pub type EphemeralNameRelationType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EphemeralNamedRelationMetadataData {
    pub name: *mut ::std::os::raw::c_char,
    pub reliddesc: Oid,
    pub tupdesc: TupleDesc,
    pub enrtype: EphemeralNameRelationType,
    pub enrtuples: f64,
}
impl Default for EphemeralNamedRelationMetadataData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type EphemeralNamedRelationMetadata = *mut EphemeralNamedRelationMetadataData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EphemeralNamedRelationData {
    pub md: EphemeralNamedRelationMetadataData,
    pub reldata: *mut ::std::os::raw::c_void,
}
impl Default for EphemeralNamedRelationData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type EphemeralNamedRelation = *mut EphemeralNamedRelationData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QueryEnvironment {
    _unused: [u8; 0],
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn create_queryEnv() -> *mut QueryEnvironment;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_visible_ENR_metadata(
        queryEnv: *mut QueryEnvironment,
        refname: *const ::std::os::raw::c_char,
    ) -> EphemeralNamedRelationMetadata;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn register_ENR(queryEnv: *mut QueryEnvironment, enr: EphemeralNamedRelation);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn unregister_ENR(queryEnv: *mut QueryEnvironment, name: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_ENR(
        queryEnv: *mut QueryEnvironment,
        name: *const ::std::os::raw::c_char,
    ) -> EphemeralNamedRelation;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ENRMetadataGetTupDesc(enrmd: EphemeralNamedRelationMetadata) -> TupleDesc;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Trigger {
    pub tgoid: Oid,
    pub tgname: *mut ::std::os::raw::c_char,
    pub tgfoid: Oid,
    pub tgtype: int16,
    pub tgenabled: ::std::os::raw::c_char,
    pub tgisinternal: bool,
    pub tgisclone: bool,
    pub tgconstrrelid: Oid,
    pub tgconstrindid: Oid,
    pub tgconstraint: Oid,
    pub tgdeferrable: bool,
    pub tginitdeferred: bool,
    pub tgnargs: int16,
    pub tgnattr: int16,
    pub tgattr: *mut int16,
    pub tgargs: *mut *mut ::std::os::raw::c_char,
    pub tgqual: *mut ::std::os::raw::c_char,
    pub tgoldtable: *mut ::std::os::raw::c_char,
    pub tgnewtable: *mut ::std::os::raw::c_char,
}
impl Default for Trigger {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TriggerDesc {
    pub triggers: *mut Trigger,
    pub numtriggers: ::std::os::raw::c_int,
    pub trig_insert_before_row: bool,
    pub trig_insert_after_row: bool,
    pub trig_insert_instead_row: bool,
    pub trig_insert_before_statement: bool,
    pub trig_insert_after_statement: bool,
    pub trig_update_before_row: bool,
    pub trig_update_after_row: bool,
    pub trig_update_instead_row: bool,
    pub trig_update_before_statement: bool,
    pub trig_update_after_statement: bool,
    pub trig_delete_before_row: bool,
    pub trig_delete_after_row: bool,
    pub trig_delete_instead_row: bool,
    pub trig_delete_before_statement: bool,
    pub trig_delete_after_statement: bool,
    pub trig_truncate_before_statement: bool,
    pub trig_truncate_after_statement: bool,
    pub trig_insert_new_table: bool,
    pub trig_update_old_table: bool,
    pub trig_update_new_table: bool,
    pub trig_delete_old_table: bool,
}
impl Default for TriggerDesc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dirent {
    pub d_ino: __ino_t,
    pub d_off: __off_t,
    pub d_reclen: ::std::os::raw::c_ushort,
    pub d_type: ::std::os::raw::c_uchar,
    pub d_name: [::std::os::raw::c_char; 256usize],
}
impl Default for dirent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DT_UNKNOWN: _bindgen_ty_9 = 0;
pub const DT_FIFO: _bindgen_ty_9 = 1;
pub const DT_CHR: _bindgen_ty_9 = 2;
pub const DT_DIR: _bindgen_ty_9 = 4;
pub const DT_BLK: _bindgen_ty_9 = 6;
pub const DT_REG: _bindgen_ty_9 = 8;
pub const DT_LNK: _bindgen_ty_9 = 10;
pub const DT_SOCK: _bindgen_ty_9 = 12;
pub const DT_WHT: _bindgen_ty_9 = 14;
pub type _bindgen_ty_9 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __dirstream {
    _unused: [u8; 0],
}
pub type DIR = __dirstream;
pub type File = ::std::os::raw::c_int;
extern "C" {
    pub static mut max_files_per_process: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut data_sync_retry: bool;
}
extern "C" {
    pub static mut max_safe_fds: ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PathNameOpenFile(
        fileName: *const ::std::os::raw::c_char,
        fileFlags: ::std::os::raw::c_int,
    ) -> File;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PathNameOpenFilePerm(
        fileName: *const ::std::os::raw::c_char,
        fileFlags: ::std::os::raw::c_int,
        fileMode: mode_t,
    ) -> File;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OpenTemporaryFile(interXact: bool) -> File;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FileClose(file: File);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FilePrefetch(
        file: File,
        offset: off_t,
        amount: ::std::os::raw::c_int,
        wait_event_info: uint32,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FileRead(
        file: File,
        buffer: *mut ::std::os::raw::c_char,
        amount: ::std::os::raw::c_int,
        offset: off_t,
        wait_event_info: uint32,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FileWrite(
        file: File,
        buffer: *mut ::std::os::raw::c_char,
        amount: ::std::os::raw::c_int,
        offset: off_t,
        wait_event_info: uint32,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FileSync(file: File, wait_event_info: uint32) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FileSize(file: File) -> off_t;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FileTruncate(
        file: File,
        offset: off_t,
        wait_event_info: uint32,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FileWriteback(file: File, offset: off_t, nbytes: off_t, wait_event_info: uint32);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FilePathName(file: File) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FileGetRawDesc(file: File) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FileGetRawFlags(file: File) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FileGetRawMode(file: File) -> mode_t;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PathNameCreateTemporaryFile(
        name: *const ::std::os::raw::c_char,
        error_on_failure: bool,
    ) -> File;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PathNameOpenTemporaryFile(name: *const ::std::os::raw::c_char) -> File;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PathNameDeleteTemporaryFile(
        name: *const ::std::os::raw::c_char,
        error_on_failure: bool,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PathNameCreateTemporaryDir(
        base: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PathNameDeleteTemporaryDir(name: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TempTablespacePath(path: *mut ::std::os::raw::c_char, tablespace: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AllocateFile(
        name: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FreeFile(file: *mut FILE) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OpenPipeStream(
        command: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ClosePipeStream(file: *mut FILE) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AllocateDir(dirname: *const ::std::os::raw::c_char) -> *mut DIR;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ReadDir(dir: *mut DIR, dirname: *const ::std::os::raw::c_char) -> *mut dirent;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ReadDirExtended(
        dir: *mut DIR,
        dirname: *const ::std::os::raw::c_char,
        elevel: ::std::os::raw::c_int,
    ) -> *mut dirent;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FreeDir(dir: *mut DIR) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OpenTransientFile(
        fileName: *const ::std::os::raw::c_char,
        fileFlags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OpenTransientFilePerm(
        fileName: *const ::std::os::raw::c_char,
        fileFlags: ::std::os::raw::c_int,
        fileMode: mode_t,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CloseTransientFile(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BasicOpenFile(
        fileName: *const ::std::os::raw::c_char,
        fileFlags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BasicOpenFilePerm(
        fileName: *const ::std::os::raw::c_char,
        fileFlags: ::std::os::raw::c_int,
        fileMode: mode_t,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AcquireExternalFD() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ReserveExternalFD();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ReleaseExternalFD();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MakePGDirectory(directoryName: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitFileAccess();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn set_max_safe_fds();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn closeAllVfds();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SetTempTablespaces(tableSpaces: *mut Oid, numSpaces: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TempTablespacesAreSet() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetTempTablespaces(
        tableSpaces: *mut Oid,
        numSpaces: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetNextTempTableSpace() -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AtEOXact_Files(isCommit: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AtEOSubXact_Files(
        isCommit: bool,
        mySubid: SubTransactionId,
        parentSubid: SubTransactionId,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RemovePgTempFiles();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RemovePgTempFilesInDir(
        tmpdirname: *const ::std::os::raw::c_char,
        missing_ok: bool,
        unlink_all: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn looks_like_temp_rel_name(name: *const ::std::os::raw::c_char) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_fsync(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_fsync_no_writethrough(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_fsync_writethrough(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_fdatasync(fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_flush_data(fd: ::std::os::raw::c_int, offset: off_t, amount: off_t);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn fsync_fname(fname: *const ::std::os::raw::c_char, isdir: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn fsync_fname_ext(
        fname: *const ::std::os::raw::c_char,
        isdir: bool,
        ignore_perm: bool,
        elevel: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn durable_rename(
        oldfile: *const ::std::os::raw::c_char,
        newfile: *const ::std::os::raw::c_char,
        loglevel: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn durable_unlink(
        fname: *const ::std::os::raw::c_char,
        loglevel: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn durable_rename_excl(
        oldfile: *const ::std::os::raw::c_char,
        newfile: *const ::std::os::raw::c_char,
        loglevel: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SyncDataDirectory();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn data_sync_elevel(elevel: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SpinlockSemas() -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SpinlockSemaSize() -> Size;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedFileSet {
    pub creator_pid: pid_t,
    pub number: uint32,
    pub mutex: slock_t,
    pub refcnt: ::std::os::raw::c_int,
    pub ntablespaces: ::std::os::raw::c_int,
    pub tablespaces: [Oid; 8usize],
}
impl Default for SharedFileSet {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SharedFileSetInit(fileset: *mut SharedFileSet, seg: *mut dsm_segment);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SharedFileSetAttach(fileset: *mut SharedFileSet, seg: *mut dsm_segment);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SharedFileSetCreate(
        fileset: *mut SharedFileSet,
        name: *const ::std::os::raw::c_char,
    ) -> File;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SharedFileSetOpen(
        fileset: *mut SharedFileSet,
        name: *const ::std::os::raw::c_char,
    ) -> File;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SharedFileSetDelete(
        fileset: *mut SharedFileSet,
        name: *const ::std::os::raw::c_char,
        error_on_failure: bool,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SharedFileSetDeleteAll(fileset: *mut SharedFileSet);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedTuplestore {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedTuplestoreAccessor {
    _unused: [u8; 0],
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn sts_estimate(participants: ::std::os::raw::c_int) -> usize;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn sts_initialize(
        sts: *mut SharedTuplestore,
        participants: ::std::os::raw::c_int,
        my_participant_number: ::std::os::raw::c_int,
        meta_data_size: usize,
        flags: ::std::os::raw::c_int,
        fileset: *mut SharedFileSet,
        name: *const ::std::os::raw::c_char,
    ) -> *mut SharedTuplestoreAccessor;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn sts_attach(
        sts: *mut SharedTuplestore,
        my_participant_number: ::std::os::raw::c_int,
        fileset: *mut SharedFileSet,
    ) -> *mut SharedTuplestoreAccessor;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn sts_end_write(accessor: *mut SharedTuplestoreAccessor);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn sts_reinitialize(accessor: *mut SharedTuplestoreAccessor);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn sts_begin_parallel_scan(accessor: *mut SharedTuplestoreAccessor);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn sts_end_parallel_scan(accessor: *mut SharedTuplestoreAccessor);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn sts_puttuple(
        accessor: *mut SharedTuplestoreAccessor,
        meta_data: *mut ::std::os::raw::c_void,
        tuple: MinimalTuple,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn sts_parallel_scan_next(
        accessor: *mut SharedTuplestoreAccessor,
        meta_data: *mut ::std::os::raw::c_void,
    ) -> MinimalTuple;
}
pub type Timestamp = int64;
pub type TimestampTz = int64;
pub type TimeOffset = int64;
pub type fsec_t = int32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Interval {
    pub time: TimeOffset,
    pub day: int32,
    pub month: int32,
}
pub const SnapshotType_SNAPSHOT_MVCC: SnapshotType = 0;
pub const SnapshotType_SNAPSHOT_SELF: SnapshotType = 1;
pub const SnapshotType_SNAPSHOT_ANY: SnapshotType = 2;
pub const SnapshotType_SNAPSHOT_TOAST: SnapshotType = 3;
pub const SnapshotType_SNAPSHOT_DIRTY: SnapshotType = 4;
pub const SnapshotType_SNAPSHOT_HISTORIC_MVCC: SnapshotType = 5;
pub const SnapshotType_SNAPSHOT_NON_VACUUMABLE: SnapshotType = 6;
pub type SnapshotType = ::std::os::raw::c_uint;
pub type Snapshot = *mut SnapshotData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SnapshotData {
    pub snapshot_type: SnapshotType,
    pub xmin: TransactionId,
    pub xmax: TransactionId,
    pub xip: *mut TransactionId,
    pub xcnt: uint32,
    pub subxip: *mut TransactionId,
    pub subxcnt: int32,
    pub suboverflowed: bool,
    pub takenDuringRecovery: bool,
    pub copied: bool,
    pub curcid: CommandId,
    pub speculativeToken: uint32,
    pub active_count: uint32,
    pub regd_count: uint32,
    pub ph_node: pairingheap_node,
    pub whenTaken: TimestampTz,
    pub lsn: XLogRecPtr,
}
impl Default for SnapshotData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Relation = *mut RelationData;
pub type RelationPtr = *mut Relation;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationIdGetRelation(relationId: Oid) -> Relation;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationClose(relation: Relation);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationGetFKeyList(relation: Relation) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationGetIndexList(relation: Relation) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationGetStatExtList(relation: Relation) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationGetPrimaryKeyIndex(relation: Relation) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationGetReplicaIndex(relation: Relation) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationGetIndexExpressions(relation: Relation) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationGetDummyIndexExpressions(relation: Relation) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationGetIndexPredicate(relation: Relation) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationGetIndexRawAttOptions(relation: Relation) -> *mut Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationGetIndexAttOptions(relation: Relation, copy: bool) -> *mut *mut bytea;
}
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_ALL: IndexAttrBitmapKind = 0;
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_KEY: IndexAttrBitmapKind = 1;
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_PRIMARY_KEY: IndexAttrBitmapKind = 2;
pub const IndexAttrBitmapKind_INDEX_ATTR_BITMAP_IDENTITY_KEY: IndexAttrBitmapKind = 3;
pub type IndexAttrBitmapKind = ::std::os::raw::c_uint;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationGetIndexAttrBitmap(
        relation: Relation,
        attrKind: IndexAttrBitmapKind,
    ) -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationGetExclusionInfo(
        indexRelation: Relation,
        operators: *mut *mut Oid,
        procs: *mut *mut Oid,
        strategies: *mut *mut uint16,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationInitIndexAccessInfo(relation: Relation);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetRelationPublicationActions(relation: Relation) -> *mut PublicationActions;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationInitTableAccessMethod(relation: Relation);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn errtable(rel: Relation) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn errtablecol(rel: Relation, attnum: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn errtablecolname(
        rel: Relation,
        colname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn errtableconstraint(
        rel: Relation,
        conname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationCacheInitialize();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationCacheInitializePhase2();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationCacheInitializePhase3();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationBuildLocalRelation(
        relname: *const ::std::os::raw::c_char,
        relnamespace: Oid,
        tupDesc: TupleDesc,
        relid: Oid,
        accessmtd: Oid,
        relfilenode: Oid,
        reltablespace: Oid,
        shared_relation: bool,
        mapped_relation: bool,
        relpersistence: ::std::os::raw::c_char,
        relkind: ::std::os::raw::c_char,
    ) -> Relation;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationSetNewRelfilenode(relation: Relation, persistence: ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationAssumeNewRelfilenode(relation: Relation);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationForgetRelation(rid: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationCacheInvalidateEntry(relationId: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationCacheInvalidate(debug_discard: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationCloseSmgrByOid(relationId: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AssertPendingSyncs_RelationCache();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AtEOXact_RelationCache(isCommit: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AtEOSubXact_RelationCache(
        isCommit: bool,
        mySubid: SubTransactionId,
        parentSubid: SubTransactionId,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationIdIsInInitFile(relationId: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationCacheInitFilePreInvalidate();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationCacheInitFilePostInvalidate();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationCacheInitFileRemove();
}
extern "C" {
    pub static mut criticalRelcachesBuilt: bool;
}
extern "C" {
    pub static mut criticalSharedRelcachesBuilt: bool;
}
pub type SortSupport = *mut SortSupportData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortSupportData {
    pub ssup_cxt: MemoryContext,
    pub ssup_collation: Oid,
    pub ssup_reverse: bool,
    pub ssup_nulls_first: bool,
    pub ssup_attno: AttrNumber,
    pub ssup_extra: *mut ::std::os::raw::c_void,
    pub comparator: ::std::option::Option<
        unsafe extern "C" fn(x: Datum, y: Datum, ssup: SortSupport) -> ::std::os::raw::c_int,
    >,
    pub abbreviate: bool,
    pub abbrev_converter:
        ::std::option::Option<unsafe extern "C" fn(original: Datum, ssup: SortSupport) -> Datum>,
    pub abbrev_abort: ::std::option::Option<
        unsafe extern "C" fn(memtupcount: ::std::os::raw::c_int, ssup: SortSupport) -> bool,
    >,
    pub abbrev_full_comparator: ::std::option::Option<
        unsafe extern "C" fn(x: Datum, y: Datum, ssup: SortSupport) -> ::std::os::raw::c_int,
    >,
}
impl Default for SortSupportData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PrepareSortSupportComparisonShim(cmpFunc: Oid, ssup: SortSupport);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PrepareSortSupportFromOrderingOp(orderingOp: Oid, ssup: SortSupport);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PrepareSortSupportFromIndexRel(indexRel: Relation, strategy: int16, ssup: SortSupport);
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexTupleData {
    pub t_tid: ItemPointerData,
    pub t_info: ::std::os::raw::c_ushort,
}
pub type IndexTuple = *mut IndexTupleData;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexAttributeBitMapData {
    pub bits: [bits8; 4usize],
}
pub type IndexAttributeBitMap = *mut IndexAttributeBitMapData;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_form_tuple(
        tupleDescriptor: TupleDesc,
        values: *mut Datum,
        isnull: *mut bool,
    ) -> IndexTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn nocache_index_getattr(
        tup: IndexTuple,
        attnum: ::std::os::raw::c_int,
        tupleDesc: TupleDesc,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_deform_tuple(
        tup: IndexTuple,
        tupleDescriptor: TupleDesc,
        values: *mut Datum,
        isnull: *mut bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CopyIndexTuple(source: IndexTuple) -> IndexTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_truncate_tuple(
        sourceDescriptor: TupleDesc,
        source: IndexTuple,
        leavenatts: ::std::os::raw::c_int,
    ) -> IndexTuple;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Tuplesortstate {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Sharedsort {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortCoordinateData {
    pub isWorker: bool,
    pub nParticipants: ::std::os::raw::c_int,
    pub sharedsort: *mut Sharedsort,
}
impl Default for SortCoordinateData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type SortCoordinate = *mut SortCoordinateData;
pub const TuplesortMethod_SORT_TYPE_STILL_IN_PROGRESS: TuplesortMethod = 0;
pub const TuplesortMethod_SORT_TYPE_TOP_N_HEAPSORT: TuplesortMethod = 1;
pub const TuplesortMethod_SORT_TYPE_QUICKSORT: TuplesortMethod = 2;
pub const TuplesortMethod_SORT_TYPE_EXTERNAL_SORT: TuplesortMethod = 4;
pub const TuplesortMethod_SORT_TYPE_EXTERNAL_MERGE: TuplesortMethod = 8;
pub type TuplesortMethod = ::std::os::raw::c_uint;
pub const TuplesortSpaceType_SORT_SPACE_TYPE_DISK: TuplesortSpaceType = 0;
pub const TuplesortSpaceType_SORT_SPACE_TYPE_MEMORY: TuplesortSpaceType = 1;
pub type TuplesortSpaceType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TuplesortInstrumentation {
    pub sortMethod: TuplesortMethod,
    pub spaceType: TuplesortSpaceType,
    pub spaceUsed: int64,
}
impl Default for TuplesortInstrumentation {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_begin_heap(
        tupDesc: TupleDesc,
        nkeys: ::std::os::raw::c_int,
        attNums: *mut AttrNumber,
        sortOperators: *mut Oid,
        sortCollations: *mut Oid,
        nullsFirstFlags: *mut bool,
        workMem: ::std::os::raw::c_int,
        coordinate: SortCoordinate,
        randomAccess: bool,
    ) -> *mut Tuplesortstate;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_begin_cluster(
        tupDesc: TupleDesc,
        indexRel: Relation,
        workMem: ::std::os::raw::c_int,
        coordinate: SortCoordinate,
        randomAccess: bool,
    ) -> *mut Tuplesortstate;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_begin_index_btree(
        heapRel: Relation,
        indexRel: Relation,
        enforceUnique: bool,
        workMem: ::std::os::raw::c_int,
        coordinate: SortCoordinate,
        randomAccess: bool,
    ) -> *mut Tuplesortstate;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_begin_index_hash(
        heapRel: Relation,
        indexRel: Relation,
        high_mask: uint32,
        low_mask: uint32,
        max_buckets: uint32,
        workMem: ::std::os::raw::c_int,
        coordinate: SortCoordinate,
        randomAccess: bool,
    ) -> *mut Tuplesortstate;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_begin_datum(
        datumType: Oid,
        sortOperator: Oid,
        sortCollation: Oid,
        nullsFirstFlag: bool,
        workMem: ::std::os::raw::c_int,
        coordinate: SortCoordinate,
        randomAccess: bool,
    ) -> *mut Tuplesortstate;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_set_bound(state: *mut Tuplesortstate, bound: int64);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_used_bound(state: *mut Tuplesortstate) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_puttupleslot(state: *mut Tuplesortstate, slot: *mut TupleTableSlot);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_putheaptuple(state: *mut Tuplesortstate, tup: HeapTuple);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_putindextuplevalues(
        state: *mut Tuplesortstate,
        rel: Relation,
        self_: ItemPointer,
        values: *mut Datum,
        isnull: *mut bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_putdatum(state: *mut Tuplesortstate, val: Datum, isNull: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_performsort(state: *mut Tuplesortstate);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_gettupleslot(
        state: *mut Tuplesortstate,
        forward: bool,
        copy: bool,
        slot: *mut TupleTableSlot,
        abbrev: *mut Datum,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_getheaptuple(state: *mut Tuplesortstate, forward: bool) -> HeapTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_getindextuple(state: *mut Tuplesortstate, forward: bool) -> IndexTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_getdatum(
        state: *mut Tuplesortstate,
        forward: bool,
        val: *mut Datum,
        isNull: *mut bool,
        abbrev: *mut Datum,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_skiptuples(state: *mut Tuplesortstate, ntuples: int64, forward: bool) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_end(state: *mut Tuplesortstate);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_reset(state: *mut Tuplesortstate);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_get_stats(state: *mut Tuplesortstate, stats: *mut TuplesortInstrumentation);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_method_name(m: TuplesortMethod) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_space_type_name(t: TuplesortSpaceType) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_merge_order(allowedMem: int64) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_estimate_shared(nworkers: ::std::os::raw::c_int) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_initialize_shared(
        shared: *mut Sharedsort,
        nWorkers: ::std::os::raw::c_int,
        seg: *mut dsm_segment,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_attach_shared(shared: *mut Sharedsort, seg: *mut dsm_segment);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_rescan(state: *mut Tuplesortstate);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_markpos(state: *mut Tuplesortstate);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplesort_restorepos(state: *mut Tuplesortstate);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Tuplestorestate {
    _unused: [u8; 0],
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplestore_begin_heap(
        randomAccess: bool,
        interXact: bool,
        maxKBytes: ::std::os::raw::c_int,
    ) -> *mut Tuplestorestate;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplestore_set_eflags(state: *mut Tuplestorestate, eflags: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplestore_puttupleslot(state: *mut Tuplestorestate, slot: *mut TupleTableSlot);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplestore_puttuple(state: *mut Tuplestorestate, tuple: HeapTuple);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplestore_putvalues(
        state: *mut Tuplestorestate,
        tdesc: TupleDesc,
        values: *mut Datum,
        isnull: *mut bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplestore_alloc_read_pointer(
        state: *mut Tuplestorestate,
        eflags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplestore_select_read_pointer(state: *mut Tuplestorestate, ptr: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplestore_copy_read_pointer(
        state: *mut Tuplestorestate,
        srcptr: ::std::os::raw::c_int,
        destptr: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplestore_trim(state: *mut Tuplestorestate);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplestore_in_memory(state: *mut Tuplestorestate) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplestore_gettupleslot(
        state: *mut Tuplestorestate,
        forward: bool,
        copy: bool,
        slot: *mut TupleTableSlot,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplestore_advance(state: *mut Tuplestorestate, forward: bool) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplestore_skiptuples(
        state: *mut Tuplestorestate,
        ntuples: int64,
        forward: bool,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplestore_tuple_count(state: *mut Tuplestorestate) -> int64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplestore_ateof(state: *mut Tuplestorestate) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplestore_rescan(state: *mut Tuplestorestate);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplestore_clear(state: *mut Tuplestorestate);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplestore_end(state: *mut Tuplestorestate);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionRoutingInfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelHashJoinState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprEvalStep {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CopyMultiInsertBuffer {
    _unused: [u8; 0],
}
pub type ExprStateEvalFunc = ::std::option::Option<
    unsafe extern "C" fn(
        expression: *mut ExprState,
        econtext: *mut ExprContext,
        isNull: *mut bool,
    ) -> Datum,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprState {
    pub tag: NodeTag,
    pub flags: uint8,
    pub resnull: bool,
    pub resvalue: Datum,
    pub resultslot: *mut TupleTableSlot,
    pub steps: *mut ExprEvalStep,
    pub evalfunc: ExprStateEvalFunc,
    pub expr: *mut Expr,
    pub evalfunc_private: *mut ::std::os::raw::c_void,
    pub steps_len: ::std::os::raw::c_int,
    pub steps_alloc: ::std::os::raw::c_int,
    pub parent: *mut PlanState,
    pub ext_params: ParamListInfo,
    pub innermost_caseval: *mut Datum,
    pub innermost_casenull: *mut bool,
    pub innermost_domainval: *mut Datum,
    pub innermost_domainnull: *mut bool,
}
impl Default for ExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexInfo {
    pub type_: NodeTag,
    pub ii_NumIndexAttrs: ::std::os::raw::c_int,
    pub ii_NumIndexKeyAttrs: ::std::os::raw::c_int,
    pub ii_IndexAttrNumbers: [AttrNumber; 32usize],
    pub ii_Expressions: *mut List,
    pub ii_ExpressionsState: *mut List,
    pub ii_Predicate: *mut List,
    pub ii_PredicateState: *mut ExprState,
    pub ii_ExclusionOps: *mut Oid,
    pub ii_ExclusionProcs: *mut Oid,
    pub ii_ExclusionStrats: *mut uint16,
    pub ii_UniqueOps: *mut Oid,
    pub ii_UniqueProcs: *mut Oid,
    pub ii_UniqueStrats: *mut uint16,
    pub ii_OpclassOptions: *mut Datum,
    pub ii_Unique: bool,
    pub ii_ReadyForInserts: bool,
    pub ii_Concurrent: bool,
    pub ii_BrokenHotChain: bool,
    pub ii_ParallelWorkers: ::std::os::raw::c_int,
    pub ii_Am: Oid,
    pub ii_AmCache: *mut ::std::os::raw::c_void,
    pub ii_Context: MemoryContext,
}
impl Default for IndexInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ExprContextCallbackFunction = ::std::option::Option<unsafe extern "C" fn(arg: Datum)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprContext_CB {
    pub next: *mut ExprContext_CB,
    pub function: ExprContextCallbackFunction,
    pub arg: Datum,
}
impl Default for ExprContext_CB {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExprContext {
    pub type_: NodeTag,
    pub ecxt_scantuple: *mut TupleTableSlot,
    pub ecxt_innertuple: *mut TupleTableSlot,
    pub ecxt_outertuple: *mut TupleTableSlot,
    pub ecxt_per_query_memory: MemoryContext,
    pub ecxt_per_tuple_memory: MemoryContext,
    pub ecxt_param_exec_vals: *mut ParamExecData,
    pub ecxt_param_list_info: ParamListInfo,
    pub ecxt_aggvalues: *mut Datum,
    pub ecxt_aggnulls: *mut bool,
    pub caseValue_datum: Datum,
    pub caseValue_isNull: bool,
    pub domainValue_datum: Datum,
    pub domainValue_isNull: bool,
    pub ecxt_estate: *mut EState,
    pub ecxt_callbacks: *mut ExprContext_CB,
}
impl Default for ExprContext {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ExprDoneCond_ExprSingleResult: ExprDoneCond = 0;
pub const ExprDoneCond_ExprMultipleResult: ExprDoneCond = 1;
pub const ExprDoneCond_ExprEndResult: ExprDoneCond = 2;
pub type ExprDoneCond = ::std::os::raw::c_uint;
pub const SetFunctionReturnMode_SFRM_ValuePerCall: SetFunctionReturnMode = 1;
pub const SetFunctionReturnMode_SFRM_Materialize: SetFunctionReturnMode = 2;
pub const SetFunctionReturnMode_SFRM_Materialize_Random: SetFunctionReturnMode = 4;
pub const SetFunctionReturnMode_SFRM_Materialize_Preferred: SetFunctionReturnMode = 8;
pub type SetFunctionReturnMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReturnSetInfo {
    pub type_: NodeTag,
    pub econtext: *mut ExprContext,
    pub expectedDesc: TupleDesc,
    pub allowedModes: ::std::os::raw::c_int,
    pub returnMode: SetFunctionReturnMode,
    pub isDone: ExprDoneCond,
    pub setResult: *mut Tuplestorestate,
    pub setDesc: TupleDesc,
}
impl Default for ReturnSetInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectionInfo {
    pub type_: NodeTag,
    pub pi_state: ExprState,
    pub pi_exprContext: *mut ExprContext,
}
impl Default for ProjectionInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JunkFilter {
    pub type_: NodeTag,
    pub jf_targetList: *mut List,
    pub jf_cleanTupType: TupleDesc,
    pub jf_cleanMap: *mut AttrNumber,
    pub jf_resultSlot: *mut TupleTableSlot,
    pub jf_junkAttNo: AttrNumber,
}
impl Default for JunkFilter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnConflictSetState {
    pub type_: NodeTag,
    pub oc_Existing: *mut TupleTableSlot,
    pub oc_ProjSlot: *mut TupleTableSlot,
    pub oc_ProjInfo: *mut ProjectionInfo,
    pub oc_WhereClause: *mut ExprState,
}
impl Default for OnConflictSetState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResultRelInfo {
    pub type_: NodeTag,
    pub ri_RangeTableIndex: Index,
    pub ri_RelationDesc: Relation,
    pub ri_NumIndices: ::std::os::raw::c_int,
    pub ri_IndexRelationDescs: RelationPtr,
    pub ri_IndexRelationInfo: *mut *mut IndexInfo,
    pub ri_TrigDesc: *mut TriggerDesc,
    pub ri_TrigFunctions: *mut FmgrInfo,
    pub ri_TrigWhenExprs: *mut *mut ExprState,
    pub ri_TrigInstrument: *mut Instrumentation,
    pub ri_ReturningSlot: *mut TupleTableSlot,
    pub ri_TrigOldSlot: *mut TupleTableSlot,
    pub ri_TrigNewSlot: *mut TupleTableSlot,
    pub ri_FdwRoutine: *mut FdwRoutine,
    pub ri_FdwState: *mut ::std::os::raw::c_void,
    pub ri_usesFdwDirectModify: bool,
    pub ri_WithCheckOptions: *mut List,
    pub ri_WithCheckOptionExprs: *mut List,
    pub ri_ConstraintExprs: *mut *mut ExprState,
    pub ri_GeneratedExprs: *mut *mut ExprState,
    pub ri_NumGeneratedNeeded: ::std::os::raw::c_int,
    pub ri_junkFilter: *mut JunkFilter,
    pub ri_returningList: *mut List,
    pub ri_projectReturning: *mut ProjectionInfo,
    pub ri_onConflictArbiterIndexes: *mut List,
    pub ri_onConflict: *mut OnConflictSetState,
    pub ri_PartitionCheck: *mut List,
    pub ri_PartitionCheckExpr: *mut ExprState,
    pub ri_RootResultRelInfo: *mut ResultRelInfo,
    pub ri_PartitionInfo: *mut PartitionRoutingInfo,
    pub ri_CopyMultiInsertBuffer: *mut CopyMultiInsertBuffer,
}
impl Default for ResultRelInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResultRelInfoExtra {
    pub rinfo: *mut ResultRelInfo,
    pub ri_extraUpdatedCols: *mut Bitmapset,
}
impl Default for ResultRelInfoExtra {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EState {
    pub type_: NodeTag,
    pub es_direction: ScanDirection,
    pub es_snapshot: Snapshot,
    pub es_crosscheck_snapshot: Snapshot,
    pub es_range_table: *mut List,
    pub es_range_table_size: Index,
    pub es_relations: *mut Relation,
    pub es_rowmarks: *mut *mut ExecRowMark,
    pub es_plannedstmt: *mut PlannedStmt,
    pub es_sourceText: *const ::std::os::raw::c_char,
    pub es_junkFilter: *mut JunkFilter,
    pub es_output_cid: CommandId,
    pub es_result_relations: *mut ResultRelInfo,
    pub es_num_result_relations: ::std::os::raw::c_int,
    pub es_result_relation_info: *mut ResultRelInfo,
    pub es_root_result_relations: *mut ResultRelInfo,
    pub es_num_root_result_relations: ::std::os::raw::c_int,
    pub es_partition_directory: PartitionDirectory,
    pub es_tuple_routing_result_relations: *mut List,
    pub es_trig_target_relations: *mut List,
    pub es_param_list_info: ParamListInfo,
    pub es_param_exec_vals: *mut ParamExecData,
    pub es_queryEnv: *mut QueryEnvironment,
    pub es_query_cxt: MemoryContext,
    pub es_tupleTable: *mut List,
    pub es_processed: uint64,
    pub es_top_eflags: ::std::os::raw::c_int,
    pub es_instrument: ::std::os::raw::c_int,
    pub es_finished: bool,
    pub es_exprcontexts: *mut List,
    pub es_subplanstates: *mut List,
    pub es_auxmodifytables: *mut List,
    pub es_per_tuple_exprcontext: *mut ExprContext,
    pub es_epq_active: *mut EPQState,
    pub es_use_parallel_mode: bool,
    pub es_query_dsa: *mut dsa_area,
    pub es_jit_flags: ::std::os::raw::c_int,
    pub es_jit: *mut JitContext,
    pub es_jit_worker_instr: *mut JitInstrumentation,
    pub es_resultrelinfo_extra: *mut List,
}
impl Default for EState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExecRowMark {
    pub relation: Relation,
    pub relid: Oid,
    pub rti: Index,
    pub prti: Index,
    pub rowmarkId: Index,
    pub markType: RowMarkType,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
    pub ermActive: bool,
    pub curCtid: ItemPointerData,
    pub ermExtra: *mut ::std::os::raw::c_void,
}
impl Default for ExecRowMark {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExecAuxRowMark {
    pub rowmark: *mut ExecRowMark,
    pub ctidAttNo: AttrNumber,
    pub toidAttNo: AttrNumber,
    pub wholeAttNo: AttrNumber,
}
impl Default for ExecAuxRowMark {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleHashEntry = *mut TupleHashEntryData;
pub type TupleHashTable = *mut TupleHashTableData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleHashEntryData {
    pub firstTuple: MinimalTuple,
    pub additional: *mut ::std::os::raw::c_void,
    pub status: uint32,
    pub hash: uint32,
}
impl Default for TupleHashEntryData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static pg_leftmost_one_pos: [uint8; 256usize];
}
extern "C" {
    pub static pg_rightmost_one_pos: [uint8; 256usize];
}
extern "C" {
    pub static pg_number_of_ones: [uint8; 256usize];
}
extern "C" {
    pub static mut pg_popcount32:
        ::std::option::Option<unsafe extern "C" fn(word: uint32) -> ::std::os::raw::c_int>;
}
extern "C" {
    pub static mut pg_popcount64:
        ::std::option::Option<unsafe extern "C" fn(word: uint64) -> ::std::os::raw::c_int>;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_popcount(buf: *const ::std::os::raw::c_char, bytes: ::std::os::raw::c_int) -> uint64;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tuplehash_hash {
    pub size: uint64,
    pub members: uint32,
    pub sizemask: uint32,
    pub grow_threshold: uint32,
    pub data: *mut TupleHashEntryData,
    pub ctx: MemoryContext,
    pub private_data: *mut ::std::os::raw::c_void,
}
impl Default for tuplehash_hash {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const tuplehash_status_tuplehash_SH_EMPTY: tuplehash_status = 0;
pub const tuplehash_status_tuplehash_SH_IN_USE: tuplehash_status = 1;
pub type tuplehash_status = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct tuplehash_iterator {
    pub cur: uint32,
    pub end: uint32,
    pub done: bool,
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplehash_create(
        ctx: MemoryContext,
        nelements: uint32,
        private_data: *mut ::std::os::raw::c_void,
    ) -> *mut tuplehash_hash;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplehash_destroy(tb: *mut tuplehash_hash);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplehash_reset(tb: *mut tuplehash_hash);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplehash_grow(tb: *mut tuplehash_hash, newsize: uint64);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplehash_insert(
        tb: *mut tuplehash_hash,
        key: MinimalTuple,
        found: *mut bool,
    ) -> *mut TupleHashEntryData;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplehash_insert_hash(
        tb: *mut tuplehash_hash,
        key: MinimalTuple,
        hash: uint32,
        found: *mut bool,
    ) -> *mut TupleHashEntryData;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplehash_lookup(tb: *mut tuplehash_hash, key: MinimalTuple) -> *mut TupleHashEntryData;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplehash_lookup_hash(
        tb: *mut tuplehash_hash,
        key: MinimalTuple,
        hash: uint32,
    ) -> *mut TupleHashEntryData;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplehash_delete(tb: *mut tuplehash_hash, key: MinimalTuple) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplehash_start_iterate(tb: *mut tuplehash_hash, iter: *mut tuplehash_iterator);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplehash_start_iterate_at(
        tb: *mut tuplehash_hash,
        iter: *mut tuplehash_iterator,
        at: uint32,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplehash_iterate(
        tb: *mut tuplehash_hash,
        iter: *mut tuplehash_iterator,
    ) -> *mut TupleHashEntryData;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tuplehash_stat(tb: *mut tuplehash_hash);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupleHashTableData {
    pub hashtab: *mut tuplehash_hash,
    pub numCols: ::std::os::raw::c_int,
    pub keyColIdx: *mut AttrNumber,
    pub tab_hash_funcs: *mut FmgrInfo,
    pub tab_eq_func: *mut ExprState,
    pub tab_collations: *mut Oid,
    pub tablecxt: MemoryContext,
    pub tempcxt: MemoryContext,
    pub entrysize: Size,
    pub tableslot: *mut TupleTableSlot,
    pub inputslot: *mut TupleTableSlot,
    pub in_hash_funcs: *mut FmgrInfo,
    pub cur_eq_func: *mut ExprState,
    pub hash_iv: uint32,
    pub exprcontext: *mut ExprContext,
}
impl Default for TupleHashTableData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TupleHashIterator = tuplehash_iterator;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggrefExprState {
    pub type_: NodeTag,
    pub aggref: *mut Aggref,
    pub aggno: ::std::os::raw::c_int,
}
impl Default for AggrefExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowFuncExprState {
    pub type_: NodeTag,
    pub wfunc: *mut WindowFunc,
    pub args: *mut List,
    pub aggfilter: *mut ExprState,
    pub wfuncno: ::std::os::raw::c_int,
}
impl Default for WindowFuncExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetExprState {
    pub type_: NodeTag,
    pub expr: *mut Expr,
    pub args: *mut List,
    pub elidedFuncState: *mut ExprState,
    pub func: FmgrInfo,
    pub funcResultStore: *mut Tuplestorestate,
    pub funcResultSlot: *mut TupleTableSlot,
    pub funcResultDesc: TupleDesc,
    pub funcReturnsTuple: bool,
    pub funcReturnsSet: bool,
    pub setArgsValid: bool,
    pub shutdown_reg: bool,
    pub fcinfo: FunctionCallInfo,
}
impl Default for SetExprState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubPlanState {
    pub type_: NodeTag,
    pub subplan: *mut SubPlan,
    pub planstate: *mut PlanState,
    pub parent: *mut PlanState,
    pub testexpr: *mut ExprState,
    pub args: *mut List,
    pub curTuple: HeapTuple,
    pub curArray: Datum,
    pub descRight: TupleDesc,
    pub projLeft: *mut ProjectionInfo,
    pub projRight: *mut ProjectionInfo,
    pub hashtable: TupleHashTable,
    pub hashnulls: TupleHashTable,
    pub havehashrows: bool,
    pub havenullrows: bool,
    pub hashtablecxt: MemoryContext,
    pub hashtempcxt: MemoryContext,
    pub innerecontext: *mut ExprContext,
    pub numCols: ::std::os::raw::c_int,
    pub keyColIdx: *mut AttrNumber,
    pub tab_eq_funcoids: *mut Oid,
    pub tab_collations: *mut Oid,
    pub tab_hash_funcs: *mut FmgrInfo,
    pub tab_eq_funcs: *mut FmgrInfo,
    pub lhs_hash_funcs: *mut FmgrInfo,
    pub cur_eq_funcs: *mut FmgrInfo,
    pub cur_eq_comp: *mut ExprState,
}
impl Default for SubPlanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlternativeSubPlanState {
    pub type_: NodeTag,
    pub subplan: *mut AlternativeSubPlan,
    pub subplans: *mut List,
    pub active: ::std::os::raw::c_int,
}
impl Default for AlternativeSubPlanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DomainConstraintType_DOM_CONSTRAINT_NOTNULL: DomainConstraintType = 0;
pub const DomainConstraintType_DOM_CONSTRAINT_CHECK: DomainConstraintType = 1;
pub type DomainConstraintType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DomainConstraintState {
    pub type_: NodeTag,
    pub constrainttype: DomainConstraintType,
    pub name: *mut ::std::os::raw::c_char,
    pub check_expr: *mut Expr,
    pub check_exprstate: *mut ExprState,
}
impl Default for DomainConstraintState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ExecProcNodeMtd =
    ::std::option::Option<unsafe extern "C" fn(pstate: *mut PlanState) -> *mut TupleTableSlot>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlanState {
    pub type_: NodeTag,
    pub plan: *mut Plan,
    pub state: *mut EState,
    pub ExecProcNode: ExecProcNodeMtd,
    pub ExecProcNodeReal: ExecProcNodeMtd,
    pub instrument: *mut Instrumentation,
    pub worker_instrument: *mut WorkerInstrumentation,
    pub worker_jit_instrument: *mut SharedJitInstrumentation,
    pub qual: *mut ExprState,
    pub lefttree: *mut PlanState,
    pub righttree: *mut PlanState,
    pub initPlan: *mut List,
    pub subPlan: *mut List,
    pub chgParam: *mut Bitmapset,
    pub ps_ResultTupleDesc: TupleDesc,
    pub ps_ResultTupleSlot: *mut TupleTableSlot,
    pub ps_ExprContext: *mut ExprContext,
    pub ps_ProjInfo: *mut ProjectionInfo,
    pub scandesc: TupleDesc,
    pub scanops: *const TupleTableSlotOps,
    pub outerops: *const TupleTableSlotOps,
    pub innerops: *const TupleTableSlotOps,
    pub resultops: *const TupleTableSlotOps,
    pub scanopsfixed: bool,
    pub outeropsfixed: bool,
    pub inneropsfixed: bool,
    pub resultopsfixed: bool,
    pub scanopsset: bool,
    pub outeropsset: bool,
    pub inneropsset: bool,
    pub resultopsset: bool,
}
impl Default for PlanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EPQState {
    pub parentestate: *mut EState,
    pub epqParam: ::std::os::raw::c_int,
    pub tuple_table: *mut List,
    pub relsubs_slot: *mut *mut TupleTableSlot,
    pub plan: *mut Plan,
    pub arowMarks: *mut List,
    pub origslot: *mut TupleTableSlot,
    pub recheckestate: *mut EState,
    pub relsubs_rowmark: *mut *mut ExecAuxRowMark,
    pub relsubs_done: *mut bool,
    pub recheckplanstate: *mut PlanState,
}
impl Default for EPQState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResultState {
    pub ps: PlanState,
    pub resconstantqual: *mut ExprState,
    pub rs_done: bool,
    pub rs_checkqual: bool,
}
impl Default for ResultState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ProjectSetState {
    pub ps: PlanState,
    pub elems: *mut *mut Node,
    pub elemdone: *mut ExprDoneCond,
    pub nelems: ::std::os::raw::c_int,
    pub pending_srf_tuples: bool,
    pub argcontext: MemoryContext,
}
impl Default for ProjectSetState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ModifyTableState {
    pub ps: PlanState,
    pub operation: CmdType,
    pub canSetTag: bool,
    pub mt_done: bool,
    pub mt_plans: *mut *mut PlanState,
    pub mt_nplans: ::std::os::raw::c_int,
    pub mt_whichplan: ::std::os::raw::c_int,
    pub mt_scans: *mut *mut TupleTableSlot,
    pub resultRelInfo: *mut ResultRelInfo,
    pub rootResultRelInfo: *mut ResultRelInfo,
    pub mt_arowmarks: *mut *mut List,
    pub mt_epqstate: EPQState,
    pub fireBSTriggers: bool,
    pub mt_root_tuple_slot: *mut TupleTableSlot,
    pub mt_partition_tuple_routing: *mut PartitionTupleRouting,
    pub mt_transition_capture: *mut TransitionCaptureState,
    pub mt_oc_transition_capture: *mut TransitionCaptureState,
    pub mt_per_subplan_tupconv_maps: *mut *mut TupleConversionMap,
}
impl Default for ModifyTableState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelAppendState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionPruneState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AppendState {
    pub ps: PlanState,
    pub appendplans: *mut *mut PlanState,
    pub as_nplans: ::std::os::raw::c_int,
    pub as_whichplan: ::std::os::raw::c_int,
    pub as_first_partial_plan: ::std::os::raw::c_int,
    pub as_pstate: *mut ParallelAppendState,
    pub pstate_len: Size,
    pub as_prune_state: *mut PartitionPruneState,
    pub as_valid_subplans: *mut Bitmapset,
    pub choose_next_subplan:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut AppendState) -> bool>,
}
impl Default for AppendState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeAppendState {
    pub ps: PlanState,
    pub mergeplans: *mut *mut PlanState,
    pub ms_nplans: ::std::os::raw::c_int,
    pub ms_nkeys: ::std::os::raw::c_int,
    pub ms_sortkeys: SortSupport,
    pub ms_slots: *mut *mut TupleTableSlot,
    pub ms_heap: *mut binaryheap,
    pub ms_initialized: bool,
    pub ms_prune_state: *mut PartitionPruneState,
    pub ms_valid_subplans: *mut Bitmapset,
}
impl Default for MergeAppendState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RecursiveUnionState {
    pub ps: PlanState,
    pub recursing: bool,
    pub intermediate_empty: bool,
    pub working_table: *mut Tuplestorestate,
    pub intermediate_table: *mut Tuplestorestate,
    pub eqfuncoids: *mut Oid,
    pub hashfunctions: *mut FmgrInfo,
    pub tempContext: MemoryContext,
    pub hashtable: TupleHashTable,
    pub tableContext: MemoryContext,
}
impl Default for RecursiveUnionState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapAndState {
    pub ps: PlanState,
    pub bitmapplans: *mut *mut PlanState,
    pub nplans: ::std::os::raw::c_int,
}
impl Default for BitmapAndState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapOrState {
    pub ps: PlanState,
    pub bitmapplans: *mut *mut PlanState,
    pub nplans: ::std::os::raw::c_int,
}
impl Default for BitmapOrState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScanState {
    pub ps: PlanState,
    pub ss_currentRelation: Relation,
    pub ss_currentScanDesc: *mut TableScanDescData,
    pub ss_ScanTupleSlot: *mut TupleTableSlot,
}
impl Default for ScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SeqScanState {
    pub ss: ScanState,
    pub pscan_len: Size,
}
impl Default for SeqScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SampleScanState {
    pub ss: ScanState,
    pub args: *mut List,
    pub repeatable: *mut ExprState,
    pub tsmroutine: *mut TsmRoutine,
    pub tsm_state: *mut ::std::os::raw::c_void,
    pub use_bulkread: bool,
    pub use_pagemode: bool,
    pub begun: bool,
    pub seed: uint32,
    pub donetuples: int64,
    pub haveblock: bool,
    pub done: bool,
}
impl Default for SampleScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexRuntimeKeyInfo {
    pub scan_key: *mut ScanKeyData,
    pub key_expr: *mut ExprState,
    pub key_toastable: bool,
}
impl Default for IndexRuntimeKeyInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexArrayKeyInfo {
    pub scan_key: *mut ScanKeyData,
    pub array_expr: *mut ExprState,
    pub next_elem: ::std::os::raw::c_int,
    pub num_elems: ::std::os::raw::c_int,
    pub elem_values: *mut Datum,
    pub elem_nulls: *mut bool,
}
impl Default for IndexArrayKeyInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexScanState {
    pub ss: ScanState,
    pub indexqualorig: *mut ExprState,
    pub indexorderbyorig: *mut List,
    pub iss_ScanKeys: *mut ScanKeyData,
    pub iss_NumScanKeys: ::std::os::raw::c_int,
    pub iss_OrderByKeys: *mut ScanKeyData,
    pub iss_NumOrderByKeys: ::std::os::raw::c_int,
    pub iss_RuntimeKeys: *mut IndexRuntimeKeyInfo,
    pub iss_NumRuntimeKeys: ::std::os::raw::c_int,
    pub iss_RuntimeKeysReady: bool,
    pub iss_RuntimeContext: *mut ExprContext,
    pub iss_RelationDesc: Relation,
    pub iss_ScanDesc: *mut IndexScanDescData,
    pub iss_ReorderQueue: *mut pairingheap,
    pub iss_ReachedEnd: bool,
    pub iss_OrderByValues: *mut Datum,
    pub iss_OrderByNulls: *mut bool,
    pub iss_SortSupport: SortSupport,
    pub iss_OrderByTypByVals: *mut bool,
    pub iss_OrderByTypLens: *mut int16,
    pub iss_PscanLen: Size,
}
impl Default for IndexScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexOnlyScanState {
    pub ss: ScanState,
    pub recheckqual: *mut ExprState,
    pub ioss_ScanKeys: *mut ScanKeyData,
    pub ioss_NumScanKeys: ::std::os::raw::c_int,
    pub ioss_OrderByKeys: *mut ScanKeyData,
    pub ioss_NumOrderByKeys: ::std::os::raw::c_int,
    pub ioss_RuntimeKeys: *mut IndexRuntimeKeyInfo,
    pub ioss_NumRuntimeKeys: ::std::os::raw::c_int,
    pub ioss_RuntimeKeysReady: bool,
    pub ioss_RuntimeContext: *mut ExprContext,
    pub ioss_RelationDesc: Relation,
    pub ioss_ScanDesc: *mut IndexScanDescData,
    pub ioss_TableSlot: *mut TupleTableSlot,
    pub ioss_VMBuffer: Buffer,
    pub ioss_PscanLen: Size,
}
impl Default for IndexOnlyScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapIndexScanState {
    pub ss: ScanState,
    pub biss_result: *mut TIDBitmap,
    pub biss_ScanKeys: *mut ScanKeyData,
    pub biss_NumScanKeys: ::std::os::raw::c_int,
    pub biss_RuntimeKeys: *mut IndexRuntimeKeyInfo,
    pub biss_NumRuntimeKeys: ::std::os::raw::c_int,
    pub biss_ArrayKeys: *mut IndexArrayKeyInfo,
    pub biss_NumArrayKeys: ::std::os::raw::c_int,
    pub biss_RuntimeKeysReady: bool,
    pub biss_RuntimeContext: *mut ExprContext,
    pub biss_RelationDesc: Relation,
    pub biss_ScanDesc: *mut IndexScanDescData,
}
impl Default for BitmapIndexScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SharedBitmapState_BM_INITIAL: SharedBitmapState = 0;
pub const SharedBitmapState_BM_INPROGRESS: SharedBitmapState = 1;
pub const SharedBitmapState_BM_FINISHED: SharedBitmapState = 2;
pub type SharedBitmapState = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct ParallelBitmapHeapState {
    pub tbmiterator: dsa_pointer,
    pub prefetch_iterator: dsa_pointer,
    pub mutex: slock_t,
    pub prefetch_pages: ::std::os::raw::c_int,
    pub prefetch_target: ::std::os::raw::c_int,
    pub state: SharedBitmapState,
    pub cv: ConditionVariable,
    pub phs_snapshot_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
impl Default for ParallelBitmapHeapState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BitmapHeapScanState {
    pub ss: ScanState,
    pub bitmapqualorig: *mut ExprState,
    pub tbm: *mut TIDBitmap,
    pub tbmiterator: *mut TBMIterator,
    pub tbmres: *mut TBMIterateResult,
    pub can_skip_fetch: bool,
    pub return_empty_tuples: ::std::os::raw::c_int,
    pub vmbuffer: Buffer,
    pub pvmbuffer: Buffer,
    pub exact_pages: ::std::os::raw::c_long,
    pub lossy_pages: ::std::os::raw::c_long,
    pub prefetch_iterator: *mut TBMIterator,
    pub prefetch_pages: ::std::os::raw::c_int,
    pub prefetch_target: ::std::os::raw::c_int,
    pub prefetch_maximum: ::std::os::raw::c_int,
    pub pscan_len: Size,
    pub initialized: bool,
    pub shared_tbmiterator: *mut TBMSharedIterator,
    pub shared_prefetch_iterator: *mut TBMSharedIterator,
    pub pstate: *mut ParallelBitmapHeapState,
}
impl Default for BitmapHeapScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TidScanState {
    pub ss: ScanState,
    pub tss_tidexprs: *mut List,
    pub tss_isCurrentOf: bool,
    pub tss_NumTids: ::std::os::raw::c_int,
    pub tss_TidPtr: ::std::os::raw::c_int,
    pub tss_TidList: *mut ItemPointerData,
    pub tss_htup: HeapTupleData,
}
impl Default for TidScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubqueryScanState {
    pub ss: ScanState,
    pub subplan: *mut PlanState,
}
impl Default for SubqueryScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionScanPerFuncState {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionScanState {
    pub ss: ScanState,
    pub eflags: ::std::os::raw::c_int,
    pub ordinality: bool,
    pub simple: bool,
    pub ordinal: int64,
    pub nfuncs: ::std::os::raw::c_int,
    pub funcstates: *mut FunctionScanPerFuncState,
    pub argcontext: MemoryContext,
}
impl Default for FunctionScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ValuesScanState {
    pub ss: ScanState,
    pub rowcontext: *mut ExprContext,
    pub exprlists: *mut *mut List,
    pub exprstatelists: *mut *mut List,
    pub array_len: ::std::os::raw::c_int,
    pub curr_idx: ::std::os::raw::c_int,
}
impl Default for ValuesScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableFuncScanState {
    pub ss: ScanState,
    pub docexpr: *mut ExprState,
    pub rowexpr: *mut ExprState,
    pub colexprs: *mut List,
    pub coldefexprs: *mut List,
    pub ns_names: *mut List,
    pub ns_uris: *mut List,
    pub notnulls: *mut Bitmapset,
    pub opaque: *mut ::std::os::raw::c_void,
    pub routine: *mut TableFuncRoutine,
    pub in_functions: *mut FmgrInfo,
    pub typioparams: *mut Oid,
    pub ordinal: int64,
    pub perTableCxt: MemoryContext,
    pub tupstore: *mut Tuplestorestate,
}
impl Default for TableFuncScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CteScanState {
    pub ss: ScanState,
    pub eflags: ::std::os::raw::c_int,
    pub readptr: ::std::os::raw::c_int,
    pub cteplanstate: *mut PlanState,
    pub leader: *mut CteScanState,
    pub cte_table: *mut Tuplestorestate,
    pub eof_cte: bool,
}
impl Default for CteScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedTuplestoreScanState {
    pub ss: ScanState,
    pub readptr: ::std::os::raw::c_int,
    pub tupdesc: TupleDesc,
    pub relation: *mut Tuplestorestate,
}
impl Default for NamedTuplestoreScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WorkTableScanState {
    pub ss: ScanState,
    pub rustate: *mut RecursiveUnionState,
}
impl Default for WorkTableScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignScanState {
    pub ss: ScanState,
    pub fdw_recheck_quals: *mut ExprState,
    pub pscan_len: Size,
    pub fdwroutine: *mut FdwRoutine,
    pub fdw_state: *mut ::std::os::raw::c_void,
}
impl Default for ForeignScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CustomScanState {
    pub ss: ScanState,
    pub flags: uint32,
    pub custom_ps: *mut List,
    pub pscan_len: Size,
    pub methods: *const CustomExecMethods,
}
impl Default for CustomScanState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct JoinState {
    pub ps: PlanState,
    pub jointype: JoinType,
    pub single_match: bool,
    pub joinqual: *mut ExprState,
}
impl Default for JoinState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NestLoopState {
    pub js: JoinState,
    pub nl_NeedNewOuter: bool,
    pub nl_MatchedOuter: bool,
    pub nl_NullInnerTupleSlot: *mut TupleTableSlot,
}
impl Default for NestLoopState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeJoinClauseData {
    _unused: [u8; 0],
}
pub type MergeJoinClause = *mut MergeJoinClauseData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MergeJoinState {
    pub js: JoinState,
    pub mj_NumClauses: ::std::os::raw::c_int,
    pub mj_Clauses: MergeJoinClause,
    pub mj_JoinState: ::std::os::raw::c_int,
    pub mj_SkipMarkRestore: bool,
    pub mj_ExtraMarks: bool,
    pub mj_ConstFalseJoin: bool,
    pub mj_FillOuter: bool,
    pub mj_FillInner: bool,
    pub mj_MatchedOuter: bool,
    pub mj_MatchedInner: bool,
    pub mj_OuterTupleSlot: *mut TupleTableSlot,
    pub mj_InnerTupleSlot: *mut TupleTableSlot,
    pub mj_MarkedTupleSlot: *mut TupleTableSlot,
    pub mj_NullOuterTupleSlot: *mut TupleTableSlot,
    pub mj_NullInnerTupleSlot: *mut TupleTableSlot,
    pub mj_OuterEContext: *mut ExprContext,
    pub mj_InnerEContext: *mut ExprContext,
}
impl Default for MergeJoinState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoinTupleData {
    _unused: [u8; 0],
}
pub type HashJoinTuple = *mut HashJoinTupleData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoinTableData {
    _unused: [u8; 0],
}
pub type HashJoinTable = *mut HashJoinTableData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashJoinState {
    pub js: JoinState,
    pub hashclauses: *mut ExprState,
    pub hj_OuterHashKeys: *mut List,
    pub hj_HashOperators: *mut List,
    pub hj_Collations: *mut List,
    pub hj_HashTable: HashJoinTable,
    pub hj_CurHashValue: uint32,
    pub hj_CurBucketNo: ::std::os::raw::c_int,
    pub hj_CurSkewBucketNo: ::std::os::raw::c_int,
    pub hj_CurTuple: HashJoinTuple,
    pub hj_OuterTupleSlot: *mut TupleTableSlot,
    pub hj_HashTupleSlot: *mut TupleTableSlot,
    pub hj_NullOuterTupleSlot: *mut TupleTableSlot,
    pub hj_NullInnerTupleSlot: *mut TupleTableSlot,
    pub hj_FirstOuterTupleSlot: *mut TupleTableSlot,
    pub hj_JoinState: ::std::os::raw::c_int,
    pub hj_MatchedOuter: bool,
    pub hj_OuterNotEmpty: bool,
}
impl Default for HashJoinState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MaterialState {
    pub ss: ScanState,
    pub eflags: ::std::os::raw::c_int,
    pub eof_underlying: bool,
    pub tuplestorestate: *mut Tuplestorestate,
}
impl Default for MaterialState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PresortedKeyData {
    pub flinfo: FmgrInfo,
    pub fcinfo: FunctionCallInfo,
    pub attno: OffsetNumber,
}
impl Default for PresortedKeyData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct SharedSortInfo {
    pub num_workers: ::std::os::raw::c_int,
    pub sinstrument: __IncompleteArrayField<TuplesortInstrumentation>,
}
impl Default for SharedSortInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortState {
    pub ss: ScanState,
    pub randomAccess: bool,
    pub bounded: bool,
    pub bound: int64,
    pub sort_Done: bool,
    pub bounded_Done: bool,
    pub bound_Done: int64,
    pub tuplesortstate: *mut ::std::os::raw::c_void,
    pub am_worker: bool,
    pub shared_info: *mut SharedSortInfo,
}
impl Default for SortState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IncrementalSortGroupInfo {
    pub groupCount: int64,
    pub maxDiskSpaceUsed: int64,
    pub totalDiskSpaceUsed: int64,
    pub maxMemorySpaceUsed: int64,
    pub totalMemorySpaceUsed: int64,
    pub sortMethods: bits32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IncrementalSortInfo {
    pub fullsortGroupInfo: IncrementalSortGroupInfo,
    pub prefixsortGroupInfo: IncrementalSortGroupInfo,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct SharedIncrementalSortInfo {
    pub num_workers: ::std::os::raw::c_int,
    pub sinfo: __IncompleteArrayField<IncrementalSortInfo>,
}
pub const IncrementalSortExecutionStatus_INCSORT_LOADFULLSORT: IncrementalSortExecutionStatus = 0;
pub const IncrementalSortExecutionStatus_INCSORT_LOADPREFIXSORT: IncrementalSortExecutionStatus = 1;
pub const IncrementalSortExecutionStatus_INCSORT_READFULLSORT: IncrementalSortExecutionStatus = 2;
pub const IncrementalSortExecutionStatus_INCSORT_READPREFIXSORT: IncrementalSortExecutionStatus = 3;
pub type IncrementalSortExecutionStatus = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IncrementalSortState {
    pub ss: ScanState,
    pub bounded: bool,
    pub bound: int64,
    pub outerNodeDone: bool,
    pub bound_Done: int64,
    pub execution_status: IncrementalSortExecutionStatus,
    pub n_fullsort_remaining: int64,
    pub fullsort_state: *mut Tuplesortstate,
    pub prefixsort_state: *mut Tuplesortstate,
    pub presorted_keys: *mut PresortedKeyData,
    pub incsort_info: IncrementalSortInfo,
    pub group_pivot: *mut TupleTableSlot,
    pub transfer_tuple: *mut TupleTableSlot,
    pub am_worker: bool,
    pub shared_info: *mut SharedIncrementalSortInfo,
}
impl Default for IncrementalSortState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupState {
    pub ss: ScanState,
    pub eqfunction: *mut ExprState,
    pub grp_done: bool,
}
impl Default for GroupState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct AggregateInstrumentation {
    pub hash_mem_peak: Size,
    pub hash_disk_used: uint64,
    pub hash_batches_used: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct SharedAggInfo {
    pub num_workers: ::std::os::raw::c_int,
    pub sinstrument: __IncompleteArrayField<AggregateInstrumentation>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerAggData {
    _unused: [u8; 0],
}
pub type AggStatePerAgg = *mut AggStatePerAggData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerTransData {
    _unused: [u8; 0],
}
pub type AggStatePerTrans = *mut AggStatePerTransData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerGroupData {
    _unused: [u8; 0],
}
pub type AggStatePerGroup = *mut AggStatePerGroupData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerPhaseData {
    _unused: [u8; 0],
}
pub type AggStatePerPhase = *mut AggStatePerPhaseData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggStatePerHashData {
    _unused: [u8; 0],
}
pub type AggStatePerHash = *mut AggStatePerHashData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AggState {
    pub ss: ScanState,
    pub aggs: *mut List,
    pub numaggs: ::std::os::raw::c_int,
    pub numtrans: ::std::os::raw::c_int,
    pub aggstrategy: AggStrategy,
    pub aggsplit: AggSplit,
    pub phase: AggStatePerPhase,
    pub numphases: ::std::os::raw::c_int,
    pub current_phase: ::std::os::raw::c_int,
    pub peragg: AggStatePerAgg,
    pub pertrans: AggStatePerTrans,
    pub hashcontext: *mut ExprContext,
    pub aggcontexts: *mut *mut ExprContext,
    pub tmpcontext: *mut ExprContext,
    pub curaggcontext: *mut ExprContext,
    pub curperagg: AggStatePerAgg,
    pub curpertrans: AggStatePerTrans,
    pub input_done: bool,
    pub agg_done: bool,
    pub projected_set: ::std::os::raw::c_int,
    pub current_set: ::std::os::raw::c_int,
    pub grouped_cols: *mut Bitmapset,
    pub all_grouped_cols: *mut List,
    pub colnos_needed: *mut Bitmapset,
    pub max_colno_needed: ::std::os::raw::c_int,
    pub all_cols_needed: bool,
    pub maxsets: ::std::os::raw::c_int,
    pub phases: AggStatePerPhase,
    pub sort_in: *mut Tuplesortstate,
    pub sort_out: *mut Tuplesortstate,
    pub sort_slot: *mut TupleTableSlot,
    pub pergroups: *mut AggStatePerGroup,
    pub grp_firstTuple: HeapTuple,
    pub table_filled: bool,
    pub num_hashes: ::std::os::raw::c_int,
    pub hash_metacxt: MemoryContext,
    pub hash_tapeinfo: *mut HashTapeInfo,
    pub hash_spills: *mut HashAggSpill,
    pub hash_spill_rslot: *mut TupleTableSlot,
    pub hash_spill_wslot: *mut TupleTableSlot,
    pub hash_batches: *mut List,
    pub hash_ever_spilled: bool,
    pub hash_spill_mode: bool,
    pub hash_mem_limit: Size,
    pub hash_ngroups_limit: uint64,
    pub hash_planned_partitions: ::std::os::raw::c_int,
    pub hashentrysize: f64,
    pub hash_mem_peak: Size,
    pub hash_ngroups_current: uint64,
    pub hash_disk_used: uint64,
    pub hash_batches_used: ::std::os::raw::c_int,
    pub perhash: AggStatePerHash,
    pub hash_pergroup: *mut AggStatePerGroup,
    pub all_pergroups: *mut AggStatePerGroup,
    pub combinedproj: *mut ProjectionInfo,
    pub shared_info: *mut SharedAggInfo,
}
impl Default for AggState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowStatePerFuncData {
    _unused: [u8; 0],
}
pub type WindowStatePerFunc = *mut WindowStatePerFuncData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowStatePerAggData {
    _unused: [u8; 0],
}
pub type WindowStatePerAgg = *mut WindowStatePerAggData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowAggState {
    pub ss: ScanState,
    pub funcs: *mut List,
    pub numfuncs: ::std::os::raw::c_int,
    pub numaggs: ::std::os::raw::c_int,
    pub perfunc: WindowStatePerFunc,
    pub peragg: WindowStatePerAgg,
    pub partEqfunction: *mut ExprState,
    pub ordEqfunction: *mut ExprState,
    pub buffer: *mut Tuplestorestate,
    pub current_ptr: ::std::os::raw::c_int,
    pub framehead_ptr: ::std::os::raw::c_int,
    pub frametail_ptr: ::std::os::raw::c_int,
    pub grouptail_ptr: ::std::os::raw::c_int,
    pub spooled_rows: int64,
    pub currentpos: int64,
    pub frameheadpos: int64,
    pub frametailpos: int64,
    pub agg_winobj: *mut WindowObjectData,
    pub aggregatedbase: int64,
    pub aggregatedupto: int64,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut ExprState,
    pub endOffset: *mut ExprState,
    pub startOffsetValue: Datum,
    pub endOffsetValue: Datum,
    pub startInRangeFunc: FmgrInfo,
    pub endInRangeFunc: FmgrInfo,
    pub inRangeColl: Oid,
    pub inRangeAsc: bool,
    pub inRangeNullsFirst: bool,
    pub currentgroup: int64,
    pub frameheadgroup: int64,
    pub frametailgroup: int64,
    pub groupheadpos: int64,
    pub grouptailpos: int64,
    pub partcontext: MemoryContext,
    pub aggcontext: MemoryContext,
    pub curaggcontext: MemoryContext,
    pub tmpcontext: *mut ExprContext,
    pub all_first: bool,
    pub all_done: bool,
    pub partition_spooled: bool,
    pub more_partitions: bool,
    pub framehead_valid: bool,
    pub frametail_valid: bool,
    pub grouptail_valid: bool,
    pub first_part_slot: *mut TupleTableSlot,
    pub framehead_slot: *mut TupleTableSlot,
    pub frametail_slot: *mut TupleTableSlot,
    pub agg_row_slot: *mut TupleTableSlot,
    pub temp_slot_1: *mut TupleTableSlot,
    pub temp_slot_2: *mut TupleTableSlot,
}
impl Default for WindowAggState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UniqueState {
    pub ps: PlanState,
    pub eqfunction: *mut ExprState,
}
impl Default for UniqueState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherState {
    pub ps: PlanState,
    pub initialized: bool,
    pub need_to_scan_locally: bool,
    pub tuples_needed: int64,
    pub funnel_slot: *mut TupleTableSlot,
    pub pei: *mut ParallelExecutorInfo,
    pub nworkers_launched: ::std::os::raw::c_int,
    pub nreaders: ::std::os::raw::c_int,
    pub nextreader: ::std::os::raw::c_int,
    pub reader: *mut *mut TupleQueueReader,
}
impl Default for GatherState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GMReaderTupleBuffer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GatherMergeState {
    pub ps: PlanState,
    pub initialized: bool,
    pub gm_initialized: bool,
    pub need_to_scan_locally: bool,
    pub tuples_needed: int64,
    pub tupDesc: TupleDesc,
    pub gm_nkeys: ::std::os::raw::c_int,
    pub gm_sortkeys: SortSupport,
    pub pei: *mut ParallelExecutorInfo,
    pub nworkers_launched: ::std::os::raw::c_int,
    pub nreaders: ::std::os::raw::c_int,
    pub gm_slots: *mut *mut TupleTableSlot,
    pub reader: *mut *mut TupleQueueReader,
    pub gm_tuple_buffers: *mut GMReaderTupleBuffer,
    pub gm_heap: *mut binaryheap,
}
impl Default for GatherMergeState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct HashInstrumentation {
    pub nbuckets: ::std::os::raw::c_int,
    pub nbuckets_original: ::std::os::raw::c_int,
    pub nbatch: ::std::os::raw::c_int,
    pub nbatch_original: ::std::os::raw::c_int,
    pub space_peak: Size,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct SharedHashInfo {
    pub num_workers: ::std::os::raw::c_int,
    pub hinstrument: __IncompleteArrayField<HashInstrumentation>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HashState {
    pub ps: PlanState,
    pub hashtable: HashJoinTable,
    pub hashkeys: *mut List,
    pub shared_info: *mut SharedHashInfo,
    pub hinstrument: *mut HashInstrumentation,
    pub parallel_state: *mut ParallelHashJoinState,
}
impl Default for HashState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOpStatePerGroupData {
    _unused: [u8; 0],
}
pub type SetOpStatePerGroup = *mut SetOpStatePerGroupData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOpState {
    pub ps: PlanState,
    pub eqfunction: *mut ExprState,
    pub eqfuncoids: *mut Oid,
    pub hashfunctions: *mut FmgrInfo,
    pub setop_done: bool,
    pub numOutput: ::std::os::raw::c_long,
    pub pergroup: SetOpStatePerGroup,
    pub grp_firstTuple: HeapTuple,
    pub hashtable: TupleHashTable,
    pub tableContext: MemoryContext,
    pub table_filled: bool,
    pub hashiter: TupleHashIterator,
}
impl Default for SetOpState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockRowsState {
    pub ps: PlanState,
    pub lr_arowMarks: *mut List,
    pub lr_epqstate: EPQState,
}
impl Default for LockRowsState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const LimitStateCond_LIMIT_INITIAL: LimitStateCond = 0;
pub const LimitStateCond_LIMIT_RESCAN: LimitStateCond = 1;
pub const LimitStateCond_LIMIT_EMPTY: LimitStateCond = 2;
pub const LimitStateCond_LIMIT_INWINDOW: LimitStateCond = 3;
pub const LimitStateCond_LIMIT_WINDOWEND_TIES: LimitStateCond = 4;
pub const LimitStateCond_LIMIT_SUBPLANEOF: LimitStateCond = 5;
pub const LimitStateCond_LIMIT_WINDOWEND: LimitStateCond = 6;
pub const LimitStateCond_LIMIT_WINDOWSTART: LimitStateCond = 7;
pub type LimitStateCond = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LimitState {
    pub ps: PlanState,
    pub limitOffset: *mut ExprState,
    pub limitCount: *mut ExprState,
    pub limitOption: LimitOption,
    pub offset: int64,
    pub count: int64,
    pub noCount: bool,
    pub lstate: LimitStateCond,
    pub position: int64,
    pub subSlot: *mut TupleTableSlot,
    pub eqfunction: *mut ExprState,
    pub last_slot: *mut TupleTableSlot,
}
impl Default for LimitState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const CommandTag_CMDTAG_UNKNOWN: CommandTag = 0;
pub const CommandTag_CMDTAG_ALTER_ACCESS_METHOD: CommandTag = 1;
pub const CommandTag_CMDTAG_ALTER_AGGREGATE: CommandTag = 2;
pub const CommandTag_CMDTAG_ALTER_CAST: CommandTag = 3;
pub const CommandTag_CMDTAG_ALTER_COLLATION: CommandTag = 4;
pub const CommandTag_CMDTAG_ALTER_CONSTRAINT: CommandTag = 5;
pub const CommandTag_CMDTAG_ALTER_CONVERSION: CommandTag = 6;
pub const CommandTag_CMDTAG_ALTER_DATABASE: CommandTag = 7;
pub const CommandTag_CMDTAG_ALTER_DEFAULT_PRIVILEGES: CommandTag = 8;
pub const CommandTag_CMDTAG_ALTER_DOMAIN: CommandTag = 9;
pub const CommandTag_CMDTAG_ALTER_EVENT_TRIGGER: CommandTag = 10;
pub const CommandTag_CMDTAG_ALTER_EXTENSION: CommandTag = 11;
pub const CommandTag_CMDTAG_ALTER_FOREIGN_DATA_WRAPPER: CommandTag = 12;
pub const CommandTag_CMDTAG_ALTER_FOREIGN_TABLE: CommandTag = 13;
pub const CommandTag_CMDTAG_ALTER_FUNCTION: CommandTag = 14;
pub const CommandTag_CMDTAG_ALTER_INDEX: CommandTag = 15;
pub const CommandTag_CMDTAG_ALTER_LANGUAGE: CommandTag = 16;
pub const CommandTag_CMDTAG_ALTER_LARGE_OBJECT: CommandTag = 17;
pub const CommandTag_CMDTAG_ALTER_MATERIALIZED_VIEW: CommandTag = 18;
pub const CommandTag_CMDTAG_ALTER_OPERATOR: CommandTag = 19;
pub const CommandTag_CMDTAG_ALTER_OPERATOR_CLASS: CommandTag = 20;
pub const CommandTag_CMDTAG_ALTER_OPERATOR_FAMILY: CommandTag = 21;
pub const CommandTag_CMDTAG_ALTER_POLICY: CommandTag = 22;
pub const CommandTag_CMDTAG_ALTER_PROCEDURE: CommandTag = 23;
pub const CommandTag_CMDTAG_ALTER_PUBLICATION: CommandTag = 24;
pub const CommandTag_CMDTAG_ALTER_ROLE: CommandTag = 25;
pub const CommandTag_CMDTAG_ALTER_ROUTINE: CommandTag = 26;
pub const CommandTag_CMDTAG_ALTER_RULE: CommandTag = 27;
pub const CommandTag_CMDTAG_ALTER_SCHEMA: CommandTag = 28;
pub const CommandTag_CMDTAG_ALTER_SEQUENCE: CommandTag = 29;
pub const CommandTag_CMDTAG_ALTER_SERVER: CommandTag = 30;
pub const CommandTag_CMDTAG_ALTER_STATISTICS: CommandTag = 31;
pub const CommandTag_CMDTAG_ALTER_SUBSCRIPTION: CommandTag = 32;
pub const CommandTag_CMDTAG_ALTER_SYSTEM: CommandTag = 33;
pub const CommandTag_CMDTAG_ALTER_TABLE: CommandTag = 34;
pub const CommandTag_CMDTAG_ALTER_TABLESPACE: CommandTag = 35;
pub const CommandTag_CMDTAG_ALTER_TEXT_SEARCH_CONFIGURATION: CommandTag = 36;
pub const CommandTag_CMDTAG_ALTER_TEXT_SEARCH_DICTIONARY: CommandTag = 37;
pub const CommandTag_CMDTAG_ALTER_TEXT_SEARCH_PARSER: CommandTag = 38;
pub const CommandTag_CMDTAG_ALTER_TEXT_SEARCH_TEMPLATE: CommandTag = 39;
pub const CommandTag_CMDTAG_ALTER_TRANSFORM: CommandTag = 40;
pub const CommandTag_CMDTAG_ALTER_TRIGGER: CommandTag = 41;
pub const CommandTag_CMDTAG_ALTER_TYPE: CommandTag = 42;
pub const CommandTag_CMDTAG_ALTER_USER_MAPPING: CommandTag = 43;
pub const CommandTag_CMDTAG_ALTER_VIEW: CommandTag = 44;
pub const CommandTag_CMDTAG_ANALYZE: CommandTag = 45;
pub const CommandTag_CMDTAG_BEGIN: CommandTag = 46;
pub const CommandTag_CMDTAG_CALL: CommandTag = 47;
pub const CommandTag_CMDTAG_CHECKPOINT: CommandTag = 48;
pub const CommandTag_CMDTAG_CLOSE: CommandTag = 49;
pub const CommandTag_CMDTAG_CLOSE_CURSOR: CommandTag = 50;
pub const CommandTag_CMDTAG_CLOSE_CURSOR_ALL: CommandTag = 51;
pub const CommandTag_CMDTAG_CLUSTER: CommandTag = 52;
pub const CommandTag_CMDTAG_COMMENT: CommandTag = 53;
pub const CommandTag_CMDTAG_COMMIT: CommandTag = 54;
pub const CommandTag_CMDTAG_COMMIT_PREPARED: CommandTag = 55;
pub const CommandTag_CMDTAG_COPY: CommandTag = 56;
pub const CommandTag_CMDTAG_COPY_FROM: CommandTag = 57;
pub const CommandTag_CMDTAG_CREATE_ACCESS_METHOD: CommandTag = 58;
pub const CommandTag_CMDTAG_CREATE_AGGREGATE: CommandTag = 59;
pub const CommandTag_CMDTAG_CREATE_CAST: CommandTag = 60;
pub const CommandTag_CMDTAG_CREATE_COLLATION: CommandTag = 61;
pub const CommandTag_CMDTAG_CREATE_CONSTRAINT: CommandTag = 62;
pub const CommandTag_CMDTAG_CREATE_CONVERSION: CommandTag = 63;
pub const CommandTag_CMDTAG_CREATE_DATABASE: CommandTag = 64;
pub const CommandTag_CMDTAG_CREATE_DOMAIN: CommandTag = 65;
pub const CommandTag_CMDTAG_CREATE_EVENT_TRIGGER: CommandTag = 66;
pub const CommandTag_CMDTAG_CREATE_EXTENSION: CommandTag = 67;
pub const CommandTag_CMDTAG_CREATE_FOREIGN_DATA_WRAPPER: CommandTag = 68;
pub const CommandTag_CMDTAG_CREATE_FOREIGN_TABLE: CommandTag = 69;
pub const CommandTag_CMDTAG_CREATE_FUNCTION: CommandTag = 70;
pub const CommandTag_CMDTAG_CREATE_INDEX: CommandTag = 71;
pub const CommandTag_CMDTAG_CREATE_LANGUAGE: CommandTag = 72;
pub const CommandTag_CMDTAG_CREATE_MATERIALIZED_VIEW: CommandTag = 73;
pub const CommandTag_CMDTAG_CREATE_OPERATOR: CommandTag = 74;
pub const CommandTag_CMDTAG_CREATE_OPERATOR_CLASS: CommandTag = 75;
pub const CommandTag_CMDTAG_CREATE_OPERATOR_FAMILY: CommandTag = 76;
pub const CommandTag_CMDTAG_CREATE_POLICY: CommandTag = 77;
pub const CommandTag_CMDTAG_CREATE_PROCEDURE: CommandTag = 78;
pub const CommandTag_CMDTAG_CREATE_PUBLICATION: CommandTag = 79;
pub const CommandTag_CMDTAG_CREATE_ROLE: CommandTag = 80;
pub const CommandTag_CMDTAG_CREATE_ROUTINE: CommandTag = 81;
pub const CommandTag_CMDTAG_CREATE_RULE: CommandTag = 82;
pub const CommandTag_CMDTAG_CREATE_SCHEMA: CommandTag = 83;
pub const CommandTag_CMDTAG_CREATE_SEQUENCE: CommandTag = 84;
pub const CommandTag_CMDTAG_CREATE_SERVER: CommandTag = 85;
pub const CommandTag_CMDTAG_CREATE_STATISTICS: CommandTag = 86;
pub const CommandTag_CMDTAG_CREATE_SUBSCRIPTION: CommandTag = 87;
pub const CommandTag_CMDTAG_CREATE_TABLE: CommandTag = 88;
pub const CommandTag_CMDTAG_CREATE_TABLE_AS: CommandTag = 89;
pub const CommandTag_CMDTAG_CREATE_TABLESPACE: CommandTag = 90;
pub const CommandTag_CMDTAG_CREATE_TEXT_SEARCH_CONFIGURATION: CommandTag = 91;
pub const CommandTag_CMDTAG_CREATE_TEXT_SEARCH_DICTIONARY: CommandTag = 92;
pub const CommandTag_CMDTAG_CREATE_TEXT_SEARCH_PARSER: CommandTag = 93;
pub const CommandTag_CMDTAG_CREATE_TEXT_SEARCH_TEMPLATE: CommandTag = 94;
pub const CommandTag_CMDTAG_CREATE_TRANSFORM: CommandTag = 95;
pub const CommandTag_CMDTAG_CREATE_TRIGGER: CommandTag = 96;
pub const CommandTag_CMDTAG_CREATE_TYPE: CommandTag = 97;
pub const CommandTag_CMDTAG_CREATE_USER_MAPPING: CommandTag = 98;
pub const CommandTag_CMDTAG_CREATE_VIEW: CommandTag = 99;
pub const CommandTag_CMDTAG_DEALLOCATE: CommandTag = 100;
pub const CommandTag_CMDTAG_DEALLOCATE_ALL: CommandTag = 101;
pub const CommandTag_CMDTAG_DECLARE_CURSOR: CommandTag = 102;
pub const CommandTag_CMDTAG_DELETE: CommandTag = 103;
pub const CommandTag_CMDTAG_DISCARD: CommandTag = 104;
pub const CommandTag_CMDTAG_DISCARD_ALL: CommandTag = 105;
pub const CommandTag_CMDTAG_DISCARD_PLANS: CommandTag = 106;
pub const CommandTag_CMDTAG_DISCARD_SEQUENCES: CommandTag = 107;
pub const CommandTag_CMDTAG_DISCARD_TEMP: CommandTag = 108;
pub const CommandTag_CMDTAG_DO: CommandTag = 109;
pub const CommandTag_CMDTAG_DROP_ACCESS_METHOD: CommandTag = 110;
pub const CommandTag_CMDTAG_DROP_AGGREGATE: CommandTag = 111;
pub const CommandTag_CMDTAG_DROP_CAST: CommandTag = 112;
pub const CommandTag_CMDTAG_DROP_COLLATION: CommandTag = 113;
pub const CommandTag_CMDTAG_DROP_CONSTRAINT: CommandTag = 114;
pub const CommandTag_CMDTAG_DROP_CONVERSION: CommandTag = 115;
pub const CommandTag_CMDTAG_DROP_DATABASE: CommandTag = 116;
pub const CommandTag_CMDTAG_DROP_DOMAIN: CommandTag = 117;
pub const CommandTag_CMDTAG_DROP_EVENT_TRIGGER: CommandTag = 118;
pub const CommandTag_CMDTAG_DROP_EXTENSION: CommandTag = 119;
pub const CommandTag_CMDTAG_DROP_FOREIGN_DATA_WRAPPER: CommandTag = 120;
pub const CommandTag_CMDTAG_DROP_FOREIGN_TABLE: CommandTag = 121;
pub const CommandTag_CMDTAG_DROP_FUNCTION: CommandTag = 122;
pub const CommandTag_CMDTAG_DROP_INDEX: CommandTag = 123;
pub const CommandTag_CMDTAG_DROP_LANGUAGE: CommandTag = 124;
pub const CommandTag_CMDTAG_DROP_MATERIALIZED_VIEW: CommandTag = 125;
pub const CommandTag_CMDTAG_DROP_OPERATOR: CommandTag = 126;
pub const CommandTag_CMDTAG_DROP_OPERATOR_CLASS: CommandTag = 127;
pub const CommandTag_CMDTAG_DROP_OPERATOR_FAMILY: CommandTag = 128;
pub const CommandTag_CMDTAG_DROP_OWNED: CommandTag = 129;
pub const CommandTag_CMDTAG_DROP_POLICY: CommandTag = 130;
pub const CommandTag_CMDTAG_DROP_PROCEDURE: CommandTag = 131;
pub const CommandTag_CMDTAG_DROP_PUBLICATION: CommandTag = 132;
pub const CommandTag_CMDTAG_DROP_ROLE: CommandTag = 133;
pub const CommandTag_CMDTAG_DROP_ROUTINE: CommandTag = 134;
pub const CommandTag_CMDTAG_DROP_RULE: CommandTag = 135;
pub const CommandTag_CMDTAG_DROP_SCHEMA: CommandTag = 136;
pub const CommandTag_CMDTAG_DROP_SEQUENCE: CommandTag = 137;
pub const CommandTag_CMDTAG_DROP_SERVER: CommandTag = 138;
pub const CommandTag_CMDTAG_DROP_STATISTICS: CommandTag = 139;
pub const CommandTag_CMDTAG_DROP_SUBSCRIPTION: CommandTag = 140;
pub const CommandTag_CMDTAG_DROP_TABLE: CommandTag = 141;
pub const CommandTag_CMDTAG_DROP_TABLESPACE: CommandTag = 142;
pub const CommandTag_CMDTAG_DROP_TEXT_SEARCH_CONFIGURATION: CommandTag = 143;
pub const CommandTag_CMDTAG_DROP_TEXT_SEARCH_DICTIONARY: CommandTag = 144;
pub const CommandTag_CMDTAG_DROP_TEXT_SEARCH_PARSER: CommandTag = 145;
pub const CommandTag_CMDTAG_DROP_TEXT_SEARCH_TEMPLATE: CommandTag = 146;
pub const CommandTag_CMDTAG_DROP_TRANSFORM: CommandTag = 147;
pub const CommandTag_CMDTAG_DROP_TRIGGER: CommandTag = 148;
pub const CommandTag_CMDTAG_DROP_TYPE: CommandTag = 149;
pub const CommandTag_CMDTAG_DROP_USER_MAPPING: CommandTag = 150;
pub const CommandTag_CMDTAG_DROP_VIEW: CommandTag = 151;
pub const CommandTag_CMDTAG_EXECUTE: CommandTag = 152;
pub const CommandTag_CMDTAG_EXPLAIN: CommandTag = 153;
pub const CommandTag_CMDTAG_FETCH: CommandTag = 154;
pub const CommandTag_CMDTAG_GRANT: CommandTag = 155;
pub const CommandTag_CMDTAG_GRANT_ROLE: CommandTag = 156;
pub const CommandTag_CMDTAG_IMPORT_FOREIGN_SCHEMA: CommandTag = 157;
pub const CommandTag_CMDTAG_INSERT: CommandTag = 158;
pub const CommandTag_CMDTAG_LISTEN: CommandTag = 159;
pub const CommandTag_CMDTAG_LOAD: CommandTag = 160;
pub const CommandTag_CMDTAG_LOCK_TABLE: CommandTag = 161;
pub const CommandTag_CMDTAG_MOVE: CommandTag = 162;
pub const CommandTag_CMDTAG_NOTIFY: CommandTag = 163;
pub const CommandTag_CMDTAG_PREPARE: CommandTag = 164;
pub const CommandTag_CMDTAG_PREPARE_TRANSACTION: CommandTag = 165;
pub const CommandTag_CMDTAG_REASSIGN_OWNED: CommandTag = 166;
pub const CommandTag_CMDTAG_REFRESH_MATERIALIZED_VIEW: CommandTag = 167;
pub const CommandTag_CMDTAG_REINDEX: CommandTag = 168;
pub const CommandTag_CMDTAG_RELEASE: CommandTag = 169;
pub const CommandTag_CMDTAG_RESET: CommandTag = 170;
pub const CommandTag_CMDTAG_REVOKE: CommandTag = 171;
pub const CommandTag_CMDTAG_REVOKE_ROLE: CommandTag = 172;
pub const CommandTag_CMDTAG_ROLLBACK: CommandTag = 173;
pub const CommandTag_CMDTAG_ROLLBACK_PREPARED: CommandTag = 174;
pub const CommandTag_CMDTAG_SAVEPOINT: CommandTag = 175;
pub const CommandTag_CMDTAG_SECURITY_LABEL: CommandTag = 176;
pub const CommandTag_CMDTAG_SELECT: CommandTag = 177;
pub const CommandTag_CMDTAG_SELECT_FOR_KEY_SHARE: CommandTag = 178;
pub const CommandTag_CMDTAG_SELECT_FOR_NO_KEY_UPDATE: CommandTag = 179;
pub const CommandTag_CMDTAG_SELECT_FOR_SHARE: CommandTag = 180;
pub const CommandTag_CMDTAG_SELECT_FOR_UPDATE: CommandTag = 181;
pub const CommandTag_CMDTAG_SELECT_INTO: CommandTag = 182;
pub const CommandTag_CMDTAG_SET: CommandTag = 183;
pub const CommandTag_CMDTAG_SET_CONSTRAINTS: CommandTag = 184;
pub const CommandTag_CMDTAG_SHOW: CommandTag = 185;
pub const CommandTag_CMDTAG_START_TRANSACTION: CommandTag = 186;
pub const CommandTag_CMDTAG_TRUNCATE_TABLE: CommandTag = 187;
pub const CommandTag_CMDTAG_UNLISTEN: CommandTag = 188;
pub const CommandTag_CMDTAG_UPDATE: CommandTag = 189;
pub const CommandTag_CMDTAG_VACUUM: CommandTag = 190;
pub const CommandTag_COMMAND_TAG_NEXTTAG: CommandTag = 191;
pub type CommandTag = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QueryCompletion {
    pub commandTag: CommandTag,
    pub nprocessed: uint64,
}
impl Default for QueryCompletion {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitializeQueryCompletion(qc: *mut QueryCompletion);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetCommandTagName(commandTag: CommandTag) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn command_tag_display_rowcount(commandTag: CommandTag) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn command_tag_event_trigger_ok(commandTag: CommandTag) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn command_tag_table_rewrite_ok(commandTag: CommandTag) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetCommandTagEnum(tagname: *const ::std::os::raw::c_char) -> CommandTag;
}
pub const CommandDest_DestNone: CommandDest = 0;
pub const CommandDest_DestDebug: CommandDest = 1;
pub const CommandDest_DestRemote: CommandDest = 2;
pub const CommandDest_DestRemoteExecute: CommandDest = 3;
pub const CommandDest_DestRemoteSimple: CommandDest = 4;
pub const CommandDest_DestSPI: CommandDest = 5;
pub const CommandDest_DestTuplestore: CommandDest = 6;
pub const CommandDest_DestIntoRel: CommandDest = 7;
pub const CommandDest_DestCopyOut: CommandDest = 8;
pub const CommandDest_DestSQLFunction: CommandDest = 9;
pub const CommandDest_DestTransientRel: CommandDest = 10;
pub const CommandDest_DestTupleQueue: CommandDest = 11;
pub type CommandDest = ::std::os::raw::c_uint;
pub type DestReceiver = _DestReceiver;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _DestReceiver {
    pub receiveSlot: ::std::option::Option<
        unsafe extern "C" fn(slot: *mut TupleTableSlot, self_: *mut DestReceiver) -> bool,
    >,
    pub rStartup: ::std::option::Option<
        unsafe extern "C" fn(
            self_: *mut DestReceiver,
            operation: ::std::os::raw::c_int,
            typeinfo: TupleDesc,
        ),
    >,
    pub rShutdown: ::std::option::Option<unsafe extern "C" fn(self_: *mut DestReceiver)>,
    pub rDestroy: ::std::option::Option<unsafe extern "C" fn(self_: *mut DestReceiver)>,
    pub mydest: CommandDest,
}
impl Default for _DestReceiver {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut None_Receiver: *mut DestReceiver;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BeginCommand(commandTag: CommandTag, dest: CommandDest);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CreateDestReceiver(dest: CommandDest) -> *mut DestReceiver;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EndCommand(
        qc: *const QueryCompletion,
        dest: CommandDest,
        force_undecorated_output: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EndReplicationCommand(commandTag: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn NullCommand(dest: CommandDest);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ReadyForQuery(dest: CommandDest);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QueryDesc {
    pub operation: CmdType,
    pub plannedstmt: *mut PlannedStmt,
    pub sourceText: *const ::std::os::raw::c_char,
    pub snapshot: Snapshot,
    pub crosscheck_snapshot: Snapshot,
    pub dest: *mut DestReceiver,
    pub params: ParamListInfo,
    pub queryEnv: *mut QueryEnvironment,
    pub instrument_options: ::std::os::raw::c_int,
    pub tupDesc: TupleDesc,
    pub estate: *mut EState,
    pub planstate: *mut PlanState,
    pub already_executed: bool,
    pub totaltime: *mut Instrumentation,
}
impl Default for QueryDesc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CreateQueryDesc(
        plannedstmt: *mut PlannedStmt,
        sourceText: *const ::std::os::raw::c_char,
        snapshot: Snapshot,
        crosscheck_snapshot: Snapshot,
        dest: *mut DestReceiver,
        params: ParamListInfo,
        queryEnv: *mut QueryEnvironment,
        instrument_options: ::std::os::raw::c_int,
    ) -> *mut QueryDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FreeQueryDesc(qdesc: *mut QueryDesc);
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct Value {
    pub type_: NodeTag,
    pub val: Value_ValUnion,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union Value_ValUnion {
    pub ival: ::std::os::raw::c_int,
    pub str_: *mut ::std::os::raw::c_char,
}
impl Default for Value_ValUnion {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for Value {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn makeInteger(i: ::std::os::raw::c_int) -> *mut Value;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn makeFloat(numericStr: *mut ::std::os::raw::c_char) -> *mut Value;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn makeString(str_: *mut ::std::os::raw::c_char) -> *mut Value;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn makeBitString(str_: *mut ::std::os::raw::c_char) -> *mut Value;
}
pub const OverridingKind_OVERRIDING_NOT_SET: OverridingKind = 0;
pub const OverridingKind_OVERRIDING_USER_VALUE: OverridingKind = 1;
pub const OverridingKind_OVERRIDING_SYSTEM_VALUE: OverridingKind = 2;
pub type OverridingKind = ::std::os::raw::c_uint;
pub const QuerySource_QSRC_ORIGINAL: QuerySource = 0;
pub const QuerySource_QSRC_PARSER: QuerySource = 1;
pub const QuerySource_QSRC_INSTEAD_RULE: QuerySource = 2;
pub const QuerySource_QSRC_QUAL_INSTEAD_RULE: QuerySource = 3;
pub const QuerySource_QSRC_NON_INSTEAD_RULE: QuerySource = 4;
pub type QuerySource = ::std::os::raw::c_uint;
pub const SortByDir_SORTBY_DEFAULT: SortByDir = 0;
pub const SortByDir_SORTBY_ASC: SortByDir = 1;
pub const SortByDir_SORTBY_DESC: SortByDir = 2;
pub const SortByDir_SORTBY_USING: SortByDir = 3;
pub type SortByDir = ::std::os::raw::c_uint;
pub const SortByNulls_SORTBY_NULLS_DEFAULT: SortByNulls = 0;
pub const SortByNulls_SORTBY_NULLS_FIRST: SortByNulls = 1;
pub const SortByNulls_SORTBY_NULLS_LAST: SortByNulls = 2;
pub type SortByNulls = ::std::os::raw::c_uint;
pub type AclMode = uint32;
#[doc = "\tQuery Tree"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Query {
    pub type_: NodeTag,
    pub commandType: CmdType,
    pub querySource: QuerySource,
    pub queryId: uint64,
    pub canSetTag: bool,
    pub utilityStmt: *mut Node,
    pub resultRelation: ::std::os::raw::c_int,
    pub hasAggs: bool,
    pub hasWindowFuncs: bool,
    pub hasTargetSRFs: bool,
    pub hasSubLinks: bool,
    pub hasDistinctOn: bool,
    pub hasRecursive: bool,
    pub hasModifyingCTE: bool,
    pub hasForUpdate: bool,
    pub hasRowSecurity: bool,
    pub cteList: *mut List,
    pub rtable: *mut List,
    pub jointree: *mut FromExpr,
    pub targetList: *mut List,
    pub override_: OverridingKind,
    pub onConflict: *mut OnConflictExpr,
    pub returningList: *mut List,
    pub groupClause: *mut List,
    pub groupingSets: *mut List,
    pub havingQual: *mut Node,
    pub windowClause: *mut List,
    pub distinctClause: *mut List,
    pub sortClause: *mut List,
    pub limitOffset: *mut Node,
    pub limitCount: *mut Node,
    pub limitOption: LimitOption,
    pub rowMarks: *mut List,
    pub setOperations: *mut Node,
    pub constraintDeps: *mut List,
    pub withCheckOptions: *mut List,
    pub stmt_location: ::std::os::raw::c_int,
    pub stmt_len: ::std::os::raw::c_int,
}
impl Default for Query {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = "\tSupporting data structures for Parse Trees\n\n\tMost of these node types appear in raw parsetrees output by the grammar,\n\tand get transformed to something else by the analyzer.  A few of them\n\tare used as-is in transformed querytrees."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TypeName {
    pub type_: NodeTag,
    pub names: *mut List,
    pub typeOid: Oid,
    pub setof: bool,
    pub pct_type: bool,
    pub typmods: *mut List,
    pub typemod: int32,
    pub arrayBounds: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for TypeName {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ColumnRef {
    pub type_: NodeTag,
    pub fields: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for ColumnRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParamRef {
    pub type_: NodeTag,
    pub number: ::std::os::raw::c_int,
    pub location: ::std::os::raw::c_int,
}
impl Default for ParamRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const A_Expr_Kind_AEXPR_OP: A_Expr_Kind = 0;
pub const A_Expr_Kind_AEXPR_OP_ANY: A_Expr_Kind = 1;
pub const A_Expr_Kind_AEXPR_OP_ALL: A_Expr_Kind = 2;
pub const A_Expr_Kind_AEXPR_DISTINCT: A_Expr_Kind = 3;
pub const A_Expr_Kind_AEXPR_NOT_DISTINCT: A_Expr_Kind = 4;
pub const A_Expr_Kind_AEXPR_NULLIF: A_Expr_Kind = 5;
pub const A_Expr_Kind_AEXPR_OF: A_Expr_Kind = 6;
pub const A_Expr_Kind_AEXPR_IN: A_Expr_Kind = 7;
pub const A_Expr_Kind_AEXPR_LIKE: A_Expr_Kind = 8;
pub const A_Expr_Kind_AEXPR_ILIKE: A_Expr_Kind = 9;
pub const A_Expr_Kind_AEXPR_SIMILAR: A_Expr_Kind = 10;
pub const A_Expr_Kind_AEXPR_BETWEEN: A_Expr_Kind = 11;
pub const A_Expr_Kind_AEXPR_NOT_BETWEEN: A_Expr_Kind = 12;
pub const A_Expr_Kind_AEXPR_BETWEEN_SYM: A_Expr_Kind = 13;
pub const A_Expr_Kind_AEXPR_NOT_BETWEEN_SYM: A_Expr_Kind = 14;
pub const A_Expr_Kind_AEXPR_PAREN: A_Expr_Kind = 15;
pub type A_Expr_Kind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Expr {
    pub type_: NodeTag,
    pub kind: A_Expr_Kind,
    pub name: *mut List,
    pub lexpr: *mut Node,
    pub rexpr: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for A_Expr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct A_Const {
    pub type_: NodeTag,
    pub val: Value,
    pub location: ::std::os::raw::c_int,
}
impl Default for A_Const {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TypeCast {
    pub type_: NodeTag,
    pub arg: *mut Node,
    pub typeName: *mut TypeName,
    pub location: ::std::os::raw::c_int,
}
impl Default for TypeCast {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CollateClause {
    pub type_: NodeTag,
    pub arg: *mut Node,
    pub collname: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for CollateClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RoleSpecType_ROLESPEC_CSTRING: RoleSpecType = 0;
pub const RoleSpecType_ROLESPEC_CURRENT_USER: RoleSpecType = 1;
pub const RoleSpecType_ROLESPEC_SESSION_USER: RoleSpecType = 2;
pub const RoleSpecType_ROLESPEC_PUBLIC: RoleSpecType = 3;
pub type RoleSpecType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RoleSpec {
    pub type_: NodeTag,
    pub roletype: RoleSpecType,
    pub rolename: *mut ::std::os::raw::c_char,
    pub location: ::std::os::raw::c_int,
}
impl Default for RoleSpec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FuncCall {
    pub type_: NodeTag,
    pub funcname: *mut List,
    pub args: *mut List,
    pub agg_order: *mut List,
    pub agg_filter: *mut Node,
    pub agg_within_group: bool,
    pub agg_star: bool,
    pub agg_distinct: bool,
    pub func_variadic: bool,
    pub over: *mut WindowDef,
    pub location: ::std::os::raw::c_int,
}
impl Default for FuncCall {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Star {
    pub type_: NodeTag,
}
impl Default for A_Star {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Indices {
    pub type_: NodeTag,
    pub is_slice: bool,
    pub lidx: *mut Node,
    pub uidx: *mut Node,
}
impl Default for A_Indices {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_Indirection {
    pub type_: NodeTag,
    pub arg: *mut Node,
    pub indirection: *mut List,
}
impl Default for A_Indirection {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct A_ArrayExpr {
    pub type_: NodeTag,
    pub elements: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for A_ArrayExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ResTarget {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub indirection: *mut List,
    pub val: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for ResTarget {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MultiAssignRef {
    pub type_: NodeTag,
    pub source: *mut Node,
    pub colno: ::std::os::raw::c_int,
    pub ncolumns: ::std::os::raw::c_int,
}
impl Default for MultiAssignRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortBy {
    pub type_: NodeTag,
    pub node: *mut Node,
    pub sortby_dir: SortByDir,
    pub sortby_nulls: SortByNulls,
    pub useOp: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for SortBy {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowDef {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub refname: *mut ::std::os::raw::c_char,
    pub partitionClause: *mut List,
    pub orderClause: *mut List,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut Node,
    pub endOffset: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for WindowDef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeSubselect {
    pub type_: NodeTag,
    pub lateral: bool,
    pub subquery: *mut Node,
    pub alias: *mut Alias,
}
impl Default for RangeSubselect {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeFunction {
    pub type_: NodeTag,
    pub lateral: bool,
    pub ordinality: bool,
    pub is_rowsfrom: bool,
    pub functions: *mut List,
    pub alias: *mut Alias,
    pub coldeflist: *mut List,
}
impl Default for RangeFunction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTableFunc {
    pub type_: NodeTag,
    pub lateral: bool,
    pub docexpr: *mut Node,
    pub rowexpr: *mut Node,
    pub namespaces: *mut List,
    pub columns: *mut List,
    pub alias: *mut Alias,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeTableFunc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTableFuncCol {
    pub type_: NodeTag,
    pub colname: *mut ::std::os::raw::c_char,
    pub typeName: *mut TypeName,
    pub for_ordinality: bool,
    pub is_not_null: bool,
    pub colexpr: *mut Node,
    pub coldefexpr: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeTableFuncCol {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTableSample {
    pub type_: NodeTag,
    pub relation: *mut Node,
    pub method: *mut List,
    pub args: *mut List,
    pub repeatable: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for RangeTableSample {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ColumnDef {
    pub type_: NodeTag,
    pub colname: *mut ::std::os::raw::c_char,
    pub typeName: *mut TypeName,
    pub inhcount: ::std::os::raw::c_int,
    pub is_local: bool,
    pub is_not_null: bool,
    pub is_from_type: bool,
    pub storage: ::std::os::raw::c_char,
    pub raw_default: *mut Node,
    pub cooked_default: *mut Node,
    pub identity: ::std::os::raw::c_char,
    pub identitySequence: *mut RangeVar,
    pub generated: ::std::os::raw::c_char,
    pub collClause: *mut CollateClause,
    pub collOid: Oid,
    pub constraints: *mut List,
    pub fdwoptions: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for ColumnDef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableLikeClause {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub options: bits32,
    pub relationOid: Oid,
}
impl Default for TableLikeClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const TableLikeOption_CREATE_TABLE_LIKE_COMMENTS: TableLikeOption = 1;
pub const TableLikeOption_CREATE_TABLE_LIKE_CONSTRAINTS: TableLikeOption = 2;
pub const TableLikeOption_CREATE_TABLE_LIKE_DEFAULTS: TableLikeOption = 4;
pub const TableLikeOption_CREATE_TABLE_LIKE_GENERATED: TableLikeOption = 8;
pub const TableLikeOption_CREATE_TABLE_LIKE_IDENTITY: TableLikeOption = 16;
pub const TableLikeOption_CREATE_TABLE_LIKE_INDEXES: TableLikeOption = 32;
pub const TableLikeOption_CREATE_TABLE_LIKE_STATISTICS: TableLikeOption = 64;
pub const TableLikeOption_CREATE_TABLE_LIKE_STORAGE: TableLikeOption = 128;
pub const TableLikeOption_CREATE_TABLE_LIKE_ALL: TableLikeOption = 2147483647;
pub type TableLikeOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexElem {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub expr: *mut Node,
    pub indexcolname: *mut ::std::os::raw::c_char,
    pub collation: *mut List,
    pub opclass: *mut List,
    pub opclassopts: *mut List,
    pub ordering: SortByDir,
    pub nulls_ordering: SortByNulls,
}
impl Default for IndexElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DefElemAction_DEFELEM_UNSPEC: DefElemAction = 0;
pub const DefElemAction_DEFELEM_SET: DefElemAction = 1;
pub const DefElemAction_DEFELEM_ADD: DefElemAction = 2;
pub const DefElemAction_DEFELEM_DROP: DefElemAction = 3;
pub type DefElemAction = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DefElem {
    pub type_: NodeTag,
    pub defnamespace: *mut ::std::os::raw::c_char,
    pub defname: *mut ::std::os::raw::c_char,
    pub arg: *mut Node,
    pub defaction: DefElemAction,
    pub location: ::std::os::raw::c_int,
}
impl Default for DefElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockingClause {
    pub type_: NodeTag,
    pub lockedRels: *mut List,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
}
impl Default for LockingClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XmlSerialize {
    pub type_: NodeTag,
    pub xmloption: XmlOptionType,
    pub expr: *mut Node,
    pub typeName: *mut TypeName,
    pub location: ::std::os::raw::c_int,
}
impl Default for XmlSerialize {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionElem {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub expr: *mut Node,
    pub collation: *mut List,
    pub opclass: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionElem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionSpec {
    pub type_: NodeTag,
    pub strategy: *mut ::std::os::raw::c_char,
    pub partParams: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionSpec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionBoundSpec {
    pub type_: NodeTag,
    pub strategy: ::std::os::raw::c_char,
    pub is_default: bool,
    pub modulus: ::std::os::raw::c_int,
    pub remainder: ::std::os::raw::c_int,
    pub listdatums: *mut List,
    pub lowerdatums: *mut List,
    pub upperdatums: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionBoundSpec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const PartitionRangeDatumKind_PARTITION_RANGE_DATUM_MINVALUE: PartitionRangeDatumKind = -1;
pub const PartitionRangeDatumKind_PARTITION_RANGE_DATUM_VALUE: PartitionRangeDatumKind = 0;
pub const PartitionRangeDatumKind_PARTITION_RANGE_DATUM_MAXVALUE: PartitionRangeDatumKind = 1;
pub type PartitionRangeDatumKind = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionRangeDatum {
    pub type_: NodeTag,
    pub kind: PartitionRangeDatumKind,
    pub value: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for PartitionRangeDatum {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PartitionCmd {
    pub type_: NodeTag,
    pub name: *mut RangeVar,
    pub bound: *mut PartitionBoundSpec,
}
impl Default for PartitionCmd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RTEKind_RTE_RELATION: RTEKind = 0;
pub const RTEKind_RTE_SUBQUERY: RTEKind = 1;
pub const RTEKind_RTE_JOIN: RTEKind = 2;
pub const RTEKind_RTE_FUNCTION: RTEKind = 3;
pub const RTEKind_RTE_TABLEFUNC: RTEKind = 4;
pub const RTEKind_RTE_VALUES: RTEKind = 5;
pub const RTEKind_RTE_CTE: RTEKind = 6;
pub const RTEKind_RTE_NAMEDTUPLESTORE: RTEKind = 7;
pub const RTEKind_RTE_RESULT: RTEKind = 8;
pub type RTEKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTblEntry {
    pub type_: NodeTag,
    pub rtekind: RTEKind,
    pub relid: Oid,
    pub relkind: ::std::os::raw::c_char,
    pub rellockmode: ::std::os::raw::c_int,
    pub tablesample: *mut TableSampleClause,
    pub subquery: *mut Query,
    pub security_barrier: bool,
    pub jointype: JoinType,
    pub joinmergedcols: ::std::os::raw::c_int,
    pub joinaliasvars: *mut List,
    pub joinleftcols: *mut List,
    pub joinrightcols: *mut List,
    pub functions: *mut List,
    pub funcordinality: bool,
    pub tablefunc: *mut TableFunc,
    pub values_lists: *mut List,
    pub ctename: *mut ::std::os::raw::c_char,
    pub ctelevelsup: Index,
    pub self_reference: bool,
    pub coltypes: *mut List,
    pub coltypmods: *mut List,
    pub colcollations: *mut List,
    pub enrname: *mut ::std::os::raw::c_char,
    pub enrtuples: f64,
    pub alias: *mut Alias,
    pub eref: *mut Alias,
    pub lateral: bool,
    pub inh: bool,
    pub inFromCl: bool,
    pub requiredPerms: AclMode,
    pub checkAsUser: Oid,
    pub selectedCols: *mut Bitmapset,
    pub insertedCols: *mut Bitmapset,
    pub updatedCols: *mut Bitmapset,
    pub extraUpdatedCols: *mut Bitmapset,
    pub securityQuals: *mut List,
}
impl Default for RangeTblEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RangeTblFunction {
    pub type_: NodeTag,
    pub funcexpr: *mut Node,
    pub funccolcount: ::std::os::raw::c_int,
    pub funccolnames: *mut List,
    pub funccoltypes: *mut List,
    pub funccoltypmods: *mut List,
    pub funccolcollations: *mut List,
    pub funcparams: *mut Bitmapset,
}
impl Default for RangeTblFunction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableSampleClause {
    pub type_: NodeTag,
    pub tsmhandler: Oid,
    pub args: *mut List,
    pub repeatable: *mut Expr,
}
impl Default for TableSampleClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const WCOKind_WCO_VIEW_CHECK: WCOKind = 0;
pub const WCOKind_WCO_RLS_INSERT_CHECK: WCOKind = 1;
pub const WCOKind_WCO_RLS_UPDATE_CHECK: WCOKind = 2;
pub const WCOKind_WCO_RLS_CONFLICT_CHECK: WCOKind = 3;
pub type WCOKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WithCheckOption {
    pub type_: NodeTag,
    pub kind: WCOKind,
    pub relname: *mut ::std::os::raw::c_char,
    pub polname: *mut ::std::os::raw::c_char,
    pub qual: *mut Node,
    pub cascaded: bool,
}
impl Default for WithCheckOption {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SortGroupClause {
    pub type_: NodeTag,
    pub tleSortGroupRef: Index,
    pub eqop: Oid,
    pub sortop: Oid,
    pub nulls_first: bool,
    pub hashable: bool,
}
impl Default for SortGroupClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const GroupingSetKind_GROUPING_SET_EMPTY: GroupingSetKind = 0;
pub const GroupingSetKind_GROUPING_SET_SIMPLE: GroupingSetKind = 1;
pub const GroupingSetKind_GROUPING_SET_ROLLUP: GroupingSetKind = 2;
pub const GroupingSetKind_GROUPING_SET_CUBE: GroupingSetKind = 3;
pub const GroupingSetKind_GROUPING_SET_SETS: GroupingSetKind = 4;
pub type GroupingSetKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GroupingSet {
    pub type_: NodeTag,
    pub kind: GroupingSetKind,
    pub content: *mut List,
    pub location: ::std::os::raw::c_int,
}
impl Default for GroupingSet {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WindowClause {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub refname: *mut ::std::os::raw::c_char,
    pub partitionClause: *mut List,
    pub orderClause: *mut List,
    pub frameOptions: ::std::os::raw::c_int,
    pub startOffset: *mut Node,
    pub endOffset: *mut Node,
    pub startInRangeFunc: Oid,
    pub endInRangeFunc: Oid,
    pub inRangeColl: Oid,
    pub inRangeAsc: bool,
    pub inRangeNullsFirst: bool,
    pub winref: Index,
    pub copiedOrder: bool,
}
impl Default for WindowClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RowMarkClause {
    pub type_: NodeTag,
    pub rti: Index,
    pub strength: LockClauseStrength,
    pub waitPolicy: LockWaitPolicy,
    pub pushedDown: bool,
}
impl Default for RowMarkClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WithClause {
    pub type_: NodeTag,
    pub ctes: *mut List,
    pub recursive: bool,
    pub location: ::std::os::raw::c_int,
}
impl Default for WithClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InferClause {
    pub type_: NodeTag,
    pub indexElems: *mut List,
    pub whereClause: *mut Node,
    pub conname: *mut ::std::os::raw::c_char,
    pub location: ::std::os::raw::c_int,
}
impl Default for InferClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OnConflictClause {
    pub type_: NodeTag,
    pub action: OnConflictAction,
    pub infer: *mut InferClause,
    pub targetList: *mut List,
    pub whereClause: *mut Node,
    pub location: ::std::os::raw::c_int,
}
impl Default for OnConflictClause {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const CTEMaterialize_CTEMaterializeDefault: CTEMaterialize = 0;
pub const CTEMaterialize_CTEMaterializeAlways: CTEMaterialize = 1;
pub const CTEMaterialize_CTEMaterializeNever: CTEMaterialize = 2;
pub type CTEMaterialize = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CommonTableExpr {
    pub type_: NodeTag,
    pub ctename: *mut ::std::os::raw::c_char,
    pub aliascolnames: *mut List,
    pub ctematerialized: CTEMaterialize,
    pub ctequery: *mut Node,
    pub location: ::std::os::raw::c_int,
    pub cterecursive: bool,
    pub cterefcount: ::std::os::raw::c_int,
    pub ctecolnames: *mut List,
    pub ctecoltypes: *mut List,
    pub ctecoltypmods: *mut List,
    pub ctecolcollations: *mut List,
}
impl Default for CommonTableExpr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TriggerTransition {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub isNew: bool,
    pub isTable: bool,
}
impl Default for TriggerTransition {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = "\t\tRaw Grammar Output Statements"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RawStmt {
    pub type_: NodeTag,
    pub stmt: *mut Node,
    pub stmt_location: ::std::os::raw::c_int,
    pub stmt_len: ::std::os::raw::c_int,
}
impl Default for RawStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = "\t\tOptimizable Statements"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InsertStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub cols: *mut List,
    pub selectStmt: *mut Node,
    pub onConflictClause: *mut OnConflictClause,
    pub returningList: *mut List,
    pub withClause: *mut WithClause,
    pub override_: OverridingKind,
}
impl Default for InsertStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeleteStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub usingClause: *mut List,
    pub whereClause: *mut Node,
    pub returningList: *mut List,
    pub withClause: *mut WithClause,
}
impl Default for DeleteStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UpdateStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub targetList: *mut List,
    pub whereClause: *mut Node,
    pub fromClause: *mut List,
    pub returningList: *mut List,
    pub withClause: *mut WithClause,
}
impl Default for UpdateStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SetOperation_SETOP_NONE: SetOperation = 0;
pub const SetOperation_SETOP_UNION: SetOperation = 1;
pub const SetOperation_SETOP_INTERSECT: SetOperation = 2;
pub const SetOperation_SETOP_EXCEPT: SetOperation = 3;
pub type SetOperation = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SelectStmt {
    pub type_: NodeTag,
    pub distinctClause: *mut List,
    pub intoClause: *mut IntoClause,
    pub targetList: *mut List,
    pub fromClause: *mut List,
    pub whereClause: *mut Node,
    pub groupClause: *mut List,
    pub havingClause: *mut Node,
    pub windowClause: *mut List,
    pub valuesLists: *mut List,
    pub sortClause: *mut List,
    pub limitOffset: *mut Node,
    pub limitCount: *mut Node,
    pub limitOption: LimitOption,
    pub lockingClause: *mut List,
    pub withClause: *mut WithClause,
    pub op: SetOperation,
    pub all: bool,
    pub larg: *mut SelectStmt,
    pub rarg: *mut SelectStmt,
}
impl Default for SelectStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetOperationStmt {
    pub type_: NodeTag,
    pub op: SetOperation,
    pub all: bool,
    pub larg: *mut Node,
    pub rarg: *mut Node,
    pub colTypes: *mut List,
    pub colTypmods: *mut List,
    pub colCollations: *mut List,
    pub groupClauses: *mut List,
}
impl Default for SetOperationStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ObjectType_OBJECT_ACCESS_METHOD: ObjectType = 0;
pub const ObjectType_OBJECT_AGGREGATE: ObjectType = 1;
pub const ObjectType_OBJECT_AMOP: ObjectType = 2;
pub const ObjectType_OBJECT_AMPROC: ObjectType = 3;
pub const ObjectType_OBJECT_ATTRIBUTE: ObjectType = 4;
pub const ObjectType_OBJECT_CAST: ObjectType = 5;
pub const ObjectType_OBJECT_COLUMN: ObjectType = 6;
pub const ObjectType_OBJECT_COLLATION: ObjectType = 7;
pub const ObjectType_OBJECT_CONVERSION: ObjectType = 8;
pub const ObjectType_OBJECT_DATABASE: ObjectType = 9;
pub const ObjectType_OBJECT_DEFAULT: ObjectType = 10;
pub const ObjectType_OBJECT_DEFACL: ObjectType = 11;
pub const ObjectType_OBJECT_DOMAIN: ObjectType = 12;
pub const ObjectType_OBJECT_DOMCONSTRAINT: ObjectType = 13;
pub const ObjectType_OBJECT_EVENT_TRIGGER: ObjectType = 14;
pub const ObjectType_OBJECT_EXTENSION: ObjectType = 15;
pub const ObjectType_OBJECT_FDW: ObjectType = 16;
pub const ObjectType_OBJECT_FOREIGN_SERVER: ObjectType = 17;
pub const ObjectType_OBJECT_FOREIGN_TABLE: ObjectType = 18;
pub const ObjectType_OBJECT_FUNCTION: ObjectType = 19;
pub const ObjectType_OBJECT_INDEX: ObjectType = 20;
pub const ObjectType_OBJECT_LANGUAGE: ObjectType = 21;
pub const ObjectType_OBJECT_LARGEOBJECT: ObjectType = 22;
pub const ObjectType_OBJECT_MATVIEW: ObjectType = 23;
pub const ObjectType_OBJECT_OPCLASS: ObjectType = 24;
pub const ObjectType_OBJECT_OPERATOR: ObjectType = 25;
pub const ObjectType_OBJECT_OPFAMILY: ObjectType = 26;
pub const ObjectType_OBJECT_POLICY: ObjectType = 27;
pub const ObjectType_OBJECT_PROCEDURE: ObjectType = 28;
pub const ObjectType_OBJECT_PUBLICATION: ObjectType = 29;
pub const ObjectType_OBJECT_PUBLICATION_REL: ObjectType = 30;
pub const ObjectType_OBJECT_ROLE: ObjectType = 31;
pub const ObjectType_OBJECT_ROUTINE: ObjectType = 32;
pub const ObjectType_OBJECT_RULE: ObjectType = 33;
pub const ObjectType_OBJECT_SCHEMA: ObjectType = 34;
pub const ObjectType_OBJECT_SEQUENCE: ObjectType = 35;
pub const ObjectType_OBJECT_SUBSCRIPTION: ObjectType = 36;
pub const ObjectType_OBJECT_STATISTIC_EXT: ObjectType = 37;
pub const ObjectType_OBJECT_TABCONSTRAINT: ObjectType = 38;
pub const ObjectType_OBJECT_TABLE: ObjectType = 39;
pub const ObjectType_OBJECT_TABLESPACE: ObjectType = 40;
pub const ObjectType_OBJECT_TRANSFORM: ObjectType = 41;
pub const ObjectType_OBJECT_TRIGGER: ObjectType = 42;
pub const ObjectType_OBJECT_TSCONFIGURATION: ObjectType = 43;
pub const ObjectType_OBJECT_TSDICTIONARY: ObjectType = 44;
pub const ObjectType_OBJECT_TSPARSER: ObjectType = 45;
pub const ObjectType_OBJECT_TSTEMPLATE: ObjectType = 46;
pub const ObjectType_OBJECT_TYPE: ObjectType = 47;
pub const ObjectType_OBJECT_USER_MAPPING: ObjectType = 48;
pub const ObjectType_OBJECT_VIEW: ObjectType = 49;
#[doc = "\t\tOther Statements (no optimizations required)\n\n\t\tThese are not touched by parser/analyze.c except to put them into\n\t\tthe utilityStmt field of a Query.  This is eventually passed to\n\t\tProcessUtility (by-passing rewriting and planning).  Some of the\n\t\tstatements do need attention from parse analysis, and this is\n\t\tdone by routines in parser/parse_utilcmd.c after ProcessUtility\n\t\treceives the command for execution.\n\t\tDECLARE CURSOR, EXPLAIN, and CREATE TABLE AS are special cases:\n\t\tthey contain optimizable statements, which get processed normally\n\t\tby parser/analyze.c."]
pub type ObjectType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateSchemaStmt {
    pub type_: NodeTag,
    pub schemaname: *mut ::std::os::raw::c_char,
    pub authrole: *mut RoleSpec,
    pub schemaElts: *mut List,
    pub if_not_exists: bool,
}
impl Default for CreateSchemaStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DropBehavior_DROP_RESTRICT: DropBehavior = 0;
pub const DropBehavior_DROP_CASCADE: DropBehavior = 1;
pub type DropBehavior = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub cmds: *mut List,
    pub relkind: ObjectType,
    pub missing_ok: bool,
}
impl Default for AlterTableStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const AlterTableType_AT_AddColumn: AlterTableType = 0;
pub const AlterTableType_AT_AddColumnRecurse: AlterTableType = 1;
pub const AlterTableType_AT_AddColumnToView: AlterTableType = 2;
pub const AlterTableType_AT_ColumnDefault: AlterTableType = 3;
pub const AlterTableType_AT_CookedColumnDefault: AlterTableType = 4;
pub const AlterTableType_AT_DropNotNull: AlterTableType = 5;
pub const AlterTableType_AT_SetNotNull: AlterTableType = 6;
pub const AlterTableType_AT_DropExpression: AlterTableType = 7;
pub const AlterTableType_AT_CheckNotNull: AlterTableType = 8;
pub const AlterTableType_AT_SetStatistics: AlterTableType = 9;
pub const AlterTableType_AT_SetOptions: AlterTableType = 10;
pub const AlterTableType_AT_ResetOptions: AlterTableType = 11;
pub const AlterTableType_AT_SetStorage: AlterTableType = 12;
pub const AlterTableType_AT_DropColumn: AlterTableType = 13;
pub const AlterTableType_AT_DropColumnRecurse: AlterTableType = 14;
pub const AlterTableType_AT_AddIndex: AlterTableType = 15;
pub const AlterTableType_AT_ReAddIndex: AlterTableType = 16;
pub const AlterTableType_AT_AddConstraint: AlterTableType = 17;
pub const AlterTableType_AT_AddConstraintRecurse: AlterTableType = 18;
pub const AlterTableType_AT_ReAddConstraint: AlterTableType = 19;
pub const AlterTableType_AT_ReAddDomainConstraint: AlterTableType = 20;
pub const AlterTableType_AT_AlterConstraint: AlterTableType = 21;
pub const AlterTableType_AT_ValidateConstraint: AlterTableType = 22;
pub const AlterTableType_AT_ValidateConstraintRecurse: AlterTableType = 23;
pub const AlterTableType_AT_AddIndexConstraint: AlterTableType = 24;
pub const AlterTableType_AT_DropConstraint: AlterTableType = 25;
pub const AlterTableType_AT_DropConstraintRecurse: AlterTableType = 26;
pub const AlterTableType_AT_ReAddComment: AlterTableType = 27;
pub const AlterTableType_AT_AlterColumnType: AlterTableType = 28;
pub const AlterTableType_AT_AlterColumnGenericOptions: AlterTableType = 29;
pub const AlterTableType_AT_ChangeOwner: AlterTableType = 30;
pub const AlterTableType_AT_ClusterOn: AlterTableType = 31;
pub const AlterTableType_AT_DropCluster: AlterTableType = 32;
pub const AlterTableType_AT_SetLogged: AlterTableType = 33;
pub const AlterTableType_AT_SetUnLogged: AlterTableType = 34;
pub const AlterTableType_AT_DropOids: AlterTableType = 35;
pub const AlterTableType_AT_SetTableSpace: AlterTableType = 36;
pub const AlterTableType_AT_SetRelOptions: AlterTableType = 37;
pub const AlterTableType_AT_ResetRelOptions: AlterTableType = 38;
pub const AlterTableType_AT_ReplaceRelOptions: AlterTableType = 39;
pub const AlterTableType_AT_EnableTrig: AlterTableType = 40;
pub const AlterTableType_AT_EnableAlwaysTrig: AlterTableType = 41;
pub const AlterTableType_AT_EnableReplicaTrig: AlterTableType = 42;
pub const AlterTableType_AT_DisableTrig: AlterTableType = 43;
pub const AlterTableType_AT_EnableTrigAll: AlterTableType = 44;
pub const AlterTableType_AT_DisableTrigAll: AlterTableType = 45;
pub const AlterTableType_AT_EnableTrigUser: AlterTableType = 46;
pub const AlterTableType_AT_DisableTrigUser: AlterTableType = 47;
pub const AlterTableType_AT_EnableRule: AlterTableType = 48;
pub const AlterTableType_AT_EnableAlwaysRule: AlterTableType = 49;
pub const AlterTableType_AT_EnableReplicaRule: AlterTableType = 50;
pub const AlterTableType_AT_DisableRule: AlterTableType = 51;
pub const AlterTableType_AT_AddInherit: AlterTableType = 52;
pub const AlterTableType_AT_DropInherit: AlterTableType = 53;
pub const AlterTableType_AT_AddOf: AlterTableType = 54;
pub const AlterTableType_AT_DropOf: AlterTableType = 55;
pub const AlterTableType_AT_ReplicaIdentity: AlterTableType = 56;
pub const AlterTableType_AT_EnableRowSecurity: AlterTableType = 57;
pub const AlterTableType_AT_DisableRowSecurity: AlterTableType = 58;
pub const AlterTableType_AT_ForceRowSecurity: AlterTableType = 59;
pub const AlterTableType_AT_NoForceRowSecurity: AlterTableType = 60;
pub const AlterTableType_AT_GenericOptions: AlterTableType = 61;
pub const AlterTableType_AT_AttachPartition: AlterTableType = 62;
pub const AlterTableType_AT_DetachPartition: AlterTableType = 63;
pub const AlterTableType_AT_AddIdentity: AlterTableType = 64;
pub const AlterTableType_AT_SetIdentity: AlterTableType = 65;
pub const AlterTableType_AT_DropIdentity: AlterTableType = 66;
pub type AlterTableType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReplicaIdentityStmt {
    pub type_: NodeTag,
    pub identity_type: ::std::os::raw::c_char,
    pub name: *mut ::std::os::raw::c_char,
}
impl Default for ReplicaIdentityStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableCmd {
    pub type_: NodeTag,
    pub subtype: AlterTableType,
    pub name: *mut ::std::os::raw::c_char,
    pub num: int16,
    pub newowner: *mut RoleSpec,
    pub def: *mut Node,
    pub behavior: DropBehavior,
    pub missing_ok: bool,
    pub recurse: bool,
}
impl Default for AlterTableCmd {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterCollationStmt {
    pub type_: NodeTag,
    pub collname: *mut List,
}
impl Default for AlterCollationStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDomainStmt {
    pub type_: NodeTag,
    pub subtype: ::std::os::raw::c_char,
    pub typeName: *mut List,
    pub name: *mut ::std::os::raw::c_char,
    pub def: *mut Node,
    pub behavior: DropBehavior,
    pub missing_ok: bool,
}
impl Default for AlterDomainStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const GrantTargetType_ACL_TARGET_OBJECT: GrantTargetType = 0;
pub const GrantTargetType_ACL_TARGET_ALL_IN_SCHEMA: GrantTargetType = 1;
pub const GrantTargetType_ACL_TARGET_DEFAULTS: GrantTargetType = 2;
pub type GrantTargetType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GrantStmt {
    pub type_: NodeTag,
    pub is_grant: bool,
    pub targtype: GrantTargetType,
    pub objtype: ObjectType,
    pub objects: *mut List,
    pub privileges: *mut List,
    pub grantees: *mut List,
    pub grant_option: bool,
    pub behavior: DropBehavior,
}
impl Default for GrantStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectWithArgs {
    pub type_: NodeTag,
    pub objname: *mut List,
    pub objargs: *mut List,
    pub args_unspecified: bool,
}
impl Default for ObjectWithArgs {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AccessPriv {
    pub type_: NodeTag,
    pub priv_name: *mut ::std::os::raw::c_char,
    pub cols: *mut List,
}
impl Default for AccessPriv {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GrantRoleStmt {
    pub type_: NodeTag,
    pub granted_roles: *mut List,
    pub grantee_roles: *mut List,
    pub is_grant: bool,
    pub admin_opt: bool,
    pub grantor: *mut RoleSpec,
    pub behavior: DropBehavior,
}
impl Default for GrantRoleStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDefaultPrivilegesStmt {
    pub type_: NodeTag,
    pub options: *mut List,
    pub action: *mut GrantStmt,
}
impl Default for AlterDefaultPrivilegesStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CopyStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub query: *mut Node,
    pub attlist: *mut List,
    pub is_from: bool,
    pub is_program: bool,
    pub filename: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub whereClause: *mut Node,
}
impl Default for CopyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const VariableSetKind_VAR_SET_VALUE: VariableSetKind = 0;
pub const VariableSetKind_VAR_SET_DEFAULT: VariableSetKind = 1;
pub const VariableSetKind_VAR_SET_CURRENT: VariableSetKind = 2;
pub const VariableSetKind_VAR_SET_MULTI: VariableSetKind = 3;
pub const VariableSetKind_VAR_RESET: VariableSetKind = 4;
pub const VariableSetKind_VAR_RESET_ALL: VariableSetKind = 5;
pub type VariableSetKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VariableSetStmt {
    pub type_: NodeTag,
    pub kind: VariableSetKind,
    pub name: *mut ::std::os::raw::c_char,
    pub args: *mut List,
    pub is_local: bool,
}
impl Default for VariableSetStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VariableShowStmt {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
}
impl Default for VariableShowStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub tableElts: *mut List,
    pub inhRelations: *mut List,
    pub partbound: *mut PartitionBoundSpec,
    pub partspec: *mut PartitionSpec,
    pub ofTypename: *mut TypeName,
    pub constraints: *mut List,
    pub options: *mut List,
    pub oncommit: OnCommitAction,
    pub tablespacename: *mut ::std::os::raw::c_char,
    pub accessMethod: *mut ::std::os::raw::c_char,
    pub if_not_exists: bool,
}
impl Default for CreateStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ConstrType_CONSTR_NULL: ConstrType = 0;
pub const ConstrType_CONSTR_NOTNULL: ConstrType = 1;
pub const ConstrType_CONSTR_DEFAULT: ConstrType = 2;
pub const ConstrType_CONSTR_IDENTITY: ConstrType = 3;
pub const ConstrType_CONSTR_GENERATED: ConstrType = 4;
pub const ConstrType_CONSTR_CHECK: ConstrType = 5;
pub const ConstrType_CONSTR_PRIMARY: ConstrType = 6;
pub const ConstrType_CONSTR_UNIQUE: ConstrType = 7;
pub const ConstrType_CONSTR_EXCLUSION: ConstrType = 8;
pub const ConstrType_CONSTR_FOREIGN: ConstrType = 9;
pub const ConstrType_CONSTR_ATTR_DEFERRABLE: ConstrType = 10;
pub const ConstrType_CONSTR_ATTR_NOT_DEFERRABLE: ConstrType = 11;
pub const ConstrType_CONSTR_ATTR_DEFERRED: ConstrType = 12;
pub const ConstrType_CONSTR_ATTR_IMMEDIATE: ConstrType = 13;
pub type ConstrType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Constraint {
    pub type_: NodeTag,
    pub contype: ConstrType,
    pub conname: *mut ::std::os::raw::c_char,
    pub deferrable: bool,
    pub initdeferred: bool,
    pub location: ::std::os::raw::c_int,
    pub is_no_inherit: bool,
    pub raw_expr: *mut Node,
    pub cooked_expr: *mut ::std::os::raw::c_char,
    pub generated_when: ::std::os::raw::c_char,
    pub keys: *mut List,
    pub including: *mut List,
    pub exclusions: *mut List,
    pub options: *mut List,
    pub indexname: *mut ::std::os::raw::c_char,
    pub indexspace: *mut ::std::os::raw::c_char,
    pub reset_default_tblspc: bool,
    pub access_method: *mut ::std::os::raw::c_char,
    pub where_clause: *mut Node,
    pub pktable: *mut RangeVar,
    pub fk_attrs: *mut List,
    pub pk_attrs: *mut List,
    pub fk_matchtype: ::std::os::raw::c_char,
    pub fk_upd_action: ::std::os::raw::c_char,
    pub fk_del_action: ::std::os::raw::c_char,
    pub old_conpfeqop: *mut List,
    pub old_pktable_oid: Oid,
    pub skip_validation: bool,
    pub initially_valid: bool,
}
impl Default for Constraint {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateTableSpaceStmt {
    pub type_: NodeTag,
    pub tablespacename: *mut ::std::os::raw::c_char,
    pub owner: *mut RoleSpec,
    pub location: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for CreateTableSpaceStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropTableSpaceStmt {
    pub type_: NodeTag,
    pub tablespacename: *mut ::std::os::raw::c_char,
    pub missing_ok: bool,
}
impl Default for DropTableSpaceStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableSpaceOptionsStmt {
    pub type_: NodeTag,
    pub tablespacename: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub isReset: bool,
}
impl Default for AlterTableSpaceOptionsStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTableMoveAllStmt {
    pub type_: NodeTag,
    pub orig_tablespacename: *mut ::std::os::raw::c_char,
    pub objtype: ObjectType,
    pub roles: *mut List,
    pub new_tablespacename: *mut ::std::os::raw::c_char,
    pub nowait: bool,
}
impl Default for AlterTableMoveAllStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateExtensionStmt {
    pub type_: NodeTag,
    pub extname: *mut ::std::os::raw::c_char,
    pub if_not_exists: bool,
    pub options: *mut List,
}
impl Default for CreateExtensionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterExtensionStmt {
    pub type_: NodeTag,
    pub extname: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for AlterExtensionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterExtensionContentsStmt {
    pub type_: NodeTag,
    pub extname: *mut ::std::os::raw::c_char,
    pub action: ::std::os::raw::c_int,
    pub objtype: ObjectType,
    pub object: *mut Node,
}
impl Default for AlterExtensionContentsStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateFdwStmt {
    pub type_: NodeTag,
    pub fdwname: *mut ::std::os::raw::c_char,
    pub func_options: *mut List,
    pub options: *mut List,
}
impl Default for CreateFdwStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterFdwStmt {
    pub type_: NodeTag,
    pub fdwname: *mut ::std::os::raw::c_char,
    pub func_options: *mut List,
    pub options: *mut List,
}
impl Default for AlterFdwStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateForeignServerStmt {
    pub type_: NodeTag,
    pub servername: *mut ::std::os::raw::c_char,
    pub servertype: *mut ::std::os::raw::c_char,
    pub version: *mut ::std::os::raw::c_char,
    pub fdwname: *mut ::std::os::raw::c_char,
    pub if_not_exists: bool,
    pub options: *mut List,
}
impl Default for CreateForeignServerStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterForeignServerStmt {
    pub type_: NodeTag,
    pub servername: *mut ::std::os::raw::c_char,
    pub version: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub has_version: bool,
}
impl Default for AlterForeignServerStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateForeignTableStmt {
    pub base: CreateStmt,
    pub servername: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for CreateForeignTableStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateUserMappingStmt {
    pub type_: NodeTag,
    pub user: *mut RoleSpec,
    pub servername: *mut ::std::os::raw::c_char,
    pub if_not_exists: bool,
    pub options: *mut List,
}
impl Default for CreateUserMappingStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterUserMappingStmt {
    pub type_: NodeTag,
    pub user: *mut RoleSpec,
    pub servername: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for AlterUserMappingStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropUserMappingStmt {
    pub type_: NodeTag,
    pub user: *mut RoleSpec,
    pub servername: *mut ::std::os::raw::c_char,
    pub missing_ok: bool,
}
impl Default for DropUserMappingStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ImportForeignSchemaType_FDW_IMPORT_SCHEMA_ALL: ImportForeignSchemaType = 0;
pub const ImportForeignSchemaType_FDW_IMPORT_SCHEMA_LIMIT_TO: ImportForeignSchemaType = 1;
pub const ImportForeignSchemaType_FDW_IMPORT_SCHEMA_EXCEPT: ImportForeignSchemaType = 2;
pub type ImportForeignSchemaType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ImportForeignSchemaStmt {
    pub type_: NodeTag,
    pub server_name: *mut ::std::os::raw::c_char,
    pub remote_schema: *mut ::std::os::raw::c_char,
    pub local_schema: *mut ::std::os::raw::c_char,
    pub list_type: ImportForeignSchemaType,
    pub table_list: *mut List,
    pub options: *mut List,
}
impl Default for ImportForeignSchemaStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreatePolicyStmt {
    pub type_: NodeTag,
    pub policy_name: *mut ::std::os::raw::c_char,
    pub table: *mut RangeVar,
    pub cmd_name: *mut ::std::os::raw::c_char,
    pub permissive: bool,
    pub roles: *mut List,
    pub qual: *mut Node,
    pub with_check: *mut Node,
}
impl Default for CreatePolicyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterPolicyStmt {
    pub type_: NodeTag,
    pub policy_name: *mut ::std::os::raw::c_char,
    pub table: *mut RangeVar,
    pub roles: *mut List,
    pub qual: *mut Node,
    pub with_check: *mut Node,
}
impl Default for AlterPolicyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateAmStmt {
    pub type_: NodeTag,
    pub amname: *mut ::std::os::raw::c_char,
    pub handler_name: *mut List,
    pub amtype: ::std::os::raw::c_char,
}
impl Default for CreateAmStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateTrigStmt {
    pub type_: NodeTag,
    pub trigname: *mut ::std::os::raw::c_char,
    pub relation: *mut RangeVar,
    pub funcname: *mut List,
    pub args: *mut List,
    pub row: bool,
    pub timing: int16,
    pub events: int16,
    pub columns: *mut List,
    pub whenClause: *mut Node,
    pub isconstraint: bool,
    pub transitionRels: *mut List,
    pub deferrable: bool,
    pub initdeferred: bool,
    pub constrrel: *mut RangeVar,
}
impl Default for CreateTrigStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateEventTrigStmt {
    pub type_: NodeTag,
    pub trigname: *mut ::std::os::raw::c_char,
    pub eventname: *mut ::std::os::raw::c_char,
    pub whenclause: *mut List,
    pub funcname: *mut List,
}
impl Default for CreateEventTrigStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterEventTrigStmt {
    pub type_: NodeTag,
    pub trigname: *mut ::std::os::raw::c_char,
    pub tgenabled: ::std::os::raw::c_char,
}
impl Default for AlterEventTrigStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreatePLangStmt {
    pub type_: NodeTag,
    pub replace: bool,
    pub plname: *mut ::std::os::raw::c_char,
    pub plhandler: *mut List,
    pub plinline: *mut List,
    pub plvalidator: *mut List,
    pub pltrusted: bool,
}
impl Default for CreatePLangStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RoleStmtType_ROLESTMT_ROLE: RoleStmtType = 0;
pub const RoleStmtType_ROLESTMT_USER: RoleStmtType = 1;
pub const RoleStmtType_ROLESTMT_GROUP: RoleStmtType = 2;
pub type RoleStmtType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateRoleStmt {
    pub type_: NodeTag,
    pub stmt_type: RoleStmtType,
    pub role: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for CreateRoleStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterRoleStmt {
    pub type_: NodeTag,
    pub role: *mut RoleSpec,
    pub options: *mut List,
    pub action: ::std::os::raw::c_int,
}
impl Default for AlterRoleStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterRoleSetStmt {
    pub type_: NodeTag,
    pub role: *mut RoleSpec,
    pub database: *mut ::std::os::raw::c_char,
    pub setstmt: *mut VariableSetStmt,
}
impl Default for AlterRoleSetStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropRoleStmt {
    pub type_: NodeTag,
    pub roles: *mut List,
    pub missing_ok: bool,
}
impl Default for DropRoleStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateSeqStmt {
    pub type_: NodeTag,
    pub sequence: *mut RangeVar,
    pub options: *mut List,
    pub ownerId: Oid,
    pub for_identity: bool,
    pub if_not_exists: bool,
}
impl Default for CreateSeqStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterSeqStmt {
    pub type_: NodeTag,
    pub sequence: *mut RangeVar,
    pub options: *mut List,
    pub for_identity: bool,
    pub missing_ok: bool,
}
impl Default for AlterSeqStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DefineStmt {
    pub type_: NodeTag,
    pub kind: ObjectType,
    pub oldstyle: bool,
    pub defnames: *mut List,
    pub args: *mut List,
    pub definition: *mut List,
    pub if_not_exists: bool,
    pub replace: bool,
}
impl Default for DefineStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateDomainStmt {
    pub type_: NodeTag,
    pub domainname: *mut List,
    pub typeName: *mut TypeName,
    pub collClause: *mut CollateClause,
    pub constraints: *mut List,
}
impl Default for CreateDomainStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateOpClassStmt {
    pub type_: NodeTag,
    pub opclassname: *mut List,
    pub opfamilyname: *mut List,
    pub amname: *mut ::std::os::raw::c_char,
    pub datatype: *mut TypeName,
    pub items: *mut List,
    pub isDefault: bool,
}
impl Default for CreateOpClassStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateOpClassItem {
    pub type_: NodeTag,
    pub itemtype: ::std::os::raw::c_int,
    pub name: *mut ObjectWithArgs,
    pub number: ::std::os::raw::c_int,
    pub order_family: *mut List,
    pub class_args: *mut List,
    pub storedtype: *mut TypeName,
}
impl Default for CreateOpClassItem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateOpFamilyStmt {
    pub type_: NodeTag,
    pub opfamilyname: *mut List,
    pub amname: *mut ::std::os::raw::c_char,
}
impl Default for CreateOpFamilyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterOpFamilyStmt {
    pub type_: NodeTag,
    pub opfamilyname: *mut List,
    pub amname: *mut ::std::os::raw::c_char,
    pub isDrop: bool,
    pub items: *mut List,
}
impl Default for AlterOpFamilyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropStmt {
    pub type_: NodeTag,
    pub objects: *mut List,
    pub removeType: ObjectType,
    pub behavior: DropBehavior,
    pub missing_ok: bool,
    pub concurrent: bool,
}
impl Default for DropStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TruncateStmt {
    pub type_: NodeTag,
    pub relations: *mut List,
    pub restart_seqs: bool,
    pub behavior: DropBehavior,
}
impl Default for TruncateStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CommentStmt {
    pub type_: NodeTag,
    pub objtype: ObjectType,
    pub object: *mut Node,
    pub comment: *mut ::std::os::raw::c_char,
}
impl Default for CommentStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SecLabelStmt {
    pub type_: NodeTag,
    pub objtype: ObjectType,
    pub object: *mut Node,
    pub provider: *mut ::std::os::raw::c_char,
    pub label: *mut ::std::os::raw::c_char,
}
impl Default for SecLabelStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeclareCursorStmt {
    pub type_: NodeTag,
    pub portalname: *mut ::std::os::raw::c_char,
    pub options: ::std::os::raw::c_int,
    pub query: *mut Node,
}
impl Default for DeclareCursorStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ClosePortalStmt {
    pub type_: NodeTag,
    pub portalname: *mut ::std::os::raw::c_char,
}
impl Default for ClosePortalStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const FetchDirection_FETCH_FORWARD: FetchDirection = 0;
pub const FetchDirection_FETCH_BACKWARD: FetchDirection = 1;
pub const FetchDirection_FETCH_ABSOLUTE: FetchDirection = 2;
pub const FetchDirection_FETCH_RELATIVE: FetchDirection = 3;
pub type FetchDirection = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FetchStmt {
    pub type_: NodeTag,
    pub direction: FetchDirection,
    pub howMany: ::std::os::raw::c_long,
    pub portalname: *mut ::std::os::raw::c_char,
    pub ismove: bool,
}
impl Default for FetchStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexStmt {
    pub type_: NodeTag,
    pub idxname: *mut ::std::os::raw::c_char,
    pub relation: *mut RangeVar,
    pub accessMethod: *mut ::std::os::raw::c_char,
    pub tableSpace: *mut ::std::os::raw::c_char,
    pub indexParams: *mut List,
    pub indexIncludingParams: *mut List,
    pub options: *mut List,
    pub whereClause: *mut Node,
    pub excludeOpNames: *mut List,
    pub idxcomment: *mut ::std::os::raw::c_char,
    pub indexOid: Oid,
    pub oldNode: Oid,
    pub oldCreateSubid: SubTransactionId,
    pub oldFirstRelfilenodeSubid: SubTransactionId,
    pub unique: bool,
    pub primary: bool,
    pub isconstraint: bool,
    pub deferrable: bool,
    pub initdeferred: bool,
    pub transformed: bool,
    pub concurrent: bool,
    pub if_not_exists: bool,
    pub reset_default_tblspc: bool,
}
impl Default for IndexStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateStatsStmt {
    pub type_: NodeTag,
    pub defnames: *mut List,
    pub stat_types: *mut List,
    pub exprs: *mut List,
    pub relations: *mut List,
    pub stxcomment: *mut ::std::os::raw::c_char,
    pub if_not_exists: bool,
}
impl Default for CreateStatsStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterStatsStmt {
    pub type_: NodeTag,
    pub defnames: *mut List,
    pub stxstattarget: ::std::os::raw::c_int,
    pub missing_ok: bool,
}
impl Default for AlterStatsStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateFunctionStmt {
    pub type_: NodeTag,
    pub is_procedure: bool,
    pub replace: bool,
    pub funcname: *mut List,
    pub parameters: *mut List,
    pub returnType: *mut TypeName,
    pub options: *mut List,
}
impl Default for CreateFunctionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const FunctionParameterMode_FUNC_PARAM_IN: FunctionParameterMode = 105;
pub const FunctionParameterMode_FUNC_PARAM_OUT: FunctionParameterMode = 111;
pub const FunctionParameterMode_FUNC_PARAM_INOUT: FunctionParameterMode = 98;
pub const FunctionParameterMode_FUNC_PARAM_VARIADIC: FunctionParameterMode = 118;
pub const FunctionParameterMode_FUNC_PARAM_TABLE: FunctionParameterMode = 116;
pub type FunctionParameterMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FunctionParameter {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub argType: *mut TypeName,
    pub mode: FunctionParameterMode,
    pub defexpr: *mut Node,
}
impl Default for FunctionParameter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterFunctionStmt {
    pub type_: NodeTag,
    pub objtype: ObjectType,
    pub func: *mut ObjectWithArgs,
    pub actions: *mut List,
}
impl Default for AlterFunctionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DoStmt {
    pub type_: NodeTag,
    pub args: *mut List,
}
impl Default for DoStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InlineCodeBlock {
    pub type_: NodeTag,
    pub source_text: *mut ::std::os::raw::c_char,
    pub langOid: Oid,
    pub langIsTrusted: bool,
    pub atomic: bool,
}
impl Default for InlineCodeBlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CallStmt {
    pub type_: NodeTag,
    pub funccall: *mut FuncCall,
    pub funcexpr: *mut FuncExpr,
}
impl Default for CallStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CallContext {
    pub type_: NodeTag,
    pub atomic: bool,
}
impl Default for CallContext {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RenameStmt {
    pub type_: NodeTag,
    pub renameType: ObjectType,
    pub relationType: ObjectType,
    pub relation: *mut RangeVar,
    pub object: *mut Node,
    pub subname: *mut ::std::os::raw::c_char,
    pub newname: *mut ::std::os::raw::c_char,
    pub behavior: DropBehavior,
    pub missing_ok: bool,
}
impl Default for RenameStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterObjectDependsStmt {
    pub type_: NodeTag,
    pub objectType: ObjectType,
    pub relation: *mut RangeVar,
    pub object: *mut Node,
    pub extname: *mut Value,
    pub remove: bool,
}
impl Default for AlterObjectDependsStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterObjectSchemaStmt {
    pub type_: NodeTag,
    pub objectType: ObjectType,
    pub relation: *mut RangeVar,
    pub object: *mut Node,
    pub newschema: *mut ::std::os::raw::c_char,
    pub missing_ok: bool,
}
impl Default for AlterObjectSchemaStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterOwnerStmt {
    pub type_: NodeTag,
    pub objectType: ObjectType,
    pub relation: *mut RangeVar,
    pub object: *mut Node,
    pub newowner: *mut RoleSpec,
}
impl Default for AlterOwnerStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterOperatorStmt {
    pub type_: NodeTag,
    pub opername: *mut ObjectWithArgs,
    pub options: *mut List,
}
impl Default for AlterOperatorStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTypeStmt {
    pub type_: NodeTag,
    pub typeName: *mut List,
    pub options: *mut List,
}
impl Default for AlterTypeStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RuleStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub rulename: *mut ::std::os::raw::c_char,
    pub whereClause: *mut Node,
    pub event: CmdType,
    pub instead: bool,
    pub actions: *mut List,
    pub replace: bool,
}
impl Default for RuleStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NotifyStmt {
    pub type_: NodeTag,
    pub conditionname: *mut ::std::os::raw::c_char,
    pub payload: *mut ::std::os::raw::c_char,
}
impl Default for NotifyStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ListenStmt {
    pub type_: NodeTag,
    pub conditionname: *mut ::std::os::raw::c_char,
}
impl Default for ListenStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UnlistenStmt {
    pub type_: NodeTag,
    pub conditionname: *mut ::std::os::raw::c_char,
}
impl Default for UnlistenStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const TransactionStmtKind_TRANS_STMT_BEGIN: TransactionStmtKind = 0;
pub const TransactionStmtKind_TRANS_STMT_START: TransactionStmtKind = 1;
pub const TransactionStmtKind_TRANS_STMT_COMMIT: TransactionStmtKind = 2;
pub const TransactionStmtKind_TRANS_STMT_ROLLBACK: TransactionStmtKind = 3;
pub const TransactionStmtKind_TRANS_STMT_SAVEPOINT: TransactionStmtKind = 4;
pub const TransactionStmtKind_TRANS_STMT_RELEASE: TransactionStmtKind = 5;
pub const TransactionStmtKind_TRANS_STMT_ROLLBACK_TO: TransactionStmtKind = 6;
pub const TransactionStmtKind_TRANS_STMT_PREPARE: TransactionStmtKind = 7;
pub const TransactionStmtKind_TRANS_STMT_COMMIT_PREPARED: TransactionStmtKind = 8;
pub const TransactionStmtKind_TRANS_STMT_ROLLBACK_PREPARED: TransactionStmtKind = 9;
pub type TransactionStmtKind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TransactionStmt {
    pub type_: NodeTag,
    pub kind: TransactionStmtKind,
    pub options: *mut List,
    pub savepoint_name: *mut ::std::os::raw::c_char,
    pub gid: *mut ::std::os::raw::c_char,
    pub chain: bool,
}
impl Default for TransactionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CompositeTypeStmt {
    pub type_: NodeTag,
    pub typevar: *mut RangeVar,
    pub coldeflist: *mut List,
}
impl Default for CompositeTypeStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateEnumStmt {
    pub type_: NodeTag,
    pub typeName: *mut List,
    pub vals: *mut List,
}
impl Default for CreateEnumStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateRangeStmt {
    pub type_: NodeTag,
    pub typeName: *mut List,
    pub params: *mut List,
}
impl Default for CreateRangeStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterEnumStmt {
    pub type_: NodeTag,
    pub typeName: *mut List,
    pub oldVal: *mut ::std::os::raw::c_char,
    pub newVal: *mut ::std::os::raw::c_char,
    pub newValNeighbor: *mut ::std::os::raw::c_char,
    pub newValIsAfter: bool,
    pub skipIfNewValExists: bool,
}
impl Default for AlterEnumStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ViewCheckOption_NO_CHECK_OPTION: ViewCheckOption = 0;
pub const ViewCheckOption_LOCAL_CHECK_OPTION: ViewCheckOption = 1;
pub const ViewCheckOption_CASCADED_CHECK_OPTION: ViewCheckOption = 2;
pub type ViewCheckOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ViewStmt {
    pub type_: NodeTag,
    pub view: *mut RangeVar,
    pub aliases: *mut List,
    pub query: *mut Node,
    pub replace: bool,
    pub options: *mut List,
    pub withCheckOption: ViewCheckOption,
}
impl Default for ViewStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LoadStmt {
    pub type_: NodeTag,
    pub filename: *mut ::std::os::raw::c_char,
}
impl Default for LoadStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreatedbStmt {
    pub type_: NodeTag,
    pub dbname: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for CreatedbStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDatabaseStmt {
    pub type_: NodeTag,
    pub dbname: *mut ::std::os::raw::c_char,
    pub options: *mut List,
}
impl Default for AlterDatabaseStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterDatabaseSetStmt {
    pub type_: NodeTag,
    pub dbname: *mut ::std::os::raw::c_char,
    pub setstmt: *mut VariableSetStmt,
}
impl Default for AlterDatabaseSetStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropdbStmt {
    pub type_: NodeTag,
    pub dbname: *mut ::std::os::raw::c_char,
    pub missing_ok: bool,
    pub options: *mut List,
}
impl Default for DropdbStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterSystemStmt {
    pub type_: NodeTag,
    pub setstmt: *mut VariableSetStmt,
}
impl Default for AlterSystemStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ClusterOption_CLUOPT_RECHECK: ClusterOption = 1;
pub const ClusterOption_CLUOPT_VERBOSE: ClusterOption = 2;
pub type ClusterOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ClusterStmt {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub indexname: *mut ::std::os::raw::c_char,
    pub options: ::std::os::raw::c_int,
}
impl Default for ClusterStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VacuumStmt {
    pub type_: NodeTag,
    pub options: *mut List,
    pub rels: *mut List,
    pub is_vacuumcmd: bool,
}
impl Default for VacuumStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VacuumRelation {
    pub type_: NodeTag,
    pub relation: *mut RangeVar,
    pub oid: Oid,
    pub va_cols: *mut List,
}
impl Default for VacuumRelation {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExplainStmt {
    pub type_: NodeTag,
    pub query: *mut Node,
    pub options: *mut List,
}
impl Default for ExplainStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateTableAsStmt {
    pub type_: NodeTag,
    pub query: *mut Node,
    pub into: *mut IntoClause,
    pub relkind: ObjectType,
    pub is_select_into: bool,
    pub if_not_exists: bool,
}
impl Default for CreateTableAsStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RefreshMatViewStmt {
    pub type_: NodeTag,
    pub concurrent: bool,
    pub skipData: bool,
    pub relation: *mut RangeVar,
}
impl Default for RefreshMatViewStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CheckPointStmt {
    pub type_: NodeTag,
}
impl Default for CheckPointStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DiscardMode_DISCARD_ALL: DiscardMode = 0;
pub const DiscardMode_DISCARD_PLANS: DiscardMode = 1;
pub const DiscardMode_DISCARD_SEQUENCES: DiscardMode = 2;
pub const DiscardMode_DISCARD_TEMP: DiscardMode = 3;
pub type DiscardMode = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DiscardStmt {
    pub type_: NodeTag,
    pub target: DiscardMode,
}
impl Default for DiscardStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockStmt {
    pub type_: NodeTag,
    pub relations: *mut List,
    pub mode: ::std::os::raw::c_int,
    pub nowait: bool,
}
impl Default for LockStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ConstraintsSetStmt {
    pub type_: NodeTag,
    pub constraints: *mut List,
    pub deferred: bool,
}
impl Default for ConstraintsSetStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ReindexObjectType_REINDEX_OBJECT_INDEX: ReindexObjectType = 0;
pub const ReindexObjectType_REINDEX_OBJECT_TABLE: ReindexObjectType = 1;
pub const ReindexObjectType_REINDEX_OBJECT_SCHEMA: ReindexObjectType = 2;
pub const ReindexObjectType_REINDEX_OBJECT_SYSTEM: ReindexObjectType = 3;
pub const ReindexObjectType_REINDEX_OBJECT_DATABASE: ReindexObjectType = 4;
pub type ReindexObjectType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReindexStmt {
    pub type_: NodeTag,
    pub kind: ReindexObjectType,
    pub relation: *mut RangeVar,
    pub name: *const ::std::os::raw::c_char,
    pub options: ::std::os::raw::c_int,
    pub concurrent: bool,
}
impl Default for ReindexStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateConversionStmt {
    pub type_: NodeTag,
    pub conversion_name: *mut List,
    pub for_encoding_name: *mut ::std::os::raw::c_char,
    pub to_encoding_name: *mut ::std::os::raw::c_char,
    pub func_name: *mut List,
    pub def: bool,
}
impl Default for CreateConversionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateCastStmt {
    pub type_: NodeTag,
    pub sourcetype: *mut TypeName,
    pub targettype: *mut TypeName,
    pub func: *mut ObjectWithArgs,
    pub context: CoercionContext,
    pub inout: bool,
}
impl Default for CreateCastStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateTransformStmt {
    pub type_: NodeTag,
    pub replace: bool,
    pub type_name: *mut TypeName,
    pub lang: *mut ::std::os::raw::c_char,
    pub fromsql: *mut ObjectWithArgs,
    pub tosql: *mut ObjectWithArgs,
}
impl Default for CreateTransformStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PrepareStmt {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub argtypes: *mut List,
    pub query: *mut Node,
}
impl Default for PrepareStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExecuteStmt {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
    pub params: *mut List,
}
impl Default for ExecuteStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeallocateStmt {
    pub type_: NodeTag,
    pub name: *mut ::std::os::raw::c_char,
}
impl Default for DeallocateStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropOwnedStmt {
    pub type_: NodeTag,
    pub roles: *mut List,
    pub behavior: DropBehavior,
}
impl Default for DropOwnedStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ReassignOwnedStmt {
    pub type_: NodeTag,
    pub roles: *mut List,
    pub newrole: *mut RoleSpec,
}
impl Default for ReassignOwnedStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTSDictionaryStmt {
    pub type_: NodeTag,
    pub dictname: *mut List,
    pub options: *mut List,
}
impl Default for AlterTSDictionaryStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const AlterTSConfigType_ALTER_TSCONFIG_ADD_MAPPING: AlterTSConfigType = 0;
pub const AlterTSConfigType_ALTER_TSCONFIG_ALTER_MAPPING_FOR_TOKEN: AlterTSConfigType = 1;
pub const AlterTSConfigType_ALTER_TSCONFIG_REPLACE_DICT: AlterTSConfigType = 2;
pub const AlterTSConfigType_ALTER_TSCONFIG_REPLACE_DICT_FOR_TOKEN: AlterTSConfigType = 3;
pub const AlterTSConfigType_ALTER_TSCONFIG_DROP_MAPPING: AlterTSConfigType = 4;
pub type AlterTSConfigType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterTSConfigurationStmt {
    pub type_: NodeTag,
    pub kind: AlterTSConfigType,
    pub cfgname: *mut List,
    pub tokentype: *mut List,
    pub dicts: *mut List,
    pub override_: bool,
    pub replace: bool,
    pub missing_ok: bool,
}
impl Default for AlterTSConfigurationStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreatePublicationStmt {
    pub type_: NodeTag,
    pub pubname: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub tables: *mut List,
    pub for_all_tables: bool,
}
impl Default for CreatePublicationStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterPublicationStmt {
    pub type_: NodeTag,
    pub pubname: *mut ::std::os::raw::c_char,
    pub options: *mut List,
    pub tables: *mut List,
    pub for_all_tables: bool,
    pub tableAction: DefElemAction,
}
impl Default for AlterPublicationStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateSubscriptionStmt {
    pub type_: NodeTag,
    pub subname: *mut ::std::os::raw::c_char,
    pub conninfo: *mut ::std::os::raw::c_char,
    pub publication: *mut List,
    pub options: *mut List,
}
impl Default for CreateSubscriptionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const AlterSubscriptionType_ALTER_SUBSCRIPTION_OPTIONS: AlterSubscriptionType = 0;
pub const AlterSubscriptionType_ALTER_SUBSCRIPTION_CONNECTION: AlterSubscriptionType = 1;
pub const AlterSubscriptionType_ALTER_SUBSCRIPTION_PUBLICATION: AlterSubscriptionType = 2;
pub const AlterSubscriptionType_ALTER_SUBSCRIPTION_REFRESH: AlterSubscriptionType = 3;
pub const AlterSubscriptionType_ALTER_SUBSCRIPTION_ENABLED: AlterSubscriptionType = 4;
pub type AlterSubscriptionType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AlterSubscriptionStmt {
    pub type_: NodeTag,
    pub kind: AlterSubscriptionType,
    pub subname: *mut ::std::os::raw::c_char,
    pub conninfo: *mut ::std::os::raw::c_char,
    pub publication: *mut List,
    pub options: *mut List,
}
impl Default for AlterSubscriptionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DropSubscriptionStmt {
    pub type_: NodeTag,
    pub subname: *mut ::std::os::raw::c_char,
    pub missing_ok: bool,
    pub behavior: DropBehavior,
}
impl Default for DropSubscriptionStmt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct MemoryContextCounters {
    pub nblocks: Size,
    pub freechunks: Size,
    pub totalspace: Size,
    pub freespace: Size,
}
pub type MemoryStatsPrintFunc = ::std::option::Option<
    unsafe extern "C" fn(
        context: MemoryContext,
        passthru: *mut ::std::os::raw::c_void,
        stats_string: *const ::std::os::raw::c_char,
    ),
>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct MemoryContextMethods {
    pub alloc: ::std::option::Option<
        unsafe extern "C" fn(context: MemoryContext, size: Size) -> *mut ::std::os::raw::c_void,
    >,
    pub free_p: ::std::option::Option<
        unsafe extern "C" fn(context: MemoryContext, pointer: *mut ::std::os::raw::c_void),
    >,
    pub realloc: ::std::option::Option<
        unsafe extern "C" fn(
            context: MemoryContext,
            pointer: *mut ::std::os::raw::c_void,
            size: Size,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub reset: ::std::option::Option<unsafe extern "C" fn(context: MemoryContext)>,
    pub delete_context: ::std::option::Option<unsafe extern "C" fn(context: MemoryContext)>,
    pub get_chunk_space: ::std::option::Option<
        unsafe extern "C" fn(context: MemoryContext, pointer: *mut ::std::os::raw::c_void) -> Size,
    >,
    pub is_empty: ::std::option::Option<unsafe extern "C" fn(context: MemoryContext) -> bool>,
    pub stats: ::std::option::Option<
        unsafe extern "C" fn(
            context: MemoryContext,
            printfunc: MemoryStatsPrintFunc,
            passthru: *mut ::std::os::raw::c_void,
            totals: *mut MemoryContextCounters,
        ),
    >,
    pub check: ::std::option::Option<unsafe extern "C" fn(context: MemoryContext)>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MemoryContextData {
    pub type_: NodeTag,
    pub isReset: bool,
    pub allowInCritSection: bool,
    pub mem_allocated: Size,
    pub methods: *const MemoryContextMethods,
    pub parent: MemoryContext,
    pub firstchild: MemoryContext,
    pub prevchild: MemoryContext,
    pub nextchild: MemoryContext,
    pub name: *const ::std::os::raw::c_char,
    pub ident: *const ::std::os::raw::c_char,
    pub reset_cbs: *mut MemoryContextCallback,
}
impl Default for MemoryContextData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut TopMemoryContext: MemoryContext;
}
extern "C" {
    pub static mut ErrorContext: MemoryContext;
}
extern "C" {
    pub static mut PostmasterContext: MemoryContext;
}
extern "C" {
    pub static mut CacheMemoryContext: MemoryContext;
}
extern "C" {
    pub static mut MessageContext: MemoryContext;
}
extern "C" {
    pub static mut TopTransactionContext: MemoryContext;
}
extern "C" {
    pub static mut CurTransactionContext: MemoryContext;
}
extern "C" {
    pub static mut PortalContext: MemoryContext;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextInit();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextReset(context: MemoryContext);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextDelete(context: MemoryContext);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextResetOnly(context: MemoryContext);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextResetChildren(context: MemoryContext);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextDeleteChildren(context: MemoryContext);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextSetIdentifier(context: MemoryContext, id: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextSetParent(context: MemoryContext, new_parent: MemoryContext);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetMemoryChunkSpace(pointer: *mut ::std::os::raw::c_void) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextGetParent(context: MemoryContext) -> MemoryContext;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextIsEmpty(context: MemoryContext) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextMemAllocated(context: MemoryContext, recurse: bool) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextStats(context: MemoryContext);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextStatsDetail(context: MemoryContext, max_children: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextAllowInCriticalSection(context: MemoryContext, allow: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextCheck(context: MemoryContext);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextContains(
        context: MemoryContext,
        pointer: *mut ::std::os::raw::c_void,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MemoryContextCreate(
        node: MemoryContext,
        tag: NodeTag,
        methods: *const MemoryContextMethods,
        parent: MemoryContext,
        name: *const ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AllocSetContextCreateInternal(
        parent: MemoryContext,
        name: *const ::std::os::raw::c_char,
        minContextSize: Size,
        initBlockSize: Size,
        maxBlockSize: Size,
    ) -> MemoryContext;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SlabContextCreate(
        parent: MemoryContext,
        name: *const ::std::os::raw::c_char,
        blockSize: Size,
        chunkSize: Size,
    ) -> MemoryContext;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GenerationContextCreate(
        parent: MemoryContext,
        name: *const ::std::os::raw::c_char,
        blockSize: Size,
    ) -> MemoryContext;
}
pub type ExecutorStart_hook_type = ::std::option::Option<
    unsafe extern "C" fn(queryDesc: *mut QueryDesc, eflags: ::std::os::raw::c_int),
>;
extern "C" {
    pub static mut ExecutorStart_hook: ExecutorStart_hook_type;
}
pub type ExecutorRun_hook_type = ::std::option::Option<
    unsafe extern "C" fn(
        queryDesc: *mut QueryDesc,
        direction: ScanDirection,
        count: uint64,
        execute_once: bool,
    ),
>;
extern "C" {
    pub static mut ExecutorRun_hook: ExecutorRun_hook_type;
}
pub type ExecutorFinish_hook_type =
    ::std::option::Option<unsafe extern "C" fn(queryDesc: *mut QueryDesc)>;
extern "C" {
    pub static mut ExecutorFinish_hook: ExecutorFinish_hook_type;
}
pub type ExecutorEnd_hook_type =
    ::std::option::Option<unsafe extern "C" fn(queryDesc: *mut QueryDesc)>;
extern "C" {
    pub static mut ExecutorEnd_hook: ExecutorEnd_hook_type;
}
pub type ExecutorCheckPerms_hook_type =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut List, arg2: bool) -> bool>;
extern "C" {
    pub static mut ExecutorCheckPerms_hook: ExecutorCheckPerms_hook_type;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecReScan(node: *mut PlanState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecMarkPos(node: *mut PlanState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecRestrPos(node: *mut PlanState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecSupportsMarkRestore(pathnode: *mut Path) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecSupportsBackwardScan(node: *mut Plan) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecMaterializesOutput(plantype: NodeTag) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn execCurrentOf(
        cexpr: *mut CurrentOfExpr,
        econtext: *mut ExprContext,
        table_oid: Oid,
        current_tid: ItemPointer,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn execTuplesMatchPrepare(
        desc: TupleDesc,
        numCols: ::std::os::raw::c_int,
        keyColIdx: *const AttrNumber,
        eqOperators: *const Oid,
        collations: *const Oid,
        parent: *mut PlanState,
    ) -> *mut ExprState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn execTuplesHashPrepare(
        numCols: ::std::os::raw::c_int,
        eqOperators: *const Oid,
        eqFuncOids: *mut *mut Oid,
        hashFunctions: *mut *mut FmgrInfo,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BuildTupleHashTable(
        parent: *mut PlanState,
        inputDesc: TupleDesc,
        numCols: ::std::os::raw::c_int,
        keyColIdx: *mut AttrNumber,
        eqfuncoids: *const Oid,
        hashfunctions: *mut FmgrInfo,
        collations: *mut Oid,
        nbuckets: ::std::os::raw::c_long,
        additionalsize: Size,
        tablecxt: MemoryContext,
        tempcxt: MemoryContext,
        use_variable_hash_iv: bool,
    ) -> TupleHashTable;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BuildTupleHashTableExt(
        parent: *mut PlanState,
        inputDesc: TupleDesc,
        numCols: ::std::os::raw::c_int,
        keyColIdx: *mut AttrNumber,
        eqfuncoids: *const Oid,
        hashfunctions: *mut FmgrInfo,
        collations: *mut Oid,
        nbuckets: ::std::os::raw::c_long,
        additionalsize: Size,
        metacxt: MemoryContext,
        tablecxt: MemoryContext,
        tempcxt: MemoryContext,
        use_variable_hash_iv: bool,
    ) -> TupleHashTable;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LookupTupleHashEntry(
        hashtable: TupleHashTable,
        slot: *mut TupleTableSlot,
        isnew: *mut bool,
        hash: *mut uint32,
    ) -> TupleHashEntry;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TupleHashTableHash(hashtable: TupleHashTable, slot: *mut TupleTableSlot) -> uint32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LookupTupleHashEntryHash(
        hashtable: TupleHashTable,
        slot: *mut TupleTableSlot,
        isnew: *mut bool,
        hash: uint32,
    ) -> TupleHashEntry;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FindTupleHashEntry(
        hashtable: TupleHashTable,
        slot: *mut TupleTableSlot,
        eqcomp: *mut ExprState,
        hashfunctions: *mut FmgrInfo,
    ) -> TupleHashEntry;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ResetTupleHashTable(hashtable: TupleHashTable);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInitJunkFilter(targetList: *mut List, slot: *mut TupleTableSlot) -> *mut JunkFilter;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInitJunkFilterInsertion(
        targetList: *mut List,
        cleanTupType: TupleDesc,
        slot: *mut TupleTableSlot,
    ) -> *mut JunkFilter;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInitJunkFilterConversion(
        targetList: *mut List,
        cleanTupType: TupleDesc,
        slot: *mut TupleTableSlot,
    ) -> *mut JunkFilter;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecFindJunkAttribute(
        junkfilter: *mut JunkFilter,
        attrName: *const ::std::os::raw::c_char,
    ) -> AttrNumber;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecFindJunkAttributeInTlist(
        targetlist: *mut List,
        attrName: *const ::std::os::raw::c_char,
    ) -> AttrNumber;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecGetJunkAttribute(
        slot: *mut TupleTableSlot,
        attno: AttrNumber,
        isNull: *mut bool,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecFilterJunk(
        junkfilter: *mut JunkFilter,
        slot: *mut TupleTableSlot,
    ) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecutorStart(queryDesc: *mut QueryDesc, eflags: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn standard_ExecutorStart(queryDesc: *mut QueryDesc, eflags: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecutorRun(
        queryDesc: *mut QueryDesc,
        direction: ScanDirection,
        count: uint64,
        execute_once: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn standard_ExecutorRun(
        queryDesc: *mut QueryDesc,
        direction: ScanDirection,
        count: uint64,
        execute_once: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecutorFinish(queryDesc: *mut QueryDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn standard_ExecutorFinish(queryDesc: *mut QueryDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecutorEnd(queryDesc: *mut QueryDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn standard_ExecutorEnd(queryDesc: *mut QueryDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecutorRewind(queryDesc: *mut QueryDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecCheckRTPerms(rangeTable: *mut List, ereport_on_violation: bool) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CheckValidResultRel(resultRelInfo: *mut ResultRelInfo, operation: CmdType);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitResultRelInfo(
        resultRelInfo: *mut ResultRelInfo,
        resultRelationDesc: Relation,
        resultRelationIndex: Index,
        partition_root_rri: *mut ResultRelInfo,
        instrument_options: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecGetTriggerResultRel(estate: *mut EState, relid: Oid) -> *mut ResultRelInfo;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecCleanUpTriggerState(estate: *mut EState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecConstraints(
        resultRelInfo: *mut ResultRelInfo,
        slot: *mut TupleTableSlot,
        estate: *mut EState,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecPartitionCheck(
        resultRelInfo: *mut ResultRelInfo,
        slot: *mut TupleTableSlot,
        estate: *mut EState,
        emitError: bool,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecPartitionCheckEmitError(
        resultRelInfo: *mut ResultRelInfo,
        slot: *mut TupleTableSlot,
        estate: *mut EState,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecWithCheckOptions(
        kind: WCOKind,
        resultRelInfo: *mut ResultRelInfo,
        slot: *mut TupleTableSlot,
        estate: *mut EState,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecUpdateLockMode(estate: *mut EState, relinfo: *mut ResultRelInfo) -> LockTupleMode;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecFindRowMark(estate: *mut EState, rti: Index, missing_ok: bool) -> *mut ExecRowMark;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecBuildAuxRowMark(erm: *mut ExecRowMark, targetlist: *mut List)
        -> *mut ExecAuxRowMark;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EvalPlanQual(
        epqstate: *mut EPQState,
        relation: Relation,
        rti: Index,
        testslot: *mut TupleTableSlot,
    ) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EvalPlanQualInit(
        epqstate: *mut EPQState,
        parentestate: *mut EState,
        subplan: *mut Plan,
        auxrowmarks: *mut List,
        epqParam: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EvalPlanQualSetPlan(epqstate: *mut EPQState, subplan: *mut Plan, auxrowmarks: *mut List);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EvalPlanQualSlot(
        epqstate: *mut EPQState,
        relation: Relation,
        rti: Index,
    ) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EvalPlanQualFetchRowMark(
        epqstate: *mut EPQState,
        rti: Index,
        slot: *mut TupleTableSlot,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EvalPlanQualNext(epqstate: *mut EPQState) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EvalPlanQualBegin(epqstate: *mut EPQState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EvalPlanQualEnd(epqstate: *mut EPQState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInitNode(
        node: *mut Plan,
        estate: *mut EState,
        eflags: ::std::os::raw::c_int,
    ) -> *mut PlanState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecSetExecProcNode(node: *mut PlanState, function: ExecProcNodeMtd);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MultiExecProcNode(node: *mut PlanState) -> *mut Node;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecEndNode(node: *mut PlanState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecShutdownNode(node: *mut PlanState) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecSetTupleBound(tuples_needed: int64, child_node: *mut PlanState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInitExpr(node: *mut Expr, parent: *mut PlanState) -> *mut ExprState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInitExprWithParams(node: *mut Expr, ext_params: ParamListInfo) -> *mut ExprState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInitQual(qual: *mut List, parent: *mut PlanState) -> *mut ExprState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInitCheck(qual: *mut List, parent: *mut PlanState) -> *mut ExprState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInitExprList(nodes: *mut List, parent: *mut PlanState) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecBuildAggTrans(
        aggstate: *mut AggState,
        phase: *mut AggStatePerPhaseData,
        doSort: bool,
        doHash: bool,
        nullcheck: bool,
    ) -> *mut ExprState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecBuildGroupingEqual(
        ldesc: TupleDesc,
        rdesc: TupleDesc,
        lops: *const TupleTableSlotOps,
        rops: *const TupleTableSlotOps,
        numCols: ::std::os::raw::c_int,
        keyColIdx: *const AttrNumber,
        eqfunctions: *const Oid,
        collations: *const Oid,
        parent: *mut PlanState,
    ) -> *mut ExprState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecBuildProjectionInfo(
        targetList: *mut List,
        econtext: *mut ExprContext,
        slot: *mut TupleTableSlot,
        parent: *mut PlanState,
        inputDesc: TupleDesc,
    ) -> *mut ProjectionInfo;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecBuildProjectionInfoExt(
        targetList: *mut List,
        econtext: *mut ExprContext,
        slot: *mut TupleTableSlot,
        assignJunkEntries: bool,
        parent: *mut PlanState,
        inputDesc: TupleDesc,
    ) -> *mut ProjectionInfo;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecPrepareExpr(node: *mut Expr, estate: *mut EState) -> *mut ExprState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecPrepareQual(qual: *mut List, estate: *mut EState) -> *mut ExprState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecPrepareCheck(qual: *mut List, estate: *mut EState) -> *mut ExprState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecPrepareExprList(nodes: *mut List, estate: *mut EState) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecCheck(state: *mut ExprState, context: *mut ExprContext) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInitTableFunctionResult(
        expr: *mut Expr,
        econtext: *mut ExprContext,
        parent: *mut PlanState,
    ) -> *mut SetExprState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecMakeTableFunctionResult(
        setexpr: *mut SetExprState,
        econtext: *mut ExprContext,
        argContext: MemoryContext,
        expectedDesc: TupleDesc,
        randomAccess: bool,
    ) -> *mut Tuplestorestate;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInitFunctionResultSet(
        expr: *mut Expr,
        econtext: *mut ExprContext,
        parent: *mut PlanState,
    ) -> *mut SetExprState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecMakeFunctionResultSet(
        fcache: *mut SetExprState,
        econtext: *mut ExprContext,
        argContext: MemoryContext,
        isNull: *mut bool,
        isDone: *mut ExprDoneCond,
    ) -> Datum;
}
pub type ExecScanAccessMtd =
    ::std::option::Option<unsafe extern "C" fn(node: *mut ScanState) -> *mut TupleTableSlot>;
pub type ExecScanRecheckMtd = ::std::option::Option<
    unsafe extern "C" fn(node: *mut ScanState, slot: *mut TupleTableSlot) -> bool,
>;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecScan(
        node: *mut ScanState,
        accessMtd: ExecScanAccessMtd,
        recheckMtd: ExecScanRecheckMtd,
    ) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecAssignScanProjectionInfo(node: *mut ScanState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecAssignScanProjectionInfoWithVarno(node: *mut ScanState, varno: Index);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecScanReScan(node: *mut ScanState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInitResultTypeTL(planstate: *mut PlanState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInitResultSlot(planstate: *mut PlanState, tts_ops: *const TupleTableSlotOps);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInitResultTupleSlotTL(planstate: *mut PlanState, tts_ops: *const TupleTableSlotOps);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInitScanTupleSlot(
        estate: *mut EState,
        scanstate: *mut ScanState,
        tupleDesc: TupleDesc,
        tts_ops: *const TupleTableSlotOps,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInitExtraTupleSlot(
        estate: *mut EState,
        tupledesc: TupleDesc,
        tts_ops: *const TupleTableSlotOps,
    ) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInitNullTupleSlot(
        estate: *mut EState,
        tupType: TupleDesc,
        tts_ops: *const TupleTableSlotOps,
    ) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecTypeFromTL(targetList: *mut List) -> TupleDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecCleanTypeFromTL(targetList: *mut List) -> TupleDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecTypeFromExprList(exprList: *mut List) -> TupleDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecTypeSetColNames(typeInfo: TupleDesc, namesList: *mut List);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn UpdateChangedParamSet(node: *mut PlanState, newchg: *mut Bitmapset);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TupOutputState {
    pub slot: *mut TupleTableSlot,
    pub dest: *mut DestReceiver,
}
impl Default for TupOutputState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn begin_tup_output_tupdesc(
        dest: *mut DestReceiver,
        tupdesc: TupleDesc,
        tts_ops: *const TupleTableSlotOps,
    ) -> *mut TupOutputState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn do_tup_output(tstate: *mut TupOutputState, values: *mut Datum, isnull: *mut bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn do_text_output_multiline(
        tstate: *mut TupOutputState,
        txt: *const ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn end_tup_output(tstate: *mut TupOutputState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CreateExecutorState() -> *mut EState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FreeExecutorState(estate: *mut EState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CreateExprContext(estate: *mut EState) -> *mut ExprContext;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CreateWorkExprContext(estate: *mut EState) -> *mut ExprContext;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CreateStandaloneExprContext() -> *mut ExprContext;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FreeExprContext(econtext: *mut ExprContext, isCommit: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ReScanExprContext(econtext: *mut ExprContext);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MakePerTupleExprContext(estate: *mut EState) -> *mut ExprContext;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecAssignExprContext(estate: *mut EState, planstate: *mut PlanState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecGetResultType(planstate: *mut PlanState) -> TupleDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecGetResultSlotOps(
        planstate: *mut PlanState,
        isfixed: *mut bool,
    ) -> *const TupleTableSlotOps;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecAssignProjectionInfo(planstate: *mut PlanState, inputDesc: TupleDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecConditionalAssignProjectionInfo(
        planstate: *mut PlanState,
        inputDesc: TupleDesc,
        varno: Index,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecFreeExprContext(planstate: *mut PlanState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecAssignScanType(scanstate: *mut ScanState, tupDesc: TupleDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecCreateScanSlotFromOuterPlan(
        estate: *mut EState,
        scanstate: *mut ScanState,
        tts_ops: *const TupleTableSlotOps,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecRelationIsTargetRelation(estate: *mut EState, scanrelid: Index) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecOpenScanRelation(
        estate: *mut EState,
        scanrelid: Index,
        eflags: ::std::os::raw::c_int,
    ) -> Relation;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInitRangeTable(estate: *mut EState, rangeTable: *mut List);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecGetRangeTableRelation(estate: *mut EState, rti: Index) -> Relation;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn executor_errposition(
        estate: *mut EState,
        location: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RegisterExprContextCallback(
        econtext: *mut ExprContext,
        function: ExprContextCallbackFunction,
        arg: Datum,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn UnregisterExprContextCallback(
        econtext: *mut ExprContext,
        function: ExprContextCallbackFunction,
        arg: Datum,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetAttributeByName(
        tuple: HeapTupleHeader,
        attname: *const ::std::os::raw::c_char,
        isNull: *mut bool,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetAttributeByNum(
        tuple: HeapTupleHeader,
        attrno: AttrNumber,
        isNull: *mut bool,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecTargetListLength(targetlist: *mut List) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecCleanTargetListLength(targetlist: *mut List) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecGetTriggerOldSlot(
        estate: *mut EState,
        relInfo: *mut ResultRelInfo,
    ) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecGetTriggerNewSlot(
        estate: *mut EState,
        relInfo: *mut ResultRelInfo,
    ) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecGetReturningSlot(
        estate: *mut EState,
        relInfo: *mut ResultRelInfo,
    ) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecGetInsertedCols(relinfo: *mut ResultRelInfo, estate: *mut EState) -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecGetUpdatedCols(relinfo: *mut ResultRelInfo, estate: *mut EState) -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecGetExtraUpdatedCols(
        relinfo: *mut ResultRelInfo,
        estate: *mut EState,
    ) -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecGetAllUpdatedCols(
        relinfo: *mut ResultRelInfo,
        estate: *mut EState,
    ) -> *mut Bitmapset;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecOpenIndices(resultRelInfo: *mut ResultRelInfo, speculative: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecCloseIndices(resultRelInfo: *mut ResultRelInfo);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecInsertIndexTuples(
        slot: *mut TupleTableSlot,
        estate: *mut EState,
        noDupErr: bool,
        specConflict: *mut bool,
        arbiterIndexes: *mut List,
    ) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecCheckIndexConstraints(
        slot: *mut TupleTableSlot,
        estate: *mut EState,
        conflictTid: ItemPointer,
        arbiterIndexes: *mut List,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn check_exclusion_constraint(
        heap: Relation,
        index: Relation,
        indexInfo: *mut IndexInfo,
        tupleid: ItemPointer,
        values: *mut Datum,
        isnull: *mut bool,
        estate: *mut EState,
        newIndex: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationFindReplTupleByIndex(
        rel: Relation,
        idxoid: Oid,
        lockmode: LockTupleMode,
        searchslot: *mut TupleTableSlot,
        outslot: *mut TupleTableSlot,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationFindReplTupleSeq(
        rel: Relation,
        lockmode: LockTupleMode,
        searchslot: *mut TupleTableSlot,
        outslot: *mut TupleTableSlot,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecSimpleRelationInsert(estate: *mut EState, slot: *mut TupleTableSlot);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecSimpleRelationUpdate(
        estate: *mut EState,
        epqstate: *mut EPQState,
        searchslot: *mut TupleTableSlot,
        slot: *mut TupleTableSlot,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecSimpleRelationDelete(
        estate: *mut EState,
        epqstate: *mut EPQState,
        searchslot: *mut TupleTableSlot,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CheckCmdReplicaIdentity(rel: Relation, cmd: CmdType);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CheckSubscriptionRelkind(
        relkind: ::std::os::raw::c_char,
        nspname: *const ::std::os::raw::c_char,
        relname: *const ::std::os::raw::c_char,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AttInMetadata {
    pub tupdesc: TupleDesc,
    pub attinfuncs: *mut FmgrInfo,
    pub attioparams: *mut Oid,
    pub atttypmods: *mut int32,
}
impl Default for AttInMetadata {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FuncCallContext {
    pub call_cntr: uint64,
    pub max_calls: uint64,
    pub user_fctx: *mut ::std::os::raw::c_void,
    pub attinmeta: *mut AttInMetadata,
    pub multi_call_memory_ctx: MemoryContext,
    pub tuple_desc: TupleDesc,
}
impl Default for FuncCallContext {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const TypeFuncClass_TYPEFUNC_SCALAR: TypeFuncClass = 0;
pub const TypeFuncClass_TYPEFUNC_COMPOSITE: TypeFuncClass = 1;
pub const TypeFuncClass_TYPEFUNC_COMPOSITE_DOMAIN: TypeFuncClass = 2;
pub const TypeFuncClass_TYPEFUNC_RECORD: TypeFuncClass = 3;
pub const TypeFuncClass_TYPEFUNC_OTHER: TypeFuncClass = 4;
pub type TypeFuncClass = ::std::os::raw::c_uint;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_call_result_type(
        fcinfo: FunctionCallInfo,
        resultTypeId: *mut Oid,
        resultTupleDesc: *mut TupleDesc,
    ) -> TypeFuncClass;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_expr_result_type(
        expr: *mut Node,
        resultTypeId: *mut Oid,
        resultTupleDesc: *mut TupleDesc,
    ) -> TypeFuncClass;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_func_result_type(
        functionId: Oid,
        resultTypeId: *mut Oid,
        resultTupleDesc: *mut TupleDesc,
    ) -> TypeFuncClass;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_expr_result_tupdesc(expr: *mut Node, noError: bool) -> TupleDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn resolve_polymorphic_argtypes(
        numargs: ::std::os::raw::c_int,
        argtypes: *mut Oid,
        argmodes: *mut ::std::os::raw::c_char,
        call_expr: *mut Node,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_func_arg_info(
        procTup: HeapTuple,
        p_argtypes: *mut *mut Oid,
        p_argnames: *mut *mut *mut ::std::os::raw::c_char,
        p_argmodes: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_func_input_arg_names(
        proargnames: Datum,
        proargmodes: Datum,
        arg_names: *mut *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_func_trftypes(
        procTup: HeapTuple,
        p_trftypes: *mut *mut Oid,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_func_result_name(functionId: Oid) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn build_function_result_tupdesc_d(
        prokind: ::std::os::raw::c_char,
        proallargtypes: Datum,
        proargmodes: Datum,
        proargnames: Datum,
    ) -> TupleDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn build_function_result_tupdesc_t(procTuple: HeapTuple) -> TupleDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationNameGetTupleDesc(relname: *const ::std::os::raw::c_char) -> TupleDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TypeGetTupleDesc(typeoid: Oid, colaliases: *mut List) -> TupleDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BlessTupleDesc(tupdesc: TupleDesc) -> TupleDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TupleDescGetAttInMetadata(tupdesc: TupleDesc) -> *mut AttInMetadata;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BuildTupleFromCStrings(
        attinmeta: *mut AttInMetadata,
        values: *mut *mut ::std::os::raw::c_char,
    ) -> HeapTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn HeapTupleHeaderGetDatum(tuple: HeapTupleHeader) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn init_MultiFuncCall(fcinfo: FunctionCallInfo) -> *mut FuncCallContext;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn per_MultiFuncCall(fcinfo: FunctionCallInfo) -> *mut FuncCallContext;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn end_MultiFuncCall(fcinfo: FunctionCallInfo, funcctx: *mut FuncCallContext);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn extract_variadic_args(
        fcinfo: FunctionCallInfo,
        variadic_start: ::std::os::raw::c_int,
        convert_unknown: bool,
        values: *mut *mut Datum,
        types: *mut *mut Oid,
        nulls: *mut *mut bool,
    ) -> ::std::os::raw::c_int;
}
pub type sig_atomic_t = __sig_atomic_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
}
impl Default for sigval {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __sigval_t = sigval;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo_t {
    pub si_signo: ::std::os::raw::c_int,
    pub si_errno: ::std::os::raw::c_int,
    pub si_code: ::std::os::raw::c_int,
    pub __pad0: ::std::os::raw::c_int,
    pub _sifields: siginfo_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union siginfo_t__bindgen_ty_1 {
    pub _pad: [::std::os::raw::c_int; 28usize],
    pub _kill: siginfo_t__bindgen_ty_1__bindgen_ty_1,
    pub _timer: siginfo_t__bindgen_ty_1__bindgen_ty_2,
    pub _rt: siginfo_t__bindgen_ty_1__bindgen_ty_3,
    pub _sigchld: siginfo_t__bindgen_ty_1__bindgen_ty_4,
    pub _sigfault: siginfo_t__bindgen_ty_1__bindgen_ty_5,
    pub _sigpoll: siginfo_t__bindgen_ty_1__bindgen_ty_6,
    pub _sigsys: siginfo_t__bindgen_ty_1__bindgen_ty_7,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_1 {
    pub si_pid: __pid_t,
    pub si_uid: __uid_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_2 {
    pub si_tid: ::std::os::raw::c_int,
    pub si_overrun: ::std::os::raw::c_int,
    pub si_sigval: __sigval_t,
}
impl Default for siginfo_t__bindgen_ty_1__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_3 {
    pub si_pid: __pid_t,
    pub si_uid: __uid_t,
    pub si_sigval: __sigval_t,
}
impl Default for siginfo_t__bindgen_ty_1__bindgen_ty_3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_4 {
    pub si_pid: __pid_t,
    pub si_uid: __uid_t,
    pub si_status: ::std::os::raw::c_int,
    pub si_utime: __clock_t,
    pub si_stime: __clock_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_5 {
    pub si_addr: *mut ::std::os::raw::c_void,
    pub si_addr_lsb: ::std::os::raw::c_short,
    pub _bounds: siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1 {
    pub _addr_bnd: siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1,
    pub _pkey: __uint32_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1 {
    pub _lower: *mut ::std::os::raw::c_void,
    pub _upper: *mut ::std::os::raw::c_void,
}
impl Default for siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for siginfo_t__bindgen_ty_1__bindgen_ty_5 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_6 {
    pub si_band: ::std::os::raw::c_long,
    pub si_fd: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_7 {
    pub _call_addr: *mut ::std::os::raw::c_void,
    pub _syscall: ::std::os::raw::c_int,
    pub _arch: ::std::os::raw::c_uint,
}
impl Default for siginfo_t__bindgen_ty_1__bindgen_ty_7 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for siginfo_t__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for siginfo_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SI_ASYNCNL: _bindgen_ty_10 = -60;
pub const SI_DETHREAD: _bindgen_ty_10 = -7;
pub const SI_TKILL: _bindgen_ty_10 = -6;
pub const SI_SIGIO: _bindgen_ty_10 = -5;
pub const SI_ASYNCIO: _bindgen_ty_10 = -4;
pub const SI_MESGQ: _bindgen_ty_10 = -3;
pub const SI_TIMER: _bindgen_ty_10 = -2;
pub const SI_QUEUE: _bindgen_ty_10 = -1;
pub const SI_USER: _bindgen_ty_10 = 0;
pub const SI_KERNEL: _bindgen_ty_10 = 128;
pub type _bindgen_ty_10 = ::std::os::raw::c_int;
pub const ILL_ILLOPC: _bindgen_ty_11 = 1;
pub const ILL_ILLOPN: _bindgen_ty_11 = 2;
pub const ILL_ILLADR: _bindgen_ty_11 = 3;
pub const ILL_ILLTRP: _bindgen_ty_11 = 4;
pub const ILL_PRVOPC: _bindgen_ty_11 = 5;
pub const ILL_PRVREG: _bindgen_ty_11 = 6;
pub const ILL_COPROC: _bindgen_ty_11 = 7;
pub const ILL_BADSTK: _bindgen_ty_11 = 8;
pub const ILL_BADIADDR: _bindgen_ty_11 = 9;
pub type _bindgen_ty_11 = ::std::os::raw::c_uint;
pub const FPE_INTDIV: _bindgen_ty_12 = 1;
pub const FPE_INTOVF: _bindgen_ty_12 = 2;
pub const FPE_FLTDIV: _bindgen_ty_12 = 3;
pub const FPE_FLTOVF: _bindgen_ty_12 = 4;
pub const FPE_FLTUND: _bindgen_ty_12 = 5;
pub const FPE_FLTRES: _bindgen_ty_12 = 6;
pub const FPE_FLTINV: _bindgen_ty_12 = 7;
pub const FPE_FLTSUB: _bindgen_ty_12 = 8;
pub const FPE_FLTUNK: _bindgen_ty_12 = 14;
pub const FPE_CONDTRAP: _bindgen_ty_12 = 15;
pub type _bindgen_ty_12 = ::std::os::raw::c_uint;
pub const SEGV_MAPERR: _bindgen_ty_13 = 1;
pub const SEGV_ACCERR: _bindgen_ty_13 = 2;
pub const SEGV_BNDERR: _bindgen_ty_13 = 3;
pub const SEGV_PKUERR: _bindgen_ty_13 = 4;
pub const SEGV_ACCADI: _bindgen_ty_13 = 5;
pub const SEGV_ADIDERR: _bindgen_ty_13 = 6;
pub const SEGV_ADIPERR: _bindgen_ty_13 = 7;
pub const SEGV_MTEAERR: _bindgen_ty_13 = 8;
pub const SEGV_MTESERR: _bindgen_ty_13 = 9;
pub type _bindgen_ty_13 = ::std::os::raw::c_uint;
pub const BUS_ADRALN: _bindgen_ty_14 = 1;
pub const BUS_ADRERR: _bindgen_ty_14 = 2;
pub const BUS_OBJERR: _bindgen_ty_14 = 3;
pub const BUS_MCEERR_AR: _bindgen_ty_14 = 4;
pub const BUS_MCEERR_AO: _bindgen_ty_14 = 5;
pub type _bindgen_ty_14 = ::std::os::raw::c_uint;
pub const CLD_EXITED: _bindgen_ty_15 = 1;
pub const CLD_KILLED: _bindgen_ty_15 = 2;
pub const CLD_DUMPED: _bindgen_ty_15 = 3;
pub const CLD_TRAPPED: _bindgen_ty_15 = 4;
pub const CLD_STOPPED: _bindgen_ty_15 = 5;
pub const CLD_CONTINUED: _bindgen_ty_15 = 6;
pub type _bindgen_ty_15 = ::std::os::raw::c_uint;
pub const POLL_IN: _bindgen_ty_16 = 1;
pub const POLL_OUT: _bindgen_ty_16 = 2;
pub const POLL_MSG: _bindgen_ty_16 = 3;
pub const POLL_ERR: _bindgen_ty_16 = 4;
pub const POLL_PRI: _bindgen_ty_16 = 5;
pub const POLL_HUP: _bindgen_ty_16 = 6;
pub type _bindgen_ty_16 = ::std::os::raw::c_uint;
pub type sigval_t = __sigval_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigevent {
    pub sigev_value: __sigval_t,
    pub sigev_signo: ::std::os::raw::c_int,
    pub sigev_notify: ::std::os::raw::c_int,
    pub _sigev_un: sigevent__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigevent__bindgen_ty_1 {
    pub _pad: [::std::os::raw::c_int; 12usize],
    pub _tid: __pid_t,
    pub _sigev_thread: sigevent__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigevent__bindgen_ty_1__bindgen_ty_1 {
    pub _function: ::std::option::Option<unsafe extern "C" fn(arg1: __sigval_t)>,
    pub _attribute: *mut pthread_attr_t,
}
impl Default for sigevent__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for sigevent__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for sigevent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type sigevent_t = sigevent;
pub const SIGEV_SIGNAL: _bindgen_ty_17 = 0;
pub const SIGEV_NONE: _bindgen_ty_17 = 1;
pub const SIGEV_THREAD: _bindgen_ty_17 = 2;
pub const SIGEV_THREAD_ID: _bindgen_ty_17 = 4;
pub type _bindgen_ty_17 = ::std::os::raw::c_uint;
pub type __sighandler_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
pub type sig_t = __sighandler_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction {
    pub __sigaction_handler: sigaction__bindgen_ty_1,
    pub sa_mask: __sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
    pub sa_restorer: ::std::option::Option<unsafe extern "C" fn()>,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigaction__bindgen_ty_1 {
    pub sa_handler: __sighandler_t,
    pub sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut siginfo_t,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
}
impl Default for sigaction__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for sigaction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _fpx_sw_bytes {
    pub magic1: __uint32_t,
    pub extended_size: __uint32_t,
    pub xstate_bv: __uint64_t,
    pub xstate_size: __uint32_t,
    pub __glibc_reserved1: [__uint32_t; 7usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _fpreg {
    pub significand: [::std::os::raw::c_ushort; 4usize],
    pub exponent: ::std::os::raw::c_ushort,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _fpxreg {
    pub significand: [::std::os::raw::c_ushort; 4usize],
    pub exponent: ::std::os::raw::c_ushort,
    pub __glibc_reserved1: [::std::os::raw::c_ushort; 3usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _xmmreg {
    pub element: [__uint32_t; 4usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _fpstate {
    pub cwd: __uint16_t,
    pub swd: __uint16_t,
    pub ftw: __uint16_t,
    pub fop: __uint16_t,
    pub rip: __uint64_t,
    pub rdp: __uint64_t,
    pub mxcsr: __uint32_t,
    pub mxcr_mask: __uint32_t,
    pub _st: [_fpxreg; 8usize],
    pub _xmm: [_xmmreg; 16usize],
    pub __glibc_reserved1: [__uint32_t; 24usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigcontext {
    pub r8: __uint64_t,
    pub r9: __uint64_t,
    pub r10: __uint64_t,
    pub r11: __uint64_t,
    pub r12: __uint64_t,
    pub r13: __uint64_t,
    pub r14: __uint64_t,
    pub r15: __uint64_t,
    pub rdi: __uint64_t,
    pub rsi: __uint64_t,
    pub rbp: __uint64_t,
    pub rbx: __uint64_t,
    pub rdx: __uint64_t,
    pub rax: __uint64_t,
    pub rcx: __uint64_t,
    pub rsp: __uint64_t,
    pub rip: __uint64_t,
    pub eflags: __uint64_t,
    pub cs: ::std::os::raw::c_ushort,
    pub gs: ::std::os::raw::c_ushort,
    pub fs: ::std::os::raw::c_ushort,
    pub __pad0: ::std::os::raw::c_ushort,
    pub err: __uint64_t,
    pub trapno: __uint64_t,
    pub oldmask: __uint64_t,
    pub cr2: __uint64_t,
    pub __bindgen_anon_1: sigcontext__bindgen_ty_1,
    pub __reserved1: [__uint64_t; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigcontext__bindgen_ty_1 {
    pub fpstate: *mut _fpstate,
    pub __fpstate_word: __uint64_t,
}
impl Default for sigcontext__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for sigcontext {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _xsave_hdr {
    pub xstate_bv: __uint64_t,
    pub __glibc_reserved1: [__uint64_t; 2usize],
    pub __glibc_reserved2: [__uint64_t; 5usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ymmh_state {
    pub ymmh_space: [__uint32_t; 64usize],
}
impl Default for _ymmh_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _xstate {
    pub fpstate: _fpstate,
    pub xstate_hdr: _xsave_hdr,
    pub ymmh: _ymmh_state,
}
impl Default for _xstate {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stack_t {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_flags: ::std::os::raw::c_int,
    pub ss_size: usize,
}
impl Default for stack_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type greg_t = ::std::os::raw::c_longlong;
pub type gregset_t = [greg_t; 23usize];
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _libc_fpxreg {
    pub significand: [::std::os::raw::c_ushort; 4usize],
    pub exponent: ::std::os::raw::c_ushort,
    pub __glibc_reserved1: [::std::os::raw::c_ushort; 3usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _libc_xmmreg {
    pub element: [__uint32_t; 4usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _libc_fpstate {
    pub cwd: __uint16_t,
    pub swd: __uint16_t,
    pub ftw: __uint16_t,
    pub fop: __uint16_t,
    pub rip: __uint64_t,
    pub rdp: __uint64_t,
    pub mxcsr: __uint32_t,
    pub mxcr_mask: __uint32_t,
    pub _st: [_libc_fpxreg; 8usize],
    pub _xmm: [_libc_xmmreg; 16usize],
    pub __glibc_reserved1: [__uint32_t; 24usize],
}
pub type fpregset_t = *mut _libc_fpstate;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mcontext_t {
    pub gregs: gregset_t,
    pub fpregs: fpregset_t,
    pub __reserved1: [::std::os::raw::c_ulonglong; 8usize],
}
impl Default for mcontext_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ucontext_t {
    pub uc_flags: ::std::os::raw::c_ulong,
    pub uc_link: *mut ucontext_t,
    pub uc_stack: stack_t,
    pub uc_mcontext: mcontext_t,
    pub uc_sigmask: sigset_t,
    pub __fpregs_mem: _libc_fpstate,
    pub __ssp: [::std::os::raw::c_ulonglong; 4usize],
}
impl Default for ucontext_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const SS_ONSTACK: _bindgen_ty_18 = 1;
pub const SS_DISABLE: _bindgen_ty_18 = 2;
pub type _bindgen_ty_18 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_onstack: ::std::os::raw::c_int,
}
impl Default for sigstack {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type pg_time_t = int64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pg_tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *const ::std::os::raw::c_char,
}
impl Default for pg_tm {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pg_tz {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pg_tzenum {
    _unused: [u8; 0],
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_localtime(timep: *const pg_time_t, tz: *const pg_tz) -> *mut pg_tm;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_gmtime(timep: *const pg_time_t) -> *mut pg_tm;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_next_dst_boundary(
        timep: *const pg_time_t,
        before_gmtoff: *mut ::std::os::raw::c_long,
        before_isdst: *mut ::std::os::raw::c_int,
        boundary: *mut pg_time_t,
        after_gmtoff: *mut ::std::os::raw::c_long,
        after_isdst: *mut ::std::os::raw::c_int,
        tz: *const pg_tz,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_interpret_timezone_abbrev(
        abbrev: *const ::std::os::raw::c_char,
        timep: *const pg_time_t,
        gmtoff: *mut ::std::os::raw::c_long,
        isdst: *mut ::std::os::raw::c_int,
        tz: *const pg_tz,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_get_timezone_offset(tz: *const pg_tz, gmtoff: *mut ::std::os::raw::c_long) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_get_timezone_name(tz: *mut pg_tz) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_tz_acceptable(tz: *mut pg_tz) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_strftime(
        s: *mut ::std::os::raw::c_char,
        max: usize,
        format: *const ::std::os::raw::c_char,
        tm: *const pg_tm,
    ) -> usize;
}
extern "C" {
    pub static mut session_timezone: *mut pg_tz;
}
extern "C" {
    pub static mut log_timezone: *mut pg_tz;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_timezone_initialize();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_tzset(tzname: *const ::std::os::raw::c_char) -> *mut pg_tz;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_tzset_offset(gmtoffset: ::std::os::raw::c_long) -> *mut pg_tz;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_tzenumerate_start() -> *mut pg_tzenum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_tzenumerate_next(dir: *mut pg_tzenum) -> *mut pg_tz;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_tzenumerate_end(dir: *mut pg_tzenum);
}
extern "C" {
    #[doc = "\t  System interrupt and critical section handling\n\n There are two types of interrupts that a running backend needs to accept\n without messing up its state: QueryCancel (SIGINT) and ProcDie (SIGTERM).\n In both cases, we need to be able to clean up the current transaction\n gracefully, so we can't respond to the interrupt instantaneously ---\n there's no guarantee that internal data structures would be self-consistent\n if the code is interrupted at an arbitrary instant.  Instead, the signal\n handlers set flags that are checked periodically during execution.\n\n The CHECK_FOR_INTERRUPTS() macro is called at strategically located spots\n where it is normally safe to accept a cancel or die interrupt.  In some\n cases, we invoke CHECK_FOR_INTERRUPTS() inside low-level subroutines that\n might sometimes be called in contexts that do *not* want to allow a cancel\n or die interrupt.  The HOLD_INTERRUPTS() and RESUME_INTERRUPTS() macros\n allow code to ensure that no cancel or die interrupt will be accepted,\n even if CHECK_FOR_INTERRUPTS() gets called in a subroutine.  The interrupt\n will be held off until CHECK_FOR_INTERRUPTS() is done outside any\n HOLD_INTERRUPTS() ... RESUME_INTERRUPTS() section.\n\n There is also a mechanism to prevent query cancel interrupts, while still\n allowing die interrupts: HOLD_CANCEL_INTERRUPTS() and\n RESUME_CANCEL_INTERRUPTS().\n\n Note that ProcessInterrupts() has also acquired a number of tasks that\n do not necessarily cause a query-cancel-or-die response.  Hence, it's\n possible that it will just clear InterruptPending and return.\n\n INTERRUPTS_PENDING_CONDITION() can be checked to see whether an\n interrupt needs to be serviced, without trying to do so immediately.\n Some callers are also interested in INTERRUPTS_CAN_BE_PROCESSED(),\n which tells whether ProcessInterrupts is sure to clear the interrupt.\n\n Special mechanisms are used to let an interrupt be accepted when we are\n waiting for a lock or when we are waiting for command input (but, of\n course, only if the interrupt holdoff counter is zero).  See the\n related code for details.\n\n A lost connection is handled similarly, although the loss of connection\n does not raise a signal, but is detected when we fail to write to the\n socket. If there was a signal for a broken connection, we could make use of\n it by setting ClientConnectionLost in the signal handler.\n\n A related, but conceptually distinct, mechanism is the \"critical section\"\n mechanism.  A critical section not only holds off cancel/die interrupts,\n but causes any ereport(ERROR) or ereport(FATAL) to become ereport(PANIC)\n --- that is, a system-wide reset is forced.  Needless to say, only really\n *critical* code should be marked as a critical section!\tCurrently, this\n mechanism is only used for XLOG-related code.\n"]
    pub static mut InterruptPending: sig_atomic_t;
}
extern "C" {
    pub static mut QueryCancelPending: sig_atomic_t;
}
extern "C" {
    pub static mut ProcDiePending: sig_atomic_t;
}
extern "C" {
    pub static mut IdleInTransactionSessionTimeoutPending: sig_atomic_t;
}
extern "C" {
    pub static mut ProcSignalBarrierPending: sig_atomic_t;
}
extern "C" {
    pub static mut ClientConnectionLost: sig_atomic_t;
}
extern "C" {
    pub static mut InterruptHoldoffCount: uint32;
}
extern "C" {
    pub static mut QueryCancelHoldoffCount: uint32;
}
extern "C" {
    pub static mut CritSectionCount: uint32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ProcessInterrupts();
}
extern "C" {
    #[doc = "\t  globals.h --\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t *"]
    pub static mut PostmasterPid: pid_t;
}
extern "C" {
    pub static mut IsPostmasterEnvironment: bool;
}
extern "C" {
    pub static mut IsUnderPostmaster: bool;
}
extern "C" {
    pub static mut IsBackgroundWorker: bool;
}
extern "C" {
    pub static mut IsBinaryUpgrade: bool;
}
extern "C" {
    pub static mut ExitOnAnyError: bool;
}
extern "C" {
    pub static mut DataDir: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut data_directory_mode: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut NBuffers: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut MaxBackends: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut MaxConnections: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut max_worker_processes: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut max_parallel_workers: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut MyProcPid: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut MyStartTime: pg_time_t;
}
extern "C" {
    pub static mut MyStartTimestamp: TimestampTz;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Port {
    _unused: [u8; 0],
}
extern "C" {
    pub static mut MyProcPort: *mut Port;
}
extern "C" {
    pub static mut MyLatch: *mut Latch;
}
extern "C" {
    pub static mut MyCancelKey: int32;
}
extern "C" {
    pub static mut MyPMChildSlot: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut OutputFileName: [::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static mut my_exec_path: [::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static mut pkglib_path: [::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static mut MyDatabaseId: Oid;
}
extern "C" {
    pub static mut MyDatabaseTableSpace: Oid;
}
extern "C" {
    pub static mut DateStyle: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut DateOrder: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut IntervalStyle: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut enableFsync: bool;
}
extern "C" {
    pub static mut allowSystemTableMods: bool;
}
extern "C" {
    pub static mut work_mem: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut hash_mem_multiplier: f64;
}
extern "C" {
    pub static mut maintenance_work_mem: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut max_parallel_maintenance_workers: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut VacuumCostPageHit: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut VacuumCostPageMiss: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut VacuumCostPageDirty: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut VacuumCostLimit: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut VacuumCostDelay: f64;
}
extern "C" {
    pub static mut VacuumPageHit: int64;
}
extern "C" {
    pub static mut VacuumPageMiss: int64;
}
extern "C" {
    pub static mut VacuumPageDirty: int64;
}
extern "C" {
    pub static mut VacuumCostBalance: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut VacuumCostActive: bool;
}
extern "C" {
    pub static mut vacuum_cleanup_index_scale_factor: f64;
}
pub type pg_stack_base_t = *mut ::std::os::raw::c_char;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn set_stack_base() -> pg_stack_base_t;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn restore_stack_base(base: pg_stack_base_t);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn check_stack_depth();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn stack_is_too_deep() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PreventCommandIfReadOnly(cmdname: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PreventCommandIfParallelMode(cmdname: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PreventCommandDuringRecovery(cmdname: *const ::std::os::raw::c_char);
}
extern "C" {
    pub static mut trace_recovery_messages: ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn trace_recovery(trace_level: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut DatabasePath: *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitPostmasterChild();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitStandaloneProcess(argv0: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SwitchToSharedLatch();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SwitchBackToLocalLatch();
}
pub const BackendType_B_INVALID: BackendType = 0;
pub const BackendType_B_AUTOVAC_LAUNCHER: BackendType = 1;
pub const BackendType_B_AUTOVAC_WORKER: BackendType = 2;
pub const BackendType_B_BACKEND: BackendType = 3;
pub const BackendType_B_BG_WORKER: BackendType = 4;
pub const BackendType_B_BG_WRITER: BackendType = 5;
pub const BackendType_B_CHECKPOINTER: BackendType = 6;
pub const BackendType_B_STARTUP: BackendType = 7;
pub const BackendType_B_WAL_RECEIVER: BackendType = 8;
pub const BackendType_B_WAL_SENDER: BackendType = 9;
pub const BackendType_B_WAL_WRITER: BackendType = 10;
pub const BackendType_B_ARCHIVER: BackendType = 11;
pub const BackendType_B_STATS_COLLECTOR: BackendType = 12;
pub const BackendType_B_LOGGER: BackendType = 13;
pub type BackendType = ::std::os::raw::c_uint;
extern "C" {
    pub static mut MyBackendType: BackendType;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetBackendTypeDesc(backendType: BackendType) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SetDatabasePath(path: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn checkDataDir();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SetDataDir(dir: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ChangeToDataDir();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetUserNameFromId(roleid: Oid, noerr: bool) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetUserId() -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetOuterUserId() -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetSessionUserId() -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetAuthenticatedUserId() -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetUserIdAndSecContext(userid: *mut Oid, sec_context: *mut ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SetUserIdAndSecContext(userid: Oid, sec_context: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InLocalUserIdChange() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InSecurityRestrictedOperation() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InNoForceRLSOperation() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetUserIdAndContext(userid: *mut Oid, sec_def_context: *mut bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SetUserIdAndContext(userid: Oid, sec_def_context: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitializeSessionUserId(rolename: *const ::std::os::raw::c_char, useroid: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitializeSessionUserIdStandalone();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SetSessionAuthorization(userid: Oid, is_superuser: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetCurrentRoleId() -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SetCurrentRoleId(roleid: Oid, is_superuser: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn superuser() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn superuser_arg(roleid: Oid) -> bool;
}
pub const ProcessingMode_BootstrapProcessing: ProcessingMode = 0;
pub const ProcessingMode_InitProcessing: ProcessingMode = 1;
pub const ProcessingMode_NormalProcessing: ProcessingMode = 2;
#[doc = "\t  pmod.h --\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t *\n\t\t\tPOSTGRES processing mode definitions.                            *"]
pub type ProcessingMode = ::std::os::raw::c_uint;
extern "C" {
    pub static mut Mode: ProcessingMode;
}
pub const AuxProcType_NotAnAuxProcess: AuxProcType = -1;
pub const AuxProcType_CheckerProcess: AuxProcType = 0;
pub const AuxProcType_BootstrapProcess: AuxProcType = 1;
pub const AuxProcType_StartupProcess: AuxProcType = 2;
pub const AuxProcType_BgWriterProcess: AuxProcType = 3;
pub const AuxProcType_CheckpointerProcess: AuxProcType = 4;
pub const AuxProcType_WalWriterProcess: AuxProcType = 5;
pub const AuxProcType_WalReceiverProcess: AuxProcType = 6;
pub const AuxProcType_NUM_AUXPROCTYPES: AuxProcType = 7;
pub type AuxProcType = ::std::os::raw::c_int;
extern "C" {
    pub static mut MyAuxProcType: AuxProcType;
}
#[pgrx_macros::pg_guard]
extern "C" {
    #[doc = "\t  pinit.h --\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t *\n\t\t\tPOSTGRES initialization and cleanup definitions.                 *"]
    pub fn pg_split_opts(
        argv: *mut *mut ::std::os::raw::c_char,
        argcp: *mut ::std::os::raw::c_int,
        optstr: *const ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitializeMaxBackends();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitPostgres(
        in_dbname: *const ::std::os::raw::c_char,
        dboid: Oid,
        username: *const ::std::os::raw::c_char,
        useroid: Oid,
        out_dbname: *mut ::std::os::raw::c_char,
        override_allow_connections: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BaseInit();
}
extern "C" {
    pub static mut IgnoreSystemIndexes: bool;
}
extern "C" {
    pub static mut process_shared_preload_libraries_in_progress: bool;
}
extern "C" {
    pub static mut session_preload_libraries_string: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut shared_preload_libraries_string: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut local_preload_libraries_string: *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CreateDataDirLockFile(amPostmaster: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CreateSocketLockFile(
        socketfile: *const ::std::os::raw::c_char,
        amPostmaster: bool,
        socketDir: *const ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TouchSocketLockFiles();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AddToDataDirLockFile(
        target_line: ::std::os::raw::c_int,
        str_: *const ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RecheckDataDirLockFile() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ValidatePgVersion(path: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn process_shared_preload_libraries();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn process_session_preload_libraries();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_bindtextdomain(domain: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn has_rolreplication(roleid: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BackupInProgress() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CancelBackup();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_hash_memory_limit() -> usize;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_hash_mem() -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_un {
    pub sun_family: sa_family_t,
    pub sun_path: [::std::os::raw::c_char; 108usize],
}
impl Default for sockaddr_un {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SockAddr {
    pub addr: sockaddr_storage,
    pub salen: socklen_t,
}
impl Default for SockAddr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ProtocolVersion = uint32;
pub type MsgType = ProtocolVersion;
pub type PacketLen = uint32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StartupPacket {
    pub protoVersion: ProtocolVersion,
    pub database: [::std::os::raw::c_char; 64usize],
    pub user: [::std::os::raw::c_char; 32usize],
    pub options: [::std::os::raw::c_char; 64usize],
    pub unused: [::std::os::raw::c_char; 64usize],
    pub tty: [::std::os::raw::c_char; 64usize],
}
impl Default for StartupPacket {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut Db_user_namespace: bool;
}
pub type AuthRequest = uint32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct CancelRequestPacket {
    pub cancelRequestCode: MsgType,
    pub backendPID: uint32,
    pub cancelAuthCode: uint32,
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgarch_start() -> ::std::os::raw::c_int;
}
pub type RmgrId = uint8;
pub const RmgrIds_RM_XLOG_ID: RmgrIds = 0;
pub const RmgrIds_RM_XACT_ID: RmgrIds = 1;
pub const RmgrIds_RM_SMGR_ID: RmgrIds = 2;
pub const RmgrIds_RM_CLOG_ID: RmgrIds = 3;
pub const RmgrIds_RM_DBASE_ID: RmgrIds = 4;
pub const RmgrIds_RM_TBLSPC_ID: RmgrIds = 5;
pub const RmgrIds_RM_MULTIXACT_ID: RmgrIds = 6;
pub const RmgrIds_RM_RELMAP_ID: RmgrIds = 7;
pub const RmgrIds_RM_STANDBY_ID: RmgrIds = 8;
pub const RmgrIds_RM_HEAP2_ID: RmgrIds = 9;
pub const RmgrIds_RM_HEAP_ID: RmgrIds = 10;
pub const RmgrIds_RM_BTREE_ID: RmgrIds = 11;
pub const RmgrIds_RM_HASH_ID: RmgrIds = 12;
pub const RmgrIds_RM_GIN_ID: RmgrIds = 13;
pub const RmgrIds_RM_GIST_ID: RmgrIds = 14;
pub const RmgrIds_RM_SEQ_ID: RmgrIds = 15;
pub const RmgrIds_RM_SPGIST_ID: RmgrIds = 16;
pub const RmgrIds_RM_BRIN_ID: RmgrIds = 17;
pub const RmgrIds_RM_COMMIT_TS_ID: RmgrIds = 18;
pub const RmgrIds_RM_REPLORIGIN_ID: RmgrIds = 19;
pub const RmgrIds_RM_GENERIC_ID: RmgrIds = 20;
pub const RmgrIds_RM_LOGICALMSG_ID: RmgrIds = 21;
pub const RmgrIds_RM_NEXT_ID: RmgrIds = 22;
pub type RmgrIds = ::std::os::raw::c_uint;
pub type pg_crc32c = uint32;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_comp_crc32c_sb8(
        crc: pg_crc32c,
        data: *const ::std::os::raw::c_void,
        len: usize,
    ) -> pg_crc32c;
}
extern "C" {
    pub static mut pg_comp_crc32c: ::std::option::Option<
        unsafe extern "C" fn(
            crc: pg_crc32c,
            data: *const ::std::os::raw::c_void,
            len: usize,
        ) -> pg_crc32c,
    >;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pg_comp_crc32c_sse42(
        crc: pg_crc32c,
        data: *const ::std::os::raw::c_void,
        len: usize,
    ) -> pg_crc32c;
}
pub const ForkNumber_InvalidForkNumber: ForkNumber = -1;
pub const ForkNumber_MAIN_FORKNUM: ForkNumber = 0;
pub const ForkNumber_FSM_FORKNUM: ForkNumber = 1;
pub const ForkNumber_VISIBILITYMAP_FORKNUM: ForkNumber = 2;
pub const ForkNumber_INIT_FORKNUM: ForkNumber = 3;
pub type ForkNumber = ::std::os::raw::c_int;
extern "C" {
    pub static forkNames: [*const ::std::os::raw::c_char; 0usize];
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn forkname_to_number(forkName: *const ::std::os::raw::c_char) -> ForkNumber;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn forkname_chars(
        str_: *const ::std::os::raw::c_char,
        fork: *mut ForkNumber,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetDatabasePath(dbNode: Oid, spcNode: Oid) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetRelationPath(
        dbNode: Oid,
        spcNode: Oid,
        relNode: Oid,
        backendId: ::std::os::raw::c_int,
        forkNumber: ForkNumber,
    ) -> *mut ::std::os::raw::c_char;
}
pub type BackendId = ::std::os::raw::c_int;
extern "C" {
    pub static mut MyBackendId: BackendId;
}
extern "C" {
    pub static mut ParallelMasterBackendId: BackendId;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RelFileNode {
    pub spcNode: Oid,
    pub dbNode: Oid,
    pub relNode: Oid,
}
impl Default for RelFileNode {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RelFileNodeBackend {
    pub node: RelFileNode,
    pub backend: BackendId,
}
impl Default for RelFileNodeBackend {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecord {
    pub xl_tot_len: uint32,
    pub xl_xid: TransactionId,
    pub xl_prev: XLogRecPtr,
    pub xl_info: uint8,
    pub xl_rmid: RmgrId,
    pub xl_crc: pg_crc32c,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordBlockHeader {
    pub id: uint8,
    pub fork_flags: uint8,
    pub data_length: uint16,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordBlockImageHeader {
    pub length: uint16,
    pub hole_offset: uint16,
    pub bimg_info: uint8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordBlockCompressHeader {
    pub hole_length: uint16,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordDataHeaderShort {
    pub id: uint8,
    pub data_length: uint8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogRecordDataHeaderLong {
    pub id: uint8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct WALOpenSegment {
    pub ws_file: ::std::os::raw::c_int,
    pub ws_segno: XLogSegNo,
    pub ws_tli: TimeLineID,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WALSegmentContext {
    pub ws_dir: [::std::os::raw::c_char; 1024usize],
    pub ws_segsize: ::std::os::raw::c_int,
}
impl Default for WALSegmentContext {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type XLogPageReadCB = ::std::option::Option<
    unsafe extern "C" fn(
        xlogreader: *mut XLogReaderState,
        targetPagePtr: XLogRecPtr,
        reqLen: ::std::os::raw::c_int,
        targetRecPtr: XLogRecPtr,
        readBuf: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int,
>;
pub type WALSegmentOpenCB = ::std::option::Option<
    unsafe extern "C" fn(
        xlogreader: *mut XLogReaderState,
        nextSegNo: XLogSegNo,
        tli_p: *mut TimeLineID,
    ),
>;
pub type WALSegmentCloseCB =
    ::std::option::Option<unsafe extern "C" fn(xlogreader: *mut XLogReaderState)>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogReaderRoutine {
    pub page_read: XLogPageReadCB,
    pub segment_open: WALSegmentOpenCB,
    pub segment_close: WALSegmentCloseCB,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DecodedBkpBlock {
    pub in_use: bool,
    pub rnode: RelFileNode,
    pub forknum: ForkNumber,
    pub blkno: BlockNumber,
    pub flags: uint8,
    pub has_image: bool,
    pub apply_image: bool,
    pub bkp_image: *mut ::std::os::raw::c_char,
    pub hole_offset: uint16,
    pub hole_length: uint16,
    pub bimg_len: uint16,
    pub bimg_info: uint8,
    pub has_data: bool,
    pub data: *mut ::std::os::raw::c_char,
    pub data_len: uint16,
    pub data_bufsz: uint16,
}
impl Default for DecodedBkpBlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XLogReaderState {
    pub routine: XLogReaderRoutine,
    pub system_identifier: uint64,
    pub private_data: *mut ::std::os::raw::c_void,
    pub ReadRecPtr: XLogRecPtr,
    pub EndRecPtr: XLogRecPtr,
    pub decoded_record: *mut XLogRecord,
    pub main_data: *mut ::std::os::raw::c_char,
    pub main_data_len: uint32,
    pub main_data_bufsz: uint32,
    pub record_origin: RepOriginId,
    pub blocks: [DecodedBkpBlock; 33usize],
    pub max_block_id: ::std::os::raw::c_int,
    pub readBuf: *mut ::std::os::raw::c_char,
    pub readLen: uint32,
    pub segcxt: WALSegmentContext,
    pub seg: WALOpenSegment,
    pub segoff: uint32,
    pub latestPagePtr: XLogRecPtr,
    pub latestPageTLI: TimeLineID,
    pub currRecPtr: XLogRecPtr,
    pub currTLI: TimeLineID,
    pub currTLIValidUntil: XLogRecPtr,
    pub nextTLI: TimeLineID,
    pub readRecordBuf: *mut ::std::os::raw::c_char,
    pub readRecordBufSize: uint32,
    pub errormsg_buf: *mut ::std::os::raw::c_char,
    pub abortedRecPtr: XLogRecPtr,
    pub missingContrecPtr: XLogRecPtr,
    pub overwrittenRecPtr: XLogRecPtr,
}
impl Default for XLogReaderState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogReaderAllocate(
        wal_segment_size: ::std::os::raw::c_int,
        waldir: *const ::std::os::raw::c_char,
        routine: *mut XLogReaderRoutine,
        private_data: *mut ::std::os::raw::c_void,
    ) -> *mut XLogReaderState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LocalXLogReaderRoutine() -> *mut XLogReaderRoutine;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogReaderFree(state: *mut XLogReaderState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogBeginRead(state: *mut XLogReaderState, RecPtr: XLogRecPtr);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogReadRecord(
        state: *mut XLogReaderState,
        errormsg: *mut *mut ::std::os::raw::c_char,
    ) -> *mut XLogRecord;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogReaderValidatePageHeader(
        state: *mut XLogReaderState,
        recptr: XLogRecPtr,
        phdr: *mut ::std::os::raw::c_char,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct WALReadError {
    pub wre_errno: ::std::os::raw::c_int,
    pub wre_off: ::std::os::raw::c_int,
    pub wre_req: ::std::os::raw::c_int,
    pub wre_read: ::std::os::raw::c_int,
    pub wre_seg: WALOpenSegment,
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn WALRead(
        state: *mut XLogReaderState,
        buf: *mut ::std::os::raw::c_char,
        startptr: XLogRecPtr,
        count: Size,
        tli: TimeLineID,
        errinfo: *mut WALReadError,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DecodeXLogRecord(
        state: *mut XLogReaderState,
        record: *mut XLogRecord,
        errmsg: *mut *mut ::std::os::raw::c_char,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogRecGetFullXid(record: *mut XLogReaderState) -> FullTransactionId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RestoreBlockImage(
        record: *mut XLogReaderState,
        block_id: uint8,
        page: *mut ::std::os::raw::c_char,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogRecGetBlockData(
        record: *mut XLogReaderState,
        block_id: uint8,
        len: *mut Size,
    ) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogRecGetBlockTag(
        record: *mut XLogReaderState,
        block_id: uint8,
        rnode: *mut RelFileNode,
        forknum: *mut ForkNumber,
        blknum: *mut BlockNumber,
    ) -> bool;
}
pub type XidStatus = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_clog_truncate {
    pub pageno: ::std::os::raw::c_int,
    pub oldestXact: TransactionId,
    pub oldestXactDb: Oid,
}
impl Default for xl_clog_truncate {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TransactionIdSetTreeStatus(
        xid: TransactionId,
        nsubxids: ::std::os::raw::c_int,
        subxids: *mut TransactionId,
        status: XidStatus,
        lsn: XLogRecPtr,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TransactionIdGetStatus(xid: TransactionId, lsn: *mut XLogRecPtr) -> XidStatus;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CLOGShmemBuffers() -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CLOGShmemSize() -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CLOGShmemInit();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BootStrapCLOG();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn StartupCLOG();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TrimCLOG();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ShutdownCLOG();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CheckPointCLOG();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExtendCLOG(newestXact: TransactionId);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TruncateCLOG(oldestXact: TransactionId, oldestxid_datoid: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn clog_redo(record: *mut XLogReaderState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn clog_desc(buf: StringInfo, record: *mut XLogReaderState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn clog_identify(info: uint8) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_node {
    pub prev: *mut dlist_node,
    pub next: *mut dlist_node,
}
impl Default for dlist_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_head {
    pub head: dlist_node,
}
impl Default for dlist_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_iter {
    pub cur: *mut dlist_node,
    pub end: *mut dlist_node,
}
impl Default for dlist_iter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dlist_mutable_iter {
    pub cur: *mut dlist_node,
    pub next: *mut dlist_node,
    pub end: *mut dlist_node,
}
impl Default for dlist_mutable_iter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_node {
    pub next: *mut slist_node,
}
impl Default for slist_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_head {
    pub head: slist_node,
}
impl Default for slist_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_iter {
    pub cur: *mut slist_node,
}
impl Default for slist_iter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct slist_mutable_iter {
    pub cur: *mut slist_node,
    pub next: *mut slist_node,
    pub prev: *mut slist_node,
}
impl Default for slist_mutable_iter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn slist_delete(head: *mut slist_head, node: *mut slist_node);
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct Latch {
    pub is_set: sig_atomic_t,
    pub is_shared: bool,
    pub owner_pid: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WaitEvent {
    pub pos: ::std::os::raw::c_int,
    pub events: uint32,
    pub fd: pgsocket,
    pub user_data: *mut ::std::os::raw::c_void,
}
impl Default for WaitEvent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WaitEventSet {
    _unused: [u8; 0],
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitializeLatchSupport();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitLatch(latch: *mut Latch);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitSharedLatch(latch: *mut Latch);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OwnLatch(latch: *mut Latch);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DisownLatch(latch: *mut Latch);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SetLatch(latch: *mut Latch);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ResetLatch(latch: *mut Latch);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CreateWaitEventSet(
        context: MemoryContext,
        nevents: ::std::os::raw::c_int,
    ) -> *mut WaitEventSet;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FreeWaitEventSet(set: *mut WaitEventSet);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AddWaitEventToSet(
        set: *mut WaitEventSet,
        events: uint32,
        fd: pgsocket,
        latch: *mut Latch,
        user_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ModifyWaitEvent(
        set: *mut WaitEventSet,
        pos: ::std::os::raw::c_int,
        events: uint32,
        latch: *mut Latch,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn WaitEventSetWait(
        set: *mut WaitEventSet,
        timeout: ::std::os::raw::c_long,
        occurred_events: *mut WaitEvent,
        nevents: ::std::os::raw::c_int,
        wait_event_info: uint32,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn WaitLatch(
        latch: *mut Latch,
        wakeEvents: ::std::os::raw::c_int,
        timeout: ::std::os::raw::c_long,
        wait_event_info: uint32,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn WaitLatchOrSocket(
        latch: *mut Latch,
        wakeEvents: ::std::os::raw::c_int,
        sock: pgsocket,
        timeout: ::std::os::raw::c_long,
        wait_event_info: uint32,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn latch_sigusr1_handler();
}
pub type LOCKMASK = ::std::os::raw::c_int;
pub type LOCKMODE = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_standby_lock {
    pub xid: TransactionId,
    pub dbOid: Oid,
    pub relOid: Oid,
}
impl Default for xl_standby_lock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LWLock {
    pub tranche: uint16,
    pub state: pg_atomic_uint32,
    pub waiters: proclist_head,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union LWLockPadded {
    pub lock: LWLock,
    pub pad: [::std::os::raw::c_char; 128usize],
}
impl Default for LWLockPadded {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union LWLockMinimallyPadded {
    pub lock: LWLock,
    pub pad: [::std::os::raw::c_char; 32usize],
}
impl Default for LWLockMinimallyPadded {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut MainLWLockArray: *mut LWLockPadded;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NamedLWLockTranche {
    pub trancheId: ::std::os::raw::c_int,
    pub trancheName: *mut ::std::os::raw::c_char,
}
impl Default for NamedLWLockTranche {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut NamedLWLockTrancheArray: *mut NamedLWLockTranche;
}
extern "C" {
    pub static mut NamedLWLockTrancheRequests: ::std::os::raw::c_int;
}
pub const LWLockMode_LW_EXCLUSIVE: LWLockMode = 0;
pub const LWLockMode_LW_SHARED: LWLockMode = 1;
pub const LWLockMode_LW_WAIT_UNTIL_FREE: LWLockMode = 2;
pub type LWLockMode = ::std::os::raw::c_uint;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LWLockAcquire(lock: *mut LWLock, mode: LWLockMode) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LWLockConditionalAcquire(lock: *mut LWLock, mode: LWLockMode) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LWLockAcquireOrWait(lock: *mut LWLock, mode: LWLockMode) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LWLockRelease(lock: *mut LWLock);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LWLockReleaseClearVar(lock: *mut LWLock, valptr: *mut uint64, val: uint64);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LWLockReleaseAll();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LWLockHeldByMe(lock: *mut LWLock) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LWLockAnyHeldByMe(
        lock: *mut LWLock,
        nlocks: ::std::os::raw::c_int,
        stride: usize,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LWLockHeldByMeInMode(lock: *mut LWLock, mode: LWLockMode) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LWLockWaitForVar(
        lock: *mut LWLock,
        valptr: *mut uint64,
        oldval: uint64,
        newval: *mut uint64,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LWLockUpdateVar(lock: *mut LWLock, valptr: *mut uint64, value: uint64);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LWLockShmemSize() -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CreateLWLocks();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitLWLockAccess();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetLWLockIdentifier(classId: uint32, eventId: uint16) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RequestNamedLWLockTranche(
        tranche_name: *const ::std::os::raw::c_char,
        num_lwlocks: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetNamedLWLockTranche(tranche_name: *const ::std::os::raw::c_char) -> *mut LWLockPadded;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LWLockNewTrancheId() -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LWLockRegisterTranche(
        tranche_id: ::std::os::raw::c_int,
        tranche_name: *const ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LWLockInitialize(lock: *mut LWLock, tranche_id: ::std::os::raw::c_int);
}
pub const BuiltinTrancheIds_LWTRANCHE_XACT_BUFFER: BuiltinTrancheIds = 48;
pub const BuiltinTrancheIds_LWTRANCHE_COMMITTS_BUFFER: BuiltinTrancheIds = 49;
pub const BuiltinTrancheIds_LWTRANCHE_SUBTRANS_BUFFER: BuiltinTrancheIds = 50;
pub const BuiltinTrancheIds_LWTRANCHE_MULTIXACTOFFSET_BUFFER: BuiltinTrancheIds = 51;
pub const BuiltinTrancheIds_LWTRANCHE_MULTIXACTMEMBER_BUFFER: BuiltinTrancheIds = 52;
pub const BuiltinTrancheIds_LWTRANCHE_NOTIFY_BUFFER: BuiltinTrancheIds = 53;
pub const BuiltinTrancheIds_LWTRANCHE_SERIAL_BUFFER: BuiltinTrancheIds = 54;
pub const BuiltinTrancheIds_LWTRANCHE_WAL_INSERT: BuiltinTrancheIds = 55;
pub const BuiltinTrancheIds_LWTRANCHE_BUFFER_CONTENT: BuiltinTrancheIds = 56;
pub const BuiltinTrancheIds_LWTRANCHE_BUFFER_IO: BuiltinTrancheIds = 57;
pub const BuiltinTrancheIds_LWTRANCHE_REPLICATION_ORIGIN_STATE: BuiltinTrancheIds = 58;
pub const BuiltinTrancheIds_LWTRANCHE_REPLICATION_SLOT_IO: BuiltinTrancheIds = 59;
pub const BuiltinTrancheIds_LWTRANCHE_LOCK_FASTPATH: BuiltinTrancheIds = 60;
pub const BuiltinTrancheIds_LWTRANCHE_BUFFER_MAPPING: BuiltinTrancheIds = 61;
pub const BuiltinTrancheIds_LWTRANCHE_LOCK_MANAGER: BuiltinTrancheIds = 62;
pub const BuiltinTrancheIds_LWTRANCHE_PREDICATE_LOCK_MANAGER: BuiltinTrancheIds = 63;
pub const BuiltinTrancheIds_LWTRANCHE_PARALLEL_HASH_JOIN: BuiltinTrancheIds = 64;
pub const BuiltinTrancheIds_LWTRANCHE_PARALLEL_QUERY_DSA: BuiltinTrancheIds = 65;
pub const BuiltinTrancheIds_LWTRANCHE_PER_SESSION_DSA: BuiltinTrancheIds = 66;
pub const BuiltinTrancheIds_LWTRANCHE_PER_SESSION_RECORD_TYPE: BuiltinTrancheIds = 67;
pub const BuiltinTrancheIds_LWTRANCHE_PER_SESSION_RECORD_TYPMOD: BuiltinTrancheIds = 68;
pub const BuiltinTrancheIds_LWTRANCHE_SHARED_TUPLESTORE: BuiltinTrancheIds = 69;
pub const BuiltinTrancheIds_LWTRANCHE_SHARED_TIDBITMAP: BuiltinTrancheIds = 70;
pub const BuiltinTrancheIds_LWTRANCHE_PARALLEL_APPEND: BuiltinTrancheIds = 71;
pub const BuiltinTrancheIds_LWTRANCHE_PER_XACT_PREDICATE_LIST: BuiltinTrancheIds = 72;
pub const BuiltinTrancheIds_LWTRANCHE_FIRST_USER_DEFINED: BuiltinTrancheIds = 73;
pub type BuiltinTrancheIds = ::std::os::raw::c_uint;
pub type LWLockId = *mut LWLock;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SHM_QUEUE {
    pub prev: *mut SHM_QUEUE,
    pub next: *mut SHM_QUEUE,
}
impl Default for SHM_QUEUE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitShmemAccess(seghdr: *mut ::std::os::raw::c_void);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitShmemAllocation();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ShmemAlloc(size: Size) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ShmemAllocNoError(size: Size) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ShmemAllocUnlocked(size: Size) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ShmemAddrIsValid(addr: *const ::std::os::raw::c_void) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitShmemIndex();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ShmemInitHash(
        name: *const ::std::os::raw::c_char,
        init_size: ::std::os::raw::c_long,
        max_size: ::std::os::raw::c_long,
        infoP: *mut HASHCTL,
        hash_flags: ::std::os::raw::c_int,
    ) -> *mut HTAB;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ShmemInitStruct(
        name: *const ::std::os::raw::c_char,
        size: Size,
        foundPtr: *mut bool,
    ) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn add_size(s1: Size, s2: Size) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn mul_size(s1: Size, s2: Size) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RequestAddinShmemSpace(size: Size);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ShmemIndexEnt {
    pub key: [::std::os::raw::c_char; 48usize],
    pub location: *mut ::std::os::raw::c_void,
    pub size: Size,
    pub allocated_size: Size,
}
impl Default for ShmemIndexEnt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SHMQueueInit(queue: *mut SHM_QUEUE);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SHMQueueElemInit(queue: *mut SHM_QUEUE);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SHMQueueDelete(queue: *mut SHM_QUEUE);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SHMQueueInsertBefore(queue: *mut SHM_QUEUE, elem: *mut SHM_QUEUE);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SHMQueueInsertAfter(queue: *mut SHM_QUEUE, elem: *mut SHM_QUEUE);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SHMQueueNext(
        queue: *const SHM_QUEUE,
        curElem: *const SHM_QUEUE,
        linkOffset: Size,
    ) -> Pointer;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SHMQueuePrev(
        queue: *const SHM_QUEUE,
        curElem: *const SHM_QUEUE,
        linkOffset: Size,
    ) -> Pointer;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SHMQueueEmpty(queue: *const SHM_QUEUE) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SHMQueueIsDetached(queue: *const SHM_QUEUE) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PROC_QUEUE {
    pub links: SHM_QUEUE,
    pub size: ::std::os::raw::c_int,
}
impl Default for PROC_QUEUE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut max_locks_per_xact: ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct VirtualTransactionId {
    pub backendId: BackendId,
    pub localTransactionId: LocalTransactionId,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockMethodData {
    pub numLockModes: ::std::os::raw::c_int,
    pub conflictTab: *const LOCKMASK,
    pub lockModeNames: *const *const ::std::os::raw::c_char,
    pub trace_flag: *const bool,
}
impl Default for LockMethodData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type LockMethod = *const LockMethodData;
pub type LOCKMETHODID = uint16;
pub const LockTagType_LOCKTAG_RELATION: LockTagType = 0;
pub const LockTagType_LOCKTAG_RELATION_EXTEND: LockTagType = 1;
pub const LockTagType_LOCKTAG_DATABASE_FROZEN_IDS: LockTagType = 2;
pub const LockTagType_LOCKTAG_PAGE: LockTagType = 3;
pub const LockTagType_LOCKTAG_TUPLE: LockTagType = 4;
pub const LockTagType_LOCKTAG_TRANSACTION: LockTagType = 5;
pub const LockTagType_LOCKTAG_VIRTUALTRANSACTION: LockTagType = 6;
pub const LockTagType_LOCKTAG_SPECULATIVE_TOKEN: LockTagType = 7;
pub const LockTagType_LOCKTAG_OBJECT: LockTagType = 8;
pub const LockTagType_LOCKTAG_USERLOCK: LockTagType = 9;
pub const LockTagType_LOCKTAG_ADVISORY: LockTagType = 10;
pub type LockTagType = ::std::os::raw::c_uint;
extern "C" {
    pub static LockTagTypeNames: [*const ::std::os::raw::c_char; 0usize];
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LOCKTAG {
    pub locktag_field1: uint32,
    pub locktag_field2: uint32,
    pub locktag_field3: uint32,
    pub locktag_field4: uint16,
    pub locktag_type: uint8,
    pub locktag_lockmethodid: uint8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LOCK {
    pub tag: LOCKTAG,
    pub grantMask: LOCKMASK,
    pub waitMask: LOCKMASK,
    pub procLocks: SHM_QUEUE,
    pub waitProcs: PROC_QUEUE,
    pub requested: [::std::os::raw::c_int; 10usize],
    pub nRequested: ::std::os::raw::c_int,
    pub granted: [::std::os::raw::c_int; 10usize],
    pub nGranted: ::std::os::raw::c_int,
}
impl Default for LOCK {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PROCLOCKTAG {
    pub myLock: *mut LOCK,
    pub myProc: *mut PGPROC,
}
impl Default for PROCLOCKTAG {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PROCLOCK {
    pub tag: PROCLOCKTAG,
    pub groupLeader: *mut PGPROC,
    pub holdMask: LOCKMASK,
    pub releaseMask: LOCKMASK,
    pub lockLink: SHM_QUEUE,
    pub procLink: SHM_QUEUE,
}
impl Default for PROCLOCK {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LOCALLOCKTAG {
    pub lock: LOCKTAG,
    pub mode: LOCKMODE,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LOCALLOCKOWNER {
    pub owner: *mut ResourceOwnerData,
    pub nLocks: int64,
}
impl Default for LOCALLOCKOWNER {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LOCALLOCK {
    pub tag: LOCALLOCKTAG,
    pub hashcode: uint32,
    pub lock: *mut LOCK,
    pub proclock: *mut PROCLOCK,
    pub nLocks: int64,
    pub numLockOwners: ::std::os::raw::c_int,
    pub maxLockOwners: ::std::os::raw::c_int,
    pub lockOwners: *mut LOCALLOCKOWNER,
    pub holdsStrongLockCount: bool,
    pub lockCleared: bool,
}
impl Default for LOCALLOCK {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct LockInstanceData {
    pub locktag: LOCKTAG,
    pub holdMask: LOCKMASK,
    pub waitLockMode: LOCKMODE,
    pub backend: BackendId,
    pub lxid: LocalTransactionId,
    pub pid: ::std::os::raw::c_int,
    pub leaderPid: ::std::os::raw::c_int,
    pub fastpath: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockData {
    pub nelements: ::std::os::raw::c_int,
    pub locks: *mut LockInstanceData,
}
impl Default for LockData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct BlockedProcData {
    pub pid: ::std::os::raw::c_int,
    pub first_lock: ::std::os::raw::c_int,
    pub num_locks: ::std::os::raw::c_int,
    pub first_waiter: ::std::os::raw::c_int,
    pub num_waiters: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockedProcsData {
    pub procs: *mut BlockedProcData,
    pub locks: *mut LockInstanceData,
    pub waiter_pids: *mut ::std::os::raw::c_int,
    pub nprocs: ::std::os::raw::c_int,
    pub maxprocs: ::std::os::raw::c_int,
    pub nlocks: ::std::os::raw::c_int,
    pub maxlocks: ::std::os::raw::c_int,
    pub npids: ::std::os::raw::c_int,
    pub maxpids: ::std::os::raw::c_int,
}
impl Default for BlockedProcsData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const LockAcquireResult_LOCKACQUIRE_NOT_AVAIL: LockAcquireResult = 0;
pub const LockAcquireResult_LOCKACQUIRE_OK: LockAcquireResult = 1;
pub const LockAcquireResult_LOCKACQUIRE_ALREADY_HELD: LockAcquireResult = 2;
pub const LockAcquireResult_LOCKACQUIRE_ALREADY_CLEAR: LockAcquireResult = 3;
pub type LockAcquireResult = ::std::os::raw::c_uint;
pub const DeadLockState_DS_NOT_YET_CHECKED: DeadLockState = 0;
pub const DeadLockState_DS_NO_DEADLOCK: DeadLockState = 1;
pub const DeadLockState_DS_SOFT_DEADLOCK: DeadLockState = 2;
pub const DeadLockState_DS_HARD_DEADLOCK: DeadLockState = 3;
pub const DeadLockState_DS_BLOCKED_BY_AUTOVACUUM: DeadLockState = 4;
pub type DeadLockState = ::std::os::raw::c_uint;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitLocks();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetLocksMethodTable(lock: *const LOCK) -> LockMethod;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetLockTagsMethodTable(locktag: *const LOCKTAG) -> LockMethod;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LockTagHashCode(locktag: *const LOCKTAG) -> uint32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DoLockModesConflict(mode1: LOCKMODE, mode2: LOCKMODE) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LockAcquire(
        locktag: *const LOCKTAG,
        lockmode: LOCKMODE,
        sessionLock: bool,
        dontWait: bool,
    ) -> LockAcquireResult;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LockAcquireExtended(
        locktag: *const LOCKTAG,
        lockmode: LOCKMODE,
        sessionLock: bool,
        dontWait: bool,
        reportMemoryError: bool,
        locallockp: *mut *mut LOCALLOCK,
    ) -> LockAcquireResult;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AbortStrongLockAcquire();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MarkLockClear(locallock: *mut LOCALLOCK);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LockRelease(locktag: *const LOCKTAG, lockmode: LOCKMODE, sessionLock: bool) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LockReleaseAll(lockmethodid: LOCKMETHODID, allLocks: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LockReleaseSession(lockmethodid: LOCKMETHODID);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LockReleaseCurrentOwner(locallocks: *mut *mut LOCALLOCK, nlocks: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LockReassignCurrentOwner(locallocks: *mut *mut LOCALLOCK, nlocks: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LockHeldByMe(locktag: *const LOCKTAG, lockmode: LOCKMODE) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetLockMethodLocalHash() -> *mut HTAB;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LockHasWaiters(locktag: *const LOCKTAG, lockmode: LOCKMODE, sessionLock: bool) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetLockConflicts(
        locktag: *const LOCKTAG,
        lockmode: LOCKMODE,
        countp: *mut ::std::os::raw::c_int,
    ) -> *mut VirtualTransactionId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AtPrepare_Locks();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PostPrepare_Locks(xid: TransactionId);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LockCheckConflicts(
        lockMethodTable: LockMethod,
        lockmode: LOCKMODE,
        lock: *mut LOCK,
        proclock: *mut PROCLOCK,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GrantLock(lock: *mut LOCK, proclock: *mut PROCLOCK, lockmode: LOCKMODE);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GrantAwaitedLock();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RemoveFromWaitQueue(proc_: *mut PGPROC, hashcode: uint32);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LockShmemSize() -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetLockStatusData() -> *mut LockData;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetBlockerStatusData(blocked_pid: ::std::os::raw::c_int) -> *mut BlockedProcsData;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetRunningTransactionLocks(nlocks: *mut ::std::os::raw::c_int) -> *mut xl_standby_lock;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetLockmodeName(
        lockmethodid: LOCKMETHODID,
        mode: LOCKMODE,
    ) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn lock_twophase_recover(
        xid: TransactionId,
        info: uint16,
        recdata: *mut ::std::os::raw::c_void,
        len: uint32,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn lock_twophase_postcommit(
        xid: TransactionId,
        info: uint16,
        recdata: *mut ::std::os::raw::c_void,
        len: uint32,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn lock_twophase_postabort(
        xid: TransactionId,
        info: uint16,
        recdata: *mut ::std::os::raw::c_void,
        len: uint32,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn lock_twophase_standby_recover(
        xid: TransactionId,
        info: uint16,
        recdata: *mut ::std::os::raw::c_void,
        len: uint32,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DeadLockCheck(proc_: *mut PGPROC) -> DeadLockState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetBlockingAutoVacuumPgproc() -> *mut PGPROC;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DeadLockReport() -> !;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RememberSimpleDeadLock(
        proc1: *mut PGPROC,
        lockmode: LOCKMODE,
        lock: *mut LOCK,
        proc2: *mut PGPROC,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitDeadLockChecking();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LockWaiterCount(locktag: *const LOCKTAG) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn VirtualXactLockTableInsert(vxid: VirtualTransactionId);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn VirtualXactLockTableCleanup();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn VirtualXactLock(vxid: VirtualTransactionId, wait: bool) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PGSemaphoreData {
    _unused: [u8; 0],
}
pub type PGSemaphore = *mut PGSemaphoreData;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PGSemaphoreShmemSize(maxSemas: ::std::os::raw::c_int) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PGReserveSemaphores(maxSemas: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PGSemaphoreCreate() -> PGSemaphore;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PGSemaphoreReset(sema: PGSemaphore);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PGSemaphoreLock(sema: PGSemaphore);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PGSemaphoreUnlock(sema: PGSemaphore);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PGSemaphoreTryLock(sema: PGSemaphore) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XidCache {
    pub xids: [TransactionId; 64usize],
}
impl Default for XidCache {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PGPROC {
    pub links: SHM_QUEUE,
    pub procgloballist: *mut *mut PGPROC,
    pub sem: PGSemaphore,
    pub waitStatus: ::std::os::raw::c_int,
    pub procLatch: Latch,
    pub lxid: LocalTransactionId,
    pub pid: ::std::os::raw::c_int,
    pub pgprocno: ::std::os::raw::c_int,
    pub backendId: BackendId,
    pub databaseId: Oid,
    pub roleId: Oid,
    pub tempNamespaceId: Oid,
    pub isBackgroundWorker: bool,
    pub recoveryConflictPending: bool,
    pub lwWaiting: bool,
    pub lwWaitMode: uint8,
    pub lwWaitLink: proclist_node,
    pub cvWaitLink: proclist_node,
    pub waitLock: *mut LOCK,
    pub waitProcLock: *mut PROCLOCK,
    pub waitLockMode: LOCKMODE,
    pub heldLocks: LOCKMASK,
    pub delayChkpt: bool,
    pub delayChkptEnd: bool,
    pub waitLSN: XLogRecPtr,
    pub syncRepState: ::std::os::raw::c_int,
    pub syncRepLinks: SHM_QUEUE,
    pub myProcLocks: [SHM_QUEUE; 16usize],
    pub subxids: XidCache,
    pub procArrayGroupMember: bool,
    pub procArrayGroupNext: pg_atomic_uint32,
    pub procArrayGroupMemberXid: TransactionId,
    pub wait_event_info: uint32,
    pub clogGroupMember: bool,
    pub clogGroupNext: pg_atomic_uint32,
    pub clogGroupMemberXid: TransactionId,
    pub clogGroupMemberXidStatus: XidStatus,
    pub clogGroupMemberPage: ::std::os::raw::c_int,
    pub clogGroupMemberLsn: XLogRecPtr,
    pub fpInfoLock: LWLock,
    pub fpLockBits: uint64,
    pub fpRelId: [Oid; 16usize],
    pub fpVXIDLock: bool,
    pub fpLocalTransactionId: LocalTransactionId,
    pub lockGroupLeader: *mut PGPROC,
    pub lockGroupMembers: dlist_head,
    pub lockGroupLink: dlist_node,
}
impl Default for PGPROC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut MyProc: *mut PGPROC;
}
extern "C" {
    pub static mut MyPgXact: *mut PGXACT;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PGXACT {
    pub xid: TransactionId,
    pub xmin: TransactionId,
    pub vacuumFlags: uint8,
    pub overflowed: bool,
    pub nxids: uint8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PROC_HDR {
    pub allProcs: *mut PGPROC,
    pub allPgXact: *mut PGXACT,
    pub allProcCount: uint32,
    pub freeProcs: *mut PGPROC,
    pub autovacFreeProcs: *mut PGPROC,
    pub bgworkerFreeProcs: *mut PGPROC,
    pub walsenderFreeProcs: *mut PGPROC,
    pub procArrayGroupFirst: pg_atomic_uint32,
    pub clogGroupFirst: pg_atomic_uint32,
    pub walwriterLatch: *mut Latch,
    pub checkpointerLatch: *mut Latch,
    pub spins_per_delay: ::std::os::raw::c_int,
    pub startupProc: *mut PGPROC,
    pub startupProcPid: ::std::os::raw::c_int,
    pub startupBufferPinWaitBufId: ::std::os::raw::c_int,
}
impl Default for PROC_HDR {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut ProcGlobal: *mut PROC_HDR;
}
extern "C" {
    pub static mut PreparedXactProcs: *mut PGPROC;
}
extern "C" {
    pub static mut DeadlockTimeout: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut StatementTimeout: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut LockTimeout: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut IdleInTransactionSessionTimeout: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut log_lock_waits: bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ProcGlobalSemas() -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ProcGlobalShmemSize() -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitProcGlobal();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitProcess();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitProcessPhase2();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitAuxiliaryProcess();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PublishStartupProcessInformation();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SetStartupBufferPinWaitBufId(bufid: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetStartupBufferPinWaitBufId() -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn HaveNFreeProcs(n: ::std::os::raw::c_int) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ProcReleaseLocks(isCommit: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ProcQueueInit(queue: *mut PROC_QUEUE);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ProcSleep(
        locallock: *mut LOCALLOCK,
        lockMethodTable: LockMethod,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ProcWakeup(proc_: *mut PGPROC, waitStatus: ::std::os::raw::c_int) -> *mut PGPROC;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ProcLockWakeup(lockMethodTable: LockMethod, lock: *mut LOCK);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CheckDeadLockAlert();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn IsWaitingForLock() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LockErrorCleanup();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ProcWaitForSignal(wait_event_info: uint32);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ProcSendSignal(pid: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AuxiliaryPidGetProc(pid: ::std::os::raw::c_int) -> *mut PGPROC;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BecomeLockGroupLeader();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BecomeLockGroupMember(leader: *mut PGPROC, pid: ::std::os::raw::c_int) -> bool;
}
pub const TrackFunctionsLevel_TRACK_FUNC_OFF: TrackFunctionsLevel = 0;
pub const TrackFunctionsLevel_TRACK_FUNC_PL: TrackFunctionsLevel = 1;
pub const TrackFunctionsLevel_TRACK_FUNC_ALL: TrackFunctionsLevel = 2;
pub type TrackFunctionsLevel = ::std::os::raw::c_uint;
pub const StatMsgType_PGSTAT_MTYPE_DUMMY: StatMsgType = 0;
pub const StatMsgType_PGSTAT_MTYPE_INQUIRY: StatMsgType = 1;
pub const StatMsgType_PGSTAT_MTYPE_TABSTAT: StatMsgType = 2;
pub const StatMsgType_PGSTAT_MTYPE_TABPURGE: StatMsgType = 3;
pub const StatMsgType_PGSTAT_MTYPE_DROPDB: StatMsgType = 4;
pub const StatMsgType_PGSTAT_MTYPE_RESETCOUNTER: StatMsgType = 5;
pub const StatMsgType_PGSTAT_MTYPE_RESETSHAREDCOUNTER: StatMsgType = 6;
pub const StatMsgType_PGSTAT_MTYPE_RESETSINGLECOUNTER: StatMsgType = 7;
pub const StatMsgType_PGSTAT_MTYPE_RESETSLRUCOUNTER: StatMsgType = 8;
pub const StatMsgType_PGSTAT_MTYPE_AUTOVAC_START: StatMsgType = 9;
pub const StatMsgType_PGSTAT_MTYPE_VACUUM: StatMsgType = 10;
pub const StatMsgType_PGSTAT_MTYPE_ANALYZE: StatMsgType = 11;
pub const StatMsgType_PGSTAT_MTYPE_ARCHIVER: StatMsgType = 12;
pub const StatMsgType_PGSTAT_MTYPE_BGWRITER: StatMsgType = 13;
pub const StatMsgType_PGSTAT_MTYPE_SLRU: StatMsgType = 14;
pub const StatMsgType_PGSTAT_MTYPE_FUNCSTAT: StatMsgType = 15;
pub const StatMsgType_PGSTAT_MTYPE_FUNCPURGE: StatMsgType = 16;
pub const StatMsgType_PGSTAT_MTYPE_RECOVERYCONFLICT: StatMsgType = 17;
pub const StatMsgType_PGSTAT_MTYPE_TEMPFILE: StatMsgType = 18;
pub const StatMsgType_PGSTAT_MTYPE_DEADLOCK: StatMsgType = 19;
pub const StatMsgType_PGSTAT_MTYPE_CHECKSUMFAILURE: StatMsgType = 20;
pub type StatMsgType = ::std::os::raw::c_uint;
pub type PgStat_Counter = int64;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_TableCounts {
    pub t_numscans: PgStat_Counter,
    pub t_tuples_returned: PgStat_Counter,
    pub t_tuples_fetched: PgStat_Counter,
    pub t_tuples_inserted: PgStat_Counter,
    pub t_tuples_updated: PgStat_Counter,
    pub t_tuples_deleted: PgStat_Counter,
    pub t_tuples_hot_updated: PgStat_Counter,
    pub t_truncated: bool,
    pub t_delta_live_tuples: PgStat_Counter,
    pub t_delta_dead_tuples: PgStat_Counter,
    pub t_changed_tuples: PgStat_Counter,
    pub t_blocks_fetched: PgStat_Counter,
    pub t_blocks_hit: PgStat_Counter,
}
pub const PgStat_Shared_Reset_Target_RESET_ARCHIVER: PgStat_Shared_Reset_Target = 0;
pub const PgStat_Shared_Reset_Target_RESET_BGWRITER: PgStat_Shared_Reset_Target = 1;
pub type PgStat_Shared_Reset_Target = ::std::os::raw::c_uint;
pub const PgStat_Single_Reset_Type_RESET_TABLE: PgStat_Single_Reset_Type = 0;
pub const PgStat_Single_Reset_Type_RESET_FUNCTION: PgStat_Single_Reset_Type = 1;
pub type PgStat_Single_Reset_Type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_TableStatus {
    pub t_id: Oid,
    pub t_shared: bool,
    pub trans: *mut PgStat_TableXactStatus,
    pub t_counts: PgStat_TableCounts,
}
impl Default for PgStat_TableStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_TableXactStatus {
    pub tuples_inserted: PgStat_Counter,
    pub tuples_updated: PgStat_Counter,
    pub tuples_deleted: PgStat_Counter,
    pub truncated: bool,
    pub inserted_pre_trunc: PgStat_Counter,
    pub updated_pre_trunc: PgStat_Counter,
    pub deleted_pre_trunc: PgStat_Counter,
    pub nest_level: ::std::os::raw::c_int,
    pub upper: *mut PgStat_TableXactStatus,
    pub parent: *mut PgStat_TableStatus,
    pub next: *mut PgStat_TableXactStatus,
}
impl Default for PgStat_TableXactStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgHdr {
    pub m_type: StatMsgType,
    pub m_size: ::std::os::raw::c_int,
}
impl Default for PgStat_MsgHdr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgDummy {
    pub m_hdr: PgStat_MsgHdr,
}
impl Default for PgStat_MsgDummy {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgInquiry {
    pub m_hdr: PgStat_MsgHdr,
    pub clock_time: TimestampTz,
    pub cutoff_time: TimestampTz,
    pub databaseid: Oid,
}
impl Default for PgStat_MsgInquiry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_TableEntry {
    pub t_id: Oid,
    pub t_counts: PgStat_TableCounts,
}
impl Default for PgStat_TableEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgTabstat {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_nentries: ::std::os::raw::c_int,
    pub m_xact_commit: ::std::os::raw::c_int,
    pub m_xact_rollback: ::std::os::raw::c_int,
    pub m_block_read_time: PgStat_Counter,
    pub m_block_write_time: PgStat_Counter,
    pub m_entry: [PgStat_TableEntry; 8usize],
}
impl Default for PgStat_MsgTabstat {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgTabpurge {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_nentries: ::std::os::raw::c_int,
    pub m_tableid: [Oid; 246usize],
}
impl Default for PgStat_MsgTabpurge {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgDropdb {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
}
impl Default for PgStat_MsgDropdb {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgResetcounter {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
}
impl Default for PgStat_MsgResetcounter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgResetsharedcounter {
    pub m_hdr: PgStat_MsgHdr,
    pub m_resettarget: PgStat_Shared_Reset_Target,
}
impl Default for PgStat_MsgResetsharedcounter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgResetsinglecounter {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_resettype: PgStat_Single_Reset_Type,
    pub m_objectid: Oid,
}
impl Default for PgStat_MsgResetsinglecounter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgResetslrucounter {
    pub m_hdr: PgStat_MsgHdr,
    pub m_index: ::std::os::raw::c_int,
}
impl Default for PgStat_MsgResetslrucounter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgAutovacStart {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_start_time: TimestampTz,
}
impl Default for PgStat_MsgAutovacStart {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgVacuum {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_tableoid: Oid,
    pub m_autovacuum: bool,
    pub m_vacuumtime: TimestampTz,
    pub m_live_tuples: PgStat_Counter,
    pub m_dead_tuples: PgStat_Counter,
}
impl Default for PgStat_MsgVacuum {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgAnalyze {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_tableoid: Oid,
    pub m_autovacuum: bool,
    pub m_resetcounter: bool,
    pub m_analyzetime: TimestampTz,
    pub m_live_tuples: PgStat_Counter,
    pub m_dead_tuples: PgStat_Counter,
}
impl Default for PgStat_MsgAnalyze {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgArchiver {
    pub m_hdr: PgStat_MsgHdr,
    pub m_failed: bool,
    pub m_xlog: [::std::os::raw::c_char; 41usize],
    pub m_timestamp: TimestampTz,
}
impl Default for PgStat_MsgArchiver {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgBgWriter {
    pub m_hdr: PgStat_MsgHdr,
    pub m_timed_checkpoints: PgStat_Counter,
    pub m_requested_checkpoints: PgStat_Counter,
    pub m_buf_written_checkpoints: PgStat_Counter,
    pub m_buf_written_clean: PgStat_Counter,
    pub m_maxwritten_clean: PgStat_Counter,
    pub m_buf_written_backend: PgStat_Counter,
    pub m_buf_fsync_backend: PgStat_Counter,
    pub m_buf_alloc: PgStat_Counter,
    pub m_checkpoint_write_time: PgStat_Counter,
    pub m_checkpoint_sync_time: PgStat_Counter,
}
impl Default for PgStat_MsgBgWriter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgSLRU {
    pub m_hdr: PgStat_MsgHdr,
    pub m_index: PgStat_Counter,
    pub m_blocks_zeroed: PgStat_Counter,
    pub m_blocks_hit: PgStat_Counter,
    pub m_blocks_read: PgStat_Counter,
    pub m_blocks_written: PgStat_Counter,
    pub m_blocks_exists: PgStat_Counter,
    pub m_flush: PgStat_Counter,
    pub m_truncate: PgStat_Counter,
}
impl Default for PgStat_MsgSLRU {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgRecoveryConflict {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_reason: ::std::os::raw::c_int,
}
impl Default for PgStat_MsgRecoveryConflict {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgTempFile {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_filesize: usize,
}
impl Default for PgStat_MsgTempFile {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_FunctionCounts {
    pub f_numcalls: PgStat_Counter,
    pub f_total_time: instr_time,
    pub f_self_time: instr_time,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_BackendFunctionEntry {
    pub f_id: Oid,
    pub f_counts: PgStat_FunctionCounts,
}
impl Default for PgStat_BackendFunctionEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_FunctionEntry {
    pub f_id: Oid,
    pub f_numcalls: PgStat_Counter,
    pub f_total_time: PgStat_Counter,
    pub f_self_time: PgStat_Counter,
}
impl Default for PgStat_FunctionEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgFuncstat {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_nentries: ::std::os::raw::c_int,
    pub m_entry: [PgStat_FunctionEntry; 30usize],
}
impl Default for PgStat_MsgFuncstat {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgFuncpurge {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_nentries: ::std::os::raw::c_int,
    pub m_functionid: [Oid; 246usize],
}
impl Default for PgStat_MsgFuncpurge {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgDeadlock {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
}
impl Default for PgStat_MsgDeadlock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_MsgChecksumFailure {
    pub m_hdr: PgStat_MsgHdr,
    pub m_databaseid: Oid,
    pub m_failurecount: ::std::os::raw::c_int,
    pub m_failure_time: TimestampTz,
}
impl Default for PgStat_MsgChecksumFailure {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union PgStat_Msg {
    pub msg_hdr: PgStat_MsgHdr,
    pub msg_dummy: PgStat_MsgDummy,
    pub msg_inquiry: PgStat_MsgInquiry,
    pub msg_tabstat: PgStat_MsgTabstat,
    pub msg_tabpurge: PgStat_MsgTabpurge,
    pub msg_dropdb: PgStat_MsgDropdb,
    pub msg_resetcounter: PgStat_MsgResetcounter,
    pub msg_resetsharedcounter: PgStat_MsgResetsharedcounter,
    pub msg_resetsinglecounter: PgStat_MsgResetsinglecounter,
    pub msg_resetslrucounter: PgStat_MsgResetslrucounter,
    pub msg_autovacuum_start: PgStat_MsgAutovacStart,
    pub msg_vacuum: PgStat_MsgVacuum,
    pub msg_analyze: PgStat_MsgAnalyze,
    pub msg_archiver: PgStat_MsgArchiver,
    pub msg_bgwriter: PgStat_MsgBgWriter,
    pub msg_slru: PgStat_MsgSLRU,
    pub msg_funcstat: PgStat_MsgFuncstat,
    pub msg_funcpurge: PgStat_MsgFuncpurge,
    pub msg_recoveryconflict: PgStat_MsgRecoveryConflict,
    pub msg_deadlock: PgStat_MsgDeadlock,
    pub msg_tempfile: PgStat_MsgTempFile,
    pub msg_checksumfailure: PgStat_MsgChecksumFailure,
}
impl Default for PgStat_Msg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_StatDBEntry {
    pub databaseid: Oid,
    pub n_xact_commit: PgStat_Counter,
    pub n_xact_rollback: PgStat_Counter,
    pub n_blocks_fetched: PgStat_Counter,
    pub n_blocks_hit: PgStat_Counter,
    pub n_tuples_returned: PgStat_Counter,
    pub n_tuples_fetched: PgStat_Counter,
    pub n_tuples_inserted: PgStat_Counter,
    pub n_tuples_updated: PgStat_Counter,
    pub n_tuples_deleted: PgStat_Counter,
    pub last_autovac_time: TimestampTz,
    pub n_conflict_tablespace: PgStat_Counter,
    pub n_conflict_lock: PgStat_Counter,
    pub n_conflict_snapshot: PgStat_Counter,
    pub n_conflict_bufferpin: PgStat_Counter,
    pub n_conflict_startup_deadlock: PgStat_Counter,
    pub n_temp_files: PgStat_Counter,
    pub n_temp_bytes: PgStat_Counter,
    pub n_deadlocks: PgStat_Counter,
    pub n_checksum_failures: PgStat_Counter,
    pub last_checksum_failure: TimestampTz,
    pub n_block_read_time: PgStat_Counter,
    pub n_block_write_time: PgStat_Counter,
    pub stat_reset_timestamp: TimestampTz,
    pub stats_timestamp: TimestampTz,
    pub tables: *mut HTAB,
    pub functions: *mut HTAB,
}
impl Default for PgStat_StatDBEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_StatTabEntry {
    pub tableid: Oid,
    pub numscans: PgStat_Counter,
    pub tuples_returned: PgStat_Counter,
    pub tuples_fetched: PgStat_Counter,
    pub tuples_inserted: PgStat_Counter,
    pub tuples_updated: PgStat_Counter,
    pub tuples_deleted: PgStat_Counter,
    pub tuples_hot_updated: PgStat_Counter,
    pub n_live_tuples: PgStat_Counter,
    pub n_dead_tuples: PgStat_Counter,
    pub changes_since_analyze: PgStat_Counter,
    pub inserts_since_vacuum: PgStat_Counter,
    pub blocks_fetched: PgStat_Counter,
    pub blocks_hit: PgStat_Counter,
    pub vacuum_timestamp: TimestampTz,
    pub vacuum_count: PgStat_Counter,
    pub autovac_vacuum_timestamp: TimestampTz,
    pub autovac_vacuum_count: PgStat_Counter,
    pub analyze_timestamp: TimestampTz,
    pub analyze_count: PgStat_Counter,
    pub autovac_analyze_timestamp: TimestampTz,
    pub autovac_analyze_count: PgStat_Counter,
}
impl Default for PgStat_StatTabEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_StatFuncEntry {
    pub functionid: Oid,
    pub f_numcalls: PgStat_Counter,
    pub f_total_time: PgStat_Counter,
    pub f_self_time: PgStat_Counter,
}
impl Default for PgStat_StatFuncEntry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_ArchiverStats {
    pub archived_count: PgStat_Counter,
    pub last_archived_wal: [::std::os::raw::c_char; 41usize],
    pub last_archived_timestamp: TimestampTz,
    pub failed_count: PgStat_Counter,
    pub last_failed_wal: [::std::os::raw::c_char; 41usize],
    pub last_failed_timestamp: TimestampTz,
    pub stat_reset_timestamp: TimestampTz,
}
impl Default for PgStat_ArchiverStats {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_GlobalStats {
    pub stats_timestamp: TimestampTz,
    pub timed_checkpoints: PgStat_Counter,
    pub requested_checkpoints: PgStat_Counter,
    pub checkpoint_write_time: PgStat_Counter,
    pub checkpoint_sync_time: PgStat_Counter,
    pub buf_written_checkpoints: PgStat_Counter,
    pub buf_written_clean: PgStat_Counter,
    pub maxwritten_clean: PgStat_Counter,
    pub buf_written_backend: PgStat_Counter,
    pub buf_fsync_backend: PgStat_Counter,
    pub buf_alloc: PgStat_Counter,
    pub stat_reset_timestamp: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PgStat_SLRUStats {
    pub blocks_zeroed: PgStat_Counter,
    pub blocks_hit: PgStat_Counter,
    pub blocks_read: PgStat_Counter,
    pub blocks_written: PgStat_Counter,
    pub blocks_exists: PgStat_Counter,
    pub flush: PgStat_Counter,
    pub truncate: PgStat_Counter,
    pub stat_reset_timestamp: TimestampTz,
}
pub const BackendState_STATE_UNDEFINED: BackendState = 0;
pub const BackendState_STATE_IDLE: BackendState = 1;
pub const BackendState_STATE_RUNNING: BackendState = 2;
pub const BackendState_STATE_IDLEINTRANSACTION: BackendState = 3;
pub const BackendState_STATE_FASTPATH: BackendState = 4;
pub const BackendState_STATE_IDLEINTRANSACTION_ABORTED: BackendState = 5;
pub const BackendState_STATE_DISABLED: BackendState = 6;
pub type BackendState = ::std::os::raw::c_uint;
pub const WaitEventActivity_WAIT_EVENT_ARCHIVER_MAIN: WaitEventActivity = 83886080;
pub const WaitEventActivity_WAIT_EVENT_AUTOVACUUM_MAIN: WaitEventActivity = 83886081;
pub const WaitEventActivity_WAIT_EVENT_BGWRITER_HIBERNATE: WaitEventActivity = 83886082;
pub const WaitEventActivity_WAIT_EVENT_BGWRITER_MAIN: WaitEventActivity = 83886083;
pub const WaitEventActivity_WAIT_EVENT_CHECKPOINTER_MAIN: WaitEventActivity = 83886084;
pub const WaitEventActivity_WAIT_EVENT_LOGICAL_APPLY_MAIN: WaitEventActivity = 83886085;
pub const WaitEventActivity_WAIT_EVENT_LOGICAL_LAUNCHER_MAIN: WaitEventActivity = 83886086;
pub const WaitEventActivity_WAIT_EVENT_PGSTAT_MAIN: WaitEventActivity = 83886087;
pub const WaitEventActivity_WAIT_EVENT_RECOVERY_WAL_STREAM: WaitEventActivity = 83886088;
pub const WaitEventActivity_WAIT_EVENT_SYSLOGGER_MAIN: WaitEventActivity = 83886089;
pub const WaitEventActivity_WAIT_EVENT_WAL_RECEIVER_MAIN: WaitEventActivity = 83886090;
pub const WaitEventActivity_WAIT_EVENT_WAL_SENDER_MAIN: WaitEventActivity = 83886091;
pub const WaitEventActivity_WAIT_EVENT_WAL_WRITER_MAIN: WaitEventActivity = 83886092;
pub type WaitEventActivity = ::std::os::raw::c_uint;
pub const WaitEventClient_WAIT_EVENT_CLIENT_READ: WaitEventClient = 100663296;
pub const WaitEventClient_WAIT_EVENT_CLIENT_WRITE: WaitEventClient = 100663297;
pub const WaitEventClient_WAIT_EVENT_GSS_OPEN_SERVER: WaitEventClient = 100663298;
pub const WaitEventClient_WAIT_EVENT_LIBPQWALRECEIVER_CONNECT: WaitEventClient = 100663299;
pub const WaitEventClient_WAIT_EVENT_LIBPQWALRECEIVER_RECEIVE: WaitEventClient = 100663300;
pub const WaitEventClient_WAIT_EVENT_SSL_OPEN_SERVER: WaitEventClient = 100663301;
pub const WaitEventClient_WAIT_EVENT_WAL_RECEIVER_WAIT_START: WaitEventClient = 100663302;
pub const WaitEventClient_WAIT_EVENT_WAL_SENDER_WAIT_WAL: WaitEventClient = 100663303;
pub const WaitEventClient_WAIT_EVENT_WAL_SENDER_WRITE_DATA: WaitEventClient = 100663304;
pub type WaitEventClient = ::std::os::raw::c_uint;
pub const WaitEventIPC_WAIT_EVENT_BACKUP_WAIT_WAL_ARCHIVE: WaitEventIPC = 134217728;
pub const WaitEventIPC_WAIT_EVENT_BGWORKER_SHUTDOWN: WaitEventIPC = 134217729;
pub const WaitEventIPC_WAIT_EVENT_BGWORKER_STARTUP: WaitEventIPC = 134217730;
pub const WaitEventIPC_WAIT_EVENT_BTREE_PAGE: WaitEventIPC = 134217731;
pub const WaitEventIPC_WAIT_EVENT_CHECKPOINT_DONE: WaitEventIPC = 134217732;
pub const WaitEventIPC_WAIT_EVENT_CHECKPOINT_START: WaitEventIPC = 134217733;
pub const WaitEventIPC_WAIT_EVENT_EXECUTE_GATHER: WaitEventIPC = 134217734;
pub const WaitEventIPC_WAIT_EVENT_HASH_BATCH_ALLOCATE: WaitEventIPC = 134217735;
pub const WaitEventIPC_WAIT_EVENT_HASH_BATCH_ELECT: WaitEventIPC = 134217736;
pub const WaitEventIPC_WAIT_EVENT_HASH_BATCH_LOAD: WaitEventIPC = 134217737;
pub const WaitEventIPC_WAIT_EVENT_HASH_BUILD_ALLOCATE: WaitEventIPC = 134217738;
pub const WaitEventIPC_WAIT_EVENT_HASH_BUILD_ELECT: WaitEventIPC = 134217739;
pub const WaitEventIPC_WAIT_EVENT_HASH_BUILD_HASH_INNER: WaitEventIPC = 134217740;
pub const WaitEventIPC_WAIT_EVENT_HASH_BUILD_HASH_OUTER: WaitEventIPC = 134217741;
pub const WaitEventIPC_WAIT_EVENT_HASH_GROW_BATCHES_ALLOCATE: WaitEventIPC = 134217742;
pub const WaitEventIPC_WAIT_EVENT_HASH_GROW_BATCHES_DECIDE: WaitEventIPC = 134217743;
pub const WaitEventIPC_WAIT_EVENT_HASH_GROW_BATCHES_ELECT: WaitEventIPC = 134217744;
pub const WaitEventIPC_WAIT_EVENT_HASH_GROW_BATCHES_FINISH: WaitEventIPC = 134217745;
pub const WaitEventIPC_WAIT_EVENT_HASH_GROW_BATCHES_REPARTITION: WaitEventIPC = 134217746;
pub const WaitEventIPC_WAIT_EVENT_HASH_GROW_BUCKETS_ALLOCATE: WaitEventIPC = 134217747;
pub const WaitEventIPC_WAIT_EVENT_HASH_GROW_BUCKETS_ELECT: WaitEventIPC = 134217748;
pub const WaitEventIPC_WAIT_EVENT_HASH_GROW_BUCKETS_REINSERT: WaitEventIPC = 134217749;
pub const WaitEventIPC_WAIT_EVENT_LOGICAL_SYNC_DATA: WaitEventIPC = 134217750;
pub const WaitEventIPC_WAIT_EVENT_LOGICAL_SYNC_STATE_CHANGE: WaitEventIPC = 134217751;
pub const WaitEventIPC_WAIT_EVENT_MQ_INTERNAL: WaitEventIPC = 134217752;
pub const WaitEventIPC_WAIT_EVENT_MQ_PUT_MESSAGE: WaitEventIPC = 134217753;
pub const WaitEventIPC_WAIT_EVENT_MQ_RECEIVE: WaitEventIPC = 134217754;
pub const WaitEventIPC_WAIT_EVENT_MQ_SEND: WaitEventIPC = 134217755;
pub const WaitEventIPC_WAIT_EVENT_PARALLEL_BITMAP_SCAN: WaitEventIPC = 134217756;
pub const WaitEventIPC_WAIT_EVENT_PARALLEL_CREATE_INDEX_SCAN: WaitEventIPC = 134217757;
pub const WaitEventIPC_WAIT_EVENT_PARALLEL_FINISH: WaitEventIPC = 134217758;
pub const WaitEventIPC_WAIT_EVENT_PROCARRAY_GROUP_UPDATE: WaitEventIPC = 134217759;
pub const WaitEventIPC_WAIT_EVENT_PROC_SIGNAL_BARRIER: WaitEventIPC = 134217760;
pub const WaitEventIPC_WAIT_EVENT_PROMOTE: WaitEventIPC = 134217761;
pub const WaitEventIPC_WAIT_EVENT_RECOVERY_CONFLICT_SNAPSHOT: WaitEventIPC = 134217762;
pub const WaitEventIPC_WAIT_EVENT_RECOVERY_CONFLICT_TABLESPACE: WaitEventIPC = 134217763;
pub const WaitEventIPC_WAIT_EVENT_RECOVERY_PAUSE: WaitEventIPC = 134217764;
pub const WaitEventIPC_WAIT_EVENT_REPLICATION_ORIGIN_DROP: WaitEventIPC = 134217765;
pub const WaitEventIPC_WAIT_EVENT_REPLICATION_SLOT_DROP: WaitEventIPC = 134217766;
pub const WaitEventIPC_WAIT_EVENT_SAFE_SNAPSHOT: WaitEventIPC = 134217767;
pub const WaitEventIPC_WAIT_EVENT_SYNC_REP: WaitEventIPC = 134217768;
pub const WaitEventIPC_WAIT_EVENT_XACT_GROUP_UPDATE: WaitEventIPC = 134217769;
pub type WaitEventIPC = ::std::os::raw::c_uint;
pub const WaitEventTimeout_WAIT_EVENT_BASE_BACKUP_THROTTLE: WaitEventTimeout = 150994944;
pub const WaitEventTimeout_WAIT_EVENT_PG_SLEEP: WaitEventTimeout = 150994945;
pub const WaitEventTimeout_WAIT_EVENT_RECOVERY_APPLY_DELAY: WaitEventTimeout = 150994946;
pub const WaitEventTimeout_WAIT_EVENT_RECOVERY_RETRIEVE_RETRY_INTERVAL: WaitEventTimeout =
    150994947;
pub const WaitEventTimeout_WAIT_EVENT_VACUUM_DELAY: WaitEventTimeout = 150994948;
pub const WaitEventTimeout_WAIT_EVENT_REGISTER_SYNC_REQUEST: WaitEventTimeout = 150994949;
pub type WaitEventTimeout = ::std::os::raw::c_uint;
pub const WaitEventIO_WAIT_EVENT_BUFFILE_READ: WaitEventIO = 167772160;
pub const WaitEventIO_WAIT_EVENT_BUFFILE_WRITE: WaitEventIO = 167772161;
pub const WaitEventIO_WAIT_EVENT_CONTROL_FILE_READ: WaitEventIO = 167772162;
pub const WaitEventIO_WAIT_EVENT_CONTROL_FILE_SYNC: WaitEventIO = 167772163;
pub const WaitEventIO_WAIT_EVENT_CONTROL_FILE_SYNC_UPDATE: WaitEventIO = 167772164;
pub const WaitEventIO_WAIT_EVENT_CONTROL_FILE_WRITE: WaitEventIO = 167772165;
pub const WaitEventIO_WAIT_EVENT_CONTROL_FILE_WRITE_UPDATE: WaitEventIO = 167772166;
pub const WaitEventIO_WAIT_EVENT_COPY_FILE_READ: WaitEventIO = 167772167;
pub const WaitEventIO_WAIT_EVENT_COPY_FILE_WRITE: WaitEventIO = 167772168;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_EXTEND: WaitEventIO = 167772169;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_FLUSH: WaitEventIO = 167772170;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_IMMEDIATE_SYNC: WaitEventIO = 167772171;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_PREFETCH: WaitEventIO = 167772172;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_READ: WaitEventIO = 167772173;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_SYNC: WaitEventIO = 167772174;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_TRUNCATE: WaitEventIO = 167772175;
pub const WaitEventIO_WAIT_EVENT_DATA_FILE_WRITE: WaitEventIO = 167772176;
pub const WaitEventIO_WAIT_EVENT_DSM_FILL_ZERO_WRITE: WaitEventIO = 167772177;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_ADDTODATADIR_READ: WaitEventIO = 167772178;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_ADDTODATADIR_SYNC: WaitEventIO = 167772179;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_ADDTODATADIR_WRITE: WaitEventIO = 167772180;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_CREATE_READ: WaitEventIO = 167772181;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_CREATE_SYNC: WaitEventIO = 167772182;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_CREATE_WRITE: WaitEventIO = 167772183;
pub const WaitEventIO_WAIT_EVENT_LOCK_FILE_RECHECKDATADIR_READ: WaitEventIO = 167772184;
pub const WaitEventIO_WAIT_EVENT_LOGICAL_REWRITE_CHECKPOINT_SYNC: WaitEventIO = 167772185;
pub const WaitEventIO_WAIT_EVENT_LOGICAL_REWRITE_MAPPING_SYNC: WaitEventIO = 167772186;
pub const WaitEventIO_WAIT_EVENT_LOGICAL_REWRITE_MAPPING_WRITE: WaitEventIO = 167772187;
pub const WaitEventIO_WAIT_EVENT_LOGICAL_REWRITE_SYNC: WaitEventIO = 167772188;
pub const WaitEventIO_WAIT_EVENT_LOGICAL_REWRITE_TRUNCATE: WaitEventIO = 167772189;
pub const WaitEventIO_WAIT_EVENT_LOGICAL_REWRITE_WRITE: WaitEventIO = 167772190;
pub const WaitEventIO_WAIT_EVENT_RELATION_MAP_READ: WaitEventIO = 167772191;
pub const WaitEventIO_WAIT_EVENT_RELATION_MAP_SYNC: WaitEventIO = 167772192;
pub const WaitEventIO_WAIT_EVENT_RELATION_MAP_WRITE: WaitEventIO = 167772193;
pub const WaitEventIO_WAIT_EVENT_REORDER_BUFFER_READ: WaitEventIO = 167772194;
pub const WaitEventIO_WAIT_EVENT_REORDER_BUFFER_WRITE: WaitEventIO = 167772195;
pub const WaitEventIO_WAIT_EVENT_REORDER_LOGICAL_MAPPING_READ: WaitEventIO = 167772196;
pub const WaitEventIO_WAIT_EVENT_REPLICATION_SLOT_READ: WaitEventIO = 167772197;
pub const WaitEventIO_WAIT_EVENT_REPLICATION_SLOT_RESTORE_SYNC: WaitEventIO = 167772198;
pub const WaitEventIO_WAIT_EVENT_REPLICATION_SLOT_SYNC: WaitEventIO = 167772199;
pub const WaitEventIO_WAIT_EVENT_REPLICATION_SLOT_WRITE: WaitEventIO = 167772200;
pub const WaitEventIO_WAIT_EVENT_SLRU_FLUSH_SYNC: WaitEventIO = 167772201;
pub const WaitEventIO_WAIT_EVENT_SLRU_READ: WaitEventIO = 167772202;
pub const WaitEventIO_WAIT_EVENT_SLRU_SYNC: WaitEventIO = 167772203;
pub const WaitEventIO_WAIT_EVENT_SLRU_WRITE: WaitEventIO = 167772204;
pub const WaitEventIO_WAIT_EVENT_SNAPBUILD_READ: WaitEventIO = 167772205;
pub const WaitEventIO_WAIT_EVENT_SNAPBUILD_SYNC: WaitEventIO = 167772206;
pub const WaitEventIO_WAIT_EVENT_SNAPBUILD_WRITE: WaitEventIO = 167772207;
pub const WaitEventIO_WAIT_EVENT_TIMELINE_HISTORY_FILE_SYNC: WaitEventIO = 167772208;
pub const WaitEventIO_WAIT_EVENT_TIMELINE_HISTORY_FILE_WRITE: WaitEventIO = 167772209;
pub const WaitEventIO_WAIT_EVENT_TIMELINE_HISTORY_READ: WaitEventIO = 167772210;
pub const WaitEventIO_WAIT_EVENT_TIMELINE_HISTORY_SYNC: WaitEventIO = 167772211;
pub const WaitEventIO_WAIT_EVENT_TIMELINE_HISTORY_WRITE: WaitEventIO = 167772212;
pub const WaitEventIO_WAIT_EVENT_TWOPHASE_FILE_READ: WaitEventIO = 167772213;
pub const WaitEventIO_WAIT_EVENT_TWOPHASE_FILE_SYNC: WaitEventIO = 167772214;
pub const WaitEventIO_WAIT_EVENT_TWOPHASE_FILE_WRITE: WaitEventIO = 167772215;
pub const WaitEventIO_WAIT_EVENT_WALSENDER_TIMELINE_HISTORY_READ: WaitEventIO = 167772216;
pub const WaitEventIO_WAIT_EVENT_WAL_BOOTSTRAP_SYNC: WaitEventIO = 167772217;
pub const WaitEventIO_WAIT_EVENT_WAL_BOOTSTRAP_WRITE: WaitEventIO = 167772218;
pub const WaitEventIO_WAIT_EVENT_WAL_COPY_READ: WaitEventIO = 167772219;
pub const WaitEventIO_WAIT_EVENT_WAL_COPY_SYNC: WaitEventIO = 167772220;
pub const WaitEventIO_WAIT_EVENT_WAL_COPY_WRITE: WaitEventIO = 167772221;
pub const WaitEventIO_WAIT_EVENT_WAL_INIT_SYNC: WaitEventIO = 167772222;
pub const WaitEventIO_WAIT_EVENT_WAL_INIT_WRITE: WaitEventIO = 167772223;
pub const WaitEventIO_WAIT_EVENT_WAL_READ: WaitEventIO = 167772224;
pub const WaitEventIO_WAIT_EVENT_WAL_SYNC: WaitEventIO = 167772225;
pub const WaitEventIO_WAIT_EVENT_WAL_SYNC_METHOD_ASSIGN: WaitEventIO = 167772226;
pub const WaitEventIO_WAIT_EVENT_WAL_WRITE: WaitEventIO = 167772227;
pub type WaitEventIO = ::std::os::raw::c_uint;
pub const ProgressCommandType_PROGRESS_COMMAND_INVALID: ProgressCommandType = 0;
pub const ProgressCommandType_PROGRESS_COMMAND_VACUUM: ProgressCommandType = 1;
pub const ProgressCommandType_PROGRESS_COMMAND_ANALYZE: ProgressCommandType = 2;
pub const ProgressCommandType_PROGRESS_COMMAND_CLUSTER: ProgressCommandType = 3;
pub const ProgressCommandType_PROGRESS_COMMAND_CREATE_INDEX: ProgressCommandType = 4;
pub const ProgressCommandType_PROGRESS_COMMAND_BASEBACKUP: ProgressCommandType = 5;
pub type ProgressCommandType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgBackendSSLStatus {
    pub ssl_bits: ::std::os::raw::c_int,
    pub ssl_compression: bool,
    pub ssl_version: [::std::os::raw::c_char; 64usize],
    pub ssl_cipher: [::std::os::raw::c_char; 64usize],
    pub ssl_client_dn: [::std::os::raw::c_char; 64usize],
    pub ssl_client_serial: [::std::os::raw::c_char; 64usize],
    pub ssl_issuer_dn: [::std::os::raw::c_char; 64usize],
}
impl Default for PgBackendSSLStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgBackendGSSStatus {
    pub gss_princ: [::std::os::raw::c_char; 64usize],
    pub gss_auth: bool,
    pub gss_enc: bool,
}
impl Default for PgBackendGSSStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgBackendStatus {
    pub st_changecount: ::std::os::raw::c_int,
    pub st_procpid: ::std::os::raw::c_int,
    pub st_backendType: BackendType,
    pub st_proc_start_timestamp: TimestampTz,
    pub st_xact_start_timestamp: TimestampTz,
    pub st_activity_start_timestamp: TimestampTz,
    pub st_state_start_timestamp: TimestampTz,
    pub st_databaseid: Oid,
    pub st_userid: Oid,
    pub st_clientaddr: SockAddr,
    pub st_clienthostname: *mut ::std::os::raw::c_char,
    pub st_ssl: bool,
    pub st_sslstatus: *mut PgBackendSSLStatus,
    pub st_gss: bool,
    pub st_gssstatus: *mut PgBackendGSSStatus,
    pub st_state: BackendState,
    pub st_appname: *mut ::std::os::raw::c_char,
    pub st_activity_raw: *mut ::std::os::raw::c_char,
    pub st_progress_command: ProgressCommandType,
    pub st_progress_command_target: Oid,
    pub st_progress_param: [int64; 20usize],
}
impl Default for PgBackendStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LocalPgBackendStatus {
    pub backendStatus: PgBackendStatus,
    pub backend_xid: TransactionId,
    pub backend_xmin: TransactionId,
}
impl Default for LocalPgBackendStatus {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PgStat_FunctionCallUsage {
    pub fs: *mut PgStat_FunctionCounts,
    pub save_f_total_time: instr_time,
    pub save_total: instr_time,
    pub f_start: instr_time,
}
impl Default for PgStat_FunctionCallUsage {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut pgstat_track_activities: bool;
}
extern "C" {
    pub static mut pgstat_track_counts: bool;
}
extern "C" {
    pub static mut pgstat_track_functions: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut pgstat_track_activity_query_size: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut pgstat_stat_directory: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut pgstat_stat_tmpname: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut pgstat_stat_filename: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut BgWriterStats: PgStat_MsgBgWriter;
}
extern "C" {
    pub static mut pgStatBlockReadTime: PgStat_Counter;
}
extern "C" {
    pub static mut pgStatBlockWriteTime: PgStat_Counter;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BackendStatusShmemSize() -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CreateSharedBackendStatus();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_init();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_start() -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_reset_all();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn allow_immediate_pgstat_restart();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_ping();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_report_stat(force: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_vacuum_stat();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_drop_database(databaseid: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_clear_snapshot();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_reset_counters();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_reset_shared_counters(arg1: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_reset_single_counter(objectid: Oid, type_: PgStat_Single_Reset_Type);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_reset_slru_counter(arg1: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_report_autovac(dboid: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_report_vacuum(
        tableoid: Oid,
        shared: bool,
        livetuples: PgStat_Counter,
        deadtuples: PgStat_Counter,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_report_analyze(
        rel: Relation,
        livetuples: PgStat_Counter,
        deadtuples: PgStat_Counter,
        resetcounter: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_report_recovery_conflict(reason: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_report_deadlock();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_report_checksum_failures_in_db(dboid: Oid, failurecount: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_report_checksum_failure();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_initialize();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_bestart();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_report_activity(state: BackendState, cmd_str: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_report_tempfile(filesize: usize);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_report_appname(appname: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_report_xact_timestamp(tstamp: TimestampTz);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_get_wait_event(wait_event_info: uint32) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_get_wait_event_type(wait_event_info: uint32) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_get_backend_current_activity(
        pid: ::std::os::raw::c_int,
        checkUser: bool,
    ) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_get_crashed_backend_activity(
        pid: ::std::os::raw::c_int,
        buffer: *mut ::std::os::raw::c_char,
        buflen: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_progress_start_command(cmdtype: ProgressCommandType, relid: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_progress_update_param(index: ::std::os::raw::c_int, val: int64);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_progress_update_multi_param(
        nparam: ::std::os::raw::c_int,
        index: *const ::std::os::raw::c_int,
        val: *const int64,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_progress_end_command();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn find_tabstat_entry(rel_id: Oid) -> *mut PgStat_TableStatus;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn find_funcstat_entry(func_id: Oid) -> *mut PgStat_BackendFunctionEntry;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_initstats(rel: Relation);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_clip_activity(
        raw_activity: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_count_heap_insert(rel: Relation, n: PgStat_Counter);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_count_heap_update(rel: Relation, hot: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_count_heap_delete(rel: Relation);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_count_truncate(rel: Relation);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_update_heap_dead_tuples(rel: Relation, delta: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_init_function_usage(
        fcinfo: *mut FunctionCallInfoBaseData,
        fcu: *mut PgStat_FunctionCallUsage,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_end_function_usage(fcu: *mut PgStat_FunctionCallUsage, finalize: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AtEOXact_PgStat(isCommit: bool, parallel: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AtEOSubXact_PgStat(isCommit: bool, nestDepth: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AtPrepare_PgStat();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PostPrepare_PgStat();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_twophase_postcommit(
        xid: TransactionId,
        info: uint16,
        recdata: *mut ::std::os::raw::c_void,
        len: uint32,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_twophase_postabort(
        xid: TransactionId,
        info: uint16,
        recdata: *mut ::std::os::raw::c_void,
        len: uint32,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_send_archiver(xlog: *const ::std::os::raw::c_char, failed: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_send_bgwriter();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_fetch_stat_dbentry(dbid: Oid) -> *mut PgStat_StatDBEntry;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_fetch_stat_tabentry(relid: Oid) -> *mut PgStat_StatTabEntry;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_fetch_stat_beentry(beid: ::std::os::raw::c_int) -> *mut PgBackendStatus;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_fetch_stat_local_beentry(
        beid: ::std::os::raw::c_int,
    ) -> *mut LocalPgBackendStatus;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_fetch_stat_funcentry(funcid: Oid) -> *mut PgStat_StatFuncEntry;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_fetch_stat_numbackends() -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_fetch_stat_archiver() -> *mut PgStat_ArchiverStats;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_fetch_global() -> *mut PgStat_GlobalStats;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_fetch_slru() -> *mut PgStat_SLRUStats;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_count_slru_page_zeroed(slru_idx: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_count_slru_page_hit(slru_idx: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_count_slru_page_read(slru_idx: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_count_slru_page_written(slru_idx: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_count_slru_page_exists(slru_idx: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_count_slru_flush(slru_idx: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_count_slru_truncate(slru_idx: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_slru_name(slru_idx: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn pgstat_slru_index(name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScanKeyData {
    pub sk_flags: ::std::os::raw::c_int,
    pub sk_attno: AttrNumber,
    pub sk_strategy: StrategyNumber,
    pub sk_subtype: Oid,
    pub sk_collation: Oid,
    pub sk_func: FmgrInfo,
    pub sk_argument: Datum,
}
impl Default for ScanKeyData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ScanKey = *mut ScanKeyData;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ScanKeyInit(
        entry: ScanKey,
        attributeNumber: AttrNumber,
        strategy: StrategyNumber,
        procedure: RegProcedure,
        argument: Datum,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ScanKeyEntryInitialize(
        entry: ScanKey,
        flags: ::std::os::raw::c_int,
        attributeNumber: AttrNumber,
        strategy: StrategyNumber,
        subtype: Oid,
        collation: Oid,
        procedure: RegProcedure,
        argument: Datum,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ScanKeyEntryInitializeWithInfo(
        entry: ScanKey,
        flags: ::std::os::raw::c_int,
        attributeNumber: AttrNumber,
        strategy: StrategyNumber,
        subtype: Oid,
        collation: Oid,
        finfo: *mut FmgrInfo,
        argument: Datum,
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexBuildResult {
    pub heap_tuples: f64,
    pub index_tuples: f64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexVacuumInfo {
    pub index: Relation,
    pub analyze_only: bool,
    pub report_progress: bool,
    pub estimated_count: bool,
    pub message_level: ::std::os::raw::c_int,
    pub num_heap_tuples: f64,
    pub strategy: BufferAccessStrategy,
}
impl Default for IndexVacuumInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexBulkDeleteResult {
    pub num_pages: BlockNumber,
    pub pages_removed: BlockNumber,
    pub estimated_count: bool,
    pub num_index_tuples: f64,
    pub tuples_removed: f64,
    pub pages_deleted: BlockNumber,
    pub pages_free: BlockNumber,
}
pub type IndexBulkDeleteCallback = ::std::option::Option<
    unsafe extern "C" fn(itemptr: ItemPointer, state: *mut ::std::os::raw::c_void) -> bool,
>;
pub type IndexScanDesc = *mut IndexScanDescData;
pub type SysScanDesc = *mut SysScanDescData;
pub type ParallelIndexScanDesc = *mut ParallelIndexScanDescData;
pub const IndexUniqueCheck_UNIQUE_CHECK_NO: IndexUniqueCheck = 0;
pub const IndexUniqueCheck_UNIQUE_CHECK_YES: IndexUniqueCheck = 1;
pub const IndexUniqueCheck_UNIQUE_CHECK_PARTIAL: IndexUniqueCheck = 2;
pub const IndexUniqueCheck_UNIQUE_CHECK_EXISTING: IndexUniqueCheck = 3;
pub type IndexUniqueCheck = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct IndexOrderByDistance {
    pub value: f64,
    pub isnull: bool,
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_open(relationId: Oid, lockmode: LOCKMODE) -> Relation;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_close(relation: Relation, lockmode: LOCKMODE);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_insert(
        indexRelation: Relation,
        values: *mut Datum,
        isnull: *mut bool,
        heap_t_ctid: ItemPointer,
        heapRelation: Relation,
        checkUnique: IndexUniqueCheck,
        indexInfo: *mut IndexInfo,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_beginscan(
        heapRelation: Relation,
        indexRelation: Relation,
        snapshot: Snapshot,
        nkeys: ::std::os::raw::c_int,
        norderbys: ::std::os::raw::c_int,
    ) -> IndexScanDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_beginscan_bitmap(
        indexRelation: Relation,
        snapshot: Snapshot,
        nkeys: ::std::os::raw::c_int,
    ) -> IndexScanDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_rescan(
        scan: IndexScanDesc,
        keys: ScanKey,
        nkeys: ::std::os::raw::c_int,
        orderbys: ScanKey,
        norderbys: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_endscan(scan: IndexScanDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_markpos(scan: IndexScanDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_restrpos(scan: IndexScanDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_parallelscan_estimate(indexrel: Relation, snapshot: Snapshot) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_parallelscan_initialize(
        heaprel: Relation,
        indexrel: Relation,
        snapshot: Snapshot,
        target: ParallelIndexScanDesc,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_parallelrescan(scan: IndexScanDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_beginscan_parallel(
        heaprel: Relation,
        indexrel: Relation,
        nkeys: ::std::os::raw::c_int,
        norderbys: ::std::os::raw::c_int,
        pscan: ParallelIndexScanDesc,
    ) -> IndexScanDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_getnext_tid(scan: IndexScanDesc, direction: ScanDirection) -> ItemPointer;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_fetch_heap(scan: IndexScanDesc, slot: *mut TupleTableSlot) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_getnext_slot(
        scan: IndexScanDesc,
        direction: ScanDirection,
        slot: *mut TupleTableSlot,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_getbitmap(scan: IndexScanDesc, bitmap: *mut TIDBitmap) -> int64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_bulk_delete(
        info: *mut IndexVacuumInfo,
        stats: *mut IndexBulkDeleteResult,
        callback: IndexBulkDeleteCallback,
        callback_state: *mut ::std::os::raw::c_void,
    ) -> *mut IndexBulkDeleteResult;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_vacuum_cleanup(
        info: *mut IndexVacuumInfo,
        stats: *mut IndexBulkDeleteResult,
    ) -> *mut IndexBulkDeleteResult;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_can_return(indexRelation: Relation, attno: ::std::os::raw::c_int) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_getprocid(irel: Relation, attnum: AttrNumber, procnum: uint16) -> RegProcedure;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_getprocinfo(irel: Relation, attnum: AttrNumber, procnum: uint16) -> *mut FmgrInfo;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_store_float8_orderby_distances(
        scan: IndexScanDesc,
        orderByTypes: *mut Oid,
        distances: *mut IndexOrderByDistance,
        recheckOrderBy: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_opclass_options(
        relation: Relation,
        attnum: AttrNumber,
        attoptions: Datum,
        validate: bool,
    ) -> *mut bytea;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationGetIndexScan(
        indexRelation: Relation,
        nkeys: ::std::os::raw::c_int,
        norderbys: ::std::os::raw::c_int,
    ) -> IndexScanDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn IndexScanEnd(scan: IndexScanDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BuildIndexValueDescription(
        indexRelation: Relation,
        values: *mut Datum,
        isnull: *mut bool,
    ) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_compute_xid_horizon_for_tuples(
        irel: Relation,
        hrel: Relation,
        ibuf: Buffer,
        itemnos: *mut OffsetNumber,
        nitems: ::std::os::raw::c_int,
    ) -> TransactionId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn systable_beginscan(
        heapRelation: Relation,
        indexId: Oid,
        indexOK: bool,
        snapshot: Snapshot,
        nkeys: ::std::os::raw::c_int,
        key: ScanKey,
    ) -> SysScanDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn systable_getnext(sysscan: SysScanDesc) -> HeapTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn systable_recheck_tuple(sysscan: SysScanDesc, tup: HeapTuple) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn systable_endscan(sysscan: SysScanDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn systable_beginscan_ordered(
        heapRelation: Relation,
        indexRelation: Relation,
        snapshot: Snapshot,
        nkeys: ::std::os::raw::c_int,
        key: ScanKey,
    ) -> SysScanDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn systable_getnext_ordered(sysscan: SysScanDesc, direction: ScanDirection) -> HeapTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn systable_endscan_ordered(sysscan: SysScanDesc);
}
pub const IndexAMProperty_AMPROP_UNKNOWN: IndexAMProperty = 0;
pub const IndexAMProperty_AMPROP_ASC: IndexAMProperty = 1;
pub const IndexAMProperty_AMPROP_DESC: IndexAMProperty = 2;
pub const IndexAMProperty_AMPROP_NULLS_FIRST: IndexAMProperty = 3;
pub const IndexAMProperty_AMPROP_NULLS_LAST: IndexAMProperty = 4;
pub const IndexAMProperty_AMPROP_ORDERABLE: IndexAMProperty = 5;
pub const IndexAMProperty_AMPROP_DISTANCE_ORDERABLE: IndexAMProperty = 6;
pub const IndexAMProperty_AMPROP_RETURNABLE: IndexAMProperty = 7;
pub const IndexAMProperty_AMPROP_SEARCH_ARRAY: IndexAMProperty = 8;
pub const IndexAMProperty_AMPROP_SEARCH_NULLS: IndexAMProperty = 9;
pub const IndexAMProperty_AMPROP_CLUSTERABLE: IndexAMProperty = 10;
pub const IndexAMProperty_AMPROP_INDEX_SCAN: IndexAMProperty = 11;
pub const IndexAMProperty_AMPROP_BITMAP_SCAN: IndexAMProperty = 12;
pub const IndexAMProperty_AMPROP_BACKWARD_SCAN: IndexAMProperty = 13;
pub const IndexAMProperty_AMPROP_CAN_ORDER: IndexAMProperty = 14;
pub const IndexAMProperty_AMPROP_CAN_UNIQUE: IndexAMProperty = 15;
pub const IndexAMProperty_AMPROP_CAN_MULTI_COL: IndexAMProperty = 16;
pub const IndexAMProperty_AMPROP_CAN_EXCLUDE: IndexAMProperty = 17;
pub const IndexAMProperty_AMPROP_CAN_INCLUDE: IndexAMProperty = 18;
pub type IndexAMProperty = ::std::os::raw::c_uint;
pub type ambuild_function = ::std::option::Option<
    unsafe extern "C" fn(
        heapRelation: Relation,
        indexRelation: Relation,
        indexInfo: *mut IndexInfo,
    ) -> *mut IndexBuildResult,
>;
pub type ambuildempty_function =
    ::std::option::Option<unsafe extern "C" fn(indexRelation: Relation)>;
pub type aminsert_function = ::std::option::Option<
    unsafe extern "C" fn(
        indexRelation: Relation,
        values: *mut Datum,
        isnull: *mut bool,
        heap_tid: ItemPointer,
        heapRelation: Relation,
        checkUnique: IndexUniqueCheck,
        indexInfo: *mut IndexInfo,
    ) -> bool,
>;
pub type ambulkdelete_function = ::std::option::Option<
    unsafe extern "C" fn(
        info: *mut IndexVacuumInfo,
        stats: *mut IndexBulkDeleteResult,
        callback: IndexBulkDeleteCallback,
        callback_state: *mut ::std::os::raw::c_void,
    ) -> *mut IndexBulkDeleteResult,
>;
pub type amvacuumcleanup_function = ::std::option::Option<
    unsafe extern "C" fn(
        info: *mut IndexVacuumInfo,
        stats: *mut IndexBulkDeleteResult,
    ) -> *mut IndexBulkDeleteResult,
>;
pub type amcanreturn_function = ::std::option::Option<
    unsafe extern "C" fn(indexRelation: Relation, attno: ::std::os::raw::c_int) -> bool,
>;
pub type amcostestimate_function = ::std::option::Option<
    unsafe extern "C" fn(
        root: *mut PlannerInfo,
        path: *mut IndexPath,
        loop_count: f64,
        indexStartupCost: *mut Cost,
        indexTotalCost: *mut Cost,
        indexSelectivity: *mut Selectivity,
        indexCorrelation: *mut f64,
        indexPages: *mut f64,
    ),
>;
pub type amoptions_function =
    ::std::option::Option<unsafe extern "C" fn(reloptions: Datum, validate: bool) -> *mut bytea>;
pub type amproperty_function = ::std::option::Option<
    unsafe extern "C" fn(
        index_oid: Oid,
        attno: ::std::os::raw::c_int,
        prop: IndexAMProperty,
        propname: *const ::std::os::raw::c_char,
        res: *mut bool,
        isnull: *mut bool,
    ) -> bool,
>;
pub type ambuildphasename_function =
    ::std::option::Option<unsafe extern "C" fn(phasenum: int64) -> *mut ::std::os::raw::c_char>;
pub type amvalidate_function = ::std::option::Option<unsafe extern "C" fn(opclassoid: Oid) -> bool>;
pub type ambeginscan_function = ::std::option::Option<
    unsafe extern "C" fn(
        indexRelation: Relation,
        nkeys: ::std::os::raw::c_int,
        norderbys: ::std::os::raw::c_int,
    ) -> IndexScanDesc,
>;
pub type amrescan_function = ::std::option::Option<
    unsafe extern "C" fn(
        scan: IndexScanDesc,
        keys: ScanKey,
        nkeys: ::std::os::raw::c_int,
        orderbys: ScanKey,
        norderbys: ::std::os::raw::c_int,
    ),
>;
pub type amgettuple_function = ::std::option::Option<
    unsafe extern "C" fn(scan: IndexScanDesc, direction: ScanDirection) -> bool,
>;
pub type amgetbitmap_function =
    ::std::option::Option<unsafe extern "C" fn(scan: IndexScanDesc, tbm: *mut TIDBitmap) -> int64>;
pub type amendscan_function = ::std::option::Option<unsafe extern "C" fn(scan: IndexScanDesc)>;
pub type ammarkpos_function = ::std::option::Option<unsafe extern "C" fn(scan: IndexScanDesc)>;
pub type amrestrpos_function = ::std::option::Option<unsafe extern "C" fn(scan: IndexScanDesc)>;
pub type amestimateparallelscan_function = ::std::option::Option<unsafe extern "C" fn() -> Size>;
pub type aminitparallelscan_function =
    ::std::option::Option<unsafe extern "C" fn(target: *mut ::std::os::raw::c_void)>;
pub type amparallelrescan_function =
    ::std::option::Option<unsafe extern "C" fn(scan: IndexScanDesc)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexAmRoutine {
    pub type_: NodeTag,
    pub amstrategies: uint16,
    pub amsupport: uint16,
    pub amoptsprocnum: uint16,
    pub amcanorder: bool,
    pub amcanorderbyop: bool,
    pub amcanbackward: bool,
    pub amcanunique: bool,
    pub amcanmulticol: bool,
    pub amoptionalkey: bool,
    pub amsearcharray: bool,
    pub amsearchnulls: bool,
    pub amstorage: bool,
    pub amclusterable: bool,
    pub ampredlocks: bool,
    pub amcanparallel: bool,
    pub amcaninclude: bool,
    pub amusemaintenanceworkmem: bool,
    pub amparallelvacuumoptions: uint8,
    pub amkeytype: Oid,
    pub ambuild: ambuild_function,
    pub ambuildempty: ambuildempty_function,
    pub aminsert: aminsert_function,
    pub ambulkdelete: ambulkdelete_function,
    pub amvacuumcleanup: amvacuumcleanup_function,
    pub amcanreturn: amcanreturn_function,
    pub amcostestimate: amcostestimate_function,
    pub amoptions: amoptions_function,
    pub amproperty: amproperty_function,
    pub ambuildphasename: ambuildphasename_function,
    pub amvalidate: amvalidate_function,
    pub ambeginscan: ambeginscan_function,
    pub amrescan: amrescan_function,
    pub amgettuple: amgettuple_function,
    pub amgetbitmap: amgetbitmap_function,
    pub amendscan: amendscan_function,
    pub ammarkpos: ammarkpos_function,
    pub amrestrpos: amrestrpos_function,
    pub amestimateparallelscan: amestimateparallelscan_function,
    pub aminitparallelscan: aminitparallelscan_function,
    pub amparallelrescan: amparallelrescan_function,
}
impl Default for IndexAmRoutine {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetIndexAmRoutine(amhandler: Oid) -> *mut IndexAmRoutine;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetIndexAmRoutineByAmId(amoid: Oid, noerror: bool) -> *mut IndexAmRoutine;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogBeginInsert();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogSetRecordFlags(flags: uint8);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogInsert(rmid: RmgrId, info: uint8) -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogEnsureRecordSpace(
        max_block_id: ::std::os::raw::c_int,
        ndatas: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogRegisterData(data: *mut ::std::os::raw::c_char, len: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogRegisterBuffer(block_id: uint8, buffer: Buffer, flags: uint8);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogRegisterBlock(
        block_id: uint8,
        rnode: *mut RelFileNode,
        forknum: ForkNumber,
        blknum: BlockNumber,
        page: *mut ::std::os::raw::c_char,
        flags: uint8,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogRegisterBufData(
        block_id: uint8,
        data: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogResetInsertion();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogCheckBufferNeedsBackup(buffer: Buffer) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn log_newpage(
        rnode: *mut RelFileNode,
        forkNum: ForkNumber,
        blk: BlockNumber,
        page: *mut ::std::os::raw::c_char,
        page_std: bool,
    ) -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn log_newpage_buffer(buffer: Buffer, page_std: bool) -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn log_newpage_range(
        rel: Relation,
        forkNum: ForkNumber,
        startblk: BlockNumber,
        endblk: BlockNumber,
        page_std: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogSaveBufferForHint(buffer: Buffer, buffer_std: bool) -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitXLogInsert();
}
extern "C" {
    pub static mut sync_method: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut ThisTimeLineID: TimeLineID;
}
extern "C" {
    pub static mut InRecovery: bool;
}
pub const HotStandbyState_STANDBY_DISABLED: HotStandbyState = 0;
pub const HotStandbyState_STANDBY_INITIALIZED: HotStandbyState = 1;
pub const HotStandbyState_STANDBY_SNAPSHOT_PENDING: HotStandbyState = 2;
pub const HotStandbyState_STANDBY_SNAPSHOT_READY: HotStandbyState = 3;
pub type HotStandbyState = ::std::os::raw::c_uint;
extern "C" {
    pub static mut standbyState: HotStandbyState;
}
pub const RecoveryTargetType_RECOVERY_TARGET_UNSET: RecoveryTargetType = 0;
pub const RecoveryTargetType_RECOVERY_TARGET_XID: RecoveryTargetType = 1;
pub const RecoveryTargetType_RECOVERY_TARGET_TIME: RecoveryTargetType = 2;
pub const RecoveryTargetType_RECOVERY_TARGET_NAME: RecoveryTargetType = 3;
pub const RecoveryTargetType_RECOVERY_TARGET_LSN: RecoveryTargetType = 4;
pub const RecoveryTargetType_RECOVERY_TARGET_IMMEDIATE: RecoveryTargetType = 5;
pub type RecoveryTargetType = ::std::os::raw::c_uint;
pub const RecoveryTargetTimeLineGoal_RECOVERY_TARGET_TIMELINE_CONTROLFILE:
    RecoveryTargetTimeLineGoal = 0;
pub const RecoveryTargetTimeLineGoal_RECOVERY_TARGET_TIMELINE_LATEST: RecoveryTargetTimeLineGoal =
    1;
pub const RecoveryTargetTimeLineGoal_RECOVERY_TARGET_TIMELINE_NUMERIC: RecoveryTargetTimeLineGoal =
    2;
pub type RecoveryTargetTimeLineGoal = ::std::os::raw::c_uint;
extern "C" {
    pub static mut ProcLastRecPtr: XLogRecPtr;
}
extern "C" {
    pub static mut XactLastRecEnd: XLogRecPtr;
}
extern "C" {
    pub static mut XactLastCommitEnd: XLogRecPtr;
}
extern "C" {
    pub static mut reachedConsistency: bool;
}
extern "C" {
    pub static mut wal_segment_size: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut min_wal_size_mb: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut max_wal_size_mb: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut wal_keep_size_mb: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut max_slot_wal_keep_size_mb: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut XLOGbuffers: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut XLogArchiveTimeout: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut wal_retrieve_retry_interval: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut XLogArchiveCommand: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut EnableHotStandby: bool;
}
extern "C" {
    pub static mut fullPageWrites: bool;
}
extern "C" {
    pub static mut wal_log_hints: bool;
}
extern "C" {
    pub static mut wal_compression: bool;
}
extern "C" {
    pub static mut wal_init_zero: bool;
}
extern "C" {
    pub static mut wal_recycle: bool;
}
extern "C" {
    pub static mut wal_consistency_checking: *mut bool;
}
extern "C" {
    pub static mut wal_consistency_checking_string: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut log_checkpoints: bool;
}
extern "C" {
    pub static mut recoveryRestoreCommand: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut recoveryEndCommand: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut archiveCleanupCommand: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut recoveryTargetInclusive: bool;
}
extern "C" {
    pub static mut recoveryTargetAction: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut recovery_min_apply_delay: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut PrimaryConnInfo: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut PrimarySlotName: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut wal_receiver_create_temp_slot: bool;
}
extern "C" {
    pub static mut recoveryTargetXid: TransactionId;
}
extern "C" {
    pub static mut recovery_target_time_string: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut recoveryTargetName: *const ::std::os::raw::c_char;
}
extern "C" {
    pub static mut recoveryTargetLSN: XLogRecPtr;
}
extern "C" {
    pub static mut recoveryTarget: RecoveryTargetType;
}
extern "C" {
    pub static mut PromoteTriggerFile: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut recoveryTargetTimeLineGoal: RecoveryTargetTimeLineGoal;
}
extern "C" {
    pub static mut recoveryTargetTLIRequested: TimeLineID;
}
extern "C" {
    pub static mut recoveryTargetTLI: TimeLineID;
}
extern "C" {
    pub static mut CheckPointSegments: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut StandbyModeRequested: bool;
}
extern "C" {
    pub static mut StandbyMode: bool;
}
pub const ArchiveMode_ARCHIVE_MODE_OFF: ArchiveMode = 0;
pub const ArchiveMode_ARCHIVE_MODE_ON: ArchiveMode = 1;
pub const ArchiveMode_ARCHIVE_MODE_ALWAYS: ArchiveMode = 2;
pub type ArchiveMode = ::std::os::raw::c_uint;
extern "C" {
    pub static mut XLogArchiveMode: ::std::os::raw::c_int;
}
pub const WalLevel_WAL_LEVEL_MINIMAL: WalLevel = 0;
pub const WalLevel_WAL_LEVEL_REPLICA: WalLevel = 1;
pub const WalLevel_WAL_LEVEL_LOGICAL: WalLevel = 2;
pub type WalLevel = ::std::os::raw::c_uint;
pub const RecoveryState_RECOVERY_STATE_CRASH: RecoveryState = 0;
pub const RecoveryState_RECOVERY_STATE_ARCHIVE: RecoveryState = 1;
pub const RecoveryState_RECOVERY_STATE_DONE: RecoveryState = 2;
pub type RecoveryState = ::std::os::raw::c_uint;
extern "C" {
    pub static mut wal_level: ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct CheckpointStatsData {
    pub ckpt_start_t: TimestampTz,
    pub ckpt_write_t: TimestampTz,
    pub ckpt_sync_t: TimestampTz,
    pub ckpt_sync_end_t: TimestampTz,
    pub ckpt_end_t: TimestampTz,
    pub ckpt_bufs_written: ::std::os::raw::c_int,
    pub ckpt_segs_added: ::std::os::raw::c_int,
    pub ckpt_segs_removed: ::std::os::raw::c_int,
    pub ckpt_segs_recycled: ::std::os::raw::c_int,
    pub ckpt_sync_rels: ::std::os::raw::c_int,
    pub ckpt_longest_sync: uint64,
    pub ckpt_agg_sync_time: uint64,
}
extern "C" {
    pub static mut CheckpointStats: CheckpointStatsData;
}
pub const WALAvailability_WALAVAIL_INVALID_LSN: WALAvailability = 0;
pub const WALAvailability_WALAVAIL_RESERVED: WALAvailability = 1;
pub const WALAvailability_WALAVAIL_EXTENDED: WALAvailability = 2;
pub const WALAvailability_WALAVAIL_UNRESERVED: WALAvailability = 3;
pub const WALAvailability_WALAVAIL_REMOVED: WALAvailability = 4;
pub type WALAvailability = ::std::os::raw::c_uint;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogInsertRecord(
        rdata: *mut XLogRecData,
        fpw_lsn: XLogRecPtr,
        flags: uint8,
        num_fpi: ::std::os::raw::c_int,
    ) -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogFlush(RecPtr: XLogRecPtr);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogBackgroundFlush() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogNeedsFlush(RecPtr: XLogRecPtr) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogFileInit(
        segno: XLogSegNo,
        use_existent: *mut bool,
        use_lock: bool,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogFileOpen(segno: XLogSegNo) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CheckXLogRemoved(segno: XLogSegNo, tli: TimeLineID);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogGetLastRemovedSegno() -> XLogSegNo;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogSetAsyncXactLSN(record: XLogRecPtr);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogSetReplicationSlotMinimumLSN(lsn: XLogRecPtr);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn xlog_redo(record: *mut XLogReaderState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn xlog_desc(buf: StringInfo, record: *mut XLogReaderState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn xlog_identify(info: uint8) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn issue_xlog_fsync(fd: ::std::os::raw::c_int, segno: XLogSegNo);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RecoveryInProgress() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetRecoveryState() -> RecoveryState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn HotStandbyActive() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn HotStandbyActiveInReplay() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogInsertAllowed() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetXLogReceiptTime(rtime: *mut TimestampTz, fromStream: *mut bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetXLogReplayRecPtr(replayTLI: *mut TimeLineID) -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetXLogInsertRecPtr() -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetXLogWriteRecPtr() -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RecoveryIsPaused() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SetRecoveryPause(recoveryPause: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetLatestXTime() -> TimestampTz;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetCurrentChunkReplayStartTime() -> TimestampTz;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn UpdateControlFile();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetSystemIdentifier() -> uint64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetMockAuthenticationNonce() -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DataChecksumsEnabled() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetFakeLSNForUnloggedRel() -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLOGShmemSize() -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLOGShmemInit();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BootStrapXLOG();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LocalProcessControlFile(reset: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn StartupXLOG();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ShutdownXLOG(code: ::std::os::raw::c_int, arg: Datum);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitXLOGAccess();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CreateCheckPoint(flags: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CreateRestartPoint(flags: ::std::os::raw::c_int) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetWALAvailability(targetLSN: XLogRecPtr) -> WALAvailability;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CalculateMaxmumSafeLSN() -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogPutNextOid(nextOid: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogRestorePoint(rpName: *const ::std::os::raw::c_char) -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn UpdateFullPageWrites();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetFullPageWriteInfo(RedoRecPtr_p: *mut XLogRecPtr, doPageWrites_p: *mut bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetRedoRecPtr() -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetInsertRecPtr() -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetFlushRecPtr() -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetLastImportantRecPtr() -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RemovePromoteSignalFiles();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PromoteIsTriggered() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CheckPromoteSignal() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn WakeupRecovery();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SetWalWriterSleeping(sleeping: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn StartupRequestWalReceiverRestart();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XLogRequestWalReceiverReply();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn assign_max_wal_size(newval: ::std::os::raw::c_int, extra: *mut ::std::os::raw::c_void);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn assign_checkpoint_completion_target(newval: f64, extra: *mut ::std::os::raw::c_void);
}
pub const SessionBackupState_SESSION_BACKUP_NONE: SessionBackupState = 0;
pub const SessionBackupState_SESSION_BACKUP_EXCLUSIVE: SessionBackupState = 1;
pub const SessionBackupState_SESSION_BACKUP_NON_EXCLUSIVE: SessionBackupState = 2;
pub type SessionBackupState = ::std::os::raw::c_uint;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn do_pg_start_backup(
        backupidstr: *const ::std::os::raw::c_char,
        fast: bool,
        starttli_p: *mut TimeLineID,
        labelfile: StringInfo,
        tablespaces: *mut *mut List,
        tblspcmapfile: StringInfo,
        infotbssize: bool,
        needtblspcmapfile: bool,
    ) -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn do_pg_stop_backup(
        labelfile: *mut ::std::os::raw::c_char,
        waitforarchive: bool,
        stoptli_p: *mut TimeLineID,
    ) -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn do_pg_abort_backup(code: ::std::os::raw::c_int, arg: Datum);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn register_persistent_abort_backup_handler();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_backup_status() -> SessionBackupState;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogPageHeaderData {
    pub xlp_magic: uint16,
    pub xlp_info: uint16,
    pub xlp_tli: TimeLineID,
    pub xlp_pageaddr: XLogRecPtr,
    pub xlp_rem_len: uint32,
}
pub type XLogPageHeader = *mut XLogPageHeaderData;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct XLogLongPageHeaderData {
    pub std: XLogPageHeaderData,
    pub xlp_sysid: uint64,
    pub xlp_seg_size: uint32,
    pub xlp_xlog_blcksz: uint32,
}
pub type XLogLongPageHeader = *mut XLogLongPageHeaderData;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_parameter_change {
    pub MaxConnections: ::std::os::raw::c_int,
    pub max_worker_processes: ::std::os::raw::c_int,
    pub max_wal_senders: ::std::os::raw::c_int,
    pub max_prepared_xacts: ::std::os::raw::c_int,
    pub max_locks_per_xact: ::std::os::raw::c_int,
    pub wal_level: ::std::os::raw::c_int,
    pub wal_log_hints: bool,
    pub track_commit_timestamp: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_restore_point {
    pub rp_time: TimestampTz,
    pub rp_name: [::std::os::raw::c_char; 64usize],
}
impl Default for xl_restore_point {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_overwrite_contrecord {
    pub overwritten_lsn: XLogRecPtr,
    pub overwrite_time: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_end_of_recovery {
    pub end_time: TimestampTz,
    pub ThisTimeLineID: TimeLineID,
    pub PrevTimeLineID: TimeLineID,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct XLogRecData {
    pub next: *mut XLogRecData,
    pub data: *mut ::std::os::raw::c_char,
    pub len: uint32,
}
impl Default for XLogRecData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RecoveryTargetAction_RECOVERY_TARGET_ACTION_PAUSE: RecoveryTargetAction = 0;
pub const RecoveryTargetAction_RECOVERY_TARGET_ACTION_PROMOTE: RecoveryTargetAction = 1;
pub const RecoveryTargetAction_RECOVERY_TARGET_ACTION_SHUTDOWN: RecoveryTargetAction = 2;
pub type RecoveryTargetAction = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RmgrData {
    pub rm_name: *const ::std::os::raw::c_char,
    pub rm_redo: ::std::option::Option<unsafe extern "C" fn(record: *mut XLogReaderState)>,
    pub rm_desc:
        ::std::option::Option<unsafe extern "C" fn(buf: StringInfo, record: *mut XLogReaderState)>,
    pub rm_identify:
        ::std::option::Option<unsafe extern "C" fn(info: uint8) -> *const ::std::os::raw::c_char>,
    pub rm_startup: ::std::option::Option<unsafe extern "C" fn()>,
    pub rm_cleanup: ::std::option::Option<unsafe extern "C" fn()>,
    pub rm_mask: ::std::option::Option<
        unsafe extern "C" fn(pagedata: *mut ::std::os::raw::c_char, blkno: BlockNumber),
    >,
}
impl Default for RmgrData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static RmgrTable: [RmgrData; 0usize];
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetLastSegSwitchData(lastSwitchLSN: *mut XLogRecPtr) -> pg_time_t;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RequestXLogSwitch(mark_unimportant: bool) -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetOldestRestartPoint(oldrecptr: *mut XLogRecPtr, oldtli: *mut TimeLineID);
}
extern "C" {
    pub static mut ArchiveRecoveryRequested: bool;
}
extern "C" {
    pub static mut InArchiveRecovery: bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_class {
    pub oid: Oid,
    pub relname: NameData,
    pub relnamespace: Oid,
    pub reltype: Oid,
    pub reloftype: Oid,
    pub relowner: Oid,
    pub relam: Oid,
    pub relfilenode: Oid,
    pub reltablespace: Oid,
    pub relpages: int32,
    pub reltuples: float4,
    pub relallvisible: int32,
    pub reltoastrelid: Oid,
    pub relhasindex: bool,
    pub relisshared: bool,
    pub relpersistence: ::std::os::raw::c_char,
    pub relkind: ::std::os::raw::c_char,
    pub relnatts: int16,
    pub relchecks: int16,
    pub relhasrules: bool,
    pub relhastriggers: bool,
    pub relhassubclass: bool,
    pub relrowsecurity: bool,
    pub relforcerowsecurity: bool,
    pub relispopulated: bool,
    pub relreplident: ::std::os::raw::c_char,
    pub relispartition: bool,
    pub relrewrite: Oid,
    pub relfrozenxid: TransactionId,
    pub relminmxid: TransactionId,
}
impl Default for FormData_pg_class {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_class = *mut FormData_pg_class;
#[repr(C)]
#[derive(Debug)]
pub struct FormData_pg_index {
    pub indexrelid: Oid,
    pub indrelid: Oid,
    pub indnatts: int16,
    pub indnkeyatts: int16,
    pub indisunique: bool,
    pub indisprimary: bool,
    pub indisexclusion: bool,
    pub indimmediate: bool,
    pub indisclustered: bool,
    pub indisvalid: bool,
    pub indcheckxmin: bool,
    pub indisready: bool,
    pub indislive: bool,
    pub indisreplident: bool,
    pub indkey: int2vector,
}
impl Default for FormData_pg_index {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_index = *mut FormData_pg_index;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectAddress {
    pub classId: Oid,
    pub objectId: Oid,
    pub objectSubId: int32,
}
impl Default for ObjectAddress {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static InvalidObjectAddress: ObjectAddress;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_object_address(
        objtype: ObjectType,
        object: *mut Node,
        relp: *mut Relation,
        lockmode: LOCKMODE,
        missing_ok: bool,
    ) -> ObjectAddress;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_object_address_rv(
        objtype: ObjectType,
        rel: *mut RangeVar,
        object: *mut List,
        relp: *mut Relation,
        lockmode: LOCKMODE,
        missing_ok: bool,
    ) -> ObjectAddress;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn check_object_ownership(
        roleid: Oid,
        objtype: ObjectType,
        address: ObjectAddress,
        object: *mut Node,
        relation: Relation,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_object_namespace(address: *const ObjectAddress) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn is_objectclass_supported(class_id: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_object_oid_index(class_id: Oid) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_object_catcache_oid(class_id: Oid) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_object_catcache_name(class_id: Oid) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_object_attnum_oid(class_id: Oid) -> AttrNumber;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_object_attnum_name(class_id: Oid) -> AttrNumber;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_object_attnum_namespace(class_id: Oid) -> AttrNumber;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_object_attnum_owner(class_id: Oid) -> AttrNumber;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_object_attnum_acl(class_id: Oid) -> AttrNumber;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_object_type(class_id: Oid, object_id: Oid) -> ObjectType;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_object_namensp_unique(class_id: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_catalog_object_by_oid(
        catalog: Relation,
        oidcol: AttrNumber,
        objectId: Oid,
    ) -> HeapTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn getObjectDescription(object: *const ObjectAddress) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn getObjectDescriptionOids(classid: Oid, objid: Oid) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn read_objtype_from_string(
        objtype: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn getObjectTypeDescription(object: *const ObjectAddress) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn getObjectIdentity(address: *const ObjectAddress) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn getObjectIdentityParts(
        address: *const ObjectAddress,
        objname: *mut *mut List,
        objargs: *mut *mut List,
    ) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn strlist_to_textarray(list: *mut List) -> *mut ArrayType;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_relkind_objtype(relkind: ::std::os::raw::c_char) -> ObjectType;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_publication {
    pub oid: Oid,
    pub pubname: NameData,
    pub pubowner: Oid,
    pub puballtables: bool,
    pub pubinsert: bool,
    pub pubupdate: bool,
    pub pubdelete: bool,
    pub pubtruncate: bool,
    pub pubviaroot: bool,
}
impl Default for FormData_pg_publication {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_publication = *mut FormData_pg_publication;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct PublicationActions {
    pub pubinsert: bool,
    pub pubupdate: bool,
    pub pubdelete: bool,
    pub pubtruncate: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Publication {
    pub oid: Oid,
    pub name: *mut ::std::os::raw::c_char,
    pub alltables: bool,
    pub pubviaroot: bool,
    pub pubactions: PublicationActions,
}
impl Default for Publication {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetPublication(pubid: Oid) -> *mut Publication;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetPublicationByName(
        pubname: *const ::std::os::raw::c_char,
        missing_ok: bool,
    ) -> *mut Publication;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetRelationPublications(relid: Oid) -> *mut List;
}
pub const PublicationPartOpt_PUBLICATION_PART_ROOT: PublicationPartOpt = 0;
pub const PublicationPartOpt_PUBLICATION_PART_LEAF: PublicationPartOpt = 1;
pub const PublicationPartOpt_PUBLICATION_PART_ALL: PublicationPartOpt = 2;
pub type PublicationPartOpt = ::std::os::raw::c_uint;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetPublicationRelations(pubid: Oid, pub_partopt: PublicationPartOpt) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetAllTablesPublications() -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetAllTablesPublicationRelations(pubviaroot: bool) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn is_publishable_relation(rel: Relation) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn publication_add_relation(
        pubid: Oid,
        targetrel: Relation,
        if_not_exists: bool,
    ) -> ObjectAddress;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetPubPartitionOptionRelations(
        result: *mut List,
        pub_partopt: PublicationPartOpt,
        relid: Oid,
    ) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_publication_oid(pubname: *const ::std::os::raw::c_char, missing_ok: bool) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_publication_name(pubid: Oid, missing_ok: bool) -> *mut ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RewriteRule {
    pub ruleId: Oid,
    pub event: CmdType,
    pub qual: *mut Node,
    pub actions: *mut List,
    pub enabled: ::std::os::raw::c_char,
    pub isInstead: bool,
}
impl Default for RewriteRule {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RuleLock {
    pub numLocks: ::std::os::raw::c_int,
    pub rules: *mut *mut RewriteRule,
}
impl Default for RuleLock {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SMgrRelationData {
    pub smgr_rnode: RelFileNodeBackend,
    pub smgr_owner: *mut *mut SMgrRelationData,
    pub smgr_targblock: BlockNumber,
    pub smgr_fsm_nblocks: BlockNumber,
    pub smgr_vm_nblocks: BlockNumber,
    pub smgr_which: ::std::os::raw::c_int,
    pub md_num_open_segs: [::std::os::raw::c_int; 4usize],
    pub md_seg_fds: [*mut _MdfdVec; 4usize],
    pub node: dlist_node,
}
impl Default for SMgrRelationData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type SMgrRelation = *mut SMgrRelationData;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgrinit();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgropen(rnode: RelFileNode, backend: BackendId) -> SMgrRelation;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgrexists(reln: SMgrRelation, forknum: ForkNumber) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgrsetowner(owner: *mut SMgrRelation, reln: SMgrRelation);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgrclearowner(owner: *mut SMgrRelation, reln: SMgrRelation);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgrclose(reln: SMgrRelation);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgrcloseall();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgrclosenode(rnode: RelFileNodeBackend);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgrcreate(reln: SMgrRelation, forknum: ForkNumber, isRedo: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgrdosyncall(rels: *mut SMgrRelation, nrels: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgrdounlinkall(rels: *mut SMgrRelation, nrels: ::std::os::raw::c_int, isRedo: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgrextend(
        reln: SMgrRelation,
        forknum: ForkNumber,
        blocknum: BlockNumber,
        buffer: *mut ::std::os::raw::c_char,
        skipFsync: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgrprefetch(reln: SMgrRelation, forknum: ForkNumber, blocknum: BlockNumber) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgrread(
        reln: SMgrRelation,
        forknum: ForkNumber,
        blocknum: BlockNumber,
        buffer: *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgrwrite(
        reln: SMgrRelation,
        forknum: ForkNumber,
        blocknum: BlockNumber,
        buffer: *mut ::std::os::raw::c_char,
        skipFsync: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgrwriteback(
        reln: SMgrRelation,
        forknum: ForkNumber,
        blocknum: BlockNumber,
        nblocks: BlockNumber,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgrnblocks(reln: SMgrRelation, forknum: ForkNumber) -> BlockNumber;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgrtruncate(
        reln: SMgrRelation,
        forknum: *mut ForkNumber,
        nforks: ::std::os::raw::c_int,
        nblocks: *mut BlockNumber,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn smgrimmedsync(reln: SMgrRelation, forknum: ForkNumber);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AtEOXact_SMgr();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockRelId {
    pub relId: Oid,
    pub dbId: Oid,
}
impl Default for LockRelId {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LockInfoData {
    pub lockRelId: LockRelId,
}
impl Default for LockInfoData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type LockInfo = *mut LockInfoData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RelationData {
    pub rd_node: RelFileNode,
    pub rd_smgr: SMgrRelation,
    pub rd_refcnt: ::std::os::raw::c_int,
    pub rd_backend: BackendId,
    pub rd_islocaltemp: bool,
    pub rd_isnailed: bool,
    pub rd_isvalid: bool,
    pub rd_indexvalid: bool,
    pub rd_statvalid: bool,
    pub rd_createSubid: SubTransactionId,
    pub rd_newRelfilenodeSubid: SubTransactionId,
    pub rd_firstRelfilenodeSubid: SubTransactionId,
    pub rd_droppedSubid: SubTransactionId,
    pub rd_rel: Form_pg_class,
    pub rd_att: TupleDesc,
    pub rd_id: Oid,
    pub rd_lockInfo: LockInfoData,
    pub rd_rules: *mut RuleLock,
    pub rd_rulescxt: MemoryContext,
    pub trigdesc: *mut TriggerDesc,
    pub rd_rsdesc: *mut RowSecurityDesc,
    pub rd_fkeylist: *mut List,
    pub rd_fkeyvalid: bool,
    pub rd_partkey: PartitionKey,
    pub rd_partkeycxt: MemoryContext,
    pub rd_partdesc: PartitionDesc,
    pub rd_pdcxt: MemoryContext,
    pub rd_partcheck: *mut List,
    pub rd_partcheckvalid: bool,
    pub rd_partcheckcxt: MemoryContext,
    pub rd_indexlist: *mut List,
    pub rd_pkindex: Oid,
    pub rd_replidindex: Oid,
    pub rd_statlist: *mut List,
    pub rd_indexattr: *mut Bitmapset,
    pub rd_keyattr: *mut Bitmapset,
    pub rd_pkattr: *mut Bitmapset,
    pub rd_idattr: *mut Bitmapset,
    pub rd_pubactions: *mut PublicationActions,
    pub rd_options: *mut bytea,
    pub rd_amhandler: Oid,
    pub rd_tableam: *const TableAmRoutine,
    pub rd_index: Form_pg_index,
    pub rd_indextuple: *mut HeapTupleData,
    pub rd_indexcxt: MemoryContext,
    pub rd_indam: *mut IndexAmRoutine,
    pub rd_opfamily: *mut Oid,
    pub rd_opcintype: *mut Oid,
    pub rd_support: *mut RegProcedure,
    pub rd_supportinfo: *mut FmgrInfo,
    pub rd_indoption: *mut int16,
    pub rd_indexprs: *mut List,
    pub rd_indpred: *mut List,
    pub rd_exclops: *mut Oid,
    pub rd_exclprocs: *mut Oid,
    pub rd_exclstrats: *mut uint16,
    pub rd_indcollation: *mut Oid,
    pub rd_opcoptions: *mut *mut bytea,
    pub rd_amcache: *mut ::std::os::raw::c_void,
    pub rd_fdwroutine: *mut FdwRoutine,
    pub rd_toastoid: Oid,
    pub pgstat_info: *mut PgStat_TableStatus,
}
impl Default for RelationData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ForeignKeyCacheInfo {
    pub type_: NodeTag,
    pub conoid: Oid,
    pub conrelid: Oid,
    pub confrelid: Oid,
    pub nkeys: ::std::os::raw::c_int,
    pub conkey: [AttrNumber; 32usize],
    pub confkey: [AttrNumber; 32usize],
    pub conpfeqop: [Oid; 32usize],
}
impl Default for ForeignKeyCacheInfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct AutoVacOpts {
    pub enabled: bool,
    pub vacuum_threshold: ::std::os::raw::c_int,
    pub vacuum_ins_threshold: ::std::os::raw::c_int,
    pub analyze_threshold: ::std::os::raw::c_int,
    pub vacuum_cost_limit: ::std::os::raw::c_int,
    pub freeze_min_age: ::std::os::raw::c_int,
    pub freeze_max_age: ::std::os::raw::c_int,
    pub freeze_table_age: ::std::os::raw::c_int,
    pub multixact_freeze_min_age: ::std::os::raw::c_int,
    pub multixact_freeze_max_age: ::std::os::raw::c_int,
    pub multixact_freeze_table_age: ::std::os::raw::c_int,
    pub log_min_duration: ::std::os::raw::c_int,
    pub vacuum_cost_delay: float8,
    pub vacuum_scale_factor: float8,
    pub vacuum_ins_scale_factor: float8,
    pub analyze_scale_factor: float8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct StdRdOptions {
    pub vl_len_: int32,
    pub fillfactor: ::std::os::raw::c_int,
    pub toast_tuple_target: ::std::os::raw::c_int,
    pub autovacuum: AutoVacOpts,
    pub user_catalog_table: bool,
    pub parallel_workers: ::std::os::raw::c_int,
    pub vacuum_index_cleanup: bool,
    pub vacuum_truncate: bool,
}
pub const ViewOptCheckOption_VIEW_OPTION_CHECK_OPTION_NOT_SET: ViewOptCheckOption = 0;
pub const ViewOptCheckOption_VIEW_OPTION_CHECK_OPTION_LOCAL: ViewOptCheckOption = 1;
pub const ViewOptCheckOption_VIEW_OPTION_CHECK_OPTION_CASCADED: ViewOptCheckOption = 2;
pub type ViewOptCheckOption = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ViewOptions {
    pub vl_len_: int32,
    pub security_barrier: bool,
    pub check_option: ViewOptCheckOption,
}
impl Default for ViewOptions {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationIncrementReferenceCount(rel: Relation);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationDecrementReferenceCount(rel: Relation);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GenericXLogState {
    _unused: [u8; 0],
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GenericXLogStart(relation: Relation) -> *mut GenericXLogState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GenericXLogRegisterBuffer(
        state: *mut GenericXLogState,
        buffer: Buffer,
        flags: ::std::os::raw::c_int,
    ) -> Page;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GenericXLogFinish(state: *mut GenericXLogState) -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GenericXLogAbort(state: *mut GenericXLogState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn generic_redo(record: *mut XLogReaderState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn generic_identify(info: uint8) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn generic_desc(buf: StringInfo, record: *mut XLogReaderState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn generic_mask(pagedata: *mut ::std::os::raw::c_char, blkno: BlockNumber);
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct GinStatsData {
    pub nPendingPages: BlockNumber,
    pub nTotalPages: BlockNumber,
    pub nEntryPages: BlockNumber,
    pub nDataPages: BlockNumber,
    pub nEntries: int64,
    pub ginVersion: int32,
}
pub type GinTernaryValue = ::std::os::raw::c_char;
extern "C" {
    pub static mut GinFuzzySearchLimit: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut gin_pending_list_limit: ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ginGetStats(index: Relation, stats: *mut GinStatsData);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ginUpdateStats(index: Relation, stats: *const GinStatsData, is_build: bool);
}
pub type GistNSN = XLogRecPtr;
pub type PageGistNSN = PageXLogRecPtr;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct GISTPageOpaqueData {
    pub nsn: PageGistNSN,
    pub rightlink: BlockNumber,
    pub flags: uint16,
    pub gist_page_id: uint16,
}
pub type GISTPageOpaque = *mut GISTPageOpaqueData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GIST_SPLITVEC {
    pub spl_left: *mut OffsetNumber,
    pub spl_nleft: ::std::os::raw::c_int,
    pub spl_ldatum: Datum,
    pub spl_ldatum_exists: bool,
    pub spl_right: *mut OffsetNumber,
    pub spl_nright: ::std::os::raw::c_int,
    pub spl_rdatum: Datum,
    pub spl_rdatum_exists: bool,
}
impl Default for GIST_SPLITVEC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GISTENTRY {
    pub key: Datum,
    pub rel: Relation,
    pub page: Page,
    pub offset: OffsetNumber,
    pub leafkey: bool,
}
impl Default for GISTENTRY {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct GISTDeletedPageContents {
    pub deleteXid: FullTransactionId,
}
#[repr(C)]
#[derive(Debug)]
pub struct GistEntryVector {
    pub n: int32,
    pub vector: __IncompleteArrayField<GISTENTRY>,
}
impl Default for GistEntryVector {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn relation_open(relationId: Oid, lockmode: LOCKMODE) -> Relation;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn try_relation_open(relationId: Oid, lockmode: LOCKMODE) -> Relation;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn relation_openrv(relation: *const RangeVar, lockmode: LOCKMODE) -> Relation;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn relation_openrv_extended(
        relation: *const RangeVar,
        lockmode: LOCKMODE,
        missing_ok: bool,
    ) -> Relation;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn relation_close(relation: Relation, lockmode: LOCKMODE);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableScanDescData {
    pub rs_rd: Relation,
    pub rs_snapshot: *mut SnapshotData,
    pub rs_nkeys: ::std::os::raw::c_int,
    pub rs_key: *mut ScanKeyData,
    pub rs_flags: uint32,
    pub rs_parallel: *mut ParallelTableScanDescData,
}
impl Default for TableScanDescData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TableScanDesc = *mut TableScanDescData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelTableScanDescData {
    pub phs_relid: Oid,
    pub phs_syncscan: bool,
    pub phs_snapshot_any: bool,
    pub phs_snapshot_off: Size,
}
impl Default for ParallelTableScanDescData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ParallelTableScanDesc = *mut ParallelTableScanDescData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParallelBlockTableScanDescData {
    pub base: ParallelTableScanDescData,
    pub phs_nblocks: BlockNumber,
    pub phs_mutex: slock_t,
    pub phs_startblock: BlockNumber,
    pub phs_nallocated: pg_atomic_uint64,
}
impl Default for ParallelBlockTableScanDescData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ParallelBlockTableScanDesc = *mut ParallelBlockTableScanDescData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexFetchTableData {
    pub rel: Relation,
}
impl Default for IndexFetchTableData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexScanDescData {
    pub heapRelation: Relation,
    pub indexRelation: Relation,
    pub xs_snapshot: *mut SnapshotData,
    pub numberOfKeys: ::std::os::raw::c_int,
    pub numberOfOrderBys: ::std::os::raw::c_int,
    pub keyData: *mut ScanKeyData,
    pub orderByData: *mut ScanKeyData,
    pub xs_want_itup: bool,
    pub xs_temp_snap: bool,
    pub kill_prior_tuple: bool,
    pub ignore_killed_tuples: bool,
    pub xactStartedInRecovery: bool,
    pub opaque: *mut ::std::os::raw::c_void,
    pub xs_itup: IndexTuple,
    pub xs_itupdesc: *mut TupleDescData,
    pub xs_hitup: HeapTuple,
    pub xs_hitupdesc: *mut TupleDescData,
    pub xs_heaptid: ItemPointerData,
    pub xs_heap_continue: bool,
    pub xs_heapfetch: *mut IndexFetchTableData,
    pub xs_recheck: bool,
    pub xs_orderbyvals: *mut Datum,
    pub xs_orderbynulls: *mut bool,
    pub xs_recheckorderby: bool,
    pub parallel_scan: *mut ParallelIndexScanDescData,
}
impl Default for IndexScanDescData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct ParallelIndexScanDescData {
    pub ps_relid: Oid,
    pub ps_indexid: Oid,
    pub ps_offset: Size,
    pub ps_snapshot_data: __IncompleteArrayField<::std::os::raw::c_char>,
}
impl Default for ParallelIndexScanDescData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SysScanDescData {
    pub heap_rel: Relation,
    pub irel: Relation,
    pub scan: *mut TableScanDescData,
    pub iscan: *mut IndexScanDescData,
    pub snapshot: *mut SnapshotData,
    pub slot: *mut TupleTableSlot,
}
impl Default for SysScanDescData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_open(relationId: Oid, lockmode: LOCKMODE) -> Relation;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_openrv(relation: *const RangeVar, lockmode: LOCKMODE) -> Relation;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_openrv_extended(
        relation: *const RangeVar,
        lockmode: LOCKMODE,
        missing_ok: bool,
    ) -> Relation;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_close(relation: Relation, lockmode: LOCKMODE);
}
pub type EOM_get_flat_size_method =
    ::std::option::Option<unsafe extern "C" fn(eohptr: *mut ExpandedObjectHeader) -> Size>;
pub type EOM_flatten_into_method = ::std::option::Option<
    unsafe extern "C" fn(
        eohptr: *mut ExpandedObjectHeader,
        result: *mut ::std::os::raw::c_void,
        allocated_size: Size,
    ),
>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ExpandedObjectMethods {
    pub get_flat_size: EOM_get_flat_size_method,
    pub flatten_into: EOM_flatten_into_method,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExpandedObjectHeader {
    pub vl_len_: int32,
    pub eoh_methods: *const ExpandedObjectMethods,
    pub eoh_context: MemoryContext,
    pub eoh_rw_ptr: [::std::os::raw::c_char; 10usize],
    pub eoh_ro_ptr: [::std::os::raw::c_char; 10usize],
}
impl Default for ExpandedObjectHeader {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DatumGetEOHP(d: Datum) -> *mut ExpandedObjectHeader;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EOH_init_header(
        eohptr: *mut ExpandedObjectHeader,
        methods: *const ExpandedObjectMethods,
        obj_context: MemoryContext,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EOH_get_flat_size(eohptr: *mut ExpandedObjectHeader) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EOH_flatten_into(
        eohptr: *mut ExpandedObjectHeader,
        result: *mut ::std::os::raw::c_void,
        allocated_size: Size,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MakeExpandedObjectReadOnlyInternal(d: Datum) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TransferExpandedObject(d: Datum, new_parent: MemoryContext) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DeleteExpandedObject(d: Datum);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayType {
    pub vl_len_: int32,
    pub ndim: ::std::os::raw::c_int,
    pub dataoffset: int32,
    pub elemtype: Oid,
}
impl Default for ArrayType {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ExpandedArrayHeader {
    pub hdr: ExpandedObjectHeader,
    pub ea_magic: ::std::os::raw::c_int,
    pub ndims: ::std::os::raw::c_int,
    pub dims: *mut ::std::os::raw::c_int,
    pub lbound: *mut ::std::os::raw::c_int,
    pub element_type: Oid,
    pub typlen: int16,
    pub typbyval: bool,
    pub typalign: ::std::os::raw::c_char,
    pub dvalues: *mut Datum,
    pub dnulls: *mut bool,
    pub dvalueslen: ::std::os::raw::c_int,
    pub nelems: ::std::os::raw::c_int,
    pub flat_size: Size,
    pub fvalue: *mut ArrayType,
    pub fstartptr: *mut ::std::os::raw::c_char,
    pub fendptr: *mut ::std::os::raw::c_char,
}
impl Default for ExpandedArrayHeader {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union AnyArrayType {
    pub flt: ArrayType,
    pub xpn: ExpandedArrayHeader,
}
impl Default for AnyArrayType {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayBuildState {
    pub mcontext: MemoryContext,
    pub dvalues: *mut Datum,
    pub dnulls: *mut bool,
    pub alen: ::std::os::raw::c_int,
    pub nelems: ::std::os::raw::c_int,
    pub element_type: Oid,
    pub typlen: int16,
    pub typbyval: bool,
    pub typalign: ::std::os::raw::c_char,
    pub private_cxt: bool,
}
impl Default for ArrayBuildState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayBuildStateArr {
    pub mcontext: MemoryContext,
    pub data: *mut ::std::os::raw::c_char,
    pub nullbitmap: *mut bits8,
    pub abytes: ::std::os::raw::c_int,
    pub nbytes: ::std::os::raw::c_int,
    pub aitems: ::std::os::raw::c_int,
    pub nitems: ::std::os::raw::c_int,
    pub ndims: ::std::os::raw::c_int,
    pub dims: [::std::os::raw::c_int; 6usize],
    pub lbs: [::std::os::raw::c_int; 6usize],
    pub array_type: Oid,
    pub element_type: Oid,
    pub private_cxt: bool,
}
impl Default for ArrayBuildStateArr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayBuildStateAny {
    pub scalarstate: *mut ArrayBuildState,
    pub arraystate: *mut ArrayBuildStateArr,
}
impl Default for ArrayBuildStateAny {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayMetaState {
    pub element_type: Oid,
    pub typlen: int16,
    pub typbyval: bool,
    pub typalign: ::std::os::raw::c_char,
    pub typdelim: ::std::os::raw::c_char,
    pub typioparam: Oid,
    pub typiofunc: Oid,
    pub proc_: FmgrInfo,
}
impl Default for ArrayMetaState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayMapState {
    pub inp_extra: ArrayMetaState,
    pub ret_extra: ArrayMetaState,
}
impl Default for ArrayMapState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ArrayIteratorData {
    _unused: [u8; 0],
}
pub type ArrayIterator = *mut ArrayIteratorData;
extern "C" {
    pub static mut Array_nulls: bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CopyArrayEls(
        array: *mut ArrayType,
        values: *mut Datum,
        nulls: *mut bool,
        nitems: ::std::os::raw::c_int,
        typlen: ::std::os::raw::c_int,
        typbyval: bool,
        typalign: ::std::os::raw::c_char,
        freedata: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn array_get_element(
        arraydatum: Datum,
        nSubscripts: ::std::os::raw::c_int,
        indx: *mut ::std::os::raw::c_int,
        arraytyplen: ::std::os::raw::c_int,
        elmlen: ::std::os::raw::c_int,
        elmbyval: bool,
        elmalign: ::std::os::raw::c_char,
        isNull: *mut bool,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn array_set_element(
        arraydatum: Datum,
        nSubscripts: ::std::os::raw::c_int,
        indx: *mut ::std::os::raw::c_int,
        dataValue: Datum,
        isNull: bool,
        arraytyplen: ::std::os::raw::c_int,
        elmlen: ::std::os::raw::c_int,
        elmbyval: bool,
        elmalign: ::std::os::raw::c_char,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn array_get_slice(
        arraydatum: Datum,
        nSubscripts: ::std::os::raw::c_int,
        upperIndx: *mut ::std::os::raw::c_int,
        lowerIndx: *mut ::std::os::raw::c_int,
        upperProvided: *mut bool,
        lowerProvided: *mut bool,
        arraytyplen: ::std::os::raw::c_int,
        elmlen: ::std::os::raw::c_int,
        elmbyval: bool,
        elmalign: ::std::os::raw::c_char,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn array_set_slice(
        arraydatum: Datum,
        nSubscripts: ::std::os::raw::c_int,
        upperIndx: *mut ::std::os::raw::c_int,
        lowerIndx: *mut ::std::os::raw::c_int,
        upperProvided: *mut bool,
        lowerProvided: *mut bool,
        srcArrayDatum: Datum,
        isNull: bool,
        arraytyplen: ::std::os::raw::c_int,
        elmlen: ::std::os::raw::c_int,
        elmbyval: bool,
        elmalign: ::std::os::raw::c_char,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn array_ref(
        array: *mut ArrayType,
        nSubscripts: ::std::os::raw::c_int,
        indx: *mut ::std::os::raw::c_int,
        arraytyplen: ::std::os::raw::c_int,
        elmlen: ::std::os::raw::c_int,
        elmbyval: bool,
        elmalign: ::std::os::raw::c_char,
        isNull: *mut bool,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn array_set(
        array: *mut ArrayType,
        nSubscripts: ::std::os::raw::c_int,
        indx: *mut ::std::os::raw::c_int,
        dataValue: Datum,
        isNull: bool,
        arraytyplen: ::std::os::raw::c_int,
        elmlen: ::std::os::raw::c_int,
        elmbyval: bool,
        elmalign: ::std::os::raw::c_char,
    ) -> *mut ArrayType;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn array_map(
        arrayd: Datum,
        exprstate: *mut ExprState,
        econtext: *mut ExprContext,
        retType: Oid,
        amstate: *mut ArrayMapState,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn array_bitmap_copy(
        destbitmap: *mut bits8,
        destoffset: ::std::os::raw::c_int,
        srcbitmap: *const bits8,
        srcoffset: ::std::os::raw::c_int,
        nitems: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn construct_array(
        elems: *mut Datum,
        nelems: ::std::os::raw::c_int,
        elmtype: Oid,
        elmlen: ::std::os::raw::c_int,
        elmbyval: bool,
        elmalign: ::std::os::raw::c_char,
    ) -> *mut ArrayType;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn construct_md_array(
        elems: *mut Datum,
        nulls: *mut bool,
        ndims: ::std::os::raw::c_int,
        dims: *mut ::std::os::raw::c_int,
        lbs: *mut ::std::os::raw::c_int,
        elmtype: Oid,
        elmlen: ::std::os::raw::c_int,
        elmbyval: bool,
        elmalign: ::std::os::raw::c_char,
    ) -> *mut ArrayType;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn construct_empty_array(elmtype: Oid) -> *mut ArrayType;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn construct_empty_expanded_array(
        element_type: Oid,
        parentcontext: MemoryContext,
        metacache: *mut ArrayMetaState,
    ) -> *mut ExpandedArrayHeader;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn deconstruct_array(
        array: *mut ArrayType,
        elmtype: Oid,
        elmlen: ::std::os::raw::c_int,
        elmbyval: bool,
        elmalign: ::std::os::raw::c_char,
        elemsp: *mut *mut Datum,
        nullsp: *mut *mut bool,
        nelemsp: *mut ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn array_contains_nulls(array: *mut ArrayType) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn initArrayResult(
        element_type: Oid,
        rcontext: MemoryContext,
        subcontext: bool,
    ) -> *mut ArrayBuildState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn accumArrayResult(
        astate: *mut ArrayBuildState,
        dvalue: Datum,
        disnull: bool,
        element_type: Oid,
        rcontext: MemoryContext,
    ) -> *mut ArrayBuildState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn makeArrayResult(astate: *mut ArrayBuildState, rcontext: MemoryContext) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn makeMdArrayResult(
        astate: *mut ArrayBuildState,
        ndims: ::std::os::raw::c_int,
        dims: *mut ::std::os::raw::c_int,
        lbs: *mut ::std::os::raw::c_int,
        rcontext: MemoryContext,
        release: bool,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn initArrayResultArr(
        array_type: Oid,
        element_type: Oid,
        rcontext: MemoryContext,
        subcontext: bool,
    ) -> *mut ArrayBuildStateArr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn accumArrayResultArr(
        astate: *mut ArrayBuildStateArr,
        dvalue: Datum,
        disnull: bool,
        array_type: Oid,
        rcontext: MemoryContext,
    ) -> *mut ArrayBuildStateArr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn makeArrayResultArr(
        astate: *mut ArrayBuildStateArr,
        rcontext: MemoryContext,
        release: bool,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn initArrayResultAny(
        input_type: Oid,
        rcontext: MemoryContext,
        subcontext: bool,
    ) -> *mut ArrayBuildStateAny;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn accumArrayResultAny(
        astate: *mut ArrayBuildStateAny,
        dvalue: Datum,
        disnull: bool,
        input_type: Oid,
        rcontext: MemoryContext,
    ) -> *mut ArrayBuildStateAny;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn makeArrayResultAny(
        astate: *mut ArrayBuildStateAny,
        rcontext: MemoryContext,
        release: bool,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn array_create_iterator(
        arr: *mut ArrayType,
        slice_ndim: ::std::os::raw::c_int,
        mstate: *mut ArrayMetaState,
    ) -> ArrayIterator;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn array_iterate(iterator: ArrayIterator, value: *mut Datum, isnull: *mut bool) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn array_free_iterator(iterator: ArrayIterator);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ArrayGetOffset(
        n: ::std::os::raw::c_int,
        dim: *const ::std::os::raw::c_int,
        lb: *const ::std::os::raw::c_int,
        indx: *const ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ArrayGetOffset0(
        n: ::std::os::raw::c_int,
        tup: *const ::std::os::raw::c_int,
        scale: *const ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ArrayGetNItems(
        ndim: ::std::os::raw::c_int,
        dims: *const ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ArrayCheckBounds(
        ndim: ::std::os::raw::c_int,
        dims: *const ::std::os::raw::c_int,
        lb: *const ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn mda_get_range(
        n: ::std::os::raw::c_int,
        span: *mut ::std::os::raw::c_int,
        st: *const ::std::os::raw::c_int,
        endp: *const ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn mda_get_prod(
        n: ::std::os::raw::c_int,
        range: *const ::std::os::raw::c_int,
        prod: *mut ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn mda_get_offset_values(
        n: ::std::os::raw::c_int,
        dist: *mut ::std::os::raw::c_int,
        prod: *const ::std::os::raw::c_int,
        span: *const ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn mda_next_tuple(
        n: ::std::os::raw::c_int,
        curr: *mut ::std::os::raw::c_int,
        span: *const ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ArrayGetIntegerTypmods(arr: *mut ArrayType, n: *mut ::std::os::raw::c_int)
        -> *mut int32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn expand_array(
        arraydatum: Datum,
        parentcontext: MemoryContext,
        metacache: *mut ArrayMetaState,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DatumGetExpandedArray(d: Datum) -> *mut ExpandedArrayHeader;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DatumGetExpandedArrayX(
        d: Datum,
        metacache: *mut ArrayMetaState,
    ) -> *mut ExpandedArrayHeader;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DatumGetAnyArrayP(d: Datum) -> *mut AnyArrayType;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn deconstruct_expanded_array(eah: *mut ExpandedArrayHeader);
}
pub const GucContext_PGC_INTERNAL: GucContext = 0;
pub const GucContext_PGC_POSTMASTER: GucContext = 1;
pub const GucContext_PGC_SIGHUP: GucContext = 2;
pub const GucContext_PGC_SU_BACKEND: GucContext = 3;
pub const GucContext_PGC_BACKEND: GucContext = 4;
pub const GucContext_PGC_SUSET: GucContext = 5;
pub const GucContext_PGC_USERSET: GucContext = 6;
pub type GucContext = ::std::os::raw::c_uint;
pub const GucSource_PGC_S_DEFAULT: GucSource = 0;
pub const GucSource_PGC_S_DYNAMIC_DEFAULT: GucSource = 1;
pub const GucSource_PGC_S_ENV_VAR: GucSource = 2;
pub const GucSource_PGC_S_FILE: GucSource = 3;
pub const GucSource_PGC_S_ARGV: GucSource = 4;
pub const GucSource_PGC_S_GLOBAL: GucSource = 5;
pub const GucSource_PGC_S_DATABASE: GucSource = 6;
pub const GucSource_PGC_S_USER: GucSource = 7;
pub const GucSource_PGC_S_DATABASE_USER: GucSource = 8;
pub const GucSource_PGC_S_CLIENT: GucSource = 9;
pub const GucSource_PGC_S_OVERRIDE: GucSource = 10;
pub const GucSource_PGC_S_INTERACTIVE: GucSource = 11;
pub const GucSource_PGC_S_TEST: GucSource = 12;
pub const GucSource_PGC_S_SESSION: GucSource = 13;
pub type GucSource = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ConfigVariable {
    pub name: *mut ::std::os::raw::c_char,
    pub value: *mut ::std::os::raw::c_char,
    pub errmsg: *mut ::std::os::raw::c_char,
    pub filename: *mut ::std::os::raw::c_char,
    pub sourceline: ::std::os::raw::c_int,
    pub ignore: bool,
    pub applied: bool,
    pub next: *mut ConfigVariable,
}
impl Default for ConfigVariable {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ParseConfigFile(
        config_file: *const ::std::os::raw::c_char,
        strict: bool,
        calling_file: *const ::std::os::raw::c_char,
        calling_lineno: ::std::os::raw::c_int,
        depth: ::std::os::raw::c_int,
        elevel: ::std::os::raw::c_int,
        head_p: *mut *mut ConfigVariable,
        tail_p: *mut *mut ConfigVariable,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ParseConfigFp(
        fp: *mut FILE,
        config_file: *const ::std::os::raw::c_char,
        depth: ::std::os::raw::c_int,
        elevel: ::std::os::raw::c_int,
        head_p: *mut *mut ConfigVariable,
        tail_p: *mut *mut ConfigVariable,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ParseConfigDirectory(
        includedir: *const ::std::os::raw::c_char,
        calling_file: *const ::std::os::raw::c_char,
        calling_lineno: ::std::os::raw::c_int,
        depth: ::std::os::raw::c_int,
        elevel: ::std::os::raw::c_int,
        head_p: *mut *mut ConfigVariable,
        tail_p: *mut *mut ConfigVariable,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FreeConfigVariables(list: *mut ConfigVariable);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct config_enum_entry {
    pub name: *const ::std::os::raw::c_char,
    pub val: ::std::os::raw::c_int,
    pub hidden: bool,
}
impl Default for config_enum_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type GucBoolCheckHook = ::std::option::Option<
    unsafe extern "C" fn(
        newval: *mut bool,
        extra: *mut *mut ::std::os::raw::c_void,
        source: GucSource,
    ) -> bool,
>;
pub type GucIntCheckHook = ::std::option::Option<
    unsafe extern "C" fn(
        newval: *mut ::std::os::raw::c_int,
        extra: *mut *mut ::std::os::raw::c_void,
        source: GucSource,
    ) -> bool,
>;
pub type GucRealCheckHook = ::std::option::Option<
    unsafe extern "C" fn(
        newval: *mut f64,
        extra: *mut *mut ::std::os::raw::c_void,
        source: GucSource,
    ) -> bool,
>;
pub type GucStringCheckHook = ::std::option::Option<
    unsafe extern "C" fn(
        newval: *mut *mut ::std::os::raw::c_char,
        extra: *mut *mut ::std::os::raw::c_void,
        source: GucSource,
    ) -> bool,
>;
pub type GucEnumCheckHook = ::std::option::Option<
    unsafe extern "C" fn(
        newval: *mut ::std::os::raw::c_int,
        extra: *mut *mut ::std::os::raw::c_void,
        source: GucSource,
    ) -> bool,
>;
pub type GucBoolAssignHook =
    ::std::option::Option<unsafe extern "C" fn(newval: bool, extra: *mut ::std::os::raw::c_void)>;
pub type GucIntAssignHook = ::std::option::Option<
    unsafe extern "C" fn(newval: ::std::os::raw::c_int, extra: *mut ::std::os::raw::c_void),
>;
pub type GucRealAssignHook =
    ::std::option::Option<unsafe extern "C" fn(newval: f64, extra: *mut ::std::os::raw::c_void)>;
pub type GucStringAssignHook = ::std::option::Option<
    unsafe extern "C" fn(newval: *const ::std::os::raw::c_char, extra: *mut ::std::os::raw::c_void),
>;
pub type GucEnumAssignHook = ::std::option::Option<
    unsafe extern "C" fn(newval: ::std::os::raw::c_int, extra: *mut ::std::os::raw::c_void),
>;
pub type GucShowHook =
    ::std::option::Option<unsafe extern "C" fn() -> *const ::std::os::raw::c_char>;
pub const GucAction_GUC_ACTION_SET: GucAction = 0;
pub const GucAction_GUC_ACTION_LOCAL: GucAction = 1;
pub const GucAction_GUC_ACTION_SAVE: GucAction = 2;
pub type GucAction = ::std::os::raw::c_uint;
extern "C" {
    pub static mut Debug_print_plan: bool;
}
extern "C" {
    pub static mut Debug_print_parse: bool;
}
extern "C" {
    pub static mut Debug_print_rewritten: bool;
}
extern "C" {
    pub static mut Debug_pretty_print: bool;
}
extern "C" {
    pub static mut log_parser_stats: bool;
}
extern "C" {
    pub static mut log_planner_stats: bool;
}
extern "C" {
    pub static mut log_executor_stats: bool;
}
extern "C" {
    pub static mut log_statement_stats: bool;
}
extern "C" {
    pub static mut log_btree_build_stats: bool;
}
extern "C" {
    pub static mut check_function_bodies: bool;
}
extern "C" {
    pub static mut session_auth_is_superuser: bool;
}
extern "C" {
    pub static mut log_duration: bool;
}
extern "C" {
    pub static mut log_parameter_max_length: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut log_parameter_max_length_on_error: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut log_min_error_statement: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut log_min_messages: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut client_min_messages: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut log_min_duration_sample: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut log_min_duration_statement: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut log_temp_files: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut log_statement_sample_rate: f64;
}
extern "C" {
    pub static mut log_xact_sample_rate: f64;
}
extern "C" {
    pub static mut backtrace_functions: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut backtrace_symbol_list: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut temp_file_limit: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut num_temp_buffers: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut cluster_name: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut ConfigFileName: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut HbaFileName: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut IdentFileName: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut external_pid_file: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut application_name: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut tcp_keepalives_idle: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut tcp_keepalives_interval: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut tcp_keepalives_count: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut tcp_user_timeout: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut trace_sort: bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SetConfigOption(
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        context: GucContext,
        source: GucSource,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DefineCustomBoolVariable(
        name: *const ::std::os::raw::c_char,
        short_desc: *const ::std::os::raw::c_char,
        long_desc: *const ::std::os::raw::c_char,
        valueAddr: *mut bool,
        bootValue: bool,
        context: GucContext,
        flags: ::std::os::raw::c_int,
        check_hook: GucBoolCheckHook,
        assign_hook: GucBoolAssignHook,
        show_hook: GucShowHook,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DefineCustomIntVariable(
        name: *const ::std::os::raw::c_char,
        short_desc: *const ::std::os::raw::c_char,
        long_desc: *const ::std::os::raw::c_char,
        valueAddr: *mut ::std::os::raw::c_int,
        bootValue: ::std::os::raw::c_int,
        minValue: ::std::os::raw::c_int,
        maxValue: ::std::os::raw::c_int,
        context: GucContext,
        flags: ::std::os::raw::c_int,
        check_hook: GucIntCheckHook,
        assign_hook: GucIntAssignHook,
        show_hook: GucShowHook,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DefineCustomRealVariable(
        name: *const ::std::os::raw::c_char,
        short_desc: *const ::std::os::raw::c_char,
        long_desc: *const ::std::os::raw::c_char,
        valueAddr: *mut f64,
        bootValue: f64,
        minValue: f64,
        maxValue: f64,
        context: GucContext,
        flags: ::std::os::raw::c_int,
        check_hook: GucRealCheckHook,
        assign_hook: GucRealAssignHook,
        show_hook: GucShowHook,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DefineCustomStringVariable(
        name: *const ::std::os::raw::c_char,
        short_desc: *const ::std::os::raw::c_char,
        long_desc: *const ::std::os::raw::c_char,
        valueAddr: *mut *mut ::std::os::raw::c_char,
        bootValue: *const ::std::os::raw::c_char,
        context: GucContext,
        flags: ::std::os::raw::c_int,
        check_hook: GucStringCheckHook,
        assign_hook: GucStringAssignHook,
        show_hook: GucShowHook,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DefineCustomEnumVariable(
        name: *const ::std::os::raw::c_char,
        short_desc: *const ::std::os::raw::c_char,
        long_desc: *const ::std::os::raw::c_char,
        valueAddr: *mut ::std::os::raw::c_int,
        bootValue: ::std::os::raw::c_int,
        options: *const config_enum_entry,
        context: GucContext,
        flags: ::std::os::raw::c_int,
        check_hook: GucEnumCheckHook,
        assign_hook: GucEnumAssignHook,
        show_hook: GucShowHook,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EmitWarningsOnPlaceholders(className: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetConfigOption(
        name: *const ::std::os::raw::c_char,
        missing_ok: bool,
        restrict_privileged: bool,
    ) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetConfigOptionResetString(
        name: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetConfigOptionFlags(
        name: *const ::std::os::raw::c_char,
        missing_ok: bool,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ProcessConfigFile(context: GucContext);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitializeGUCOptions();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SelectConfigFiles(
        userDoption: *const ::std::os::raw::c_char,
        progname: *const ::std::os::raw::c_char,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ResetAllOptions();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AtStart_GUC();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn NewGUCNestLevel() -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AtEOXact_GUC(isCommit: bool, nestLevel: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BeginReportingGUCOptions();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ParseLongOption(
        string: *const ::std::os::raw::c_char,
        name: *mut *mut ::std::os::raw::c_char,
        value: *mut *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn parse_int(
        value: *const ::std::os::raw::c_char,
        result: *mut ::std::os::raw::c_int,
        flags: ::std::os::raw::c_int,
        hintmsg: *mut *const ::std::os::raw::c_char,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn parse_real(
        value: *const ::std::os::raw::c_char,
        result: *mut f64,
        flags: ::std::os::raw::c_int,
        hintmsg: *mut *const ::std::os::raw::c_char,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn set_config_option(
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        context: GucContext,
        source: GucSource,
        action: GucAction,
        changeVal: bool,
        elevel: ::std::os::raw::c_int,
        is_reload: bool,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AlterSystemSetConfigFile(altersysstmt: *mut AlterSystemStmt);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetConfigOptionByName(
        name: *const ::std::os::raw::c_char,
        varname: *mut *const ::std::os::raw::c_char,
        missing_ok: bool,
    ) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetConfigOptionByNum(
        varnum: ::std::os::raw::c_int,
        values: *mut *const ::std::os::raw::c_char,
        noshow: *mut bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetNumConfigOptions() -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SetPGVariable(name: *const ::std::os::raw::c_char, args: *mut List, is_local: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetPGVariable(name: *const ::std::os::raw::c_char, dest: *mut DestReceiver);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetPGVariableResultDesc(name: *const ::std::os::raw::c_char) -> TupleDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExecSetVariableStmt(stmt: *mut VariableSetStmt, isTopLevel: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExtractSetVariableArgs(stmt: *mut VariableSetStmt) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ProcessGUCArray(
        array: *mut ArrayType,
        context: GucContext,
        source: GucSource,
        action: GucAction,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GUCArrayAdd(
        array: *mut ArrayType,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
    ) -> *mut ArrayType;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GUCArrayDelete(
        array: *mut ArrayType,
        name: *const ::std::os::raw::c_char,
    ) -> *mut ArrayType;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GUCArrayReset(array: *mut ArrayType) -> *mut ArrayType;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EstimateGUCStateSpace() -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SerializeGUCState(maxsize: Size, start_address: *mut ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RestoreGUCState(gucstate: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub static mut GUC_check_errmsg_string: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut GUC_check_errdetail_string: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut GUC_check_errhint_string: *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GUC_check_errcode(sqlerrcode: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn check_default_tablespace(
        newval: *mut *mut ::std::os::raw::c_char,
        extra: *mut *mut ::std::os::raw::c_void,
        source: GucSource,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn check_temp_tablespaces(
        newval: *mut *mut ::std::os::raw::c_char,
        extra: *mut *mut ::std::os::raw::c_void,
        source: GucSource,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn assign_temp_tablespaces(
        newval: *const ::std::os::raw::c_char,
        extra: *mut ::std::os::raw::c_void,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn check_search_path(
        newval: *mut *mut ::std::os::raw::c_char,
        extra: *mut *mut ::std::os::raw::c_void,
        source: GucSource,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn assign_search_path(
        newval: *const ::std::os::raw::c_char,
        extra: *mut ::std::os::raw::c_void,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn check_wal_buffers(
        newval: *mut ::std::os::raw::c_int,
        extra: *mut *mut ::std::os::raw::c_void,
        source: GucSource,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn assign_xlog_sync_method(
        new_sync_method: ::std::os::raw::c_int,
        extra: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub static mut default_table_access_method: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut synchronize_seqscans: bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BulkInsertStateData {
    _unused: [u8; 0],
}
pub const ScanOptions_SO_TYPE_SEQSCAN: ScanOptions = 1;
pub const ScanOptions_SO_TYPE_BITMAPSCAN: ScanOptions = 2;
pub const ScanOptions_SO_TYPE_SAMPLESCAN: ScanOptions = 4;
pub const ScanOptions_SO_TYPE_TIDSCAN: ScanOptions = 8;
pub const ScanOptions_SO_TYPE_ANALYZE: ScanOptions = 16;
pub const ScanOptions_SO_ALLOW_STRAT: ScanOptions = 32;
pub const ScanOptions_SO_ALLOW_SYNC: ScanOptions = 64;
pub const ScanOptions_SO_ALLOW_PAGEMODE: ScanOptions = 128;
pub const ScanOptions_SO_TEMP_SNAPSHOT: ScanOptions = 256;
pub type ScanOptions = ::std::os::raw::c_uint;
pub const TM_Result_TM_Ok: TM_Result = 0;
pub const TM_Result_TM_Invisible: TM_Result = 1;
pub const TM_Result_TM_SelfModified: TM_Result = 2;
pub const TM_Result_TM_Updated: TM_Result = 3;
pub const TM_Result_TM_Deleted: TM_Result = 4;
pub const TM_Result_TM_BeingModified: TM_Result = 5;
pub const TM_Result_TM_WouldBlock: TM_Result = 6;
pub type TM_Result = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TM_FailureData {
    pub ctid: ItemPointerData,
    pub xmax: TransactionId,
    pub cmax: CommandId,
    pub traversed: bool,
}
pub type IndexBuildCallback = ::std::option::Option<
    unsafe extern "C" fn(
        index: Relation,
        tid: ItemPointer,
        values: *mut Datum,
        isnull: *mut bool,
        tupleIsAlive: bool,
        state: *mut ::std::os::raw::c_void,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TableAmRoutine {
    pub type_: NodeTag,
    pub slot_callbacks:
        ::std::option::Option<unsafe extern "C" fn(rel: Relation) -> *const TupleTableSlotOps>,
    pub scan_begin: ::std::option::Option<
        unsafe extern "C" fn(
            rel: Relation,
            snapshot: Snapshot,
            nkeys: ::std::os::raw::c_int,
            key: *mut ScanKeyData,
            pscan: ParallelTableScanDesc,
            flags: uint32,
        ) -> TableScanDesc,
    >,
    pub scan_end: ::std::option::Option<unsafe extern "C" fn(scan: TableScanDesc)>,
    pub scan_rescan: ::std::option::Option<
        unsafe extern "C" fn(
            scan: TableScanDesc,
            key: *mut ScanKeyData,
            set_params: bool,
            allow_strat: bool,
            allow_sync: bool,
            allow_pagemode: bool,
        ),
    >,
    pub scan_getnextslot: ::std::option::Option<
        unsafe extern "C" fn(
            scan: TableScanDesc,
            direction: ScanDirection,
            slot: *mut TupleTableSlot,
        ) -> bool,
    >,
    pub parallelscan_estimate: ::std::option::Option<unsafe extern "C" fn(rel: Relation) -> Size>,
    pub parallelscan_initialize: ::std::option::Option<
        unsafe extern "C" fn(rel: Relation, pscan: ParallelTableScanDesc) -> Size,
    >,
    pub parallelscan_reinitialize:
        ::std::option::Option<unsafe extern "C" fn(rel: Relation, pscan: ParallelTableScanDesc)>,
    pub index_fetch_begin:
        ::std::option::Option<unsafe extern "C" fn(rel: Relation) -> *mut IndexFetchTableData>,
    pub index_fetch_reset:
        ::std::option::Option<unsafe extern "C" fn(data: *mut IndexFetchTableData)>,
    pub index_fetch_end:
        ::std::option::Option<unsafe extern "C" fn(data: *mut IndexFetchTableData)>,
    pub index_fetch_tuple: ::std::option::Option<
        unsafe extern "C" fn(
            scan: *mut IndexFetchTableData,
            tid: ItemPointer,
            snapshot: Snapshot,
            slot: *mut TupleTableSlot,
            call_again: *mut bool,
            all_dead: *mut bool,
        ) -> bool,
    >,
    pub tuple_fetch_row_version: ::std::option::Option<
        unsafe extern "C" fn(
            rel: Relation,
            tid: ItemPointer,
            snapshot: Snapshot,
            slot: *mut TupleTableSlot,
        ) -> bool,
    >,
    pub tuple_tid_valid:
        ::std::option::Option<unsafe extern "C" fn(scan: TableScanDesc, tid: ItemPointer) -> bool>,
    pub tuple_get_latest_tid:
        ::std::option::Option<unsafe extern "C" fn(scan: TableScanDesc, tid: ItemPointer)>,
    pub tuple_satisfies_snapshot: ::std::option::Option<
        unsafe extern "C" fn(rel: Relation, slot: *mut TupleTableSlot, snapshot: Snapshot) -> bool,
    >,
    pub compute_xid_horizon_for_tuples: ::std::option::Option<
        unsafe extern "C" fn(
            rel: Relation,
            items: *mut ItemPointerData,
            nitems: ::std::os::raw::c_int,
        ) -> TransactionId,
    >,
    pub tuple_insert: ::std::option::Option<
        unsafe extern "C" fn(
            rel: Relation,
            slot: *mut TupleTableSlot,
            cid: CommandId,
            options: ::std::os::raw::c_int,
            bistate: *mut BulkInsertStateData,
        ),
    >,
    pub tuple_insert_speculative: ::std::option::Option<
        unsafe extern "C" fn(
            rel: Relation,
            slot: *mut TupleTableSlot,
            cid: CommandId,
            options: ::std::os::raw::c_int,
            bistate: *mut BulkInsertStateData,
            specToken: uint32,
        ),
    >,
    pub tuple_complete_speculative: ::std::option::Option<
        unsafe extern "C" fn(
            rel: Relation,
            slot: *mut TupleTableSlot,
            specToken: uint32,
            succeeded: bool,
        ),
    >,
    pub multi_insert: ::std::option::Option<
        unsafe extern "C" fn(
            rel: Relation,
            slots: *mut *mut TupleTableSlot,
            nslots: ::std::os::raw::c_int,
            cid: CommandId,
            options: ::std::os::raw::c_int,
            bistate: *mut BulkInsertStateData,
        ),
    >,
    pub tuple_delete: ::std::option::Option<
        unsafe extern "C" fn(
            rel: Relation,
            tid: ItemPointer,
            cid: CommandId,
            snapshot: Snapshot,
            crosscheck: Snapshot,
            wait: bool,
            tmfd: *mut TM_FailureData,
            changingPart: bool,
        ) -> TM_Result,
    >,
    pub tuple_update: ::std::option::Option<
        unsafe extern "C" fn(
            rel: Relation,
            otid: ItemPointer,
            slot: *mut TupleTableSlot,
            cid: CommandId,
            snapshot: Snapshot,
            crosscheck: Snapshot,
            wait: bool,
            tmfd: *mut TM_FailureData,
            lockmode: *mut LockTupleMode,
            update_indexes: *mut bool,
        ) -> TM_Result,
    >,
    pub tuple_lock: ::std::option::Option<
        unsafe extern "C" fn(
            rel: Relation,
            tid: ItemPointer,
            snapshot: Snapshot,
            slot: *mut TupleTableSlot,
            cid: CommandId,
            mode: LockTupleMode,
            wait_policy: LockWaitPolicy,
            flags: uint8,
            tmfd: *mut TM_FailureData,
        ) -> TM_Result,
    >,
    pub finish_bulk_insert:
        ::std::option::Option<unsafe extern "C" fn(rel: Relation, options: ::std::os::raw::c_int)>,
    pub relation_set_new_filenode: ::std::option::Option<
        unsafe extern "C" fn(
            rel: Relation,
            newrnode: *const RelFileNode,
            persistence: ::std::os::raw::c_char,
            freezeXid: *mut TransactionId,
            minmulti: *mut MultiXactId,
        ),
    >,
    pub relation_nontransactional_truncate:
        ::std::option::Option<unsafe extern "C" fn(rel: Relation)>,
    pub relation_copy_data:
        ::std::option::Option<unsafe extern "C" fn(rel: Relation, newrnode: *const RelFileNode)>,
    pub relation_copy_for_cluster: ::std::option::Option<
        unsafe extern "C" fn(
            NewTable: Relation,
            OldTable: Relation,
            OldIndex: Relation,
            use_sort: bool,
            OldestXmin: TransactionId,
            xid_cutoff: *mut TransactionId,
            multi_cutoff: *mut MultiXactId,
            num_tuples: *mut f64,
            tups_vacuumed: *mut f64,
            tups_recently_dead: *mut f64,
        ),
    >,
    pub relation_vacuum: ::std::option::Option<
        unsafe extern "C" fn(
            onerel: Relation,
            params: *mut VacuumParams,
            bstrategy: BufferAccessStrategy,
        ),
    >,
    pub scan_analyze_next_block: ::std::option::Option<
        unsafe extern "C" fn(
            scan: TableScanDesc,
            blockno: BlockNumber,
            bstrategy: BufferAccessStrategy,
        ) -> bool,
    >,
    pub scan_analyze_next_tuple: ::std::option::Option<
        unsafe extern "C" fn(
            scan: TableScanDesc,
            OldestXmin: TransactionId,
            liverows: *mut f64,
            deadrows: *mut f64,
            slot: *mut TupleTableSlot,
        ) -> bool,
    >,
    pub index_build_range_scan: ::std::option::Option<
        unsafe extern "C" fn(
            table_rel: Relation,
            index_rel: Relation,
            index_info: *mut IndexInfo,
            allow_sync: bool,
            anyvisible: bool,
            progress: bool,
            start_blockno: BlockNumber,
            numblocks: BlockNumber,
            callback: IndexBuildCallback,
            callback_state: *mut ::std::os::raw::c_void,
            scan: TableScanDesc,
        ) -> f64,
    >,
    pub index_validate_scan: ::std::option::Option<
        unsafe extern "C" fn(
            table_rel: Relation,
            index_rel: Relation,
            index_info: *mut IndexInfo,
            snapshot: Snapshot,
            state: *mut ValidateIndexState,
        ),
    >,
    pub relation_size: ::std::option::Option<
        unsafe extern "C" fn(rel: Relation, forkNumber: ForkNumber) -> uint64,
    >,
    pub relation_needs_toast_table:
        ::std::option::Option<unsafe extern "C" fn(rel: Relation) -> bool>,
    pub relation_toast_am: ::std::option::Option<unsafe extern "C" fn(rel: Relation) -> Oid>,
    pub relation_fetch_toast_slice: ::std::option::Option<
        unsafe extern "C" fn(
            toastrel: Relation,
            valueid: Oid,
            attrsize: int32,
            sliceoffset: int32,
            slicelength: int32,
            result: *mut varlena,
        ),
    >,
    pub relation_estimate_size: ::std::option::Option<
        unsafe extern "C" fn(
            rel: Relation,
            attr_widths: *mut int32,
            pages: *mut BlockNumber,
            tuples: *mut f64,
            allvisfrac: *mut f64,
        ),
    >,
    pub scan_bitmap_next_block: ::std::option::Option<
        unsafe extern "C" fn(scan: TableScanDesc, tbmres: *mut TBMIterateResult) -> bool,
    >,
    pub scan_bitmap_next_tuple: ::std::option::Option<
        unsafe extern "C" fn(
            scan: TableScanDesc,
            tbmres: *mut TBMIterateResult,
            slot: *mut TupleTableSlot,
        ) -> bool,
    >,
    pub scan_sample_next_block: ::std::option::Option<
        unsafe extern "C" fn(scan: TableScanDesc, scanstate: *mut SampleScanState) -> bool,
    >,
    pub scan_sample_next_tuple: ::std::option::Option<
        unsafe extern "C" fn(
            scan: TableScanDesc,
            scanstate: *mut SampleScanState,
            slot: *mut TupleTableSlot,
        ) -> bool,
    >,
}
impl Default for TableAmRoutine {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_slot_callbacks(rel: Relation) -> *const TupleTableSlotOps;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_slot_create(rel: Relation, reglist: *mut *mut List) -> *mut TupleTableSlot;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_beginscan_catalog(
        rel: Relation,
        nkeys: ::std::os::raw::c_int,
        key: *mut ScanKeyData,
    ) -> TableScanDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_scan_update_snapshot(scan: TableScanDesc, snapshot: Snapshot);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_parallelscan_estimate(rel: Relation, snapshot: Snapshot) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_parallelscan_initialize(
        rel: Relation,
        pscan: ParallelTableScanDesc,
        snapshot: Snapshot,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_beginscan_parallel(rel: Relation, pscan: ParallelTableScanDesc) -> TableScanDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_index_fetch_tuple_check(
        rel: Relation,
        tid: ItemPointer,
        snapshot: Snapshot,
        all_dead: *mut bool,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_tuple_get_latest_tid(scan: TableScanDesc, tid: ItemPointer);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn simple_table_tuple_insert(rel: Relation, slot: *mut TupleTableSlot);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn simple_table_tuple_delete(rel: Relation, tid: ItemPointer, snapshot: Snapshot);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn simple_table_tuple_update(
        rel: Relation,
        otid: ItemPointer,
        slot: *mut TupleTableSlot,
        snapshot: Snapshot,
        update_indexes: *mut bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_block_parallelscan_estimate(rel: Relation) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_block_parallelscan_initialize(rel: Relation, pscan: ParallelTableScanDesc)
        -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_block_parallelscan_reinitialize(rel: Relation, pscan: ParallelTableScanDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_block_parallelscan_nextpage(
        rel: Relation,
        pbscan: ParallelBlockTableScanDesc,
    ) -> BlockNumber;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_block_parallelscan_startblock_init(
        rel: Relation,
        pbscan: ParallelBlockTableScanDesc,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_block_relation_size(rel: Relation, forkNumber: ForkNumber) -> uint64;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn table_block_relation_estimate_size(
        rel: Relation,
        attr_widths: *mut int32,
        pages: *mut BlockNumber,
        tuples: *mut f64,
        allvisfrac: *mut f64,
        overhead_bytes_per_tuple: Size,
        usable_bytes_per_page: Size,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetTableAmRoutine(amhandler: Oid) -> *const TableAmRoutine;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetHeapamTableAmRoutine() -> *const TableAmRoutine;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn check_default_table_access_method(
        newval: *mut *mut ::std::os::raw::c_char,
        extra: *mut *mut ::std::os::raw::c_void,
        source: GucSource,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct shm_toc {
    _unused: [u8; 0],
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn shm_toc_create(
        magic: uint64,
        address: *mut ::std::os::raw::c_void,
        nbytes: Size,
    ) -> *mut shm_toc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn shm_toc_attach(magic: uint64, address: *mut ::std::os::raw::c_void) -> *mut shm_toc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn shm_toc_allocate(toc: *mut shm_toc, nbytes: Size) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn shm_toc_freespace(toc: *mut shm_toc) -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn shm_toc_insert(toc: *mut shm_toc, key: uint64, address: *mut ::std::os::raw::c_void);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn shm_toc_lookup(
        toc: *mut shm_toc,
        key: uint64,
        noError: bool,
    ) -> *mut ::std::os::raw::c_void;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct shm_toc_estimator {
    pub space_for_chunks: Size,
    pub number_of_keys: Size,
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn shm_toc_estimate(e: *mut shm_toc_estimator) -> Size;
}
pub type BulkInsertState = *mut BulkInsertStateData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HeapScanDescData {
    pub rs_base: TableScanDescData,
    pub rs_nblocks: BlockNumber,
    pub rs_startblock: BlockNumber,
    pub rs_numblocks: BlockNumber,
    pub rs_inited: bool,
    pub rs_cblock: BlockNumber,
    pub rs_cbuf: Buffer,
    pub rs_strategy: BufferAccessStrategy,
    pub rs_ctup: HeapTupleData,
    pub rs_cindex: ::std::os::raw::c_int,
    pub rs_ntuples: ::std::os::raw::c_int,
    pub rs_vistuples: [OffsetNumber; 291usize],
}
impl Default for HeapScanDescData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type HeapScanDesc = *mut HeapScanDescData;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IndexFetchHeapData {
    pub xs_base: IndexFetchTableData,
    pub xs_cbuf: Buffer,
}
impl Default for IndexFetchHeapData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const HTSV_Result_HEAPTUPLE_DEAD: HTSV_Result = 0;
pub const HTSV_Result_HEAPTUPLE_LIVE: HTSV_Result = 1;
pub const HTSV_Result_HEAPTUPLE_RECENTLY_DEAD: HTSV_Result = 2;
pub const HTSV_Result_HEAPTUPLE_INSERT_IN_PROGRESS: HTSV_Result = 3;
pub const HTSV_Result_HEAPTUPLE_DELETE_IN_PROGRESS: HTSV_Result = 4;
pub type HTSV_Result = ::std::os::raw::c_uint;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_beginscan(
        relation: Relation,
        snapshot: Snapshot,
        nkeys: ::std::os::raw::c_int,
        key: ScanKey,
        parallel_scan: ParallelTableScanDesc,
        flags: uint32,
    ) -> TableScanDesc;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_setscanlimits(scan: TableScanDesc, startBlk: BlockNumber, numBlks: BlockNumber);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heapgetpage(scan: TableScanDesc, page: BlockNumber);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_rescan(
        scan: TableScanDesc,
        key: ScanKey,
        set_params: bool,
        allow_strat: bool,
        allow_sync: bool,
        allow_pagemode: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_endscan(scan: TableScanDesc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_getnext(scan: TableScanDesc, direction: ScanDirection) -> HeapTuple;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_getnextslot(
        sscan: TableScanDesc,
        direction: ScanDirection,
        slot: *mut TupleTableSlot,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_fetch(
        relation: Relation,
        snapshot: Snapshot,
        tuple: HeapTuple,
        userbuf: *mut Buffer,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_fetch_extended(
        relation: Relation,
        snapshot: Snapshot,
        tuple: HeapTuple,
        userbuf: *mut Buffer,
        keep_buf: bool,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_hot_search_buffer(
        tid: ItemPointer,
        relation: Relation,
        buffer: Buffer,
        snapshot: Snapshot,
        heapTuple: HeapTuple,
        all_dead: *mut bool,
        first_call: bool,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_get_latest_tid(scan: TableScanDesc, tid: ItemPointer);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn setLastTid(tid: ItemPointer);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetBulkInsertState() -> BulkInsertState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FreeBulkInsertState(arg1: BulkInsertState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ReleaseBulkInsertStatePin(bistate: BulkInsertState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_insert(
        relation: Relation,
        tup: HeapTuple,
        cid: CommandId,
        options: ::std::os::raw::c_int,
        bistate: BulkInsertState,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_multi_insert(
        relation: Relation,
        slots: *mut *mut TupleTableSlot,
        ntuples: ::std::os::raw::c_int,
        cid: CommandId,
        options: ::std::os::raw::c_int,
        bistate: BulkInsertState,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_delete(
        relation: Relation,
        tid: ItemPointer,
        cid: CommandId,
        crosscheck: Snapshot,
        wait: bool,
        tmfd: *mut TM_FailureData,
        changingPart: bool,
    ) -> TM_Result;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_finish_speculative(relation: Relation, tid: ItemPointer);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_abort_speculative(relation: Relation, tid: ItemPointer);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_update(
        relation: Relation,
        otid: ItemPointer,
        newtup: HeapTuple,
        cid: CommandId,
        crosscheck: Snapshot,
        wait: bool,
        tmfd: *mut TM_FailureData,
        lockmode: *mut LockTupleMode,
    ) -> TM_Result;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_lock_tuple(
        relation: Relation,
        tuple: HeapTuple,
        cid: CommandId,
        mode: LockTupleMode,
        wait_policy: LockWaitPolicy,
        follow_update: bool,
        buffer: *mut Buffer,
        tmfd: *mut TM_FailureData,
    ) -> TM_Result;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_inplace_update(relation: Relation, tuple: HeapTuple);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_freeze_tuple(
        tuple: HeapTupleHeader,
        relfrozenxid: TransactionId,
        relminmxid: TransactionId,
        cutoff_xid: TransactionId,
        cutoff_multi: TransactionId,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_tuple_needs_freeze(
        tuple: HeapTupleHeader,
        cutoff_xid: TransactionId,
        cutoff_multi: MultiXactId,
        buf: Buffer,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_tuple_needs_eventual_freeze(tuple: HeapTupleHeader) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn simple_heap_insert(relation: Relation, tup: HeapTuple);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn simple_heap_delete(relation: Relation, tid: ItemPointer);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn simple_heap_update(relation: Relation, otid: ItemPointer, tup: HeapTuple);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_compute_xid_horizon_for_tuples(
        rel: Relation,
        items: *mut ItemPointerData,
        nitems: ::std::os::raw::c_int,
    ) -> TransactionId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_page_prune_opt(relation: Relation, buffer: Buffer);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_page_prune(
        relation: Relation,
        buffer: Buffer,
        OldestXmin: TransactionId,
        report_stats: bool,
        latestRemovedXid: *mut TransactionId,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_page_prune_execute(
        buffer: Buffer,
        redirected: *mut OffsetNumber,
        nredirected: ::std::os::raw::c_int,
        nowdead: *mut OffsetNumber,
        ndead: ::std::os::raw::c_int,
        nowunused: *mut OffsetNumber,
        nunused: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_get_root_tuples(page: Page, root_offsets: *mut OffsetNumber);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ss_report_location(rel: Relation, location: BlockNumber);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ss_get_location(rel: Relation, relnblocks: BlockNumber) -> BlockNumber;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SyncScanShmemInit();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SyncScanShmemSize() -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_vacuum_rel(
        onerel: Relation,
        params: *mut VacuumParams,
        bstrategy: BufferAccessStrategy,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn parallel_vacuum_main(seg: *mut dsm_segment, toc: *mut shm_toc);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn HeapTupleSatisfiesVisibility(
        stup: HeapTuple,
        snapshot: Snapshot,
        buffer: Buffer,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn HeapTupleSatisfiesUpdate(
        stup: HeapTuple,
        curcid: CommandId,
        buffer: Buffer,
    ) -> TM_Result;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn HeapTupleSatisfiesVacuum(
        stup: HeapTuple,
        OldestXmin: TransactionId,
        buffer: Buffer,
    ) -> HTSV_Result;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn HeapTupleSetHintBits(
        tuple: HeapTupleHeader,
        buffer: Buffer,
        infomask: uint16,
        xid: TransactionId,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn HeapTupleHeaderIsOnlyLocked(tuple: HeapTupleHeader) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XidInMVCCSnapshot(xid: TransactionId, snapshot: Snapshot) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn HeapTupleIsSurelyDead(htup: HeapTuple, OldestXmin: TransactionId) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ResolveCminCmaxDuringDecoding(
        tuplecid_data: *mut HTAB,
        snapshot: Snapshot,
        htup: HeapTuple,
        buffer: Buffer,
        cmin: *mut CommandId,
        cmax: *mut CommandId,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn HeapCheckForSerializableConflictOut(
        valid: bool,
        relation: Relation,
        tuple: HeapTuple,
        buffer: Buffer,
        snapshot: Snapshot,
    );
}
pub const relopt_type_RELOPT_TYPE_BOOL: relopt_type = 0;
pub const relopt_type_RELOPT_TYPE_INT: relopt_type = 1;
pub const relopt_type_RELOPT_TYPE_REAL: relopt_type = 2;
pub const relopt_type_RELOPT_TYPE_ENUM: relopt_type = 3;
pub const relopt_type_RELOPT_TYPE_STRING: relopt_type = 4;
pub type relopt_type = ::std::os::raw::c_uint;
pub const relopt_kind_RELOPT_KIND_LOCAL: relopt_kind = 0;
pub const relopt_kind_RELOPT_KIND_HEAP: relopt_kind = 1;
pub const relopt_kind_RELOPT_KIND_TOAST: relopt_kind = 2;
pub const relopt_kind_RELOPT_KIND_BTREE: relopt_kind = 4;
pub const relopt_kind_RELOPT_KIND_HASH: relopt_kind = 8;
pub const relopt_kind_RELOPT_KIND_GIN: relopt_kind = 16;
pub const relopt_kind_RELOPT_KIND_GIST: relopt_kind = 32;
pub const relopt_kind_RELOPT_KIND_ATTRIBUTE: relopt_kind = 64;
pub const relopt_kind_RELOPT_KIND_TABLESPACE: relopt_kind = 128;
pub const relopt_kind_RELOPT_KIND_SPGIST: relopt_kind = 256;
pub const relopt_kind_RELOPT_KIND_VIEW: relopt_kind = 512;
pub const relopt_kind_RELOPT_KIND_BRIN: relopt_kind = 1024;
pub const relopt_kind_RELOPT_KIND_PARTITIONED: relopt_kind = 2048;
pub const relopt_kind_RELOPT_KIND_LAST_DEFAULT: relopt_kind = 2048;
pub const relopt_kind_RELOPT_KIND_MAX: relopt_kind = 1073741824;
pub type relopt_kind = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_gen {
    pub name: *const ::std::os::raw::c_char,
    pub desc: *const ::std::os::raw::c_char,
    pub kinds: bits32,
    pub lockmode: LOCKMODE,
    pub namelen: ::std::os::raw::c_int,
    pub type_: relopt_type,
}
impl Default for relopt_gen {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct relopt_value {
    pub gen: *mut relopt_gen,
    pub isset: bool,
    pub values: relopt_value__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union relopt_value__bindgen_ty_1 {
    pub bool_val: bool,
    pub int_val: ::std::os::raw::c_int,
    pub real_val: f64,
    pub enum_val: ::std::os::raw::c_int,
    pub string_val: *mut ::std::os::raw::c_char,
}
impl Default for relopt_value__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl Default for relopt_value {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_bool {
    pub gen: relopt_gen,
    pub default_val: bool,
}
impl Default for relopt_bool {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_int {
    pub gen: relopt_gen,
    pub default_val: ::std::os::raw::c_int,
    pub min: ::std::os::raw::c_int,
    pub max: ::std::os::raw::c_int,
}
impl Default for relopt_int {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_real {
    pub gen: relopt_gen,
    pub default_val: f64,
    pub min: f64,
    pub max: f64,
}
impl Default for relopt_real {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_enum_elt_def {
    pub string_val: *const ::std::os::raw::c_char,
    pub symbol_val: ::std::os::raw::c_int,
}
impl Default for relopt_enum_elt_def {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_enum {
    pub gen: relopt_gen,
    pub members: *mut relopt_enum_elt_def,
    pub default_val: ::std::os::raw::c_int,
    pub detailmsg: *const ::std::os::raw::c_char,
}
impl Default for relopt_enum {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type validate_string_relopt =
    ::std::option::Option<unsafe extern "C" fn(value: *const ::std::os::raw::c_char)>;
pub type fill_string_relopt = ::std::option::Option<
    unsafe extern "C" fn(
        value: *const ::std::os::raw::c_char,
        ptr: *mut ::std::os::raw::c_void,
    ) -> Size,
>;
pub type relopts_validator = ::std::option::Option<
    unsafe extern "C" fn(
        parsed_options: *mut ::std::os::raw::c_void,
        vals: *mut relopt_value,
        nvals: ::std::os::raw::c_int,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_string {
    pub gen: relopt_gen,
    pub default_len: ::std::os::raw::c_int,
    pub default_isnull: bool,
    pub validate_cb: validate_string_relopt,
    pub fill_cb: fill_string_relopt,
    pub default_val: *mut ::std::os::raw::c_char,
}
impl Default for relopt_string {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct relopt_parse_elt {
    pub optname: *const ::std::os::raw::c_char,
    pub opttype: relopt_type,
    pub offset: ::std::os::raw::c_int,
}
impl Default for relopt_parse_elt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct local_relopt {
    pub option: *mut relopt_gen,
    pub offset: ::std::os::raw::c_int,
}
impl Default for local_relopt {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct local_relopts {
    pub options: *mut List,
    pub validators: *mut List,
    pub relopt_struct_size: Size,
}
impl Default for local_relopts {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn add_reloption_kind() -> relopt_kind;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn add_bool_reloption(
        kinds: bits32,
        name: *const ::std::os::raw::c_char,
        desc: *const ::std::os::raw::c_char,
        default_val: bool,
        lockmode: LOCKMODE,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn add_int_reloption(
        kinds: bits32,
        name: *const ::std::os::raw::c_char,
        desc: *const ::std::os::raw::c_char,
        default_val: ::std::os::raw::c_int,
        min_val: ::std::os::raw::c_int,
        max_val: ::std::os::raw::c_int,
        lockmode: LOCKMODE,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn add_real_reloption(
        kinds: bits32,
        name: *const ::std::os::raw::c_char,
        desc: *const ::std::os::raw::c_char,
        default_val: f64,
        min_val: f64,
        max_val: f64,
        lockmode: LOCKMODE,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn add_enum_reloption(
        kinds: bits32,
        name: *const ::std::os::raw::c_char,
        desc: *const ::std::os::raw::c_char,
        members: *mut relopt_enum_elt_def,
        default_val: ::std::os::raw::c_int,
        detailmsg: *const ::std::os::raw::c_char,
        lockmode: LOCKMODE,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn add_string_reloption(
        kinds: bits32,
        name: *const ::std::os::raw::c_char,
        desc: *const ::std::os::raw::c_char,
        default_val: *const ::std::os::raw::c_char,
        validator: validate_string_relopt,
        lockmode: LOCKMODE,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn init_local_reloptions(opts: *mut local_relopts, relopt_struct_size: Size);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn register_reloptions_validator(opts: *mut local_relopts, validator: relopts_validator);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn add_local_bool_reloption(
        opts: *mut local_relopts,
        name: *const ::std::os::raw::c_char,
        desc: *const ::std::os::raw::c_char,
        default_val: bool,
        offset: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn add_local_int_reloption(
        opts: *mut local_relopts,
        name: *const ::std::os::raw::c_char,
        desc: *const ::std::os::raw::c_char,
        default_val: ::std::os::raw::c_int,
        min_val: ::std::os::raw::c_int,
        max_val: ::std::os::raw::c_int,
        offset: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn add_local_real_reloption(
        opts: *mut local_relopts,
        name: *const ::std::os::raw::c_char,
        desc: *const ::std::os::raw::c_char,
        default_val: f64,
        min_val: f64,
        max_val: f64,
        offset: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn add_local_enum_reloption(
        relopts: *mut local_relopts,
        name: *const ::std::os::raw::c_char,
        desc: *const ::std::os::raw::c_char,
        members: *mut relopt_enum_elt_def,
        default_val: ::std::os::raw::c_int,
        detailmsg: *const ::std::os::raw::c_char,
        offset: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn add_local_string_reloption(
        opts: *mut local_relopts,
        name: *const ::std::os::raw::c_char,
        desc: *const ::std::os::raw::c_char,
        default_val: *const ::std::os::raw::c_char,
        validator: validate_string_relopt,
        filler: fill_string_relopt,
        offset: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn transformRelOptions(
        oldOptions: Datum,
        defList: *mut List,
        namspace: *const ::std::os::raw::c_char,
        validnsps: *mut *mut ::std::os::raw::c_char,
        acceptOidsOff: bool,
        isReset: bool,
    ) -> Datum;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn untransformRelOptions(options: Datum) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn extractRelOptions(
        tuple: HeapTuple,
        tupdesc: TupleDesc,
        amoptions: amoptions_function,
    ) -> *mut bytea;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn build_reloptions(
        reloptions: Datum,
        validate: bool,
        kind: relopt_kind,
        relopt_struct_size: Size,
        relopt_elems: *const relopt_parse_elt,
        num_relopt_elems: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn build_local_reloptions(
        relopts: *mut local_relopts,
        options: Datum,
        validate: bool,
    ) -> *mut ::std::os::raw::c_void;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn default_reloptions(reloptions: Datum, validate: bool, kind: relopt_kind) -> *mut bytea;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn heap_reloptions(
        relkind: ::std::os::raw::c_char,
        reloptions: Datum,
        validate: bool,
    ) -> *mut bytea;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn view_reloptions(reloptions: Datum, validate: bool) -> *mut bytea;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn partitioned_table_reloptions(reloptions: Datum, validate: bool) -> *mut bytea;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_reloptions(
        amoptions: amoptions_function,
        reloptions: Datum,
        validate: bool,
    ) -> *mut bytea;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn attribute_reloptions(reloptions: Datum, validate: bool) -> *mut bytea;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tablespace_reloptions(reloptions: Datum, validate: bool) -> *mut bytea;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AlterTableGetRelOptionsLockLevel(defList: *mut List) -> LOCKMODE;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedInvalCatcacheMsg {
    pub id: int8,
    pub dbId: Oid,
    pub hashValue: uint32,
}
impl Default for SharedInvalCatcacheMsg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedInvalCatalogMsg {
    pub id: int8,
    pub dbId: Oid,
    pub catId: Oid,
}
impl Default for SharedInvalCatalogMsg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedInvalRelcacheMsg {
    pub id: int8,
    pub dbId: Oid,
    pub relId: Oid,
}
impl Default for SharedInvalRelcacheMsg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedInvalSmgrMsg {
    pub id: int8,
    pub backend_hi: int8,
    pub backend_lo: uint16,
    pub rnode: RelFileNode,
}
impl Default for SharedInvalSmgrMsg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedInvalRelmapMsg {
    pub id: int8,
    pub dbId: Oid,
}
impl Default for SharedInvalRelmapMsg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SharedInvalSnapshotMsg {
    pub id: int8,
    pub dbId: Oid,
    pub relId: Oid,
}
impl Default for SharedInvalSnapshotMsg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union SharedInvalidationMessage {
    pub id: int8,
    pub cc: SharedInvalCatcacheMsg,
    pub cat: SharedInvalCatalogMsg,
    pub rc: SharedInvalRelcacheMsg,
    pub sm: SharedInvalSmgrMsg,
    pub rm: SharedInvalRelmapMsg,
    pub sn: SharedInvalSnapshotMsg,
}
impl Default for SharedInvalidationMessage {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static mut SharedInvalidMessageCounter: uint64;
}
extern "C" {
    pub static mut catchupInterruptPending: sig_atomic_t;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SendSharedInvalidMessages(
        msgs: *const SharedInvalidationMessage,
        n: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ReceiveSharedInvalidMessages(
        invalFunction: ::std::option::Option<
            unsafe extern "C" fn(msg: *mut SharedInvalidationMessage),
        >,
        resetFunction: ::std::option::Option<unsafe extern "C" fn()>,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn HandleCatchupInterrupt();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ProcessCatchupInterrupt();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn xactGetCommittedInvalidationMessages(
        msgs: *mut *mut SharedInvalidationMessage,
        RelcacheInitFileInval: *mut bool,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ProcessCommittedInvalidationMessages(
        msgs: *mut SharedInvalidationMessage,
        nmsgs: ::std::os::raw::c_int,
        RelcacheInitFileInval: bool,
        dbid: Oid,
        tsid: Oid,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LocalExecuteInvalidationMessage(msg: *mut SharedInvalidationMessage);
}
extern "C" {
    pub static mut PgStartTime: TimestampTz;
}
extern "C" {
    pub static mut PgReloadTime: TimestampTz;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn anytimestamp_typmod_check(istz: bool, typmod: int32) -> int32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetCurrentTimestamp() -> TimestampTz;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetSQLCurrentTimestamp(typmod: int32) -> TimestampTz;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetSQLLocalTimestamp(typmod: int32) -> Timestamp;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TimestampDifference(
        start_time: TimestampTz,
        stop_time: TimestampTz,
        secs: *mut ::std::os::raw::c_long,
        microsecs: *mut ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TimestampDifferenceMilliseconds(
        start_time: TimestampTz,
        stop_time: TimestampTz,
    ) -> ::std::os::raw::c_long;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TimestampDifferenceExceeds(
        start_time: TimestampTz,
        stop_time: TimestampTz,
        msec: ::std::os::raw::c_int,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn time_t_to_timestamptz(tm: pg_time_t) -> TimestampTz;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn timestamptz_to_time_t(t: TimestampTz) -> pg_time_t;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn timestamptz_to_str(t: TimestampTz) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tm2timestamp(
        tm: *mut pg_tm,
        fsec: fsec_t,
        tzp: *mut ::std::os::raw::c_int,
        dt: *mut Timestamp,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn timestamp2tm(
        dt: Timestamp,
        tzp: *mut ::std::os::raw::c_int,
        tm: *mut pg_tm,
        fsec: *mut fsec_t,
        tzn: *mut *const ::std::os::raw::c_char,
        attimezone: *mut pg_tz,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dt2time(
        dt: Timestamp,
        hour: *mut ::std::os::raw::c_int,
        min: *mut ::std::os::raw::c_int,
        sec: *mut ::std::os::raw::c_int,
        fsec: *mut fsec_t,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn interval2tm(span: Interval, tm: *mut pg_tm, fsec: *mut fsec_t) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn tm2interval(tm: *mut pg_tm, fsec: fsec_t, span: *mut Interval) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SetEpochTimestamp() -> Timestamp;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetEpochTime(tm: *mut pg_tm);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn timestamp_cmp_internal(dt1: Timestamp, dt2: Timestamp) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn timestamp2timestamptz_opt_overflow(
        timestamp: Timestamp,
        overflow: *mut ::std::os::raw::c_int,
    ) -> TimestampTz;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn timestamp_cmp_timestamptz_internal(timestampVal: Timestamp, dt2: TimestampTz) -> int32;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn isoweek2j(
        year: ::std::os::raw::c_int,
        week: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn isoweek2date(
        woy: ::std::os::raw::c_int,
        year: *mut ::std::os::raw::c_int,
        mon: *mut ::std::os::raw::c_int,
        mday: *mut ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn isoweekdate2date(
        isoweek: ::std::os::raw::c_int,
        wday: ::std::os::raw::c_int,
        year: *mut ::std::os::raw::c_int,
        mon: *mut ::std::os::raw::c_int,
        mday: *mut ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn date2isoweek(
        year: ::std::os::raw::c_int,
        mon: ::std::os::raw::c_int,
        mday: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn date2isoyear(
        year: ::std::os::raw::c_int,
        mon: ::std::os::raw::c_int,
        mday: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn date2isoyearday(
        year: ::std::os::raw::c_int,
        mon: ::std::os::raw::c_int,
        mday: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TimestampTimestampTzRequiresRewrite() -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tzEntry {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct datetkn {
    pub token: [::std::os::raw::c_char; 11usize],
    pub type_: ::std::os::raw::c_char,
    pub value: int32,
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct TimeZoneAbbrevTable {
    pub tblsize: Size,
    pub numabbrevs: ::std::os::raw::c_int,
    pub abbrevs: __IncompleteArrayField<datetkn>,
}
#[repr(C)]
#[derive(Debug)]
pub struct DynamicZoneAbbrev {
    pub tz: *mut pg_tz,
    pub zone: __IncompleteArrayField<::std::os::raw::c_char>,
}
impl Default for DynamicZoneAbbrev {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub static months: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static days: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static mut day_tab: [[::std::os::raw::c_int; 13usize]; 2usize];
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetCurrentDateTime(tm: *mut pg_tm);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetCurrentTimeUsec(tm: *mut pg_tm, fsec: *mut fsec_t, tzp: *mut ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn j2date(
        jd: ::std::os::raw::c_int,
        year: *mut ::std::os::raw::c_int,
        month: *mut ::std::os::raw::c_int,
        day: *mut ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn date2j(
        year: ::std::os::raw::c_int,
        month: ::std::os::raw::c_int,
        day: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ParseDateTime(
        timestr: *const ::std::os::raw::c_char,
        workbuf: *mut ::std::os::raw::c_char,
        buflen: usize,
        field: *mut *mut ::std::os::raw::c_char,
        ftype: *mut ::std::os::raw::c_int,
        maxfields: ::std::os::raw::c_int,
        numfields: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DecodeDateTime(
        field: *mut *mut ::std::os::raw::c_char,
        ftype: *mut ::std::os::raw::c_int,
        nf: ::std::os::raw::c_int,
        dtype: *mut ::std::os::raw::c_int,
        tm: *mut pg_tm,
        fsec: *mut fsec_t,
        tzp: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DecodeTimezone(
        str_: *mut ::std::os::raw::c_char,
        tzp: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DecodeTimeOnly(
        field: *mut *mut ::std::os::raw::c_char,
        ftype: *mut ::std::os::raw::c_int,
        nf: ::std::os::raw::c_int,
        dtype: *mut ::std::os::raw::c_int,
        tm: *mut pg_tm,
        fsec: *mut fsec_t,
        tzp: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DecodeInterval(
        field: *mut *mut ::std::os::raw::c_char,
        ftype: *mut ::std::os::raw::c_int,
        nf: ::std::os::raw::c_int,
        range: ::std::os::raw::c_int,
        dtype: *mut ::std::os::raw::c_int,
        tm: *mut pg_tm,
        fsec: *mut fsec_t,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DecodeISO8601Interval(
        str_: *mut ::std::os::raw::c_char,
        dtype: *mut ::std::os::raw::c_int,
        tm: *mut pg_tm,
        fsec: *mut fsec_t,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DateTimeParseError(
        dterr: ::std::os::raw::c_int,
        str_: *const ::std::os::raw::c_char,
        datatype: *const ::std::os::raw::c_char,
    ) -> !;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DetermineTimeZoneOffset(tm: *mut pg_tm, tzp: *mut pg_tz) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DetermineTimeZoneAbbrevOffset(
        tm: *mut pg_tm,
        abbr: *const ::std::os::raw::c_char,
        tzp: *mut pg_tz,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DetermineTimeZoneAbbrevOffsetTS(
        ts: TimestampTz,
        abbr: *const ::std::os::raw::c_char,
        tzp: *mut pg_tz,
        isdst: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EncodeDateOnly(
        tm: *mut pg_tm,
        style: ::std::os::raw::c_int,
        str_: *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EncodeTimeOnly(
        tm: *mut pg_tm,
        fsec: fsec_t,
        print_tz: bool,
        tz: ::std::os::raw::c_int,
        style: ::std::os::raw::c_int,
        str_: *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EncodeDateTime(
        tm: *mut pg_tm,
        fsec: fsec_t,
        print_tz: bool,
        tz: ::std::os::raw::c_int,
        tzn: *const ::std::os::raw::c_char,
        style: ::std::os::raw::c_int,
        str_: *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EncodeInterval(
        tm: *mut pg_tm,
        fsec: fsec_t,
        style: ::std::os::raw::c_int,
        str_: *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EncodeSpecialTimestamp(dt: Timestamp, str_: *mut ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ValidateDate(
        fmask: ::std::os::raw::c_int,
        isjulian: bool,
        is2digits: bool,
        bc: bool,
        tm: *mut pg_tm,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DecodeTimezoneAbbrev(
        field: ::std::os::raw::c_int,
        lowtoken: *mut ::std::os::raw::c_char,
        offset: *mut ::std::os::raw::c_int,
        tz: *mut *mut pg_tz,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DecodeSpecial(
        field: ::std::os::raw::c_int,
        lowtoken: *mut ::std::os::raw::c_char,
        val: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DecodeUnits(
        field: ::std::os::raw::c_int,
        lowtoken: *mut ::std::os::raw::c_char,
        val: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn j2day(jd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TemporalSimplify(max_precis: int32, node: *mut Node) -> *mut Node;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CheckDateTokenTables() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ConvertTimeZoneAbbrevs(
        abbrevs: *mut tzEntry,
        n: ::std::os::raw::c_int,
    ) -> *mut TimeZoneAbbrevTable;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InstallTimeZoneAbbrevs(tbl: *mut TimeZoneAbbrevTable);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AdjustTimestampForTypmod(time: *mut Timestamp, typmod: int32);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AdjustTimestampForTypmodError(
        time: *mut Timestamp,
        typmod: int32,
        error: *mut bool,
    ) -> bool;
}
extern "C" {
    pub static mut DefaultXactIsoLevel: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut XactIsoLevel: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut DefaultXactReadOnly: bool;
}
extern "C" {
    pub static mut XactReadOnly: bool;
}
extern "C" {
    pub static mut xact_is_sampled: bool;
}
extern "C" {
    pub static mut DefaultXactDeferrable: bool;
}
extern "C" {
    pub static mut XactDeferrable: bool;
}
pub const SyncCommitLevel_SYNCHRONOUS_COMMIT_OFF: SyncCommitLevel = 0;
pub const SyncCommitLevel_SYNCHRONOUS_COMMIT_LOCAL_FLUSH: SyncCommitLevel = 1;
pub const SyncCommitLevel_SYNCHRONOUS_COMMIT_REMOTE_WRITE: SyncCommitLevel = 2;
pub const SyncCommitLevel_SYNCHRONOUS_COMMIT_REMOTE_FLUSH: SyncCommitLevel = 3;
pub const SyncCommitLevel_SYNCHRONOUS_COMMIT_REMOTE_APPLY: SyncCommitLevel = 4;
pub type SyncCommitLevel = ::std::os::raw::c_uint;
extern "C" {
    pub static mut synchronous_commit: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut MyXactFlags: ::std::os::raw::c_int;
}
pub const XactEvent_XACT_EVENT_COMMIT: XactEvent = 0;
pub const XactEvent_XACT_EVENT_PARALLEL_COMMIT: XactEvent = 1;
pub const XactEvent_XACT_EVENT_ABORT: XactEvent = 2;
pub const XactEvent_XACT_EVENT_PARALLEL_ABORT: XactEvent = 3;
pub const XactEvent_XACT_EVENT_PREPARE: XactEvent = 4;
pub const XactEvent_XACT_EVENT_PRE_COMMIT: XactEvent = 5;
pub const XactEvent_XACT_EVENT_PARALLEL_PRE_COMMIT: XactEvent = 6;
pub const XactEvent_XACT_EVENT_PRE_PREPARE: XactEvent = 7;
pub type XactEvent = ::std::os::raw::c_uint;
pub type XactCallback =
    ::std::option::Option<unsafe extern "C" fn(event: XactEvent, arg: *mut ::std::os::raw::c_void)>;
pub const SubXactEvent_SUBXACT_EVENT_START_SUB: SubXactEvent = 0;
pub const SubXactEvent_SUBXACT_EVENT_COMMIT_SUB: SubXactEvent = 1;
pub const SubXactEvent_SUBXACT_EVENT_ABORT_SUB: SubXactEvent = 2;
pub const SubXactEvent_SUBXACT_EVENT_PRE_COMMIT_SUB: SubXactEvent = 3;
pub type SubXactEvent = ::std::os::raw::c_uint;
pub type SubXactCallback = ::std::option::Option<
    unsafe extern "C" fn(
        event: SubXactEvent,
        mySubid: SubTransactionId,
        parentSubid: SubTransactionId,
        arg: *mut ::std::os::raw::c_void,
    ),
>;
#[repr(C)]
#[derive(Debug, Default)]
pub struct xl_xact_assignment {
    pub xtop: TransactionId,
    pub nsubxacts: ::std::os::raw::c_int,
    pub xsub: __IncompleteArrayField<TransactionId>,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_xact_xinfo {
    pub xinfo: uint32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_xact_dbinfo {
    pub dbId: Oid,
    pub tsId: Oid,
}
impl Default for xl_xact_dbinfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct xl_xact_subxacts {
    pub nsubxacts: ::std::os::raw::c_int,
    pub subxacts: __IncompleteArrayField<TransactionId>,
}
#[repr(C)]
#[derive(Debug)]
pub struct xl_xact_relfilenodes {
    pub nrels: ::std::os::raw::c_int,
    pub xnodes: __IncompleteArrayField<RelFileNode>,
}
impl Default for xl_xact_relfilenodes {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
pub struct xl_xact_invals {
    pub nmsgs: ::std::os::raw::c_int,
    pub msgs: __IncompleteArrayField<SharedInvalidationMessage>,
}
impl Default for xl_xact_invals {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_xact_twophase {
    pub xid: TransactionId,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_xact_origin {
    pub origin_lsn: XLogRecPtr,
    pub origin_timestamp: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_xact_commit {
    pub xact_time: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct xl_xact_abort {
    pub xact_time: TimestampTz,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_xact_prepare {
    pub magic: uint32,
    pub total_len: uint32,
    pub xid: TransactionId,
    pub database: Oid,
    pub prepared_at: TimestampTz,
    pub owner: Oid,
    pub nsubxacts: int32,
    pub ncommitrels: int32,
    pub nabortrels: int32,
    pub ninvalmsgs: int32,
    pub initfileinval: bool,
    pub gidlen: uint16,
    pub origin_lsn: XLogRecPtr,
    pub origin_timestamp: TimestampTz,
}
impl Default for xl_xact_prepare {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_xact_parsed_commit {
    pub xact_time: TimestampTz,
    pub xinfo: uint32,
    pub dbId: Oid,
    pub tsId: Oid,
    pub nsubxacts: ::std::os::raw::c_int,
    pub subxacts: *mut TransactionId,
    pub nrels: ::std::os::raw::c_int,
    pub xnodes: *mut RelFileNode,
    pub nmsgs: ::std::os::raw::c_int,
    pub msgs: *mut SharedInvalidationMessage,
    pub twophase_xid: TransactionId,
    pub twophase_gid: [::std::os::raw::c_char; 200usize],
    pub nabortrels: ::std::os::raw::c_int,
    pub abortnodes: *mut RelFileNode,
    pub origin_lsn: XLogRecPtr,
    pub origin_timestamp: TimestampTz,
}
impl Default for xl_xact_parsed_commit {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type xl_xact_parsed_prepare = xl_xact_parsed_commit;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xl_xact_parsed_abort {
    pub xact_time: TimestampTz,
    pub xinfo: uint32,
    pub dbId: Oid,
    pub tsId: Oid,
    pub nsubxacts: ::std::os::raw::c_int,
    pub subxacts: *mut TransactionId,
    pub nrels: ::std::os::raw::c_int,
    pub xnodes: *mut RelFileNode,
    pub twophase_xid: TransactionId,
    pub twophase_gid: [::std::os::raw::c_char; 200usize],
    pub origin_lsn: XLogRecPtr,
    pub origin_timestamp: TimestampTz,
}
impl Default for xl_xact_parsed_abort {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn IsTransactionState() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn IsAbortedTransactionBlockState() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetTopTransactionId() -> TransactionId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetTopTransactionIdIfAny() -> TransactionId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetCurrentTransactionId() -> TransactionId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetCurrentTransactionIdIfAny() -> TransactionId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetStableLatestTransactionId() -> TransactionId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetCurrentSubTransactionId() -> SubTransactionId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetTopFullTransactionId() -> FullTransactionId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetTopFullTransactionIdIfAny() -> FullTransactionId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetCurrentFullTransactionId() -> FullTransactionId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetCurrentFullTransactionIdIfAny() -> FullTransactionId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn MarkCurrentTransactionIdLoggedIfAny();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SubTransactionIsActive(subxid: SubTransactionId) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetCurrentCommandId(used: bool) -> CommandId;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SetParallelStartTimestamps(xact_ts: TimestampTz, stmt_ts: TimestampTz);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetCurrentTransactionStartTimestamp() -> TimestampTz;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetCurrentStatementStartTimestamp() -> TimestampTz;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetCurrentTransactionStopTimestamp() -> TimestampTz;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SetCurrentStatementStartTimestamp();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetCurrentTransactionNestLevel() -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TransactionIdIsCurrentTransactionId(xid: TransactionId) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CommandCounterIncrement();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ForceSyncCommit();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn StartTransactionCommand();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SaveTransactionCharacteristics();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RestoreTransactionCharacteristics();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CommitTransactionCommand();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AbortCurrentTransaction();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BeginTransactionBlock();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EndTransactionBlock(chain: bool) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PrepareTransactionBlock(gid: *const ::std::os::raw::c_char) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn UserAbortTransactionBlock(chain: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BeginImplicitTransactionBlock();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EndImplicitTransactionBlock();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ReleaseSavepoint(name: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DefineSavepoint(name: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RollbackToSavepoint(name: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BeginInternalSubTransaction(name: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ReleaseCurrentSubTransaction();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RollbackAndReleaseCurrentSubTransaction();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn IsSubTransaction() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EstimateTransactionStateSpace() -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SerializeTransactionState(maxsize: Size, start_address: *mut ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn StartParallelWorkerTransaction(tstatespace: *mut ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EndParallelWorkerTransaction();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn IsTransactionBlock() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn IsTransactionOrTransactionBlock() -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TransactionBlockStatusCode() -> ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AbortOutOfAnyTransaction();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PreventInTransactionBlock(isTopLevel: bool, stmtType: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RequireTransactionBlock(isTopLevel: bool, stmtType: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn WarnNoTransactionBlock(isTopLevel: bool, stmtType: *const ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn IsInTransactionBlock(isTopLevel: bool) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RegisterXactCallback(callback: XactCallback, arg: *mut ::std::os::raw::c_void);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn UnregisterXactCallback(callback: XactCallback, arg: *mut ::std::os::raw::c_void);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RegisterSubXactCallback(callback: SubXactCallback, arg: *mut ::std::os::raw::c_void);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn UnregisterSubXactCallback(callback: SubXactCallback, arg: *mut ::std::os::raw::c_void);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn xactGetCommittedChildren(ptr: *mut *mut TransactionId) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XactLogCommitRecord(
        commit_time: TimestampTz,
        nsubxacts: ::std::os::raw::c_int,
        subxacts: *mut TransactionId,
        nrels: ::std::os::raw::c_int,
        rels: *mut RelFileNode,
        nmsgs: ::std::os::raw::c_int,
        msgs: *mut SharedInvalidationMessage,
        relcacheInval: bool,
        forceSync: bool,
        xactflags: ::std::os::raw::c_int,
        twophase_xid: TransactionId,
        twophase_gid: *const ::std::os::raw::c_char,
    ) -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn XactLogAbortRecord(
        abort_time: TimestampTz,
        nsubxacts: ::std::os::raw::c_int,
        subxacts: *mut TransactionId,
        nrels: ::std::os::raw::c_int,
        rels: *mut RelFileNode,
        xactflags: ::std::os::raw::c_int,
        twophase_xid: TransactionId,
        twophase_gid: *const ::std::os::raw::c_char,
    ) -> XLogRecPtr;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn xact_redo(record: *mut XLogReaderState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn xact_desc(buf: StringInfo, record: *mut XLogReaderState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn xact_identify(info: uint8) -> *const ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ParseCommitRecord(
        info: uint8,
        xlrec: *mut xl_xact_commit,
        parsed: *mut xl_xact_parsed_commit,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ParseAbortRecord(
        info: uint8,
        xlrec: *mut xl_xact_abort,
        parsed: *mut xl_xact_parsed_abort,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ParsePrepareRecord(
        info: uint8,
        xlrec: *mut xl_xact_prepare,
        parsed: *mut xl_xact_parsed_prepare,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EnterParallelMode();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ExitParallelMode();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn IsInParallelMode() -> bool;
}
pub const DependencyType_DEPENDENCY_NORMAL: DependencyType = 110;
pub const DependencyType_DEPENDENCY_AUTO: DependencyType = 97;
pub const DependencyType_DEPENDENCY_INTERNAL: DependencyType = 105;
pub const DependencyType_DEPENDENCY_PARTITION_PRI: DependencyType = 80;
pub const DependencyType_DEPENDENCY_PARTITION_SEC: DependencyType = 83;
pub const DependencyType_DEPENDENCY_EXTENSION: DependencyType = 101;
pub const DependencyType_DEPENDENCY_AUTO_EXTENSION: DependencyType = 120;
pub const DependencyType_DEPENDENCY_PIN: DependencyType = 112;
pub type DependencyType = ::std::os::raw::c_uint;
pub const SharedDependencyType_SHARED_DEPENDENCY_PIN: SharedDependencyType = 112;
pub const SharedDependencyType_SHARED_DEPENDENCY_OWNER: SharedDependencyType = 111;
pub const SharedDependencyType_SHARED_DEPENDENCY_ACL: SharedDependencyType = 97;
pub const SharedDependencyType_SHARED_DEPENDENCY_POLICY: SharedDependencyType = 114;
pub const SharedDependencyType_SHARED_DEPENDENCY_TABLESPACE: SharedDependencyType = 116;
pub const SharedDependencyType_SHARED_DEPENDENCY_INVALID: SharedDependencyType = 0;
pub type SharedDependencyType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectAddresses {
    _unused: [u8; 0],
}
pub const ObjectClass_OCLASS_CLASS: ObjectClass = 0;
pub const ObjectClass_OCLASS_PROC: ObjectClass = 1;
pub const ObjectClass_OCLASS_TYPE: ObjectClass = 2;
pub const ObjectClass_OCLASS_CAST: ObjectClass = 3;
pub const ObjectClass_OCLASS_COLLATION: ObjectClass = 4;
pub const ObjectClass_OCLASS_CONSTRAINT: ObjectClass = 5;
pub const ObjectClass_OCLASS_CONVERSION: ObjectClass = 6;
pub const ObjectClass_OCLASS_DEFAULT: ObjectClass = 7;
pub const ObjectClass_OCLASS_LANGUAGE: ObjectClass = 8;
pub const ObjectClass_OCLASS_LARGEOBJECT: ObjectClass = 9;
pub const ObjectClass_OCLASS_OPERATOR: ObjectClass = 10;
pub const ObjectClass_OCLASS_OPCLASS: ObjectClass = 11;
pub const ObjectClass_OCLASS_OPFAMILY: ObjectClass = 12;
pub const ObjectClass_OCLASS_AM: ObjectClass = 13;
pub const ObjectClass_OCLASS_AMOP: ObjectClass = 14;
pub const ObjectClass_OCLASS_AMPROC: ObjectClass = 15;
pub const ObjectClass_OCLASS_REWRITE: ObjectClass = 16;
pub const ObjectClass_OCLASS_TRIGGER: ObjectClass = 17;
pub const ObjectClass_OCLASS_SCHEMA: ObjectClass = 18;
pub const ObjectClass_OCLASS_STATISTIC_EXT: ObjectClass = 19;
pub const ObjectClass_OCLASS_TSPARSER: ObjectClass = 20;
pub const ObjectClass_OCLASS_TSDICT: ObjectClass = 21;
pub const ObjectClass_OCLASS_TSTEMPLATE: ObjectClass = 22;
pub const ObjectClass_OCLASS_TSCONFIG: ObjectClass = 23;
pub const ObjectClass_OCLASS_ROLE: ObjectClass = 24;
pub const ObjectClass_OCLASS_DATABASE: ObjectClass = 25;
pub const ObjectClass_OCLASS_TBLSPACE: ObjectClass = 26;
pub const ObjectClass_OCLASS_FDW: ObjectClass = 27;
pub const ObjectClass_OCLASS_FOREIGN_SERVER: ObjectClass = 28;
pub const ObjectClass_OCLASS_USER_MAPPING: ObjectClass = 29;
pub const ObjectClass_OCLASS_DEFACL: ObjectClass = 30;
pub const ObjectClass_OCLASS_EXTENSION: ObjectClass = 31;
pub const ObjectClass_OCLASS_EVENT_TRIGGER: ObjectClass = 32;
pub const ObjectClass_OCLASS_POLICY: ObjectClass = 33;
pub const ObjectClass_OCLASS_PUBLICATION: ObjectClass = 34;
pub const ObjectClass_OCLASS_PUBLICATION_REL: ObjectClass = 35;
pub const ObjectClass_OCLASS_SUBSCRIPTION: ObjectClass = 36;
pub const ObjectClass_OCLASS_TRANSFORM: ObjectClass = 37;
pub type ObjectClass = ::std::os::raw::c_uint;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AcquireDeletionLock(object: *const ObjectAddress, flags: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ReleaseDeletionLock(object: *const ObjectAddress);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn performDeletion(
        object: *const ObjectAddress,
        behavior: DropBehavior,
        flags: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn performMultipleDeletions(
        objects: *const ObjectAddresses,
        behavior: DropBehavior,
        flags: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn recordDependencyOnExpr(
        depender: *const ObjectAddress,
        expr: *mut Node,
        rtable: *mut List,
        behavior: DependencyType,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn recordDependencyOnSingleRelExpr(
        depender: *const ObjectAddress,
        expr: *mut Node,
        relId: Oid,
        behavior: DependencyType,
        self_behavior: DependencyType,
        reverse_self: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn getObjectClass(object: *const ObjectAddress) -> ObjectClass;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn new_object_addresses() -> *mut ObjectAddresses;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn add_exact_object_address(object: *const ObjectAddress, addrs: *mut ObjectAddresses);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn object_address_present(
        object: *const ObjectAddress,
        addrs: *const ObjectAddresses,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn record_object_address_dependencies(
        depender: *const ObjectAddress,
        referenced: *mut ObjectAddresses,
        behavior: DependencyType,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn sort_object_addresses(addrs: *mut ObjectAddresses);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn free_object_addresses(addrs: *mut ObjectAddresses);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn recordDependencyOn(
        depender: *const ObjectAddress,
        referenced: *const ObjectAddress,
        behavior: DependencyType,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn recordMultipleDependencies(
        depender: *const ObjectAddress,
        referenced: *const ObjectAddress,
        nreferenced: ::std::os::raw::c_int,
        behavior: DependencyType,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn recordDependencyOnCurrentExtension(object: *const ObjectAddress, isReplace: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn checkMembershipInCurrentExtension(object: *const ObjectAddress);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn deleteDependencyRecordsFor(
        classId: Oid,
        objectId: Oid,
        skipExtensionDeps: bool,
    ) -> ::std::os::raw::c_long;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn deleteDependencyRecordsForClass(
        classId: Oid,
        objectId: Oid,
        refclassId: Oid,
        deptype: ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_long;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn deleteDependencyRecordsForSpecific(
        classId: Oid,
        objectId: Oid,
        deptype: ::std::os::raw::c_char,
        refclassId: Oid,
        refobjectId: Oid,
    ) -> ::std::os::raw::c_long;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn changeDependencyFor(
        classId: Oid,
        objectId: Oid,
        refClassId: Oid,
        oldRefObjectId: Oid,
        newRefObjectId: Oid,
    ) -> ::std::os::raw::c_long;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn changeDependenciesOf(
        classId: Oid,
        oldObjectId: Oid,
        newObjectId: Oid,
    ) -> ::std::os::raw::c_long;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn changeDependenciesOn(
        refClassId: Oid,
        oldRefObjectId: Oid,
        newRefObjectId: Oid,
    ) -> ::std::os::raw::c_long;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn getExtensionOfObject(classId: Oid, objectId: Oid) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn getAutoExtensionsOfObject(classId: Oid, objectId: Oid) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn sequenceIsOwned(
        seqId: Oid,
        deptype: ::std::os::raw::c_char,
        tableId: *mut Oid,
        colId: *mut int32,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn getOwnedSequences(relid: Oid) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn getIdentitySequence(relid: Oid, attnum: AttrNumber, missing_ok: bool) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_constraint_index(constraintId: Oid) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_index_constraint(indexId: Oid) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_index_ref_constraints(indexId: Oid) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn recordSharedDependencyOn(
        depender: *mut ObjectAddress,
        referenced: *mut ObjectAddress,
        deptype: SharedDependencyType,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn deleteSharedDependencyRecordsFor(classId: Oid, objectId: Oid, objectSubId: int32);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn recordDependencyOnOwner(classId: Oid, objectId: Oid, owner: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn changeDependencyOnOwner(classId: Oid, objectId: Oid, newOwnerId: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn recordDependencyOnTablespace(classId: Oid, objectId: Oid, tablespace: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn changeDependencyOnTablespace(classId: Oid, objectId: Oid, newTablespaceId: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn updateAclDependencies(
        classId: Oid,
        objectId: Oid,
        objectSubId: int32,
        ownerId: Oid,
        noldmembers: ::std::os::raw::c_int,
        oldmembers: *mut Oid,
        nnewmembers: ::std::os::raw::c_int,
        newmembers: *mut Oid,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn checkSharedDependencies(
        classId: Oid,
        objectId: Oid,
        detail_msg: *mut *mut ::std::os::raw::c_char,
        detail_log_msg: *mut *mut ::std::os::raw::c_char,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn shdepLockAndCheckObject(classId: Oid, objectId: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn copyTemplateDependencies(templateDbId: Oid, newDbId: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn dropDatabaseDependencies(databaseId: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn shdepDropOwned(relids: *mut List, behavior: DropBehavior);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn shdepReassignOwned(relids: *mut List, newrole: Oid);
}
pub const IndexStateFlagsAction_INDEX_CREATE_SET_READY: IndexStateFlagsAction = 0;
pub const IndexStateFlagsAction_INDEX_CREATE_SET_VALID: IndexStateFlagsAction = 1;
pub const IndexStateFlagsAction_INDEX_DROP_CLEAR_VALID: IndexStateFlagsAction = 2;
pub const IndexStateFlagsAction_INDEX_DROP_SET_DEAD: IndexStateFlagsAction = 3;
pub type IndexStateFlagsAction = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ValidateIndexState {
    pub tuplesort: *mut Tuplesortstate,
    pub htups: f64,
    pub itups: f64,
    pub tups_inserted: f64,
}
impl Default for ValidateIndexState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_check_primary_key(
        heapRel: Relation,
        indexInfo: *mut IndexInfo,
        is_alter_table: bool,
        stmt: *mut IndexStmt,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_create(
        heapRelation: Relation,
        indexRelationName: *const ::std::os::raw::c_char,
        indexRelationId: Oid,
        parentIndexRelid: Oid,
        parentConstraintId: Oid,
        relFileNode: Oid,
        indexInfo: *mut IndexInfo,
        indexColNames: *mut List,
        accessMethodObjectId: Oid,
        tableSpaceId: Oid,
        collationObjectId: *mut Oid,
        classObjectId: *mut Oid,
        coloptions: *mut int16,
        reloptions: Datum,
        flags: bits16,
        constr_flags: bits16,
        allow_system_table_mods: bool,
        is_internal: bool,
        constraintId: *mut Oid,
    ) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_concurrently_create_copy(
        heapRelation: Relation,
        oldIndexId: Oid,
        newName: *const ::std::os::raw::c_char,
    ) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_concurrently_build(heapRelationId: Oid, indexRelationId: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_concurrently_swap(
        newIndexId: Oid,
        oldIndexId: Oid,
        oldName: *const ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_concurrently_set_dead(heapId: Oid, indexId: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_constraint_create(
        heapRelation: Relation,
        indexRelationId: Oid,
        parentConstraintId: Oid,
        indexInfo: *mut IndexInfo,
        constraintName: *const ::std::os::raw::c_char,
        constraintType: ::std::os::raw::c_char,
        constr_flags: bits16,
        allow_system_table_mods: bool,
        is_internal: bool,
    ) -> ObjectAddress;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_drop(indexId: Oid, concurrent: bool, concurrent_lock_mode: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BuildIndexInfo(index: Relation) -> *mut IndexInfo;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BuildDummyIndexInfo(index: Relation) -> *mut IndexInfo;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CompareIndexInfo(
        info1: *mut IndexInfo,
        info2: *mut IndexInfo,
        collations1: *mut Oid,
        collations2: *mut Oid,
        opfamilies1: *mut Oid,
        opfamilies2: *mut Oid,
        attmap: *mut AttrMap,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn BuildSpeculativeIndexInfo(index: Relation, ii: *mut IndexInfo);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FormIndexDatum(
        indexInfo: *mut IndexInfo,
        slot: *mut TupleTableSlot,
        estate: *mut EState,
        values: *mut Datum,
        isnull: *mut bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_build(
        heapRelation: Relation,
        indexRelation: Relation,
        indexInfo: *mut IndexInfo,
        isreindex: bool,
        parallel: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn validate_index(heapId: Oid, indexId: Oid, snapshot: Snapshot);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn index_set_state_flags(indexId: Oid, action: IndexStateFlagsAction);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn IndexGetRelation(indexId: Oid, missing_ok: bool) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn reindex_index(
        indexId: Oid,
        skip_constraint_checks: bool,
        relpersistence: ::std::os::raw::c_char,
        options: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn reindex_relation(
        relid: Oid,
        flags: ::std::os::raw::c_int,
        options: ::std::os::raw::c_int,
    ) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ReindexIsProcessingHeap(heapOid: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ReindexIsProcessingIndex(indexOid: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ResetReindexState(nestLevel: ::std::os::raw::c_int);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EstimateReindexStateSpace() -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SerializeReindexState(maxsize: Size, start_address: *mut ::std::os::raw::c_char);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RestoreReindexState(reindexstate: *mut ::std::os::raw::c_void);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn IndexSetParentIndex(idx: Relation, parentOid: Oid);
}
pub type CatalogIndexState = *mut ResultRelInfo;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CatalogOpenIndexes(heapRel: Relation) -> CatalogIndexState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CatalogCloseIndexes(indstate: CatalogIndexState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CatalogTupleInsert(heapRel: Relation, tup: HeapTuple);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CatalogTupleInsertWithInfo(
        heapRel: Relation,
        tup: HeapTuple,
        indstate: CatalogIndexState,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CatalogTupleUpdate(heapRel: Relation, otid: ItemPointer, tup: HeapTuple);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CatalogTupleUpdateWithInfo(
        heapRel: Relation,
        otid: ItemPointer,
        tup: HeapTuple,
        indstate: CatalogIndexState,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CatalogTupleDelete(heapRel: Relation, tid: ItemPointer);
}
extern "C" {
    pub static mut no_such_variable: ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug)]
pub struct _FuncCandidateList {
    pub next: *mut _FuncCandidateList,
    pub pathpos: ::std::os::raw::c_int,
    pub oid: Oid,
    pub nargs: ::std::os::raw::c_int,
    pub nvargs: ::std::os::raw::c_int,
    pub ndargs: ::std::os::raw::c_int,
    pub argnumbers: *mut ::std::os::raw::c_int,
    pub args: __IncompleteArrayField<Oid>,
}
impl Default for _FuncCandidateList {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type FuncCandidateList = *mut _FuncCandidateList;
pub const TempNamespaceStatus_TEMP_NAMESPACE_NOT_TEMP: TempNamespaceStatus = 0;
pub const TempNamespaceStatus_TEMP_NAMESPACE_IDLE: TempNamespaceStatus = 1;
pub const TempNamespaceStatus_TEMP_NAMESPACE_IN_USE: TempNamespaceStatus = 2;
pub type TempNamespaceStatus = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OverrideSearchPath {
    pub schemas: *mut List,
    pub addCatalog: bool,
    pub addTemp: bool,
    pub generation: uint64,
}
impl Default for OverrideSearchPath {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const RVROption_RVR_MISSING_OK: RVROption = 1;
pub const RVROption_RVR_NOWAIT: RVROption = 2;
pub const RVROption_RVR_SKIP_LOCKED: RVROption = 4;
pub type RVROption = ::std::os::raw::c_uint;
pub type RangeVarGetRelidCallback = ::std::option::Option<
    unsafe extern "C" fn(
        relation: *const RangeVar,
        relId: Oid,
        oldRelId: Oid,
        callback_arg: *mut ::std::os::raw::c_void,
    ),
>;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RangeVarGetRelidExtended(
        relation: *const RangeVar,
        lockmode: LOCKMODE,
        flags: uint32,
        callback: RangeVarGetRelidCallback,
        callback_arg: *mut ::std::os::raw::c_void,
    ) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RangeVarGetCreationNamespace(newRelation: *const RangeVar) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RangeVarGetAndCheckCreationNamespace(
        newRelation: *mut RangeVar,
        lockmode: LOCKMODE,
        existing_relation_id: *mut Oid,
    ) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RangeVarAdjustRelationPersistence(newRelation: *mut RangeVar, nspid: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelnameGetRelid(relname: *const ::std::os::raw::c_char) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RelationIsVisible(relid: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TypenameGetTypid(typname: *const ::std::os::raw::c_char) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TypenameGetTypidExtended(typname: *const ::std::os::raw::c_char, temp_ok: bool) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TypeIsVisible(typid: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FuncnameGetCandidates(
        names: *mut List,
        nargs: ::std::os::raw::c_int,
        argnames: *mut List,
        expand_variadic: bool,
        expand_defaults: bool,
        missing_ok: bool,
    ) -> FuncCandidateList;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FunctionIsVisible(funcid: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OpernameGetOprid(names: *mut List, oprleft: Oid, oprright: Oid) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OpernameGetCandidates(
        names: *mut List,
        oprkind: ::std::os::raw::c_char,
        missing_schema_ok: bool,
    ) -> FuncCandidateList;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OperatorIsVisible(oprid: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OpclassnameGetOpcid(amid: Oid, opcname: *const ::std::os::raw::c_char) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OpclassIsVisible(opcid: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OpfamilynameGetOpfid(amid: Oid, opfname: *const ::std::os::raw::c_char) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OpfamilyIsVisible(opfid: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CollationGetCollid(collname: *const ::std::os::raw::c_char) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CollationIsVisible(collid: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ConversionGetConid(conname: *const ::std::os::raw::c_char) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ConversionIsVisible(conid: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_statistics_object_oid(names: *mut List, missing_ok: bool) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn StatisticsObjIsVisible(relid: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_ts_parser_oid(names: *mut List, missing_ok: bool) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TSParserIsVisible(prsId: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_ts_dict_oid(names: *mut List, missing_ok: bool) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TSDictionaryIsVisible(dictId: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_ts_template_oid(names: *mut List, missing_ok: bool) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TSTemplateIsVisible(tmplId: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_ts_config_oid(names: *mut List, missing_ok: bool) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn TSConfigIsVisible(cfgid: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn DeconstructQualifiedName(
        names: *mut List,
        nspname_p: *mut *mut ::std::os::raw::c_char,
        objname_p: *mut *mut ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LookupNamespaceNoError(nspname: *const ::std::os::raw::c_char) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LookupExplicitNamespace(nspname: *const ::std::os::raw::c_char, missing_ok: bool)
        -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_namespace_oid(nspname: *const ::std::os::raw::c_char, missing_ok: bool) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn LookupCreationNamespace(nspname: *const ::std::os::raw::c_char) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CheckSetNamespace(oldNspOid: Oid, nspOid: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn QualifiedNameGetCreationNamespace(
        names: *mut List,
        objname_p: *mut *mut ::std::os::raw::c_char,
    ) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn makeRangeVarFromNameList(names: *mut List) -> *mut RangeVar;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn NameListToString(names: *mut List) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn NameListToQuotedString(names: *mut List) -> *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn isTempNamespace(namespaceId: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn isTempToastNamespace(namespaceId: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn isTempOrTempToastNamespace(namespaceId: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn isAnyTempNamespace(namespaceId: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn isOtherTempNamespace(namespaceId: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn checkTempNamespaceStatus(namespaceId: Oid) -> TempNamespaceStatus;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetTempNamespaceBackendId(namespaceId: Oid) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetTempToastNamespace() -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetTempNamespaceState(tempNamespaceId: *mut Oid, tempToastNamespaceId: *mut Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SetTempNamespaceState(tempNamespaceId: Oid, tempToastNamespaceId: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ResetTempTableNamespace();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn GetOverrideSearchPath(context: MemoryContext) -> *mut OverrideSearchPath;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn CopyOverrideSearchPath(path: *mut OverrideSearchPath) -> *mut OverrideSearchPath;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OverrideSearchPathMatchesCurrent(path: *mut OverrideSearchPath) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PushOverrideSearchPath(newpath: *mut OverrideSearchPath);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn PopOverrideSearchPath();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_collation_oid(collname: *mut List, missing_ok: bool) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn get_conversion_oid(conname: *mut List, missing_ok: bool) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn FindDefaultConversionProc(for_encoding: int32, to_encoding: int32) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn InitializeSearchPath();
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AtEOXact_Namespace(isCommit: bool, parallel: bool);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AtEOSubXact_Namespace(
        isCommit: bool,
        mySubid: SubTransactionId,
        parentSubid: SubTransactionId,
    );
}
extern "C" {
    pub static mut namespace_search_path: *mut ::std::os::raw::c_char;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn fetch_search_path(includeImplicit: bool) -> *mut List;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn fetch_search_path_array(
        sarray: *mut Oid,
        sarray_len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub const ObjectAccessType_OAT_POST_CREATE: ObjectAccessType = 0;
pub const ObjectAccessType_OAT_DROP: ObjectAccessType = 1;
pub const ObjectAccessType_OAT_POST_ALTER: ObjectAccessType = 2;
pub const ObjectAccessType_OAT_NAMESPACE_SEARCH: ObjectAccessType = 3;
pub const ObjectAccessType_OAT_FUNCTION_EXECUTE: ObjectAccessType = 4;
pub const ObjectAccessType_OAT_TRUNCATE: ObjectAccessType = 5;
pub type ObjectAccessType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ObjectAccessPostCreate {
    pub is_internal: bool,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ObjectAccessDrop {
    pub dropflags: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ObjectAccessPostAlter {
    pub auxiliary_id: Oid,
    pub is_internal: bool,
}
impl Default for ObjectAccessPostAlter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ObjectAccessNamespaceSearch {
    pub ereport_on_violation: bool,
    pub result: bool,
}
pub type object_access_hook_type = ::std::option::Option<
    unsafe extern "C" fn(
        access: ObjectAccessType,
        classId: Oid,
        objectId: Oid,
        subId: ::std::os::raw::c_int,
        arg: *mut ::std::os::raw::c_void,
    ),
>;
extern "C" {
    pub static mut object_access_hook: object_access_hook_type;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RunObjectPostCreateHook(
        classId: Oid,
        objectId: Oid,
        subId: ::std::os::raw::c_int,
        is_internal: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RunObjectDropHook(
        classId: Oid,
        objectId: Oid,
        subId: ::std::os::raw::c_int,
        dropflags: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RunObjectTruncateHook(objectId: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RunObjectPostAlterHook(
        classId: Oid,
        objectId: Oid,
        subId: ::std::os::raw::c_int,
        auxiliaryId: Oid,
        is_internal: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RunNamespaceSearchHook(objectId: Oid, ereport_on_violation: bool) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RunFunctionExecuteHook(objectId: Oid);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_amop {
    pub oid: Oid,
    pub amopfamily: Oid,
    pub amoplefttype: Oid,
    pub amoprighttype: Oid,
    pub amopstrategy: int16,
    pub amoppurpose: ::std::os::raw::c_char,
    pub amopopr: Oid,
    pub amopmethod: Oid,
    pub amopsortfamily: Oid,
}
impl Default for FormData_pg_amop {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_amop = *mut FormData_pg_amop;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_authid {
    pub oid: Oid,
    pub rolname: NameData,
    pub rolsuper: bool,
    pub rolinherit: bool,
    pub rolcreaterole: bool,
    pub rolcreatedb: bool,
    pub rolcanlogin: bool,
    pub rolreplication: bool,
    pub rolbypassrls: bool,
    pub rolconnlimit: int32,
}
impl Default for FormData_pg_authid {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_authid = *mut FormData_pg_authid;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_database {
    pub oid: Oid,
    pub datname: NameData,
    pub datdba: Oid,
    pub encoding: int32,
    pub datcollate: NameData,
    pub datctype: NameData,
    pub datistemplate: bool,
    pub datallowconn: bool,
    pub datconnlimit: int32,
    pub datlastsysoid: Oid,
    pub datfrozenxid: TransactionId,
    pub datminmxid: TransactionId,
    pub dattablespace: Oid,
}
impl Default for FormData_pg_database {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_database = *mut FormData_pg_database;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_enum {
    pub oid: Oid,
    pub enumtypid: Oid,
    pub enumsortorder: float4,
    pub enumlabel: NameData,
}
impl Default for FormData_pg_enum {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_enum = *mut FormData_pg_enum;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EnumValuesCreate(enumTypeOid: Oid, vals: *mut List);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EnumValuesDelete(enumTypeOid: Oid);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AddEnumLabel(
        enumTypeOid: Oid,
        newVal: *const ::std::os::raw::c_char,
        neighbor: *const ::std::os::raw::c_char,
        newValIsAfter: bool,
        skipIfExists: bool,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RenameEnumLabel(
        enumTypeOid: Oid,
        oldVal: *const ::std::os::raw::c_char,
        newVal: *const ::std::os::raw::c_char,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EnumBlacklisted(enum_id: Oid) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn EstimateEnumBlacklistSpace() -> Size;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn SerializeEnumBlacklist(space: *mut ::std::os::raw::c_void, size: Size);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn RestoreEnumBlacklist(space: *mut ::std::os::raw::c_void);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn AtEOXact_Enum();
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_extension {
    pub oid: Oid,
    pub extname: NameData,
    pub extowner: Oid,
    pub extnamespace: Oid,
    pub extrelocatable: bool,
}
impl Default for FormData_pg_extension {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_extension = *mut FormData_pg_extension;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_foreign_server {
    pub oid: Oid,
    pub srvname: NameData,
    pub srvowner: Oid,
    pub srvfdw: Oid,
}
impl Default for FormData_pg_foreign_server {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_foreign_server = *mut FormData_pg_foreign_server;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_foreign_table {
    pub ftrelid: Oid,
    pub ftserver: Oid,
}
impl Default for FormData_pg_foreign_table {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_foreign_table = *mut FormData_pg_foreign_table;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_operator {
    pub oid: Oid,
    pub oprname: NameData,
    pub oprnamespace: Oid,
    pub oprowner: Oid,
    pub oprkind: ::std::os::raw::c_char,
    pub oprcanmerge: bool,
    pub oprcanhash: bool,
    pub oprleft: Oid,
    pub oprright: Oid,
    pub oprresult: Oid,
    pub oprcom: Oid,
    pub oprnegate: Oid,
    pub oprcode: regproc,
    pub oprrest: regproc,
    pub oprjoin: regproc,
}
impl Default for FormData_pg_operator {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_operator = *mut FormData_pg_operator;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OperatorCreate(
        operatorName: *const ::std::os::raw::c_char,
        operatorNamespace: Oid,
        leftTypeId: Oid,
        rightTypeId: Oid,
        procedureId: Oid,
        commutatorName: *mut List,
        negatorName: *mut List,
        restrictionId: Oid,
        joinId: Oid,
        canMerge: bool,
        canHash: bool,
    ) -> ObjectAddress;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn makeOperatorDependencies(
        tuple: HeapTuple,
        makeExtensionDep: bool,
        isUpdate: bool,
    ) -> ObjectAddress;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn OperatorUpd(baseId: Oid, commId: Oid, negId: Oid, isDelete: bool);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_opclass {
    pub oid: Oid,
    pub opcmethod: Oid,
    pub opcname: NameData,
    pub opcnamespace: Oid,
    pub opcowner: Oid,
    pub opcfamily: Oid,
    pub opcintype: Oid,
    pub opcdefault: bool,
    pub opckeytype: Oid,
}
impl Default for FormData_pg_opclass {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_opclass = *mut FormData_pg_opclass;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FormData_pg_opfamily {
    pub oid: Oid,
    pub opfmethod: Oid,
    pub opfname: NameData,
    pub opfnamespace: Oid,
    pub opfowner: Oid,
}
impl Default for FormData_pg_opfamily {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_opfamily = *mut FormData_pg_opfamily;
#[repr(C)]
#[derive(Debug)]
pub struct FormData_pg_proc {
    pub oid: Oid,
    pub proname: NameData,
    pub pronamespace: Oid,
    pub proowner: Oid,
    pub prolang: Oid,
    pub procost: float4,
    pub prorows: float4,
    pub provariadic: Oid,
    pub prosupport: regproc,
    pub prokind: ::std::os::raw::c_char,
    pub prosecdef: bool,
    pub proleakproof: bool,
    pub proisstrict: bool,
    pub proretset: bool,
    pub provolatile: ::std::os::raw::c_char,
    pub proparallel: ::std::os::raw::c_char,
    pub pronargs: int16,
    pub pronargdefaults: int16,
    pub prorettype: Oid,
    pub proargtypes: oidvector,
}
impl Default for FormData_pg_proc {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Form_pg_proc = *mut FormData_pg_proc;
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn ProcedureCreate(
        procedureName: *const ::std::os::raw::c_char,
        procNamespace: Oid,
        replace: bool,
        returnsSet: bool,
        returnType: Oid,
        proowner: Oid,
        languageObjectId: Oid,
        languageValidator: Oid,
        prosrc: *const ::std::os::raw::c_char,
        probin: *const ::std::os::raw::c_char,
        prokind: ::std::os::raw::c_char,
        security_definer: bool,
        isLeakProof: bool,
        isStrict: bool,
        volatility: ::std::os::raw::c_char,
        parallel: ::std::os::raw::c_char,
        parameterTypes: *mut oidvector,
        allParameterTypes: Datum,
        parameterModes: Datum,
        parameterNames: Datum,
        parameterDefaults: *mut List,
        trftypes: Datum,
        proconfig: Datum,
        prosupport: Oid,
        procost: float4,
        prorows: float4,
    ) -> ObjectAddress;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn function_parse_error_transpose(prosrc: *const ::std::os::raw::c_char) -> bool;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn oid_array_to_list(datum: Datum) -> *mut List;
}
pub const ParseExprKind_EXPR_KIND_NONE: ParseExprKind = 0;
pub const ParseExprKind_EXPR_KIND_OTHER: ParseExprKind = 1;
pub const ParseExprKind_EXPR_KIND_JOIN_ON: ParseExprKind = 2;
pub const ParseExprKind_EXPR_KIND_JOIN_USING: ParseExprKind = 3;
pub const ParseExprKind_EXPR_KIND_FROM_SUBSELECT: ParseExprKind = 4;
pub const ParseExprKind_EXPR_KIND_FROM_FUNCTION: ParseExprKind = 5;
pub const ParseExprKind_EXPR_KIND_WHERE: ParseExprKind = 6;
pub const ParseExprKind_EXPR_KIND_HAVING: ParseExprKind = 7;
pub const ParseExprKind_EXPR_KIND_FILTER: ParseExprKind = 8;
pub const ParseExprKind_EXPR_KIND_WINDOW_PARTITION: ParseExprKind = 9;
pub const ParseExprKind_EXPR_KIND_WINDOW_ORDER: ParseExprKind = 10;
pub const ParseExprKind_EXPR_KIND_WINDOW_FRAME_RANGE: ParseExprKind = 11;
pub const ParseExprKind_EXPR_KIND_WINDOW_FRAME_ROWS: ParseExprKind = 12;
pub const ParseExprKind_EXPR_KIND_WINDOW_FRAME_GROUPS: ParseExprKind = 13;
pub const ParseExprKind_EXPR_KIND_SELECT_TARGET: ParseExprKind = 14;
pub const ParseExprKind_EXPR_KIND_INSERT_TARGET: ParseExprKind = 15;
pub const ParseExprKind_EXPR_KIND_UPDATE_SOURCE: ParseExprKind = 16;
pub const ParseExprKind_EXPR_KIND_UPDATE_TARGET: ParseExprKind = 17;
pub const ParseExprKind_EXPR_KIND_GROUP_BY: ParseExprKind = 18;
pub const ParseExprKind_EXPR_KIND_ORDER_BY: ParseExprKind = 19;
pub const ParseExprKind_EXPR_KIND_DISTINCT_ON: ParseExprKind = 20;
pub const ParseExprKind_EXPR_KIND_LIMIT: ParseExprKind = 21;
pub const ParseExprKind_EXPR_KIND_OFFSET: ParseExprKind = 22;
pub const ParseExprKind_EXPR_KIND_RETURNING: ParseExprKind = 23;
pub const ParseExprKind_EXPR_KIND_VALUES: ParseExprKind = 24;
pub const ParseExprKind_EXPR_KIND_VALUES_SINGLE: ParseExprKind = 25;
pub const ParseExprKind_EXPR_KIND_CHECK_CONSTRAINT: ParseExprKind = 26;
pub const ParseExprKind_EXPR_KIND_DOMAIN_CHECK: ParseExprKind = 27;
pub const ParseExprKind_EXPR_KIND_COLUMN_DEFAULT: ParseExprKind = 28;
pub const ParseExprKind_EXPR_KIND_FUNCTION_DEFAULT: ParseExprKind = 29;
pub const ParseExprKind_EXPR_KIND_INDEX_EXPRESSION: ParseExprKind = 30;
pub const ParseExprKind_EXPR_KIND_INDEX_PREDICATE: ParseExprKind = 31;
pub const ParseExprKind_EXPR_KIND_ALTER_COL_TRANSFORM: ParseExprKind = 32;
pub const ParseExprKind_EXPR_KIND_EXECUTE_PARAMETER: ParseExprKind = 33;
pub const ParseExprKind_EXPR_KIND_TRIGGER_WHEN: ParseExprKind = 34;
pub const ParseExprKind_EXPR_KIND_POLICY: ParseExprKind = 35;
pub const ParseExprKind_EXPR_KIND_PARTITION_BOUND: ParseExprKind = 36;
pub const ParseExprKind_EXPR_KIND_PARTITION_EXPRESSION: ParseExprKind = 37;
pub const ParseExprKind_EXPR_KIND_CALL_ARGUMENT: ParseExprKind = 38;
pub const ParseExprKind_EXPR_KIND_COPY_WHERE: ParseExprKind = 39;
pub const ParseExprKind_EXPR_KIND_GENERATED_COLUMN: ParseExprKind = 40;
pub type ParseExprKind = ::std::os::raw::c_uint;
pub type PreParseColumnRefHook = ::std::option::Option<
    unsafe extern "C" fn(pstate: *mut ParseState, cref: *mut ColumnRef) -> *mut Node,
>;
pub type PostParseColumnRefHook = ::std::option::Option<
    unsafe extern "C" fn(
        pstate: *mut ParseState,
        cref: *mut ColumnRef,
        var: *mut Node,
    ) -> *mut Node,
>;
pub type ParseParamRefHook = ::std::option::Option<
    unsafe extern "C" fn(pstate: *mut ParseState, pref: *mut ParamRef) -> *mut Node,
>;
pub type CoerceParamHook = ::std::option::Option<
    unsafe extern "C" fn(
        pstate: *mut ParseState,
        param: *mut Param,
        targetTypeId: Oid,
        targetTypeMod: int32,
        location: ::std::os::raw::c_int,
    ) -> *mut Node,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParseState {
    pub parentParseState: *mut ParseState,
    pub p_sourcetext: *const ::std::os::raw::c_char,
    pub p_rtable: *mut List,
    pub p_joinexprs: *mut List,
    pub p_joinlist: *mut List,
    pub p_namespace: *mut List,
    pub p_lateral_active: bool,
    pub p_ctenamespace: *mut List,
    pub p_future_ctes: *mut List,
    pub p_parent_cte: *mut CommonTableExpr,
    pub p_target_relation: Relation,
    pub p_target_nsitem: *mut ParseNamespaceItem,
    pub p_is_insert: bool,
    pub p_windowdefs: *mut List,
    pub p_expr_kind: ParseExprKind,
    pub p_next_resno: ::std::os::raw::c_int,
    pub p_multiassign_exprs: *mut List,
    pub p_locking_clause: *mut List,
    pub p_locked_from_parent: bool,
    pub p_resolve_unknowns: bool,
    pub p_queryEnv: *mut QueryEnvironment,
    pub p_hasAggs: bool,
    pub p_hasWindowFuncs: bool,
    pub p_hasTargetSRFs: bool,
    pub p_hasSubLinks: bool,
    pub p_hasModifyingCTE: bool,
    pub p_last_srf: *mut Node,
    pub p_pre_columnref_hook: PreParseColumnRefHook,
    pub p_post_columnref_hook: PostParseColumnRefHook,
    pub p_paramref_hook: ParseParamRefHook,
    pub p_coerce_param_hook: CoerceParamHook,
    pub p_ref_hook_state: *mut ::std::os::raw::c_void,
}
impl Default for ParseState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParseNamespaceItem {
    pub p_rte: *mut RangeTblEntry,
    pub p_rtindex: ::std::os::raw::c_int,
    pub p_nscolumns: *mut ParseNamespaceColumn,
    pub p_rel_visible: bool,
    pub p_cols_visible: bool,
    pub p_lateral_only: bool,
    pub p_lateral_ok: bool,
}
impl Default for ParseNamespaceItem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParseNamespaceColumn {
    pub p_varno: Index,
    pub p_varattno: AttrNumber,
    pub p_vartype: Oid,
    pub p_vartypmod: int32,
    pub p_varcollid: Oid,
    pub p_varnosyn: Index,
    pub p_varattnosyn: AttrNumber,
}
impl Default for ParseNamespaceColumn {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ParseCallbackState {
    pub pstate: *mut ParseState,
    pub location: ::std::os::raw::c_int,
    pub errcallback: ErrorContextCallback,
}
impl Default for ParseCallbackState {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn make_parsestate(parentParseState: *mut ParseState) -> *mut ParseState;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn free_parsestate(pstate: *mut ParseState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn parser_errposition(
        pstate: *mut ParseState,
        location: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn setup_parser_errposition_callback(
        pcbstate: *mut ParseCallbackState,
        pstate: *mut ParseState,
        location: ::std::os::raw::c_int,
    );
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn cancel_parser_errposition_callback(pcbstate: *mut ParseCallbackState);
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn transformContainerType(containerType: *mut Oid, containerTypmod: *mut int32) -> Oid;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn transformContainerSubscripts(
        pstate: *mut ParseState,
        containerBase: *mut Node,
        containerType: Oid,
        elementType: Oid,
        containerTypMod: int32,
        indirection: *mut List,
        assignFrom: *mut Node,
    ) -> *mut SubscriptingRef;
}
#[pgrx_macros::pg_guard]
extern "C" {
    pub fn make_const(
        pstate: *mut ParseState,
        value: *mut Value,
        location: ::std::os::raw::c_int,
    ) -> *mut Const;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AclItem {
    pub ai_grantee: Oid,
    pub ai_grantor: Oid,
    pub ai_privs: AclMode,
}
impl Default for AclItem {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type Acl = ArrayType;
pub const AclMaskHow_ACLMASK_ALL: AclMaskHow = 0;
pub const AclMaskHow_ACLMASK_ANY: AclMaskHow = 1;
pub type AclMaskHow = ::std::os::raw::c_uint;
pub const AclResult_ACLCHECK_OK: AclResult = 0;
pub const AclResult_ACLCHECK_NO_PRIV: AclResult = 1;
pub const AclResul