# Contributing to CloudEvents sdk-go

:+1::tada: First off, thanks for taking the time to contribute! :tada::+1:

We welcome contributions from the community! Please take some time to become
acquainted with the process before submitting a pull request. There are just
a few things to keep in mind.

## Pull Requests

Typically a pull request should relate to an existing issue. If you have
found a bug, want to add an improvement, or suggest an API change, please
create an issue before proceeding with a pull request. For very minor changes
such as typos in the documentation this isn't really necessary.

For step by step help with managing your pull request, have a look at our
[PR Guidelines](pr_guidelines.md) document.

### Sign your work

Each PR must be signed. Be sure your `git` `user.name` and `user.email` are configured
then use the `--signoff` flag for your commits.

```console
git commit --signoff
```

### Style Guide

Code style for this module is maintained using [`go fmt`](https://golang.org/cmd/go/#hdr-Gofmt__reformat__package_sources).

### Maintainers

If you are a maintainer of this repository, [here](maintainers_guide.pr) is a brief
guide with helpful tips.
