# Mantine

[![NPM](https://img.shields.io/npm/l/@mantine/core)](https://github.com/mantinedev/mantine/blob/master/LICENSE)
[![GitHub contributors](https://img.shields.io/github/contributors/mantinedev/mantine)](https://github.com/mantinedev/mantine/graphs/contributors)
[![npm](https://img.shields.io/npm/v/@mantine/core)](https://www.npmjs.com/package/@mantine/core)
[![npm](https://img.shields.io/npm/dm/@mantine/hooks)](https://www.npmjs.com/package/@mantine/hooks)
[![Help wanted](https://img.shields.io/github/labels/mantinedev/mantine/help%20wanted?label=Contribute)](https://github.com/mantinedev/mantine/labels/help%20wanted)
[![Discord](https://img.shields.io/badge/Chat%20on-Discord-%235865f2)](https://discord.gg/eUZpPbpxb4)
[![Twitter Follow](https://img.shields.io/twitter/follow/mantinedev?style=social)](https://twitter.com/mantinedev)

## Links

- [Documentation](https://mantine.dev/)
- [Contributing](https://mantine.dev/pages/contributing/)
- [Ask question or give feedback](https://github.com/mantinedev/mantine/discussions)
- [Changelog](https://mantine.dev/pages/changelog/)
- [Follow on Twitter](https://twitter.com/mantinedev)
- [Join Discord community](https://discord.gg/eUZpPbpxb4)

## Packages

- `@mantine/hooks` – collection of 40+ hooks for state and UI management
- [`@mantine/styles`](https://mantine.dev/styles/create-styles/) – [emotion](https://emotion.sh/) based css-in-js library that is used in all Mantine components
- `@mantine/core` – core components library – 100+ components, exports everything from `@mantine/styles`
- [`@mantine/form`](https://mantine.dev/form/use-form/) – forms management library
- [`@mantine/notifications`](https://mantine.dev/others/notifications/) – a fully featured notifications system
- [`@mantine/spotlight`](https://mantine.dev/others/spotlight/) – `Ctrl + K` command center for your application
- [`@mantine/prism`](https://mantine.dev/others/prism/) – code highlight built with [prism-react-renderer](https://github.com/FormidableLabs/prism-react-renderer)
- [`@mantine/rte`](https://mantine.dev/others/rte/) – a Quill based rich text editor
- [`@mantine/dropzone`](https://mantine.dev/others/dropzone/) – manages files drag 'n' drop to an area or entire screen
- [`@mantine/carousel`](https://mantine.dev/others/carousel/) – Carousel component
- [`@mantine/nprogress`](https://mantine.dev/others/nprogress/) – navigation progress
- [`@mantine/modals`](https://mantine.dev/others/modals/) – centralized modals manager
- [`@mantine/ssr`](https://mantine.dev/guides/ssr/) – server side rendering utilities
- [`@mantine/next`](https://mantine.dev/guides/next/) – server side rendering utilities for Next.js
- [`@mantine/remix`](https://mantine.dev/guides/remix/) – server side rendering utilities for Remix
- [`gatsby-plugin-mantine`](https://mantine.dev/guides/gatsby/) – Gatsby plugin to setup server side rendering
- [`eslint-config-mantine`](https://www.npmjs.com/package/eslint-config-mantine) – ESLint and Prettier configuration that is used in all Mantine projects

## Getting help

Mantine has a very friendly community, we are always happy to help you get started:

- [Join Discord community](https://discord.gg/eUZpPbpxb4) – it is the easiest way to get help, all questions are usually answered in about 30 minutes
- [GitHub Discussions](https://github.com/mantinedev/mantine/discussions) – ask anything about the project or give feedback

## Contributors

<a href="https://github.com/mantinedev/mantine/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=mantinedev/mantine" />
</a>

[Become a contributor](https://mantine.dev/pages/contributing/)

## License

MIT
