import React from 'react';
import { MantineProvider } from '@mantine/styles';
import { Table } from './Table';

export default { title: 'Table' };

const elements = [
  { position: 6, mass: 12.011, symbol: 'C', name: 'Carbon' },
  { position: 7, mass: 14.007, symbol: 'N', name: 'Nitrogen' },
  { position: 39, mass: 88.906, symbol: 'Y', name: 'Yttrium' },
  { position: 56, mass: 137.33, symbol: 'Ba', name: 'Barium' },
  { position: 58, mass: 140.12, symbol: 'Ce', name: 'Cerium' },
];

export function Usage() {
  const rows = elements.map((element) => (
    <tr key={element.name}>
      <td>{element.position}</td>
      <td>{element.name}</td>
      <td>{element.symbol}</td>
      <td>{element.mass}</td>
    </tr>
  ));

  return (
    <MantineProvider inherit theme={{ spacing: { xs: 0, sm: 2, md: 4, lg: 8, xl: 12 } }}>
      <div style={{ padding: 40 }}>
        <Table verticalSpacing="xl" horizontalSpacing="xs" fontSize="xl" striped>
          <thead>
            <tr>
              <th>Element position</th>
              <th>Element name</th>
              <th>Symbol</th>
              <th>Atomic mass</th>
            </tr>
          </thead>
          <tbody>{rows}</tbody>
        </Table>
      </div>
    </MantineProvider>
  );
}
