/* eslint-disable no-console */
import React from 'react';
import { storiesOf } from '@storybook/react';
import { Button, Text, Group } from '@mantine/core';
import {
  ModalsProvider,
  openConfirmModal,
  openContextModal,
  openModal,
  closeAllModals,
  closeModal,
  ContextModalProps,
} from './index';

function Demo() {
  const showContextModal = () =>
    openContextModal({
      modalId: 'context-modal',
      modal: 'hello',
      title: 'Context modal',
      onClose: () => console.log('context modal closed'),
      innerProps: {
        contextProp: 'test-modal',
      },
    });

  const showContentModal = () =>
    openModal({
      modalId: 'content-modal',
      title: 'Hello there',
      children: (
        <Text color="blue" onClick={() => closeModal('content-modal')}>
          My content modal
        </Text>
      ),
      onClose: () => console.log('content modal 1 closed'),
    });

  const showSingleConfirmModal = () =>
    openConfirmModal({
      title: 'Just confirm',
      onCancel: () => console.log('Single confirm modal cancelled'),
      onConfirm: () => console.log('Single confirm modal confirmed'),
      onClose: () => console.log('Single confirm modal closed'),
    });

  const showNestedModal = () =>
    openConfirmModal({
      title: 'Are you really sure?',
      closeOnConfirm: false,
      onConfirm: closeAllModals,
      onClose: () => console.log('confirm modal 2 closed'),
    });

  const showConfirmModal = () =>
    openConfirmModal({
      title: 'Please confirm this action',
      confirmProps: { color: 'red' },
      closeOnConfirm: false,
      children: (
        <Text size="sm" color="dimmed">
          Lorem ipsum dolor sit amet consectetur adipisicing elit. Ratione magnam modi vitae
          molestias unde tempora exercitationem fugit, ex repellat doloribus maiores facilis quo
          quis, itaque temporibus obcaecati vel iusto praesentium.
        </Text>
      ),
      onCancel: () => console.log('Cancel'),
      onConfirm: showNestedModal,
      onClose: () => console.log('confirm modal 1 closed'),
    });

  return (
    <Group sx={{ padding: 40 }}>
      <Button onClick={showContextModal}>Open context modal</Button>
      <Button onClick={showConfirmModal} color="red">
        Open nested confirm modal
      </Button>
      <Button onClick={showSingleConfirmModal} color="cyan">
        Open single confirm modal
      </Button>
      <Button onClick={showContentModal} color="violet">
        Open content modal
      </Button>
    </Group>
  );
}

storiesOf('Modals Manager', module).add('Custom modal', () => (
  <ModalsProvider
    modals={{
      hello: ({ context, id, innerProps }: ContextModalProps<{ contextProp: string }>) => {
        console.log(innerProps, id, context);
        return (
          <div>
            <div>Test custom modal: {innerProps.contextProp}</div>
            <Button onClick={() => context.closeModal(id)}>Close</Button>
          </div>
        );
      },
    }}
    labels={{ confirm: 'Confirm', cancel: 'Cancel' }}
  >
    <Demo />
  </ModalsProvider>
));
