#!/usr/bin/python

import sys

pairs = []
for line in sys.stdin:
    pairs.extend(line.strip().split())
pairs = zip(pairs[::2], pairs[1::2])

fixed = {
    'ERROR_ACCESS_DENIED': 'STATUS_ACCESS_DENIED',
    'ERROR_CANNOT_IMPERSONATE': 'STATUS_CANNOT_IMPERSONATE',
    'ERROR_CONNECTION_ABORTED': 'STATUS_CONNECTION_ABORTED',
    'ERROR_CTX_LICENSE_NOT_AVAILABLE': 'STATUS_CTX_LICENSE_NOT_AVAILABLE',
    'ERROR_DRIVER_BLOCKED': 'STATUS_DRIVER_BLOCKED',
    'ERROR_EA_LIST_INCONSISTENT': 'STATUS_EA_LIST_INCONSISTENT',
    'ERROR_FILE_INVALID': 'STATUS_FILE_INVALID',
    'ERROR_HOST_UNREACHABLE': 'STATUS_HOST_UNREACHABLE',
    'ERROR_INTERNAL_ERROR': 'STATUS_INTERNAL_ERROR',
    'ERROR_INVALID_HANDLE': 'STATUS_INVALID_HANDLE',
    'ERROR_INVALID_PARAMETER': 'STATUS_INVALID_PARAMETER',
    'ERROR_INVALID_USER_BUFFER': 'STATUS_INVALID_USER_BUFFER',
    'ERROR_LOGON_FAILURE': 'STATUS_LOGON_FAILURE',
    'ERROR_MEDIA_CHANGED': 'STATUS_MEDIA_CHANGED',
    'ERROR_NOT_LOCKED': 'STATUS_NOT_LOCKED',
    'ERROR_NOT_SUPPORTED': 'STATUS_NOT_SUPPORTED',
    'ERROR_NO_LOGON_SERVERS': 'STATUS_NO_LOGON_SERVERS',
    'ERROR_NO_SUCH_LOGON_SESSION': 'STATUS_NO_SUCH_LOGON_SESSION',
    'ERROR_NO_SUCH_PACKAGE': 'STATUS_NO_SUCH_PACKAGE',
    'ERROR_NO_USER_SESSION_KEY': 'STATUS_NO_USER_SESSION_KEY',
    'ERROR_PASSWORD_EXPIRED': 'STATUS_PASSWORD_EXPIRED',
    'ERROR_PIPE_BUSY': 'STATUS_PIPE_BUSY',
    'ERROR_STACK_OVERFLOW': 'STATUS_STACK_OVERFLOW',
    'ERROR_TOO_MANY_NAMES': 'STATUS_TOO_MANY_NAMES',
    'ERROR_TRUST_FAILURE': 'STATUS_TRUST_FAILURE',
    'ERROR_ACCESS_DISABLED_BY_POLICY': 'STATUS_ACCESS_DISABLED_BY_POLICY_OTHER',
    'ERROR_BAD_EXE_FORMAT': 'STATUS_INVALID_IMAGE_FORMAT',
    'ERROR_BAD_NETPATH': 'STATUS_BAD_NETWORK_PATH',
    'ERROR_BAD_PATHNAME': 'STATUS_OBJECT_PATH_INVALID',
    'ERROR_BAD_PIPE': 'STATUS_INVALID_PIPE_STATE',
    'ERROR_CRC': 'STATUS_CRC_ERROR',
    'ERROR_DEV_NOT_EXIST': 'STATUS_DEVICE_DOES_NOT_EXIST',
    'ERROR_DUP_NAME': 'STATUS_DUPLICATE_NAME',
    'ERROR_FILE_CORRUPT': 'STATUS_FILE_CORRUPT_ERROR',
    'ERROR_FILE_NOT_FOUND': 'STATUS_OBJECT_NAME_NOT_FOUND',
    'ERROR_HANDLE_EOF': 'STATUS_END_OF_FILE',
    'ERROR_INSUFFICIENT_BUFFER': 'STATUS_BUFFER_TOO_SMALL',
    'ERROR_INVALID_ADDRESS': 'STATUS_MEMORY_NOT_ALLOCATED',
    'ERROR_INVALID_FUNCTION': 'STATUS_NOT_IMPLEMENTED',
    'ERROR_INVALID_NETNAME': 'STATUS_INVALID_ADDRESS_COMPONENT',
    'ERROR_INVALID_ORDINAL': 'STATUS_ORDINAL_NOT_FOUND',
    'ERROR_INVALID_PASSWORD': 'STATUS_WRONG_PASSWORD',
    'ERROR_IO_DEVICE': 'STATUS_IO_DEVICE_ERROR',
    'ERROR_LOCK_VIOLATION': 'STATUS_LOCK_NOT_GRANTED',
    'ERROR_MORE_DATA': 'STATUS_BUFFER_OVERFLOW',
    'ERROR_MUTUAL_AUTH_FAILED': 'STATUS_MUTUAL_AUTHENTICATION_FAILED',
    'ERROR_NETNAME_DELETED': 'STATUS_NETWORK_NAME_DELETED',
    'ERROR_NOACCESS': 'STATUS_ACCESS_VIOLATION',
    'ERROR_NOT_ENOUGH_MEMORY': 'STATUS_NO_MEMORY',
    'ERROR_NOT_OWNER': 'STATUS_RESOURCE_NOT_OWNED',
    'ERROR_NOT_READY': 'STATUS_DEVICE_NOT_READY',
    'ERROR_NO_DATA': 'STATUS_PIPE_EMPTY',
    'ERROR_NO_MORE_ITEMS': 'STATUS_NO_MORE_ENTRIES',
    'ERROR_NO_SYSTEM_RESOURCES': 'STATUS_INSUFFICIENT_RESOURCES',
    'ERROR_PATH_NOT_FOUND': 'STATUS_OBJECT_PATH_NOT_FOUND',
    'ERROR_PROC_NOT_FOUND': 'STATUS_PROCEDURE_NOT_FOUND',
    'ERROR_REM_NOT_LIST': 'STATUS_REMOTE_NOT_LISTENING',
    'ERROR_SERVICE_ALREADY_RUNNING': 'STATUS_IMAGE_ALREADY_LOADED',
    'ERROR_UNEXP_NET_ERR': 'STATUS_UNEXPECTED_NETWORK_ERROR',
    'ERROR_WRITE_PROTECT': 'STATUS_MEDIA_WRITE_PROTECTED',
}
errmap = {}
for pair in pairs:
    if not pair[1] in fixed:
        assert pair[1] not in errmap
        errmap[pair[1]] = pair[0]
errmap.update(fixed)

if "FspNtStatusFromWin32" == sys.argv[1]:
    for w, s in sorted(errmap.items()):
        print "case %-40s return %s;" % (w + ':', s)
elif "FspWin32FromNtStatus" == sys.argv[1]:
    for s, w in sorted(pairs):
        print "case %-40s return %s;" % (s + ':', w)
