/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.cli.SemanticAnalysis;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AbstractSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DescDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.plan.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.plan.ShowTablesDesc;
import org.apache.hadoop.hive.ql.plan.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.CreateDatabaseHook;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.CreateTableHook;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.HCatSemanticAnalyzerBase;
import org.apache.hive.hcatalog.common.ErrorType;
import org.apache.hive.hcatalog.common.HCatException;

public class HCatSemanticAnalyzer
extends HCatSemanticAnalyzerBase {
    private AbstractSemanticAnalyzerHook hook;
    private ASTNode ast;

    public ASTNode preAnalyze(HiveSemanticAnalyzerHookContext context, ASTNode ast) throws SemanticException {
        this.ast = ast;
        switch (ast.getToken().getType()) {
            case 631: {
                this.hook = new CreateTableHook();
                return this.hook.preAnalyze(context, ast);
            }
            case 625: {
                this.hook = new CreateDatabaseHook();
                return this.hook.preAnalyze(context, ast);
            }
            case 596: {
                if (((ASTNode)ast.getChild(1)).getToken().getType() == 592) {
                    return ast;
                }
                if (((ASTNode)ast.getChild(1)).getToken().getType() == 594) {
                    throw new SemanticException("Operation not supported.");
                }
                return ast;
            }
            case 583: 
            case 584: 
            case 586: 
            case 587: 
            case 589: 
            case 590: 
            case 591: 
            case 597: 
            case 599: 
            case 600: 
            case 602: 
            case 603: 
            case 604: 
            case 606: 
            case 611: 
            case 612: 
            case 613: 
            case 627: 
            case 630: 
            case 632: 
            case 646: 
            case 647: 
            case 648: 
            case 654: 
            case 656: 
            case 658: 
            case 659: 
            case 661: 
            case 665: 
            case 677: 
            case 678: 
            case 680: 
            case 715: 
            case 775: 
            case 776: 
            case 788: 
            case 790: 
            case 791: 
            case 792: 
            case 793: 
            case 794: 
            case 797: 
            case 799: 
            case 802: 
            case 821: 
            case 873: {
                return ast;
            }
        }
        throw new SemanticException("Operation not supported.");
    }

    @Override
    public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<? extends Serializable>> rootTasks) throws SemanticException {
        try {
            switch (this.ast.getToken().getType()) {
                case 583: 
                case 584: 
                case 586: 
                case 587: 
                case 589: 
                case 590: 
                case 591: 
                case 596: 
                case 597: 
                case 599: 
                case 600: 
                case 602: 
                case 603: 
                case 604: 
                case 606: 
                case 611: 
                case 612: 
                case 613: 
                case 625: 
                case 627: 
                case 630: 
                case 631: 
                case 632: 
                case 646: 
                case 647: 
                case 648: 
                case 654: 
                case 656: 
                case 658: 
                case 659: 
                case 661: 
                case 665: 
                case 677: 
                case 678: 
                case 680: 
                case 715: 
                case 775: 
                case 776: 
                case 788: 
                case 790: 
                case 791: 
                case 792: 
                case 793: 
                case 794: 
                case 797: 
                case 799: 
                case 802: 
                case 821: 
                case 873: {
                    break;
                }
                default: {
                    throw new HCatException(ErrorType.ERROR_INTERNAL_EXCEPTION, "Unexpected token: " + this.ast.getToken());
                }
            }
            this.authorizeDDL(context, rootTasks);
        }
        catch (HCatException e) {
            throw new SemanticException((Throwable)e);
        }
        catch (HiveException e) {
            throw new SemanticException((Throwable)e);
        }
        if (this.hook != null) {
            this.hook.postAnalyze(context, rootTasks);
        }
    }

    private String extractTableName(String compoundName) {
        String[] words = compoundName.split("\\.");
        return words[0];
    }

    @Override
    protected void authorizeDDLWork(HiveSemanticAnalyzerHookContext cntxt, Hive hive, DDLWork work) throws HiveException {
        ShowPartitionsDesc showParts;
        DescTableDesc descTable;
        AlterTableDesc alterTable;
        DropTableDesc dropTable;
        ShowTableStatusDesc showTableStatus;
        ShowTablesDesc showTables;
        SwitchDatabaseDesc switchDb;
        DescDatabaseDesc descDb;
        Database db;
        DropDatabaseDesc dropDb;
        ShowDatabasesDesc showDatabases = work.getShowDatabasesDesc();
        if (showDatabases != null) {
            this.authorize(HiveOperation.SHOWDATABASES.getInputRequiredPrivileges(), HiveOperation.SHOWDATABASES.getOutputRequiredPrivileges());
        }
        if ((dropDb = work.getDropDatabaseDesc()) != null && (db = cntxt.getHive().getDatabase(dropDb.getDatabaseName())) != null) {
            this.authorize(db, Privilege.DROP);
        }
        if ((descDb = work.getDescDatabaseDesc()) != null) {
            Database db2 = cntxt.getHive().getDatabase(descDb.getDatabaseName());
            this.authorize(db2, Privilege.SELECT);
        }
        if ((switchDb = work.getSwitchDatabaseDesc()) != null) {
            Database db3 = cntxt.getHive().getDatabase(switchDb.getDatabaseName());
            this.authorize(db3, Privilege.SELECT);
        }
        if ((showTables = work.getShowTblsDesc()) != null) {
            String dbName = showTables.getDbName() == null ? SessionState.get().getCurrentDatabase() : showTables.getDbName();
            this.authorize(cntxt.getHive().getDatabase(dbName), Privilege.SELECT);
        }
        if ((showTableStatus = work.getShowTblStatusDesc()) != null) {
            String dbName = showTableStatus.getDbName() == null ? SessionState.get().getCurrentDatabase() : showTableStatus.getDbName();
            this.authorize(cntxt.getHive().getDatabase(dbName), Privilege.SELECT);
        }
        if ((dropTable = work.getDropTblDesc()) != null && dropTable.getPartSpecs() != null) {
            for (DropTableDesc.PartSpec partSpec : dropTable.getPartSpecs()) {
                Table table = hive.getTable(SessionState.get().getCurrentDatabase(), dropTable.getTableName());
                List partitions = null;
                try {
                    partitions = hive.getPartitionsByFilter(table, partSpec.getPartSpec().getExprString());
                }
                catch (Exception e) {
                    throw new HiveException((Throwable)e);
                }
                for (Partition part : partitions) {
                    this.authorize(part, Privilege.DROP);
                }
            }
        }
        if ((alterTable = work.getAlterTblDesc()) != null) {
            Table table = hive.getTable(SessionState.get().getCurrentDatabase(), alterTable.getOldName(), false);
            Partition part = null;
            if (alterTable.getPartSpec() != null) {
                part = hive.getPartition(table, (Map)alterTable.getPartSpec(), false);
            }
            String newLocation = alterTable.getNewLocation();
            if (alterTable.getOp() == AlterTableDesc.AlterTableTypes.ALTERLOCATION) {
                if (part != null) {
                    this.authorize(part, Privilege.ALTER_DATA);
                    part.setLocation(newLocation);
                    this.authorize(part, Privilege.ALTER_DATA);
                } else {
                    this.authorize(table, Privilege.ALTER_DATA);
                    table.getTTable().getSd().setLocation(newLocation);
                    this.authorize(table, Privilege.ALTER_DATA);
                }
            }
        }
        if ((descTable = work.getDescTblDesc()) != null) {
            String tableName = this.extractTableName(descTable.getTableName());
            this.authorizeTable(cntxt.getHive(), tableName, Privilege.SELECT);
        }
        if ((showParts = work.getShowPartsDesc()) != null) {
            String tableName = this.extractTableName(showParts.getTabName());
            this.authorizeTable(cntxt.getHive(), tableName, Privilege.SELECT);
        }
    }
}

