<?php

namespace Collections\Iterator;

class LazyValuesIterator implements \Iterator
{
    /**
     * @var \Iterator
     */
    private $it;

    public function __construct($it)
    {
        $this->it = $it;
    }

    public function __clone()
    {
        $this->it = clone $this->it;
    }

    public function rewind()
    {
        $this->it->rewind();
    }

    public function valid()
    {
        return $this->it->valid();
    }

    public function next()
    {
        $this->it->next();
    }

    public function key()
    {
        return null;
    }

    public function current()
    {
        return $this->it->current();
    }
}
