---
title: "Env"
weight: 20
---

# Env

{{< hint info >}}
The values of all environment variables have a lower priority than flags.
{{< /hint >}}

Avoid typing the same flag values repeatedly every time by setting environment variables.

|          NAME           |         FLAG          |
|:-----------------------:|:---------------------:|
|        `TDL_NS`         |       `-n/--ns`       |
|       `TDL_PROXY`       |       `--proxy`       |
|      `TDL_STORAGE`      |      `--storage`      |
|       `TDL_DEBUG`       |       `--debug`       |
|       `TDL_SIZE`        |      `-s/--size`      |
|      `TDL_THREADS`      |    `-t/--threads`     |
|       `TDL_LIMIT`       |     `-l/--limit`      |
|       `TDL_POOL`        |       `--pool`        |
|        `TDL_NTP`        |        `--ntp`        |
| `TDL_RECONNECT_TIMEOUT` | `--reconnect-timeout` |
|     `TDL_TEMPLATE`      |    dl `--template`    |

{{< hint warning >}}
- `TDL_STORAGE` format in env is different from that in flags: `{"type": "bolt", "path": "/path/to/data-dir"}` (JSON object).
{{< /hint >}}
