/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.testing;

import com.android.annotations.NonNull;
import com.android.builder.testing.ConnectedDevice;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;

public class ConnectedDeviceProvider
extends DeviceProvider {
    @NonNull
    private final File adbLocation;
    @NonNull
    private final List<ConnectedDevice> localDevices = Lists.newArrayList();

    public ConnectedDeviceProvider(@NonNull File adbLocation) {
        this.adbLocation = adbLocation;
    }

    @NonNull
    public String getName() {
        return "connected";
    }

    @NonNull
    public List<? extends DeviceConnector> getDevices() {
        return this.localDevices;
    }

    public void init() throws DeviceException {
        try {
            long timeOut;
            AndroidDebugBridge.initIfNeeded((boolean)false);
            AndroidDebugBridge bridge = AndroidDebugBridge.createBridge((String)this.adbLocation.getAbsolutePath(), (boolean)false);
            int sleepTime = 1000;
            for (timeOut = 30000L; !bridge.hasInitialDeviceList() && timeOut > 0L; timeOut -= (long)sleepTime) {
                Thread.sleep(sleepTime);
            }
            if (timeOut <= 0L && !bridge.hasInitialDeviceList()) {
                throw new RuntimeException("Timeout getting device list.", null);
            }
            IDevice[] devices = bridge.getDevices();
            if (devices.length == 0) {
                throw new RuntimeException("No connected devices!", null);
            }
            for (IDevice iDevice : devices) {
                this.localDevices.add(new ConnectedDevice(iDevice));
            }
        }
        catch (Exception e) {
            throw new DeviceException((Throwable)e);
        }
    }

    public void terminate() throws DeviceException {
    }

    public int getTimeout() {
        return 0;
    }

    public boolean isConfigured() {
        return true;
    }
}

