/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.truth.AutoValue_Expect_ExpectationFailure;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.StringUtil;
import com.google.common.truth.TestVerb;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@GwtIncompatible(value="JUnit4")
public class Expect
extends TestVerb
implements TestRule {
    private final ExpectationGatherer gatherer;
    private boolean inRuleContext = false;

    public static Expect create() {
        return Expect.create(new ExpectationGatherer());
    }

    public static Expect create(ExpectationGatherer gatherer) {
        return new Expect(gatherer);
    }

    public static Expect createAndEnableStackTrace() {
        return new Expect(new ExpectationGatherer(true));
    }

    Expect(ExpectationGatherer gatherer) {
        super(gatherer);
        this.gatherer = gatherer;
    }

    public boolean hasFailures() {
        return !this.gatherer.getMessages().isEmpty();
    }

    @Override
    protected FailureStrategy getFailureStrategy() {
        if (!this.inRuleContext) {
            String message = "assertion made on Expect instance, but it's not enabled as a @Rule.";
            throw new IllegalStateException(message);
        }
        return super.getFailureStrategy();
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Expect.this.inRuleContext = true;
                base.evaluate();
                Expect.this.inRuleContext = false;
                Throwable earliestCause = null;
                if (!Expect.this.gatherer.getMessages().isEmpty()) {
                    AssertionError error = new AssertionError((Object)Expect.this.gatherer.toString());
                    ((Throwable)((Object)error)).initCause(earliestCause);
                    throw error;
                }
            }
        };
    }

    static abstract class ExpectationFailure {
        static ExpectationFailure create(String message, Throwable cause) {
            return new AutoValue_Expect_ExpectationFailure(message, cause);
        }

        static ExpectationFailure create(String message) {
            return new AutoValue_Expect_ExpectationFailure(message, null);
        }

        ExpectationFailure() {
        }

        abstract String message();

        @Nullable
        abstract Throwable cause();
    }

    public static class ExpectationGatherer
    extends FailureStrategy {
        private final List<ExpectationFailure> messages = new ArrayList<ExpectationFailure>();
        private final boolean showStackTrace;

        public ExpectationGatherer() {
            this.showStackTrace = false;
        }

        public ExpectationGatherer(boolean showStackTrace) {
            this.showStackTrace = showStackTrace;
        }

        @Override
        public void fail(String message) {
            this.fail(message, new Throwable(message));
        }

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual) {
            String errorMessage = StringUtil.messageFor(message, expected, actual);
            this.fail(errorMessage, new Throwable(errorMessage));
        }

        @Override
        public void fail(String message, Throwable cause) {
            this.messages.add(ExpectationFailure.create(message, cause));
        }

        public List<ExpectationFailure> getMessages() {
            return this.messages;
        }

        public String toString() {
            Throwable earliestCause = null;
            StringBuilder message = new StringBuilder("All failed expectations:\n");
            int count = 0;
            for (ExpectationFailure failure : this.getMessages()) {
                if (earliestCause == null && failure.cause() != null) {
                    earliestCause = failure.cause();
                }
                message.append("  ").append(count++ + 1).append(". ").append(failure.message()).append("\n");
                if (!this.showStackTrace || failure.cause() == null) continue;
                StringWriter stackTraceWriter = new StringWriter();
                failure.cause().printStackTrace(new PrintWriter(stackTraceWriter));
                String string = String.valueOf(String.valueOf(stackTraceWriter));
                message.append(new StringBuilder(1 + string.length()).append(string).append("\n").toString());
            }
            return message.toString();
        }
    }
}

