---
layout: community
---

# Open-source projects using Bazel

If you'd like your project listed here, please
[let us know](mailto:kchodorow@google.com?subject=My project uses Bazel)!

## [GRPC](http://www.grpc.io)

A language-and-platform-neutral remote procedure call system. (Bazel is a
supported, although not primary, build system.)

## [Error Prone](https://github.com/google/error-prone)

Catches common Java mistakes as compile-time errors. (Migration to Bazel is
in progress.)

## [CallBuilder](https://github.com/google/CallBuilder)

A Java code generator that allows you to create a builder by writing one
function.

## [Kythe](https://github.com/google/kythe)

An ecosystem for building tools that work with code.

## [Trunk](https://github.com/mzhaom/trunk)

A collection of C++/Java opensource projects with BUILD files so they
can be built with Bazel with out of box support for protobuf and
grpc (maybe thrift).

## [Turbo Santa](https://github.com/turbo-santa/turbo-santa-common)

A platform-independent GameBoy emulator.

# Corporate users of Bazel

## [Braintree](https://www.braintreepayments.com)

Braintree, a PayPal subsidiary, develops payment solutions for websites and
applications. They use Bazel for parts of their internal build and Paul Gross
even posted a [nice piece about how their switch to
Bazel went](https://www.pgrs.net/2015/09/01/migrating-from-gradle-to-bazel/).

## [Makani](https://www.google.com/makani)

Makani, now a Google subsidiary, develops energy kites and uses
Bazel to build their software (including their embedded C++ software).

