"""Test Kostal Plenticore diagnostics."""
from aiohttp import ClientSession

from homeassistant.components.diagnostics import REDACTED
from homeassistant.core import HomeAssistant

from tests.common import MockConfigEntry
from tests.components.diagnostics import get_diagnostics_for_config_entry


async def test_entry_diagnostics(
    hass: HomeAssistant, hass_client: ClientSession, init_integration: MockConfigEntry
):
    """Test config entry diagnostics."""
    assert await get_diagnostics_for_config_entry(
        hass, hass_client, init_integration
    ) == {
        "config_entry": {
            "entry_id": "2ab8dd92a62787ddfe213a67e09406bd",
            "version": 1,
            "domain": "kostal_plenticore",
            "title": "scb",
            "data": {"host": "192.168.1.2", "password": REDACTED},
            "options": {},
            "pref_disable_new_entities": False,
            "pref_disable_polling": False,
            "source": "user",
            "unique_id": None,
            "disabled_by": None,
        },
        "client": {
            "version": "Version(api_version=0.2.0, hostname=scb, name=PUCK RESTful API, sw_version=01.16.05025)",
            "me": "Me(locked=False, active=True, authenticated=True, permissions=[] anonymous=False role=USER)",
            "available_process_data": {"devices:local": ["HomeGrid_P", "HomePv_P"]},
            "available_settings_data": {
                "devices:local": [
                    "SettingsData(id=Battery:MinSoc, unit=%, default=None, min=5, max=100,type=byte, access=readwrite)"
                ]
            },
        },
        "device": {
            "configuration_url": "http://192.168.1.2",
            "identifiers": "**REDACTED**",
            "manufacturer": "Kostal",
            "model": "PLENTICORE plus 10",
            "name": "scb",
            "sw_version": "IOC: 01.45 MC: 01.46",
        },
    }
