/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation.directiveValues;

import com.shapesecurity.salvation.data.GUID;
import com.shapesecurity.salvation.data.Origin;
import com.shapesecurity.salvation.data.SchemeHostPortTriple;
import com.shapesecurity.salvation.data.URI;
import com.shapesecurity.salvation.directiveValues.AncestorSource;
import com.shapesecurity.salvation.directiveValues.SourceExpression;
import com.shapesecurity.salvation.interfaces.MatchesSource;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HostSource
implements SourceExpression,
AncestorSource,
MatchesSource {
    public static final HostSource WILDCARD = new HostSource(null, "*", -1, null);
    private static final int WILDCARD_HASHCODE = -1622262038;
    @Nullable
    private final String scheme;
    @Nonnull
    private final String host;
    private final int port;
    @Nullable
    private final String path;

    public HostSource(@Nullable String scheme, @Nonnull String host, int port, @Nullable String path) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null || !(other instanceof HostSource)) {
            return false;
        }
        HostSource otherPrime = (HostSource)other;
        if (this.isWildcard() && otherPrime.isWildcard()) {
            return true;
        }
        return Objects.equals(this.scheme != null ? this.scheme.toLowerCase() : null, otherPrime.scheme != null ? otherPrime.scheme.toLowerCase() : null) && Objects.equals(this.host != null ? this.host.toLowerCase() : null, otherPrime.host != null ? otherPrime.host.toLowerCase() : null) && this.port == otherPrime.port && Objects.equals(this.path, otherPrime.path);
    }

    public int hashCode() {
        int h = 0;
        if (this.scheme != null) {
            h ^= this.scheme.toLowerCase().hashCode() ^ 0xA303EFA3;
        }
        h ^= this.host.toLowerCase().hashCode() ^ 0xFB2290B2;
        h ^= this.port ^ 0xB54E99F3;
        if (this.path != null) {
            h ^= this.path.hashCode() ^ 0x13324C0E;
        }
        return h;
    }

    public boolean isWildcard() {
        return this.host.equals("*") && this.scheme == null && this.port == -1 && this.path == null;
    }

    @Override
    public boolean matchesSource(@Nonnull Origin origin, @Nonnull URI source) {
        boolean portMatches;
        boolean thisUsesDefaultPort;
        if (!(origin instanceof SchemeHostPortTriple)) {
            return false;
        }
        SchemeHostPortTriple shpOrigin = (SchemeHostPortTriple)origin;
        if (this.isWildcard()) {
            return true;
        }
        boolean schemeMatches = this.scheme == null ? (source.scheme.equalsIgnoreCase("http") ? shpOrigin.scheme.equalsIgnoreCase("http") || shpOrigin.scheme.equalsIgnoreCase("https") : source.scheme.equalsIgnoreCase(shpOrigin.scheme)) : this.scheme.equalsIgnoreCase(source.scheme);
        boolean hostMatches = this.host.equals("*") || (this.host.startsWith("*.") ? source.host.toLowerCase().endsWith(this.host.substring(1).toLowerCase()) : this.host.equalsIgnoreCase(source.host));
        boolean uriUsesDefaultPort = source.port == -1 || SchemeHostPortTriple.defaultPortForProtocol(source.scheme) == source.port;
        boolean bl = thisUsesDefaultPort = this.scheme != null && (this.port == -1 || SchemeHostPortTriple.defaultPortForProtocol(this.scheme) == this.port);
        boolean bl2 = this.port == -200 || (this.port == -1 ? uriUsesDefaultPort : (source.port == -1 ? thisUsesDefaultPort : this.port == source.port)) ? true : (portMatches = false);
        boolean pathMatches = this.path == null || (this.path.endsWith("/") ? source.path.startsWith(this.path) : this.path.equals(source.path));
        return schemeMatches && hostMatches && portMatches && pathMatches;
    }

    @Override
    public boolean matchesSource(@Nonnull Origin origin, @Nonnull GUID source) {
        return false;
    }

    public boolean matchesOnlyOrigin(@Nonnull SchemeHostPortTriple origin) {
        boolean thisUsesDefaultPort;
        boolean schemeMatches = this.scheme != null && this.scheme.equalsIgnoreCase(origin.scheme);
        boolean hostMatches = this.host.equalsIgnoreCase(origin.host);
        boolean originUsesDefaultPort = origin.port == -1 || SchemeHostPortTriple.defaultPortForProtocol(origin.scheme) == origin.port;
        boolean bl = thisUsesDefaultPort = this.scheme != null && (this.port == -1 || SchemeHostPortTriple.defaultPortForProtocol(this.scheme) == this.port);
        boolean portMatches = this.port == -1 ? originUsesDefaultPort : (origin.port == -1 ? thisUsesDefaultPort : this.port == origin.port);
        return schemeMatches && hostMatches && portMatches;
    }

    @Override
    @Nonnull
    public String show() {
        boolean isDefaultPort = this.port == -1 || this.scheme != null && this.port == SchemeHostPortTriple.defaultPortForProtocol(this.scheme);
        return (this.scheme == null ? "" : this.scheme + "://") + this.host + (isDefaultPort ? "" : ":" + (this.port == -200 ? "*" : Integer.valueOf(this.port))) + (this.path == null ? "" : this.path);
    }
}

