/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation.directives;

import com.shapesecurity.salvation.data.Base64Value;
import com.shapesecurity.salvation.data.GUID;
import com.shapesecurity.salvation.data.Origin;
import com.shapesecurity.salvation.data.SchemeHostPortTriple;
import com.shapesecurity.salvation.data.URI;
import com.shapesecurity.salvation.directiveValues.HashSource;
import com.shapesecurity.salvation.directiveValues.HostSource;
import com.shapesecurity.salvation.directiveValues.KeywordSource;
import com.shapesecurity.salvation.directiveValues.NonceSource;
import com.shapesecurity.salvation.directiveValues.SourceExpression;
import com.shapesecurity.salvation.directives.Directive;
import com.shapesecurity.salvation.interfaces.MatchesHash;
import com.shapesecurity.salvation.interfaces.MatchesNonce;
import com.shapesecurity.salvation.interfaces.MatchesSource;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class SourceListDirective
extends Directive<SourceExpression>
implements MatchesSource,
MatchesHash,
MatchesNonce {
    SourceListDirective(@Nonnull String name, @Nonnull Set<SourceExpression> values) {
        super(name, values);
    }

    @Override
    public boolean matchesHash(@Nonnull HashSource.HashAlgorithm algorithm, @Nonnull Base64Value hashValue) {
        return this.values().filter(x -> x instanceof MatchesHash).anyMatch(x -> ((MatchesHash)((Object)x)).matchesHash(algorithm, hashValue));
    }

    @Override
    public boolean matchesSource(@Nonnull Origin origin, @Nonnull URI source) {
        return this.values().filter(x -> x instanceof MatchesSource).anyMatch(x -> ((MatchesSource)((Object)x)).matchesSource(origin, source));
    }

    @Override
    public boolean matchesSource(@Nonnull Origin origin, @Nonnull GUID source) {
        return this.values().filter(x -> x instanceof MatchesSource).anyMatch(x -> ((MatchesSource)((Object)x)).matchesSource(origin, source));
    }

    @Override
    public boolean matchesNonce(@Nonnull String nonce) {
        return this.values().filter(x -> x instanceof MatchesNonce).anyMatch(x -> ((MatchesNonce)((Object)x)).matchesNonce(nonce));
    }

    public boolean containsHashSource() {
        return this.values().anyMatch(x -> x instanceof HashSource);
    }

    public boolean containsNonceSource() {
        return this.values().anyMatch(x -> x instanceof NonceSource);
    }

    public boolean containsKeywordsAndNoncesOnly() {
        return this.values().allMatch(x -> x instanceof KeywordSource || x instanceof NonceSource);
    }

    @Nonnull
    public Directive<SourceExpression> resolveSelf(@Nonnull Origin origin) {
        return this.bind(dv -> {
            if (dv == KeywordSource.Self) {
                if (origin instanceof SchemeHostPortTriple) {
                    SchemeHostPortTriple shpOrigin = (SchemeHostPortTriple)origin;
                    return Collections.singleton(new HostSource(shpOrigin.scheme, shpOrigin.host, shpOrigin.port, null));
                }
                if (origin instanceof GUID) {
                    return Collections.EMPTY_SET;
                }
            }
            return null;
        });
    }
}

