/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker.table;

import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class Cell
implements Locator {
    private static final int MAX_COLSPAN = 1000;
    private static final int MAX_ROWSPAN = 8190;
    private int left;
    private int bottom;
    private int right;
    private final String[] headers;
    private final boolean header;
    private final int columnNumber;
    private final int lineNumber;
    private final String publicId;
    private final String systemId;
    private final ErrorHandler errorHandler;

    Cell(int colspan, int rowspan, String[] headers, boolean header, Locator locator, ErrorHandler errorHandler) throws SAXException {
        this.errorHandler = errorHandler;
        if (locator == null) {
            this.columnNumber = -1;
            this.lineNumber = -1;
            this.publicId = null;
            this.systemId = null;
        } else {
            this.columnNumber = locator.getColumnNumber();
            this.lineNumber = locator.getLineNumber();
            this.publicId = locator.getPublicId();
            this.systemId = locator.getSystemId();
        }
        if (rowspan > 8190) {
            this.warn("A rowspan attribute has the value " + rowspan + ", which exceeds the magic Gecko limit of " + 8190 + ".");
        }
        if (colspan > 1000) {
            this.warn("A colspan attribute has the value " + colspan + ", which exceeds the magic browser limit of " + 1000 + ".");
        }
        if (rowspan == Integer.MAX_VALUE) {
            throw new SAXException("Implementation limit reached. Table row counter overflowed.");
        }
        this.left = 0;
        this.right = colspan;
        this.bottom = rowspan == 0 ? Integer.MAX_VALUE : rowspan;
        this.headers = headers;
        this.header = header;
    }

    public String[] getHeadings() {
        return this.headers;
    }

    public boolean isHeader() {
        return this.header;
    }

    public void warn(String message) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.warning(new SAXParseException(message, this.publicId, this.systemId, this.lineNumber, this.columnNumber));
        }
    }

    public void err(String message) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.error(new SAXParseException(message, this.publicId, this.systemId, this.lineNumber, this.columnNumber));
        }
    }

    public void errOnHorizontalOverlap(Cell laterCell) throws SAXException {
        if (laterCell.right > this.left && this.right > laterCell.left) {
            this.err("Table cell is overlapped by later table cell.");
            laterCell.err("Table cell overlaps an earlier table cell.");
        }
    }

    public void setPosition(int top, int left) throws SAXException {
        this.left = left;
        this.right += left;
        if (this.right < 1) {
            throw new SAXException("Implementation limit reached. Table column counter overflowed.");
        }
        if (this.bottom != Integer.MAX_VALUE) {
            this.bottom += top;
            if (this.bottom < 1) {
                throw new SAXException("Implementation limit reached. Table row counter overflowed.");
            }
        }
    }

    public boolean shouldBeCulled(int row) {
        return row >= this.bottom;
    }

    public int getBottom() {
        return this.bottom;
    }

    int getLeft() {
        return this.left;
    }

    int getRight() {
        return this.right;
    }

    public void errIfNotRowspanZero(String rowGroupType) throws SAXException {
        if (this.bottom != Integer.MAX_VALUE) {
            this.err("Table cell spans past the end of its " + (rowGroupType == null ? "implicit row group" : "row group established by a \u201c" + rowGroupType + "\u201d element") + "; clipped to the end of the row group.");
        }
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    public String elementName() {
        return this.header ? "th" : "td";
    }
}

