/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import nu.validator.datatype.AbstractDatatype;
import nu.validator.datatype.data.LanguageData;
import org.relaxng.datatype.DatatypeException;

public final class Language
extends AbstractDatatype {
    public static final Language THE_INSTANCE = new Language();
    private static final Pattern HYPHEN = Pattern.compile("-");
    private static final boolean WARN = System.getProperty("nu.validator.datatype.warn", "").equals("true");
    private static String[] languages = null;
    private static String[] extlangs = null;
    private static String[] scripts = null;
    private static String[] regions = null;
    private static String[] variants = null;
    private static String[] grandfathered = null;
    private static String[] redundant = null;
    private static String[] deprecated = null;
    private static String[] deprecatedLang = null;
    private static int[] suppressedScriptByLanguage = null;
    private static Map<String, String> preferredValueByLanguageMap = new HashMap<String, String>();
    private static String[][][] prefixesByVariant = null;
    private static int[] prefixByExtlang = null;

    private Language() {
    }

    @Override
    public void checkValid(CharSequence lit) throws DatatypeException {
        String[] subtags;
        String literal = lit.toString();
        if (literal.length() == 0) {
            throw this.newDatatypeException("The empty string is not a valid language tag.");
        }
        if (this.isGrandfathered(literal = Language.toAsciiLowerCase(literal))) {
            if (this.isDeprecated(literal) && WARN) {
                throw this.newDatatypeException("The grandfathered language tag ", literal, " is deprecated. Use \u201c" + preferredValueByLanguageMap.get(literal) + "\u201d instead.", WARN);
            }
            return;
        }
        if (this.isRedundant(literal)) {
            if (this.isDeprecated(literal) && WARN) {
                throw this.newDatatypeException("The language tag ", lit.toString(), " is deprecated. Use \u201c" + preferredValueByLanguageMap.get(literal) + "\u201d instead.", WARN);
            }
            return;
        }
        if (literal.startsWith("-")) {
            throw this.newDatatypeException("Language tag must not start with HYPHEN-MINUS.");
        }
        if (literal.endsWith("-")) {
            throw this.newDatatypeException("Language tag must not end with HYPHEN-MINUS.");
        }
        for (String subtag : subtags = HYPHEN.split(literal)) {
            int len = subtag.length();
            if (len == 0) {
                throw this.newDatatypeException("Zero-length subtag.");
            }
            if (len <= 8) continue;
            throw this.newDatatypeException("Subtags must not exceed 8 characters in length.");
        }
        int i = 0;
        String subtag = subtags[i];
        int len = subtag.length();
        if ("x".equals(subtag)) {
            this.checkPrivateUse(i, subtags);
            return;
        }
        if ((len == 2 || len == 3) && this.isLowerCaseAlpha(subtag)) {
            if (!this.isLanguage(subtag)) {
                throw this.newDatatypeException("The language subtag ", subtag, " is not a valid ISO language part of a language tag.");
            }
            if (this.isDeprecatedLang(subtag) && WARN) {
                throw this.newDatatypeException("The language subtag ", subtag, " is deprecated. Use \u201c" + preferredValueByLanguageMap.get(subtag) + "\u201d instead.", WARN);
            }
            if (++i == subtags.length) {
                return;
            }
            subtag = subtags[i];
            len = subtag.length();
        } else {
            if (len == 4 && this.isLowerCaseAlpha(subtag)) {
                throw this.newDatatypeException("Found reserved language tag: ", subtag, ".");
            }
            if (len >= 5 && this.isLowerCaseAlpha(subtag)) {
                if (!this.isLanguage(subtag)) {
                    throw this.newDatatypeException("The language subtag ", subtag, " is not a valid IANA language part of a language tag.");
                }
                if (this.isDeprecatedLang(subtag) && WARN) {
                    throw this.newDatatypeException("The language subtag ", subtag, " is deprecated. Use \u201c" + preferredValueByLanguageMap.get(subtag) + "\u201d instead.", WARN);
                }
                if (++i == subtags.length) {
                    return;
                }
                subtag = subtags[i];
                len = subtag.length();
            } else {
                throw this.newDatatypeException("The language subtag ", subtag, " is not a valid language subtag.");
            }
        }
        if ("x".equals(subtag)) {
            this.checkPrivateUse(i, subtags);
            return;
        }
        if (subtag.length() == 3 && this.isLowerCaseAlpha(subtag)) {
            if (!this.isExtlang(subtag)) {
                throw this.newDatatypeException("Bad extlang subtag ", subtag, ".");
            }
            if (!this.usesPrefixByExtlang(subtags[0], subtag)) {
                throw this.newDatatypeException("Extlang subtag ", subtag, " has an incorrect prefix.");
            }
            if (++i == subtags.length) {
                return;
            }
            subtag = subtags[i];
            len = subtag.length();
        }
        if ("x".equals(subtag)) {
            this.checkPrivateUse(i, subtags);
            return;
        }
        if (subtag.length() == 4 & this.isLowerCaseAlpha(subtag)) {
            if (!this.isScript(subtag)) {
                throw this.newDatatypeException("Bad script subtag.");
            }
            if (this.isDeprecated(subtag) && WARN) {
                throw this.newDatatypeException("The script subtag ", subtag, " is deprecated. Use \u201c" + preferredValueByLanguageMap.get(subtag) + "\u201d instead.", WARN);
            }
            if (this.shouldSuppressScript(subtags[0], subtag)) {
                throw this.newDatatypeException("Language tag should omit the default script for the language.");
            }
            if (++i == subtags.length) {
                return;
            }
            subtag = subtags[i];
            len = subtag.length();
        }
        if (len == 3 && this.isDigit(subtag) || len == 2 && this.isLowerCaseAlpha(subtag)) {
            if (!this.isRegion(subtag)) {
                throw this.newDatatypeException("Bad region subtag.");
            }
            if (this.isDeprecated(subtag) && WARN) {
                throw this.newDatatypeException("The region subtag ", subtag, " is deprecated. Use \u201c" + preferredValueByLanguageMap.get(subtag) + "\u201d instead.", WARN);
            }
            if (++i == subtags.length) {
                return;
            }
            subtag = subtags[i];
            len = subtag.length();
        }
        while (true) {
            if ("x".equals(subtag)) {
                this.checkPrivateUse(i, subtags);
                return;
            }
            if (len == 1 && this.isLowerCaseAlphaNumeric(subtag)) {
                throw this.newDatatypeException("Unknown extension ", subtag, ".");
            }
            if (len == 4 && this.isDigit(subtag.charAt(0)) && this.isLowerCaseAlphaNumeric(subtag) || len >= 5 && this.isLowerCaseAlphaNumeric(subtag)) {
                if (!this.isVariant(subtag)) {
                    throw this.newDatatypeException("Bad variant subtag ", subtag, ".");
                }
                if (this.isDeprecated(subtag) && WARN) {
                    throw this.newDatatypeException("The variant subtag ", subtag, " is deprecated. Use \u201c" + preferredValueByLanguageMap.get(subtag) + "\u201d instead.", WARN);
                }
            } else {
                throw this.newDatatypeException("The subtag ", subtag, " does not match the format for any permissible subtag type.");
            }
            this.checkForValidPrefix(subtag, subtags, i);
            if (++i == subtags.length) {
                return;
            }
            subtag = subtags[i];
            len = subtag.length();
        }
    }

    private void checkForValidPrefix(String subtag, String[] subtags, int i) throws DatatypeException {
        String variant = subtags[i];
        int index = Arrays.binarySearch(variants, variant);
        assert (index >= 0);
        String[][] prefixes = prefixesByVariant[index];
        if (prefixes.length == 0) {
            return;
        }
        ArrayList<String> recommendedPrefixes = new ArrayList<String>();
        String[][] stringArray = prefixes;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String[] stringArray2;
            for (String prefixComponent : stringArray2 = stringArray[j]) {
                if (this.subtagsContainPrefixComponent(prefixComponent, subtags, i)) continue;
                recommendedPrefixes.add(prefixComponent);
            }
            if (!this.prefixMatches(stringArray2, subtags, i)) continue;
            return;
        }
        if (recommendedPrefixes.size() == 0) {
            return;
        }
        int count = recommendedPrefixes.size();
        StringBuilder sb = new StringBuilder();
        if (recommendedPrefixes.size() > 1) {
            sb.append(" one of ");
        }
        for (String string : recommendedPrefixes) {
            if (count != recommendedPrefixes.size()) {
                sb.append(", ");
                if (count == 1) {
                    sb.append(" or ");
                }
            }
            sb.append("\u201c");
            sb.append(string);
            sb.append('\u201d');
            --count;
        }
        throw this.newDatatypeException("Variant ", subtag, " lacks recommended prefix. Use " + sb + " instead.");
    }

    private boolean prefixMatches(String[] prefix, String[] subtags, int limit) {
        for (String prefixComponent : prefix) {
            if (this.subtagsContainPrefixComponent(prefixComponent, subtags, limit)) continue;
            return false;
        }
        return true;
    }

    private boolean subtagsContainPrefixComponent(String prefixComponent, String[] subtags, int limit) {
        for (int i = 0; i < limit; ++i) {
            String subtag = subtags[i];
            if (!subtag.equals(prefixComponent)) continue;
            return true;
        }
        return false;
    }

    private boolean usesPrefixByExtlang(String language, String extlang) {
        int langIndex = Arrays.binarySearch(languages, language);
        int extlangIndex = Arrays.binarySearch(extlangs, extlang);
        assert (langIndex > -1);
        int prefixExpected = prefixByExtlang[extlangIndex];
        return prefixExpected == langIndex;
    }

    private boolean shouldSuppressScript(String language, String script) {
        int langIndex = Arrays.binarySearch(languages, language);
        assert (langIndex > -1);
        int scriptIndex = suppressedScriptByLanguage[langIndex];
        if (scriptIndex < 0) {
            return false;
        }
        return scripts[scriptIndex].equals(script);
    }

    private boolean isVariant(String subtag) {
        return Arrays.binarySearch(variants, subtag) > -1;
    }

    private boolean isRegion(String subtag) {
        return Arrays.binarySearch(regions, subtag) > -1 || "aa".equals(subtag) || "qm".compareTo(subtag) <= 0 && "qz".compareTo(subtag) >= 0 || "xa".compareTo(subtag) <= 0 && "xz".compareTo(subtag) >= 0 || "zz".equals(subtag);
    }

    private boolean isScript(String subtag) {
        return Arrays.binarySearch(scripts, subtag) > -1 || "qaaa".compareTo(subtag) <= 0 && "qabx".compareTo(subtag) >= 0;
    }

    private boolean isExtlang(String subtag) {
        return Arrays.binarySearch(extlangs, subtag) > -1;
    }

    private boolean isLanguage(String subtag) {
        return Arrays.binarySearch(languages, subtag) > -1 || "qaa".compareTo(subtag) <= 0 && "qtz".compareTo(subtag) >= 0;
    }

    private void checkPrivateUse(int i, String[] subtags) throws DatatypeException {
        int len = subtags.length;
        if (++i == len) {
            throw this.newDatatypeException("No subtags in private use sequence.");
        }
        while (i < len) {
            String subtag = subtags[i];
            if (subtag.length() < 2) {
                throw this.newDatatypeException("Private use subtag ", subtag, " is too short.");
            }
            if (!this.isLowerCaseAlphaNumeric(subtag)) {
                throw this.newDatatypeException("Bad character in private use subtag ", subtag, ".");
            }
            ++i;
        }
    }

    private boolean isLowerCaseAlphaNumeric(char c) {
        return this.isLowerCaseAlpha(c) || this.isDigit(c);
    }

    private boolean isLowerCaseAlphaNumeric(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (this.isLowerCaseAlphaNumeric(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isDigit(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (this.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isLowerCaseAlpha(char c) {
        return c >= 'a' && c <= 'z';
    }

    private boolean isLowerCaseAlpha(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (this.isLowerCaseAlpha(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isGrandfathered(String literal) {
        return Arrays.binarySearch(grandfathered, literal) > -1;
    }

    private boolean isRedundant(String literal) {
        return Arrays.binarySearch(redundant, literal) > -1;
    }

    private boolean isDeprecated(String subtag) {
        return Arrays.binarySearch(deprecated, subtag) > -1;
    }

    private boolean isDeprecatedLang(String subtag) {
        return Arrays.binarySearch(deprecatedLang, subtag) > -1;
    }

    @Override
    public String getName() {
        return "language tag";
    }

    static {
        try {
            LanguageData data = new LanguageData();
            languages = data.getLanguages();
            extlangs = data.getExtlangs();
            scripts = data.getScripts();
            regions = data.getRegions();
            variants = data.getVariants();
            grandfathered = data.getGrandfathered();
            redundant = data.getRedundant();
            deprecated = data.getDeprecated();
            deprecatedLang = data.getDeprecatedLang();
            suppressedScriptByLanguage = data.getSuppressedScriptByLanguage();
            prefixByExtlang = data.getPrefixByExtlang();
            preferredValueByLanguageMap = data.getPreferredValueByLanguageMap();
            prefixesByVariant = data.getPrefixesByVariant();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

