/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.gnu.xml.aelfred2;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import nu.validator.gnu.xml.aelfred2.FatalSAXException;
import nu.validator.gnu.xml.aelfred2.SAXDriver;
import nu.validator.htmlparser.common.CharacterHandler;
import nu.validator.htmlparser.extra.NormalizationChecker;
import nu.validator.htmlparser.impl.NCName;
import nu.validator.htmlparser.io.Encoding;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class XmlParser {
    private static final int SURROGATE_OFFSET = -56613888;
    public static final int CONTENT_UNDECLARED = 0;
    public static final int CONTENT_ANY = 1;
    public static final int CONTENT_EMPTY = 2;
    public static final int CONTENT_MIXED = 3;
    public static final int CONTENT_ELEMENTS = 4;
    public static final int ENTITY_UNDECLARED = 0;
    public static final int ENTITY_INTERNAL = 1;
    public static final int ENTITY_NDATA = 2;
    public static final int ENTITY_TEXT = 3;
    public static final int ATTRIBUTE_DEFAULT_UNDECLARED = 30;
    public static final int ATTRIBUTE_DEFAULT_SPECIFIED = 31;
    public static final int ATTRIBUTE_DEFAULT_IMPLIED = 32;
    public static final int ATTRIBUTE_DEFAULT_REQUIRED = 33;
    public static final int ATTRIBUTE_DEFAULT_FIXED = 34;
    private static final int INPUT_NONE = 0;
    private static final int INPUT_INTERNAL = 1;
    private static final int INPUT_READER = 5;
    private static final int LIT_ENTITY_REF = 2;
    private static final int LIT_NORMALIZE = 4;
    private static final int LIT_ATTRIBUTE = 8;
    private static final int LIT_DISABLE_PE = 16;
    private static final int LIT_DISABLE_CREF = 32;
    private static final int LIT_DISABLE_EREF = 64;
    private static final int LIT_PUBID = 256;
    static boolean uriWarnings;
    private SAXDriver handler;
    private Reader reader;
    private InputStream is;
    private int line;
    private int linePrev;
    private int column;
    private int columnPrev;
    private boolean nextCharOnNewLine;
    private int sourceType;
    private LinkedList<Input> inputStack;
    private String characterEncoding;
    private int currentByteCount;
    private char[] readBuffer;
    private int readBufferPos;
    private int readBufferLength;
    private int readBufferOverflow;
    private static final int READ_BUFFER_MAX = 60;
    private static int DATA_BUFFER_INITIAL;
    private char[] dataBuffer;
    private int dataBufferPos;
    private static int NAME_BUFFER_INITIAL;
    private char[] nameBuffer;
    private int nameBufferPos;
    private boolean docIsStandalone;
    private HashMap<String, ElementDecl> elementInfo;
    private HashMap<String, EntityInfo> entityInfo;
    private HashMap<String, String> notationInfo;
    private boolean skippedPE;
    private String currentElement;
    private int currentElementContent;
    private LinkedList<String> entityStack;
    private boolean inLiteral;
    private boolean expandPE;
    private boolean peIsError;
    private boolean doReport;
    private static final int SYMBOL_TABLE_LENGTH = 2039;
    private Object[][] symbolTable;
    private String[] tagAttributes;
    private int tagAttributePos;
    private boolean inCDATA;
    private static final int XML_10 = 0;
    private static final int XML_11 = 1;
    private int xmlVersion = 0;
    private NormalizationChecker normalizationChecker;
    private CharacterHandler characterHandler;
    static final char[] startDelimComment;
    static final char[] endDelimComment;
    static final char[] startDelimPI;
    static final char[] endDelimPI;
    static final char[] endDelimCDATA;
    private boolean isDirtyCurrentElement;
    private boolean alreadyWarnedAboutPrivateUseCharacters;
    private char prev;

    XmlParser() {
    }

    void setHandler(SAXDriver handler) {
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doParse(String systemId, String publicId, Reader reader, InputStream stream, String encoding) throws Exception {
        if (this.handler == null) {
            throw new IllegalStateException("no callback handler");
        }
        this.alreadyWarnedAboutPrivateUseCharacters = false;
        this.initializeVariables();
        this.setInternalEntity("amp", "&#38;");
        this.setInternalEntity("lt", "&#60;");
        this.setInternalEntity("gt", "&#62;");
        this.setInternalEntity("apos", "&#39;");
        this.setInternalEntity("quot", "&#34;");
        try {
            this.handler.startDocument();
            this.pushURL(false, "[document]", new ExternalIdentifiers(publicId, systemId, null), reader, stream, encoding, false);
            this.parseDocument();
        }
        catch (EOFException e) {
            this.fatal("Empty document, with no root element.");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void fatal(String message, String textFound, String textExpected) throws SAXException {
        if (textFound != null) {
            message = message + " (found \u201c" + textFound + "\u201d)";
        }
        if (textExpected != null) {
            message = message + " (expected \u201c" + textExpected + "\u201d)";
        }
        this.handler.fatal(message);
        throw new FatalSAXException(message);
    }

    private void fatal(String message, char textFound, String textExpected) throws SAXException {
        this.fatal(message, new Character(textFound).toString(), textExpected);
    }

    private void fatal(String message) throws SAXException {
        this.handler.fatal(message);
    }

    private void err(String message) throws SAXException {
        this.handler.verror(message);
    }

    private void parseDocument() throws Exception {
        try {
            boolean sawDTD = this.parseProlog();
            this.require('<');
            this.parseElement(!sawDTD);
        }
        catch (EOFException ee) {
            this.fatal("premature end of file", "[EOF]", null);
        }
        try {
            this.parseMisc();
            char c = this.readCh();
            this.fatal("unexpected characters after document end", c, null);
        }
        catch (EOFException e) {
            if (this.characterHandler != null) {
                this.characterHandler.end();
            }
            if (this.normalizationChecker != null) {
                this.normalizationChecker.end();
            }
            return;
        }
    }

    private void parseComment() throws Exception {
        boolean saved = this.expandPE;
        this.expandPE = false;
        this.parseUntil(endDelimComment);
        this.require('>');
        this.expandPE = saved;
        this.handler.comment(this.dataBuffer, 0, this.dataBufferPos);
        this.dataBufferPos = 0;
    }

    private void parsePI() throws SAXException, IOException {
        boolean saved = this.expandPE;
        this.expandPE = false;
        String name = this.readNmtoken(true);
        if (name.indexOf(58) >= 0) {
            this.fatal("Illegal character(':') in processing instruction name ", name, null);
        }
        if ("xml".equalsIgnoreCase(name)) {
            this.fatal("Illegal processing instruction target", name, null);
        }
        if (!this.tryRead(endDelimPI)) {
            this.requireWhitespace();
            this.parseUntil(endDelimPI);
        }
        this.expandPE = saved;
        this.handler.processingInstruction(name, this.dataBufferToString());
    }

    private void parseCDSect() throws Exception {
        this.parseUntil(endDelimCDATA);
        this.dataBufferFlush();
    }

    private boolean parseProlog() throws Exception {
        this.parseMisc();
        if (this.tryRead("<!DOCTYPE")) {
            this.parseDoctypedecl();
            this.parseMisc();
            return true;
        }
        return false;
    }

    private void checkLegalVersion(String version) throws SAXException {
        int len = version.length();
        for (int i = 0; i < len; ++i) {
            char c = version.charAt(i);
            if ('0' <= c && c <= '9' || c == '_' || c == '.' || c == ':' || c == '-' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z') continue;
            this.fatal("illegal character in version", version, "1.0");
        }
    }

    private String parseXMLDecl(String encoding) throws SAXException, IOException {
        String encodingName = null;
        String standalone = null;
        int flags = 112;
        this.require("version");
        this.parseEq();
        String version = this.readLiteral(flags);
        this.checkLegalVersion(version);
        if (!version.equals("1.0")) {
            if (version.equals("1.1")) {
                this.fatal("XML 1.1 not supported.");
            } else {
                this.fatal("illegal XML version", version, "1.0");
            }
        } else {
            this.xmlVersion = 0;
        }
        boolean white = this.tryWhitespace();
        if (this.tryRead("encoding")) {
            if (!white) {
                this.fatal("whitespace required before 'encoding='");
            }
            this.parseEq();
            encodingName = this.readLiteral(flags);
            this.checkEncodingLiteral(encodingName);
            if (this.reader == null) {
                this.draconianInputStreamReader(encodingName, this.is, true);
            } else {
                this.checkEncodingMatch(encoding, encodingName);
            }
        }
        if (encodingName != null) {
            white = this.tryWhitespace();
        } else {
            if (encoding == null) {
                this.draconianInputStreamReader("UTF-8", this.is, false);
            }
            this.warnAboutLackOfEncodingDecl(encoding);
        }
        if (this.tryRead("standalone")) {
            if (!white) {
                this.fatal("whitespace required before 'standalone='");
            }
            this.parseEq();
            standalone = this.readLiteral(flags);
            if ("yes".equals(standalone)) {
                this.docIsStandalone = true;
            } else if (!"no".equals(standalone)) {
                this.fatal("standalone flag must be 'yes' or 'no'");
            }
        }
        this.skipWhitespace();
        this.require("?>");
        return encodingName;
    }

    private void checkEncodingLiteral(String encodingName) throws SAXException {
        char c;
        if (encodingName == null) {
            return;
        }
        if (encodingName.length() == 0) {
            this.fatal("The empty string does not a legal encoding name.");
        }
        if (!((c = encodingName.charAt(0)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            this.fatal("The encoding name must start with an ASCII letter.");
        }
        for (int i = 1; i < encodingName.length(); ++i) {
            c = encodingName.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '-') continue;
            this.fatal("Illegal character in encoding name: U+" + Integer.toHexString(c) + ".");
        }
    }

    private String parseTextDecl(String encoding) throws SAXException, IOException {
        String encodingName = null;
        int flags = 112;
        if (this.tryRead("version")) {
            this.parseEq();
            String version = this.readLiteral(flags);
            this.checkLegalVersion(version);
            if (!version.equals("1.0")) {
                if (version.equals("1.1")) {
                    this.fatal("XML 1.1 not supported.");
                } else {
                    this.fatal("illegal XML version", version, "1.0");
                }
            }
            this.requireWhitespace();
        }
        this.require("encoding");
        this.parseEq();
        encodingName = this.readLiteral(flags);
        this.checkEncodingLiteral(encodingName);
        if (this.reader == null) {
            this.draconianInputStreamReader(encodingName, this.is, true);
        } else {
            this.checkEncodingMatch(encoding, encodingName);
        }
        this.skipWhitespace();
        this.require("?>");
        return encodingName;
    }

    private void checkEncodingMatch(String used, String detected) throws SAXException {
        if (used == null) {
            if (!this.characterEncoding.equalsIgnoreCase(detected)) {
                this.fatal("Declared character encoding was not the one sniffed from the BOM.", detected, this.characterEncoding);
            }
        } else if (!"".equals(used) && !used.equalsIgnoreCase(detected)) {
            this.handler.warn("External encoding information specified " + used + ", but XML declaration specified " + detected + ". Allowing external to override per RFC 3023. The well-formedness status of this document may change when decoupled from the external character encoding information.");
        }
    }

    private void draconianInputStreamReader(String encoding, InputStream stream, boolean requireAsciiSuperset) throws SAXException, IOException {
        this.draconianInputStreamReader(encoding, stream, requireAsciiSuperset, encoding);
    }

    private void draconianInputStreamReader(String encoding, InputStream stream, boolean requireAsciiSuperset, String actualName) throws SAXException, IOException {
        this.sourceType = 5;
        this.characterEncoding = Encoding.toAsciiLowerCase(actualName);
        encoding = Encoding.toAsciiLowerCase(encoding);
        try {
            Encoding htmlActual;
            Encoding cs = Encoding.forName(encoding);
            String canonName = cs.getCanonName();
            if (requireAsciiSuperset && !cs.isAsciiSuperset()) {
                this.fatal("The encoding \u201c" + actualName + "\u201d is not an ASCII superset and, therefore, cannot be used in an internal encoding declaration.");
            }
            if (!cs.isRegistered()) {
                if (encoding.startsWith("x-")) {
                    this.err("The encoding \u201c" + actualName + "\u201d is not an IANA-registered encoding. (Charmod C022)");
                } else {
                    this.err("The encoding \u201c" + actualName + "\u201d is not an IANA-registered encoding and did not use the \u201cx-\u201d prefix. (Charmod C023)");
                }
            } else if (!canonName.equals(encoding)) {
                this.err("The encoding \u201c" + actualName + "\u201d is not the preferred name of the character encoding in use. The preferred name is \u201c" + canonName + "\u201d. (Charmod C024)");
            }
            if (!("utf-8".equals(encoding) || "utf-16".equals(encoding) || "utf-16be".equals(encoding) || "utf-16le".equals(encoding) || "iso-8859-1".equals(encoding) || "us-ascii".equals(encoding))) {
                this.handler.warn("XML processors are required to support the UTF-8 and UTF-16 character encodings. The encoding was \u201c" + actualName + "\u201d instead, which is an incompatibility risk.");
            }
            if ((htmlActual = cs.getActualHtmlEncoding()) != null) {
                this.handler.warn("Documents encoded as \u201c" + htmlActual.getCanonName() + "\u201d are often mislabeled as \u201c" + actualName + "\u201d, which is the declared encoding of this document.");
            }
            CharsetDecoder decoder = cs.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            this.reader = new InputStreamReader(stream, decoder);
        }
        catch (UnsupportedCharsetException e) {
            this.fatal("Unsupported character encoding \u201c" + actualName + "\u201d.");
        }
    }

    private void parseMisc() throws Exception {
        while (true) {
            this.skipWhitespace();
            if (this.tryRead(startDelimPI)) {
                this.parsePI();
                continue;
            }
            if (!this.tryRead(startDelimComment)) break;
            this.parseComment();
        }
    }

    private void parseDoctypedecl() throws Exception {
        this.requireWhitespace();
        String rootName = this.readNmtoken(true);
        this.skipWhitespace();
        ExternalIdentifiers ids = this.readExternalIds(false, true);
        this.handler.doctypeDecl(rootName, ids.publicId, ids.systemId);
        this.skipWhitespace();
        if (this.tryRead('[')) {
            while (true) {
                this.expandPE = true;
                this.doReport = true;
                this.skipWhitespace();
                this.expandPE = false;
                this.doReport = false;
                if (this.tryRead(']')) break;
                this.expandPE = true;
                this.peIsError = true;
                this.parseMarkupdecl();
                this.expandPE = false;
                this.peIsError = false;
            }
        }
        this.skipWhitespace();
        this.require('>');
        InputSource subset = ids.systemId == null ? this.handler.getExternalSubset(rootName, this.handler.getSystemId()) : null;
        if (ids.systemId != null || subset != null) {
            this.pushString(null, ">");
            if (ids.systemId != null) {
                this.pushURL(true, "[dtd]", ids, null, null, null, true);
            } else {
                this.handler.warn("modifying document by adding external subset");
                this.pushURL(true, "[dtd]", new ExternalIdentifiers(subset.getPublicId(), subset.getSystemId(), null), subset.getCharacterStream(), subset.getByteStream(), subset.getEncoding(), false);
            }
            while (true) {
                this.expandPE = true;
                this.doReport = true;
                this.skipWhitespace();
                this.expandPE = false;
                this.doReport = false;
                if (this.tryRead('>')) break;
                this.expandPE = true;
                this.parseMarkupdecl();
                this.expandPE = false;
            }
            if (this.inputStack.size() != 1) {
                this.fatal("external subset has unmatched '>'");
            }
        }
        this.handler.endDoctype();
        this.expandPE = false;
        this.doReport = true;
    }

    private void parseMarkupdecl() throws Exception {
        char[] saved = null;
        boolean savedPE = this.expandPE;
        this.require('<');
        this.unread('<');
        this.expandPE = false;
        if (this.tryRead("<!ELEMENT")) {
            saved = this.readBuffer;
            this.expandPE = savedPE;
            this.parseElementDecl();
        } else if (this.tryRead("<!ATTLIST")) {
            saved = this.readBuffer;
            this.expandPE = savedPE;
            this.parseAttlistDecl();
        } else if (this.tryRead("<!ENTITY")) {
            saved = this.readBuffer;
            this.expandPE = savedPE;
            this.parseEntityDecl();
        } else if (this.tryRead("<!NOTATION")) {
            saved = this.readBuffer;
            this.expandPE = savedPE;
            this.parseNotationDecl();
        } else if (this.tryRead(startDelimPI)) {
            saved = this.readBuffer;
            this.expandPE = savedPE;
            this.parsePI();
        } else if (this.tryRead(startDelimComment)) {
            saved = this.readBuffer;
            this.expandPE = savedPE;
            this.parseComment();
        } else if (this.tryRead("<![")) {
            saved = this.readBuffer;
            this.expandPE = savedPE;
            if (this.inputStack.size() > 0) {
                this.parseConditionalSect(saved);
            } else {
                this.fatal("conditional sections illegal in internal subset");
            }
        } else {
            this.fatal("expected markup declaration");
        }
        if (this.readBuffer != saved) {
            this.handler.verror("Illegal Declaration/PE nesting");
        }
    }

    private void parseElement(boolean maybeGetSubset) throws Exception {
        InputSource subset;
        int oldElementContent = this.currentElementContent;
        String oldElement = this.currentElement;
        this.tagAttributePos = 0;
        String gi = this.readNmtoken(true);
        if (maybeGetSubset && (subset = this.handler.getExternalSubset(gi, this.handler.getSystemId())) != null) {
            String publicId = subset.getPublicId();
            String systemId = subset.getSystemId();
            this.handler.warn("modifying document by adding DTD");
            this.handler.doctypeDecl(gi, publicId, systemId);
            this.pushString(null, ">");
            this.pushURL(true, "[dtd]", new ExternalIdentifiers(publicId, systemId, null), subset.getCharacterStream(), subset.getByteStream(), subset.getEncoding(), false);
            while (true) {
                this.expandPE = true;
                this.doReport = true;
                this.skipWhitespace();
                this.expandPE = false;
                this.doReport = false;
                if (this.tryRead('>')) break;
                this.expandPE = true;
                this.parseMarkupdecl();
                this.expandPE = false;
            }
            if (this.inputStack.size() != 1) {
                this.fatal("external subset has unmatched '>'");
            }
            this.handler.endDoctype();
        }
        this.currentElement = gi;
        ElementDecl element = this.elementInfo.get(gi);
        this.currentElementContent = this.getContentType(element, 1);
        boolean white = this.tryWhitespace();
        char c = this.readCh();
        while (c != '/' && c != '>') {
            this.unread(c);
            if (!white) {
                this.fatal("need whitespace between attributes");
            }
            this.parseAttribute(gi);
            white = this.tryWhitespace();
            c = this.readCh();
        }
        Iterator<String> atts = this.declaredAttributes(element);
        if (atts != null) {
            block6: while (atts.hasNext()) {
                String aname = atts.next();
                for (int i = 0; i < this.tagAttributePos; ++i) {
                    if (this.tagAttributes[i] == aname) continue block6;
                }
                String value = this.getAttributeDefaultValue(gi, aname);
                if (value == null) continue;
                this.handler.attribute(aname, value, false);
            }
        }
        switch (c) {
            case '>': {
                this.handler.startElement(gi);
                this.parseContent();
                break;
            }
            case '/': {
                this.require('>');
                this.handler.startElement(gi);
                this.handler.endElement(gi);
            }
        }
        this.currentElement = oldElement;
        this.currentElementContent = oldElementContent;
    }

    private void parseAttribute(String name) throws Exception {
        int flags = 10;
        String aname = this.readNmtoken(true);
        String type = this.getAttributeType(name, aname);
        this.parseEq();
        String value = this.handler.stringInterning ? (type == "CDATA" || type == null ? this.readLiteral(flags) : this.readLiteral(flags | 4)) : (type == null || type.equals("CDATA") ? this.readLiteral(flags) : this.readLiteral(flags | 4));
        for (int i = 0; i < this.tagAttributePos; ++i) {
            if (!aname.equals(this.tagAttributes[i])) continue;
            this.fatal("duplicate attribute", aname, null);
        }
        this.handler.attribute(aname, value, true);
        this.dataBufferPos = 0;
        if (this.tagAttributePos == this.tagAttributes.length) {
            String[] newAttrib = new String[this.tagAttributes.length * 2];
            System.arraycopy(this.tagAttributes, 0, newAttrib, 0, this.tagAttributePos);
            this.tagAttributes = newAttrib;
        }
        this.tagAttributes[this.tagAttributePos++] = aname;
    }

    private void parseEq() throws SAXException, IOException {
        this.skipWhitespace();
        this.require('=');
        this.skipWhitespace();
    }

    private void parseETag() throws Exception {
        this.require(this.currentElement);
        this.skipWhitespace();
        this.require('>');
        this.handler.endElement(this.currentElement);
    }

    private void parseContent() throws Exception {
        while (true) {
            this.parseCharData();
            char c = this.readCh();
            block0 : switch (c) {
                case '&': {
                    c = this.readCh();
                    if (c == '#') {
                        this.parseCharRef();
                    } else {
                        this.unread(c);
                        this.parseEntityRef(true);
                    }
                    this.isDirtyCurrentElement = true;
                    break;
                }
                case '<': {
                    this.dataBufferFlush();
                    c = this.readCh();
                    switch (c) {
                        case '!': {
                            c = this.readCh();
                            switch (c) {
                                case '-': {
                                    this.require('-');
                                    this.isDirtyCurrentElement = false;
                                    this.parseComment();
                                    break block0;
                                }
                                case '[': {
                                    this.isDirtyCurrentElement = false;
                                    this.require("CDATA[");
                                    this.handler.startCDATA();
                                    this.inCDATA = true;
                                    this.parseCDSect();
                                    this.inCDATA = false;
                                    this.handler.endCDATA();
                                    break block0;
                                }
                            }
                            this.fatal("expected comment or CDATA section", c, null);
                            break block0;
                        }
                        case '?': {
                            this.isDirtyCurrentElement = false;
                            this.parsePI();
                            break block0;
                        }
                        case '/': {
                            this.isDirtyCurrentElement = false;
                            this.parseETag();
                            return;
                        }
                    }
                    this.isDirtyCurrentElement = false;
                    this.unread(c);
                    this.parseElement(false);
                }
            }
        }
    }

    private void parseElementDecl() throws Exception {
        this.requireWhitespace();
        String name = this.readNmtoken(true);
        this.requireWhitespace();
        this.parseContentspec(name);
        this.skipWhitespace();
        this.require('>');
    }

    private void parseContentspec(String name) throws Exception {
        String model;
        if (this.tryRead("EMPTY")) {
            this.setElement(name, 2, null, null);
            if (!this.skippedPE) {
                this.handler.getDeclHandler().elementDecl(name, "EMPTY");
            }
            return;
        }
        if (this.tryRead("ANY")) {
            this.setElement(name, 1, null, null);
            if (!this.skippedPE) {
                this.handler.getDeclHandler().elementDecl(name, "ANY");
            }
            return;
        }
        this.require('(');
        char[] saved = this.readBuffer;
        this.dataBufferAppend('(');
        this.skipWhitespace();
        if (this.tryRead("#PCDATA")) {
            this.dataBufferAppend("#PCDATA");
            this.parseMixed(saved);
            model = this.dataBufferToString();
            this.setElement(name, 3, model, null);
        } else {
            this.parseElements(saved);
            model = this.dataBufferToString();
            this.setElement(name, 4, model, null);
        }
        if (!this.skippedPE) {
            this.handler.getDeclHandler().elementDecl(name, model);
        }
    }

    private void parseElements(char[] saved) throws Exception {
        char sep;
        this.skipWhitespace();
        this.parseCp();
        this.skipWhitespace();
        char c = this.readCh();
        switch (c) {
            case ')': {
                if (this.readBuffer != saved) {
                    this.handler.verror("Illegal Group/PE nesting");
                }
                this.dataBufferAppend(')');
                c = this.readCh();
                switch (c) {
                    case '*': 
                    case '+': 
                    case '?': {
                        this.dataBufferAppend(c);
                        break;
                    }
                    default: {
                        this.unread(c);
                    }
                }
                return;
            }
            case ',': 
            case '|': {
                sep = c;
                this.dataBufferAppend(c);
                break;
            }
            default: {
                this.fatal("bad separator in content model", c, null);
                return;
            }
        }
        while (true) {
            this.skipWhitespace();
            this.parseCp();
            this.skipWhitespace();
            c = this.readCh();
            if (c == ')') {
                if (this.readBuffer != saved) {
                    this.handler.verror("Illegal Group/PE nesting");
                }
                break;
            }
            if (c != sep) {
                this.fatal("bad separator in content model", c, null);
                return;
            }
            this.dataBufferAppend(c);
        }
        this.dataBufferAppend(')');
        c = this.readCh();
        switch (c) {
            case '*': 
            case '+': 
            case '?': {
                this.dataBufferAppend(c);
                return;
            }
        }
        this.unread(c);
    }

    private void parseCp() throws Exception {
        if (this.tryRead('(')) {
            this.dataBufferAppend('(');
            this.parseElements(this.readBuffer);
        } else {
            this.dataBufferAppend(this.readNmtoken(true));
            char c = this.readCh();
            switch (c) {
                case '*': 
                case '+': 
                case '?': {
                    this.dataBufferAppend(c);
                    break;
                }
                default: {
                    this.unread(c);
                }
            }
        }
    }

    private void parseMixed(char[] saved) throws Exception {
        this.skipWhitespace();
        if (this.tryRead(')')) {
            if (this.readBuffer != saved) {
                this.handler.verror("Illegal Group/PE nesting");
            }
            this.dataBufferAppend(")*");
            this.tryRead('*');
            return;
        }
        this.skipWhitespace();
        while (!this.tryRead(")")) {
            this.require('|');
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(true));
            this.skipWhitespace();
        }
        if (this.readBuffer != saved) {
            this.handler.verror("Illegal Group/PE nesting");
        }
        this.require('*');
        this.dataBufferAppend(")*");
    }

    private void parseAttlistDecl() throws Exception {
        this.requireWhitespace();
        String elementName = this.readNmtoken(true);
        boolean white = this.tryWhitespace();
        while (!this.tryRead('>')) {
            if (!white) {
                this.fatal("whitespace required before attribute definition");
            }
            this.parseAttDef(elementName);
            white = this.tryWhitespace();
        }
    }

    private void parseAttDef(String elementName) throws Exception {
        String enumer = null;
        String name = this.readNmtoken(true);
        this.requireWhitespace();
        String type = this.readAttType();
        if (this.handler.stringInterning) {
            if ("ENUMERATION" == type || "NOTATION" == type) {
                enumer = this.dataBufferToString();
            }
        } else if ("ENUMERATION".equals(type) || "NOTATION".equals(type)) {
            enumer = this.dataBufferToString();
        }
        this.requireWhitespace();
        this.parseDefault(elementName, name, type, enumer);
    }

    private String readAttType() throws Exception {
        if (this.tryRead('(')) {
            this.parseEnumeration(false);
            return "ENUMERATION";
        }
        String typeString = this.readNmtoken(true);
        if (this.handler.stringInterning) {
            if ("NOTATION" == typeString) {
                this.parseNotationType();
                return typeString;
            }
            if ("CDATA" == typeString || "ID" == typeString || "IDREF" == typeString || "IDREFS" == typeString || "ENTITY" == typeString || "ENTITIES" == typeString || "NMTOKEN" == typeString || "NMTOKENS" == typeString) {
                return typeString;
            }
        } else {
            if ("NOTATION".equals(typeString)) {
                this.parseNotationType();
                return typeString;
            }
            if ("CDATA".equals(typeString) || "ID".equals(typeString) || "IDREF".equals(typeString) || "IDREFS".equals(typeString) || "ENTITY".equals(typeString) || "ENTITIES".equals(typeString) || "NMTOKEN".equals(typeString) || "NMTOKENS".equals(typeString)) {
                return typeString;
            }
        }
        this.fatal("illegal attribute type", typeString, null);
        return null;
    }

    private void parseEnumeration(boolean isNames) throws Exception {
        this.dataBufferAppend('(');
        this.skipWhitespace();
        this.dataBufferAppend(this.readNmtoken(isNames));
        this.skipWhitespace();
        while (!this.tryRead(')')) {
            this.require('|');
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(isNames));
            this.skipWhitespace();
        }
        this.dataBufferAppend(')');
    }

    private void parseNotationType() throws Exception {
        this.requireWhitespace();
        this.require('(');
        this.parseEnumeration(true);
    }

    private void parseDefault(String elementName, String name, String type, String enumer) throws Exception {
        int valueType = 31;
        String value = null;
        int flags = 8;
        boolean saved = this.expandPE;
        String defaultType = null;
        if (!this.skippedPE) {
            flags |= 2;
            if (this.handler.stringInterning) {
                if ("CDATA" != type) {
                    flags |= 4;
                }
            } else if (!"CDATA".equals(type)) {
                flags |= 4;
            }
        }
        this.expandPE = false;
        if (this.tryRead('#')) {
            if (this.tryRead("FIXED")) {
                defaultType = "#FIXED";
                valueType = 34;
                this.requireWhitespace();
                value = this.readLiteral(flags);
            } else if (this.tryRead("REQUIRED")) {
                defaultType = "#REQUIRED";
                valueType = 33;
            } else if (this.tryRead("IMPLIED")) {
                defaultType = "#IMPLIED";
                valueType = 32;
            } else {
                this.fatal("illegal keyword for attribute default value");
            }
        } else {
            value = this.readLiteral(flags);
        }
        this.expandPE = saved;
        this.setAttribute(elementName, name, type, enumer, value, valueType);
        if (this.handler.stringInterning) {
            if ("ENUMERATION" == type) {
                type = enumer;
            } else if ("NOTATION" == type) {
                type = "NOTATION " + enumer;
            }
        } else if ("ENUMERATION".equals(type)) {
            type = enumer;
        } else if ("NOTATION".equals(type)) {
            type = "NOTATION " + enumer;
        }
        if (!this.skippedPE) {
            this.handler.getDeclHandler().attributeDecl(elementName, name, type, defaultType, value);
        }
    }

    private void parseConditionalSect(char[] saved) throws Exception {
        this.skipWhitespace();
        if (this.tryRead("INCLUDE")) {
            this.skipWhitespace();
            this.require('[');
            if (this.readBuffer != saved) {
                this.handler.verror("Illegal Conditional Section/PE nesting");
            }
            this.skipWhitespace();
            while (!this.tryRead("]]>")) {
                this.parseMarkupdecl();
                this.skipWhitespace();
            }
        } else if (this.tryRead("IGNORE")) {
            this.skipWhitespace();
            this.require('[');
            if (this.readBuffer != saved) {
                this.handler.verror("Illegal Conditional Section/PE nesting");
            }
            this.expandPE = false;
            int nest = 1;
            while (nest > 0) {
                char c = this.readCh();
                switch (c) {
                    case '<': {
                        if (!this.tryRead("![")) break;
                        ++nest;
                        break;
                    }
                    case ']': {
                        if (!this.tryRead("]>")) break;
                        --nest;
                    }
                }
            }
            this.expandPE = true;
        } else {
            this.fatal("conditional section must begin with INCLUDE or IGNORE");
        }
    }

    private void parseCharRef() throws SAXException, IOException {
        this.parseCharRef(true);
    }

    private void tryReadCharRef() throws SAXException, IOException {
        int value = 0;
        if (this.tryRead('x')) {
            char c;
            while ((c = this.readCh()) != ';') {
                int n = Character.digit(c, 16);
                if (n == -1) {
                    this.fatal("illegal character in character reference", c, null);
                    break;
                }
                value *= 16;
                value += n;
            }
        } else {
            char c;
            while ((c = this.readCh()) != ';') {
                int n = Character.digit(c, 10);
                if (n == -1) {
                    this.fatal("illegal character in character reference", c, null);
                    break;
                }
                value *= 10;
                value += n;
            }
        }
        if (value < 32 && value != 10 && value != 9 && value != 13 || value >= 55296 && value <= 57343 || value == 65534 || value == 65535 || value > 0x10FFFF) {
            this.fatal("illegal XML character reference U+" + Integer.toHexString(value));
        } else if (value >= 127 && value <= 159) {
            this.handler.warn("Character reference expands to a control character: U+00" + Integer.toHexString(value) + ".");
        }
        if (this.isPrivateUse(value)) {
            this.warnAboutPrivateUseChar();
        }
        if (value > 0x10FFFF) {
            this.fatal("character reference " + value + " is too large for UTF-16", new Integer(value).toString(), null);
        }
    }

    private void parseCharRef(boolean doFlush) throws SAXException, IOException {
        int value = 0;
        if (this.tryRead('x')) {
            char c;
            while ((c = this.readCh()) != ';') {
                int n = Character.digit(c, 16);
                if (n == -1) {
                    this.fatal("illegal character in character reference", c, null);
                    break;
                }
                value *= 16;
                value += n;
            }
        } else {
            char c;
            while ((c = this.readCh()) != ';') {
                int n = Character.digit(c, 10);
                if (n == -1) {
                    this.fatal("illegal character in character reference", c, null);
                    break;
                }
                value *= 10;
                value += c - 48;
            }
        }
        if (value < 32 && value != 10 && value != 9 && value != 13 || value >= 55296 && value <= 57343 || value == 65534 || value == 65535 || value > 0x10FFFF) {
            this.fatal("illegal XML character reference U+" + Integer.toHexString(value));
        } else if (value >= 127 && value <= 159) {
            this.handler.warn("Character reference expands to a control character: U+00" + Integer.toHexString(value) + ".");
        }
        if (this.isPrivateUse(value)) {
            this.warnAboutPrivateUseChar();
        }
        if (value <= 65535) {
            this.dataBufferAppend((char)value);
        } else if (value <= 0x10FFFF) {
            this.dataBufferAppend((char)(0xD800 | (value -= 65536) >> 10));
            this.dataBufferAppend((char)(0xDC00 | value & 0x3FF));
        } else {
            this.fatal("character reference " + value + " is too large for UTF-16", new Integer(value).toString(), null);
        }
        if (doFlush) {
            this.dataBufferFlush();
        }
    }

    private void parseEntityRef(boolean externalAllowed) throws SAXException, IOException {
        String name = this.readNmtoken(true);
        this.require(';');
        switch (this.getEntityType(name)) {
            case 0: {
                String message = "reference to undeclared general entity " + name;
                if (this.skippedPE && !this.docIsStandalone) {
                    this.handler.verror(message);
                    if (!externalAllowed) break;
                    this.handler.skippedEntity(name);
                    break;
                }
                this.fatal(message);
                break;
            }
            case 1: {
                this.pushString(name, this.getEntityValue(name));
                char t = this.readCh();
                this.unread(t);
                int bufferPosMark = this.readBufferPos;
                int end = this.readBufferPos + this.getEntityValue(name).length();
                for (int k = this.readBufferPos; k < end; ++k) {
                    t = this.readCh();
                    if (t != '&') continue;
                    t = this.readCh();
                    if (t == '#') {
                        this.tryReadCharRef();
                        if (this.readBufferPos >= end) break;
                        k = this.readBufferPos;
                        continue;
                    }
                    if (Character.isLetter(t)) {
                        this.unread(t);
                        this.readNmtoken(true);
                        this.require(';');
                        if (this.readBufferPos >= end) break;
                        k = this.readBufferPos;
                        continue;
                    }
                    this.fatal(" malformed entity reference");
                }
                this.readBufferPos = bufferPosMark;
                break;
            }
            case 3: {
                if (externalAllowed) {
                    this.pushURL(false, name, this.getEntityIds(name), null, null, null, true);
                    break;
                }
                this.fatal("reference to external entity in attribute value.", name, null);
                break;
            }
            case 2: {
                if (externalAllowed) {
                    this.fatal("unparsed entity reference in content", name, null);
                    break;
                }
                this.fatal("reference to external entity in attribute value.", name, null);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void parsePEReference() throws SAXException, IOException {
        String name = "%" + this.readNmtoken(true);
        this.require(';');
        switch (this.getEntityType(name)) {
            case 0: {
                this.handler.verror("reference to undeclared parameter entity " + name);
                break;
            }
            case 1: {
                if (this.inLiteral) {
                    this.pushString(name, this.getEntityValue(name));
                    break;
                }
                this.pushString(name, ' ' + this.getEntityValue(name) + ' ');
                break;
            }
            case 3: {
                if (!this.inLiteral) {
                    this.pushString(null, " ");
                }
                this.pushURL(true, name, this.getEntityIds(name), null, null, null, true);
                if (this.inLiteral) break;
                this.pushString(null, " ");
            }
        }
    }

    private void parseEntityDecl() throws Exception {
        boolean peFlag = false;
        int flags = 0;
        this.expandPE = false;
        this.requireWhitespace();
        if (this.tryRead('%')) {
            peFlag = true;
            this.requireWhitespace();
        }
        this.expandPE = true;
        String name = this.readNmtoken(true);
        if (name.indexOf(58) >= 0) {
            this.fatal("Illegal character(':') in entity name ", name, null);
        }
        if (peFlag) {
            name = "%" + name;
        }
        this.requireWhitespace();
        char c = this.readCh();
        this.unread(c);
        if (c == '\"' || c == '\'') {
            String value = this.readLiteral(flags);
            this.setInternalEntity(name, value);
        } else {
            ExternalIdentifiers ids = this.readExternalIds(false, false);
            boolean white = this.tryWhitespace();
            if (!peFlag && this.tryRead("NDATA")) {
                if (!white) {
                    this.fatal("whitespace required before NDATA");
                }
                this.requireWhitespace();
                String notationName = this.readNmtoken(true);
                if (!this.skippedPE) {
                    this.setExternalEntity(name, 2, ids, notationName);
                    this.handler.unparsedEntityDecl(name, ids.publicId, ids.systemId, ids.baseUri, notationName);
                }
            } else if (!this.skippedPE) {
                this.setExternalEntity(name, 3, ids, null);
                this.handler.getDeclHandler().externalEntityDecl(name, ids.publicId, this.handler.resolveURIs() ? this.handler.absolutize(ids.baseUri, ids.systemId, false) : ids.systemId);
            }
        }
        this.skipWhitespace();
        this.require('>');
    }

    private void parseNotationDecl() throws Exception {
        this.requireWhitespace();
        String nname = this.readNmtoken(true);
        if (nname.indexOf(58) >= 0) {
            this.fatal("Illegal character(':') in notation name ", nname, null);
        }
        this.requireWhitespace();
        ExternalIdentifiers ids = this.readExternalIds(true, false);
        this.setNotation(nname, ids);
        this.skipWhitespace();
        this.require('>');
    }

    private void parseCharData() throws Exception {
        int state = 0;
        boolean pureWhite = false;
        if (this.currentElementContent == 4 && !this.isDirtyCurrentElement) {
            pureWhite = true;
        }
        while (true) {
            int i;
            block7: for (i = this.readBufferPos; i < this.readBufferLength; ++i) {
                this.advanceLocation();
                char c = this.readBuffer[i];
                switch (c) {
                    case '\n': {
                        this.nextCharOnNewLine = true;
                        continue block7;
                    }
                    case '\t': 
                    case '\r': 
                    case ' ': {
                        continue block7;
                    }
                    case '&': 
                    case '<': {
                        state = 1;
                        this.rollbackLocation();
                        break block7;
                    }
                    case ']': {
                        pureWhite = false;
                        if (this.readBufferOverflow != -1) continue block7;
                        if (i + 2 >= this.readBufferLength) {
                            this.reportText(pureWhite, i);
                            this.readBufferOverflow = 93;
                            this.fillBuffer();
                            i = this.readBufferPos;
                        }
                        if (this.readBuffer[i + 1] != ']' || this.readBuffer[i + 2] != '>') continue block7;
                        state = 2;
                        this.rollbackLocation();
                        break block7;
                    }
                    default: {
                        if (c < ' ' || c > '\ufffd' || c >= '\u007f' && c <= '\u009f' && c != '\u0085' && this.xmlVersion == 1) {
                            this.fatal("illegal XML character U+" + Integer.toHexString(c));
                        } else if (c >= '\u007f' && c <= '\u009f') {
                            this.handler.warn("Saw a control character: U+00" + Integer.toHexString(c) + ".");
                        }
                        pureWhite = false;
                    }
                }
            }
            this.reportText(pureWhite, i);
            if (state != 0) break;
            this.unread(this.readCh());
        }
        if (!pureWhite) {
            this.isDirtyCurrentElement = true;
        }
        if (state != 1) {
            this.fatal("character data may not contain ']]>'");
        }
    }

    private void reportText(boolean pureWhite, int i) throws SAXException {
        int length = i - this.readBufferPos;
        if (length != 0) {
            int saveLine = this.line;
            int saveColumn = this.column;
            this.line = this.linePrev;
            this.column = this.columnPrev;
            if (pureWhite) {
                this.handler.ignorableWhitespace(this.readBuffer, this.readBufferPos, length);
            } else {
                this.handler.charData(this.readBuffer, this.readBufferPos, length);
            }
            this.line = saveLine;
            this.column = saveColumn;
            this.readBufferPos = i;
        }
    }

    private void advanceLocation() {
        this.linePrev = this.line++;
        this.columnPrev = this.column++;
        if (this.nextCharOnNewLine) {
            this.column = 1;
        }
        this.nextCharOnNewLine = false;
    }

    private void requireWhitespace() throws SAXException, IOException {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
        } else {
            this.fatal("whitespace required", c, null);
        }
    }

    private void skipWhitespace() throws SAXException, IOException {
        char c = this.readCh();
        while (this.isWhitespace(c)) {
            c = this.readCh();
        }
        this.unread(c);
    }

    private String readNmtoken(boolean isName) throws SAXException, IOException {
        this.nameBufferPos = 0;
        while (true) {
            char c = this.readCh();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '%': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    this.unread(c);
                    if (this.nameBufferPos == 0) {
                        this.fatal("name expected");
                    }
                    String s = this.intern(this.nameBuffer, 0, this.nameBufferPos);
                    this.nameBufferPos = 0;
                    return s;
                }
            }
            if (isName && this.nameBufferPos == 0 && !NCName.isNCNameStart(c)) {
                this.fatal("Not a name start character, U+" + Integer.toHexString(c));
            } else if (!NCName.isNCNameTrail(c) && c != ':') {
                this.fatal("Not a name character, U+" + Integer.toHexString(c));
            }
            if (this.nameBufferPos >= this.nameBuffer.length) {
                this.nameBuffer = (char[])this.extendArray(this.nameBuffer, this.nameBuffer.length, this.nameBufferPos);
            }
            this.nameBuffer[this.nameBufferPos++] = c;
        }
    }

    private String readLiteral(int flags) throws SAXException, IOException {
        int startLine = this.line;
        boolean saved = this.expandPE;
        boolean savedReport = this.doReport;
        char delim = this.readCh();
        if (delim != '\"' && delim != '\'') {
            this.fatal("expected '\"' or \"'\"", delim, null);
            return null;
        }
        this.inLiteral = true;
        if ((flags & 0x10) != 0) {
            this.expandPE = false;
        }
        this.doReport = false;
        char[] ourBuf = this.readBuffer;
        try {
            char c = this.readCh();
            block8: while (c != delim || this.readBuffer != ourBuf) {
                switch (c) {
                    case '\n': 
                    case '\r': {
                        if ((flags & 0x108) == 0) break;
                        c = ' ';
                        break;
                    }
                    case '\t': {
                        if ((flags & 8) == 0) break;
                        c = ' ';
                        break;
                    }
                    case '&': {
                        c = this.readCh();
                        if (c == '#') {
                            if ((flags & 0x20) != 0) {
                                this.dataBufferAppend('&');
                                break;
                            }
                            this.parseCharRef(false);
                        } else {
                            this.unread(c);
                            if ((flags & 2) > 0) {
                                this.parseEntityRef(false);
                            } else if ((flags & 0x40) != 0) {
                                this.dataBufferAppend('&');
                            } else {
                                String name = this.readNmtoken(true);
                                this.require(';');
                                this.dataBufferAppend('&');
                                this.dataBufferAppend(name);
                                this.dataBufferAppend(';');
                            }
                        }
                        c = this.readCh();
                        continue block8;
                    }
                    case '<': {
                        if ((flags & 8) == 0) break;
                        this.fatal("attribute values may not contain '<'");
                        break;
                    }
                }
                this.dataBufferAppend(c);
                c = this.readCh();
            }
        }
        catch (EOFException e) {
            this.fatal("end of input while looking for delimiter (started on line " + startLine + ')', null, new Character(delim).toString());
        }
        this.inLiteral = false;
        this.expandPE = saved;
        this.doReport = savedReport;
        if ((flags & 4) > 0) {
            this.dataBufferNormalize();
        }
        return this.dataBufferToString();
    }

    private ExternalIdentifiers readExternalIds(boolean inNotation, boolean isSubset) throws Exception {
        ExternalIdentifiers ids = new ExternalIdentifiers();
        int flags = 112;
        if (this.tryRead("PUBLIC")) {
            char c;
            this.requireWhitespace();
            ids.publicId = this.readLiteral(0x104 | flags);
            if (inNotation) {
                this.skipWhitespace();
                c = this.readCh();
                this.unread(c);
                if (c == '\"' || c == '\'') {
                    ids.systemId = this.readLiteral(flags);
                }
            } else {
                this.requireWhitespace();
                ids.systemId = this.readLiteral(flags);
            }
            for (int i = 0; i < ids.publicId.length(); ++i) {
                c = ids.publicId.charAt(i);
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || " \r\n0123456789-' ()+,./:=?;!*#@$_%".indexOf(c) != -1) continue;
                this.fatal("illegal PUBLIC id character U+" + Integer.toHexString(c));
            }
        } else if (this.tryRead("SYSTEM")) {
            this.requireWhitespace();
            ids.systemId = this.readLiteral(flags);
        } else if (!isSubset) {
            this.fatal("missing SYSTEM or PUBLIC keyword");
        }
        if (ids.systemId != null) {
            if (ids.systemId.indexOf(35) != -1) {
                this.handler.verror("SYSTEM id has a URI fragment: " + ids.systemId);
            }
            ids.baseUri = this.handler.getSystemId();
            if (ids.baseUri == null && uriWarnings) {
                this.handler.warn("No base URI; hope URI is absolute: " + ids.systemId);
            }
        }
        return ids;
    }

    private boolean isWhitespace(char c) {
        if (c > ' ') {
            return false;
        }
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    private void dataBufferAppend(char c) {
        if (this.dataBufferPos >= this.dataBuffer.length) {
            this.dataBuffer = (char[])this.extendArray(this.dataBuffer, this.dataBuffer.length, this.dataBufferPos);
        }
        this.dataBuffer[this.dataBufferPos++] = c;
    }

    private void dataBufferAppend(String s) {
        this.dataBufferAppend(s.toCharArray(), 0, s.length());
    }

    private void dataBufferAppend(char[] ch, int start, int length) {
        this.dataBuffer = (char[])this.extendArray(this.dataBuffer, this.dataBuffer.length, this.dataBufferPos + length);
        System.arraycopy(ch, start, this.dataBuffer, this.dataBufferPos, length);
        this.dataBufferPos += length;
    }

    private void dataBufferNormalize() {
        int j;
        int i = 0;
        int end = this.dataBufferPos;
        for (j = 0; j < end && this.dataBuffer[j] == ' '; ++j) {
        }
        while (end > j && this.dataBuffer[end - 1] == ' ') {
            --end;
        }
        while (j < end) {
            char c;
            if ((c = this.dataBuffer[j++]) == ' ') {
                while (j < end && this.dataBuffer[j++] == ' ') {
                }
                this.dataBuffer[i++] = 32;
                this.dataBuffer[i++] = this.dataBuffer[j - 1];
                continue;
            }
            this.dataBuffer[i++] = c;
        }
        this.dataBufferPos = i;
    }

    private String dataBufferToString() {
        String s = new String(this.dataBuffer, 0, this.dataBufferPos);
        this.dataBufferPos = 0;
        return s;
    }

    private void dataBufferFlush() throws SAXException {
        int saveLine = this.line;
        int saveColumn = this.column;
        this.line = this.linePrev;
        this.column = this.columnPrev;
        if (this.currentElementContent == 4 && this.dataBufferPos > 0 && !this.inCDATA) {
            for (int i = 0; i < this.dataBufferPos; ++i) {
                if (this.isWhitespace(this.dataBuffer[i])) continue;
                this.handler.charData(this.dataBuffer, 0, this.dataBufferPos);
                this.dataBufferPos = 0;
            }
            if (this.dataBufferPos > 0) {
                this.handler.ignorableWhitespace(this.dataBuffer, 0, this.dataBufferPos);
                this.dataBufferPos = 0;
            }
        } else if (this.dataBufferPos > 0) {
            this.handler.charData(this.dataBuffer, 0, this.dataBufferPos);
            this.dataBufferPos = 0;
        }
        this.line = saveLine;
        this.column = saveColumn;
    }

    private void require(String delim) throws SAXException, IOException {
        char[] ch;
        int length = delim.length();
        if (length < this.dataBuffer.length) {
            ch = this.dataBuffer;
            delim.getChars(0, length, ch, 0);
        } else {
            ch = delim.toCharArray();
        }
        for (int i = 0; i < length; ++i) {
            this.require(ch[i]);
        }
    }

    private void require(char delim) throws SAXException, IOException {
        char c = this.readCh();
        if (c != delim) {
            this.fatal("required character", c, new Character(delim).toString());
        }
    }

    public String intern(char[] ch, int start, int length) {
        int index = 0;
        int hash = 0;
        for (int i = start; i < start + length; ++i) {
            hash = 31 * hash + ch[i];
        }
        Object[] bucket = this.symbolTable[hash = (hash & Integer.MAX_VALUE) % 2039];
        if (bucket == null) {
            bucket = new Object[8];
        } else {
            char[] chFound;
            while (index < bucket.length && (chFound = (char[])bucket[index]) != null) {
                if (chFound.length == length) {
                    for (int i = 0; i < chFound.length && ch[start + i] == chFound[i]; ++i) {
                        if (i != length - 1) continue;
                        return (String)bucket[index + 1];
                    }
                }
                index += 2;
            }
            bucket = (Object[])this.extendArray(bucket, bucket.length, index);
        }
        this.symbolTable[hash] = bucket;
        String s = new String(ch, start, length).intern();
        bucket[index] = s.toCharArray();
        bucket[index + 1] = s;
        return s;
    }

    private Object extendArray(Object array, int currentSize, int requiredSize) {
        if (requiredSize < currentSize) {
            return array;
        }
        Object[] newArray = null;
        int newSize = currentSize * 2;
        if (newSize <= requiredSize) {
            newSize = requiredSize + 1;
        }
        if (array instanceof char[]) {
            newArray = new char[newSize];
        } else if (array instanceof Object[]) {
            newArray = new Object[newSize];
        } else {
            throw new RuntimeException();
        }
        System.arraycopy(array, 0, newArray, 0, currentSize);
        return newArray;
    }

    boolean isStandalone() {
        return this.docIsStandalone;
    }

    private int getContentType(ElementDecl element, int defaultType) {
        if (element == null) {
            return defaultType;
        }
        int retval = element.contentType;
        if (retval == 0) {
            retval = defaultType;
        }
        return retval;
    }

    public int getElementContentType(String name) {
        ElementDecl element = this.elementInfo.get(name);
        return this.getContentType(element, 0);
    }

    private void setElement(String name, int contentType, String contentModel, HashMap<String, AttributeDecl> attributes) throws SAXException {
        if (this.skippedPE) {
            return;
        }
        ElementDecl element = this.elementInfo.get(name);
        if (element == null) {
            element = new ElementDecl();
            element.contentType = contentType;
            element.contentModel = contentModel;
            element.attributes = attributes;
            this.elementInfo.put(name, element);
            return;
        }
        if (contentType != 0) {
            if (element.contentType == 0) {
                element.contentType = contentType;
                element.contentModel = contentModel;
            } else {
                this.handler.verror("multiple declarations for element type: " + name);
            }
        } else if (attributes != null) {
            element.attributes = attributes;
        }
    }

    private HashMap<String, AttributeDecl> getElementAttributes(String name) {
        ElementDecl element = this.elementInfo.get(name);
        return element == null ? null : element.attributes;
    }

    private Iterator<String> declaredAttributes(ElementDecl element) {
        if (element == null) {
            return null;
        }
        HashMap<String, AttributeDecl> attlist = element.attributes;
        if (attlist == null) {
            return null;
        }
        return attlist.keySet().iterator();
    }

    public Iterator<String> declaredAttributes(String elname) {
        return this.declaredAttributes(this.elementInfo.get(elname));
    }

    public String getAttributeType(String name, String aname) {
        AttributeDecl attribute = this.getAttribute(name, aname);
        return attribute == null ? null : attribute.type;
    }

    public String getAttributeEnumeration(String name, String aname) {
        AttributeDecl attribute = this.getAttribute(name, aname);
        return attribute == null ? null : attribute.enumeration;
    }

    public String getAttributeDefaultValue(String name, String aname) {
        AttributeDecl attribute = this.getAttribute(name, aname);
        return attribute == null ? null : attribute.value;
    }

    public int getAttributeDefaultValueType(String name, String aname) {
        AttributeDecl attribute = this.getAttribute(name, aname);
        return attribute == null ? 30 : attribute.valueType;
    }

    private void setAttribute(String elName, String name, String type, String enumeration, String value, int valueType) throws Exception {
        if (this.skippedPE) {
            return;
        }
        HashMap<String, AttributeDecl> attlist = this.getElementAttributes(elName);
        if (attlist == null) {
            attlist = new HashMap();
        }
        if (attlist.get(name) != null) {
            return;
        }
        AttributeDecl attribute = new AttributeDecl();
        attribute.type = type;
        attribute.value = value;
        attribute.valueType = valueType;
        attribute.enumeration = enumeration;
        attlist.put(name, attribute);
        this.setElement(elName, 0, null, attlist);
    }

    private AttributeDecl getAttribute(String elName, String name) {
        HashMap<String, AttributeDecl> attlist = this.getElementAttributes(elName);
        return attlist == null ? null : attlist.get(name);
    }

    public int getEntityType(String ename) {
        EntityInfo entity = this.entityInfo.get(ename);
        return entity == null ? 0 : entity.type;
    }

    public ExternalIdentifiers getEntityIds(String ename) {
        EntityInfo entity = this.entityInfo.get(ename);
        return entity == null ? null : entity.ids;
    }

    public String getEntityValue(String ename) {
        EntityInfo entity = this.entityInfo.get(ename);
        return entity == null ? null : entity.value;
    }

    private void setInternalEntity(String eName, String value) throws SAXException {
        if (this.skippedPE) {
            return;
        }
        if (this.entityInfo.get(eName) == null) {
            EntityInfo entity = new EntityInfo();
            entity.type = 1;
            entity.value = value;
            this.entityInfo.put(eName, entity);
        }
        if (this.handler.stringInterning ? "lt" == eName || "gt" == eName || "quot" == eName || "apos" == eName || "amp" == eName : "lt".equals(eName) || "gt".equals(eName) || "quot".equals(eName) || "apos".equals(eName) || "amp".equals(eName)) {
            return;
        }
        this.handler.getDeclHandler().internalEntityDecl(eName, value);
    }

    private void setExternalEntity(String eName, int eClass, ExternalIdentifiers ids, String nName) {
        if (this.entityInfo.get(eName) == null) {
            EntityInfo entity = new EntityInfo();
            entity.type = eClass;
            entity.ids = ids;
            entity.notationName = nName;
            this.entityInfo.put(eName, entity);
        }
    }

    private void setNotation(String nname, ExternalIdentifiers ids) throws SAXException {
        if (this.skippedPE) {
            return;
        }
        this.handler.notationDecl(nname, ids.publicId, ids.systemId, ids.baseUri);
        if (this.notationInfo.get(nname) == null) {
            this.notationInfo.put(nname, nname);
        } else {
            this.handler.verror("Duplicate notation name decl: " + nname);
        }
    }

    public int getLineNumber() {
        if (this.line > 0) {
            return this.line;
        }
        return -1;
    }

    public int getColumnNumber() {
        if (this.column > 0) {
            return this.column;
        }
        return -1;
    }

    private char readCh() throws SAXException, IOException {
        this.fillBuffer();
        char c = this.readBuffer[this.readBufferPos++];
        this.advanceLocation();
        if ((c & 0xFC00) == 56320) {
            if ((this.prev & 0xFC00) == 55296) {
                int intVal = (this.prev << 10) + c + -56613888;
                if (this.isNonCharacter(intVal)) {
                    this.handler.warn("Astral non-character.");
                }
                if (this.isAstralPrivateUse(intVal)) {
                    this.warnAboutPrivateUseChar();
                }
            } else if (this.prev != '\u0000') {
                this.fatal("Unmatched low surrogate.");
            }
            this.prev = c;
        } else if ((this.prev & 0xFC00) == 55296) {
            this.fatal("Unmatched high surrogate.");
        }
        if (c == '\n') {
            this.nextCharOnNewLine = true;
        } else {
            if (c != '<') {
                if (c < ' ' && c != '\t' && c != '\r' || c > '\ufffd' || c >= '\u007f' && c <= '\u009f' && c != '\u0085' && this.xmlVersion == 1) {
                    this.fatal("illegal XML character U+" + Integer.toHexString(c));
                } else if (c >= '\u007f' && c <= '\u009f') {
                    this.handler.warn("Saw a control character: U+00" + Integer.toHexString(c) + ".");
                }
            }
            if (this.isPrivateUse(c)) {
                this.warnAboutPrivateUseChar();
            } else if (c == '%' && this.expandPE) {
                if (this.peIsError) {
                    this.fatal("PE reference within decl in internal subset.");
                }
                this.parsePEReference();
                return this.readCh();
            }
        }
        return c;
    }

    private void fillBuffer() throws SAXException, IOException {
        block3: while (this.readBufferPos >= this.readBufferLength) {
            switch (this.sourceType) {
                case 5: {
                    this.readDataChunk();
                    while (this.readBufferLength < 1) {
                        this.popInput();
                        if (this.readBufferLength >= 1) continue;
                        this.readDataChunk();
                    }
                    continue block3;
                }
            }
            this.popInput();
        }
    }

    private void unread(char c) throws SAXException {
        this.rollbackLocation();
        if (this.readBufferPos > 0) {
            this.readBuffer[--this.readBufferPos] = c;
        } else {
            this.pushString(null, new Character(c).toString());
        }
    }

    private void rollbackLocation() {
        assert (this.column != this.columnPrev || this.line != this.linePrev);
        this.nextCharOnNewLine = this.column == 1;
        this.line = this.linePrev;
        this.column = this.columnPrev;
    }

    private void unread(char[] ch, int length) throws SAXException {
        if (length < this.readBufferPos) {
            this.readBufferPos -= length;
        } else {
            this.pushCharArray(null, ch, 0, length);
        }
    }

    private void pushURL(boolean isPE, String ename, ExternalIdentifiers ids, Reader aReader, InputStream aStream, String aEncoding, boolean doResolve) throws SAXException, IOException {
        InputSource source;
        InputSource scratch = new InputSource();
        if (!isPE) {
            this.dataBufferFlush();
        }
        scratch.setPublicId(ids.publicId);
        scratch.setSystemId(ids.systemId);
        if (doResolve) {
            source = this.handler.resolveEntity(isPE, ename, scratch, ids.baseUri);
            if (source == null) {
                this.handler.warn("skipping entity: " + ename);
                this.handler.skippedEntity(ename);
                if (isPE) {
                    this.skippedPE = true;
                }
                return;
            }
            String systemId = source.getSystemId();
        } else {
            scratch.setCharacterStream(aReader);
            scratch.setByteStream(aStream);
            scratch.setEncoding(aEncoding);
            source = scratch;
            String systemId = ids.systemId;
            if (this.handler.stringInterning) {
                this.handler.startExternalEntity(ename, systemId, "[document]" == ename);
            } else {
                this.handler.startExternalEntity(ename, systemId, "[document]".equals(ename));
            }
        }
        this.pushInput(ename);
        this.readBuffer = new char[64];
        this.readBufferPos = 0;
        this.readBufferLength = 0;
        this.readBufferOverflow = -1;
        this.is = null;
        this.reader = null;
        this.line = 0;
        this.column = 1;
        this.linePrev = 0;
        this.columnPrev = 1;
        this.nextCharOnNewLine = true;
        this.currentByteCount = 0;
        if (source.getCharacterStream() != null) {
            char bom;
            this.sourceType = 5;
            this.reader = source.getCharacterStream();
            if ("UTF-8".equalsIgnoreCase(source.getEncoding()) && (bom = this.readCh()) != '\ufeff') {
                this.unread(bom);
            }
            this.tryEncodingDecl(source.getEncoding() == null ? "" : source.getEncoding());
            return;
        }
        if (source.getByteStream() != null) {
            this.is = source.getByteStream();
        } else {
            this.fatal("The entity resolver didn't properly resolve the entity.");
        }
        if (!this.is.markSupported()) {
            this.is = new BufferedInputStream(this.is);
        }
        if (source.getEncoding() != null) {
            char bom;
            this.draconianInputStreamReader(source.getEncoding(), this.is, false);
            if ("UTF-8".equalsIgnoreCase(source.getEncoding()) && (bom = this.readCh()) != '\ufeff') {
                this.unread(bom);
            }
            this.tryEncodingDecl(source.getEncoding());
        } else {
            this.detectEncoding();
            String enc = this.tryEncodingDecl(null);
            if (enc == null && "UTF-32" == this.characterEncoding) {
                this.fatal("UTF-32 was sniffed from the BOM, but there was no matching encoding declaration. The omission of explicit encoding declaration is only allowed with UTF-8 and UTF-16.");
            }
        }
    }

    private String tryEncodingDecl(String encoding) throws SAXException, IOException {
        if (this.tryRead("<?xml")) {
            if (this.tryWhitespace()) {
                if (this.inputStack.size() > 0) {
                    return this.parseTextDecl(encoding);
                }
                return this.parseXMLDecl(encoding);
            }
            this.pushString(null, "<?xml");
        }
        this.warnAboutLackOfEncodingDecl(encoding);
        return null;
    }

    private void warnAboutLackOfEncodingDecl(String encoding) throws SAXException {
        if (!(encoding == null || "".equals(encoding) || "UTF-8".equalsIgnoreCase(encoding) || "UTF-16".equalsIgnoreCase(encoding))) {
            this.handler.warn("External encoding information specified a non-UTF-8/non-UTF-16 encoding (" + encoding + "), but there was no matching internal encoding declaration. The well-formedness status of this document may change when decoupled from the external encoding information.");
        }
    }

    private void detectEncoding() throws SAXException, IOException {
        byte[] signature = new byte[6];
        this.is.mark(6);
        this.is.read(signature);
        this.is.reset();
        if (XmlParser.tryEncoding(signature, (byte)0, (byte)0, (byte)0, (byte)60)) {
            this.fatal("UTF-32BE is not supported. (XML processors are only required to support UTF-8 and UTF-16.)");
        } else if (XmlParser.tryEncoding(signature, (byte)60, (byte)0, (byte)0, (byte)0)) {
            this.fatal("UTF-32LE is not supported. (XML processors are only required to support UTF-8 and UTF-16.)");
        } else if (XmlParser.tryEncoding(signature, (byte)0, (byte)0, (byte)60, (byte)0)) {
            this.fatal("Unsupported 32-bit encoding. (XML processors are only required to support UTF-8 and UTF-16.)");
        } else if (XmlParser.tryEncoding(signature, (byte)0, (byte)60, (byte)0, (byte)0)) {
            this.fatal("Unsupported 32-bit encoding. (XML processors are only required to support UTF-8 and UTF-16.)");
        } else if (XmlParser.tryEncoding(signature, (byte)0, (byte)0, (byte)-2, (byte)-1)) {
            this.fatal("UTF-32 is not supported. (XML processors are only required to support UTF-8 and UTF-16.)");
        } else if (XmlParser.tryEncoding(signature, (byte)0, (byte)60, (byte)0, (byte)0)) {
            this.fatal("UTF-32 is not supported. (XML processors are only required to support UTF-8 and UTF-16.)");
        } else if (XmlParser.tryEncoding(signature, (byte)-2, (byte)-1)) {
            this.is.read();
            this.is.read();
            this.draconianInputStreamReader("UTF-16BE", this.is, false, "UTF-16");
        } else if (XmlParser.tryEncoding(signature, (byte)-1, (byte)-2)) {
            this.is.read();
            this.is.read();
            this.draconianInputStreamReader("UTF-16LE", this.is, false, "UTF-16");
        } else if (XmlParser.tryEncoding(signature, (byte)0, (byte)60, (byte)0, (byte)63)) {
            this.fatal("no byte-order mark for UTF-16 entity");
        } else if (XmlParser.tryEncoding(signature, (byte)60, (byte)0, (byte)63, (byte)0)) {
            this.fatal("no byte-order mark for UTF-16 entity");
        } else if (XmlParser.tryEncoding(signature, (byte)76, (byte)111, (byte)-89, (byte)-108)) {
            this.fatal("Unsupported EBCDIC encoding. (XML processors are only required to support UTF-8 and UTF-16.)");
        } else if (signature[0] == 60 && signature[1] == 63 && signature[2] == 120 && signature[3] == 109 && signature[4] == 108 && (signature[5] == 32 || signature[5] == 10 || signature[5] == 13 || signature[5] == 9)) {
            this.characterEncoding = null;
            this.prefetchASCIIEncodingDecl();
        } else if (signature[0] == -17 && signature[1] == -69 && signature[2] == -65) {
            this.is.read();
            this.is.read();
            this.is.read();
            this.draconianInputStreamReader("UTF-8", this.is, false);
        } else {
            this.draconianInputStreamReader("UTF-8", this.is, false);
        }
    }

    private static boolean tryEncoding(byte[] sig, byte b1, byte b2, byte b3, byte b4) {
        return sig[0] == b1 && sig[1] == b2 && sig[2] == b3 && sig[3] == b4;
    }

    private static boolean tryEncoding(byte[] sig, byte b1, byte b2) {
        return sig[0] == b1 && sig[1] == b2;
    }

    private void pushString(String ename, String s) throws SAXException {
        char[] ch = s.toCharArray();
        this.pushCharArray(ename, ch, 0, ch.length);
    }

    private void pushCharArray(String ename, char[] ch, int start, int length) throws SAXException {
        this.pushInput(ename);
        if (ename != null && this.doReport) {
            this.dataBufferFlush();
            this.handler.startInternalEntity(ename);
        }
        this.sourceType = 1;
        this.readBuffer = ch;
        this.readBufferPos = start;
        this.readBufferLength = length;
        this.readBufferOverflow = -1;
    }

    private void pushInput(String ename) throws SAXException {
        if (this.entityStack.size() > 16) {
            this.fatal("Entity recursion too deep. Stopping to protect against denial of service attacks.");
        }
        if (ename != null) {
            for (String e : this.entityStack) {
                if (e == null || e != ename) continue;
                this.fatal("recursive reference to entity", ename, null);
            }
        }
        this.entityStack.addLast(ename);
        if (this.sourceType == 0) {
            return;
        }
        Input input = new Input();
        input.sourceType = this.sourceType;
        input.readBuffer = this.readBuffer;
        input.readBufferPos = this.readBufferPos;
        input.readBufferLength = this.readBufferLength;
        input.line = this.line;
        input.linePrev = this.linePrev;
        input.charecterEncoding = this.characterEncoding;
        input.readBufferOverflow = this.readBufferOverflow;
        input.is = this.is;
        input.currentByteCount = this.currentByteCount;
        input.column = this.column;
        input.columnPrev = this.columnPrev;
        input.nextCharOnNewLine = this.nextCharOnNewLine;
        input.reader = this.reader;
        input.prev = this.prev;
        input.normalizationChecker = this.normalizationChecker;
        input.characterHandler = this.characterHandler;
        this.characterHandler = null;
        this.inputStack.addLast(input);
    }

    private void popInput() throws SAXException, IOException {
        String ename = this.entityStack.removeLast();
        if (ename != null && this.doReport) {
            this.dataBufferFlush();
        }
        switch (this.sourceType) {
            case 5: {
                this.handler.endExternalEntity(ename);
                this.reader.close();
                break;
            }
            case 1: {
                if (ename == null || !this.doReport) break;
                this.handler.endInternalEntity(ename);
            }
        }
        if (this.characterHandler != null) {
            this.characterHandler.end();
        }
        if (this.normalizationChecker != null) {
            this.normalizationChecker.end();
        }
        if (this.inputStack.isEmpty()) {
            throw new EOFException("no more input");
        }
        Input input = this.inputStack.removeLast();
        this.sourceType = input.sourceType;
        this.readBuffer = input.readBuffer;
        this.readBufferPos = input.readBufferPos;
        this.readBufferLength = input.readBufferLength;
        this.line = input.line;
        this.linePrev = input.linePrev;
        this.characterEncoding = input.charecterEncoding;
        this.readBufferOverflow = input.readBufferOverflow;
        this.is = input.is;
        this.currentByteCount = input.currentByteCount;
        this.column = input.column;
        this.columnPrev = input.columnPrev;
        this.nextCharOnNewLine = input.nextCharOnNewLine;
        this.reader = input.reader;
        this.prev = input.prev;
        this.normalizationChecker = input.normalizationChecker;
        this.characterHandler = input.characterHandler;
    }

    private boolean tryRead(char delim) throws SAXException, IOException {
        char c = this.readCh();
        if (c == delim) {
            return true;
        }
        this.unread(c);
        return false;
    }

    private boolean tryRead(String delim) throws SAXException, IOException {
        return this.tryRead(delim.toCharArray());
    }

    private boolean tryRead(char[] ch) throws SAXException, IOException {
        int saveLine = this.line;
        int saveColumn = this.column;
        int saveLinePrev = this.linePrev;
        int saveColumnPrev = this.columnPrev;
        boolean saveNextCharOnNewLine = this.nextCharOnNewLine;
        for (int i = 0; i < ch.length; ++i) {
            char c = this.readCh();
            if (c == ch[i]) continue;
            this.unread(c);
            if (i != 0) {
                this.unread(ch, i);
            }
            this.line = saveLine;
            this.column = saveColumn;
            this.linePrev = saveLinePrev;
            this.columnPrev = saveColumnPrev;
            this.nextCharOnNewLine = saveNextCharOnNewLine;
            return false;
        }
        return true;
    }

    private boolean tryWhitespace() throws SAXException, IOException {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
            return true;
        }
        this.unread(c);
        return false;
    }

    private void parseUntil(char[] delim) throws SAXException, IOException {
        int startLine = this.line;
        try {
            while (!this.tryRead(delim)) {
                char c = this.readCh();
                this.dataBufferAppend(c);
            }
        }
        catch (EOFException e) {
            this.fatal("end of input while looking for delimiter (started on line " + startLine + ')', null, new String(delim));
        }
    }

    private void prefetchASCIIEncodingDecl() throws SAXException, IOException {
        this.readBufferLength = 0;
        this.readBufferPos = 0;
        this.is.mark(this.readBuffer.length);
        while (true) {
            int ch = this.is.read();
            this.readBuffer[this.readBufferLength++] = (char)ch;
            switch (ch) {
                case 62: {
                    return;
                }
                case -1: {
                    this.fatal("file ends before end of XML or encoding declaration.", null, "?>");
                }
            }
            if (this.readBuffer.length != this.readBufferLength) continue;
            this.fatal("unfinished XML or encoding declaration");
        }
    }

    private void readDataChunk() throws SAXException, IOException {
        int count;
        if (this.readBufferOverflow > -1) {
            this.readBuffer[0] = (char)this.readBufferOverflow;
            this.readBufferOverflow = -1;
            this.readBufferPos = 1;
        } else {
            this.readBufferPos = 0;
        }
        try {
            count = this.reader.read(this.readBuffer, this.readBufferPos, 60 - this.readBufferPos);
        }
        catch (CharacterCodingException cce) {
            this.fatal("Input data does not conform to the input encoding. The input encoding was " + this.characterEncoding + ".");
            return;
        }
        if (this.characterHandler != null && count > 0) {
            this.characterHandler.characters(this.readBuffer, this.readBufferPos, count);
        }
        if (this.normalizationChecker != null && count > 0) {
            this.normalizationChecker.characters(this.readBuffer, this.readBufferPos, count);
        }
        this.readBufferLength = count < 0 ? this.readBufferPos : this.readBufferPos + count;
        if (this.readBufferLength > 0) {
            this.filterCR(count >= 0);
        }
    }

    private void filterCR(boolean moreData) {
        int j;
        this.readBufferOverflow = -1;
        int i = j = this.readBufferPos;
        block3: while (j < this.readBufferLength) {
            switch (this.readBuffer[j]) {
                case '\r': {
                    if (j == this.readBufferLength - 1) {
                        if (moreData) {
                            this.readBufferOverflow = 13;
                            --this.readBufferLength;
                            break block3;
                        }
                        this.readBuffer[i++] = 10;
                        break block3;
                    }
                    if (this.readBuffer[j + 1] == '\n') {
                        ++j;
                    }
                    this.readBuffer[i] = 10;
                    break;
                }
                default: {
                    this.readBuffer[i] = this.readBuffer[j];
                }
            }
            ++i;
            ++j;
        }
        this.readBufferLength = i;
    }

    private void warnAboutPrivateUseChar() throws SAXException {
        if (!this.alreadyWarnedAboutPrivateUseCharacters) {
            this.handler.warn("Document uses the Unicode Private Use Area(s), which should not be used in publicly exchanged documents. (Charmod C073)");
            this.alreadyWarnedAboutPrivateUseCharacters = true;
        }
    }

    private boolean isPrivateUse(char c) {
        return c >= '\ue000' && c <= '\uf8ff';
    }

    private boolean isPrivateUse(int c) {
        return c >= 57344 && c <= 63743 || c >= 983040 && c <= 1048573 || c >= 0x100000 && c <= 1114109;
    }

    private boolean isAstralPrivateUse(int c) {
        return c >= 983040 && c <= 1048573 || c >= 0x100000 && c <= 1114109;
    }

    private boolean isNonCharacter(int c) {
        return (c & 0xFFFE) == 65534;
    }

    private void initializeVariables() throws SAXException {
        this.prev = '\u0000';
        this.line = 0;
        this.column = 1;
        this.linePrev = 0;
        this.columnPrev = 1;
        this.nextCharOnNewLine = true;
        this.dataBufferPos = 0;
        this.dataBuffer = new char[DATA_BUFFER_INITIAL];
        this.nameBufferPos = 0;
        this.nameBuffer = new char[NAME_BUFFER_INITIAL];
        this.elementInfo = new HashMap();
        this.entityInfo = new HashMap();
        this.notationInfo = new HashMap();
        this.skippedPE = false;
        this.currentElement = null;
        this.currentElementContent = 0;
        this.sourceType = 0;
        this.inputStack = new LinkedList();
        this.entityStack = new LinkedList();
        this.tagAttributePos = 0;
        this.tagAttributes = new String[100];
        this.readBufferOverflow = -1;
        this.inLiteral = false;
        this.expandPE = false;
        this.peIsError = false;
        this.doReport = false;
        this.inCDATA = false;
        this.symbolTable = new Object[2039][];
        if (this.handler.checkNormalization) {
            this.normalizationChecker = new NormalizationChecker(this.handler);
            this.normalizationChecker.setErrorHandler(this.handler.getErrorHandler());
            this.normalizationChecker.start();
        } else {
            this.normalizationChecker = null;
        }
        if (this.handler.characterHandler != null) {
            this.characterHandler = this.handler.characterHandler;
            this.handler.characterHandler = null;
            this.characterHandler.start();
        } else {
            this.characterHandler = null;
        }
    }

    public String getEncoding() {
        return this.characterEncoding;
    }

    static {
        String key = "gnu.xml.aelfred2.XmlParser.uriWarnings";
        try {
            uriWarnings = "true".equals(System.getProperty(key));
        }
        catch (SecurityException e) {
            uriWarnings = false;
        }
        DATA_BUFFER_INITIAL = 4096;
        NAME_BUFFER_INITIAL = 1024;
        startDelimComment = new char[]{'<', '!', '-', '-'};
        endDelimComment = new char[]{'-', '-'};
        startDelimPI = new char[]{'<', '?'};
        endDelimPI = new char[]{'?', '>'};
        endDelimCDATA = new char[]{']', ']', '>'};
    }

    static class Input {
        CharacterHandler characterHandler;
        boolean nextCharOnNewLine;
        int columnPrev;
        int linePrev;
        char prev;
        int sourceType;
        char[] readBuffer;
        int readBufferPos;
        int readBufferLength;
        int line;
        String charecterEncoding;
        int readBufferOverflow;
        InputStream is;
        int currentByteCount;
        int column;
        Reader reader;
        NormalizationChecker normalizationChecker;

        Input() {
        }
    }

    static class ElementDecl {
        int contentType;
        String contentModel;
        HashMap<String, AttributeDecl> attributes;

        ElementDecl() {
        }
    }

    static class AttributeDecl {
        String type;
        String value;
        int valueType;
        String enumeration;
        String defaultValue;

        AttributeDecl() {
        }
    }

    static class EntityInfo {
        int type;
        ExternalIdentifiers ids;
        String value;
        String notationName;

        EntityInfo() {
        }
    }

    static class ExternalIdentifiers {
        String publicId;
        String systemId;
        String baseUri;

        ExternalIdentifiers() {
        }

        ExternalIdentifiers(String publicId, String systemId, String baseUri) {
            this.publicId = publicId;
            this.systemId = systemId;
            this.baseUri = baseUri;
        }
    }
}

