/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.sax;

import nu.validator.htmlparser.impl.HtmlAttributes;
import nu.validator.htmlparser.impl.TreeBuilder;
import nu.validator.saxtree.Characters;
import nu.validator.saxtree.Comment;
import nu.validator.saxtree.DTD;
import nu.validator.saxtree.Document;
import nu.validator.saxtree.DocumentFragment;
import nu.validator.saxtree.Element;
import nu.validator.saxtree.Node;
import nu.validator.saxtree.ParentNode;
import org.xml.sax.SAXException;

class SAXTreeBuilder
extends TreeBuilder<Element> {
    private static final char[] ISINDEX_PROMPT = "This is a searchable index. Enter search keywords: ".toCharArray();
    private Document document;
    private Node cachedTable = null;
    private Node cachedTablePreviousSibling = null;

    SAXTreeBuilder() {
    }

    @Override
    protected void appendComment(Element parent, char[] buf, int start, int length) {
        parent.appendChild(new Comment(this.tokenizer, buf, start, length));
    }

    @Override
    protected void appendCommentToDocument(char[] buf, int start, int length) {
        this.document.appendChild(new Comment(this.tokenizer, buf, start, length));
    }

    @Override
    protected void appendCharacters(Element parent, char[] buf, int start, int length) {
        parent.appendChild(new Characters(this.tokenizer, buf, start, length));
    }

    @Override
    protected void appendIsindexPrompt(Element parent) throws SAXException {
        parent.appendChild(new Characters(this.tokenizer, ISINDEX_PROMPT, 0, ISINDEX_PROMPT.length));
    }

    @Override
    protected boolean hasChildren(Element element) {
        return element.getFirstChild() != null;
    }

    @Override
    protected void appendElement(Element child, Element newParent) {
        newParent.appendChild(child);
    }

    @Override
    protected Element createHtmlElementSetAsRoot(HtmlAttributes attributes) {
        Element newElt = new Element(this.tokenizer, "http://www.w3.org/1999/xhtml", "html", "html", attributes, true, null);
        this.document.appendChild(newElt);
        return newElt;
    }

    @Override
    protected void addAttributesToElement(Element element, HtmlAttributes attributes) throws SAXException {
        HtmlAttributes existingAttrs = (HtmlAttributes)element.getAttributes();
        existingAttrs.merge(attributes);
    }

    @Override
    protected void appendDoctypeToDocument(String name, String publicIdentifier, String systemIdentifier) {
        DTD dtd = new DTD(this.tokenizer, name, publicIdentifier, systemIdentifier);
        dtd.setEndLocator(this.tokenizer);
        this.document.appendChild(dtd);
    }

    Document getDocument() {
        Document rv = this.document;
        this.document = null;
        return rv;
    }

    DocumentFragment getDocumentFragment() {
        DocumentFragment rv = new DocumentFragment();
        rv.appendChildren(this.document.getFirstChild());
        this.document = null;
        return rv;
    }

    @Override
    protected void end() throws SAXException {
        this.document.setEndLocator(this.tokenizer);
        this.cachedTable = null;
        this.cachedTablePreviousSibling = null;
    }

    @Override
    protected void start(boolean fragment) {
        this.document = new Document(this.tokenizer);
        this.cachedTable = null;
        this.cachedTablePreviousSibling = null;
    }

    @Override
    protected void appendChildrenToNewParent(Element oldParent, Element newParent) throws SAXException {
        newParent.appendChildren(oldParent);
    }

    @Override
    protected Element createElement(String ns, String name, HtmlAttributes attributes, Element intendedParent) throws SAXException {
        return new Element(this.tokenizer, ns, name, name, attributes, true, null);
    }

    @Override
    protected Element createAndInsertFosterParentedElement(String ns, String name, HtmlAttributes attributes, Element table, Element stackParent) throws SAXException {
        ParentNode parent = table.getParentNode();
        Element child = this.createElement(ns, name, attributes, parent != null ? (Element)parent : stackParent);
        if (parent != null) {
            parent.insertBetween(child, this.previousSibling(table), table);
            this.cachedTablePreviousSibling = child;
        } else {
            stackParent.appendChild(child);
        }
        return child;
    }

    @Override
    protected void insertFosterParentedCharacters(char[] buf, int start, int length, Element table, Element stackParent) throws SAXException {
        Characters child = new Characters(this.tokenizer, buf, start, length);
        ParentNode parent = table.getParentNode();
        if (parent != null) {
            parent.insertBetween(child, this.previousSibling(table), table);
            this.cachedTablePreviousSibling = child;
        } else {
            stackParent.appendChild(child);
        }
    }

    @Override
    protected void insertFosterParentedChild(Element child, Element table, Element stackParent) throws SAXException {
        ParentNode parent = table.getParentNode();
        if (parent != null) {
            parent.insertBetween(child, this.previousSibling(table), table);
            this.cachedTablePreviousSibling = child;
        } else {
            stackParent.appendChild(child);
        }
    }

    private Node previousSibling(Node table) {
        if (table == this.cachedTable) {
            return this.cachedTablePreviousSibling;
        }
        this.cachedTable = table;
        this.cachedTablePreviousSibling = table.getPreviousSibling();
        return this.cachedTablePreviousSibling;
    }

    @Override
    protected void detachFromParent(Element element) throws SAXException {
        element.detach();
    }
}

