/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet;

import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import nu.validator.servlet.InboundGzipFilter;
import nu.validator.servlet.InboundSizeLimitFilter;
import nu.validator.servlet.MultipartFormDataFilter;
import nu.validator.servlet.VerifierServlet;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.GzipFilter;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class Main {
    private static final long SIZE_LIMIT = Integer.parseInt(System.getProperty("nu.validator.servlet.max-file-size", "2097152"));

    public static void main(String[] args) throws Exception {
        block55: {
            if (!"1".equals(System.getProperty("nu.validator.servlet.read-local-log4j-properties"))) {
                PropertyConfigurator.configure(Main.class.getClassLoader().getResource("nu/validator/localentities/files/log4j.properties"));
            } else {
                PropertyConfigurator.configure(System.getProperty("nu.validator.servlet.log4j-properties", "log4j.properties"));
            }
            ServletContextHandler contextHandler = new ServletContextHandler();
            contextHandler.setContextPath("/");
            contextHandler.addFilter(new FilterHolder(new GzipFilter()), "/*", EnumSet.of(DispatcherType.REQUEST));
            contextHandler.addFilter(new FilterHolder(new InboundSizeLimitFilter(SIZE_LIMIT)), "/*", EnumSet.of(DispatcherType.REQUEST));
            contextHandler.addFilter(new FilterHolder(new InboundGzipFilter()), "/*", EnumSet.of(DispatcherType.REQUEST));
            contextHandler.addFilter(new FilterHolder(new MultipartFormDataFilter()), "/*", EnumSet.of(DispatcherType.REQUEST));
            contextHandler.addServlet(new ServletHolder(new VerifierServlet()), "/*");
            Server server = new Server(new QueuedThreadPool(100));
            server.setHandler(contextHandler);
            ServerConnector serverConnector = new ServerConnector(server, new HttpConnectionFactory(new HttpConfiguration()));
            int port = args.length > 0 ? Integer.parseInt(args[0]) : 8888;
            serverConnector.setPort(port);
            server.setConnectors(new Connector[]{serverConnector});
            int stopPort = -1;
            if (args.length > 1) {
                stopPort = Integer.parseInt(args[1]);
            }
            if (stopPort != -1) {
                Throwable throwable;
                Throwable throwable2;
                try {
                    throwable2 = null;
                    try (Socket clientSocket = new Socket(InetAddress.getByName("127.0.0.1"), stopPort);){
                        throwable = null;
                        try (InputStream in = clientSocket.getInputStream();){
                            in.read();
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (Throwable in) {
                        throwable2 = in;
                        throw in;
                    }
                }
                catch (ConnectException clientSocket) {
                    // empty catch block
                }
                server.start();
                throwable2 = null;
                try (ServerSocket serverSocket = new ServerSocket(stopPort, 0, InetAddress.getByName("127.0.0.1"));){
                    throwable = null;
                    try (Socket s = serverSocket.accept();){
                        server.stop();
                        s.getOutputStream().close();
                        break block55;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
            }
            server.start();
        }
    }
}

