# Copyright The IETF Trust 2019-2020, All Rights Reserved
# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2019-05-27 05:56


from django.db import migrations

import sys, time

from tqdm import tqdm


def forward(apps, schema_editor):

    CommunityList               = apps.get_model('community', 'CommunityList')
    CommunityListDocs           = apps.get_model('community', 'CommunityListDocs')
    SearchRule                  = apps.get_model('community', 'SearchRule')
    SearchRuleDocs              = apps.get_model('community', 'SearchRuleDocs')

    # Document id fixup ------------------------------------------------------------


    sys.stderr.write('\n')

    sys.stderr.write(' %s.%s:\n' % (CommunityList.__name__, 'added_docs'))
    for l in tqdm(CommunityList.objects.all()):
        l.added_docs.set([ d.document for d in CommunityListDocs.objects.filter(communitylist=l) ])

    sys.stderr.write(' %s.%s:\n' % (SearchRule.__name__, 'name_contains_index'))
    for r in tqdm(SearchRule.objects.all()):
        r.name_contains_index.set([ d.document for d in SearchRuleDocs.objects.filter(searchrule=r) ])

def reverse(apps, schema_editor):
    pass

def timestamp(apps, schema_editor):
    sys.stderr.write('\n %s' % time.strftime('%Y-%m-%d %H:%M:%S'))

class Migration(migrations.Migration):

    dependencies = [
        ('community', '0005_2_add_docs_m2m_table'),
    ]

    operations = [
        #migrations.RunPython(forward, reverse),
        # Alternative:
        migrations.RunPython(timestamp, timestamp),
        migrations.RunSQL(
            "INSERT INTO community_communitylist_added_docs SELECT * FROM community_communitylistdocs;",
            ""),
        migrations.RunPython(timestamp, timestamp),
        migrations.RunSQL(
            "INSERT INTO community_searchrule_name_contains_index SELECT * FROM community_searchruledocs;",
            ""),
        migrations.RunPython(timestamp, timestamp),
    ]
