# Copyright The IETF Trust 2019-2020, All Rights Reserved
# -*- coding: utf-8 -*-
# Generated by Django 1.11.26 on 2019-11-19 11:47


from django.db import migrations

def forward(apps, schema_editor):
    DBTemplate = apps.get_model('dbtemplate','DBTemplate')
    qs = DBTemplate.objects.filter(path='/group/defaults/email/review_assigned.txt')
    qs.update(content="""{{ assigner.ascii }} has assigned {{ reviewer.person.ascii }} as a reviewer for this document.

{% if prev_team_reviews %}This team has completed other reviews of this document:{% endif %}{% for assignment in prev_team_reviews %}
- {{ assignment.completed_on }} {{ assignment.reviewer.person.ascii }} -{% if assignment.reviewed_rev %}{{ assignment.reviewed_rev }}{% else %}{{ assignment.review_request.requested_rev }}{% endif %} {{ assignment.result.name }}  
{% endfor %}
""")
    qs.update(title="Default template for review assignment email")

def reverse(apps, schema_editor):
    DBTemplate = apps.get_model('dbtemplate','DBTemplate')
    qs = DBTemplate.objects.filter(path='/group/defaults/email/review_assigned.txt')
    qs.update(content="""{{ assigner.ascii }} has assigned you as a reviewer for this document.

{% if prev_team_reviews %}This team has completed other reviews of this document:{% endif %}{% for assignment in prev_team_reviews %}
- {{ assignment.completed_on }} {{ assignment.reviewer.person.ascii }} -{% if assignment.reviewed_rev %}{{ assignment.reviewed_rev }}{% else %}{{ assignment.review_request.requested_rev }}{% endif %} {{ assignment.result.name }}  
{% endfor %}
""")


class Migration(migrations.Migration):

    dependencies = [
        ('dbtemplate', '0006_add_review_assigned_template'),
    ]

    operations = [
        migrations.RunPython(forward, reverse)
    ]
