# Copyright The IETF Trust 2018-2020, All Rights Reserved
# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2018-11-04 10:56


from tqdm import tqdm

from django.db import migrations


def forward(apps, schema_editor):
    State = apps.get_model('doc','State')
    Document = apps.get_model('doc','Document')
    DocHistory = apps.get_model('doc','DocHistory')

    idexists = State.objects.create(
        type_id = 'draft-iesg',
        slug = 'idexists',
        name = 'I-D Exists',
        used = True,
        desc = 'The IESG has not started processing this draft, or has stopped processing it without publicastion.',
        order = 0,
    )
    idexists.next_states.set(State.objects.filter(type='draft-iesg',slug__in=['pub-req','watching']))

    #for doc in tqdm(Document.objects.filter(type='draft'):
    #    if not doc.states.filter(type='draft-iesg').exists():
    #        doc.states.add(idexists)
    #    for dh in doc.history_set.all():
    #        if not dh.states.filter(type='draft-iesg').exists():
    #            dh.states.add(idexists)            

    for doc in tqdm(Document.objects.filter(type_id='draft').exclude(states__type_id='draft-iesg')):
        doc.states.add(idexists)
    for history in tqdm(DocHistory.objects.filter(type_id='draft').exclude(states__type_id='draft-iesg')):
        history.states.add(idexists)


def reverse(apps, schema_editor):
    State = apps.get_model('doc','State')
    State.objects.filter(slug='idexists').delete()

class Migration(migrations.Migration):

    dependencies = [
        ('doc', '0006_ballotpositiondocevent_send_email'),
    ]

    operations = [
        migrations.RunPython(forward, reverse)
    ]
