# -*- coding: utf-8 -*-
# Copyright The IETF Trust 2020, All Rights Reserved
# Generated by Django 1.11.28 on 2020-03-03 13:54
from __future__ import unicode_literals

from django.db import migrations

def forward(apps, schema_editor):

    Person = apps.get_model('person', 'Person')

    Document = apps.get_model('doc','Document')
    State = apps.get_model('doc','State')
    BallotDocEvent = apps.get_model('doc','BallotDocEvent')

    replaced_state = State.objects.create(type_id='charter', slug='replaced', name='Replaced', used=True, desc="This charter's group was replaced.", order = 0)
    by = Person.objects.get(name='(System)')

    for doc in Document.objects.filter(type_id='charter',states__type_id='charter',states__slug__in=['intrev','extrev'],group__state='replaced'):
        doc.states.remove(*list(doc.states.filter(type_id='charter')))
        doc.states.add(replaced_state)
        ballot = BallotDocEvent.objects.filter(doc=doc, type__in=('created_ballot', 'closed_ballot')).order_by('-time', '-id').first()
        if ballot and ballot.type == 'created_ballot':
            e = BallotDocEvent(type="closed_ballot", doc=doc, rev=doc.rev, by=by)
            e.ballot_type = ballot.ballot_type
            e.desc = 'Closed "%s" ballot' % e.ballot_type.name
            e.save()


def reverse(apps, schema_editor):
    pass
    
class Migration(migrations.Migration):

    dependencies = [
        ('doc', '0030_fix_bytes_mailarch_url'),
        ('person', '0009_auto_20190118_0725'),
    ]

    operations = [
        migrations.RunPython(forward, reverse),
    ]
