# Generated by Django 2.2.16 on 2020-09-22 07:58

from django.db import migrations


def forward(apps, schema_editor):
    Document = apps.get_model('doc', 'Document')
    DocAlias = apps.get_model('doc', 'DocAlias')

    docs_without_alias = Document.objects.filter(docalias__isnull=True)

    bad_aliases = DocAlias.objects.filter(name__in=docs_without_alias.values_list('name'))
    bad_aliases.delete()

    for doc in docs_without_alias:
        DocAlias.objects.create(name=doc.name).docs.add(doc)

def reverse(apps, schema_editor):
    pass

class Migration(migrations.Migration):

    dependencies = [
        ('doc', '0036_orgs_vs_repos'),
    ]

    operations = [
        migrations.RunPython(forward, reverse),
    ]
