# Copyright The IETF Trust 2018-2020, All Rights Reserved
# -*- coding: utf-8 -*-
# Generated by Django 1.11.10 on 2018-02-20 10:52


import datetime
from django.db import migrations, models
import django.db.models.deletion
import ietf.utils.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('name', '0001_initial'),
        ('person', '0001_initial'),
        ('doc', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Group',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time', models.DateTimeField(default=datetime.datetime.now)),
                ('name', models.CharField(max_length=80)),
                ('description', models.TextField(blank=True)),
                ('list_email', models.CharField(blank=True, max_length=64)),
                ('list_subscribe', models.CharField(blank=True, max_length=255)),
                ('list_archive', models.CharField(blank=True, max_length=255)),
                ('comments', models.TextField(blank=True)),
                ('acronym', models.SlugField(max_length=40, unique=True)),
                ('charter', ietf.utils.models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='chartered_group', to='doc.Document')),
                ('parent', ietf.utils.models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='group.Group')),
                ('state', ietf.utils.models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='name.GroupStateName')),
                ('type', ietf.utils.models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='name.GroupTypeName')),
                ('unused_states', models.ManyToManyField(blank=True, help_text='Document states that have been disabled for the group.', to='doc.State')),
                ('unused_tags', models.ManyToManyField(blank=True, help_text='Document tags that have been disabled for the group.', to='name.DocTagName')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GroupEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time', models.DateTimeField(default=datetime.datetime.now, help_text='When the event happened')),
                ('type', models.CharField(choices=[('changed_state', 'Changed state'), ('added_comment', 'Added comment'), ('info_changed', 'Changed metadata'), ('requested_close', 'Requested closing group'), ('changed_milestone', 'Changed milestone'), ('sent_notification', 'Sent notification'), ('status_update', 'Status update')], max_length=50)),
                ('desc', models.TextField()),
            ],
            options={
                'ordering': ['-time', 'id'],
            },
        ),
        migrations.CreateModel(
            name='GroupHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time', models.DateTimeField(default=datetime.datetime.now)),
                ('name', models.CharField(max_length=80)),
                ('description', models.TextField(blank=True)),
                ('list_email', models.CharField(blank=True, max_length=64)),
                ('list_subscribe', models.CharField(blank=True, max_length=255)),
                ('list_archive', models.CharField(blank=True, max_length=255)),
                ('comments', models.TextField(blank=True)),
                ('acronym', models.CharField(max_length=40)),
                ('group', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='history_set', to='group.Group')),
                ('parent', ietf.utils.models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='group.Group')),
                ('state', ietf.utils.models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='name.GroupStateName')),
                ('type', ietf.utils.models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='name.GroupTypeName')),
                ('unused_states', models.ManyToManyField(blank=True, help_text='Document states that have been disabled for the group.', to='doc.State')),
                ('unused_tags', models.ManyToManyField(blank=True, help_text='Document tags that have been disabled for the group.', to='name.DocTagName')),
            ],
            options={
                'verbose_name_plural': 'group histories',
            },
        ),
        migrations.CreateModel(
            name='GroupMilestone',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('desc', models.CharField(max_length=500, verbose_name='Description')),
                ('due', models.DateField()),
                ('resolved', models.CharField(blank=True, help_text='Explanation of why milestone is resolved (usually "Done"), or empty if still due.', max_length=50)),
                ('time', models.DateTimeField(auto_now=True)),
                ('docs', models.ManyToManyField(blank=True, to='doc.Document')),
                ('group', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='group.Group')),
                ('state', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='name.GroupMilestoneStateName')),
            ],
            options={
                'ordering': ['due', 'id'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GroupMilestoneHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('desc', models.CharField(max_length=500, verbose_name='Description')),
                ('due', models.DateField()),
                ('resolved', models.CharField(blank=True, help_text='Explanation of why milestone is resolved (usually "Done"), or empty if still due.', max_length=50)),
                ('time', models.DateTimeField()),
                ('docs', models.ManyToManyField(blank=True, to='doc.Document')),
                ('group', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='group.Group')),
                ('milestone', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='history_set', to='group.GroupMilestone')),
                ('state', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='name.GroupMilestoneStateName')),
            ],
            options={
                'ordering': ['due', 'id'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GroupStateTransitions',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('group', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='group.Group')),
                ('next_states', models.ManyToManyField(related_name='previous_groupstatetransitions_states', to='doc.State')),
                ('state', ietf.utils.models.ForeignKey(help_text='State for which the next states should be overridden', on_delete=django.db.models.deletion.CASCADE, to='doc.State')),
            ],
        ),
        migrations.CreateModel(
            name='GroupURL',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('url', models.URLField()),
                ('group', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='group.Group')),
            ],
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', ietf.utils.models.ForeignKey(help_text='Email address used by person for this role.', on_delete=django.db.models.deletion.CASCADE, to='person.Email')),
                ('group', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='group.Group')),
                ('name', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='name.RoleName')),
                ('person', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='person.Person')),
            ],
            options={
                'ordering': ['name_id'],
            },
        ),
        migrations.CreateModel(
            name='RoleHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', ietf.utils.models.ForeignKey(help_text='Email address used by person for this role.', on_delete=django.db.models.deletion.CASCADE, to='person.Email')),
                ('group', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='group.GroupHistory')),
                ('name', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='name.RoleName')),
                ('person', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='person.Person')),
            ],
            options={
                'verbose_name_plural': 'role histories',
            },
        ),
        migrations.CreateModel(
            name='ChangeStateGroupEvent',
            fields=[
                ('groupevent_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='group.GroupEvent')),
                ('state', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='name.GroupStateName')),
            ],
            bases=('group.groupevent',),
        ),
        migrations.CreateModel(
            name='MilestoneGroupEvent',
            fields=[
                ('groupevent_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='group.GroupEvent')),
                ('milestone', ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='group.GroupMilestone')),
            ],
            bases=('group.groupevent',),
        ),
        migrations.AddField(
            model_name='groupevent',
            name='by',
            field=ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='person.Person'),
        ),
        migrations.AddField(
            model_name='groupevent',
            name='group',
            field=ietf.utils.models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='group.Group'),
        ),
    ]
