# Copyright The IETF Trust 2019-2020, All Rights Reserved
# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2019-01-09 09:02


from django.db import migrations

import debug                            # pyflakes:ignore

group_type_features = {
    'ag': {
        'custom_group_roles': True,
        'has_session_materials': True,
        'acts_like_wg': True,
        'create_wiki': True,
        'is_schedulable': True,
        'req_subm_approval': True,
        'show_on_agenda': True,
        'docman_roles': ['chair', 'delegate', 'secr'],
        'groupman_roles': ['ad', 'chair', 'delegate'],
        'matman_roles': ['ad', 'chair', 'delegate', 'secr'],
        'role_order': ['chair', 'secr'],
    },
    'area': {
        'custom_group_roles': True,
        'has_session_materials': False,
        'acts_like_wg': False,
        'create_wiki': True,
        'is_schedulable': False,
        'req_subm_approval': True,
        'show_on_agenda': False,
        'docman_roles': ['ad', 'delegate', 'secr'],
        'groupman_roles': ['ad',],
        'matman_roles': ['ad', 'chair', 'delegate', 'secr'],
        'role_order': ['chair', 'secr'],
        },
    'dir': {
        'custom_group_roles': True,
        'has_session_materials': False,
        'acts_like_wg': False,
        'create_wiki': True,
        'is_schedulable': False,
        'req_subm_approval': True,
        'show_on_agenda': False,
        'docman_roles': [],
        'groupman_roles': ['ad', 'secr', ],
        'matman_roles': ['ad', 'chair', 'delegate', 'secr'],
        'role_order': ['chair', 'secr'],
        },
    'review': {
        'custom_group_roles': True,
        'has_session_materials': False,
        'acts_like_wg': False,
        'create_wiki': True,
        'is_schedulable': False,
        'req_subm_approval': True,
        'show_on_agenda': False,
        'docman_roles': ['secr'],
        'groupman_roles': ['ad', 'secr'],
        'matman_roles': ['ad', 'secr'],
        'role_order': ['chair', 'secr'],
        },
    'iab': {
        'custom_group_roles': True,
        'has_session_materials': False,
        'acts_like_wg': False,
        'create_wiki': False,
        'is_schedulable': False,
        'req_subm_approval': True,
        'show_on_agenda': True,
        'docman_roles': ['chair'],
        'groupman_roles': [],
        'matman_roles': ['chair', 'delegate'],
        'role_order': ['chair', 'secr'],
        },
    'ietf': {
        'custom_group_roles': True,
        'has_session_materials': True,
        'acts_like_wg': False,
        'create_wiki': False,
        'is_schedulable': False,
        'req_subm_approval': True,
        'show_on_agenda': False,
        'docman_roles': ['chair', ],
        'groupman_roles': ['chair', 'delegate'],
        'matman_roles': ['chair', 'delegate'],
        'role_order': ['chair', 'secr'],
        },
    'individ': {
        'custom_group_roles': True,
        'has_session_materials': False,
        'acts_like_wg': False,
        'create_wiki': False,
        'is_schedulable': False,
        'req_subm_approval': False,
        'show_on_agenda': False,
        'docman_roles': ['auth'],
        'groupman_roles': [],
        'matman_roles': [],
        'role_order': ['chair', 'secr'],
        },
    'irtf': {
        'custom_group_roles': True,
        'has_session_materials': False,
        'acts_like_wg': False,
        'create_wiki': False,
        'is_schedulable': False,
        'req_subm_approval': True,
        'show_on_agenda': False,
        'docman_roles': [],
        'groupman_roles': ['chair', 'delegate'],
        'matman_roles': ['chair', 'delegate', 'secr'],
        'role_order': ['chair', 'secr'],
        },
    'isoc': {
        'custom_group_roles': True,
        'has_session_materials': False,
        'acts_like_wg': False,
        'create_wiki': False,
        'is_schedulable': False,
        'req_subm_approval': True,
        'show_on_agenda': False,
        'docman_roles': [],
        'groupman_roles': ['chair', ],
        'matman_roles': ['chair', 'secr'],
        'role_order': ['chair', 'secr'],
        },
    'nomcom': {
        'custom_group_roles': True,
        'has_session_materials': False,
        'acts_like_wg': False,
        'create_wiki': True,
        'is_schedulable': False,
        'req_subm_approval': True,
        'show_on_agenda': False,
        'docman_roles': [],
        'groupman_roles': ['chair', 'advisor'],
        'matman_roles': ['chair'],
        'role_order': ['chair', 'member', 'advisor'],
        },
    'program': {
        'custom_group_roles': True,
        'has_session_materials': False,
        'acts_like_wg': False,
        'create_wiki': False,
        'is_schedulable': False,
        'req_subm_approval': False,
        'show_on_agenda': False,
        'docman_roles': ['chair', 'secr'],
        'groupman_roles': ['chair', 'secr'],
        'matman_roles': ['chair', 'secr'],
        'role_order': ['chair', 'secr'],
        },
    'rfcedtyp': {
        'custom_group_roles': True,
        'has_session_materials': False,
        'acts_like_wg': False,
        'create_wiki': False,
        'is_schedulable': False,
        'req_subm_approval': True,
        'show_on_agenda': False,
        'docman_roles': [],
        'groupman_roles': [],
        'matman_roles': [],
        'role_order': ['chair', 'secr'],
        },
    'rg': {
        'custom_group_roles': False,
        'has_session_materials': True,
        'acts_like_wg': True,
        'create_wiki': True,
        'is_schedulable': True,
        'req_subm_approval': True,
        'show_on_agenda': True,
        'docman_roles': ['chair', 'delegate', 'secr'],
        'groupman_roles': ['chair', 'secr'],
        'matman_roles': ['chair', 'secr'],
        'role_order': ['chair', 'secr'],
        },
    'sdo': {
        'custom_group_roles': True,
        'has_session_materials': False,
        'acts_like_wg': False,
        'create_wiki': False,
        'is_schedulable': False,
        'req_subm_approval': True,
        'show_on_agenda': False,
        'docman_roles': ['liaiman', 'matman'],
        'groupman_roles': [],
        'matman_roles': [],
        'role_order': ['liaiman'],
        },
    'team': {
        'custom_group_roles': True,
        'has_session_materials': False,
        'acts_like_wg': False,
        'create_wiki': True,
        'is_schedulable': False,
        'req_subm_approval': False,
        'show_on_agenda': False,
        'docman_roles': [],
        'groupman_roles': ['chair', ],
        'matman_roles': [],
        'role_order': ['chair', 'member', 'matman'],
        },
    'wg': {
        'custom_group_roles': False,
        'has_session_materials': True,
        'acts_like_wg': True,
        'create_wiki': True,
        'is_schedulable': True,
        'req_subm_approval': True,
        'show_on_agenda': True,
        'docman_roles': ['chair', 'delegate', 'secr'],
        'groupman_roles': ['ad', 'chair', 'delegate', 'secr'],
        'matman_roles': ['ad', 'chair', 'delegate', 'secr'],
        'role_order': ['chair', 'secr', 'delegate'],
        },
}

def forward(apps, schema_editor):
    GroupFeatures = apps.get_model('group', 'GroupFeatures')
    for type in group_type_features:
        features = group_type_features[type]
        gf = GroupFeatures.objects.get(type=type)
        for k,v in features.items():
            setattr(gf, k, v)
        gf.save()
# This migration does not remove or change any previous fields, and executes
# swirftly, so we permit it to be interleaved with schema migrations
forward.interleavable = True            # type: ignore # https://github.com/python/mypy/issues/2087

def reverse(apps, schema_editor):
    pass

class Migration(migrations.Migration):

    dependencies = [
        ('group', '0006_group_features_lists_to_jsonfield')
    ]

    operations = [
        migrations.RunPython(forward, reverse),
    ]
