# Copyright The IETF Trust 2019-2020, All Rights Reserved
# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2019-03-23 17:50


from django.db import migrations

from ietf.group.models import Group 
from ietf.person.models import Person
from ietf.message.models import Message
from datetime import datetime

def forward(apps, schema_editor):

        p=Person.objects.filter(name="Jim Fenton")[0]

# Unfortunately, get_nomcom_by_year only works for 2013 and later, so we need to do things the hard way.

        n = Group.objects.filter(acronym="nomcom2002")[0]
 
        n.message_set.create(by=p, subject="nomcom call for volunteers", time=datetime(2002,7,30),
                frm="Phil Roberts <PRoberts@MEGISTO.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
This is the call for volunteers to participate in the 2002 IETF
Nominations Committee, the committee that will select this year's
nominees for the IAB and the IESG.  Details about the Nominations
Committee process can be found in RFC 2727.

The NomCom is the IETF's way of choosing its leadership. Typically,
half of the IAB and half of the IESG is selected each year. It is
possible that the NomCom will have to fill more or fewer slots than
this, due to the creation or elimination of positions by the IESG,
resignations, transfers, etc. IESG members whose terms are up are
Harald Alvestrand, IETF Chair; Scott Bradner, Transport; Randy Bush,
Operations &amp; Management; Patrik Faltstrom, Applications; Thomas Narten,
Internet; Bill Fenner, Routing; and Jeff Schiller, Security. IAB
members whose terms are up are: Ran Atkinson, Rob Austein, Fred Baker,
Steve Deering, Sally Floyd, and Geoff Huston.

For the NomCom to work as it should, the pool from which the volunteers
are chosen should be as large as possible. The more people who
volunteer, the better chance we have of choosing a random yet
representative cross section of the IETF population. Volunteering for
the NomCom is also a good way of serving the IETF community. So please
volunteer.

NomCom members are barred from nomination during the year they serve,
even if they later resign. Therefore being selected for the NomCom
provides complete immunity against selection for the IAB or IESG during
that year.

People who volunteer should be sure they can the afford the time,
several hours per week for the next 4-5 months.  The task basically
involves the following activities:

  - Reading candidate's statements
  - Participating in a weekly 2 hour conference call.
  - Attending the IETF meetings held during the selection process.
  - Doing several interviews.
  - Speaking to IETF participants about the candidates, the job
    requirements or the process.

All NomCom deliberations and supporting information that relates to
specific nominees, candidates, and confirmed candidates are
confidential. The NomCom members will be exposed to confidential
information as a result of their deliberations, their interactions with
those they consult, and from those who provide requested supporting
information. All members are expected to handle this information in a
manner consistent with its sensitivity.

To qualify as a volunteer, a person needs to have attended 2 out of the
last 3 IETF meetings.  Anyone who meets this requirement is invited to
volunteer by emailing your name, telephone number(s), and email address
to proberts@megisto.com no later than September 6, 2002.  Please put
"NOMCOM VOLUNTEER" in the subject line.

Once the list closes, I'll provide the list to the IETF secretariat who
will verify the eligibility of the each of the volunteers (e.g. has
attended at least 2 of the last 3 IETFs).  I will also ask them to
publish the list prior to verification for volunteers to confirm that I
actually received their email volunteering.  This list will be
published at: http://www.ietf.org/nomcom/index.html

We will then run the selection process and announce the results the
week of September 16, 2002. Ten (10) NomCom voting members will be
chosen from the pool of volunteers according to the procedure described
by Donald Eastlake in RFC 2777, "Publicly Verifiable Nomcom Random
Selection". The source of randomness will be based on the shares traded
number of 12 stocks selected by the NomCom chair.

The official shares traded numbers (denoted in 000s) will be drawn from
the September 16, 2002 Wall Street Journal which reports the sales
figures from the previous trading day - September 13, 2002. If trading
in any of the stocks  is suspended, then the shares traded will be
assumed to be 0.

Please volunteer.

Thank you,

Phil Roberts &lt;proberts@megisto.com&gt;

STOCKS USED IN THE NOMCOM SELECTION PROCESS:

Martha Stewart Living (MSO)
Harley-Davidson (HDI)
Motorola (MOT)
Sony (SNE)
Metlife (MET)
Home Depot (HD)
Wrigely (WWY)
Granite Construction, Inc (GVA)
UPS (UPS)
Marriott International (MAR)
Quest Diagnostics (DGX)
Nordstrom (JWN)

""")

        n.message_set.create(by=p, subject="Selection of the Nominations Committee", time=datetime(2002,9,17),
                frm="Phil Roberts <PRoberts@MEGISTO.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
STOCKS USED IN THE NOMCOM SELECTION PROCESS, published result (in 100s), 
number used as input (using 000s, rounded):

Martha Stewart Living (MSO), 1562, 156,
Harley-Davidson (HDI), 12575, 1258,
Motorola (MOT), 86406, 8641,
Sony (SNE), 4061, 406,
Metlife (MET), 26384, 2638,
Home Depot (HD), 77244, 7724,
Wrigely (WWY), 2422, 242,
Granite Construction, Inc (GVA), 2134, 213,
UPS (UPS), 25343, 2534,
Marriott International (MAR), 20820, 2082,
Quest Diagnostics (DGX), 6471, 647,
Nordstrom (JWN), 3598, 360.


Output of selection run:
------------------------

Type size of pool:
(or 'exit' to exit) 146
Type number of items to be selected:
(or 'exit' to exit) 10
Approximately 49.8 bits of entropy needed.

Type #1 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
156 
Type #2 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
1258 
Type #3 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
8641 
Type #4 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
406 
Type #5 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
2638 
Type #6 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
7724 
Type #7 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
242 
Type #8 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
213 
Type #9 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
2534 
Type #10 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
2082 
Type #11 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
647 
Type #12 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
360 
Type #13 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
Key is:
 156./1258./8641./406./2638./7724./242./213./2534./2082./647./360./
index        hex value of MD5        div  selected
 1  E220923B36A9DC02559AD9D8A2A3788E  146  -> 23 <-
 2  4DA923C4AB28A35840731A3BC7FD6FED  145  -> 75 <-
 3  C15AC23F9DDA50A178749955C7DB4C53  144  -> 86 <-
 4  CF0F40F7AD1346B3DA357793950D7E01  143  -> 47 <-
 5  1FB9FDBD56707A1B656F095A3CF0ACEF  142  -> 74 <-
 6  C530071D6CD9E5FA83AA719D28C4013A  141  -> 127 <-
 7  9E9F928E84A3BF6DE15E336C9AF0EB14  140  -> 118 <-
 8  8668415B21041948BE0EE91A69724B4C  139  -> 15 <-
 9  26338CA7ED8FB029E20B1AD0DD34BEC4  138  ->  9 <-
10  369D706DC4051ADFD4259C287E78AAE7  137  -> 140 <-

Done, type any character to exit.

----------------------------------
Nominations committee:
 23. Edward Lewis
 75. Alec Brusilovsky
 86. Michael Richardson
 47. Eva Jonsson
 74. Stephen Trowbridge
127. Frank Alfano
118. Thomas Kurien
 15. Dennis Beard
  9. Richard Draves
140. Eva Gustaffson

"""
        )

        n.message_set.create(by=p, subject="Announcement of the Nominations Committee", time=datetime(2002,9,18),
                frm="Phil Roberts <PRoberts@MEGISTO.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
We have completed selection of the 2002 
Nominations committee.

Please welcome the voting members of this 
year's Nomcom: 

Edward Lewis <edlewis@arin.net> 
Alec Brusilovsky <abrusilovsky@ieee.org> 
Michael Richardson <mcr@sandelman.ca> 
Eva Jonsson <eva.jonsson@utfors.se> 
Stephen Trowbridge <sjtrowbridge@lucent.com> 
Frank Alfano <falfano@lucent.com> 
Thomas Kurien <kurien@lucent.com> 
Dennis Beard <beardd@nortelnetworks.com> 
Richard Draves <richdr@microsoft.com> 
Eva Gustafsson <eva.gustafsson@ericsson.com.>

The non-voting members are: 

Phil Roberts <proberts@megisto.com> (chair) 
Allison Mankin <mankin@psg.com> (IETF liaison) 
Eric Rescorla <ekr@rtfm.com> (IAB liaison) 
Theodore Ts'o <tytso@mit.edu> (previous nomcom chair)

Information on this year's selection process is available at: 
<http://www.ietf.org/nomcom/select-announce.txt>
"""
        )

        n.message_set.create(by=p, subject="Announcement of IESG and IAB Nominations Requests", time=datetime(2002,10,21),
                frm="Phil Roberts <PRoberts@MEGISTO.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
The 2002-2003 Nominations Committee is now
soliciting nominations for the open
slots on the IESG and IAB. 

Please take the time, even if it is
only a few moments, to send us your
thoughts. 

Members of the community are encouraged to
nominate candidates for any of the positions
which are up for re-filling: 

IESG Terms ending in March, 2003:
Harald Alvestrand IETF Chair
Scott Bradner Transport
Randy Bush Operations & Management
Patrik Faltstrom Applications
Thomas Narten Internet
Bill Fenner Routing
Jeff Schiller Security 

IAB Terms ending in March, 2003:
Ran Atkinson
Rob Austein
Fred Baker
Steve Deering
Sally Floyd
Geoff Huston 

Members of the community are encouraged to contact the nomcom confidentially 
1) to nominate someone for any of these positions (please provide the email
address of any nominee), 
2) to provide input relating to potential candidates, or 
3) to provide comments regarding the past performance of incumbents.
All of this information will be considered during the deliberations of
the nominating committee and will be held in confidence by the nominating
committee. 

We emphasize that comments sent to the nominations committee will be kept
in confidence. As noted in RFC 2727 "all deliberations and supporting 
information that relates to specific nominees, candidates, and confirmed
candidates are confidential." 

Self-nominations are accepted. The deadline for nominations is midnight
Friday, November 22, 2002. Early input is desirable so that candidates
may be interviewed during the Atlanta IETF meeting. 

The members of the NomCom can be contacted individually at the addresses
below or collectively at <nomcom@ietf.org>. Additionally, the members of
the NomCom will be identified at the IETF by a small orange dot
on their name tags. People are encouraged to take advantage of the
opportunity to talk to the members of the NomCom about nominations
and other issues related to the IAB and IESG membership. 

The 2002-2003 Nominations Committee
Edward Lewis <edlewis@arin.net> 
Alec Brusilovsky <abrusilovsky@lucent.com> 
Michael Richardson <mcr@sandelman.ca> 
Eva Jonsson <eva.jonsson@utfors.se> 
Stephen Trowbridge <sjtrowbridge@lucent.com> 
Frank Alfano <falfano@lucent.com> 
Thomas Kurien <kurien@lucent.com> 
Dennis Beard <beardd@nortelnetworks.com> 
Richard Draves <richdr@microsoft.com> 
Eva Gustafsson <eva.gustafsson@ericsson.com> 

Non-voting members:
Phil Roberts <proberts@megito.com> (chair)
Allison Mankin <mankin@psg.com> (IESG liaison)
Eric Rescorla <ekr@rtfm.com> (IAB liaison) 
Theodore Ts'o <tytso@mit.edu> (previous nomcom chair) 

The role of non-voting members (from RFC 2727): 

"The nominations committee comprises at least a non-voting Chair,
10 voting volunteers, and 3 non-voting liaisons. The sitting IAB
and IESG members each appoint a non-voting liaison to the nominating
committee from their current membership who are not sitting in an 
open position. The Chair of the prior year's nominating committee 
also serves as a non-voting liaison.

""")

        n.message_set.create(by=p, subject="Announcement of IESG and IAB Nominations Requests", time=datetime(2002,11,0o5),
                frm="Phil Roberts <PRoberts@MEGISTO.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
The 2002-2003 Nominations Committee is now
soliciting nominations for the open
slots on the IESG and IAB.

Please take the time, even if it is
only a few moments, to send us your
thoughts.

Members of the community are encouraged to
nominate candidates for any of the positions
which are up for re-filling:

IESG Terms ending in March, 2003:
Harald Alvestrand     IETF Chair
Scott Bradner         Transport
Randy Bush            Operations & Management
Patrik Faltstrom      Applications
Thomas Narten         Internet
Bill Fenner           Routing
Jeff Schiller         Security

IAB Terms ending in March, 2003:
Ran Atkinson
Rob Austein
Fred Baker
*Steve Deering
Sally Floyd
Geoff Huston

*Please note that Steve Deering is on sabbatical and will not be a candidate
to return to the IAB.

Members of the community are encouraged to contact the nomcom confidentially 
1) to nominate someone for any of these positions (please provide the email
address of any nominee), 
2) to provide input relating to potential candidates, or 
3) to provide comments regarding the past performance of incumbents.
All of this information will be considered during the deliberations of
the nominating committee and will be held in confidence by the nominating
committee.

We emphasize that comments sent to the nominations committee will be kept
in confidence. As noted in RFC 2727 "all deliberations and supporting 
information that relates to specific nominees, candidates, and confirmed
candidates are confidential."

Self-nominations are accepted. The deadline for nominations is midnight
Friday, November 22, 2002.  Early input is desirable so that candidates
may be interviewed during the Atlanta IETF meeting.

The members of the NomCom can be contacted individually at the addresses
below or collectively at nomcom@ietf.org.  Additionally, the members of
the NomCom will be identified at the IETF by a small orange dot
on their name tags.  People are encouraged to take advantage of the
opportunity to talk to the members of the NomCom about nominations
and other issues related to the IAB and IESG membership.

The 2002-2003 Nominations Committee
Edward Lewis <edlewis@arin.net> 
Alec Brusilovsky <abrusilovsky@lucent.com> 
Michael Richardson <mcr@sandelman.ca> 
Eva Jonsson <eva.jonsson@utfors.se> 
Stephen Trowbridge <sjtrowbridge@lucent.com> 
Frank Alfano <falfano@lucent.com> 
Thomas Kurien <kurien@lucent.com> 
Dennis Beard <beardd@nortelnetworks.com> 
Richard Draves <richdr@microsoft.com> 
Eva Gustafsson <eva.gustafsson@ericsson.com>

Non-voting members:
Phil Roberts <proberts@megito.com> (chair)
Allison Mankin <mankin@psg.com> (IESG liaison)
Eric Rescorla <ekr@rtfm.com> (IAB liaison) 
Theodore Ts'o <tytso@mit.edu> (previous nomcom chair)

The role of non-voting members (from RFC 2727):

"The nominations committee comprises at least a non-voting Chair,
10 voting volunteers, and 3 non-voting liaisons.  The sitting IAB
and IESG members each appoint a non-voting liaison to the nominating
committee from their current membership who are not sitting in an 
open position.  The Chair of the prior year's nominating committee 
also serves as a non-voting liaison.
""")

        n.message_set.create(by=p, subject="Announcement of IESG and IAB Nominations Requests", time=datetime(2002,11,12),
                frm="Phil Roberts <PRoberts@MEGISTO.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
The 2002-2003 Nominations Committee is now
soliciting nominations for the open
slots on the IESG and IAB.

Please take the time, even if it is
only a few moments, to send us your
thoughts.

Members of the community are encouraged to
nominate candidates for any of the positions
which are up for re-filling:

IESG Terms ending in March, 2003:
Harald Alvestrand     IETF Chair
Scott Bradner         Transport
Randy Bush            Operations & Management
Patrik Faltstrom      Applications
Thomas Narten         Internet
Bill Fenner           Routing
Jeff Schiller         Security

IAB Terms ending in March, 2003:
Ran Atkinson
Rob Austein
Fred Baker
*Steve Deering
Sally Floyd
Geoff Huston

*Please note that Steve Deering is on sabbatical and will not be a candidate
to return to the IAB.

Members of the community are encouraged to contact the nomcom confidentially 
1) to nominate someone for any of these positions (please provide the email
address of any nominee), 
2) to provide input relating to potential candidates, or 
3) to provide comments regarding the past performance of incumbents.
All of this information will be considered during the deliberations of
the nominating committee and will be held in confidence by the nominating
committee.

We emphasize that comments sent to the nominations committee will be kept
in confidence. As noted in RFC 2727 "all deliberations and supporting 
information that relates to specific nominees, candidates, and confirmed
candidates are confidential."

Self-nominations are accepted. The deadline for nominations is midnight
Friday, November 22, 2002.  Early input is desirable so that candidates
may be interviewed during the Atlanta IETF meeting.

The members of the NomCom can be contacted individually at the addresses
below or collectively at nomcom@ietf.org.  Additionally, the members of
the NomCom will be identified at the IETF by a small orange dot
on their name tags.  People are encouraged to take advantage of the
opportunity to talk to the members of the NomCom about nominations
and other issues related to the IAB and IESG membership.

The 2002-2003 Nominations Committee
Edward Lewis <edlewis@arin.net> 
Alec Brusilovsky <abrusilovsky@lucent.com> 
Michael Richardson <mcr@sandelman.ca> 
Eva Jonsson <eva.jonsson@utfors.se> 
Stephen Trowbridge <sjtrowbridge@lucent.com> 
Frank Alfano <falfano@lucent.com> 
Thomas Kurien <kurien@lucent.com> 
Dennis Beard <beardd@nortelnetworks.com> 
Richard Draves <richdr@microsoft.com> 
Eva Gustafsson <eva.gustafsson@ericsson.com>

Non-voting members:
Phil Roberts <proberts@megito.com> (chair)
Allison Mankin <mankin@psg.com> (IESG liaison)
Eric Rescorla <ekr@rtfm.com> (IAB liaison) 
Theodore Ts'o <tytso@mit.edu> (previous nomcom chair)

The role of non-voting members (from RFC 2727):

"The nominations committee comprises at least a non-voting Chair,
10 voting volunteers, and 3 non-voting liaisons.  The sitting IAB
and IESG members each appoint a non-voting liaison to the nominating
committee from their current membership who are not sitting in an 
open position.  The Chair of the prior year's nominating committee 
also serves as a non-voting liaison.
"""
        )

        n.message_set.create(by=p, subject="IETF Nomcom Announcement", time=datetime(2003,2,27),
                frm="Phil Roberts <PRoberts@MEGISTO.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
The nomcom is pleased to announce the results of the 2002-2003
selection process.  The IAB has approved the IESG candidates and
the ISOC has approved the IAB candidates.  Please welcome them
in their roles.
 

The IESG selections are as follows:
Harald Alvestrand   IETF Chair
Ted Hardie          Applications
Thomas Narten       Internet
Randy Bush          Operations and Management
Bill Fenner         Routing
Russ Housley        Security
Jon Peterson        Transport
 
The IAB selections are as follows:
Bernard Aboba
Rob Austein
Sally Floyd
Jun-ichiro Itojun Hagino
Mark Handley
Geoff Huston
 
And also Patrik Faltstrom has been selected to fill
the vacancy left by Ted Hardie, a one year term.

Many people deserve to be thanked.  First thanks are due to
all of those who volunteered to serve on the nomcom, and especially
to those who were randomly selected and served as voting members
of the nomcom.  They contributed considerable time from their busy
schedules to participate in weekly calls, to conduct interviews, to
read questionnaires, and to make the selection of candidates.
 
Thanks to those in the community who volunteered to serve on the IESG
and the IAB, both to those who were selected and those not chosen this
time around.  Thanks very much for completing the questionnaires, the
follow-up questionnaires, and participating in interviews.
 
Thanks are also due to the IETF as a whole for providing input to the
process through nominations, recommendations, and feedback on
potential candidates.
 
The voting members of the nomcom are:
Edward Lewis
Alec Brusilovsky
Michael Richardson
Eva Jonsson
Stephen Trowbridge
Frank Alfano
Thomas Kurien
Dennis Beard
Richard Draves
Eva Gustafsson

The nonvoting members are:
Phil Roberts - chair
Allison Mankin - IESG liaison
Eric Rescorla - IAB liaison
Ted Ts'o - past chair
""")

        n.message_set.create(by=p, subject="Announcement of IESG and IAB Nominations Request", time=datetime(2003,6,11),
                frm="Phil Roberts <PRoberts@MEGISTO.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
 The nominations committee has received notice to fill the vacancy in the
 Internet Area created with Erik Nordmark's departure. The nominations
 committee is seeking nominees to fill the open position. The chosen
 candidate
 will serve out the rest of the current term, which ends in March 2004,
 and the two year term following, according to the rules documented in RFC
 2727.
   
 Members of the community are encouraged to contact the nomcom confidentially

 1) to nominate someone for this position (please provide the email
 address of any nominee), or 2) to provide input relating to potential
 candidates.
   
 All of this information will be considered during the deliberations of
 the nominating committee and will be held in confidence by the nominating
 committee.
   
 We emphasize that comments sent to the nominations committee will be kept
 in confidence. As noted in RFC 2727 "all deliberations and supporting 
 information that relates to specific nominees, candidates, and confirmed
 candidates are confidential."
   
 Self-nominations are accepted. The deadline for nominations is midnight
 Tuesday, June 17, 2003. 
   
 The members of the NomCom can be contacted individually at the addresses
 below or collectively at <nomcom@ietf.org>.
   
 The 2002-2003 Nominations Committee
 Edward Lewis <edlewis@arin.net> 
 Alec Brusilovsky <abrusilovsky@iee.org> 
 Michael Richardson <mcr@sandelman.ca> 
 Eva Jonsson <eva.jonsson@utfors.se> 
 Stephen Trowbridge <sjtrowbridge@lucent.com> 
 Frank Alfano <falfano@lucent.com> 
 Thomas Kurien <kurien@kamputech.com> 
 Dennis Beard <beardd@nortelnetworks.com>

 Richard Draves <richdr@microsoft.com> 
 Eva Gustafsson <eva.gustafsson@ericsson.com>
   
 Non-voting members:
 Phil Roberts <proberts@megito.com> (chair)
 Allison Mankin <mankin@psg.com> (IESG liaison)
 Eric Rescorla <ekr@rtfm.com> (IAB liaison) 
 Theodore Ts'o <tytso@mit.edu> (previous nomcom chair)
   
 The role of non-voting members (from RFC 2727):
   
 "The nominations committee comprises at least a non-voting Chair,
 10 voting volunteers, and 3 non-voting liaisons. The sitting IAB
 and IESG members each appoint a non-voting liaison to the nominating
 committee from their current membership who are not sitting in an 
 open position. The Chair of the prior year's nominating committee 
 also serves as a non-voting liaison.
""")

        n.message_set.create(by=p, subject="Nomcom result announcement", time=datetime(2003,7,15),
                frm="Phil Roberts <PRoberts@MEGISTO.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
 The nomcom is pleased to announce that it has selected Margaret Wasserman
 to fill the mid-term vacancy left by Erik Nordmark's resignation.
   
 Thanks are due again to many folks. First thanks are due to
 all of those who volunteered to serve on the nomcom, and especially
 to those who were randomly selected and served as voting members
 of the nomcom. They contributed considerable time from their busy
 schedules to participate in weekly calls, to conduct interviews, to
 read questionnaires, and to make the selection of candidates.
   
 Thanks to those in the community who volunteered to serve on the IESG
 and the IAB, both to those who were selected and those not chosen this
 time around. Thanks very much for completing the questionnaires, the
 follow-up questionnaires, and participating in interviews.
   
 Thanks are also due to the IETF as a whole for providing input to the
 process through nominations, recommendations, and feedback on
 potential candidates.
   
 The voting members of the nomcom are:
 Edward Lewis
 Alec Brusilovsky
 Michael Richardson
 Eva Jonsson
 Stephen Trowbridge
 Frank Alfano
 Thomas Kurien
 Dennis Beard
 Richard Draves
 Eva Gustafsson
   
 The nonvoting members are:
 Phil Roberts - chair
 Allison Mankin - IESG liaison
 Eric Rescorla - IAB liaison
 Ted Ts'o - past chair
""")

        n = Group.objects.filter(acronym="nomcom2003")[0]

        n.message_set.create(by=p, subject="IETF Nominations Committee Chair Announcement", time=datetime(2003,8,25),
                frm="Lynn St. Amour", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
 One of the roles of the ISOC President is to appoint the IETF Nominations 
Committee chair. This is done through consultation with the IETF and IAB Chairs 
as well as the ISOC Executive Committee and it gives us great pleasure to announce 
that Rich Draves has agreed to serve as the 2003 IETF Nominations Committee chair. 
Rich can be reached at <richdr@microsoft.com>.

A Call for Nominations for this committee will be sent shortly to the IETF 
Announcement list; and a list of the IESG and IAB seats to be filled will also be 
published shortly. Please give serious consideration to possible candidates for these
posts and in the interim, make your suggestions known to Rich, who will share them 
with the committee when seated.

This is an ambitious undertaking and it is important that the entire IETF community 
assist as much as possible. Thank you in advance for your support and a sincere thank
you to Rich for agreeing to take on this important responsibility.

Lynn St. Amour
President & CEO
The Internet Society
""")

        n.message_set.create(by=p, subject="NomCom call for volunteers", time=datetime(2003,9,22),
                frm="Richard Draves <richdr@microsoft.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
This is the call for volunteers to participate in the 2003 IETF Nominations Committee, 
the committee that will select this year's nominees for the IAB and the IESG.

The NomCom is the IETF's way of choosing its leadership. Typically, half of the IAB 
and half of the IESG is selected each year. It is possible that the NomCom will have 
to fill more or fewer slots than this, due to the creation or elimination of positions 
by the IESG, resignations, transfers, etc. IESG members whose terms are up are: 
Ned Freed, Applications; Bert Wijnen, Operations and Management; Alex Zinin, 
Routing; Steve Bellovin, Security; and Allison Mankin, Transport. 
IAB members whose terms are up are: Leslie Daigle, Patrik Faltstrom, 
Charlie Kaufman, James Kempf, Eric Rescorla, and Mike St. Johns.

For the NomCom to work as it should, the pool from which the volunteers are chosen 
should be as large as possible. The more people who volunteer, the better chance 
we have of choosing a random yet representative cross section of the IETF population. 
Volunteering for the NomCom is also a good way of serving the IETF community. 
So please volunteer.

NomCom members are barred from nomination during the year they serve, even if they 
later resign. Therefore being selected for the NomCom provides complete immunity against 
selection for the IAB or IESG during that year.

People who volunteer should be sure they can the afford the time, several hours per week 
for the next 4-5 months.  The task basically involves the following activities:

- Reading candidate's statements
- Participating in a weekly 2 hour conference call.
- Attending the IETF meetings held during the selection process.
- Doing several interviews.
- Speaking to IETF participants about the candidates, the job requirements, or the process.

All NomCom deliberations and supporting information that relates to specific nominees, 
candidates, and confirmed candidates are confidential. The NomCom members will be exposed 
to confidential information as a result of their deliberations, their interactions with 
those they consult, and from those who provide requested supporting information. 
All members are expected to handle this information in a manner consistent with 
its sensitivity.

Details about the Nominations Committee process can be found in RFC 2727 and 
draft-ietf-nomcom-rfc2727bis-07.txt. The 2003 NomCom will use RFC 2727 until 2727bis 
is approved as an RFC, at which time we will switch (as much as possible) to 2727bis.

To qualify as a volunteer, a person needs to have attended 2 out of the last 3 IETF meetings 
(according to RFC 2727) or 3 out of the last 5 IETF meetings (according to 2727bis). 
Anyone who meets either of these requirements is invited to volunteer by emailing your name, 
telephone number(s), and email address to richdr@microsoft.com no later than noon in Seattle 
on October 3, 2003.  Please put "NOMCOM VOLUNTEER" in the subject line.

I will check the eligibility of volunteers against both criteria and publish a up-to-date 
list of verified volunteers at http://www.ietf.org/nomcom/index.html. On October 3, 
I will decide whether to use the 2-of-3 or 3-of-5 rule, depending on whether 2727bis 
has been approved by that date. This will result in a final list of volunteers.

I will then run the selection process and announce the results on October 10, 2003. 
Ten NomCom voting members will be chosen from the pool of volunteers according to the 
procedure described by Donald Eastlake in RFC 2777, "Publicly Verifiable Nomcom Random 
Selection". The source of randomness will be based on the shares-traded number of 12 stocks 
selected by the NomCom chair.

The official shares-traded numbers (denoted in 000s) will be drawn from the October 10, 2003 
Wall Street Journal which reports the sales figures from the previous trading day - October 9,
2003. If trading in any of the stocks is suspended, then the shares traded will be assumed 
to be 0.

The NomCom voting members will start their term on October 17, after the IETF community 
has had a chance to review the random selection process.

Please volunteer.

Thank you,

Rich Draves <richdr@microsoft.com>

STOCKS USED IN THE NOMCOM SELECTION PROCESS:

Motorola (MOT)
Lucent (LU)
Nortel (NT)
Liberty (L)
Pfizer (PFE)
General Electric (GE)
Nokia (NOK)
EMC Corp (EMC)
FTI Consulting (FCN)
Citigroup (C)
Corning (GLW)
Tyco International (TYC)
""")

        n.message_set.create(by=p, subject="NomCom volunteer list", time=datetime(2003,10,6),
                frm="Richard Draves <richdr@microsoft.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
The final list of volunteers for the 2003 NomCom can be found at
http://www.ietf.org/nomcom. I would like to thank everyone who
volunteered.

I will run the selection process and announce the results on October 10,
2003. Ten NomCom voting members will be chosen from the pool of
volunteers according to the procedure described by Donald Eastlake in
RFC 2777, "Publicly Verifiable Nomcom Random Selection". The source of
randomness will be based on the shares-traded number of the 12 stocks
specified below.

At this time, 2727bis has not yet been approved as an RFC. Hence I will
use RFC 2727's eligibility criteria (attended 2 of the last 3 IETF
meetings) when performing the random selection. I will not check the
primary affiliation of the volunteers. If the RFC 2777 algorithm selects
an ineligible volunteer, I will repeat the method until I have ten
eligible and willing volunteers.

The official shares-traded numbers (denoted in 000s) will be drawn from
the October 10, 2003 Wall Street Journal which reports the sales figures
from the previous trading day - October 9, 2003. If trading in any of
the stocks is suspended, then the shares traded will be assumed to be 0.

The NomCom voting members will start their term on October 17, after the
IETF community has had a chance to review the random selection process.

Thank you,

Rich Draves <richdr@microsoft.com>

STOCKS USED IN THE NOMCOM SELECTION PROCESS:

Motorola (MOT)
Lucent (LU)
Nortel (NT)
Liberty (L)
Pfizer (PFE)
General Electric (GE)
Nokia (NOK)
EMC Corp (EMC)
FTI Consulting (FCN)
Citigroup (C)
Corning (GLW)
Tyco International (TYC)
""")

        n.message_set.create(by=p, subject="Selection of the Nominations Committee", time=datetime(2003,10,10),
                frm="Richard Draves <richdr@microsoft.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
STOCKS USED IN THE NOMCOM SELECTION PROCESS, published result (in 100s), 
number used as input (using 000s, rounded):

Motorola (MOT)                  143319  14332
Lucent (LU)                     636797  63680
Nortel (NT)                     266832  26683
Liberty (L)                     83877   8388
Pfizer (PFE)                    175698  17570
General Electric (GE)           266052  26605
Nokia (NOK)                     137837  13784
EMC Corp (EMC)                  108120  10812
FTI Consulting (FCN)            9765    977
Citigroup (C)                   145963  14596
Corning (GLW)                   116000  11600
Tyco International (TYC)        107024  10702

Output of selection run:
------------------------

Type size of pool:
(or 'exit' to exit) 114
Type number of items to be selected:
(or 'exit' to exit) 15
Approximately 61.0 bits of entropy needed.

Type #1 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
14332
14332
Type #2 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
63680
63680
Type #3 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
26683
26683
Type #4 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
8388
8388
Type #5 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
17570
17570
Type #6 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
26605
26605
Type #7 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
13784
13784
Type #8 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
10812
10812
Type #9 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
977
977
Type #10 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
14596
14596
Type #11 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
11600
11600
Type #12 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
10702
10702
Type #13 randomness or 'end' followed by new line.
Up to 16 integers or the word 'float' followed by up
to 16 x.y format reals.
end
Key is:
14332./63680./26683./8388./17570./26605./13784./10812./977./14596./11600./10702./
index        hex value of MD5        div  selected
 1  F9B4D100A3CC11E9F996D3806ACF1E29  114  -> 56 <-
 2  319E2A14967C870FC89FDA06E21CB1A5  113  -> 44 <-
 3  2F0E1E14F6659112390388D06D5DC395  112  -> 88 <-
 4  D2D99A5EA018EF669293B370BE1F841A  111  -> 57 <-
 5  53AD4E59C1E64FBA45FD2686186DD855  110  -> 114 <-
 6  BBFF136BBE4E3580424039F6DB489300  109  -> 81 <-
 7  69748D37FC816759F04F6660672050E9  108  -> 55 <-
 8  CFE98B12654474DB49F0F224FD79AE0B  107  -> 84 <-
 9  0A7ADA8D4B330BDA96CE570E9ACACF72  106  -> 100 <-
10  B67F3A637817D2391A68FD0068D09A10  105  -> 82 <-
11  84F8A3A7EEC6C0EAB68233E3144CC892  104  -> 108 <-
12  C59B0A56531A8B9A280040E5FF9CF899  103  -> 47 <-
13  FB4AD25533FA8DC99ED7113A3A388BCD  102  -> 28 <-
14  D6CD94F1E92DAFE569FF0835063E5495  101  -> 105 <-
15  6C22311D8EB6F2298EB201DFFD1AFE22  100  -> 89 <-

Done, type any character to exit.

----------------------------------
Nominations committee:
56. Kireeti Kompella <kireeti@juniper.net>
44. Abdul-jabbar Asiri <ajasiri@nortelnetworks.com>
88. Jin Seek Choi <jin@icu.ac.kr>
57. Richard Shockey <richard@shockey.us>
114. Ralph Droms <rdroms@cisco.com>
81. David E. Martin <martinde@us.ibm.com>
55. NOT ELIGIBLE
84. Dan Forsberg <dan.forsberg@nokia.com>
100. Ole J. Jacobsen <ole@cisco.com>
82. Basavaraj Patil <basavaraj.patil@nokia.com>
108. Andrew Thiessen <Andrew@its.bldrdoc.gov>
""")

        n.message_set.create(by=p, subject="NomCom Selection", time=datetime(2003,10,10),
                frm="Richard Draves <richdr@microsoft.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
Please welcome the voting members of this year's nomcom:

Kireeti Kompella <kireeti@juniper.net>
Abdul-jabbar Asiri <ajasiri@nortelnetworks.com>
Jin Seek Choi <jin@icu.ac.kr>
Richard Shockey <richard@shockey.us>
Ralph Droms <rdroms@cisco.com>
David E. Martin <martinde@us.ibm.com>
Dan Forsberg <dan.forsberg@nokia.com>
Ole J. Jacobsen <ole@cisco.com>
Basavaraj Patil <basavaraj.patil@nokia.com>
Andrew Thiessen <Andrew@its.bldrdoc.gov>

The non-voting members are: 

Rich Draves <richdr@microsoft.com> (chair)
Phil Roberts <proberts@megisto.com> (previous chair) 
Bill Fenner <fenner@research.att.com> (IESG liaison) 

The IAB has not yet selected its liaison - that should happen next week.

The ISOC has appointed Brian Carpenter <brc@zurich.ibm.com> as its
liaison. Because 2727bis has not yet been approved, following the
procedures of RFC 2727 I will propose the addition of Brian as a
liaison, subject to the nomcom's approval.

The nomcom's term will start on October 17, 2003, after the IETF
community has had a chance to review the selection process.

Information on this year's selection process is available at
http://www.ietf.org/nomcom. I used the RFC 2727 eligibility rules.

Thanks,
Rich
""")

        n.message_set.create(by=p, subject="Call for Nominees", time=datetime(2003,10,17),
                frm="Richard Draves <richdr@microsoft.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
Please send the NomCom <nomcom@ietf.org> nominations for the open IESG
and IAB positions:

IESG members whose terms are up are:
Ned Freed, Applications
Bert Wijnen, Operations and Management
Alex Zinin, Routing
Steve Bellovin, Security
Allison Mankin, Transport

IAB members whose terms are up are:
Leslie Daigle
Patrik Faltstrom 
Charlie Kaufman
James Kempf
Eric Rescorla
Mike St. Johns

The nomination period will end at noon Pacific Time on Friday November 14.

Any member of the IETF community may nominate any member of the IETF
community for any open position. Self-nominations are permitted.

Please also send the NomCom your feedback on the past performance of the
incumbents.

Thanks,
Rich
""")

        n.message_set.create(by=p, subject="NomCom members", time=datetime(2003,10,24),
                frm="Richard Draves <richdr@microsoft.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
AB has appointed Geoff Huston as its non-voting liaison to the
nomcom.

Following RFC 2727's provisions, the nomcom has voted to add Brian
Carpenter as a non-voting liaison with the ISOC board.

To recap, the nomcom voting members are:

Kireeti Kompella <kireeti@juniper.net>
Abdul-jabbar Asiri <ajasiri@nortelnetworks.com>
Jin Seek Choi <jin@icu.ac.kr>
Richard Shockey <richard@shockey.us>
Ralph Droms <rdroms@cisco.com>
David E. Martin <martinde@us.ibm.com>
Dan Forsberg <dan.forsberg@nokia.com>
Ole J. Jacobsen <ole@cisco.com>
Basavaraj Patil <basavaraj.patil@nokia.com>
Andrew Thiessen <Andrew@its.bldrdoc.gov>

The non-voting members are: 

Rich Draves <richdr@microsoft.com> (chair)
Phil Roberts <proberts@megisto.com> (previous chair) 
Bill Fenner <fenner@research.att.com> (IESG liaison) 
Geoff Huston <gih@telstra.net> (IAB liaison)
Brian Carpenter <brc@zurich.ibm.com> (ISOC liaison)

Thanks,
Rich
""")

        n.message_set.create(by=p, subject="NomCom at IETF", time=datetime(2003,11,7),
                frm="Richard Draves <richdr@microsoft.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
Members of the nomcom at IETF will be happy to chat with you in person
about what the nomcom should look for in candidates for the IESG and
IAB, specific feedback about the incumbents or potential nominees,
suggestions for nominees, etc.

Note that all such information and feedback is kept strictly
confidential within the nomcom.

You can easily spot nomcom members because we will have orange dots on
our registration badges. Also, the nomcom will be holding "office
hours." You can drop by the "Directors Row 2" room, Tuesday through
Thursday, to find someone to chat with. Or you can always send email to
nomcom@ietf.org.

Thanks,
Rich
""")

        n.message_set.create(by=p, subject="NomCom News", time=datetime(2003,11,14),
                frm="Richard Draves <richdr@microsoft.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
Randy Bush has resigned from his position as O&M Area Director. Hence,
the nomcom will be filling Randy's position in addition to the
previously announced positions.

Please submit nominations for Randy's O&M Area Director position to
nomcom@ietf.org. The deadline for these nominations is noon (Pacific
Time) on December 1.

I am extending the deadline for nominations for the other positions to
noon (Pacific Time) on November 17.

Any member of the IETF community may nominate any member of the IETF
community for any open position. Self-nominations are permitted.

Please also send the NomCom your feedback on the past performance of the
incumbents, or feedback on potential nominees.

All input to the nomcom will be kept strictly confidential.

Thanks,
Rich
""")

        n.message_set.create(by=p, subject="reminder - nominations to replace Randy Bush", time=datetime(2003,11,26),
                frm="Richard Draves <richdr@microsoft.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
At IETF Randy Bush resigned from his position as Operations & Management
Area Director for the IETF. This creates a mid-term vacancy that the
IETF NomCom needs to fill. Randy's replacement will have a one-year
term.

Please submit nominations for Randy's O&M Area Director position to
nomcom@ietf.org. The deadline for these nominations is noon (Pacific
Time) on December 1.

Any member of the IETF community may nominate any member of the IETF
community for any open position. Self-nominations are permitted.

Please also send the NomCom your feedback on the past performance of the
incumbents, feedback on potential nominees, or your thoughts on what the
NomCom should keep in mind when considering candidates.

All input to the nomcom will be kept strictly confidential.

Thanks,
Rich
""")

        n.message_set.create(by=p, subject="Randy Bush replacement schedule", time=datetime(2003,12,1),
                frm="Richard Draves <richdr@microsoft.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
For mid-term vacancies, RFC 2727 says "the selection and confirmation
process is expected to be completed within 1 month." However, there are
several factors that make a one-month schedule impractical in this
situation.

1. Some nominees for Randy's O&M AD position are also under
consideration for other positions.
2. The two O&M ADs need to have complementary skills.
3. Candidates with operational experience & relationships are rare.
4. The Thanksgiving and Christmas holiday seasons.

To have the best chance of producing a high-quality result, the NomCom
(after consulting with ISOC and the IAB as confirming body) has arrived
at the following schedule for filling Randy Bush's O&M AD position:

1. Nominations due to NomCom by Dec 1, 2003.
2. NomCom produces confidential short-list by Dec 10.
3. NomCom makes decision by Dec 22.
4. NomCom notifies IAB on Jan 5, 2004.
5. IAB confirms (or rejects) by Jan 19.

Thanks,
Rich
""")

        n.message_set.create(by=p, subject="Randy Bush replacement", time=datetime(2004,1,14),
                frm="Richard Draves <richdr@microsoft.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
I am pleased to announce that the IAB has confirmed the NomCom's
selection of David Kessens for a one-year term as O&M Area Director,
filling the mid-term vacancy left by Randy Bush's resignation.

Thanks,
Rich
""")

        n.message_set.create(by=p, subject="NomCom results", time=datetime(2004,2,13),
                frm="Richard Draves <richdr@microsoft.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
I am pleased to announce the results of the 2003-2004 NomCom selection
process. The IAB has approved the IESG candidates and the ISOC board has
approved the IAB candidates. Please welcome them in their roles:

The IESG selections are:
Scott Hollenbeck, Applications
Bert Wijnen, Operations and Management
Alex Zinin, Routing
Steve Bellovin, Security
Allison Mankin, Transport
 
The IAB selections are:
Leslie Daigle
Patrik Faltstrom
Bob Hinden
Eric Rescorla
Pete Resnick
Jonathan Rosenberg

Many people deserve to be thanked.  First thanks are due to all of those
who volunteered to serve on the NomCom, and especially to those who were
randomly selected and served as voting members of the NomCom. They
contributed considerable time from their busy schedules to participate
in weekly calls, to conduct interviews, to read questionnaires, and to
make the selection of candidates.
 
Thanks to those in the community who volunteered to serve on the IESG
and the IAB, both to those who were selected and those not chosen this
time around. Thanks very much for completing the questionnaires and
participating in interviews.
 
Thanks are also due to the IETF as a whole for providing input to the
process through nominations, recommendations, and feedback on potential
candidates.
 
The voting members of the nomcom are:
Kireeti Kompella
Abdul-jabbar Asiri
Jin Seek Choi
Richard Shockey
Ralph Droms
David Martin
Dan Forsberg
Ole Jacobsen
Basavaraj Patil
Andrew Thiessen

The nonvoting members are:
Richard Draves, chair
Phil Roberts, past chair
Bill Fenner, IESG liaison
Geoff Huston, IAB liaison
Brian Carpenter, ISOC liaison

Thanks,
Rich
""")

        n.message_set.create(by=p, subject="call for Security AD nominations", time=datetime(2004,9,28),
                frm="Richard Draves <richdr@microsoft.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
Steve Bellovin has resigned from his position as Security Area Director,
effective the end of the November IETF meeting. The IESG has asked the
2003-2004 NomCom to fill the mid-term vacancy. Steve's replacement will
serve the remainder of Steve's two-year term.

Please submit nominations for Steve's Security AD position to
nomcom03@ietf.org. The deadline for these nominations is noon (Pacific
Time) on October 11, 2004. Please include the nominee's email address or
other contact information. Feel free to comment on the nominee's
qualifications and the needs of the Security Area.

Any member of the IETF community may nominate any member of the IETF
community. Self-nominations are permitted.

Even if you do not wish to make a nomination, please send the NomCom any
input on the Security Area and/or potential nominees.

All input to the NomCom will be kept strictly confidential.

Thanks,
Rich
""")

        n.message_set.create(by=p, subject="Steve Bellovin replacement", time=datetime(2004,11,7),
                frm="Richard Draves <richdr@microsoft.com>", to="IETF Announcement list <ietf-announce@ietf.org>", body="""
I am pleased to announce that the IAB has confirmed the NomCom's
selection of Sam Hartman for a one-year term as Security Area Director,
filling the mid-term vacancy left by Steve Bellovin's resignation.

I would like to thank everyone who volunteered their time and energy
for this process, including all the candidates, the members of the
community
who provided feedback, and the members of the nomcom.

Thanks,
Rich
""")

        return
        

def reverse(apps, schema_editor):
        n = Group.objects.filter(acronym="nomcom2002")[0]

        announcements = Message.objects.filter(related_groups=n)
        announcements.delete()

        n = Group.objects.filter(acronym="nomcom2003")[0]
        announcements = Message.objects.filter(related_groups=n)
        announcements.delete()

        return


class Migration(migrations.Migration):

    dependencies = [
        ('group', '0011_auto_20190225_1302'),
    ]

    operations = [
                migrations.RunPython(forward, reverse)
    ]
