# Copyright The IETF Trust 2019-2020, All Rights Reserved
# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2019-05-10 06:48


import sys

from tqdm import tqdm

from django.db import migrations


def forward(apps, schema_editor):

    Document                    = apps.get_model('doc','Document')
    GroupMilestone              = apps.get_model('group', 'GroupMilestone')
    GroupMilestoneDocs          = apps.get_model('group', 'GroupMilestoneDocs')
    GroupMilestoneHistory       = apps.get_model('group', 'GroupMilestoneHistory')
    GroupMilestoneHistoryDocs   = apps.get_model('group', 'GroupMilestoneHistoryDocs')

    # Document id fixup ------------------------------------------------------------

    objs = Document.objects.in_bulk()
    nameid = { o.name: o.id for id, o in objs.items() }

    sys.stderr.write('\n')

    sys.stderr.write(' %s.%s:\n' % (GroupMilestone.__name__, 'docs'))
    count = 0
    for m in tqdm(GroupMilestone.objects.all()):
        for d in m.docs.all():
            count += 1
            GroupMilestoneDocs.objects.get_or_create(groupmilestone=m, document_id=nameid[d.name])
    sys.stderr.write(' %s GroupMilestoneDocs objects created\n' % (count, ))

    sys.stderr.write(' %s.%s:\n' % (GroupMilestoneHistory.__name__, 'docs'))
    count = 0
    for m in tqdm(GroupMilestoneHistory.objects.all()):
        for d in m.docs.all():
            count += 1
            GroupMilestoneHistoryDocs.objects.get_or_create(GroupMilestoneHistory=m, document_id=nameid[d.name])
    sys.stderr.write(' %s GroupMilestoneHistoryDocs objects created\n' % (count, ))


def reverse(apps, schema_editor):
    pass

class Migration(migrations.Migration):

    dependencies = [
        ('group', '0013_add_groupmilestone_docs2_m2m'),
        ('doc', '0014_set_document_docalias_id'),
    ]

    operations = [
        migrations.RunPython(forward, reverse),
    ]
