# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-05-01 12:54
from __future__ import unicode_literals

from django.db import migrations

authroles_map = {
    'adhoc': ['Secretariat'],
    'admin': ['Secretariat'],
    'ag': ['Secretariat', 'Area Director'],
    'area': ['Secretariat'],
    'dir': ['Secretariat'],
    'iab': ['Secretariat'],
    'iana': ['Secretariat'],
    'iesg': ['Secretariat'],
    'ietf': ['Secretariat'],
    'individ': [],
    'irtf': ['Secretariat'],
    'ise': ['Secretariat'],
    'isoc': ['Secretariat'],
    'nomcom': ['Secretariat'],
    'program': ['Secretariat', 'IAB'],
    'review': ['Secretariat'],
    'rfcedtyp': ['Secretariat'],
    'rg': ['Secretariat', 'IRTF Chair'],
    'sdo': ['Secretariat'],
    'team': ['Secretariat'],
    'wg': ['Secretariat', 'Area Director'],
}

def forward(apps, schema_editor):
    GroupFeatures = apps.get_model('group', 'GroupFeatures')
    for type_id, authroles in authroles_map.items():
        GroupFeatures.objects.filter(type_id=type_id).update(groupman_authroles=authroles)

def reverse(apps, schema_editor):
    pass

class Migration(migrations.Migration):

    dependencies = [
        ('group', '0024_add_groupman_authroles'),
    ]

    operations = [
        migrations.RunPython(forward, reverse),
    ]
