# Generated by Django 2.2.17 on 2020-12-11 08:52

from django.db import migrations


def forward(apps, schema_editor):
    role_names_to_add = ['liaison_contact', 'liaison_cc_contact']
    
    Group = apps.get_model('group', 'Group')
    GroupFeatures = apps.get_model('group', 'GroupFeatures')
    Role = apps.get_model('group', 'Role')
    
    # Add new liaison contact roles to default_used_fields for wg, sdo, and area groups
    for group_type in ['wg', 'sdo', 'area']:
        gf = GroupFeatures.objects.get(type_id=group_type)
        for role_name in role_names_to_add:
            if role_name not in gf.default_used_roles:
                gf.default_used_roles.append(role_name)
        gf.save()
        
        # Add new role names to any groups that both have liaison contacts
        # and use a custom used_roles list.
        for group in Group.objects.filter(type_id=group_type):
            used_roles_is_set = len(group.used_roles) > 0
            has_contacts = Role.objects.filter(name_id__in=role_names_to_add).exists()
            if used_roles_is_set and has_contacts:
                for role_name in role_names_to_add:
                    if role_name not in group.used_roles:
                        print('>> Adding %s to used_roles for %s' % (role_name, group.acronym))
                        group.used_roles.append(role_name)
                group.save()


def reverse(apps, schema_editor):
    role_names_to_remove = ['liaison_contact', 'liaison_cc_contact']
    
    Group = apps.get_model('group', 'Group')
    GroupFeatures = apps.get_model('group', 'GroupFeatures')

    for group in Group.objects.all():
        for role_name in role_names_to_remove:
            if role_name in group.used_roles:
                print('>> Removing %s from used_roles for %s' % (role_name, group.acronym))
                group.used_roles.remove(role_name)
                group.save()

    for gf in GroupFeatures.objects.all():
        for role_name in role_names_to_remove:
            if role_name in gf.default_used_roles:
                print('>> Removing %s from default_used_roles for %s' % (role_name, gf.type_id))
                gf.default_used_roles.remove(role_name)
                gf.save()


class Migration(migrations.Migration):

    dependencies = [
        ('group', '0041_create_liaison_contact_roles'),
    ]

    operations = [
        migrations.RunPython(forward, reverse),
    ]
