# Copyright The IETF Trust 2021 All Rights Reserved

# Generated by Django 2.2.24 on 2021-09-26 11:29

from django.db import migrations


default_purposes = dict(
    adhoc=['presentation'],
    adm=['closed_meeting', 'officehours'],
    ag=['regular'],
    area=['regular'],
    dir=['open_meeting', 'presentation', 'regular', 'social', 'tutorial'],
    iab=['closed_meeting', 'regular'],
    iabasg=['closed_meeting', 'officehours', 'open_meeting'],
    iana=['officehours'],
    iesg=['closed_meeting', 'open_meeting'],
    ietf=['admin', 'plenary', 'presentation', 'social'],
    irtf=[],
    ise=['officehours'],
    isoc=['officehours', 'open_meeting', 'presentation'],
    nomcom=['closed_meeting', 'officehours'],
    program=['regular', 'tutorial'],
    rag=['regular'],
    review=['open_meeting', 'social'],
    rfcedtyp=['officehours'],
    rg=['regular'],
    team=['coding', 'presentation', 'social', 'tutorial'],
    wg=['regular'],
)


def forward(apps, schema_editor):
    GroupFeatures = apps.get_model('group', 'GroupFeatures')
    SessionPurposeName = apps.get_model('name', 'SessionPurposeName')

    # verify that we're not about to use an invalid purpose
    for purposes in default_purposes.values():
        for purpose in purposes:
            SessionPurposeName.objects.get(pk=purpose)  # throws an exception unless exists

    for type_, purposes in default_purposes.items():
        GroupFeatures.objects.filter(
            type=type_
        ).update(
            session_purposes=purposes
        )

def reverse(apps, schema_editor):
    GroupFeatures = apps.get_model('group', 'GroupFeatures')
    GroupFeatures.objects.update(session_purposes=[])  # clear back out to default


class Migration(migrations.Migration):

    dependencies = [
        ('group', '0052_groupfeatures_session_purposes'),
        ('name', '0035_populate_sessionpurposename'),

    ]

    operations = [
        migrations.RunPython(forward, reverse),
    ]
