# Copyright The IETF Trust 2018-2020, All Rights Reserved
# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2018-11-02 11:34


from django.db import migrations

def forward(apps, schema_editor):
    MailTrigger = apps.get_model('mailtrigger','MailTrigger')
    Recipient = apps.get_model('mailtrigger', 'Recipient')

    Recipient.objects.create(
        slug = 'review_doc_ad',
        desc = "The reviewed document's responsible area director",
        template = '{% if review_req.doc.ad %}{{review_req.doc.ad.email_address}}{% endif %}'
    )
    Recipient.objects.create(
        slug = 'review_team_ads',
        desc = "The ADs of the team reviewing the document"
    )

    review_notify_ad = MailTrigger.objects.create(
        slug = 'review_notify_ad',
        desc = 'Recipients when a team notifies area directors when a review with one of a certain set of results (typically results indicating problem) is submitted',
    )
    review_notify_ad.to.set(Recipient.objects.filter(slug__in=['review_doc_ad','review_team_ads']))


def reverse(apps, schema_editor):
    MailTrigger = apps.get_model('mailtrigger','MailTrigger')
    Recipient = apps.get_model('mailtrigger', 'Recipient')

    MailTrigger.objects.filter(slug='review_notify_ad').delete()
    Recipient.objects.filter(slug='review_doc_ad').delete()
    Recipient.objects.filter(slug='review_team_ads').delete()

class Migration(migrations.Migration):

    dependencies = [
        ('mailtrigger', '0002_conflrev_changes'),
        ('review', '0004_reviewteamsettings_secr_mail_alias'),
    ]

    operations = [
        migrations.RunPython(forward, reverse)
    ]
