# Generated by Django 2.2.17 on 2020-11-23 09:54

from django.db import migrations


def forward(apps, schema_editor):
    """Add new MailTrigger and Recipients, remove the one being replaced"""
    MailTrigger = apps.get_model('mailtrigger', 'MailTrigger')
    Recipient = apps.get_model('mailtrigger', 'Recipient')

    MailTrigger.objects.create(
        slug='sub_director_approval_requested',
        desc='Recipients for a message requesting AD approval of a revised draft submission',
    ).to.add(
        Recipient.objects.create(
            pk='sub_group_parent_directors',
            desc="ADs for the parent group of a submission"
        )
    )

    MailTrigger.objects.create(
        slug='sub_replaced_doc_chair_approval_requested',
        desc='Recipients for a message requesting chair approval of a replaced WG document',
    ).to.add(
        Recipient.objects.get(pk='doc_group_chairs')
    )

    MailTrigger.objects.create(
        slug='sub_replaced_doc_director_approval_requested',
        desc='Recipients for a message requesting AD approval of a replaced WG document',
    ).to.add(
        Recipient.objects.create(
            pk='doc_group_parent_directors',
            desc='ADs for the parent group of a doc'
        )
    )


def reverse(apps, schema_editor):
    """Remove the MailTrigger and Recipient created in the forward migration"""
    MailTrigger = apps.get_model('mailtrigger', 'MailTrigger')
    MailTrigger.objects.filter(slug='sub_director_approval_requested').delete()
    MailTrigger.objects.filter(slug='sub_replaced_doc_chair_approval_requested').delete()
    MailTrigger.objects.filter(slug='sub_replaced_doc_director_approval_requested').delete()
    Recipient = apps.get_model('mailtrigger', 'Recipient')
    Recipient.objects.filter(pk='sub_group_parent_directors').delete()
    Recipient.objects.filter(pk='doc_group_parent_directors').delete()


class Migration(migrations.Migration):

    dependencies = [
        ('mailtrigger', '0019_email_iana_expert_review_state_changed'),
    ]

    operations = [
        migrations.RunPython(forward, reverse)
    ]
