# Generated by Django 2.2.20 on 2021-05-13 07:20

from django.db import migrations


def forward(apps, schema_editor):
    """Add new MailTrigger and Recipients"""
    MailTrigger = apps.get_model('mailtrigger', 'MailTrigger')
    Recipient = apps.get_model('mailtrigger', 'Recipient')

    mt, created = MailTrigger.objects.get_or_create(slug='doc_external_resource_change_requested')
    if created:
        mt.desc='Recipients when a change to the external resources for a document is requested.'
        mt.save()
        for recipient_slug in [
            "doc_ad",
            "doc_group_chairs",
            "doc_group_delegates",
            "doc_shepherd",
            "doc_stream_manager"
        ]:
            mt.to.add(Recipient.objects.get(slug=recipient_slug))


def reverse(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('mailtrigger', '0021_email_remind_action_holders'),
    ]

    operations = [
        migrations.RunPython(forward, reverse)
    ]
