# Autogenerated by the makeresources management command 2015-08-06 11:00 PDT
from ietf.api import ModelResource
from ietf.api import ToOneField         # pyflakes:ignore
from tastypie.fields import ToManyField  # pyflakes:ignore
from tastypie.constants import ALL, ALL_WITH_RELATIONS  # pyflakes:ignore
from tastypie.cache import SimpleCache

from ietf import api

from ietf.mailtrigger.models import Recipient, MailTrigger


class RecipientResource(ModelResource):
    class Meta:
        cache = SimpleCache()
        queryset = Recipient.objects.all()
        #resource_name = 'recipient'
        filtering = { 
            "slug": ALL,
            "desc": ALL,
            "template": ALL,
        }
api.mailtrigger.register(RecipientResource())

class MailTriggerResource(ModelResource):
    to      = ToManyField(RecipientResource, 'to', null=True)
    cc      = ToManyField(RecipientResource, 'cc', null=True)
    class Meta:
        cache = SimpleCache()
        queryset = MailTrigger.objects.all()
        #resource_name = 'mailtrigger'
        filtering = { 
            "slug": ALL,
            "desc": ALL,
            "to": ALL_WITH_RELATIONS,
            "cc": ALL_WITH_RELATIONS,
        }
api.mailtrigger.register(MailTriggerResource())

