# Copyright The IETF Trust 2019-2020, All Rights Reserved
# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2019-03-23 06:11


import datetime
from django.db import migrations


def copy_session(session):
    session.pk = None
    session.save()
    return session


def forward(apps, schema_editor):
    Meeting = apps.get_model('meeting', 'Meeting')
    today = datetime.datetime.today()
    meetings = Meeting.objects.filter(date__gt=today, type='ietf')
    for meeting in meetings:
        sessions = meeting.session_set.filter(type__in=['break', 'reg'])
        for session in sessions:
            assignments = session.timeslotassignments.filter(schedule=meeting.agenda)
            if assignments.count() > 1:
                ids = [ a.id for a in assignments ]
                first_assignment = session.timeslotassignments.get(id=ids[0])
                original_session = first_assignment.session
                for assignment in session.timeslotassignments.filter(id__in=ids[1:]):
                    assignment.session = copy_session(original_session)
                    assignment.save()

def backward(apps, schema_editor):
    return

class Migration(migrations.Migration):

    dependencies = [
        ('meeting', '0012_add_slide_submissions'),
    ]

    operations = [
        migrations.RunPython(forward, backward),
    ]
