# Copyright The IETF Trust 2019-2020, All Rights Reserved
# -*- coding: utf-8 -*-
# Generated by Django 1.11.26 on 2019-11-19 02:42


from django.db import migrations

import datetime

def create_scheduling_events(apps, schema_editor):
    Session = apps.get_model('meeting', 'Session')
    SchedulingEvent = apps.get_model('meeting', 'SchedulingEvent')
    Person = apps.get_model('person', 'Person')
    SessionStatusName = apps.get_model('name', 'SessionStatusName')

    system_person = Person.objects.get(name='(System)')
    session_status_names = { n.slug: n for n in SessionStatusName.objects.all() }

    epoch_time = datetime.datetime(1970, 1, 1, 0, 0, 0)

    for s in Session.objects.select_related('requested_by').filter(schedulingevent=None).iterator():
        # temporarily fix up weird timestamps for the migration
        if s.requested == epoch_time:
            s.requested = s.modified

        requested_event = SchedulingEvent()
        requested_event.session = s
        requested_event.time = s.requested
        requested_event.by = s.requested_by
        requested_event.status = session_status_names[s.status_id if s.status_id == 'apprw' or (s.status_id == 'notmeet' and not s.scheduled) else 'schedw']
        requested_event.save()

        scheduled_event = None
        if s.status_id != requested_event.status_id:
            if s.scheduled or s.status_id in ['sched', 'scheda']:
                scheduled_event = SchedulingEvent()
                scheduled_event.session = s
                if s.scheduled:
                    scheduled_event.time = s.scheduled
                else:
                    # we don't know when this happened
                    scheduled_event.time = s.modified
                scheduled_event.by = system_person # we don't know who did it
                scheduled_event.status = session_status_names[s.status_id if s.status_id == 'scheda' else 'sched']
                scheduled_event.save()

        final_event = None
        if s.status_id not in ['apprw', 'schedw', 'notmeet', 'sched', 'scheda']:
            final_event = SchedulingEvent()
            final_event.session = s
            final_event.time = s.modified
            final_event.by = system_person # we don't know who did it
            final_event.status = session_status_names[s.status_id]
            final_event.save()

def noop(apps, schema_editor):
    pass

class Migration(migrations.Migration):

    dependencies = [
        ('meeting', '0022_schedulingevent'),
    ]

    operations = [
        migrations.RunPython(create_scheduling_events, noop),
    ]
