# Copyright The IETF Trust 2019-2020, All Rights Reserved
# -*- coding: utf-8 -*-
# Generated by Django 1.11.26 on 2019-12-06 11:13


from django.db import migrations

def rename_session_to_regular(apps, schema_editor):
    Session = apps.get_model('meeting', 'Session')
    TimeSlot = apps.get_model('meeting', 'TimeSlot')
    Room = apps.get_model('meeting', 'Room')
    TimeSlotTypeName = apps.get_model('name', 'TimeSlotTypeName')

    TimeSlotTypeName.objects.create(
        slug='regular',
        name='Regular',
        used=True,
        order=0,
    )

    Session.objects.filter(type='session').update(type='regular')
    TimeSlot.objects.filter(type='session').update(type='regular')
    Room.session_types.through.objects.filter(timeslottypename='session').update(timeslottypename='regular')

    TimeSlotTypeName.objects.filter(slug='session').delete()

def noop(apps, schema_editor):
    pass

class Migration(migrations.Migration):

    dependencies = [
        ('meeting', '0024_auto_20191204_1731'),
    ]

    operations = [
        migrations.RunPython(rename_session_to_regular, noop),
    ]
